# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: pinpoint
using AWS.Compat
using AWS.UUIDs

"""
    create_app(create_application_request)
    create_app(create_application_request, params::Dict{String,<:Any})

 Creates an application.

# Arguments
- `create_application_request`:

"""
function create_app(
    CreateApplicationRequest; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/apps",
        Dict{String,Any}("CreateApplicationRequest" => CreateApplicationRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_app(
    CreateApplicationRequest,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CreateApplicationRequest" => CreateApplicationRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_campaign(write_campaign_request, application-id)
    create_campaign(write_campaign_request, application-id, params::Dict{String,<:Any})

Creates a new campaign for an application or updates the settings of an existing campaign
for an application.

# Arguments
- `write_campaign_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function create_campaign(
    WriteCampaignRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/campaigns",
        Dict{String,Any}("WriteCampaignRequest" => WriteCampaignRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_campaign(
    WriteCampaignRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/campaigns",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("WriteCampaignRequest" => WriteCampaignRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_email_template(email_template_request, template-name)
    create_email_template(email_template_request, template-name, params::Dict{String,<:Any})

Creates a message template for messages that are sent through the email channel.

# Arguments
- `email_template_request`:
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

"""
function create_email_template(
    EmailTemplateRequest, template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/templates/$(template-name)/email",
        Dict{String,Any}("EmailTemplateRequest" => EmailTemplateRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_email_template(
    EmailTemplateRequest,
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/templates/$(template-name)/email",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("EmailTemplateRequest" => EmailTemplateRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_export_job(export_job_request, application-id)
    create_export_job(export_job_request, application-id, params::Dict{String,<:Any})

Creates an export job for an application.

# Arguments
- `export_job_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function create_export_job(
    ExportJobRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/jobs/export",
        Dict{String,Any}("ExportJobRequest" => ExportJobRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_export_job(
    ExportJobRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/jobs/export",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ExportJobRequest" => ExportJobRequest), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_import_job(import_job_request, application-id)
    create_import_job(import_job_request, application-id, params::Dict{String,<:Any})

Creates an import job for an application.

# Arguments
- `import_job_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function create_import_job(
    ImportJobRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/jobs/import",
        Dict{String,Any}("ImportJobRequest" => ImportJobRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_import_job(
    ImportJobRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/jobs/import",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ImportJobRequest" => ImportJobRequest), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_in_app_template(in_app_template_request, template-name)
    create_in_app_template(in_app_template_request, template-name, params::Dict{String,<:Any})

Creates a new message template for messages using the in-app message channel.

# Arguments
- `in_app_template_request`:
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

"""
function create_in_app_template(
    InAppTemplateRequest, template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/templates/$(template-name)/inapp",
        Dict{String,Any}("InAppTemplateRequest" => InAppTemplateRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_in_app_template(
    InAppTemplateRequest,
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/templates/$(template-name)/inapp",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InAppTemplateRequest" => InAppTemplateRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_journey(write_journey_request, application-id)
    create_journey(write_journey_request, application-id, params::Dict{String,<:Any})

Creates a journey for an application.

# Arguments
- `write_journey_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function create_journey(
    WriteJourneyRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/journeys",
        Dict{String,Any}("WriteJourneyRequest" => WriteJourneyRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_journey(
    WriteJourneyRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/journeys",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("WriteJourneyRequest" => WriteJourneyRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_push_template(push_notification_template_request, template-name)
    create_push_template(push_notification_template_request, template-name, params::Dict{String,<:Any})

Creates a message template for messages that are sent through a push notification channel.

# Arguments
- `push_notification_template_request`:
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

"""
function create_push_template(
    PushNotificationTemplateRequest,
    template_name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/templates/$(template-name)/push",
        Dict{String,Any}(
            "PushNotificationTemplateRequest" => PushNotificationTemplateRequest
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_push_template(
    PushNotificationTemplateRequest,
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/templates/$(template-name)/push",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PushNotificationTemplateRequest" => PushNotificationTemplateRequest
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_recommender_configuration(create_recommender_configuration)
    create_recommender_configuration(create_recommender_configuration, params::Dict{String,<:Any})

Creates an Amazon Pinpoint configuration for a recommender model.

# Arguments
- `create_recommender_configuration`:

"""
function create_recommender_configuration(
    CreateRecommenderConfiguration; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/recommenders",
        Dict{String,Any}(
            "CreateRecommenderConfiguration" => CreateRecommenderConfiguration
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_recommender_configuration(
    CreateRecommenderConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/recommenders",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CreateRecommenderConfiguration" => CreateRecommenderConfiguration
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_segment(write_segment_request, application-id)
    create_segment(write_segment_request, application-id, params::Dict{String,<:Any})

Creates a new segment for an application or updates the configuration, dimension, and other
settings for an existing segment that's associated with an application.

# Arguments
- `write_segment_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function create_segment(
    WriteSegmentRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/segments",
        Dict{String,Any}("WriteSegmentRequest" => WriteSegmentRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_segment(
    WriteSegmentRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/segments",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("WriteSegmentRequest" => WriteSegmentRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_sms_template(smstemplate_request, template-name)
    create_sms_template(smstemplate_request, template-name, params::Dict{String,<:Any})

Creates a message template for messages that are sent through the SMS channel.

# Arguments
- `smstemplate_request`:
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

"""
function create_sms_template(
    SMSTemplateRequest, template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/templates/$(template-name)/sms",
        Dict{String,Any}("SMSTemplateRequest" => SMSTemplateRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_sms_template(
    SMSTemplateRequest,
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/templates/$(template-name)/sms",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SMSTemplateRequest" => SMSTemplateRequest), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_voice_template(voice_template_request, template-name)
    create_voice_template(voice_template_request, template-name, params::Dict{String,<:Any})

Creates a message template for messages that are sent through the voice channel.

# Arguments
- `voice_template_request`:
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

"""
function create_voice_template(
    VoiceTemplateRequest, template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/templates/$(template-name)/voice",
        Dict{String,Any}("VoiceTemplateRequest" => VoiceTemplateRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_voice_template(
    VoiceTemplateRequest,
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/templates/$(template-name)/voice",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("VoiceTemplateRequest" => VoiceTemplateRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_adm_channel(application-id)
    delete_adm_channel(application-id, params::Dict{String,<:Any})

Disables the ADM channel for an application and deletes any existing settings for the
channel.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function delete_adm_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/adm";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_adm_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/adm",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_apns_channel(application-id)
    delete_apns_channel(application-id, params::Dict{String,<:Any})

Disables the APNs channel for an application and deletes any existing settings for the
channel.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function delete_apns_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/apns";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_apns_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/apns",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_apns_sandbox_channel(application-id)
    delete_apns_sandbox_channel(application-id, params::Dict{String,<:Any})

Disables the APNs sandbox channel for an application and deletes any existing settings for
the channel.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function delete_apns_sandbox_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/apns_sandbox";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_apns_sandbox_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/apns_sandbox",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_apns_voip_channel(application-id)
    delete_apns_voip_channel(application-id, params::Dict{String,<:Any})

Disables the APNs VoIP channel for an application and deletes any existing settings for the
channel.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function delete_apns_voip_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/apns_voip";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_apns_voip_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/apns_voip",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_apns_voip_sandbox_channel(application-id)
    delete_apns_voip_sandbox_channel(application-id, params::Dict{String,<:Any})

Disables the APNs VoIP sandbox channel for an application and deletes any existing settings
for the channel.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function delete_apns_voip_sandbox_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/apns_voip_sandbox";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_apns_voip_sandbox_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/apns_voip_sandbox",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app(application-id)
    delete_app(application-id, params::Dict{String,<:Any})

Deletes an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function delete_app(application_id; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_baidu_channel(application-id)
    delete_baidu_channel(application-id, params::Dict{String,<:Any})

Disables the Baidu channel for an application and deletes any existing settings for the
channel.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function delete_baidu_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/baidu";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_baidu_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/baidu",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_campaign(application-id, campaign-id)
    delete_campaign(application-id, campaign-id, params::Dict{String,<:Any})

Deletes a campaign from an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `campaign-id`: The unique identifier for the campaign.

"""
function delete_campaign(
    application_id, campaign_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_campaign(
    application_id,
    campaign_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_email_channel(application-id)
    delete_email_channel(application-id, params::Dict{String,<:Any})

Disables the email channel for an application and deletes any existing settings for the
channel.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function delete_email_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/email";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_email_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/email",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_email_template(template-name)
    delete_email_template(template-name, params::Dict{String,<:Any})

Deletes a message template for messages that were sent through the email channel.

# Arguments
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function delete_email_template(
    template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/templates/$(template-name)/email";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_email_template(
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/templates/$(template-name)/email",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_endpoint(application-id, endpoint-id)
    delete_endpoint(application-id, endpoint-id, params::Dict{String,<:Any})

Deletes an endpoint from an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `endpoint-id`: The case insensitive unique identifier for the endpoint. The identifier
  can't contain , { or }.

"""
function delete_endpoint(
    application_id, endpoint_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/endpoints/$(endpoint-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_endpoint(
    application_id,
    endpoint_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/endpoints/$(endpoint-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_event_stream(application-id)
    delete_event_stream(application-id, params::Dict{String,<:Any})

Deletes the event stream for an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function delete_event_stream(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/eventstream";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_event_stream(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/eventstream",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_gcm_channel(application-id)
    delete_gcm_channel(application-id, params::Dict{String,<:Any})

Disables the GCM channel for an application and deletes any existing settings for the
channel.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function delete_gcm_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/gcm";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_gcm_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/gcm",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_in_app_template(template-name)
    delete_in_app_template(template-name, params::Dict{String,<:Any})

Deletes a message template for messages sent using the in-app message channel.

# Arguments
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function delete_in_app_template(
    template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/templates/$(template-name)/inapp";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_in_app_template(
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/templates/$(template-name)/inapp",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_journey(application-id, journey-id)
    delete_journey(application-id, journey-id, params::Dict{String,<:Any})

Deletes a journey from an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `journey-id`: The unique identifier for the journey.

"""
function delete_journey(
    application_id, journey_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/journeys/$(journey-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_journey(
    application_id,
    journey_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/journeys/$(journey-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_push_template(template-name)
    delete_push_template(template-name, params::Dict{String,<:Any})

Deletes a message template for messages that were sent through a push notification channel.

# Arguments
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function delete_push_template(
    template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/templates/$(template-name)/push";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_push_template(
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/templates/$(template-name)/push",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_recommender_configuration(recommender-id)
    delete_recommender_configuration(recommender-id, params::Dict{String,<:Any})

Deletes an Amazon Pinpoint configuration for a recommender model.

# Arguments
- `recommender-id`: The unique identifier for the recommender model configuration. This
  identifier is displayed as the Recommender ID on the Amazon Pinpoint console.

"""
function delete_recommender_configuration(
    recommender_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/recommenders/$(recommender-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_recommender_configuration(
    recommender_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/recommenders/$(recommender-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_segment(application-id, segment-id)
    delete_segment(application-id, segment-id, params::Dict{String,<:Any})

Deletes a segment from an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `segment-id`: The unique identifier for the segment.

"""
function delete_segment(
    application_id, segment_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/segments/$(segment-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_segment(
    application_id,
    segment_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/segments/$(segment-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_sms_channel(application-id)
    delete_sms_channel(application-id, params::Dict{String,<:Any})

Disables the SMS channel for an application and deletes any existing settings for the
channel.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function delete_sms_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/sms";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_sms_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/sms",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_sms_template(template-name)
    delete_sms_template(template-name, params::Dict{String,<:Any})

Deletes a message template for messages that were sent through the SMS channel.

# Arguments
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function delete_sms_template(
    template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/templates/$(template-name)/sms";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_sms_template(
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/templates/$(template-name)/sms",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user_endpoints(application-id, user-id)
    delete_user_endpoints(application-id, user-id, params::Dict{String,<:Any})

Deletes all the endpoints that are associated with a specific user ID.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `user-id`: The unique identifier for the user.

"""
function delete_user_endpoints(
    application_id, user_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/users/$(user-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user_endpoints(
    application_id,
    user_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/users/$(user-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_channel(application-id)
    delete_voice_channel(application-id, params::Dict{String,<:Any})

Disables the voice channel for an application and deletes any existing settings for the
channel.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function delete_voice_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/voice";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/apps/$(application-id)/channels/voice",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_template(template-name)
    delete_voice_template(template-name, params::Dict{String,<:Any})

Deletes a message template for messages that were sent through the voice channel.

# Arguments
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function delete_voice_template(
    template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/templates/$(template-name)/voice";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_template(
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/templates/$(template-name)/voice",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_adm_channel(application-id)
    get_adm_channel(application-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of the ADM channel for an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_adm_channel(application_id; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/adm";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_adm_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/adm",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_apns_channel(application-id)
    get_apns_channel(application-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of the APNs channel for an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_apns_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/apns";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_apns_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/apns",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_apns_sandbox_channel(application-id)
    get_apns_sandbox_channel(application-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of the APNs sandbox channel for an
application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_apns_sandbox_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/apns_sandbox";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_apns_sandbox_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/apns_sandbox",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_apns_voip_channel(application-id)
    get_apns_voip_channel(application-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of the APNs VoIP channel for an
application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_apns_voip_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/apns_voip";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_apns_voip_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/apns_voip",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_apns_voip_sandbox_channel(application-id)
    get_apns_voip_sandbox_channel(application-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of the APNs VoIP sandbox channel for an
application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_apns_voip_sandbox_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/apns_voip_sandbox";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_apns_voip_sandbox_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/apns_voip_sandbox",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_app(application-id)
    get_app(application-id, params::Dict{String,<:Any})

Retrieves information about an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_app(application_id; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_app(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_application_date_range_kpi(application-id, kpi-name)
    get_application_date_range_kpi(application-id, kpi-name, params::Dict{String,<:Any})

Retrieves (queries) pre-aggregated data for a standard metric that applies to an
application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `kpi-name`: The name of the metric, also referred to as a key performance indicator
  (KPI), to retrieve data for. This value describes the associated metric and consists of two
  or more terms, which are comprised of lowercase alphanumeric characters, separated by a
  hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid
  values, see the Amazon Pinpoint Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"end-time"`: The last date and time to retrieve data for, as part of an inclusive date
  range that filters the query results. This value should be in extended ISO 8601 format and
  use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC
  July 26, 2019.
- `"next-token"`: The  string that specifies which page of results to return in a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"start-time"`: The first date and time to retrieve data for, as part of an inclusive
  date range that filters the query results. This value should be in extended ISO 8601 format
  and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC
  July 19, 2019. This value should also be fewer than 90 days from the current day.
"""
function get_application_date_range_kpi(
    application_id, kpi_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/kpis/daterange/$(kpi-name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_application_date_range_kpi(
    application_id,
    kpi_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/kpis/daterange/$(kpi-name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_application_settings(application-id)
    get_application_settings(application-id, params::Dict{String,<:Any})

Retrieves information about the settings for an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_application_settings(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/settings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_application_settings(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/settings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_apps()
    get_apps(params::Dict{String,<:Any})

Retrieves information about all the applications that are associated with your Amazon
Pinpoint account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"token"`: The NextToken string that specifies which page of results to return in a
  paginated response.
"""
function get_apps(; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "GET", "/v1/apps"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_apps(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET", "/v1/apps", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_baidu_channel(application-id)
    get_baidu_channel(application-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of the Baidu channel for an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_baidu_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/baidu";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_baidu_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/baidu",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_campaign(application-id, campaign-id)
    get_campaign(application-id, campaign-id, params::Dict{String,<:Any})

Retrieves information about the status, configuration, and other settings for a campaign.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `campaign-id`: The unique identifier for the campaign.

"""
function get_campaign(
    application_id, campaign_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_campaign(
    application_id,
    campaign_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_campaign_activities(application-id, campaign-id)
    get_campaign_activities(application-id, campaign-id, params::Dict{String,<:Any})

Retrieves information about all the activities for a campaign.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `campaign-id`: The unique identifier for the campaign.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"token"`: The NextToken string that specifies which page of results to return in a
  paginated response.
"""
function get_campaign_activities(
    application_id, campaign_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)/activities";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_campaign_activities(
    application_id,
    campaign_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)/activities",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_campaign_date_range_kpi(application-id, campaign-id, kpi-name)
    get_campaign_date_range_kpi(application-id, campaign-id, kpi-name, params::Dict{String,<:Any})

Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `campaign-id`: The unique identifier for the campaign.
- `kpi-name`: The name of the metric, also referred to as a key performance indicator
  (KPI), to retrieve data for. This value describes the associated metric and consists of two
  or more terms, which are comprised of lowercase alphanumeric characters, separated by a
  hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid
  values, see the Amazon Pinpoint Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"end-time"`: The last date and time to retrieve data for, as part of an inclusive date
  range that filters the query results. This value should be in extended ISO 8601 format and
  use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC
  July 26, 2019.
- `"next-token"`: The  string that specifies which page of results to return in a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"start-time"`: The first date and time to retrieve data for, as part of an inclusive
  date range that filters the query results. This value should be in extended ISO 8601 format
  and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC
  July 19, 2019. This value should also be fewer than 90 days from the current day.
"""
function get_campaign_date_range_kpi(
    application_id,
    campaign_id,
    kpi_name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)/kpis/daterange/$(kpi-name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_campaign_date_range_kpi(
    application_id,
    campaign_id,
    kpi_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)/kpis/daterange/$(kpi-name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_campaign_version(application-id, campaign-id, version)
    get_campaign_version(application-id, campaign-id, version, params::Dict{String,<:Any})

Retrieves information about the status, configuration, and other settings for a specific
version of a campaign.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `campaign-id`: The unique identifier for the campaign.
- `version`: The unique version number (Version property) for the campaign version.

"""
function get_campaign_version(
    application_id, campaign_id, version; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)/versions/$(version)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_campaign_version(
    application_id,
    campaign_id,
    version,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)/versions/$(version)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_campaign_versions(application-id, campaign-id)
    get_campaign_versions(application-id, campaign-id, params::Dict{String,<:Any})

Retrieves information about the status, configuration, and other settings for all versions
of a campaign.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `campaign-id`: The unique identifier for the campaign.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"token"`: The NextToken string that specifies which page of results to return in a
  paginated response.
"""
function get_campaign_versions(
    application_id, campaign_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_campaign_versions(
    application_id,
    campaign_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_campaigns(application-id)
    get_campaigns(application-id, params::Dict{String,<:Any})

Retrieves information about the status, configuration, and other settings for all the
campaigns that are associated with an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"token"`: The NextToken string that specifies which page of results to return in a
  paginated response.
"""
function get_campaigns(application_id; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/campaigns";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_campaigns(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/campaigns",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_channels(application-id)
    get_channels(application-id, params::Dict{String,<:Any})

Retrieves information about the history and status of each channel for an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_channels(application_id; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_channels(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_email_channel(application-id)
    get_email_channel(application-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of the email channel for an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_email_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/email";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_email_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/email",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_email_template(template-name)
    get_email_template(template-name, params::Dict{String,<:Any})

Retrieves the content and settings of a message template for messages that are sent through
the email channel.

# Arguments
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function get_email_template(
    template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/templates/$(template-name)/email";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_email_template(
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/templates/$(template-name)/email",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_endpoint(application-id, endpoint-id)
    get_endpoint(application-id, endpoint-id, params::Dict{String,<:Any})

Retrieves information about the settings and attributes of a specific endpoint for an
application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `endpoint-id`: The case insensitive unique identifier for the endpoint. The identifier
  can't contain , { or }.

"""
function get_endpoint(
    application_id, endpoint_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/endpoints/$(endpoint-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_endpoint(
    application_id,
    endpoint_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/endpoints/$(endpoint-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_event_stream(application-id)
    get_event_stream(application-id, params::Dict{String,<:Any})

Retrieves information about the event stream settings for an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_event_stream(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/eventstream";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_event_stream(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/eventstream",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_export_job(application-id, job-id)
    get_export_job(application-id, job-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of a specific export job for an
application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `job-id`: The unique identifier for the job.

"""
function get_export_job(
    application_id, job_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/jobs/export/$(job-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_export_job(
    application_id,
    job_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/jobs/export/$(job-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_export_jobs(application-id)
    get_export_jobs(application-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of all the export jobs for an
application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"token"`: The NextToken string that specifies which page of results to return in a
  paginated response.
"""
function get_export_jobs(application_id; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/jobs/export";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_export_jobs(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/jobs/export",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_gcm_channel(application-id)
    get_gcm_channel(application-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of the GCM channel for an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_gcm_channel(application_id; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/gcm";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_gcm_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/gcm",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_import_job(application-id, job-id)
    get_import_job(application-id, job-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of a specific import job for an
application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `job-id`: The unique identifier for the job.

"""
function get_import_job(
    application_id, job_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/jobs/import/$(job-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_import_job(
    application_id,
    job_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/jobs/import/$(job-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_import_jobs(application-id)
    get_import_jobs(application-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of all the import jobs for an
application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"token"`: The NextToken string that specifies which page of results to return in a
  paginated response.
"""
function get_import_jobs(application_id; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/jobs/import";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_import_jobs(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/jobs/import",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_in_app_messages(application-id, endpoint-id)
    get_in_app_messages(application-id, endpoint-id, params::Dict{String,<:Any})

Retrieves the in-app messages targeted for the provided endpoint ID.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `endpoint-id`: The unique identifier for the endpoint.

"""
function get_in_app_messages(
    application_id, endpoint_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/endpoints/$(endpoint-id)/inappmessages";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_in_app_messages(
    application_id,
    endpoint_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/endpoints/$(endpoint-id)/inappmessages",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_in_app_template(template-name)
    get_in_app_template(template-name, params::Dict{String,<:Any})

Retrieves the content and settings of a message template for messages sent through the
in-app channel.

# Arguments
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function get_in_app_template(
    template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/templates/$(template-name)/inapp";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_in_app_template(
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/templates/$(template-name)/inapp",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_journey(application-id, journey-id)
    get_journey(application-id, journey-id, params::Dict{String,<:Any})

Retrieves information about the status, configuration, and other settings for a journey.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `journey-id`: The unique identifier for the journey.

"""
function get_journey(
    application_id, journey_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_journey(
    application_id,
    journey_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_journey_date_range_kpi(application-id, journey-id, kpi-name)
    get_journey_date_range_kpi(application-id, journey-id, kpi-name, params::Dict{String,<:Any})

Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a
journey.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `journey-id`: The unique identifier for the journey.
- `kpi-name`: The name of the metric, also referred to as a key performance indicator
  (KPI), to retrieve data for. This value describes the associated metric and consists of two
  or more terms, which are comprised of lowercase alphanumeric characters, separated by a
  hyphen. Examples are email-open-rate and successful-delivery-rate. For a list of valid
  values, see the Amazon Pinpoint Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"end-time"`: The last date and time to retrieve data for, as part of an inclusive date
  range that filters the query results. This value should be in extended ISO 8601 format and
  use Coordinated Universal Time (UTC), for example: 2019-07-26T20:00:00Z for 8:00 PM UTC
  July 26, 2019.
- `"next-token"`: The  string that specifies which page of results to return in a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"start-time"`: The first date and time to retrieve data for, as part of an inclusive
  date range that filters the query results. This value should be in extended ISO 8601 format
  and use Coordinated Universal Time (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC
  July 19, 2019. This value should also be fewer than 90 days from the current day.
"""
function get_journey_date_range_kpi(
    application_id, journey_id, kpi_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/kpis/daterange/$(kpi-name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_journey_date_range_kpi(
    application_id,
    journey_id,
    kpi_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/kpis/daterange/$(kpi-name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_journey_execution_activity_metrics(application-id, journey-activity-id, journey-id)
    get_journey_execution_activity_metrics(application-id, journey-activity-id, journey-id, params::Dict{String,<:Any})

Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a
journey activity.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `journey-activity-id`: The unique identifier for the journey activity.
- `journey-id`: The unique identifier for the journey.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"next-token"`: The  string that specifies which page of results to return in a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
"""
function get_journey_execution_activity_metrics(
    application_id,
    journey_activity_id,
    journey_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/activities/$(journey-activity-id)/execution-metrics";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_journey_execution_activity_metrics(
    application_id,
    journey_activity_id,
    journey_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/activities/$(journey-activity-id)/execution-metrics",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_journey_execution_metrics(application-id, journey-id)
    get_journey_execution_metrics(application-id, journey-id, params::Dict{String,<:Any})

Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a
journey.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `journey-id`: The unique identifier for the journey.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"next-token"`: The  string that specifies which page of results to return in a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
"""
function get_journey_execution_metrics(
    application_id, journey_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/execution-metrics";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_journey_execution_metrics(
    application_id,
    journey_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/execution-metrics",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_journey_run_execution_activity_metrics(application-id, journey-activity-id, journey-id, run-id)
    get_journey_run_execution_activity_metrics(application-id, journey-activity-id, journey-id, run-id, params::Dict{String,<:Any})

Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to
a journey activity.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `journey-activity-id`: The unique identifier for the journey activity.
- `journey-id`: The unique identifier for the journey.
- `run-id`: The unique identifier for the journey run.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"next-token"`: The  string that specifies which page of results to return in a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
"""
function get_journey_run_execution_activity_metrics(
    application_id,
    journey_activity_id,
    journey_id,
    run_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/runs/$(run-id)/activities/$(journey-activity-id)/execution-metrics";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_journey_run_execution_activity_metrics(
    application_id,
    journey_activity_id,
    journey_id,
    run_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/runs/$(run-id)/activities/$(journey-activity-id)/execution-metrics",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_journey_run_execution_metrics(application-id, journey-id, run-id)
    get_journey_run_execution_metrics(application-id, journey-id, run-id, params::Dict{String,<:Any})

Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to
a journey.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `journey-id`: The unique identifier for the journey.
- `run-id`: The unique identifier for the journey run.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"next-token"`: The  string that specifies which page of results to return in a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
"""
function get_journey_run_execution_metrics(
    application_id, journey_id, run_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/runs/$(run-id)/execution-metrics";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_journey_run_execution_metrics(
    application_id,
    journey_id,
    run_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/runs/$(run-id)/execution-metrics",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_journey_runs(application-id, journey-id)
    get_journey_runs(application-id, journey-id, params::Dict{String,<:Any})

Provides information about the runs of a journey.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `journey-id`: The unique identifier for the journey.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"token"`: The NextToken string that specifies which page of results to return in a
  paginated response.
"""
function get_journey_runs(
    application_id, journey_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/runs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_journey_runs(
    application_id,
    journey_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/runs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_push_template(template-name)
    get_push_template(template-name, params::Dict{String,<:Any})

Retrieves the content and settings of a message template for messages that are sent through
a push notification channel.

# Arguments
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function get_push_template(
    template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/templates/$(template-name)/push";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_push_template(
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/templates/$(template-name)/push",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_recommender_configuration(recommender-id)
    get_recommender_configuration(recommender-id, params::Dict{String,<:Any})

Retrieves information about an Amazon Pinpoint configuration for a recommender model.

# Arguments
- `recommender-id`: The unique identifier for the recommender model configuration. This
  identifier is displayed as the Recommender ID on the Amazon Pinpoint console.

"""
function get_recommender_configuration(
    recommender_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/recommenders/$(recommender-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_recommender_configuration(
    recommender_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/recommenders/$(recommender-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_recommender_configurations()
    get_recommender_configurations(params::Dict{String,<:Any})

Retrieves information about all the recommender model configurations that are associated
with your Amazon Pinpoint account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"token"`: The NextToken string that specifies which page of results to return in a
  paginated response.
"""
function get_recommender_configurations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET", "/v1/recommenders"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_recommender_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/recommenders",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_segment(application-id, segment-id)
    get_segment(application-id, segment-id, params::Dict{String,<:Any})

Retrieves information about the configuration, dimension, and other settings for a specific
segment that's associated with an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `segment-id`: The unique identifier for the segment.

"""
function get_segment(
    application_id, segment_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/segments/$(segment-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_segment(
    application_id,
    segment_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/segments/$(segment-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_segment_export_jobs(application-id, segment-id)
    get_segment_export_jobs(application-id, segment-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of the export jobs for a segment.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `segment-id`: The unique identifier for the segment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"token"`: The NextToken string that specifies which page of results to return in a
  paginated response.
"""
function get_segment_export_jobs(
    application_id, segment_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/segments/$(segment-id)/jobs/export";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_segment_export_jobs(
    application_id,
    segment_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/segments/$(segment-id)/jobs/export",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_segment_import_jobs(application-id, segment-id)
    get_segment_import_jobs(application-id, segment-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of the import jobs for a segment.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `segment-id`: The unique identifier for the segment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"token"`: The NextToken string that specifies which page of results to return in a
  paginated response.
"""
function get_segment_import_jobs(
    application_id, segment_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/segments/$(segment-id)/jobs/import";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_segment_import_jobs(
    application_id,
    segment_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/segments/$(segment-id)/jobs/import",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_segment_version(application-id, segment-id, version)
    get_segment_version(application-id, segment-id, version, params::Dict{String,<:Any})

Retrieves information about the configuration, dimension, and other settings for a specific
version of a segment that's associated with an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `segment-id`: The unique identifier for the segment.
- `version`: The unique version number (Version property) for the campaign version.

"""
function get_segment_version(
    application_id, segment_id, version; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/segments/$(segment-id)/versions/$(version)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_segment_version(
    application_id,
    segment_id,
    version,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/segments/$(segment-id)/versions/$(version)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_segment_versions(application-id, segment-id)
    get_segment_versions(application-id, segment-id, params::Dict{String,<:Any})

Retrieves information about the configuration, dimension, and other settings for all the
versions of a specific segment that's associated with an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `segment-id`: The unique identifier for the segment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"token"`: The NextToken string that specifies which page of results to return in a
  paginated response.
"""
function get_segment_versions(
    application_id, segment_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/segments/$(segment-id)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_segment_versions(
    application_id,
    segment_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/segments/$(segment-id)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_segments(application-id)
    get_segments(application-id, params::Dict{String,<:Any})

Retrieves information about the configuration, dimension, and other settings for all the
segments that are associated with an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"token"`: The NextToken string that specifies which page of results to return in a
  paginated response.
"""
function get_segments(application_id; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/segments";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_segments(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/segments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sms_channel(application-id)
    get_sms_channel(application-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of the SMS channel for an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_sms_channel(application_id; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/sms";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sms_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/sms",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sms_template(template-name)
    get_sms_template(template-name, params::Dict{String,<:Any})

Retrieves the content and settings of a message template for messages that are sent through
the SMS channel.

# Arguments
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function get_sms_template(template_name; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "GET",
        "/v1/templates/$(template-name)/sms";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sms_template(
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/templates/$(template-name)/sms",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_user_endpoints(application-id, user-id)
    get_user_endpoints(application-id, user-id, params::Dict{String,<:Any})

Retrieves information about all the endpoints that are associated with a specific user ID.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `user-id`: The unique identifier for the user.

"""
function get_user_endpoints(
    application_id, user_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/users/$(user-id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_user_endpoints(
    application_id,
    user_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/users/$(user-id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_channel(application-id)
    get_voice_channel(application-id, params::Dict{String,<:Any})

Retrieves information about the status and settings of the voice channel for an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function get_voice_channel(
    application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/voice";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_channel(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/channels/voice",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_template(template-name)
    get_voice_template(template-name, params::Dict{String,<:Any})

Retrieves the content and settings of a message template for messages that are sent through
the voice channel.

# Arguments
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function get_voice_template(
    template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/templates/$(template-name)/voice";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_template(
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/templates/$(template-name)/voice",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_journeys(application-id)
    list_journeys(application-id, params::Dict{String,<:Any})

Retrieves information about the status, configuration, and other settings for all the
journeys that are associated with an application.

# Arguments
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"token"`: The NextToken string that specifies which page of results to return in a
  paginated response.
"""
function list_journeys(application_id; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_journeys(
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/apps/$(application-id)/journeys",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource-arn)
    list_tags_for_resource(resource-arn, params::Dict{String,<:Any})

Retrieves all the tags (keys and values) that are associated with an application, campaign,
message template, or segment.

# Arguments
- `resource-arn`: The Amazon Resource Name (ARN) of the resource.

"""
function list_tags_for_resource(
    resource_arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/tags/$(resource-arn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resource_arn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/tags/$(resource-arn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_template_versions(template-name, template-type)
    list_template_versions(template-name, template-type, params::Dict{String,<:Any})

Retrieves information about all the versions of a specific message template.

# Arguments
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.
- `template-type`: The type of channel that the message template is designed for. Valid
  values are: EMAIL, PUSH, SMS, and VOICE.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"next-token"`: The  string that specifies which page of results to return in a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
"""
function list_template_versions(
    template_name, template_type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/templates/$(template-name)/$(template-type)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_template_versions(
    template_name,
    template_type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "GET",
        "/v1/templates/$(template-name)/$(template-type)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_templates()
    list_templates(params::Dict{String,<:Any})

Retrieves information about all the message templates that are associated with your Amazon
Pinpoint account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"next-token"`: The  string that specifies which page of results to return in a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"page-size"`: The maximum number of items to include in each page of a paginated
  response. This parameter is not supported for application, campaign, and journey metrics.
- `"prefix"`: The substring to match in the names of the message templates to include in
  the results. If you specify this value, Amazon Pinpoint returns only those templates whose
  names begin with the value that you specify.
- `"template-type"`: The type of message template to include in the results. Valid values
  are: EMAIL, PUSH, SMS, and VOICE. To include all types of templates in the results, don't
  include this parameter in your request.
"""
function list_templates(; aws_config::AbstractAWSConfig=current_aws_config())
    return pinpoint(
        "GET", "/v1/templates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "GET",
        "/v1/templates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    phone_number_validate(number_validate_request)
    phone_number_validate(number_validate_request, params::Dict{String,<:Any})

Retrieves information about a phone number.

# Arguments
- `number_validate_request`:

"""
function phone_number_validate(
    NumberValidateRequest; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/phone/number/validate",
        Dict{String,Any}("NumberValidateRequest" => NumberValidateRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function phone_number_validate(
    NumberValidateRequest,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/phone/number/validate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("NumberValidateRequest" => NumberValidateRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_event_stream(write_event_stream, application-id)
    put_event_stream(write_event_stream, application-id, params::Dict{String,<:Any})

Creates a new event stream for an application or updates the settings of an existing event
stream for an application.

# Arguments
- `write_event_stream`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function put_event_stream(
    WriteEventStream, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/eventstream",
        Dict{String,Any}("WriteEventStream" => WriteEventStream);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_event_stream(
    WriteEventStream,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/eventstream",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("WriteEventStream" => WriteEventStream), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_events(events_request, application-id)
    put_events(events_request, application-id, params::Dict{String,<:Any})

Creates a new event to record for endpoints, or creates or updates endpoint data that
existing events are associated with.

# Arguments
- `events_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function put_events(
    EventsRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/events",
        Dict{String,Any}("EventsRequest" => EventsRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_events(
    EventsRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/events",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EventsRequest" => EventsRequest), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_attributes(update_attributes_request, application-id, attribute-type)
    remove_attributes(update_attributes_request, application-id, attribute-type, params::Dict{String,<:Any})

Removes one or more custom attributes, of the same attribute type, from the application.
Existing endpoints still have the attributes but Amazon Pinpoint will stop capturing new or
changed values for these attributes.

# Arguments
- `update_attributes_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `attribute-type`:  The type of attribute or attributes to remove. Valid values are:
  endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date
  when an associated user opted in or out of receiving communications from you through a
  specific type of channel. endpoint-metric-attributes - Custom metrics that your app reports
  to Amazon Pinpoint for endpoints, such as the number of app sessions or the number of items
  left in a cart. endpoint-user-attributes - Custom attributes that describe users, such as
  first name, last name, and age.

"""
function remove_attributes(
    UpdateAttributesRequest,
    application_id,
    attribute_type;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/attributes/$(attribute-type)",
        Dict{String,Any}("UpdateAttributesRequest" => UpdateAttributesRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_attributes(
    UpdateAttributesRequest,
    application_id,
    attribute_type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/attributes/$(attribute-type)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UpdateAttributesRequest" => UpdateAttributesRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_messages(message_request, application-id)
    send_messages(message_request, application-id, params::Dict{String,<:Any})

Creates and sends a direct message.

# Arguments
- `message_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function send_messages(
    MessageRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/messages",
        Dict{String,Any}("MessageRequest" => MessageRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_messages(
    MessageRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/messages",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("MessageRequest" => MessageRequest), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_otpmessage(send_otpmessage_request_parameters, application-id)
    send_otpmessage(send_otpmessage_request_parameters, application-id, params::Dict{String,<:Any})

Send an OTP message

# Arguments
- `send_otpmessage_request_parameters`:
- `application-id`: The unique ID of your Amazon Pinpoint application.

"""
function send_otpmessage(
    SendOTPMessageRequestParameters,
    application_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/otp",
        Dict{String,Any}(
            "SendOTPMessageRequestParameters" => SendOTPMessageRequestParameters
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_otpmessage(
    SendOTPMessageRequestParameters,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/otp",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SendOTPMessageRequestParameters" => SendOTPMessageRequestParameters
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_users_messages(send_users_message_request, application-id)
    send_users_messages(send_users_message_request, application-id, params::Dict{String,<:Any})

Creates and sends a message to a list of users.

# Arguments
- `send_users_message_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function send_users_messages(
    SendUsersMessageRequest,
    application_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/users-messages",
        Dict{String,Any}("SendUsersMessageRequest" => SendUsersMessageRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_users_messages(
    SendUsersMessageRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/users-messages",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SendUsersMessageRequest" => SendUsersMessageRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(tags_model, resource-arn)
    tag_resource(tags_model, resource-arn, params::Dict{String,<:Any})

Adds one or more tags (keys and values) to an application, campaign, message template, or
segment.

# Arguments
- `tags_model`:
- `resource-arn`: The Amazon Resource Name (ARN) of the resource.

"""
function tag_resource(
    TagsModel, resource_arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "POST",
        "/v1/tags/$(resource-arn)",
        Dict{String,Any}("TagsModel" => TagsModel);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    TagsModel,
    resource_arn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/tags/$(resource-arn)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TagsModel" => TagsModel), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource-arn, tag_keys)
    untag_resource(resource-arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags (keys and values) from an application, campaign, message template,
or segment.

# Arguments
- `resource-arn`: The Amazon Resource Name (ARN) of the resource.
- `tag_keys`: The key of the tag to remove from the resource. To remove multiple tags,
  append the tagKeys parameter and argument for each additional tag to remove, separated by
  an ampersand (&amp;).

"""
function untag_resource(
    resource_arn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "DELETE",
        "/v1/tags/$(resource-arn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resource_arn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "DELETE",
        "/v1/tags/$(resource-arn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_adm_channel(admchannel_request, application-id)
    update_adm_channel(admchannel_request, application-id, params::Dict{String,<:Any})

Enables the ADM channel for an application or updates the status and settings of the ADM
channel for an application.

# Arguments
- `admchannel_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function update_adm_channel(
    ADMChannelRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/adm",
        Dict{String,Any}("ADMChannelRequest" => ADMChannelRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_adm_channel(
    ADMChannelRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/adm",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ADMChannelRequest" => ADMChannelRequest), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_apns_channel(apnschannel_request, application-id)
    update_apns_channel(apnschannel_request, application-id, params::Dict{String,<:Any})

Enables the APNs channel for an application or updates the status and settings of the APNs
channel for an application.

# Arguments
- `apnschannel_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function update_apns_channel(
    APNSChannelRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/apns",
        Dict{String,Any}("APNSChannelRequest" => APNSChannelRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_apns_channel(
    APNSChannelRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/apns",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("APNSChannelRequest" => APNSChannelRequest), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_apns_sandbox_channel(apnssandbox_channel_request, application-id)
    update_apns_sandbox_channel(apnssandbox_channel_request, application-id, params::Dict{String,<:Any})

Enables the APNs sandbox channel for an application or updates the status and settings of
the APNs sandbox channel for an application.

# Arguments
- `apnssandbox_channel_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function update_apns_sandbox_channel(
    APNSSandboxChannelRequest,
    application_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/apns_sandbox",
        Dict{String,Any}("APNSSandboxChannelRequest" => APNSSandboxChannelRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_apns_sandbox_channel(
    APNSSandboxChannelRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/apns_sandbox",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("APNSSandboxChannelRequest" => APNSSandboxChannelRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_apns_voip_channel(apnsvoip_channel_request, application-id)
    update_apns_voip_channel(apnsvoip_channel_request, application-id, params::Dict{String,<:Any})

Enables the APNs VoIP channel for an application or updates the status and settings of the
APNs VoIP channel for an application.

# Arguments
- `apnsvoip_channel_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function update_apns_voip_channel(
    APNSVoipChannelRequest,
    application_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/apns_voip",
        Dict{String,Any}("APNSVoipChannelRequest" => APNSVoipChannelRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_apns_voip_channel(
    APNSVoipChannelRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/apns_voip",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("APNSVoipChannelRequest" => APNSVoipChannelRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_apns_voip_sandbox_channel(apnsvoip_sandbox_channel_request, application-id)
    update_apns_voip_sandbox_channel(apnsvoip_sandbox_channel_request, application-id, params::Dict{String,<:Any})

Enables the APNs VoIP sandbox channel for an application or updates the status and settings
of the APNs VoIP sandbox channel for an application.

# Arguments
- `apnsvoip_sandbox_channel_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function update_apns_voip_sandbox_channel(
    APNSVoipSandboxChannelRequest,
    application_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/apns_voip_sandbox",
        Dict{String,Any}("APNSVoipSandboxChannelRequest" => APNSVoipSandboxChannelRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_apns_voip_sandbox_channel(
    APNSVoipSandboxChannelRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/apns_voip_sandbox",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "APNSVoipSandboxChannelRequest" => APNSVoipSandboxChannelRequest
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_application_settings(write_application_settings_request, application-id)
    update_application_settings(write_application_settings_request, application-id, params::Dict{String,<:Any})

Updates the settings for an application.

# Arguments
- `write_application_settings_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function update_application_settings(
    WriteApplicationSettingsRequest,
    application_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/settings",
        Dict{String,Any}(
            "WriteApplicationSettingsRequest" => WriteApplicationSettingsRequest
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_application_settings(
    WriteApplicationSettingsRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/settings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "WriteApplicationSettingsRequest" => WriteApplicationSettingsRequest
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_baidu_channel(baidu_channel_request, application-id)
    update_baidu_channel(baidu_channel_request, application-id, params::Dict{String,<:Any})

Enables the Baidu channel for an application or updates the status and settings of the
Baidu channel for an application.

# Arguments
- `baidu_channel_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function update_baidu_channel(
    BaiduChannelRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/baidu",
        Dict{String,Any}("BaiduChannelRequest" => BaiduChannelRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_baidu_channel(
    BaiduChannelRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/baidu",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("BaiduChannelRequest" => BaiduChannelRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_campaign(write_campaign_request, application-id, campaign-id)
    update_campaign(write_campaign_request, application-id, campaign-id, params::Dict{String,<:Any})

Updates the configuration and other settings for a campaign.

# Arguments
- `write_campaign_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `campaign-id`: The unique identifier for the campaign.

"""
function update_campaign(
    WriteCampaignRequest,
    application_id,
    campaign_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)",
        Dict{String,Any}("WriteCampaignRequest" => WriteCampaignRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_campaign(
    WriteCampaignRequest,
    application_id,
    campaign_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/campaigns/$(campaign-id)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("WriteCampaignRequest" => WriteCampaignRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_email_channel(email_channel_request, application-id)
    update_email_channel(email_channel_request, application-id, params::Dict{String,<:Any})

Enables the email channel for an application or updates the status and settings of the
email channel for an application.

# Arguments
- `email_channel_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function update_email_channel(
    EmailChannelRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/email",
        Dict{String,Any}("EmailChannelRequest" => EmailChannelRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_email_channel(
    EmailChannelRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/email",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("EmailChannelRequest" => EmailChannelRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_email_template(email_template_request, template-name)
    update_email_template(email_template_request, template-name, params::Dict{String,<:Any})

Updates an existing message template for messages that are sent through the email channel.

# Arguments
- `email_template_request`:
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"create-new-version"`: Specifies whether to save the updates as a new version of the
  message template. Valid values are: true, save the updates as a new version; and, false,
  save the updates to (overwrite) the latest existing version of the template. If you don't
  specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the
  latest existing version of the template. If you specify a value of true for this parameter,
  don't specify a value for the version parameter. Otherwise, an error will occur.
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function update_email_template(
    EmailTemplateRequest, template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "PUT",
        "/v1/templates/$(template-name)/email",
        Dict{String,Any}("EmailTemplateRequest" => EmailTemplateRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_email_template(
    EmailTemplateRequest,
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/templates/$(template-name)/email",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("EmailTemplateRequest" => EmailTemplateRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_endpoint(endpoint_request, application-id, endpoint-id)
    update_endpoint(endpoint_request, application-id, endpoint-id, params::Dict{String,<:Any})

Creates a new endpoint for an application or updates the settings and attributes of an
existing endpoint for an application. You can also use this operation to define custom
attributes for an endpoint. If an update includes one or more values for a custom
attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.

# Arguments
- `endpoint_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `endpoint-id`: The case insensitive unique identifier for the endpoint. The identifier
  can't contain , { or }.

"""
function update_endpoint(
    EndpointRequest,
    application_id,
    endpoint_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/endpoints/$(endpoint-id)",
        Dict{String,Any}("EndpointRequest" => EndpointRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_endpoint(
    EndpointRequest,
    application_id,
    endpoint_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/endpoints/$(endpoint-id)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("EndpointRequest" => EndpointRequest), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_endpoints_batch(endpoint_batch_request, application-id)
    update_endpoints_batch(endpoint_batch_request, application-id, params::Dict{String,<:Any})

Creates a new batch of endpoints for an application or updates the settings and attributes
of a batch of existing endpoints for an application. You can also use this operation to
define custom attributes for a batch of endpoints. If an update includes one or more values
for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the
new values.

# Arguments
- `endpoint_batch_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function update_endpoints_batch(
    EndpointBatchRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/endpoints",
        Dict{String,Any}("EndpointBatchRequest" => EndpointBatchRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_endpoints_batch(
    EndpointBatchRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/endpoints",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("EndpointBatchRequest" => EndpointBatchRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_gcm_channel(gcmchannel_request, application-id)
    update_gcm_channel(gcmchannel_request, application-id, params::Dict{String,<:Any})

Enables the GCM channel for an application or updates the status and settings of the GCM
channel for an application.

# Arguments
- `gcmchannel_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function update_gcm_channel(
    GCMChannelRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/gcm",
        Dict{String,Any}("GCMChannelRequest" => GCMChannelRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_gcm_channel(
    GCMChannelRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/gcm",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("GCMChannelRequest" => GCMChannelRequest), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_in_app_template(in_app_template_request, template-name)
    update_in_app_template(in_app_template_request, template-name, params::Dict{String,<:Any})

Updates an existing message template for messages sent through the in-app message channel.

# Arguments
- `in_app_template_request`:
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"create-new-version"`: Specifies whether to save the updates as a new version of the
  message template. Valid values are: true, save the updates as a new version; and, false,
  save the updates to (overwrite) the latest existing version of the template. If you don't
  specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the
  latest existing version of the template. If you specify a value of true for this parameter,
  don't specify a value for the version parameter. Otherwise, an error will occur.
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function update_in_app_template(
    InAppTemplateRequest, template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "PUT",
        "/v1/templates/$(template-name)/inapp",
        Dict{String,Any}("InAppTemplateRequest" => InAppTemplateRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_in_app_template(
    InAppTemplateRequest,
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/templates/$(template-name)/inapp",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InAppTemplateRequest" => InAppTemplateRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_journey(write_journey_request, application-id, journey-id)
    update_journey(write_journey_request, application-id, journey-id, params::Dict{String,<:Any})

Updates the configuration and other settings for a journey.

# Arguments
- `write_journey_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `journey-id`: The unique identifier for the journey.

"""
function update_journey(
    WriteJourneyRequest,
    application_id,
    journey_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/journeys/$(journey-id)",
        Dict{String,Any}("WriteJourneyRequest" => WriteJourneyRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_journey(
    WriteJourneyRequest,
    application_id,
    journey_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/journeys/$(journey-id)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("WriteJourneyRequest" => WriteJourneyRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_journey_state(journey_state_request, application-id, journey-id)
    update_journey_state(journey_state_request, application-id, journey-id, params::Dict{String,<:Any})

Cancels (stops) an active journey.

# Arguments
- `journey_state_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `journey-id`: The unique identifier for the journey.

"""
function update_journey_state(
    JourneyStateRequest,
    application_id,
    journey_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/state",
        Dict{String,Any}("JourneyStateRequest" => JourneyStateRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_journey_state(
    JourneyStateRequest,
    application_id,
    journey_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/journeys/$(journey-id)/state",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("JourneyStateRequest" => JourneyStateRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_push_template(push_notification_template_request, template-name)
    update_push_template(push_notification_template_request, template-name, params::Dict{String,<:Any})

Updates an existing message template for messages that are sent through a push notification
channel.

# Arguments
- `push_notification_template_request`:
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"create-new-version"`: Specifies whether to save the updates as a new version of the
  message template. Valid values are: true, save the updates as a new version; and, false,
  save the updates to (overwrite) the latest existing version of the template. If you don't
  specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the
  latest existing version of the template. If you specify a value of true for this parameter,
  don't specify a value for the version parameter. Otherwise, an error will occur.
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function update_push_template(
    PushNotificationTemplateRequest,
    template_name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/templates/$(template-name)/push",
        Dict{String,Any}(
            "PushNotificationTemplateRequest" => PushNotificationTemplateRequest
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_push_template(
    PushNotificationTemplateRequest,
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/templates/$(template-name)/push",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PushNotificationTemplateRequest" => PushNotificationTemplateRequest
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_recommender_configuration(update_recommender_configuration, recommender-id)
    update_recommender_configuration(update_recommender_configuration, recommender-id, params::Dict{String,<:Any})

Updates an Amazon Pinpoint configuration for a recommender model.

# Arguments
- `update_recommender_configuration`:
- `recommender-id`: The unique identifier for the recommender model configuration. This
  identifier is displayed as the Recommender ID on the Amazon Pinpoint console.

"""
function update_recommender_configuration(
    UpdateRecommenderConfiguration,
    recommender_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/recommenders/$(recommender-id)",
        Dict{String,Any}(
            "UpdateRecommenderConfiguration" => UpdateRecommenderConfiguration
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_recommender_configuration(
    UpdateRecommenderConfiguration,
    recommender_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/recommenders/$(recommender-id)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "UpdateRecommenderConfiguration" => UpdateRecommenderConfiguration
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_segment(write_segment_request, application-id, segment-id)
    update_segment(write_segment_request, application-id, segment-id, params::Dict{String,<:Any})

Creates a new segment for an application or updates the configuration, dimension, and other
settings for an existing segment that's associated with an application.

# Arguments
- `write_segment_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.
- `segment-id`: The unique identifier for the segment.

"""
function update_segment(
    WriteSegmentRequest,
    application_id,
    segment_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/segments/$(segment-id)",
        Dict{String,Any}("WriteSegmentRequest" => WriteSegmentRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_segment(
    WriteSegmentRequest,
    application_id,
    segment_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/segments/$(segment-id)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("WriteSegmentRequest" => WriteSegmentRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sms_channel(smschannel_request, application-id)
    update_sms_channel(smschannel_request, application-id, params::Dict{String,<:Any})

Enables the SMS channel for an application or updates the status and settings of the SMS
channel for an application.

# Arguments
- `smschannel_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function update_sms_channel(
    SMSChannelRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/sms",
        Dict{String,Any}("SMSChannelRequest" => SMSChannelRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sms_channel(
    SMSChannelRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/sms",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SMSChannelRequest" => SMSChannelRequest), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sms_template(smstemplate_request, template-name)
    update_sms_template(smstemplate_request, template-name, params::Dict{String,<:Any})

Updates an existing message template for messages that are sent through the SMS channel.

# Arguments
- `smstemplate_request`:
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"create-new-version"`: Specifies whether to save the updates as a new version of the
  message template. Valid values are: true, save the updates as a new version; and, false,
  save the updates to (overwrite) the latest existing version of the template. If you don't
  specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the
  latest existing version of the template. If you specify a value of true for this parameter,
  don't specify a value for the version parameter. Otherwise, an error will occur.
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function update_sms_template(
    SMSTemplateRequest, template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "PUT",
        "/v1/templates/$(template-name)/sms",
        Dict{String,Any}("SMSTemplateRequest" => SMSTemplateRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sms_template(
    SMSTemplateRequest,
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/templates/$(template-name)/sms",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SMSTemplateRequest" => SMSTemplateRequest), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_template_active_version(template_active_version_request, template-name, template-type)
    update_template_active_version(template_active_version_request, template-name, template-type, params::Dict{String,<:Any})

Changes the status of a specific version of a message template to active.

# Arguments
- `template_active_version_request`:
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.
- `template-type`: The type of channel that the message template is designed for. Valid
  values are: EMAIL, PUSH, SMS, and VOICE.

"""
function update_template_active_version(
    TemplateActiveVersionRequest,
    template_name,
    template_type;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/templates/$(template-name)/$(template-type)/active-version",
        Dict{String,Any}("TemplateActiveVersionRequest" => TemplateActiveVersionRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_template_active_version(
    TemplateActiveVersionRequest,
    template_name,
    template_type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/templates/$(template-name)/$(template-type)/active-version",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TemplateActiveVersionRequest" => TemplateActiveVersionRequest
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_voice_channel(voice_channel_request, application-id)
    update_voice_channel(voice_channel_request, application-id, params::Dict{String,<:Any})

Enables the voice channel for an application or updates the status and settings of the
voice channel for an application.

# Arguments
- `voice_channel_request`:
- `application-id`: The unique identifier for the application. This identifier is displayed
  as the Project ID on the Amazon Pinpoint console.

"""
function update_voice_channel(
    VoiceChannelRequest, application_id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/voice",
        Dict{String,Any}("VoiceChannelRequest" => VoiceChannelRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_voice_channel(
    VoiceChannelRequest,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/apps/$(application-id)/channels/voice",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("VoiceChannelRequest" => VoiceChannelRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_voice_template(voice_template_request, template-name)
    update_voice_template(voice_template_request, template-name, params::Dict{String,<:Any})

Updates an existing message template for messages that are sent through the voice channel.

# Arguments
- `voice_template_request`:
- `template-name`: The name of the message template. A template name must start with an
  alphanumeric character and can contain a maximum of 128 characters. The characters can be
  alphanumeric characters, underscores (_), or hyphens (-). Template names are case sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"create-new-version"`: Specifies whether to save the updates as a new version of the
  message template. Valid values are: true, save the updates as a new version; and, false,
  save the updates to (overwrite) the latest existing version of the template. If you don't
  specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the
  latest existing version of the template. If you specify a value of true for this parameter,
  don't specify a value for the version parameter. Otherwise, an error will occur.
- `"version"`: The unique identifier for the version of the message template to update,
  retrieve information about, or delete. To retrieve identifiers and other information for
  all the versions of a template, use the Template Versions resource. If specified, this
  value must match the identifier for an existing template version. If specified for an
  update operation, this value must match the identifier for the latest existing version of
  the template. This restriction helps ensure that race conditions don't occur. If you don't
  specify a value for this parameter, Amazon Pinpoint does the following: For a get
  operation, retrieves information about the active version of the template. For an update
  operation, saves the updates to (overwrites) the latest existing version of the template,
  if the create-new-version parameter isn't used or is set to false. For a delete operation,
  deletes the template, including all versions of the template.
"""
function update_voice_template(
    VoiceTemplateRequest, template_name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return pinpoint(
        "PUT",
        "/v1/templates/$(template-name)/voice",
        Dict{String,Any}("VoiceTemplateRequest" => VoiceTemplateRequest);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_voice_template(
    VoiceTemplateRequest,
    template_name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "PUT",
        "/v1/templates/$(template-name)/voice",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("VoiceTemplateRequest" => VoiceTemplateRequest),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    verify_otpmessage(verify_otpmessage_request_parameters, application-id)
    verify_otpmessage(verify_otpmessage_request_parameters, application-id, params::Dict{String,<:Any})

Verify an OTP

# Arguments
- `verify_otpmessage_request_parameters`:
- `application-id`: The unique ID of your Amazon Pinpoint application.

"""
function verify_otpmessage(
    VerifyOTPMessageRequestParameters,
    application_id;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/verify-otp",
        Dict{String,Any}(
            "VerifyOTPMessageRequestParameters" => VerifyOTPMessageRequestParameters
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function verify_otpmessage(
    VerifyOTPMessageRequestParameters,
    application_id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return pinpoint(
        "POST",
        "/v1/apps/$(application-id)/verify-otp",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "VerifyOTPMessageRequestParameters" => VerifyOTPMessageRequestParameters
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
