# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: privatenetworks
using AWS.Compat
using AWS.UUIDs

"""
    acknowledge_order_receipt(order_arn)
    acknowledge_order_receipt(order_arn, params::Dict{String,<:Any})

Acknowledges that the specified network order was received.

# Arguments
- `order_arn`: The Amazon Resource Name (ARN) of the order.

"""
function acknowledge_order_receipt(
    orderArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "POST",
        "/v1/orders/acknowledge",
        Dict{String,Any}("orderArn" => orderArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function acknowledge_order_receipt(
    orderArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "POST",
        "/v1/orders/acknowledge",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("orderArn" => orderArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    activate_device_identifier(device_identifier_arn)
    activate_device_identifier(device_identifier_arn, params::Dict{String,<:Any})

Activates the specified device identifier.

# Arguments
- `device_identifier_arn`: The Amazon Resource Name (ARN) of the device identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
"""
function activate_device_identifier(
    deviceIdentifierArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "POST",
        "/v1/device-identifiers/activate",
        Dict{String,Any}("deviceIdentifierArn" => deviceIdentifierArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function activate_device_identifier(
    deviceIdentifierArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "POST",
        "/v1/device-identifiers/activate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("deviceIdentifierArn" => deviceIdentifierArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    activate_network_site(network_site_arn, shipping_address)
    activate_network_site(network_site_arn, shipping_address, params::Dict{String,<:Any})

Activates the specified network site.

# Arguments
- `network_site_arn`: The Amazon Resource Name (ARN) of the network site.
- `shipping_address`: The shipping address of the network site.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `"commitmentConfiguration"`: Determines the duration and renewal status of the commitment
  period for all pending radio units. If you include commitmentConfiguration in the
  ActivateNetworkSiteRequest action, you must specify the following:   The commitment period
  for the radio unit. You can choose a 60-day, 1-year, or 3-year period.   Whether you want
  your commitment period to automatically renew for one more year after your current
  commitment period expires.   For pricing, see Amazon Web Services Private 5G Pricing. If
  you do not include commitmentConfiguration in the ActivateNetworkSiteRequest action, the
  commitment period is set to 60-days.
"""
function activate_network_site(
    networkSiteArn, shippingAddress; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "POST",
        "/v1/network-sites/activate",
        Dict{String,Any}(
            "networkSiteArn" => networkSiteArn, "shippingAddress" => shippingAddress
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function activate_network_site(
    networkSiteArn,
    shippingAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "POST",
        "/v1/network-sites/activate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "networkSiteArn" => networkSiteArn, "shippingAddress" => shippingAddress
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    configure_access_point(access_point_arn)
    configure_access_point(access_point_arn, params::Dict{String,<:Any})

Configures the specified network resource.   Use this action to specify the geographic
position of the hardware. You must provide Certified Professional Installer (CPI)
credentials in the request so that we can obtain spectrum grants. For more information, see
Radio units in the Amazon Web Services Private 5G User Guide.

# Arguments
- `access_point_arn`: The Amazon Resource Name (ARN) of the network resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"cpiSecretKey"`: A Base64 encoded string of the CPI certificate associated with the CPI
  user who is certifying the coordinates of the network resource.
- `"cpiUserId"`: The CPI user ID of the CPI user who is certifying the coordinates of the
  network resource.
- `"cpiUserPassword"`: The CPI password associated with the CPI certificate in cpiSecretKey.
- `"cpiUsername"`: The CPI user name of the CPI user who is certifying the coordinates of
  the radio unit.
- `"position"`: The position of the network resource.
"""
function configure_access_point(
    accessPointArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "POST",
        "/v1/network-resources/configure",
        Dict{String,Any}("accessPointArn" => accessPointArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function configure_access_point(
    accessPointArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "POST",
        "/v1/network-resources/configure",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("accessPointArn" => accessPointArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_network(network_name)
    create_network(network_name, params::Dict{String,<:Any})

Creates a network.

# Arguments
- `network_name`: The name of the network. You can't change the name after you create the
  network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `"description"`: The description of the network.
- `"tags"`:  The tags to apply to the network.
"""
function create_network(networkName; aws_config::AbstractAWSConfig=current_aws_config())
    return privatenetworks(
        "POST",
        "/v1/networks",
        Dict{String,Any}("networkName" => networkName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_network(
    networkName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "POST",
        "/v1/networks",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("networkName" => networkName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_network_site(network_arn, network_site_name)
    create_network_site(network_arn, network_site_name, params::Dict{String,<:Any})

Creates a network site.

# Arguments
- `network_arn`: The Amazon Resource Name (ARN) of the network.
- `network_site_name`: The name of the site. You can't change the name after you create the
  site.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"availabilityZone"`: The Availability Zone that is the parent of this site. You can't
  change the Availability Zone after you create the site.
- `"availabilityZoneId"`: The ID of the Availability Zone that is the parent of this site.
  You can't change the Availability Zone after you create the site.
- `"clientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `"description"`: The description of the site.
- `"pendingPlan"`: Information about the pending plan for this site.
- `"tags"`:  The tags to apply to the network site.
"""
function create_network_site(
    networkArn, networkSiteName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "POST",
        "/v1/network-sites",
        Dict{String,Any}("networkArn" => networkArn, "networkSiteName" => networkSiteName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_network_site(
    networkArn,
    networkSiteName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "POST",
        "/v1/network-sites",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "networkArn" => networkArn, "networkSiteName" => networkSiteName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deactivate_device_identifier(device_identifier_arn)
    deactivate_device_identifier(device_identifier_arn, params::Dict{String,<:Any})

Deactivates the specified device identifier.

# Arguments
- `device_identifier_arn`: The Amazon Resource Name (ARN) of the device identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
"""
function deactivate_device_identifier(
    deviceIdentifierArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "POST",
        "/v1/device-identifiers/deactivate",
        Dict{String,Any}("deviceIdentifierArn" => deviceIdentifierArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deactivate_device_identifier(
    deviceIdentifierArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "POST",
        "/v1/device-identifiers/deactivate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("deviceIdentifierArn" => deviceIdentifierArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_network(network_arn)
    delete_network(network_arn, params::Dict{String,<:Any})

Deletes the specified network. You must delete network sites before you delete the network.
For more information, see DeleteNetworkSite in the API Reference for Amazon Web Services
Private 5G.

# Arguments
- `network_arn`: The Amazon Resource Name (ARN) of the network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
"""
function delete_network(networkArn; aws_config::AbstractAWSConfig=current_aws_config())
    return privatenetworks(
        "DELETE",
        "/v1/networks/$(networkArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_network(
    networkArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "DELETE",
        "/v1/networks/$(networkArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_network_site(network_site_arn)
    delete_network_site(network_site_arn, params::Dict{String,<:Any})

Deletes the specified network site. Return the hardware after you delete the network site.
You are responsible for minimum charges. For more information, see Hardware returns in the
Amazon Web Services Private 5G User Guide.

# Arguments
- `network_site_arn`: The Amazon Resource Name (ARN) of the network site.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
"""
function delete_network_site(
    networkSiteArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "DELETE",
        "/v1/network-sites/$(networkSiteArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_network_site(
    networkSiteArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "DELETE",
        "/v1/network-sites/$(networkSiteArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_device_identifier(device_identifier_arn)
    get_device_identifier(device_identifier_arn, params::Dict{String,<:Any})

Gets the specified device identifier.

# Arguments
- `device_identifier_arn`: The Amazon Resource Name (ARN) of the device identifier.

"""
function get_device_identifier(
    deviceIdentifierArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "GET",
        "/v1/device-identifiers/$(deviceIdentifierArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_device_identifier(
    deviceIdentifierArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "GET",
        "/v1/device-identifiers/$(deviceIdentifierArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_network(network_arn)
    get_network(network_arn, params::Dict{String,<:Any})

Gets the specified network.

# Arguments
- `network_arn`: The Amazon Resource Name (ARN) of the network.

"""
function get_network(networkArn; aws_config::AbstractAWSConfig=current_aws_config())
    return privatenetworks(
        "GET",
        "/v1/networks/$(networkArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_network(
    networkArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "GET",
        "/v1/networks/$(networkArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_network_resource(network_resource_arn)
    get_network_resource(network_resource_arn, params::Dict{String,<:Any})

Gets the specified network resource.

# Arguments
- `network_resource_arn`: The Amazon Resource Name (ARN) of the network resource.

"""
function get_network_resource(
    networkResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "GET",
        "/v1/network-resources/$(networkResourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_network_resource(
    networkResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "GET",
        "/v1/network-resources/$(networkResourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_network_site(network_site_arn)
    get_network_site(network_site_arn, params::Dict{String,<:Any})

Gets the specified network site.

# Arguments
- `network_site_arn`: The Amazon Resource Name (ARN) of the network site.

"""
function get_network_site(
    networkSiteArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "GET",
        "/v1/network-sites/$(networkSiteArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_network_site(
    networkSiteArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "GET",
        "/v1/network-sites/$(networkSiteArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_order(order_arn)
    get_order(order_arn, params::Dict{String,<:Any})

Gets the specified order.

# Arguments
- `order_arn`: The Amazon Resource Name (ARN) of the order.

"""
function get_order(orderArn; aws_config::AbstractAWSConfig=current_aws_config())
    return privatenetworks(
        "GET",
        "/v1/orders/$(orderArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_order(
    orderArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "GET",
        "/v1/orders/$(orderArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_device_identifiers(network_arn)
    list_device_identifiers(network_arn, params::Dict{String,<:Any})

Lists device identifiers. Add filters to your request to return a more specific list of
results. Use filters to match the Amazon Resource Name (ARN) of an order, the status of
device identifiers, or the ARN of the traffic group. If you specify multiple filters,
filters are joined with an OR, and the request returns results that match all of the
specified filters.

# Arguments
- `network_arn`: The Amazon Resource Name (ARN) of the network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: The filters.    ORDER - The Amazon Resource Name (ARN) of the order.
  STATUS - The status (ACTIVE | INACTIVE).    TRAFFIC_GROUP - The Amazon Resource Name (ARN)
  of the traffic group.   Filter values are case sensitive. If you specify multiple values
  for a filter, the values are joined with an OR, and the request returns all results that
  match any of the specified values.
- `"maxResults"`: The maximum number of results to return.
- `"startToken"`: The token for the next page of results.
"""
function list_device_identifiers(
    networkArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "POST",
        "/v1/device-identifiers/list",
        Dict{String,Any}("networkArn" => networkArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_device_identifiers(
    networkArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "POST",
        "/v1/device-identifiers/list",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("networkArn" => networkArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_network_resources(network_arn)
    list_network_resources(network_arn, params::Dict{String,<:Any})

Lists network resources. Add filters to your request to return a more specific list of
results. Use filters to match the Amazon Resource Name (ARN) of an order or the status of
network resources. If you specify multiple filters, filters are joined with an OR, and the
request returns results that match all of the specified filters.

# Arguments
- `network_arn`: The Amazon Resource Name (ARN) of the network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: The filters.    ORDER - The Amazon Resource Name (ARN) of the order.
  STATUS - The status (AVAILABLE | DELETED | DELETING | PENDING | PENDING_RETURN |
  PROVISIONING | SHIPPED).   Filter values are case sensitive. If you specify multiple values
  for a filter, the values are joined with an OR, and the request returns all results that
  match any of the specified values.
- `"maxResults"`: The maximum number of results to return.
- `"startToken"`: The token for the next page of results.
"""
function list_network_resources(
    networkArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "POST",
        "/v1/network-resources",
        Dict{String,Any}("networkArn" => networkArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_network_resources(
    networkArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "POST",
        "/v1/network-resources",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("networkArn" => networkArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_network_sites(network_arn)
    list_network_sites(network_arn, params::Dict{String,<:Any})

Lists network sites. Add filters to your request to return a more specific list of results.
Use filters to match the status of the network site.

# Arguments
- `network_arn`: The Amazon Resource Name (ARN) of the network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: The filters. Add filters to your request to return a more specific list of
  results. Use filters to match the status of the network sites.    STATUS - The status
  (AVAILABLE | CREATED | DELETED | DEPROVISIONING | PROVISIONING).   Filter values are case
  sensitive. If you specify multiple values for a filter, the values are joined with an OR,
  and the request returns all results that match any of the specified values.
- `"maxResults"`: The maximum number of results to return.
- `"startToken"`: The token for the next page of results.
"""
function list_network_sites(networkArn; aws_config::AbstractAWSConfig=current_aws_config())
    return privatenetworks(
        "POST",
        "/v1/network-sites/list",
        Dict{String,Any}("networkArn" => networkArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_network_sites(
    networkArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "POST",
        "/v1/network-sites/list",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("networkArn" => networkArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_networks()
    list_networks(params::Dict{String,<:Any})

Lists networks. Add filters to your request to return a more specific list of results. Use
filters to match the status of the network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: The filters.    STATUS - The status (AVAILABLE | CREATED | DELETED |
  DEPROVISIONING | PROVISIONING).   Filter values are case sensitive. If you specify multiple
  values for a filter, the values are joined with an OR, and the request returns all results
  that match any of the specified values.
- `"maxResults"`: The maximum number of results to return.
- `"startToken"`: The token for the next page of results.
"""
function list_networks(; aws_config::AbstractAWSConfig=current_aws_config())
    return privatenetworks(
        "POST", "/v1/networks/list"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_networks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "POST",
        "/v1/networks/list",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_orders(network_arn)
    list_orders(network_arn, params::Dict{String,<:Any})

Lists orders. Add filters to your request to return a more specific list of results. Use
filters to match the Amazon Resource Name (ARN) of the network site or the status of the
order. If you specify multiple filters, filters are joined with an OR, and the request
returns results that match all of the specified filters.

# Arguments
- `network_arn`: The Amazon Resource Name (ARN) of the network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: The filters.    NETWORK_SITE - The Amazon Resource Name (ARN) of the network
  site.    STATUS - The status (ACKNOWLEDGING | ACKNOWLEDGED | UNACKNOWLEDGED).   Filter
  values are case sensitive. If you specify multiple values for a filter, the values are
  joined with an OR, and the request returns all results that match any of the specified
  values.
- `"maxResults"`: The maximum number of results to return.
- `"startToken"`: The token for the next page of results.
"""
function list_orders(networkArn; aws_config::AbstractAWSConfig=current_aws_config())
    return privatenetworks(
        "POST",
        "/v1/orders/list",
        Dict{String,Any}("networkArn" => networkArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_orders(
    networkArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "POST",
        "/v1/orders/list",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("networkArn" => networkArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags for the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    ping()
    ping(params::Dict{String,<:Any})

Checks the health of the service.

"""
function ping(; aws_config::AbstractAWSConfig=current_aws_config())
    return privatenetworks(
        "GET", "/ping"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function ping(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "GET", "/ping", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    start_network_resource_update(network_resource_arn, update_type)
    start_network_resource_update(network_resource_arn, update_type, params::Dict{String,<:Any})

Use this action to do the following tasks:   Update the duration and renewal status of the
commitment period for a radio unit. The update goes into effect immediately.   Request a
replacement for a network resource.   Request that you return a network resource.   After
you submit a request to replace or return a network resource, the status of the network
resource changes to CREATING_SHIPPING_LABEL. The shipping label is available when the
status of the network resource is PENDING_RETURN. After the network resource is
successfully returned, its status changes to DELETED. For more information, see Return a
radio unit.

# Arguments
- `network_resource_arn`: The Amazon Resource Name (ARN) of the network resource.
- `update_type`: The update type.    REPLACE - Submits a request to replace a defective
  radio unit. We provide a shipping label that you can use for the return process and we ship
  a replacement radio unit to you.    RETURN - Submits a request to return a radio unit that
  you no longer need. We provide a shipping label that you can use for the return process.
  COMMITMENT - Submits a request to change or renew the commitment period. If you choose this
  value, then you must set  commitmentConfiguration .

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"commitmentConfiguration"`: Use this action to extend and automatically renew the
  commitment period for the radio unit. You can do the following:   Change a 60-day
  commitment to a 1-year or 3-year commitment. The change is immediate and the hourly rate
  decreases to the rate for the new commitment period.   Change a 1-year commitment to a
  3-year commitment. The change is immediate and the hourly rate decreases to the rate for
  the 3-year commitment period.   Set a 1-year commitment to automatically renew for an
  additional 1 year. The hourly rate for the additional year will continue to be the same as
  your existing 1-year rate.   Set a 3-year commitment to automatically renew for an
  additional 1 year. The hourly rate for the additional year will continue to be the same as
  your existing 3-year rate.   Turn off a previously-enabled automatic renewal on a 1-year or
  3-year commitment. You cannot use the automatic-renewal option for a 60-day commitment.
  For pricing, see Amazon Web Services Private 5G Pricing.
- `"returnReason"`: The reason for the return. Providing a reason for a return is optional.
- `"shippingAddress"`: The shipping address. If you don't provide a shipping address when
  replacing or returning a network resource, we use the address from the original order for
  the network resource.
"""
function start_network_resource_update(
    networkResourceArn, updateType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "POST",
        "/v1/network-resources/update",
        Dict{String,Any}(
            "networkResourceArn" => networkResourceArn, "updateType" => updateType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_network_resource_update(
    networkResourceArn,
    updateType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "POST",
        "/v1/network-resources/update",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "networkResourceArn" => networkResourceArn, "updateType" => updateType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

 Adds tags to the specified resource.

# Arguments
- `resource_arn`:  The Amazon Resource Name (ARN) of the resource.
- `tags`: The tags to add to the resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return privatenetworks(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tag_keys`: The tag keys.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_network_site(network_site_arn)
    update_network_site(network_site_arn, params::Dict{String,<:Any})

Updates the specified network site.

# Arguments
- `network_site_arn`: The Amazon Resource Name (ARN) of the network site.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `"description"`: The description.
"""
function update_network_site(
    networkSiteArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "PUT",
        "/v1/network-sites/site",
        Dict{String,Any}("networkSiteArn" => networkSiteArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_network_site(
    networkSiteArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "PUT",
        "/v1/network-sites/site",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("networkSiteArn" => networkSiteArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_network_site_plan(network_site_arn, pending_plan)
    update_network_site_plan(network_site_arn, pending_plan, params::Dict{String,<:Any})

Updates the specified network site plan.

# Arguments
- `network_site_arn`: The Amazon Resource Name (ARN) of the network site.
- `pending_plan`: The pending plan.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
"""
function update_network_site_plan(
    networkSiteArn, pendingPlan; aws_config::AbstractAWSConfig=current_aws_config()
)
    return privatenetworks(
        "PUT",
        "/v1/network-sites/plan",
        Dict{String,Any}("networkSiteArn" => networkSiteArn, "pendingPlan" => pendingPlan);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_network_site_plan(
    networkSiteArn,
    pendingPlan,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return privatenetworks(
        "PUT",
        "/v1/network-sites/plan",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "networkSiteArn" => networkSiteArn, "pendingPlan" => pendingPlan
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
