# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: qbusiness
using AWS.Compat
using AWS.UUIDs

"""
    batch_delete_document(application_id, documents, index_id)
    batch_delete_document(application_id, documents, index_id, params::Dict{String,<:Any})

Asynchronously deletes one or more documents added using the BatchPutDocument API from an
Amazon Q Business index. You can see the progress of the deletion, and any error messages
related to the process, by using CloudWatch.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application.
- `documents`: Documents deleted from the Amazon Q Business index.
- `index_id`: The identifier of the Amazon Q Business index that contains the documents to
  delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dataSourceSyncId"`: The identifier of the data source sync during which the documents
  were deleted.
"""
function batch_delete_document(
    applicationId, documents, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/indices/$(indexId)/documents/delete",
        Dict{String,Any}("documents" => documents);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_delete_document(
    applicationId,
    documents,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/indices/$(indexId)/documents/delete",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("documents" => documents), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_put_document(application_id, documents, index_id)
    batch_put_document(application_id, documents, index_id, params::Dict{String,<:Any})

Adds one or more documents to an Amazon Q Business index. You use this API to:   ingest
your structured and unstructured documents and documents stored in an Amazon S3 bucket into
an Amazon Q Business index.   add custom attributes to documents in an Amazon Q Business
index.   attach an access control list to the documents added to an Amazon Q Business
index.   You can see the progress of the deletion, and any error messages related to the
process, by using CloudWatch.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application.
- `documents`: One or more documents to add to the index.
- `index_id`: The identifier of the Amazon Q Business index to add the documents to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dataSourceSyncId"`: The identifier of the data source sync during which the documents
  were added.
- `"roleArn"`: The Amazon Resource Name (ARN) of an IAM role with permission to access your
  S3 bucket.
"""
function batch_put_document(
    applicationId, documents, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/indices/$(indexId)/documents",
        Dict{String,Any}("documents" => documents);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_put_document(
    applicationId,
    documents,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/indices/$(indexId)/documents",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("documents" => documents), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    chat_sync(application_id)
    chat_sync(application_id, params::Dict{String,<:Any})

Starts or continues a non-streaming Amazon Q Business conversation.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application linked to the
  Amazon Q Business conversation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"actionExecution"`: A request from an end user to perform an Amazon Q Business plugin
  action.
- `"attachments"`: A list of files uploaded directly during chat. You can upload a maximum
  of 5 files of upto 10 MB each.
- `"attributeFilter"`: Enables filtering of Amazon Q Business web experience responses
  based on document attributes or metadata fields.
- `"authChallengeResponse"`: An authentication verification event response by a third party
  authentication server to Amazon Q Business.
- `"chatMode"`: The chat modes available to an Amazon Q Business end user.
  RETRIEVAL_MODE - The default chat mode for an Amazon Q Business application. When this mode
  is enabled, Amazon Q Business generates responses only from data sources connected to an
  Amazon Q Business application.    CREATOR_MODE - By selecting this mode, users can choose
  to generate responses only from the LLM knowledge, without consulting connected data
  sources, for a chat request.    PLUGIN_MODE - By selecting this mode, users can choose to
  use plugins in chat.   For more information, see Admin controls and guardrails, Plugins,
  and Conversation settings.
- `"chatModeConfiguration"`: The chat mode configuration for an Amazon Q Business
  application.
- `"clientToken"`: A token that you provide to identify a chat request.
- `"conversationId"`: The identifier of the Amazon Q Business conversation.
- `"parentMessageId"`: The identifier of the previous system message in a conversation.
- `"userGroups"`: The groups that a user associated with the chat input belongs to.
- `"userId"`: The identifier of the user attached to the chat input.
- `"userMessage"`: A end user message in a conversation.
"""
function chat_sync(applicationId; aws_config::AbstractAWSConfig=current_aws_config())
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/conversations?sync",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function chat_sync(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/conversations?sync",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_application(display_name)
    create_application(display_name, params::Dict{String,<:Any})

Creates an Amazon Q Business application.  There are new tiers for Amazon Q Business. Not
all features in Amazon Q Business Pro are also available in Amazon Q Business Lite. For
information on what's included in Amazon Q Business Lite and what's included in Amazon Q
Business Pro, see Amazon Q Business tiers. You must use the Amazon Q Business console to
assign subscription tiers to users.

# Arguments
- `display_name`: A name for the Amazon Q Business application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"attachmentsConfiguration"`: An option to allow end users to upload files directly
  during chat.
- `"clientToken"`: A token that you provide to identify the request to create your Amazon Q
  Business application.
- `"description"`: A description for the Amazon Q Business application.
- `"encryptionConfiguration"`: The identifier of the KMS key that is used to encrypt your
  data. Amazon Q Business doesn't support asymmetric keys.
- `"identityCenterInstanceArn"`:  The Amazon Resource Name (ARN) of the IAM Identity Center
  instance you are either creating for—or connecting to—your Amazon Q Business
  application.
- `"qAppsConfiguration"`: An option to allow end users to create and use Amazon Q Apps in
  the web experience.
- `"roleArn"`:  The Amazon Resource Name (ARN) of an IAM role with permissions to access
  your Amazon CloudWatch logs and metrics.
- `"tags"`: A list of key-value pairs that identify or categorize your Amazon Q Business
  application. You can also use tags to help control access to the application. Tag keys and
  values can consist of Unicode letters, digits, white space, and any of the following
  symbols: _ . : / = + - @.
"""
function create_application(displayName; aws_config::AbstractAWSConfig=current_aws_config())
    return qbusiness(
        "POST",
        "/applications",
        Dict{String,Any}("displayName" => displayName, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_application(
    displayName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "displayName" => displayName, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_data_source(application_id, configuration, display_name, index_id)
    create_data_source(application_id, configuration, display_name, index_id, params::Dict{String,<:Any})

Creates a data source connector for an Amazon Q Business application.  CreateDataSource is
a synchronous operation. The operation returns 200 if the data source was successfully
created. Otherwise, an exception is raised.

# Arguments
- `application_id`:  The identifier of the Amazon Q Business application the data source
  will be attached to.
- `configuration`: Configuration information to connect to your data source repository. For
  configuration templates for your specific data source, see Supported connectors.
- `display_name`: A name for the data source connector.
- `index_id`: The identifier of the index that you want to use with the data source
  connector.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A token you provide to identify a request to create a data source
  connector. Multiple calls to the CreateDataSource API with the same client token will
  create only one data source connector.
- `"description"`: A description for the data source connector.
- `"documentEnrichmentConfiguration"`:
- `"roleArn"`: The Amazon Resource Name (ARN) of an IAM role with permission to access the
  data source and required resources.
- `"syncSchedule"`: Sets the frequency for Amazon Q Business to check the documents in your
  data source repository and update your index. If you don't set a schedule, Amazon Q
  Business won't periodically update the index. Specify a cron- format schedule string or an
  empty string to indicate that the index is updated on demand. You can't specify the
  Schedule parameter when the Type parameter is set to CUSTOM. If you do, you receive a
  ValidationException exception.
- `"tags"`: A list of key-value pairs that identify or categorize the data source
  connector. You can also use tags to help control access to the data source connector. Tag
  keys and values can consist of Unicode letters, digits, white space, and any of the
  following symbols: _ . : / = + - @.
- `"vpcConfiguration"`: Configuration information for an Amazon VPC (Virtual Private Cloud)
  to connect to your data source. For more information, see Using Amazon VPC with Amazon Q
  Business connectors.
"""
function create_data_source(
    applicationId,
    configuration,
    displayName,
    indexId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/indices/$(indexId)/datasources",
        Dict{String,Any}(
            "configuration" => configuration,
            "displayName" => displayName,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_data_source(
    applicationId,
    configuration,
    displayName,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/indices/$(indexId)/datasources",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "configuration" => configuration,
                    "displayName" => displayName,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_index(application_id, display_name)
    create_index(application_id, display_name, params::Dict{String,<:Any})

Creates an Amazon Q Business index. To determine if index creation has completed, check the
Status field returned from a call to DescribeIndex. The Status field is set to ACTIVE when
the index is ready to use. Once the index is active, you can index your documents using the
 BatchPutDocument  API or the  CreateDataSource  API.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application using the index.
- `display_name`: A name for the Amazon Q Business index.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"capacityConfiguration"`: The capacity units you want to provision for your index. You
  can add and remove capacity to fit your usage needs.
- `"clientToken"`: A token that you provide to identify the request to create an index.
  Multiple calls to the CreateIndex API with the same client token will create only one index.
- `"description"`: A description for the Amazon Q Business index.
- `"tags"`: A list of key-value pairs that identify or categorize the index. You can also
  use tags to help control access to the index. Tag keys and values can consist of Unicode
  letters, digits, white space, and any of the following symbols: _ . : / = + - @.
- `"type"`: The index type that's suitable for your needs. For more information on what's
  included in each type of index, see Amazon Q Business tiers.
"""
function create_index(
    applicationId, displayName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/indices",
        Dict{String,Any}("displayName" => displayName, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_index(
    applicationId,
    displayName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/indices",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "displayName" => displayName, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_plugin(application_id, auth_configuration, display_name, type)
    create_plugin(application_id, auth_configuration, display_name, type, params::Dict{String,<:Any})

Creates an Amazon Q Business plugin.

# Arguments
- `application_id`: The identifier of the application that will contain the plugin.
- `auth_configuration`:
- `display_name`: A the name for your plugin.
- `type`: The type of plugin you want to create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A token that you provide to identify the request to create your Amazon Q
  Business plugin.
- `"customPluginConfiguration"`: Contains configuration for a custom plugin.
- `"serverUrl"`: The source URL used for plugin configuration.
- `"tags"`: A list of key-value pairs that identify or categorize the data source
  connector. You can also use tags to help control access to the data source connector. Tag
  keys and values can consist of Unicode letters, digits, white space, and any of the
  following symbols: _ . : / = + - @.
"""
function create_plugin(
    applicationId,
    authConfiguration,
    displayName,
    type;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/plugins",
        Dict{String,Any}(
            "authConfiguration" => authConfiguration,
            "displayName" => displayName,
            "type" => type,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_plugin(
    applicationId,
    authConfiguration,
    displayName,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/plugins",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "authConfiguration" => authConfiguration,
                    "displayName" => displayName,
                    "type" => type,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_retriever(application_id, configuration, display_name, type)
    create_retriever(application_id, configuration, display_name, type, params::Dict{String,<:Any})

Adds a retriever to your Amazon Q Business application.

# Arguments
- `application_id`: The identifier of your Amazon Q Business application.
- `configuration`:
- `display_name`: The name of your retriever.
- `type`: The type of retriever you are using.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A token that you provide to identify the request to create your Amazon Q
  Business application retriever.
- `"roleArn"`: The ARN of an IAM role used by Amazon Q Business to access the basic
  authentication credentials stored in a Secrets Manager secret.
- `"tags"`: A list of key-value pairs that identify or categorize the retriever. You can
  also use tags to help control access to the retriever. Tag keys and values can consist of
  Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
"""
function create_retriever(
    applicationId,
    configuration,
    displayName,
    type;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/retrievers",
        Dict{String,Any}(
            "configuration" => configuration,
            "displayName" => displayName,
            "type" => type,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_retriever(
    applicationId,
    configuration,
    displayName,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/retrievers",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "configuration" => configuration,
                    "displayName" => displayName,
                    "type" => type,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_user(application_id, user_id)
    create_user(application_id, user_id, params::Dict{String,<:Any})

Creates a universally unique identifier (UUID) mapped to a list of local user ids within an
application.

# Arguments
- `application_id`: The identifier of the application for which the user mapping will be
  created.
- `user_id`: The user emails attached to a user mapping.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A token that you provide to identify the request to create your Amazon Q
  Business user mapping.
- `"userAliases"`: The list of user aliases in the mapping.
"""
function create_user(
    applicationId, userId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/users",
        Dict{String,Any}("userId" => userId, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user(
    applicationId,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/users",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("userId" => userId, "clientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_web_experience(application_id)
    create_web_experience(application_id, params::Dict{String,<:Any})

Creates an Amazon Q Business web experience.

# Arguments
- `application_id`: The identifier of the Amazon Q Business web experience.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A token you provide to identify a request to create an Amazon Q Business
  web experience.
- `"roleArn"`: The Amazon Resource Name (ARN) of the service role attached to your web
  experience.
- `"samplePromptsControlMode"`: Determines whether sample prompts are enabled in the web
  experience for an end user.
- `"subtitle"`: A subtitle to personalize your Amazon Q Business web experience.
- `"tags"`: A list of key-value pairs that identify or categorize your Amazon Q Business
  web experience. You can also use tags to help control access to the web experience. Tag
  keys and values can consist of Unicode letters, digits, white space, and any of the
  following symbols: _ . : / = + - @.
- `"title"`: The title for your Amazon Q Business web experience.
- `"welcomeMessage"`: The customized welcome message for end users of an Amazon Q Business
  web experience.
"""
function create_web_experience(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/experiences",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_web_experience(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/experiences",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application(application_id)
    delete_application(application_id, params::Dict{String,<:Any})

Deletes an Amazon Q Business application.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application.

"""
function delete_application(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_chat_controls_configuration(application_id)
    delete_chat_controls_configuration(application_id, params::Dict{String,<:Any})

Deletes chat controls configured for an existing Amazon Q Business application.

# Arguments
- `application_id`: The identifier of the application the chat controls have been
  configured for.

"""
function delete_chat_controls_configuration(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/chatcontrols";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_chat_controls_configuration(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/chatcontrols",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_conversation(application_id, conversation_id)
    delete_conversation(application_id, conversation_id, params::Dict{String,<:Any})

Deletes an Amazon Q Business web experience conversation.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application associated with the
  conversation.
- `conversation_id`: The identifier of the Amazon Q Business web experience conversation
  being deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"userId"`: The identifier of the user who is deleting the conversation.
"""
function delete_conversation(
    applicationId, conversationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/conversations/$(conversationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_conversation(
    applicationId,
    conversationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/conversations/$(conversationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_data_source(application_id, data_source_id, index_id)
    delete_data_source(application_id, data_source_id, index_id, params::Dict{String,<:Any})

Deletes an Amazon Q Business data source connector. While the data source is being deleted,
the Status field returned by a call to the DescribeDataSource API is set to DELETING.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application used with the data
  source connector.
- `data_source_id`: The identifier of the data source connector that you want to delete.
- `index_id`: The identifier of the index used with the data source connector.

"""
function delete_data_source(
    applicationId, dataSourceId, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/indices/$(indexId)/datasources/$(dataSourceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_data_source(
    applicationId,
    dataSourceId,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/indices/$(indexId)/datasources/$(dataSourceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_group(application_id, group_name, index_id)
    delete_group(application_id, group_name, index_id, params::Dict{String,<:Any})

Deletes a group so that all users and sub groups that belong to the group can no longer
access documents only available to that group. For example, after deleting the group
\"Summer Interns\", all interns who belonged to that group no longer see intern-only
documents in their chat results.  If you want to delete, update, or replace users or sub
groups of a group, you need to use the PutGroup operation. For example, if a user in the
group \"Engineering\" leaves the engineering team and another user takes their place, you
provide an updated list of users or sub groups that belong to the \"Engineering\" group
when calling PutGroup.

# Arguments
- `application_id`: The identifier of the application in which the group mapping belongs.
- `group_name`: The name of the group you want to delete.
- `index_id`: The identifier of the index you want to delete the group from.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dataSourceId"`: The identifier of the data source linked to the group A group can be
  tied to multiple data sources. You can delete a group from accessing documents in a certain
  data source. For example, the groups \"Research\", \"Engineering\", and \"Sales and
  Marketing\" are all tied to the company's documents stored in the data sources Confluence
  and Salesforce. You want to delete \"Research\" and \"Engineering\" groups from Salesforce,
  so that these groups cannot access customer-related documents stored in Salesforce. Only
  \"Sales and Marketing\" should access documents in the Salesforce data source.
"""
function delete_group(
    applicationId, groupName, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/indices/$(indexId)/groups/$(groupName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_group(
    applicationId,
    groupName,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/indices/$(indexId)/groups/$(groupName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_index(application_id, index_id)
    delete_index(application_id, index_id, params::Dict{String,<:Any})

Deletes an Amazon Q Business index.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application the Amazon Q
  Business index is linked to.
- `index_id`: The identifier of the Amazon Q Business index.

"""
function delete_index(
    applicationId, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/indices/$(indexId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_index(
    applicationId,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/indices/$(indexId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_plugin(application_id, plugin_id)
    delete_plugin(application_id, plugin_id, params::Dict{String,<:Any})

Deletes an Amazon Q Business plugin.

# Arguments
- `application_id`: The identifier the application attached to the Amazon Q Business plugin.
- `plugin_id`: The identifier of the plugin being deleted.

"""
function delete_plugin(
    applicationId, pluginId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/plugins/$(pluginId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_plugin(
    applicationId,
    pluginId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/plugins/$(pluginId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_retriever(application_id, retriever_id)
    delete_retriever(application_id, retriever_id, params::Dict{String,<:Any})

Deletes the retriever used by an Amazon Q Business application.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application using the retriever.
- `retriever_id`: The identifier of the retriever being deleted.

"""
function delete_retriever(
    applicationId, retrieverId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/retrievers/$(retrieverId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_retriever(
    applicationId,
    retrieverId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/retrievers/$(retrieverId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user(application_id, user_id)
    delete_user(application_id, user_id, params::Dict{String,<:Any})

Deletes a user by email id.

# Arguments
- `application_id`: The identifier of the application from which the user is being deleted.
- `user_id`: The user email being deleted.

"""
function delete_user(
    applicationId, userId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/users/$(userId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user(
    applicationId,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/users/$(userId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_web_experience(application_id, web_experience_id)
    delete_web_experience(application_id, web_experience_id, params::Dict{String,<:Any})

Deletes an Amazon Q Business web experience.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application linked to the
  Amazon Q Business web experience.
- `web_experience_id`: The identifier of the Amazon Q Business web experience being deleted.

"""
function delete_web_experience(
    applicationId, webExperienceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/experiences/$(webExperienceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_web_experience(
    applicationId,
    webExperienceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "DELETE",
        "/applications/$(applicationId)/experiences/$(webExperienceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_application(application_id)
    get_application(application_id, params::Dict{String,<:Any})

Gets information about an existing Amazon Q Business application.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application.

"""
function get_application(applicationId; aws_config::AbstractAWSConfig=current_aws_config())
    return qbusiness(
        "GET",
        "/applications/$(applicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_application(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_chat_controls_configuration(application_id)
    get_chat_controls_configuration(application_id, params::Dict{String,<:Any})

Gets information about an chat controls configured for an existing Amazon Q Business
application.

# Arguments
- `application_id`: The identifier of the application for which the chat controls are
  configured.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of configured chat controls to return.
- `"nextToken"`: If the maxResults response was incomplete because there is more data to
  retrieve, Amazon Q Business returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of Amazon Q Business chat controls configured.
"""
function get_chat_controls_configuration(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/chatcontrols";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_chat_controls_configuration(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/chatcontrols",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_data_source(application_id, data_source_id, index_id)
    get_data_source(application_id, data_source_id, index_id, params::Dict{String,<:Any})

Gets information about an existing Amazon Q Business data source connector.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application.
- `data_source_id`: The identifier of the data source connector.
- `index_id`: The identfier of the index used with the data source connector.

"""
function get_data_source(
    applicationId, dataSourceId, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices/$(indexId)/datasources/$(dataSourceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_data_source(
    applicationId,
    dataSourceId,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices/$(indexId)/datasources/$(dataSourceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_group(application_id, group_name, index_id)
    get_group(application_id, group_name, index_id, params::Dict{String,<:Any})

Describes a group by group name.

# Arguments
- `application_id`: The identifier of the application id the group is attached to.
- `group_name`: The name of the group.
- `index_id`: The identifier of the index the group is attached to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dataSourceId"`: The identifier of the data source the group is attached to.
"""
function get_group(
    applicationId, groupName, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices/$(indexId)/groups/$(groupName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_group(
    applicationId,
    groupName,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices/$(indexId)/groups/$(groupName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_index(application_id, index_id)
    get_index(application_id, index_id, params::Dict{String,<:Any})

Gets information about an existing Amazon Q Business index.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application connected to the
  index.
- `index_id`: The identifier of the Amazon Q Business index you want information on.

"""
function get_index(
    applicationId, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices/$(indexId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_index(
    applicationId,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices/$(indexId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_plugin(application_id, plugin_id)
    get_plugin(application_id, plugin_id, params::Dict{String,<:Any})

Gets information about an existing Amazon Q Business plugin.

# Arguments
- `application_id`: The identifier of the application which contains the plugin.
- `plugin_id`: The identifier of the plugin.

"""
function get_plugin(
    applicationId, pluginId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/plugins/$(pluginId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_plugin(
    applicationId,
    pluginId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/plugins/$(pluginId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_retriever(application_id, retriever_id)
    get_retriever(application_id, retriever_id, params::Dict{String,<:Any})

Gets information about an existing retriever used by an Amazon Q Business application.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application using the retriever.
- `retriever_id`: The identifier of the retriever.

"""
function get_retriever(
    applicationId, retrieverId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/retrievers/$(retrieverId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_retriever(
    applicationId,
    retrieverId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/retrievers/$(retrieverId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_user(application_id, user_id)
    get_user(application_id, user_id, params::Dict{String,<:Any})

Describes the universally unique identifier (UUID) associated with a local user in a data
source.

# Arguments
- `application_id`: The identifier of the application connected to the user.
- `user_id`: The user email address attached to the user.

"""
function get_user(applicationId, userId; aws_config::AbstractAWSConfig=current_aws_config())
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/users/$(userId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_user(
    applicationId,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/users/$(userId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_web_experience(application_id, web_experience_id)
    get_web_experience(application_id, web_experience_id, params::Dict{String,<:Any})

Gets information about an existing Amazon Q Business web experience.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application linked to the web
  experience.
- `web_experience_id`: The identifier of the Amazon Q Business web experience.

"""
function get_web_experience(
    applicationId, webExperienceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/experiences/$(webExperienceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_web_experience(
    applicationId,
    webExperienceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/experiences/$(webExperienceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_applications()
    list_applications(params::Dict{String,<:Any})

Lists Amazon Q Business applications.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of Amazon Q Business applications to return.
- `"nextToken"`: If the maxResults response was incomplete because there is more data to
  retrieve, Amazon Q Business returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of Amazon Q Business applications.
"""
function list_applications(; aws_config::AbstractAWSConfig=current_aws_config())
    return qbusiness(
        "GET", "/applications"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_conversations(application_id)
    list_conversations(application_id, params::Dict{String,<:Any})

Lists one or more Amazon Q Business conversations.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of Amazon Q Business conversations to return.
- `"nextToken"`: If the maxResults response was incomplete because there is more data to
  retrieve, Amazon Q Business returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of Amazon Q Business conversations.
- `"userId"`: The identifier of the user involved in the Amazon Q Business web experience
  conversation.
"""
function list_conversations(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/conversations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_conversations(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/conversations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_data_source_sync_jobs(application_id, data_source_id, index_id)
    list_data_source_sync_jobs(application_id, data_source_id, index_id, params::Dict{String,<:Any})

Get information about an Amazon Q Business data source connector synchronization.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application connected to the
  data source.
- `data_source_id`:  The identifier of the data source connector.
- `index_id`: The identifier of the index used with the Amazon Q Business data source
  connector.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"endTime"`:  The end time of the data source connector sync.
- `"maxResults"`: The maximum number of synchronization jobs to return in the response.
- `"nextToken"`: If the maxResults response was incpmplete because there is more data to
  retriever, Amazon Q Business returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of responses.
- `"startTime"`:  The start time of the data source connector sync.
- `"syncStatus"`: Only returns synchronization jobs with the Status field equal to the
  specified status.
"""
function list_data_source_sync_jobs(
    applicationId, dataSourceId, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices/$(indexId)/datasources/$(dataSourceId)/syncjobs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_data_source_sync_jobs(
    applicationId,
    dataSourceId,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices/$(indexId)/datasources/$(dataSourceId)/syncjobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_data_sources(application_id, index_id)
    list_data_sources(application_id, index_id, params::Dict{String,<:Any})

Lists the Amazon Q Business data source connectors that you have created.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application linked to the data
  source connectors.
- `index_id`: The identifier of the index used with one or more data source connectors.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of data source connectors to return.
- `"nextToken"`: If the maxResults response was incomplete because there is more data to
  retrieve, Amazon Q Business returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of Amazon Q Business data source connectors.
"""
function list_data_sources(
    applicationId, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices/$(indexId)/datasources";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_data_sources(
    applicationId,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices/$(indexId)/datasources",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_documents(application_id, index_id)
    list_documents(application_id, index_id, params::Dict{String,<:Any})

A list of documents attached to an index.

# Arguments
- `application_id`: The identifier of the application id the documents are attached to.
- `index_id`: The identifier of the index the documents are attached to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dataSourceIds"`: The identifier of the data sources the documents are attached to.
- `"maxResults"`: The maximum number of documents to return.
- `"nextToken"`: If the maxResults response was incomplete because there is more data to
  retrieve, Amazon Q Business returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of documents.
"""
function list_documents(
    applicationId, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/index/$(indexId)/documents";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_documents(
    applicationId,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/index/$(indexId)/documents",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_groups(application_id, index_id, updated_earlier_than)
    list_groups(application_id, index_id, updated_earlier_than, params::Dict{String,<:Any})

Provides a list of groups that are mapped to users.

# Arguments
- `application_id`: The identifier of the application for getting a list of groups mapped
  to users.
- `index_id`: The identifier of the index for getting a list of groups mapped to users.
- `updated_earlier_than`: The timestamp identifier used for the latest PUT or DELETE action
  for mapping users to their groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dataSourceId"`: The identifier of the data source for getting a list of groups mapped
  to users.
- `"maxResults"`: The maximum number of returned groups that are mapped to users.
- `"nextToken"`: If the previous response was incomplete (because there is more data to
  retrieve), Amazon Q Business returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of groups that are mapped to users.
"""
function list_groups(
    applicationId,
    indexId,
    updatedEarlierThan;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices/$(indexId)/groups",
        Dict{String,Any}("updatedEarlierThan" => updatedEarlierThan);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_groups(
    applicationId,
    indexId,
    updatedEarlierThan,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices/$(indexId)/groups",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("updatedEarlierThan" => updatedEarlierThan), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_indices(application_id)
    list_indices(application_id, params::Dict{String,<:Any})

Lists the Amazon Q Business indices you have created.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application connected to the
  index.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of indices to return.
- `"nextToken"`: If the maxResults response was incomplete because there is more data to
  retrieve, Amazon Q Business returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of Amazon Q Business indices.
"""
function list_indices(applicationId; aws_config::AbstractAWSConfig=current_aws_config())
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_indices(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/indices",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_messages(application_id, conversation_id)
    list_messages(application_id, conversation_id, params::Dict{String,<:Any})

Gets a list of messages associated with an Amazon Q Business web experience.

# Arguments
- `application_id`: The identifier for the Amazon Q Business application.
- `conversation_id`: The identifier of the Amazon Q Business web experience conversation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of messages to return.
- `"nextToken"`: If the number of retrievers returned exceeds maxResults, Amazon Q Business
  returns a next token as a pagination token to retrieve the next set of messages.
- `"userId"`: The identifier of the user involved in the Amazon Q Business web experience
  conversation.
"""
function list_messages(
    applicationId, conversationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/conversations/$(conversationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_messages(
    applicationId,
    conversationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/conversations/$(conversationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_plugins(application_id)
    list_plugins(application_id, params::Dict{String,<:Any})

Lists configured Amazon Q Business plugins.

# Arguments
- `application_id`: The identifier of the application the plugin is attached to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of documents to return.
- `"nextToken"`: If the maxResults response was incomplete because there is more data to
  retrieve, Amazon Q Business returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of plugins.
"""
function list_plugins(applicationId; aws_config::AbstractAWSConfig=current_aws_config())
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/plugins";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_plugins(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/plugins",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_retrievers(application_id)
    list_retrievers(application_id, params::Dict{String,<:Any})

Lists the retriever used by an Amazon Q Business application.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application using the retriever.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of retrievers returned.
- `"nextToken"`: If the number of retrievers returned exceeds maxResults, Amazon Q Business
  returns a next token as a pagination token to retrieve the next set of retrievers.
"""
function list_retrievers(applicationId; aws_config::AbstractAWSConfig=current_aws_config())
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/retrievers";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_retrievers(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/retrievers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Gets a list of tags associated with a specified resource. Amazon Q Business applications
and data sources can have tags associated with them.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the Amazon Q Business application or
  data source to get a list of tags for.

"""
function list_tags_for_resource(
    resourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/v1/tags/$(resourceARN)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/v1/tags/$(resourceARN)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_web_experiences(application_id)
    list_web_experiences(application_id, params::Dict{String,<:Any})

Lists one or more Amazon Q Business Web Experiences.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application linked to the
  listed web experiences.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of Amazon Q Business Web Experiences to return.
- `"nextToken"`: If the maxResults response was incomplete because there is more data to
  retrieve, Amazon Q Business returns a pagination token in the response. You can use this
  pagination token to retrieve the next set of Amazon Q Business conversations.
"""
function list_web_experiences(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/experiences";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_web_experiences(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "GET",
        "/applications/$(applicationId)/experiences",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_feedback(application_id, conversation_id, message_id)
    put_feedback(application_id, conversation_id, message_id, params::Dict{String,<:Any})

Enables your end user to provide feedback on their Amazon Q Business generated chat
responses.

# Arguments
- `application_id`: The identifier of the application associated with the feedback.
- `conversation_id`: The identifier of the conversation the feedback is attached to.
- `message_id`: The identifier of the chat message that the feedback was given for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"messageCopiedAt"`: The timestamp for when the feedback was recorded.
- `"messageUsefulness"`: The feedback usefulness value given by the user to the chat
  message.
- `"userId"`: The identifier of the user giving the feedback.
"""
function put_feedback(
    applicationId,
    conversationId,
    messageId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/conversations/$(conversationId)/messages/$(messageId)/feedback";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_feedback(
    applicationId,
    conversationId,
    messageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/conversations/$(conversationId)/messages/$(messageId)/feedback",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_group(application_id, group_members, group_name, index_id, type)
    put_group(application_id, group_members, group_name, index_id, type, params::Dict{String,<:Any})

Create, or updates, a mapping of users—who have access to a document—to groups. You can
also map sub groups to groups. For example, the group \"Company Intellectual Property
Teams\" includes sub groups \"Research\" and \"Engineering\". These sub groups include
their own list of users or people who work in these teams. Only users who work in research
and engineering, and therefore belong in the intellectual property group, can see
top-secret company documents in their Amazon Q Business chat results.

# Arguments
- `application_id`: The identifier of the application in which the user and group mapping
  belongs.
- `group_members`:
- `group_name`: The list that contains your users or sub groups that belong the same group.
  For example, the group \"Company\" includes the user \"CEO\" and the sub groups
  \"Research\", \"Engineering\", and \"Sales and Marketing\". If you have more than 1000
  users and/or sub groups for a single group, you need to provide the path to the S3 file
  that lists your users and sub groups for a group. Your sub groups can contain more than
  1000 users, but the list of sub groups that belong to a group (and/or users) must be no
  more than 1000.
- `index_id`: The identifier of the index in which you want to map users to their groups.
- `type`: The type of the group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dataSourceId"`: The identifier of the data source for which you want to map users to
  their groups. This is useful if a group is tied to multiple data sources, but you only want
  the group to access documents of a certain data source. For example, the groups
  \"Research\", \"Engineering\", and \"Sales and Marketing\" are all tied to the company's
  documents stored in the data sources Confluence and Salesforce. However, \"Sales and
  Marketing\" team only needs access to customer-related documents stored in Salesforce.
"""
function put_group(
    applicationId,
    groupMembers,
    groupName,
    indexId,
    type;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/indices/$(indexId)/groups",
        Dict{String,Any}(
            "groupMembers" => groupMembers, "groupName" => groupName, "type" => type
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_group(
    applicationId,
    groupMembers,
    groupName,
    indexId,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/indices/$(indexId)/groups",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "groupMembers" => groupMembers, "groupName" => groupName, "type" => type
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_data_source_sync_job(application_id, data_source_id, index_id)
    start_data_source_sync_job(application_id, data_source_id, index_id, params::Dict{String,<:Any})

Starts a data source connector synchronization job. If a synchronization job is already in
progress, Amazon Q Business returns a ConflictException.

# Arguments
- `application_id`: The identifier of Amazon Q Business application the data source is
  connected to.
- `data_source_id`:  The identifier of the data source connector.
- `index_id`: The identifier of the index used with the data source connector.

"""
function start_data_source_sync_job(
    applicationId, dataSourceId, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/indices/$(indexId)/datasources/$(dataSourceId)/startsync";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_data_source_sync_job(
    applicationId,
    dataSourceId,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/indices/$(indexId)/datasources/$(dataSourceId)/startsync",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_data_source_sync_job(application_id, data_source_id, index_id)
    stop_data_source_sync_job(application_id, data_source_id, index_id, params::Dict{String,<:Any})

Stops an Amazon Q Business data source connector synchronization job already in progress.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application that the data
  source is connected to.
- `data_source_id`:  The identifier of the data source connector.
- `index_id`: The identifier of the index used with the Amazon Q Business data source
  connector.

"""
function stop_data_source_sync_job(
    applicationId, dataSourceId, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/indices/$(indexId)/datasources/$(dataSourceId)/stopsync";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_data_source_sync_job(
    applicationId,
    dataSourceId,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/applications/$(applicationId)/indices/$(indexId)/datasources/$(dataSourceId)/stopsync",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds the specified tag to the specified Amazon Q Business application or data source
resource. If the tag already exists, the existing value is replaced with the new value.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the Amazon Q Business application or
  data source to tag.
- `tags`: A list of tag keys to add to the Amazon Q Business application or data source. If
  a tag already exists, the existing value is replaced with the new value.

"""
function tag_resource(resourceARN, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return qbusiness(
        "POST",
        "/v1/tags/$(resourceARN)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceARN,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "POST",
        "/v1/tags/$(resourceARN)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes a tag from an Amazon Q Business application or a data source.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the Amazon Q Business application, or
  data source to remove the tag from.
- `tag_keys`: A list of tag keys to remove from the Amazon Q Business application or data
  source. If a tag key does not exist on the resource, it is ignored.

"""
function untag_resource(
    resourceARN, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "DELETE",
        "/v1/tags/$(resourceARN)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceARN,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "DELETE",
        "/v1/tags/$(resourceARN)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_application(application_id)
    update_application(application_id, params::Dict{String,<:Any})

Updates an existing Amazon Q Business application.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"attachmentsConfiguration"`: An option to allow end users to upload files directly
  during chat.
- `"description"`: A description for the Amazon Q Business application.
- `"displayName"`: A name for the Amazon Q Business application.
- `"identityCenterInstanceArn"`:  The Amazon Resource Name (ARN) of the IAM Identity Center
  instance you are either creating for—or connecting to—your Amazon Q Business
  application.
- `"qAppsConfiguration"`: An option to allow end users to create and use Amazon Q Apps in
  the web experience.
- `"roleArn"`: An Amazon Web Services Identity and Access Management (IAM) role that gives
  Amazon Q Business permission to access Amazon CloudWatch logs and metrics.
"""
function update_application(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_application(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_chat_controls_configuration(application_id)
    update_chat_controls_configuration(application_id, params::Dict{String,<:Any})

Updates an set of chat controls configured for an existing Amazon Q Business application.

# Arguments
- `application_id`: The identifier of the application for which the chat controls are
  configured.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"blockedPhrasesConfigurationUpdate"`: The phrases blocked from chat by your chat control
  configuration.
- `"clientToken"`: A token that you provide to identify the request to update a Amazon Q
  Business application chat configuration.
- `"creatorModeConfiguration"`: The configuration details for CREATOR_MODE.
- `"responseScope"`: The response scope configured for your application. This determines
  whether your application uses its retrieval augmented generation (RAG) system to generate
  answers only from your enterprise data, or also uses the large language models (LLM)
  knowledge to respons to end user questions in chat.
- `"topicConfigurationsToCreateOrUpdate"`: The configured topic specific chat controls you
  want to update.
- `"topicConfigurationsToDelete"`: The configured topic specific chat controls you want to
  delete.
"""
function update_chat_controls_configuration(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "PATCH",
        "/applications/$(applicationId)/chatcontrols",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_chat_controls_configuration(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "PATCH",
        "/applications/$(applicationId)/chatcontrols",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_data_source(application_id, data_source_id, index_id)
    update_data_source(application_id, data_source_id, index_id, params::Dict{String,<:Any})

Updates an existing Amazon Q Business data source connector.

# Arguments
- `application_id`:  The identifier of the Amazon Q Business application the data source is
  attached to.
- `data_source_id`: The identifier of the data source connector.
- `index_id`: The identifier of the index attached to the data source connector.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"configuration"`:
- `"description"`: The description of the data source connector.
- `"displayName"`: A name of the data source connector.
- `"documentEnrichmentConfiguration"`:
- `"roleArn"`: The Amazon Resource Name (ARN) of an IAM role with permission to access the
  data source and required resources.
- `"syncSchedule"`: The chosen update frequency for your data source.
- `"vpcConfiguration"`:
"""
function update_data_source(
    applicationId, dataSourceId, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/indices/$(indexId)/datasources/$(dataSourceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_data_source(
    applicationId,
    dataSourceId,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/indices/$(indexId)/datasources/$(dataSourceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_index(application_id, index_id)
    update_index(application_id, index_id, params::Dict{String,<:Any})

Updates an Amazon Q Business index.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application connected to the
  index.
- `index_id`: The identifier of the Amazon Q Business index.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"capacityConfiguration"`: The storage capacity units you want to provision for your
  Amazon Q Business index. You can add and remove capacity to fit your usage needs.
- `"description"`: The description of the Amazon Q Business index.
- `"displayName"`: The name of the Amazon Q Business index.
- `"documentAttributeConfigurations"`: Configuration information for document metadata or
  fields. Document metadata are fields or attributes associated with your documents. For
  example, the company department name associated with each document. For more information,
  see Understanding document attributes.
"""
function update_index(
    applicationId, indexId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/indices/$(indexId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_index(
    applicationId,
    indexId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/indices/$(indexId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_plugin(application_id, plugin_id)
    update_plugin(application_id, plugin_id, params::Dict{String,<:Any})

Updates an Amazon Q Business plugin.

# Arguments
- `application_id`: The identifier of the application the plugin is attached to.
- `plugin_id`: The identifier of the plugin.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authConfiguration"`: The authentication configuration the plugin is using.
- `"customPluginConfiguration"`: The configuration for a custom plugin.
- `"displayName"`: The name of the plugin.
- `"serverUrl"`: The source URL used for plugin configuration.
- `"state"`: The status of the plugin.
"""
function update_plugin(
    applicationId, pluginId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/plugins/$(pluginId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_plugin(
    applicationId,
    pluginId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/plugins/$(pluginId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_retriever(application_id, retriever_id)
    update_retriever(application_id, retriever_id, params::Dict{String,<:Any})

Updates the retriever used for your Amazon Q Business application.

# Arguments
- `application_id`: The identifier of your Amazon Q Business application.
- `retriever_id`: The identifier of your retriever.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"configuration"`:
- `"displayName"`: The name of your retriever.
- `"roleArn"`: The Amazon Resource Name (ARN) of an IAM role with permission to access the
  retriever and required resources.
"""
function update_retriever(
    applicationId, retrieverId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/retrievers/$(retrieverId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_retriever(
    applicationId,
    retrieverId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/retrievers/$(retrieverId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_user(application_id, user_id)
    update_user(application_id, user_id, params::Dict{String,<:Any})

Updates a information associated with a user id.

# Arguments
- `application_id`: The identifier of the application the user is attached to.
- `user_id`: The email id attached to the user.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"userAliasesToDelete"`: The user aliases attached to the user id that are to be deleted.
- `"userAliasesToUpdate"`: The user aliases attached to the user id that are to be updated.
"""
function update_user(
    applicationId, userId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/users/$(userId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_user(
    applicationId,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/users/$(userId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_web_experience(application_id, web_experience_id)
    update_web_experience(application_id, web_experience_id, params::Dict{String,<:Any})

Updates an Amazon Q Business web experience.

# Arguments
- `application_id`: The identifier of the Amazon Q Business application attached to the web
  experience.
- `web_experience_id`: The identifier of the Amazon Q Business web experience.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authenticationConfiguration"`: The authentication configuration of the Amazon Q
  Business web experience.
- `"roleArn"`: The Amazon Resource Name (ARN) of the role with permission to access the
  Amazon Q Business web experience and required resources.
- `"samplePromptsControlMode"`: Determines whether sample prompts are enabled in the web
  experience for an end user.
- `"subtitle"`: The subtitle of the Amazon Q Business web experience.
- `"title"`: The title of the Amazon Q Business web experience.
- `"welcomeMessage"`: A customized welcome message for an end user in an Amazon Q Business
  web experience.
"""
function update_web_experience(
    applicationId, webExperienceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/experiences/$(webExperienceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_web_experience(
    applicationId,
    webExperienceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return qbusiness(
        "PUT",
        "/applications/$(applicationId)/experiences/$(webExperienceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
