# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: redshift_serverless
using AWS.Compat
using AWS.UUIDs

"""
    convert_recovery_point_to_snapshot(recovery_point_id, snapshot_name)
    convert_recovery_point_to_snapshot(recovery_point_id, snapshot_name, params::Dict{String,<:Any})

Converts a recovery point to a snapshot. For more information about recovery points and
snapshots, see Working with snapshots and recovery points.

# Arguments
- `recovery_point_id`: The unique identifier of the recovery point.
- `snapshot_name`: The name of the snapshot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"retentionPeriod"`: How long to retain the snapshot.
- `"tags"`: An array of Tag objects to associate with the created snapshot.
"""
function convert_recovery_point_to_snapshot(
    recoveryPointId, snapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ConvertRecoveryPointToSnapshot",
        Dict{String,Any}(
            "recoveryPointId" => recoveryPointId, "snapshotName" => snapshotName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function convert_recovery_point_to_snapshot(
    recoveryPointId,
    snapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "ConvertRecoveryPointToSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "recoveryPointId" => recoveryPointId, "snapshotName" => snapshotName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_custom_domain_association(custom_domain_certificate_arn, custom_domain_name, workgroup_name)
    create_custom_domain_association(custom_domain_certificate_arn, custom_domain_name, workgroup_name, params::Dict{String,<:Any})

Creates a custom domain association for Amazon Redshift Serverless.

# Arguments
- `custom_domain_certificate_arn`: The custom domain name’s certificate Amazon resource
  name (ARN).
- `custom_domain_name`: The custom domain name to associate with the workgroup.
- `workgroup_name`: The name of the workgroup associated with the database.

"""
function create_custom_domain_association(
    customDomainCertificateArn,
    customDomainName,
    workgroupName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "CreateCustomDomainAssociation",
        Dict{String,Any}(
            "customDomainCertificateArn" => customDomainCertificateArn,
            "customDomainName" => customDomainName,
            "workgroupName" => workgroupName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_custom_domain_association(
    customDomainCertificateArn,
    customDomainName,
    workgroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "CreateCustomDomainAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "customDomainCertificateArn" => customDomainCertificateArn,
                    "customDomainName" => customDomainName,
                    "workgroupName" => workgroupName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_endpoint_access(endpoint_name, subnet_ids, workgroup_name)
    create_endpoint_access(endpoint_name, subnet_ids, workgroup_name, params::Dict{String,<:Any})

Creates an Amazon Redshift Serverless managed VPC endpoint.

# Arguments
- `endpoint_name`: The name of the VPC endpoint. An endpoint name must contain 1-30
  characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first character must be
  a letter. The name can't contain two consecutive hyphens or end with a hyphen.
- `subnet_ids`: The unique identifers of subnets from which Amazon Redshift Serverless
  chooses one to deploy a VPC endpoint.
- `workgroup_name`: The name of the workgroup to associate with the VPC endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ownerAccount"`: The owner Amazon Web Services account for the Amazon Redshift
  Serverless workgroup.
- `"vpcSecurityGroupIds"`: The unique identifiers of the security group that defines the
  ports, protocols, and sources for inbound traffic that you are authorizing into your
  endpoint.
"""
function create_endpoint_access(
    endpointName,
    subnetIds,
    workgroupName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "CreateEndpointAccess",
        Dict{String,Any}(
            "endpointName" => endpointName,
            "subnetIds" => subnetIds,
            "workgroupName" => workgroupName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_endpoint_access(
    endpointName,
    subnetIds,
    workgroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "CreateEndpointAccess",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "endpointName" => endpointName,
                    "subnetIds" => subnetIds,
                    "workgroupName" => workgroupName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_namespace(namespace_name)
    create_namespace(namespace_name, params::Dict{String,<:Any})

Creates a namespace in Amazon Redshift Serverless.

# Arguments
- `namespace_name`: The name of the namespace.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"adminPasswordSecretKmsKeyId"`: The ID of the Key Management Service (KMS) key used to
  encrypt and store the namespace's admin credentials secret. You can only use this parameter
  if manageAdminPassword is true.
- `"adminUserPassword"`: The password of the administrator for the first database created
  in the namespace. You can't use adminUserPassword if manageAdminPassword is true.
- `"adminUsername"`: The username of the administrator for the first database created in
  the namespace.
- `"dbName"`: The name of the first database created in the namespace.
- `"defaultIamRoleArn"`: The Amazon Resource Name (ARN) of the IAM role to set as a default
  in the namespace.
- `"iamRoles"`: A list of IAM roles to associate with the namespace.
- `"kmsKeyId"`: The ID of the Amazon Web Services Key Management Service key used to
  encrypt your data.
- `"logExports"`: The types of logs the namespace can export. Available export types are
  userlog, connectionlog, and useractivitylog.
- `"manageAdminPassword"`: If true, Amazon Redshift uses Secrets Manager to manage the
  namespace's admin credentials. You can't use adminUserPassword if manageAdminPassword is
  true. If manageAdminPassword is false or not set, Amazon Redshift uses adminUserPassword
  for the admin user account's password.
- `"redshiftIdcApplicationArn"`: The ARN for the Redshift application that integrates with
  IAM Identity Center.
- `"tags"`: A list of tag instances.
"""
function create_namespace(namespaceName; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "CreateNamespace",
        Dict{String,Any}("namespaceName" => namespaceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_namespace(
    namespaceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "CreateNamespace",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("namespaceName" => namespaceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_scheduled_action(namespace_name, role_arn, schedule, scheduled_action_name, target_action)
    create_scheduled_action(namespace_name, role_arn, schedule, scheduled_action_name, target_action, params::Dict{String,<:Any})

Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift
API action. For example, you can create a schedule of when to run the CreateSnapshot API
operation.

# Arguments
- `namespace_name`: The name of the namespace for which to create a scheduled action.
- `role_arn`: The ARN of the IAM role to assume to run the scheduled action. This IAM role
  must have permission to run the Amazon Redshift Serverless API operation in the scheduled
  action. This IAM role must allow the Amazon Redshift scheduler to schedule creating
  snapshots. (Principal scheduler.redshift.amazonaws.com) to assume permissions on your
  behalf. For more information about the IAM role to use with the Amazon Redshift scheduler,
  see Using Identity-Based Policies for Amazon Redshift in the Amazon Redshift Cluster
  Management Guide
- `schedule`: The schedule for a one-time (at timestamp format) or recurring (cron format)
  scheduled action. Schedule invocations must be separated by at least one hour. Times are in
  UTC.   Format of at timestamp is yyyy-mm-ddThh:mm:ss. For example, 2016-03-04T17:27:00.
  Format of cron expression is (Minutes Hours Day-of-month Month Day-of-week Year). For
  example, \"(0 10 ? * MON *)\". For more information, see Cron Expressions in the Amazon
  CloudWatch Events User Guide.
- `scheduled_action_name`: The name of the scheduled action.
- `target_action`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"enabled"`: Indicates whether the schedule is enabled. If false, the scheduled action
  does not trigger. For more information about state of the scheduled action, see
  ScheduledAction.
- `"endTime"`: The end time in UTC when the schedule is no longer active. After this time,
  the scheduled action does not trigger.
- `"scheduledActionDescription"`: The description of the scheduled action.
- `"startTime"`: The start time in UTC when the schedule is active. Before this time, the
  scheduled action does not trigger.
"""
function create_scheduled_action(
    namespaceName,
    roleArn,
    schedule,
    scheduledActionName,
    targetAction;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "CreateScheduledAction",
        Dict{String,Any}(
            "namespaceName" => namespaceName,
            "roleArn" => roleArn,
            "schedule" => schedule,
            "scheduledActionName" => scheduledActionName,
            "targetAction" => targetAction,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_scheduled_action(
    namespaceName,
    roleArn,
    schedule,
    scheduledActionName,
    targetAction,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "CreateScheduledAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "namespaceName" => namespaceName,
                    "roleArn" => roleArn,
                    "schedule" => schedule,
                    "scheduledActionName" => scheduledActionName,
                    "targetAction" => targetAction,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_snapshot(namespace_name, snapshot_name)
    create_snapshot(namespace_name, snapshot_name, params::Dict{String,<:Any})

Creates a snapshot of all databases in a namespace. For more information about snapshots,
see  Working with snapshots and recovery points.

# Arguments
- `namespace_name`: The namespace to create a snapshot for.
- `snapshot_name`: The name of the snapshot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"retentionPeriod"`: How long to retain the created snapshot.
- `"tags"`: An array of Tag objects to associate with the snapshot.
"""
function create_snapshot(
    namespaceName, snapshotName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "CreateSnapshot",
        Dict{String,Any}("namespaceName" => namespaceName, "snapshotName" => snapshotName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_snapshot(
    namespaceName,
    snapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "CreateSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "namespaceName" => namespaceName, "snapshotName" => snapshotName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_snapshot_copy_configuration(destination_region, namespace_name)
    create_snapshot_copy_configuration(destination_region, namespace_name, params::Dict{String,<:Any})

Creates a snapshot copy configuration that lets you copy snapshots to another Amazon Web
Services Region.

# Arguments
- `destination_region`: The destination Amazon Web Services Region that you want to copy
  snapshots to.
- `namespace_name`: The name of the namespace to copy snapshots from.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"destinationKmsKeyId"`: The KMS key to use to encrypt your snapshots in the destination
  Amazon Web Services Region.
- `"snapshotRetentionPeriod"`: The retention period of the snapshots that you copy to the
  destination Amazon Web Services Region.
"""
function create_snapshot_copy_configuration(
    destinationRegion, namespaceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "CreateSnapshotCopyConfiguration",
        Dict{String,Any}(
            "destinationRegion" => destinationRegion, "namespaceName" => namespaceName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_snapshot_copy_configuration(
    destinationRegion,
    namespaceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "CreateSnapshotCopyConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationRegion" => destinationRegion,
                    "namespaceName" => namespaceName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_usage_limit(amount, resource_arn, usage_type)
    create_usage_limit(amount, resource_arn, usage_type, params::Dict{String,<:Any})

Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage
limit is identified by the returned usage limit identifier.

# Arguments
- `amount`: The limit amount. If time-based, this amount is in Redshift Processing Units
  (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data
  transferred between Regions in cross-account sharing. The value must be a positive number.
- `resource_arn`: The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource
  to create the usage limit for.
- `usage_type`: The type of Amazon Redshift Serverless usage to create a usage limit for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"breachAction"`: The action that Amazon Redshift Serverless takes when the limit is
  reached. The default is log.
- `"period"`: The time period that the amount applies to. A weekly period begins on Sunday.
  The default is monthly.
"""
function create_usage_limit(
    amount, resourceArn, usageType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "CreateUsageLimit",
        Dict{String,Any}(
            "amount" => amount, "resourceArn" => resourceArn, "usageType" => usageType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_usage_limit(
    amount,
    resourceArn,
    usageType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "CreateUsageLimit",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "amount" => amount,
                    "resourceArn" => resourceArn,
                    "usageType" => usageType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_workgroup(namespace_name, workgroup_name)
    create_workgroup(namespace_name, workgroup_name, params::Dict{String,<:Any})

Creates an workgroup in Amazon Redshift Serverless.

# Arguments
- `namespace_name`: The name of the namespace to associate with the workgroup.
- `workgroup_name`: The name of the created workgroup.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"baseCapacity"`: The base data warehouse capacity of the workgroup in Redshift
  Processing Units (RPUs).
- `"configParameters"`: An array of parameters to set for advanced control over a database.
  The options are auto_mv, datestyle, enable_case_sensitive_identifier,
  enable_user_activity_logging, query_group, search_path, require_ssl, use_fips_ssl, and
  query monitoring metrics that let you define performance boundaries. For more information
  about query monitoring rules and available metrics, see  Query monitoring metrics for
  Amazon Redshift Serverless.
- `"enhancedVpcRouting"`: The value that specifies whether to turn on enhanced virtual
  private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic
  through your VPC instead of over the internet.
- `"maxCapacity"`: The maximum data-warehouse capacity Amazon Redshift Serverless uses to
  serve queries. The max capacity is specified in RPUs.
- `"port"`: The custom port to use when connecting to a workgroup. Valid port ranges are
  5431-5455 and 8191-8215. The default is 5439.
- `"publiclyAccessible"`: A value that specifies whether the workgroup can be accessed from
  a public network.
- `"securityGroupIds"`: An array of security group IDs to associate with the workgroup.
- `"subnetIds"`: An array of VPC subnet IDs to associate with the workgroup.
- `"tags"`: A array of tag instances.
"""
function create_workgroup(
    namespaceName, workgroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "CreateWorkgroup",
        Dict{String,Any}(
            "namespaceName" => namespaceName, "workgroupName" => workgroupName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_workgroup(
    namespaceName,
    workgroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "CreateWorkgroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "namespaceName" => namespaceName, "workgroupName" => workgroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_custom_domain_association(custom_domain_name, workgroup_name)
    delete_custom_domain_association(custom_domain_name, workgroup_name, params::Dict{String,<:Any})

Deletes a custom domain association for Amazon Redshift Serverless.

# Arguments
- `custom_domain_name`: The custom domain name associated with the workgroup.
- `workgroup_name`: The name of the workgroup associated with the database.

"""
function delete_custom_domain_association(
    customDomainName, workgroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "DeleteCustomDomainAssociation",
        Dict{String,Any}(
            "customDomainName" => customDomainName, "workgroupName" => workgroupName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_custom_domain_association(
    customDomainName,
    workgroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "DeleteCustomDomainAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "customDomainName" => customDomainName, "workgroupName" => workgroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_endpoint_access(endpoint_name)
    delete_endpoint_access(endpoint_name, params::Dict{String,<:Any})

Deletes an Amazon Redshift Serverless managed VPC endpoint.

# Arguments
- `endpoint_name`: The name of the VPC endpoint to delete.

"""
function delete_endpoint_access(
    endpointName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "DeleteEndpointAccess",
        Dict{String,Any}("endpointName" => endpointName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_endpoint_access(
    endpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "DeleteEndpointAccess",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("endpointName" => endpointName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_namespace(namespace_name)
    delete_namespace(namespace_name, params::Dict{String,<:Any})

Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you
can create a final snapshot that has all of the data within the namespace.

# Arguments
- `namespace_name`: The name of the namespace to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"finalSnapshotName"`: The name of the snapshot to be created before the namespace is
  deleted.
- `"finalSnapshotRetentionPeriod"`: How long to retain the final snapshot.
"""
function delete_namespace(namespaceName; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "DeleteNamespace",
        Dict{String,Any}("namespaceName" => namespaceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_namespace(
    namespaceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "DeleteNamespace",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("namespaceName" => namespaceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_policy(resource_arn)
    delete_resource_policy(resource_arn, params::Dict{String,<:Any})

Deletes the specified resource policy.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the policy to delete.

"""
function delete_resource_policy(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "DeleteResourcePolicy",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resource_policy(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "DeleteResourcePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_scheduled_action(scheduled_action_name)
    delete_scheduled_action(scheduled_action_name, params::Dict{String,<:Any})

Deletes a scheduled action.

# Arguments
- `scheduled_action_name`: The name of the scheduled action to delete.

"""
function delete_scheduled_action(
    scheduledActionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "DeleteScheduledAction",
        Dict{String,Any}("scheduledActionName" => scheduledActionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_scheduled_action(
    scheduledActionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "DeleteScheduledAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("scheduledActionName" => scheduledActionName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_snapshot(snapshot_name)
    delete_snapshot(snapshot_name, params::Dict{String,<:Any})

Deletes a snapshot from Amazon Redshift Serverless.

# Arguments
- `snapshot_name`: The name of the snapshot to be deleted.

"""
function delete_snapshot(snapshotName; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "DeleteSnapshot",
        Dict{String,Any}("snapshotName" => snapshotName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_snapshot(
    snapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "DeleteSnapshot",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("snapshotName" => snapshotName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_snapshot_copy_configuration(snapshot_copy_configuration_id)
    delete_snapshot_copy_configuration(snapshot_copy_configuration_id, params::Dict{String,<:Any})

Deletes a snapshot copy configuration

# Arguments
- `snapshot_copy_configuration_id`: The ID of the snapshot copy configuration to delete.

"""
function delete_snapshot_copy_configuration(
    snapshotCopyConfigurationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "DeleteSnapshotCopyConfiguration",
        Dict{String,Any}("snapshotCopyConfigurationId" => snapshotCopyConfigurationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_snapshot_copy_configuration(
    snapshotCopyConfigurationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "DeleteSnapshotCopyConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "snapshotCopyConfigurationId" => snapshotCopyConfigurationId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_usage_limit(usage_limit_id)
    delete_usage_limit(usage_limit_id, params::Dict{String,<:Any})

Deletes a usage limit from Amazon Redshift Serverless.

# Arguments
- `usage_limit_id`: The unique identifier of the usage limit to delete.

"""
function delete_usage_limit(
    usageLimitId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "DeleteUsageLimit",
        Dict{String,Any}("usageLimitId" => usageLimitId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_usage_limit(
    usageLimitId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "DeleteUsageLimit",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("usageLimitId" => usageLimitId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_workgroup(workgroup_name)
    delete_workgroup(workgroup_name, params::Dict{String,<:Any})

Deletes a workgroup.

# Arguments
- `workgroup_name`: The name of the workgroup to be deleted.

"""
function delete_workgroup(workgroupName; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "DeleteWorkgroup",
        Dict{String,Any}("workgroupName" => workgroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_workgroup(
    workgroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "DeleteWorkgroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("workgroupName" => workgroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_credentials()
    get_credentials(params::Dict{String,<:Any})

Returns a database user name and temporary password with temporary authorization to log in
to Amazon Redshift Serverless. By default, the temporary credentials expire in 900 seconds.
You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60
minutes).  &lt;p&gt;The Identity and Access Management (IAM) user or role that runs
GetCredentials must have an IAM policy attached that allows access to all necessary actions
and resources.&lt;/p&gt; &lt;p&gt;If the &lt;code&gt;DbName&lt;/code&gt; parameter is
specified, the IAM policy must allow access to the resource dbname for the specified
database name.&lt;/p&gt;

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"customDomainName"`: The custom domain name associated with the workgroup. The custom
  domain name or the workgroup name must be included in the request.
- `"dbName"`: The name of the database to get temporary authorization to log on to.
  Constraints:   Must be 1 to 64 alphanumeric characters or hyphens.   Must contain only
  uppercase or lowercase letters, numbers, underscore, plus sign, period (dot), at symbol
  (@), or hyphen.   The first character must be a letter.   Must not contain a colon ( : ) or
  slash ( / ).   Cannot be a reserved word. A list of reserved words can be found in Reserved
  Words  in the Amazon Redshift Database Developer Guide
- `"durationSeconds"`: The number of seconds until the returned temporary password expires.
  The minimum is 900 seconds, and the maximum is 3600 seconds.
- `"workgroupName"`: The name of the workgroup associated with the database.
"""
function get_credentials(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "GetCredentials"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_credentials(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "GetCredentials", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_custom_domain_association(custom_domain_name, workgroup_name)
    get_custom_domain_association(custom_domain_name, workgroup_name, params::Dict{String,<:Any})

Gets information about a specific custom domain association.

# Arguments
- `custom_domain_name`: The custom domain name associated with the workgroup.
- `workgroup_name`: The name of the workgroup associated with the database.

"""
function get_custom_domain_association(
    customDomainName, workgroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "GetCustomDomainAssociation",
        Dict{String,Any}(
            "customDomainName" => customDomainName, "workgroupName" => workgroupName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_custom_domain_association(
    customDomainName,
    workgroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "GetCustomDomainAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "customDomainName" => customDomainName, "workgroupName" => workgroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_endpoint_access(endpoint_name)
    get_endpoint_access(endpoint_name, params::Dict{String,<:Any})

Returns information, such as the name, about a VPC endpoint.

# Arguments
- `endpoint_name`: The name of the VPC endpoint to return information for.

"""
function get_endpoint_access(
    endpointName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "GetEndpointAccess",
        Dict{String,Any}("endpointName" => endpointName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_endpoint_access(
    endpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "GetEndpointAccess",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("endpointName" => endpointName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_namespace(namespace_name)
    get_namespace(namespace_name, params::Dict{String,<:Any})

Returns information about a namespace in Amazon Redshift Serverless.

# Arguments
- `namespace_name`: The name of the namespace to retrieve information for.

"""
function get_namespace(namespaceName; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "GetNamespace",
        Dict{String,Any}("namespaceName" => namespaceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_namespace(
    namespaceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "GetNamespace",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("namespaceName" => namespaceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_recovery_point(recovery_point_id)
    get_recovery_point(recovery_point_id, params::Dict{String,<:Any})

Returns information about a recovery point.

# Arguments
- `recovery_point_id`: The unique identifier of the recovery point to return information
  for.

"""
function get_recovery_point(
    recoveryPointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "GetRecoveryPoint",
        Dict{String,Any}("recoveryPointId" => recoveryPointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_recovery_point(
    recoveryPointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "GetRecoveryPoint",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("recoveryPointId" => recoveryPointId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_policy(resource_arn)
    get_resource_policy(resource_arn, params::Dict{String,<:Any})

Returns a resource policy.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to return.

"""
function get_resource_policy(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "GetResourcePolicy",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_policy(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "GetResourcePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_scheduled_action(scheduled_action_name)
    get_scheduled_action(scheduled_action_name, params::Dict{String,<:Any})

Returns information about a scheduled action.

# Arguments
- `scheduled_action_name`: The name of the scheduled action.

"""
function get_scheduled_action(
    scheduledActionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "GetScheduledAction",
        Dict{String,Any}("scheduledActionName" => scheduledActionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_scheduled_action(
    scheduledActionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "GetScheduledAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("scheduledActionName" => scheduledActionName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_snapshot()
    get_snapshot(params::Dict{String,<:Any})

Returns information about a specific snapshot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ownerAccount"`: The owner Amazon Web Services account of a snapshot shared with another
  user.
- `"snapshotArn"`: The Amazon Resource Name (ARN) of the snapshot to return.
- `"snapshotName"`: The name of the snapshot to return.
"""
function get_snapshot(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "GetSnapshot"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_snapshot(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "GetSnapshot", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_table_restore_status(table_restore_request_id)
    get_table_restore_status(table_restore_request_id, params::Dict{String,<:Any})

Returns information about a TableRestoreStatus object.

# Arguments
- `table_restore_request_id`: The ID of the RestoreTableFromSnapshot request to return
  status for.

"""
function get_table_restore_status(
    tableRestoreRequestId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "GetTableRestoreStatus",
        Dict{String,Any}("tableRestoreRequestId" => tableRestoreRequestId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_table_restore_status(
    tableRestoreRequestId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "GetTableRestoreStatus",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("tableRestoreRequestId" => tableRestoreRequestId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_usage_limit(usage_limit_id)
    get_usage_limit(usage_limit_id, params::Dict{String,<:Any})

Returns information about a usage limit.

# Arguments
- `usage_limit_id`: The unique identifier of the usage limit to return information for.

"""
function get_usage_limit(usageLimitId; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "GetUsageLimit",
        Dict{String,Any}("usageLimitId" => usageLimitId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_usage_limit(
    usageLimitId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "GetUsageLimit",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("usageLimitId" => usageLimitId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_workgroup(workgroup_name)
    get_workgroup(workgroup_name, params::Dict{String,<:Any})

Returns information about a specific workgroup.

# Arguments
- `workgroup_name`: The name of the workgroup to return information for.

"""
function get_workgroup(workgroupName; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "GetWorkgroup",
        Dict{String,Any}("workgroupName" => workgroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_workgroup(
    workgroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "GetWorkgroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("workgroupName" => workgroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_custom_domain_associations()
    list_custom_domain_associations(params::Dict{String,<:Any})

 Lists custom domain associations for Amazon Redshift Serverless.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"customDomainCertificateArn"`: The custom domain name’s certificate Amazon resource
  name (ARN).
- `"customDomainName"`: The custom domain name associated with the workgroup.
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to display the next page of results.
- `"nextToken"`: When nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page.
"""
function list_custom_domain_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ListCustomDomainAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_custom_domain_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ListCustomDomainAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_endpoint_access()
    list_endpoint_access(params::Dict{String,<:Any})

Returns an array of EndpointAccess objects and relevant information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to display the next page of results.
- `"nextToken"`: If your initial ListEndpointAccess operation returns a nextToken, you can
  include the returned nextToken in following ListEndpointAccess operations, which returns
  results in the next page.
- `"ownerAccount"`: The owner Amazon Web Services account for the Amazon Redshift
  Serverless workgroup.
- `"vpcId"`: The unique identifier of the virtual private cloud with access to Amazon
  Redshift Serverless.
- `"workgroupName"`: The name of the workgroup associated with the VPC endpoint to return.
"""
function list_endpoint_access(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "ListEndpointAccess"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_endpoint_access(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ListEndpointAccess", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_namespaces()
    list_namespaces(params::Dict{String,<:Any})

Returns information about a list of specified namespaces.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to display the next page of results.
- `"nextToken"`: If your initial ListNamespaces operation returns a nextToken, you can
  include the returned nextToken in following ListNamespaces operations, which returns
  results in the next page.
"""
function list_namespaces(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "ListNamespaces"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_namespaces(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ListNamespaces", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_recovery_points()
    list_recovery_points(params::Dict{String,<:Any})

Returns an array of recovery points.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"endTime"`: The time when creation of the recovery point finished.
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to display the next page of results.
- `"namespaceArn"`: The Amazon Resource Name (ARN) of the namespace from which to list
  recovery points.
- `"namespaceName"`: The name of the namespace to list recovery points for.
- `"nextToken"`: If your initial ListRecoveryPoints operation returns a nextToken, you can
  include the returned nextToken in following ListRecoveryPoints operations, which returns
  results in the next page.
- `"startTime"`: The time when the recovery point's creation was initiated.
"""
function list_recovery_points(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "ListRecoveryPoints"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_recovery_points(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ListRecoveryPoints", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_scheduled_actions()
    list_scheduled_actions(params::Dict{String,<:Any})

Returns a list of scheduled actions. You can use the flags to filter the list of returned
scheduled actions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. Use nextToken to display the next page of results.
- `"namespaceName"`: The name of namespace associated with the scheduled action to retrieve.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page.
"""
function list_scheduled_actions(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "ListScheduledActions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_scheduled_actions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ListScheduledActions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_snapshot_copy_configurations()
    list_snapshot_copy_configurations(params::Dict{String,<:Any})

Returns a list of snapshot copy configurations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to display the next page of results.
- `"namespaceName"`: The namespace from which to list all snapshot copy configurations.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page.
"""
function list_snapshot_copy_configurations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ListSnapshotCopyConfigurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_snapshot_copy_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ListSnapshotCopyConfigurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_snapshots()
    list_snapshots(params::Dict{String,<:Any})

Returns a list of snapshots.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"endTime"`: The timestamp showing when the snapshot creation finished.
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to display the next page of results.
- `"namespaceArn"`: The Amazon Resource Name (ARN) of the namespace from which to list all
  snapshots.
- `"namespaceName"`: The namespace from which to list all snapshots.
- `"nextToken"`: If nextToken is returned, there are more results available. The value of
  nextToken is a unique pagination token for each page. Make the call again using the
  returned token to retrieve the next page.
- `"ownerAccount"`: The owner Amazon Web Services account of the snapshot.
- `"startTime"`: The time when the creation of the snapshot was initiated.
"""
function list_snapshots(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "ListSnapshots"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_snapshots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ListSnapshots", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_table_restore_status()
    list_table_restore_status(params::Dict{String,<:Any})

Returns information about an array of TableRestoreStatus objects.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to display the next page of results.
- `"namespaceName"`: The namespace from which to list all of the statuses of
  RestoreTableFromSnapshot operations .
- `"nextToken"`: If your initial ListTableRestoreStatus operation returns a nextToken, you
  can include the returned nextToken in following ListTableRestoreStatus operations. This
  will return results on the next page.
- `"workgroupName"`: The workgroup from which to list all of the statuses of
  RestoreTableFromSnapshot operations.
"""
function list_table_restore_status(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "ListTableRestoreStatus"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_table_restore_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ListTableRestoreStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags assigned to a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to list tags for.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ListTagsForResource",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_usage_limits()
    list_usage_limits(params::Dict{String,<:Any})

Lists all usage limits within Amazon Redshift Serverless.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results. The default is 100.
- `"nextToken"`: If your initial ListUsageLimits operation returns a nextToken, you can
  include the returned nextToken in following ListUsageLimits operations, which returns
  results in the next page.
- `"resourceArn"`: The Amazon Resource Name (ARN) associated with the resource whose usage
  limits you want to list.
- `"usageType"`: The Amazon Redshift Serverless feature whose limits you want to see.
"""
function list_usage_limits(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "ListUsageLimits"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_usage_limits(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ListUsageLimits", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_workgroups()
    list_workgroups(params::Dict{String,<:Any})

Returns information about a list of specified workgroups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to display the next page of results.
- `"nextToken"`: If your initial ListWorkgroups operation returns a nextToken, you can
  include the returned nextToken in following ListNamespaces operations, which returns
  results in the next page.
- `"ownerAccount"`: The owner Amazon Web Services account for the Amazon Redshift
  Serverless workgroup.
"""
function list_workgroups(; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "ListWorkgroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_workgroups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "ListWorkgroups", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    put_resource_policy(policy, resource_arn)
    put_resource_policy(policy, resource_arn, params::Dict{String,<:Any})

Creates or updates a resource policy. Currently, you can use policies to share snapshots
across Amazon Web Services accounts.

# Arguments
- `policy`: The policy to create or update. For example, the following policy grants a user
  authorization to restore a snapshot.  \"{\"Version\": \"2012-10-17\", \"Statement\" : [{
  \"Sid\": \"AllowUserRestoreFromSnapshot\", \"Principal\":{\"AWS\": [\"739247239426\"]},
  \"Action\": [\"redshift-serverless:RestoreFromSnapshot\"] , \"Effect\": \"Allow\" }]}\"
- `resource_arn`: The Amazon Resource Name (ARN) of the account to create or update a
  resource policy for.

"""
function put_resource_policy(
    policy, resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "PutResourcePolicy",
        Dict{String,Any}("policy" => policy, "resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_policy(
    policy,
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "PutResourcePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("policy" => policy, "resourceArn" => resourceArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_from_recovery_point(namespace_name, recovery_point_id, workgroup_name)
    restore_from_recovery_point(namespace_name, recovery_point_id, workgroup_name, params::Dict{String,<:Any})

Restore the data from a recovery point.

# Arguments
- `namespace_name`: The name of the namespace to restore data into.
- `recovery_point_id`: The unique identifier of the recovery point to restore from.
- `workgroup_name`: The name of the workgroup used to restore data.

"""
function restore_from_recovery_point(
    namespaceName,
    recoveryPointId,
    workgroupName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "RestoreFromRecoveryPoint",
        Dict{String,Any}(
            "namespaceName" => namespaceName,
            "recoveryPointId" => recoveryPointId,
            "workgroupName" => workgroupName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_from_recovery_point(
    namespaceName,
    recoveryPointId,
    workgroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "RestoreFromRecoveryPoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "namespaceName" => namespaceName,
                    "recoveryPointId" => recoveryPointId,
                    "workgroupName" => workgroupName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_from_snapshot(namespace_name, workgroup_name)
    restore_from_snapshot(namespace_name, workgroup_name, params::Dict{String,<:Any})

Restores a namespace from a snapshot.

# Arguments
- `namespace_name`: The name of the namespace to restore the snapshot to.
- `workgroup_name`: The name of the workgroup used to restore the snapshot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"adminPasswordSecretKmsKeyId"`: The ID of the Key Management Service (KMS) key used to
  encrypt and store the namespace's admin credentials secret.
- `"manageAdminPassword"`: If true, Amazon Redshift uses Secrets Manager to manage the
  restored snapshot's admin credentials. If MmanageAdminPassword is false or not set, Amazon
  Redshift uses the admin credentials that the namespace or cluster had at the time the
  snapshot was taken.
- `"ownerAccount"`: The Amazon Web Services account that owns the snapshot.
- `"snapshotArn"`: The Amazon Resource Name (ARN) of the snapshot to restore from. Required
  if restoring from Amazon Redshift Serverless to a provisioned cluster. Must not be
  specified at the same time as snapshotName. The format of the ARN is
  arn:aws:redshift:&lt;region&gt;:&lt;account_id&gt;:snapshot:&lt;cluster_identifier&gt;/&lt;s
  napshot_identifier&gt;.
- `"snapshotName"`: The name of the snapshot to restore from. Must not be specified at the
  same time as snapshotArn.
"""
function restore_from_snapshot(
    namespaceName, workgroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "RestoreFromSnapshot",
        Dict{String,Any}(
            "namespaceName" => namespaceName, "workgroupName" => workgroupName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_from_snapshot(
    namespaceName,
    workgroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "RestoreFromSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "namespaceName" => namespaceName, "workgroupName" => workgroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_table_from_recovery_point(namespace_name, new_table_name, recovery_point_id, source_database_name, source_table_name, workgroup_name)
    restore_table_from_recovery_point(namespace_name, new_table_name, recovery_point_id, source_database_name, source_table_name, workgroup_name, params::Dict{String,<:Any})

Restores a table from a recovery point to your Amazon Redshift Serverless instance. You
can't use this operation to restore tables with interleaved sort keys.

# Arguments
- `namespace_name`: Namespace of the recovery point to restore from.
- `new_table_name`: The name of the table to create from the restore operation.
- `recovery_point_id`: The ID of the recovery point to restore the table from.
- `source_database_name`: The name of the source database that contains the table being
  restored.
- `source_table_name`: The name of the source table being restored.
- `workgroup_name`: The workgroup to restore the table to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"activateCaseSensitiveIdentifier"`: Indicates whether name identifiers for database,
  schema, and table are case sensitive. If true, the names are case sensitive. If false, the
  names are not case sensitive. The default is false.
- `"sourceSchemaName"`: The name of the source schema that contains the table being
  restored.
- `"targetDatabaseName"`: The name of the database to restore the table to.
- `"targetSchemaName"`: The name of the schema to restore the table to.
"""
function restore_table_from_recovery_point(
    namespaceName,
    newTableName,
    recoveryPointId,
    sourceDatabaseName,
    sourceTableName,
    workgroupName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "RestoreTableFromRecoveryPoint",
        Dict{String,Any}(
            "namespaceName" => namespaceName,
            "newTableName" => newTableName,
            "recoveryPointId" => recoveryPointId,
            "sourceDatabaseName" => sourceDatabaseName,
            "sourceTableName" => sourceTableName,
            "workgroupName" => workgroupName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_table_from_recovery_point(
    namespaceName,
    newTableName,
    recoveryPointId,
    sourceDatabaseName,
    sourceTableName,
    workgroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "RestoreTableFromRecoveryPoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "namespaceName" => namespaceName,
                    "newTableName" => newTableName,
                    "recoveryPointId" => recoveryPointId,
                    "sourceDatabaseName" => sourceDatabaseName,
                    "sourceTableName" => sourceTableName,
                    "workgroupName" => workgroupName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_table_from_snapshot(namespace_name, new_table_name, snapshot_name, source_database_name, source_table_name, workgroup_name)
    restore_table_from_snapshot(namespace_name, new_table_name, snapshot_name, source_database_name, source_table_name, workgroup_name, params::Dict{String,<:Any})

Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can't use
this operation to restore tables with interleaved sort keys.

# Arguments
- `namespace_name`: The namespace of the snapshot to restore from.
- `new_table_name`: The name of the table to create from the restore operation.
- `snapshot_name`: The name of the snapshot to restore the table from.
- `source_database_name`: The name of the source database that contains the table being
  restored.
- `source_table_name`: The name of the source table being restored.
- `workgroup_name`: The workgroup to restore the table to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"activateCaseSensitiveIdentifier"`: Indicates whether name identifiers for database,
  schema, and table are case sensitive. If true, the names are case sensitive. If false, the
  names are not case sensitive. The default is false.
- `"sourceSchemaName"`: The name of the source schema that contains the table being
  restored.
- `"targetDatabaseName"`: The name of the database to restore the table to.
- `"targetSchemaName"`: The name of the schema to restore the table to.
"""
function restore_table_from_snapshot(
    namespaceName,
    newTableName,
    snapshotName,
    sourceDatabaseName,
    sourceTableName,
    workgroupName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "RestoreTableFromSnapshot",
        Dict{String,Any}(
            "namespaceName" => namespaceName,
            "newTableName" => newTableName,
            "snapshotName" => snapshotName,
            "sourceDatabaseName" => sourceDatabaseName,
            "sourceTableName" => sourceTableName,
            "workgroupName" => workgroupName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_table_from_snapshot(
    namespaceName,
    newTableName,
    snapshotName,
    sourceDatabaseName,
    sourceTableName,
    workgroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "RestoreTableFromSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "namespaceName" => namespaceName,
                    "newTableName" => newTableName,
                    "snapshotName" => snapshotName,
                    "sourceDatabaseName" => sourceDatabaseName,
                    "sourceTableName" => sourceTableName,
                    "workgroupName" => workgroupName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Assigns one or more tags to a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to tag.
- `tags`: The map of the key-value pairs used to tag the resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "TagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes a tag or set of tags from a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to remove tags from.
- `tag_keys`: The tag or set of tags to remove from the resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "UntagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_custom_domain_association(custom_domain_certificate_arn, custom_domain_name, workgroup_name)
    update_custom_domain_association(custom_domain_certificate_arn, custom_domain_name, workgroup_name, params::Dict{String,<:Any})

Updates an Amazon Redshift Serverless certificate associated with a custom domain.

# Arguments
- `custom_domain_certificate_arn`: The custom domain name’s certificate Amazon resource
  name (ARN). This is optional.
- `custom_domain_name`: The custom domain name associated with the workgroup.
- `workgroup_name`: The name of the workgroup associated with the database.

"""
function update_custom_domain_association(
    customDomainCertificateArn,
    customDomainName,
    workgroupName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "UpdateCustomDomainAssociation",
        Dict{String,Any}(
            "customDomainCertificateArn" => customDomainCertificateArn,
            "customDomainName" => customDomainName,
            "workgroupName" => workgroupName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_custom_domain_association(
    customDomainCertificateArn,
    customDomainName,
    workgroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "UpdateCustomDomainAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "customDomainCertificateArn" => customDomainCertificateArn,
                    "customDomainName" => customDomainName,
                    "workgroupName" => workgroupName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_endpoint_access(endpoint_name)
    update_endpoint_access(endpoint_name, params::Dict{String,<:Any})

Updates an Amazon Redshift Serverless managed endpoint.

# Arguments
- `endpoint_name`: The name of the VPC endpoint to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"vpcSecurityGroupIds"`: The list of VPC security groups associated with the endpoint
  after the endpoint is modified.
"""
function update_endpoint_access(
    endpointName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "UpdateEndpointAccess",
        Dict{String,Any}("endpointName" => endpointName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_endpoint_access(
    endpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "UpdateEndpointAccess",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("endpointName" => endpointName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_namespace(namespace_name)
    update_namespace(namespace_name, params::Dict{String,<:Any})

Updates a namespace with the specified settings. Unless required, you can't update multiple
parameters in one request. For example, you must specify both adminUsername and
adminUserPassword to update either field, but you can't update both kmsKeyId and logExports
in a single request.

# Arguments
- `namespace_name`: The name of the namespace to update. You can't update the name of a
  namespace once it is created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"adminPasswordSecretKmsKeyId"`: The ID of the Key Management Service (KMS) key used to
  encrypt and store the namespace's admin credentials secret. You can only use this parameter
  if manageAdminPassword is true.
- `"adminUserPassword"`: The password of the administrator for the first database created
  in the namespace. This parameter must be updated together with adminUsername. You can't use
  adminUserPassword if manageAdminPassword is true.
- `"adminUsername"`: The username of the administrator for the first database created in
  the namespace. This parameter must be updated together with adminUserPassword.
- `"defaultIamRoleArn"`: The Amazon Resource Name (ARN) of the IAM role to set as a default
  in the namespace. This parameter must be updated together with iamRoles.
- `"iamRoles"`: A list of IAM roles to associate with the namespace. This parameter must be
  updated together with defaultIamRoleArn.
- `"kmsKeyId"`: The ID of the Amazon Web Services Key Management Service key used to
  encrypt your data.
- `"logExports"`: The types of logs the namespace can export. The export types are userlog,
  connectionlog, and useractivitylog.
- `"manageAdminPassword"`: If true, Amazon Redshift uses Secrets Manager to manage the
  namespace's admin credentials. You can't use adminUserPassword if manageAdminPassword is
  true. If manageAdminPassword is false or not set, Amazon Redshift uses adminUserPassword
  for the admin user account's password.
"""
function update_namespace(namespaceName; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "UpdateNamespace",
        Dict{String,Any}("namespaceName" => namespaceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_namespace(
    namespaceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "UpdateNamespace",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("namespaceName" => namespaceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_scheduled_action(scheduled_action_name)
    update_scheduled_action(scheduled_action_name, params::Dict{String,<:Any})

Updates a scheduled action.

# Arguments
- `scheduled_action_name`: The name of the scheduled action to update to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"enabled"`: Specifies whether to enable the scheduled action.
- `"endTime"`: The end time in UTC of the scheduled action to update.
- `"roleArn"`: The ARN of the IAM role to assume to run the scheduled action. This IAM role
  must have permission to run the Amazon Redshift Serverless API operation in the scheduled
  action. This IAM role must allow the Amazon Redshift scheduler to schedule creating
  snapshots (Principal scheduler.redshift.amazonaws.com) to assume permissions on your
  behalf. For more information about the IAM role to use with the Amazon Redshift scheduler,
  see Using Identity-Based Policies for Amazon Redshift in the Amazon Redshift Cluster
  Management Guide
- `"schedule"`: The schedule for a one-time (at timestamp format) or recurring (cron
  format) scheduled action. Schedule invocations must be separated by at least one hour.
  Times are in UTC.   Format of at timestamp is yyyy-mm-ddThh:mm:ss. For example,
  2016-03-04T17:27:00.   Format of cron expression is (Minutes Hours Day-of-month Month
  Day-of-week Year). For example, \"(0 10 ? * MON *)\". For more information, see Cron
  Expressions in the Amazon CloudWatch Events User Guide.
- `"scheduledActionDescription"`: The descripion of the scheduled action to update to.
- `"startTime"`: The start time in UTC of the scheduled action to update to.
- `"targetAction"`:
"""
function update_scheduled_action(
    scheduledActionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "UpdateScheduledAction",
        Dict{String,Any}("scheduledActionName" => scheduledActionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_scheduled_action(
    scheduledActionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "UpdateScheduledAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("scheduledActionName" => scheduledActionName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_snapshot(snapshot_name)
    update_snapshot(snapshot_name, params::Dict{String,<:Any})

Updates a snapshot.

# Arguments
- `snapshot_name`: The name of the snapshot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"retentionPeriod"`: The new retention period of the snapshot.
"""
function update_snapshot(snapshotName; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "UpdateSnapshot",
        Dict{String,Any}("snapshotName" => snapshotName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_snapshot(
    snapshotName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "UpdateSnapshot",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("snapshotName" => snapshotName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_snapshot_copy_configuration(snapshot_copy_configuration_id)
    update_snapshot_copy_configuration(snapshot_copy_configuration_id, params::Dict{String,<:Any})

Updates a snapshot copy configuration.

# Arguments
- `snapshot_copy_configuration_id`: The ID of the snapshot copy configuration to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"snapshotRetentionPeriod"`: The new retention period of how long to keep a snapshot in
  the destination Amazon Web Services Region.
"""
function update_snapshot_copy_configuration(
    snapshotCopyConfigurationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "UpdateSnapshotCopyConfiguration",
        Dict{String,Any}("snapshotCopyConfigurationId" => snapshotCopyConfigurationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_snapshot_copy_configuration(
    snapshotCopyConfigurationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "UpdateSnapshotCopyConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "snapshotCopyConfigurationId" => snapshotCopyConfigurationId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_usage_limit(usage_limit_id)
    update_usage_limit(usage_limit_id, params::Dict{String,<:Any})

Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or
period of a usage limit.

# Arguments
- `usage_limit_id`: The identifier of the usage limit to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"amount"`: The new limit amount. If time-based, this amount is in Redshift Processing
  Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data
  transferred between Regions in cross-account sharing. The value must be a positive number.
- `"breachAction"`: The new action that Amazon Redshift Serverless takes when the limit is
  reached.
"""
function update_usage_limit(
    usageLimitId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return redshift_serverless(
        "UpdateUsageLimit",
        Dict{String,Any}("usageLimitId" => usageLimitId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_usage_limit(
    usageLimitId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "UpdateUsageLimit",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("usageLimitId" => usageLimitId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_workgroup(workgroup_name)
    update_workgroup(workgroup_name, params::Dict{String,<:Any})

Updates a workgroup with the specified configuration settings. You can't update multiple
parameters in one request. For example, you can update baseCapacity or port in a single
request, but you can't update both in the same request.

# Arguments
- `workgroup_name`: The name of the workgroup to update. You can't update the name of a
  workgroup once it is created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"baseCapacity"`: The new base data warehouse capacity in Redshift Processing Units
  (RPUs).
- `"configParameters"`: An array of parameters to set for advanced control over a database.
  The options are auto_mv, datestyle, enable_case_sensitive_identifier,
  enable_user_activity_logging, query_group, search_path, require_ssl, use_fips_ssl, and
  query monitoring metrics that let you define performance boundaries. For more information
  about query monitoring rules and available metrics, see  Query monitoring metrics for
  Amazon Redshift Serverless.
- `"enhancedVpcRouting"`: The value that specifies whether to turn on enhanced virtual
  private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic
  through your VPC.
- `"maxCapacity"`: The maximum data-warehouse capacity Amazon Redshift Serverless uses to
  serve queries. The max capacity is specified in RPUs.
- `"port"`: The custom port to use when connecting to a workgroup. Valid port ranges are
  5431-5455 and 8191-8215. The default is 5439.
- `"publiclyAccessible"`: A value that specifies whether the workgroup can be accessible
  from a public network.
- `"securityGroupIds"`: An array of security group IDs to associate with the workgroup.
- `"subnetIds"`: An array of VPC subnet IDs to associate with the workgroup.
"""
function update_workgroup(workgroupName; aws_config::AbstractAWSConfig=current_aws_config())
    return redshift_serverless(
        "UpdateWorkgroup",
        Dict{String,Any}("workgroupName" => workgroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_workgroup(
    workgroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return redshift_serverless(
        "UpdateWorkgroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("workgroupName" => workgroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
