# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: ssm_contacts
using AWS.Compat
using AWS.UUIDs

"""
    accept_page(accept_code, accept_type, page_id)
    accept_page(accept_code, accept_type, page_id, params::Dict{String,<:Any})

Used to acknowledge an engagement to a contact channel during an incident.

# Arguments
- `accept_code`: A 6-digit code used to acknowledge the page.
- `accept_type`: The type indicates if the page was DELIVERED or READ.
- `page_id`: The Amazon Resource Name (ARN) of the engagement to a contact channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AcceptCodeValidation"`: An optional field that Incident Manager uses to ENFORCE
  AcceptCode validation when acknowledging an page. Acknowledgement can occur by replying to
  a page, or when entering the AcceptCode in the console. Enforcing AcceptCode validation
  causes Incident Manager to verify that the code entered by the user matches the code sent
  by Incident Manager with the page. Incident Manager can also IGNORE AcceptCode validation.
  Ignoring AcceptCode validation causes Incident Manager to accept any value entered for the
  AcceptCode.
- `"ContactChannelId"`: The ARN of the contact channel.
- `"Note"`: Information provided by the user when the user acknowledges the page.
"""
function accept_page(
    AcceptCode, AcceptType, PageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "AcceptPage",
        Dict{String,Any}(
            "AcceptCode" => AcceptCode, "AcceptType" => AcceptType, "PageId" => PageId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_page(
    AcceptCode,
    AcceptType,
    PageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "AcceptPage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AcceptCode" => AcceptCode,
                    "AcceptType" => AcceptType,
                    "PageId" => PageId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    activate_contact_channel(activation_code, contact_channel_id)
    activate_contact_channel(activation_code, contact_channel_id, params::Dict{String,<:Any})

Activates a contact's contact channel. Incident Manager can't engage a contact until the
contact channel has been activated.

# Arguments
- `activation_code`: The code sent to the contact channel when it was created in the
  contact.
- `contact_channel_id`: The Amazon Resource Name (ARN) of the contact channel.

"""
function activate_contact_channel(
    ActivationCode, ContactChannelId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "ActivateContactChannel",
        Dict{String,Any}(
            "ActivationCode" => ActivationCode, "ContactChannelId" => ContactChannelId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function activate_contact_channel(
    ActivationCode,
    ContactChannelId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "ActivateContactChannel",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ActivationCode" => ActivationCode,
                    "ContactChannelId" => ContactChannelId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_contact(alias, plan, type)
    create_contact(alias, plan, type, params::Dict{String,<:Any})

Contacts are either the contacts that Incident Manager engages during an incident or the
escalation plans that Incident Manager uses to engage contacts in phases during an incident.

# Arguments
- `alias`: The short name to quickly identify a contact or escalation plan. The contact
  alias must be unique and identifiable.
- `plan`: A list of stages. A contact has an engagement plan with stages that contact
  specified contact channels. An escalation plan uses stages that contact specified contacts.
- `type`: To create an escalation plan use ESCALATION. To create a contact use PERSONAL.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DisplayName"`: The full name of the contact or escalation plan.
- `"IdempotencyToken"`: A token ensuring that the operation is called only once with the
  specified details.
- `"Tags"`: Adds a tag to the target. You can only tag resources created in the first
  Region of your replication set.
"""
function create_contact(
    Alias, Plan, Type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "CreateContact",
        Dict{String,Any}(
            "Alias" => Alias,
            "Plan" => Plan,
            "Type" => Type,
            "IdempotencyToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_contact(
    Alias,
    Plan,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "CreateContact",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Alias" => Alias,
                    "Plan" => Plan,
                    "Type" => Type,
                    "IdempotencyToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_contact_channel(contact_id, delivery_address, name, type)
    create_contact_channel(contact_id, delivery_address, name, type, params::Dict{String,<:Any})

A contact channel is the method that Incident Manager uses to engage your contact.

# Arguments
- `contact_id`: The Amazon Resource Name (ARN) of the contact you are adding the contact
  channel to.
- `delivery_address`: The details that Incident Manager uses when trying to engage the
  contact channel. The format is dependent on the type of the contact channel. The following
  are the expected formats:   SMS - '+' followed by the country code and phone number   VOICE
  - '+' followed by the country code and phone number   EMAIL - any standard email format
- `name`: The name of the contact channel.
- `type`: Incident Manager supports three types of contact channels:    SMS     VOICE
  EMAIL

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeferActivation"`: If you want to activate the channel at a later time, you can choose
  to defer activation. Incident Manager can't engage your contact channel until it has been
  activated.
- `"IdempotencyToken"`: A token ensuring that the operation is called only once with the
  specified details.
"""
function create_contact_channel(
    ContactId,
    DeliveryAddress,
    Name,
    Type;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "CreateContactChannel",
        Dict{String,Any}(
            "ContactId" => ContactId,
            "DeliveryAddress" => DeliveryAddress,
            "Name" => Name,
            "Type" => Type,
            "IdempotencyToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_contact_channel(
    ContactId,
    DeliveryAddress,
    Name,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "CreateContactChannel",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ContactId" => ContactId,
                    "DeliveryAddress" => DeliveryAddress,
                    "Name" => Name,
                    "Type" => Type,
                    "IdempotencyToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_rotation(contact_ids, name, recurrence, time_zone_id)
    create_rotation(contact_ids, name, recurrence, time_zone_id, params::Dict{String,<:Any})

Creates a rotation in an on-call schedule.

# Arguments
- `contact_ids`: The Amazon Resource Names (ARNs) of the contacts to add to the rotation.
  The order that you list the contacts in is their shift order in the rotation schedule. To
  change the order of the contact's shifts, use the UpdateRotation operation.
- `name`: The name of the rotation.
- `recurrence`: Information about the rule that specifies when a shift's team members
  rotate.
- `time_zone_id`: The time zone to base the rotation’s activity on in Internet Assigned
  Numbers Authority (IANA) format. For example: \"America/Los_Angeles\", \"UTC\", or
  \"Asia/Seoul\". For more information, see the Time Zone Database on the IANA website.
  Designators for time zones that don’t support Daylight Savings Time rules, such as
  Pacific Standard Time (PST) and Pacific Daylight Time (PDT), are not supported.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IdempotencyToken"`: A token that ensures that the operation is called only once with
  the specified details.
- `"StartTime"`: The date and time that the rotation goes into effect.
- `"Tags"`: Optional metadata to assign to the rotation. Tags enable you to categorize a
  resource in different ways, such as by purpose, owner, or environment. For more
  information, see Tagging Incident Manager resources in the Incident Manager User Guide.
"""
function create_rotation(
    ContactIds,
    Name,
    Recurrence,
    TimeZoneId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "CreateRotation",
        Dict{String,Any}(
            "ContactIds" => ContactIds,
            "Name" => Name,
            "Recurrence" => Recurrence,
            "TimeZoneId" => TimeZoneId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_rotation(
    ContactIds,
    Name,
    Recurrence,
    TimeZoneId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "CreateRotation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ContactIds" => ContactIds,
                    "Name" => Name,
                    "Recurrence" => Recurrence,
                    "TimeZoneId" => TimeZoneId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_rotation_override(end_time, new_contact_ids, rotation_id, start_time)
    create_rotation_override(end_time, new_contact_ids, rotation_id, start_time, params::Dict{String,<:Any})

Creates an override for a rotation in an on-call schedule.

# Arguments
- `end_time`: The date and time when the override ends.
- `new_contact_ids`: The Amazon Resource Names (ARNs) of the contacts to replace those in
  the current on-call rotation with. If you want to include any current team members in the
  override shift, you must include their ARNs in the new contact ID list.
- `rotation_id`: The Amazon Resource Name (ARN) of the rotation to create an override for.
- `start_time`: The date and time when the override goes into effect.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IdempotencyToken"`: A token that ensures that the operation is called only once with
  the specified details.
"""
function create_rotation_override(
    EndTime,
    NewContactIds,
    RotationId,
    StartTime;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "CreateRotationOverride",
        Dict{String,Any}(
            "EndTime" => EndTime,
            "NewContactIds" => NewContactIds,
            "RotationId" => RotationId,
            "StartTime" => StartTime,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_rotation_override(
    EndTime,
    NewContactIds,
    RotationId,
    StartTime,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "CreateRotationOverride",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EndTime" => EndTime,
                    "NewContactIds" => NewContactIds,
                    "RotationId" => RotationId,
                    "StartTime" => StartTime,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deactivate_contact_channel(contact_channel_id)
    deactivate_contact_channel(contact_channel_id, params::Dict{String,<:Any})

To no longer receive Incident Manager engagements to a contact channel, you can deactivate
the channel.

# Arguments
- `contact_channel_id`: The Amazon Resource Name (ARN) of the contact channel you're
  deactivating.

"""
function deactivate_contact_channel(
    ContactChannelId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "DeactivateContactChannel",
        Dict{String,Any}("ContactChannelId" => ContactChannelId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deactivate_contact_channel(
    ContactChannelId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "DeactivateContactChannel",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ContactChannelId" => ContactChannelId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_contact(contact_id)
    delete_contact(contact_id, params::Dict{String,<:Any})

To remove a contact from Incident Manager, you can delete the contact. Deleting a contact
removes them from all escalation plans and related response plans. Deleting an escalation
plan removes it from all related response plans. You will have to recreate the contact and
its contact channels before you can use it again.

# Arguments
- `contact_id`: The Amazon Resource Name (ARN) of the contact that you're deleting.

"""
function delete_contact(ContactId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "DeleteContact",
        Dict{String,Any}("ContactId" => ContactId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_contact(
    ContactId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "DeleteContact",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContactId" => ContactId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_contact_channel(contact_channel_id)
    delete_contact_channel(contact_channel_id, params::Dict{String,<:Any})

To no longer receive engagements on a contact channel, you can delete the channel from a
contact. Deleting the contact channel removes it from the contact's engagement plan. If you
delete the only contact channel for a contact, you won't be able to engage that contact
during an incident.

# Arguments
- `contact_channel_id`: The Amazon Resource Name (ARN) of the contact channel.

"""
function delete_contact_channel(
    ContactChannelId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "DeleteContactChannel",
        Dict{String,Any}("ContactChannelId" => ContactChannelId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_contact_channel(
    ContactChannelId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "DeleteContactChannel",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ContactChannelId" => ContactChannelId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_rotation(rotation_id)
    delete_rotation(rotation_id, params::Dict{String,<:Any})

Deletes a rotation from the system. If a rotation belongs to more than one on-call
schedule, this operation deletes it from all of them.

# Arguments
- `rotation_id`: The Amazon Resource Name (ARN) of the on-call rotation to delete.

"""
function delete_rotation(RotationId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "DeleteRotation",
        Dict{String,Any}("RotationId" => RotationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_rotation(
    RotationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "DeleteRotation",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RotationId" => RotationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_rotation_override(rotation_id, rotation_override_id)
    delete_rotation_override(rotation_id, rotation_override_id, params::Dict{String,<:Any})

Deletes an existing override for an on-call rotation.

# Arguments
- `rotation_id`: The Amazon Resource Name (ARN) of the rotation that was overridden.
- `rotation_override_id`: The Amazon Resource Name (ARN) of the on-call rotation override
  to delete.

"""
function delete_rotation_override(
    RotationId, RotationOverrideId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "DeleteRotationOverride",
        Dict{String,Any}(
            "RotationId" => RotationId, "RotationOverrideId" => RotationOverrideId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_rotation_override(
    RotationId,
    RotationOverrideId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "DeleteRotationOverride",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "RotationId" => RotationId, "RotationOverrideId" => RotationOverrideId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_engagement(engagement_id)
    describe_engagement(engagement_id, params::Dict{String,<:Any})

Incident Manager uses engagements to engage contacts and escalation plans during an
incident. Use this command to describe the engagement that occurred during an incident.

# Arguments
- `engagement_id`: The Amazon Resource Name (ARN) of the engagement you want the details of.

"""
function describe_engagement(
    EngagementId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "DescribeEngagement",
        Dict{String,Any}("EngagementId" => EngagementId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_engagement(
    EngagementId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "DescribeEngagement",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EngagementId" => EngagementId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_page(page_id)
    describe_page(page_id, params::Dict{String,<:Any})

Lists details of the engagement to a contact channel.

# Arguments
- `page_id`: The ID of the engagement to a contact channel.

"""
function describe_page(PageId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "DescribePage",
        Dict{String,Any}("PageId" => PageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_page(
    PageId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "DescribePage",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("PageId" => PageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_contact(contact_id)
    get_contact(contact_id, params::Dict{String,<:Any})

Retrieves information about the specified contact or escalation plan.

# Arguments
- `contact_id`: The Amazon Resource Name (ARN) of the contact or escalation plan.

"""
function get_contact(ContactId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "GetContact",
        Dict{String,Any}("ContactId" => ContactId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_contact(
    ContactId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "GetContact",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContactId" => ContactId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_contact_channel(contact_channel_id)
    get_contact_channel(contact_channel_id, params::Dict{String,<:Any})

List details about a specific contact channel.

# Arguments
- `contact_channel_id`: The Amazon Resource Name (ARN) of the contact channel you want
  information about.

"""
function get_contact_channel(
    ContactChannelId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "GetContactChannel",
        Dict{String,Any}("ContactChannelId" => ContactChannelId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_contact_channel(
    ContactChannelId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "GetContactChannel",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ContactChannelId" => ContactChannelId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_contact_policy(contact_arn)
    get_contact_policy(contact_arn, params::Dict{String,<:Any})

Retrieves the resource policies attached to the specified contact or escalation plan.

# Arguments
- `contact_arn`: The Amazon Resource Name (ARN) of the contact or escalation plan.

"""
function get_contact_policy(ContactArn; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "GetContactPolicy",
        Dict{String,Any}("ContactArn" => ContactArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_contact_policy(
    ContactArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "GetContactPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContactArn" => ContactArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_rotation(rotation_id)
    get_rotation(rotation_id, params::Dict{String,<:Any})

Retrieves information about an on-call rotation.

# Arguments
- `rotation_id`: The Amazon Resource Name (ARN) of the on-call rotation to retrieve
  information about.

"""
function get_rotation(RotationId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "GetRotation",
        Dict{String,Any}("RotationId" => RotationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_rotation(
    RotationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "GetRotation",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("RotationId" => RotationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_rotation_override(rotation_id, rotation_override_id)
    get_rotation_override(rotation_id, rotation_override_id, params::Dict{String,<:Any})

Retrieves information about an override to an on-call rotation.

# Arguments
- `rotation_id`: The Amazon Resource Name (ARN) of the overridden rotation to retrieve
  information about.
- `rotation_override_id`: The Amazon Resource Name (ARN) of the on-call rotation override
  to retrieve information about.

"""
function get_rotation_override(
    RotationId, RotationOverrideId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "GetRotationOverride",
        Dict{String,Any}(
            "RotationId" => RotationId, "RotationOverrideId" => RotationOverrideId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_rotation_override(
    RotationId,
    RotationOverrideId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "GetRotationOverride",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "RotationId" => RotationId, "RotationOverrideId" => RotationOverrideId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_contact_channels(contact_id)
    list_contact_channels(contact_id, params::Dict{String,<:Any})

Lists all contact channels for the specified contact.

# Arguments
- `contact_id`: The Amazon Resource Name (ARN) of the contact.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of contact channels per page.
- `"NextToken"`: The pagination token to continue to the next page of results.
"""
function list_contact_channels(
    ContactId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "ListContactChannels",
        Dict{String,Any}("ContactId" => ContactId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_contact_channels(
    ContactId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "ListContactChannels",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContactId" => ContactId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_contacts()
    list_contacts(params::Dict{String,<:Any})

Lists all contacts and escalation plans in Incident Manager.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AliasPrefix"`: Used to list only contacts who's aliases start with the specified prefix.
- `"MaxResults"`: The maximum number of contacts and escalation plans per page of results.
- `"NextToken"`: The pagination token to continue to the next page of results.
- `"Type"`: The type of contact. A contact is type PERSONAL and an escalation plan is type
  ESCALATION.
"""
function list_contacts(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "ListContacts"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_contacts(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "ListContacts", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_engagements()
    list_engagements(params::Dict{String,<:Any})

Lists all engagements that have happened in an incident.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IncidentId"`: The Amazon Resource Name (ARN) of the incident you're listing engagements
  for.
- `"MaxResults"`: The maximum number of engagements per page of results.
- `"NextToken"`: The pagination token to continue to the next page of results.
- `"TimeRangeValue"`: The time range to lists engagements for an incident.
"""
function list_engagements(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "ListEngagements"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_engagements(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "ListEngagements", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_page_receipts(page_id)
    list_page_receipts(page_id, params::Dict{String,<:Any})

Lists all of the engagements to contact channels that have been acknowledged.

# Arguments
- `page_id`: The Amazon Resource Name (ARN) of the engagement to a specific contact channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of acknowledgements per page of results.
- `"NextToken"`: The pagination token to continue to the next page of results.
"""
function list_page_receipts(PageId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "ListPageReceipts",
        Dict{String,Any}("PageId" => PageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_page_receipts(
    PageId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "ListPageReceipts",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("PageId" => PageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_page_resolutions(page_id)
    list_page_resolutions(page_id, params::Dict{String,<:Any})

Returns the resolution path of an engagement. For example, the escalation plan engaged in
an incident might target an on-call schedule that includes several contacts in a rotation,
but just one contact on-call when the incident starts. The resolution path indicates the
hierarchy of escalation plan &gt; on-call schedule &gt; contact.

# Arguments
- `page_id`: The Amazon Resource Name (ARN) of the contact engaged for the incident.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
"""
function list_page_resolutions(PageId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "ListPageResolutions",
        Dict{String,Any}("PageId" => PageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_page_resolutions(
    PageId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "ListPageResolutions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("PageId" => PageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_pages_by_contact(contact_id)
    list_pages_by_contact(contact_id, params::Dict{String,<:Any})

Lists the engagements to a contact's contact channels.

# Arguments
- `contact_id`: The Amazon Resource Name (ARN) of the contact you are retrieving
  engagements for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of engagements to contact channels to list per page of
  results.
- `"NextToken"`: The pagination token to continue to the next page of results.
"""
function list_pages_by_contact(
    ContactId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "ListPagesByContact",
        Dict{String,Any}("ContactId" => ContactId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_pages_by_contact(
    ContactId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "ListPagesByContact",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContactId" => ContactId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_pages_by_engagement(engagement_id)
    list_pages_by_engagement(engagement_id, params::Dict{String,<:Any})

Lists the engagements to contact channels that occurred by engaging a contact.

# Arguments
- `engagement_id`: The Amazon Resource Name (ARN) of the engagement.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of engagements to contact channels to list per page of
  results.
- `"NextToken"`: The pagination token to continue to the next page of results.
"""
function list_pages_by_engagement(
    EngagementId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "ListPagesByEngagement",
        Dict{String,Any}("EngagementId" => EngagementId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_pages_by_engagement(
    EngagementId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "ListPagesByEngagement",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EngagementId" => EngagementId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_preview_rotation_shifts(end_time, members, recurrence, time_zone_id)
    list_preview_rotation_shifts(end_time, members, recurrence, time_zone_id, params::Dict{String,<:Any})

Returns a list of shifts based on rotation configuration parameters.  The Incident Manager
primarily uses this operation to populate the Preview calendar. It is not typically run by
end users.

# Arguments
- `end_time`: The date and time a rotation shift would end.
- `members`: The contacts that would be assigned to a rotation.
- `recurrence`: Information about how long a rotation would last before restarting at the
  beginning of the shift order.
- `time_zone_id`: The time zone the rotation’s activity would be based on, in Internet
  Assigned Numbers Authority (IANA) format. For example: \"America/Los_Angeles\", \"UTC\", or
  \"Asia/Seoul\".

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that can be specified in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. This token is used to get the next set of
  results.
- `"Overrides"`: Information about changes that would be made in a rotation override.
- `"RotationStartTime"`: The date and time a rotation would begin. The first shift is
  calculated from this date and time.
- `"StartTime"`: Used to filter the range of calculated shifts before sending the response
  back to the user.
"""
function list_preview_rotation_shifts(
    EndTime,
    Members,
    Recurrence,
    TimeZoneId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "ListPreviewRotationShifts",
        Dict{String,Any}(
            "EndTime" => EndTime,
            "Members" => Members,
            "Recurrence" => Recurrence,
            "TimeZoneId" => TimeZoneId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_preview_rotation_shifts(
    EndTime,
    Members,
    Recurrence,
    TimeZoneId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "ListPreviewRotationShifts",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EndTime" => EndTime,
                    "Members" => Members,
                    "Recurrence" => Recurrence,
                    "TimeZoneId" => TimeZoneId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_rotation_overrides(end_time, rotation_id, start_time)
    list_rotation_overrides(end_time, rotation_id, start_time, params::Dict{String,<:Any})

Retrieves a list of overrides currently specified for an on-call rotation.

# Arguments
- `end_time`: The date and time for the end of a time range for listing overrides.
- `rotation_id`: The Amazon Resource Name (ARN) of the rotation to retrieve information
  about.
- `start_time`: The date and time for the beginning of a time range for listing overrides.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
"""
function list_rotation_overrides(
    EndTime, RotationId, StartTime; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "ListRotationOverrides",
        Dict{String,Any}(
            "EndTime" => EndTime, "RotationId" => RotationId, "StartTime" => StartTime
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_rotation_overrides(
    EndTime,
    RotationId,
    StartTime,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "ListRotationOverrides",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EndTime" => EndTime,
                    "RotationId" => RotationId,
                    "StartTime" => StartTime,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_rotation_shifts(end_time, rotation_id)
    list_rotation_shifts(end_time, rotation_id, params::Dict{String,<:Any})

Returns a list of shifts generated by an existing rotation in the system.

# Arguments
- `end_time`: The date and time for the end of the time range to list shifts for.
- `rotation_id`: The Amazon Resource Name (ARN) of the rotation to retrieve shift
  information about.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
- `"StartTime"`: The date and time for the beginning of the time range to list shifts for.
"""
function list_rotation_shifts(
    EndTime, RotationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "ListRotationShifts",
        Dict{String,Any}("EndTime" => EndTime, "RotationId" => RotationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_rotation_shifts(
    EndTime,
    RotationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "ListRotationShifts",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("EndTime" => EndTime, "RotationId" => RotationId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_rotations()
    list_rotations(params::Dict{String,<:Any})

Retrieves a list of on-call rotations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this call. The call also
  returns a token that you can specify in a subsequent call to get the next set of results.
- `"NextToken"`: A token to start the list. Use this token to get the next set of results.
- `"RotationNamePrefix"`: A filter to include rotations in list results based on their
  common prefix. For example, entering prod returns a list of all rotation names that begin
  with prod, such as production and prod-1.
"""
function list_rotations(; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "ListRotations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_rotations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "ListRotations", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags of an escalation plan or contact.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the contact or escalation plan.

"""
function list_tags_for_resource(
    ResourceARN; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "ListTagsForResource",
        Dict{String,Any}("ResourceARN" => ResourceARN);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceARN,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceARN" => ResourceARN), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_contact_policy(contact_arn, policy)
    put_contact_policy(contact_arn, policy, params::Dict{String,<:Any})

Adds a resource policy to the specified contact or escalation plan. The resource policy is
used to share the contact or escalation plan using Resource Access Manager (RAM). For more
information about cross-account sharing, see Setting up cross-account functionality.

# Arguments
- `contact_arn`: The Amazon Resource Name (ARN) of the contact or escalation plan.
- `policy`: Details of the resource policy.

"""
function put_contact_policy(
    ContactArn, Policy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "PutContactPolicy",
        Dict{String,Any}("ContactArn" => ContactArn, "Policy" => Policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_contact_policy(
    ContactArn,
    Policy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "PutContactPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ContactArn" => ContactArn, "Policy" => Policy),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_activation_code(contact_channel_id)
    send_activation_code(contact_channel_id, params::Dict{String,<:Any})

Sends an activation code to a contact channel. The contact can use this code to activate
the contact channel in the console or with the ActivateChannel operation. Incident Manager
can't engage a contact channel until it has been activated.

# Arguments
- `contact_channel_id`: The Amazon Resource Name (ARN) of the contact channel.

"""
function send_activation_code(
    ContactChannelId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "SendActivationCode",
        Dict{String,Any}("ContactChannelId" => ContactChannelId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_activation_code(
    ContactChannelId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "SendActivationCode",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ContactChannelId" => ContactChannelId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_engagement(contact_id, content, sender, subject)
    start_engagement(contact_id, content, sender, subject, params::Dict{String,<:Any})

Starts an engagement to a contact or escalation plan. The engagement engages each contact
specified in the incident.

# Arguments
- `contact_id`: The Amazon Resource Name (ARN) of the contact being engaged.
- `content`: The secure content of the message that was sent to the contact. Use this field
  for engagements to VOICE or EMAIL.
- `sender`: The user that started the engagement.
- `subject`: The secure subject of the message that was sent to the contact. Use this field
  for engagements to VOICE or EMAIL.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IdempotencyToken"`: A token ensuring that the operation is called only once with the
  specified details.
- `"IncidentId"`: The ARN of the incident that the engagement is part of.
- `"PublicContent"`: The insecure content of the message that was sent to the contact. Use
  this field for engagements to SMS.
- `"PublicSubject"`: The insecure subject of the message that was sent to the contact. Use
  this field for engagements to SMS.
"""
function start_engagement(
    ContactId, Content, Sender, Subject; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "StartEngagement",
        Dict{String,Any}(
            "ContactId" => ContactId,
            "Content" => Content,
            "Sender" => Sender,
            "Subject" => Subject,
            "IdempotencyToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_engagement(
    ContactId,
    Content,
    Sender,
    Subject,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "StartEngagement",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ContactId" => ContactId,
                    "Content" => Content,
                    "Sender" => Sender,
                    "Subject" => Subject,
                    "IdempotencyToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_engagement(engagement_id)
    stop_engagement(engagement_id, params::Dict{String,<:Any})

Stops an engagement before it finishes the final stage of the escalation plan or engagement
plan. Further contacts aren't engaged.

# Arguments
- `engagement_id`: The Amazon Resource Name (ARN) of the engagement.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Reason"`: The reason that you're stopping the engagement.
"""
function stop_engagement(EngagementId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "StopEngagement",
        Dict{String,Any}("EngagementId" => EngagementId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_engagement(
    EngagementId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "StopEngagement",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EngagementId" => EngagementId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Tags a contact or escalation plan. You can tag only contacts and escalation plans in the
first region of your replication set.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the contact or escalation plan.
- `tags`: A list of tags that you are adding to the contact or escalation plan.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "TagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the contact or escalation plan.
- `tag_keys`: The key of the tag that you want to remove.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "UntagResource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_contact(contact_id)
    update_contact(contact_id, params::Dict{String,<:Any})

Updates the contact or escalation plan specified.

# Arguments
- `contact_id`: The Amazon Resource Name (ARN) of the contact or escalation plan you're
  updating.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DisplayName"`: The full name of the contact or escalation plan.
- `"Plan"`: A list of stages. A contact has an engagement plan with stages for specified
  contact channels. An escalation plan uses these stages to contact specified contacts.
"""
function update_contact(ContactId; aws_config::AbstractAWSConfig=current_aws_config())
    return ssm_contacts(
        "UpdateContact",
        Dict{String,Any}("ContactId" => ContactId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_contact(
    ContactId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "UpdateContact",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContactId" => ContactId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_contact_channel(contact_channel_id)
    update_contact_channel(contact_channel_id, params::Dict{String,<:Any})

Updates a contact's contact channel.

# Arguments
- `contact_channel_id`: The Amazon Resource Name (ARN) of the contact channel you want to
  update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeliveryAddress"`: The details that Incident Manager uses when trying to engage the
  contact channel.
- `"Name"`: The name of the contact channel.
"""
function update_contact_channel(
    ContactChannelId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "UpdateContactChannel",
        Dict{String,Any}("ContactChannelId" => ContactChannelId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_contact_channel(
    ContactChannelId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "UpdateContactChannel",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ContactChannelId" => ContactChannelId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_rotation(recurrence, rotation_id)
    update_rotation(recurrence, rotation_id, params::Dict{String,<:Any})

Updates the information specified for an on-call rotation.

# Arguments
- `recurrence`: Information about how long the updated rotation lasts before restarting at
  the beginning of the shift order.
- `rotation_id`: The Amazon Resource Name (ARN) of the rotation to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ContactIds"`: The Amazon Resource Names (ARNs) of the contacts to include in the
  updated rotation.  The order in which you list the contacts is their shift order in the
  rotation schedule.
- `"StartTime"`: The date and time the rotation goes into effect.
- `"TimeZoneId"`: The time zone to base the updated rotation’s activity on, in Internet
  Assigned Numbers Authority (IANA) format. For example: \"America/Los_Angeles\", \"UTC\", or
  \"Asia/Seoul\". For more information, see the Time Zone Database on the IANA website.
  Designators for time zones that don’t support Daylight Savings Time Rules, such as
  Pacific Standard Time (PST) and Pacific Daylight Time (PDT), aren't supported.
"""
function update_rotation(
    Recurrence, RotationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ssm_contacts(
        "UpdateRotation",
        Dict{String,Any}("Recurrence" => Recurrence, "RotationId" => RotationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_rotation(
    Recurrence,
    RotationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ssm_contacts(
        "UpdateRotation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Recurrence" => Recurrence, "RotationId" => RotationId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
