# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: swf
using AWS.Compat
using AWS.UUIDs

"""
    count_closed_workflow_executions(domain)
    count_closed_workflow_executions(domain, params::Dict{String,<:Any})

Returns the number of closed workflow executions within the given domain that meet the
specified filtering criteria.  This operation is eventually consistent. The results are
best effort and may not exactly reflect recent updates and changes.   Access Control  You
can use IAM policies to control this action's access to Amazon SWF resources as follows:
Use a Resource element with the domain name to limit the action to only specified domains.
 Use an Action element to allow or deny permission to call this action.   Constrain the
following parameters by using a Condition element with the appropriate keys.
tagFilter.tag: String constraint. The key is swf:tagFilter.tag.    typeFilter.name: String
constraint. The key is swf:typeFilter.name.    typeFilter.version: String constraint. The
key is swf:typeFilter.version.     If the caller doesn't have sufficient permissions to
invoke the action, or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's cause parameter is set to
OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage
Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain containing the workflow executions to count.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"closeStatusFilter"`: If specified, only workflow executions that match this close
  status are counted. This filter has an affect only if executionStatus is specified as
  CLOSED.   closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
  exclusive. You can specify at most one of these in a request.
- `"closeTimeFilter"`: If specified, only workflow executions that meet the close time
  criteria of the filter are counted.   startTimeFilter and closeTimeFilter are mutually
  exclusive. You must specify one of these in a request but not both.
- `"executionFilter"`: If specified, only workflow executions matching the WorkflowId in
  the filter are counted.   closeStatusFilter, executionFilter, typeFilter and tagFilter are
  mutually exclusive. You can specify at most one of these in a request.
- `"startTimeFilter"`: If specified, only workflow executions that meet the start time
  criteria of the filter are counted.   startTimeFilter and closeTimeFilter are mutually
  exclusive. You must specify one of these in a request but not both.
- `"tagFilter"`: If specified, only executions that have a tag that matches the filter are
  counted.   closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
  exclusive. You can specify at most one of these in a request.
- `"typeFilter"`: If specified, indicates the type of the workflow executions to be
  counted.   closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
  exclusive. You can specify at most one of these in a request.
"""
function count_closed_workflow_executions(
    domain; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "CountClosedWorkflowExecutions",
        Dict{String,Any}("domain" => domain);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function count_closed_workflow_executions(
    domain, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "CountClosedWorkflowExecutions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("domain" => domain), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    count_open_workflow_executions(domain, start_time_filter)
    count_open_workflow_executions(domain, start_time_filter, params::Dict{String,<:Any})

Returns the number of open workflow executions within the given domain that meet the
specified filtering criteria.  This operation is eventually consistent. The results are
best effort and may not exactly reflect recent updates and changes.   Access Control  You
can use IAM policies to control this action's access to Amazon SWF resources as follows:
Use a Resource element with the domain name to limit the action to only specified domains.
 Use an Action element to allow or deny permission to call this action.   Constrain the
following parameters by using a Condition element with the appropriate keys.
tagFilter.tag: String constraint. The key is swf:tagFilter.tag.    typeFilter.name: String
constraint. The key is swf:typeFilter.name.    typeFilter.version: String constraint. The
key is swf:typeFilter.version.     If the caller doesn't have sufficient permissions to
invoke the action, or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's cause parameter is set to
OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage
Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain containing the workflow executions to count.
- `start_time_filter`: Specifies the start time criteria that workflow executions must meet
  in order to be counted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"executionFilter"`: If specified, only workflow executions matching the WorkflowId in
  the filter are counted.   executionFilter, typeFilter and tagFilter are mutually exclusive.
  You can specify at most one of these in a request.
- `"tagFilter"`: If specified, only executions that have a tag that matches the filter are
  counted.   executionFilter, typeFilter and tagFilter are mutually exclusive. You can
  specify at most one of these in a request.
- `"typeFilter"`: Specifies the type of the workflow executions to be counted.
  executionFilter, typeFilter and tagFilter are mutually exclusive. You can specify at most
  one of these in a request.
"""
function count_open_workflow_executions(
    domain, startTimeFilter; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "CountOpenWorkflowExecutions",
        Dict{String,Any}("domain" => domain, "startTimeFilter" => startTimeFilter);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function count_open_workflow_executions(
    domain,
    startTimeFilter,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "CountOpenWorkflowExecutions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domain" => domain, "startTimeFilter" => startTimeFilter),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    count_pending_activity_tasks(domain, task_list)
    count_pending_activity_tasks(domain, task_list, params::Dict{String,<:Any})

Returns the estimated number of activity tasks in the specified task list. The count
returned is an approximation and isn't guaranteed to be exact. If you specify a task list
that no activity task was ever scheduled in then 0 is returned.  Access Control  You can
use IAM policies to control this action's access to Amazon SWF resources as follows:   Use
a Resource element with the domain name to limit the action to only specified domains.
Use an Action element to allow or deny permission to call this action.   Constrain the
taskList.name parameter by using a Condition element with the swf:taskList.name key to
allow the action to access only certain task lists.   If the caller doesn't have sufficient
permissions to invoke the action, or the parameter values fall outside the specified
constraints, the action fails. The associated event attribute's cause parameter is set to
OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage
Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain that contains the task list.
- `task_list`: The name of the task list.

"""
function count_pending_activity_tasks(
    domain, taskList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "CountPendingActivityTasks",
        Dict{String,Any}("domain" => domain, "taskList" => taskList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function count_pending_activity_tasks(
    domain,
    taskList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "CountPendingActivityTasks",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("domain" => domain, "taskList" => taskList), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    count_pending_decision_tasks(domain, task_list)
    count_pending_decision_tasks(domain, task_list, params::Dict{String,<:Any})

Returns the estimated number of decision tasks in the specified task list. The count
returned is an approximation and isn't guaranteed to be exact. If you specify a task list
that no decision task was ever scheduled in then 0 is returned.  Access Control  You can
use IAM policies to control this action's access to Amazon SWF resources as follows:   Use
a Resource element with the domain name to limit the action to only specified domains.
Use an Action element to allow or deny permission to call this action.   Constrain the
taskList.name parameter by using a Condition element with the swf:taskList.name key to
allow the action to access only certain task lists.   If the caller doesn't have sufficient
permissions to invoke the action, or the parameter values fall outside the specified
constraints, the action fails. The associated event attribute's cause parameter is set to
OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage
Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain that contains the task list.
- `task_list`: The name of the task list.

"""
function count_pending_decision_tasks(
    domain, taskList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "CountPendingDecisionTasks",
        Dict{String,Any}("domain" => domain, "taskList" => taskList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function count_pending_decision_tasks(
    domain,
    taskList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "CountPendingDecisionTasks",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("domain" => domain, "taskList" => taskList), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_activity_type(activity_type, domain)
    delete_activity_type(activity_type, domain, params::Dict{String,<:Any})

Deletes the specified activity type. Note: Prior to deletion, activity types must first be
deprecated.   After an activity type has been deleted, you cannot schedule new activities
of that type. Activities that started before the type was deleted will continue to run.
Access Control  You can use IAM policies to control this action's access to Amazon SWF
resources as follows:   Use a Resource element with the domain name to limit the action to
only specified domains.   Use an Action element to allow or deny permission to call this
action.   Constrain the following parameters by using a Condition element with the
appropriate keys.    activityType.name: String constraint. The key is
swf:activityType.name.    activityType.version: String constraint. The key is
swf:activityType.version.     If the caller doesn't have sufficient permissions to invoke
the action, or the parameter values fall outside the specified constraints, the action
fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF
Workflows in the Amazon SWF Developer Guide.

# Arguments
- `activity_type`: The activity type to delete.
- `domain`: The name of the domain in which the activity type is registered.

"""
function delete_activity_type(
    activityType, domain; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "DeleteActivityType",
        Dict{String,Any}("activityType" => activityType, "domain" => domain);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_activity_type(
    activityType,
    domain,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "DeleteActivityType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("activityType" => activityType, "domain" => domain),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_workflow_type(domain, workflow_type)
    delete_workflow_type(domain, workflow_type, params::Dict{String,<:Any})

Deletes the specified workflow type. Note: Prior to deletion, workflow types must first be
deprecated.  After a workflow type has been deleted, you cannot create new executions of
that type. Executions that started before the type was deleted will continue to run.
Access Control  You can use IAM policies to control this action's access to Amazon SWF
resources as follows:   Use a Resource element with the domain name to limit the action to
only specified domains.   Use an Action element to allow or deny permission to call this
action.   Constrain the following parameters by using a Condition element with the
appropriate keys.    workflowType.name: String constraint. The key is
swf:workflowType.name.    workflowType.version: String constraint. The key is
swf:workflowType.version.     If the caller doesn't have sufficient permissions to invoke
the action, or the parameter values fall outside the specified constraints, the action
fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF
Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain in which the workflow type is registered.
- `workflow_type`: The workflow type to delete.

"""
function delete_workflow_type(
    domain, workflowType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "DeleteWorkflowType",
        Dict{String,Any}("domain" => domain, "workflowType" => workflowType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_workflow_type(
    domain,
    workflowType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "DeleteWorkflowType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domain" => domain, "workflowType" => workflowType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deprecate_activity_type(activity_type, domain)
    deprecate_activity_type(activity_type, domain, params::Dict{String,<:Any})

Deprecates the specified activity type. After an activity type has been deprecated, you
cannot create new tasks of that activity type. Tasks of this type that were scheduled
before the type was deprecated continue to run.  Access Control  You can use IAM policies
to control this action's access to Amazon SWF resources as follows:   Use a Resource
element with the domain name to limit the action to only specified domains.   Use an Action
element to allow or deny permission to call this action.   Constrain the following
parameters by using a Condition element with the appropriate keys.    activityType.name:
String constraint. The key is swf:activityType.name.    activityType.version: String
constraint. The key is swf:activityType.version.     If the caller doesn't have sufficient
permissions to invoke the action, or the parameter values fall outside the specified
constraints, the action fails. The associated event attribute's cause parameter is set to
OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage
Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `activity_type`: The activity type to deprecate.
- `domain`: The name of the domain in which the activity type is registered.

"""
function deprecate_activity_type(
    activityType, domain; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "DeprecateActivityType",
        Dict{String,Any}("activityType" => activityType, "domain" => domain);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deprecate_activity_type(
    activityType,
    domain,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "DeprecateActivityType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("activityType" => activityType, "domain" => domain),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deprecate_domain(name)
    deprecate_domain(name, params::Dict{String,<:Any})

Deprecates the specified domain. After a domain has been deprecated it cannot be used to
create new workflow executions or register new types. However, you can still use visibility
actions on this domain. Deprecating a domain also deprecates all activity and workflow
types registered in the domain. Executions that were started before the domain was
deprecated continues to run.  This operation is eventually consistent. The results are best
effort and may not exactly reflect recent updates and changes.   Access Control  You can
use IAM policies to control this action's access to Amazon SWF resources as follows:   Use
a Resource element with the domain name to limit the action to only specified domains.
Use an Action element to allow or deny permission to call this action.   You cannot use an
IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient
permissions to invoke the action, or the parameter values fall outside the specified
constraints, the action fails. The associated event attribute's cause parameter is set to
OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage
Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `name`: The name of the domain to deprecate.

"""
function deprecate_domain(name; aws_config::AbstractAWSConfig=current_aws_config())
    return swf(
        "DeprecateDomain",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deprecate_domain(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "DeprecateDomain",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deprecate_workflow_type(domain, workflow_type)
    deprecate_workflow_type(domain, workflow_type, params::Dict{String,<:Any})

Deprecates the specified workflow type. After a workflow type has been deprecated, you
cannot create new executions of that type. Executions that were started before the type was
deprecated continues to run. A deprecated workflow type may still be used when calling
visibility actions.  This operation is eventually consistent. The results are best effort
and may not exactly reflect recent updates and changes.   Access Control  You can use IAM
policies to control this action's access to Amazon SWF resources as follows:   Use a
Resource element with the domain name to limit the action to only specified domains.   Use
an Action element to allow or deny permission to call this action.   Constrain the
following parameters by using a Condition element with the appropriate keys.
workflowType.name: String constraint. The key is swf:workflowType.name.
workflowType.version: String constraint. The key is swf:workflowType.version.     If the
caller doesn't have sufficient permissions to invoke the action, or the parameter values
fall outside the specified constraints, the action fails. The associated event attribute's
cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies,
see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain in which the workflow type is registered.
- `workflow_type`: The workflow type to deprecate.

"""
function deprecate_workflow_type(
    domain, workflowType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "DeprecateWorkflowType",
        Dict{String,Any}("domain" => domain, "workflowType" => workflowType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deprecate_workflow_type(
    domain,
    workflowType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "DeprecateWorkflowType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domain" => domain, "workflowType" => workflowType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_activity_type(activity_type, domain)
    describe_activity_type(activity_type, domain, params::Dict{String,<:Any})

Returns information about the specified activity type. This includes configuration settings
provided when the type was registered and other general information about the type.  Access
Control  You can use IAM policies to control this action's access to Amazon SWF resources
as follows:   Use a Resource element with the domain name to limit the action to only
specified domains.   Use an Action element to allow or deny permission to call this action.
  Constrain the following parameters by using a Condition element with the appropriate
keys.    activityType.name: String constraint. The key is swf:activityType.name.
activityType.version: String constraint. The key is swf:activityType.version.     If the
caller doesn't have sufficient permissions to invoke the action, or the parameter values
fall outside the specified constraints, the action fails. The associated event attribute's
cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies,
see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `activity_type`: The activity type to get information about. Activity types are
  identified by the name and version that were supplied when the activity was registered.
- `domain`: The name of the domain in which the activity type is registered.

"""
function describe_activity_type(
    activityType, domain; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "DescribeActivityType",
        Dict{String,Any}("activityType" => activityType, "domain" => domain);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_activity_type(
    activityType,
    domain,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "DescribeActivityType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("activityType" => activityType, "domain" => domain),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_domain(name)
    describe_domain(name, params::Dict{String,<:Any})

Returns information about the specified domain, including description and status.  Access
Control  You can use IAM policies to control this action's access to Amazon SWF resources
as follows:   Use a Resource element with the domain name to limit the action to only
specified domains.   Use an Action element to allow or deny permission to call this action.
  You cannot use an IAM policy to constrain this action's parameters.   If the caller
doesn't have sufficient permissions to invoke the action, or the parameter values fall
outside the specified constraints, the action fails. The associated event attribute's cause
parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see
Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `name`: The name of the domain to describe.

"""
function describe_domain(name; aws_config::AbstractAWSConfig=current_aws_config())
    return swf(
        "DescribeDomain",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_domain(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "DescribeDomain",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_workflow_execution(domain, execution)
    describe_workflow_execution(domain, execution, params::Dict{String,<:Any})

Returns information about the specified workflow execution including its type and some
statistics.  This operation is eventually consistent. The results are best effort and may
not exactly reflect recent updates and changes.   Access Control  You can use IAM policies
to control this action's access to Amazon SWF resources as follows:   Use a Resource
element with the domain name to limit the action to only specified domains.   Use an Action
element to allow or deny permission to call this action.   You cannot use an IAM policy to
constrain this action's parameters.   If the caller doesn't have sufficient permissions to
invoke the action, or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's cause parameter is set to
OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage
Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain containing the workflow execution.
- `execution`: The workflow execution to describe.

"""
function describe_workflow_execution(
    domain, execution; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "DescribeWorkflowExecution",
        Dict{String,Any}("domain" => domain, "execution" => execution);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_workflow_execution(
    domain,
    execution,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "DescribeWorkflowExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domain" => domain, "execution" => execution),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_workflow_type(domain, workflow_type)
    describe_workflow_type(domain, workflow_type, params::Dict{String,<:Any})

Returns information about the specified workflow type. This includes configuration settings
specified when the type was registered and other information such as creation date, current
status, etc.  Access Control  You can use IAM policies to control this action's access to
Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the
action to only specified domains.   Use an Action element to allow or deny permission to
call this action.   Constrain the following parameters by using a Condition element with
the appropriate keys.    workflowType.name: String constraint. The key is
swf:workflowType.name.    workflowType.version: String constraint. The key is
swf:workflowType.version.     If the caller doesn't have sufficient permissions to invoke
the action, or the parameter values fall outside the specified constraints, the action
fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF
Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain in which this workflow type is registered.
- `workflow_type`: The workflow type to describe.

"""
function describe_workflow_type(
    domain, workflowType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "DescribeWorkflowType",
        Dict{String,Any}("domain" => domain, "workflowType" => workflowType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_workflow_type(
    domain,
    workflowType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "DescribeWorkflowType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domain" => domain, "workflowType" => workflowType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_workflow_execution_history(domain, execution)
    get_workflow_execution_history(domain, execution, params::Dict{String,<:Any})

Returns the history of the specified workflow execution. The results may be split into
multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken
returned by the initial call.  This operation is eventually consistent. The results are
best effort and may not exactly reflect recent updates and changes.   Access Control  You
can use IAM policies to control this action's access to Amazon SWF resources as follows:
Use a Resource element with the domain name to limit the action to only specified domains.
 Use an Action element to allow or deny permission to call this action.   You cannot use an
IAM policy to constrain this action's parameters.   If the caller doesn't have sufficient
permissions to invoke the action, or the parameter values fall outside the specified
constraints, the action fails. The associated event attribute's cause parameter is set to
OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage
Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain containing the workflow execution.
- `execution`: Specifies the workflow execution for which to return the history.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maximumPageSize"`: The maximum number of results that are returned per call. Use
  nextPageToken to obtain further pages of results.
- `"nextPageToken"`: If NextPageToken is returned there are more results available. The
  value of NextPageToken is a unique pagination token for each page. Make the call again
  using the returned token to retrieve the next page. Keep all other arguments unchanged.
  Each pagination token expires after 24 hours. Using an expired pagination token will return
  a 400 error: \"Specified token has exceeded its maximum lifetime\".  The configured
  maximumPageSize determines how many results can be returned in a single call.
- `"reverseOrder"`: When set to true, returns the events in reverse order. By default the
  results are returned in ascending order of the eventTimeStamp of the events.
"""
function get_workflow_execution_history(
    domain, execution; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "GetWorkflowExecutionHistory",
        Dict{String,Any}("domain" => domain, "execution" => execution);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_workflow_execution_history(
    domain,
    execution,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "GetWorkflowExecutionHistory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domain" => domain, "execution" => execution),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_activity_types(domain, registration_status)
    list_activity_types(domain, registration_status, params::Dict{String,<:Any})

Returns information about all activities registered in the specified domain that match the
specified name and registration status. The result includes information like creation date,
current status of the activity, etc. The results may be split into multiple pages. To
retrieve subsequent pages, make the call again using the nextPageToken returned by the
initial call.  Access Control  You can use IAM policies to control this action's access to
Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the
action to only specified domains.   Use an Action element to allow or deny permission to
call this action.   You cannot use an IAM policy to constrain this action's parameters.
If the caller doesn't have sufficient permissions to invoke the action, or the parameter
values fall outside the specified constraints, the action fails. The associated event
attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM
policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF
Developer Guide.

# Arguments
- `domain`: The name of the domain in which the activity types have been registered.
- `registration_status`: Specifies the registration status of the activity types to list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maximumPageSize"`: The maximum number of results that are returned per call. Use
  nextPageToken to obtain further pages of results.
- `"name"`: If specified, only lists the activity types that have this name.
- `"nextPageToken"`: If NextPageToken is returned there are more results available. The
  value of NextPageToken is a unique pagination token for each page. Make the call again
  using the returned token to retrieve the next page. Keep all other arguments unchanged.
  Each pagination token expires after 24 hours. Using an expired pagination token will return
  a 400 error: \"Specified token has exceeded its maximum lifetime\".  The configured
  maximumPageSize determines how many results can be returned in a single call.
- `"reverseOrder"`: When set to true, returns the results in reverse order. By default, the
  results are returned in ascending alphabetical order by name of the activity types.
"""
function list_activity_types(
    domain, registrationStatus; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "ListActivityTypes",
        Dict{String,Any}("domain" => domain, "registrationStatus" => registrationStatus);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_activity_types(
    domain,
    registrationStatus,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "ListActivityTypes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "domain" => domain, "registrationStatus" => registrationStatus
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_closed_workflow_executions(domain)
    list_closed_workflow_executions(domain, params::Dict{String,<:Any})

Returns a list of closed workflow executions in the specified domain that meet the
filtering criteria. The results may be split into multiple pages. To retrieve subsequent
pages, make the call again using the nextPageToken returned by the initial call.  This
operation is eventually consistent. The results are best effort and may not exactly reflect
recent updates and changes.   Access Control  You can use IAM policies to control this
action's access to Amazon SWF resources as follows:   Use a Resource element with the
domain name to limit the action to only specified domains.   Use an Action element to allow
or deny permission to call this action.   Constrain the following parameters by using a
Condition element with the appropriate keys.    tagFilter.tag: String constraint. The key
is swf:tagFilter.tag.    typeFilter.name: String constraint. The key is
swf:typeFilter.name.    typeFilter.version: String constraint. The key is
swf:typeFilter.version.     If the caller doesn't have sufficient permissions to invoke the
action, or the parameter values fall outside the specified constraints, the action fails.
The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For
details and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in
the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain that contains the workflow executions to list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"closeStatusFilter"`: If specified, only workflow executions that match this close
  status are listed. For example, if TERMINATED is specified, then only TERMINATED workflow
  executions are listed.   closeStatusFilter, executionFilter, typeFilter and tagFilter are
  mutually exclusive. You can specify at most one of these in a request.
- `"closeTimeFilter"`: If specified, the workflow executions are included in the returned
  results based on whether their close times are within the range specified by this filter.
  Also, if this parameter is specified, the returned results are ordered by their close
  times.   startTimeFilter and closeTimeFilter are mutually exclusive. You must specify one
  of these in a request but not both.
- `"executionFilter"`: If specified, only workflow executions matching the workflow ID
  specified in the filter are returned.   closeStatusFilter, executionFilter, typeFilter and
  tagFilter are mutually exclusive. You can specify at most one of these in a request.
- `"maximumPageSize"`: The maximum number of results that are returned per call. Use
  nextPageToken to obtain further pages of results.
- `"nextPageToken"`: If NextPageToken is returned there are more results available. The
  value of NextPageToken is a unique pagination token for each page. Make the call again
  using the returned token to retrieve the next page. Keep all other arguments unchanged.
  Each pagination token expires after 24 hours. Using an expired pagination token will return
  a 400 error: \"Specified token has exceeded its maximum lifetime\".  The configured
  maximumPageSize determines how many results can be returned in a single call.
- `"reverseOrder"`: When set to true, returns the results in reverse order. By default the
  results are returned in descending order of the start or the close time of the executions.
- `"startTimeFilter"`: If specified, the workflow executions are included in the returned
  results based on whether their start times are within the range specified by this filter.
  Also, if this parameter is specified, the returned results are ordered by their start
  times.   startTimeFilter and closeTimeFilter are mutually exclusive. You must specify one
  of these in a request but not both.
- `"tagFilter"`: If specified, only executions that have the matching tag are listed.
  closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually exclusive. You
  can specify at most one of these in a request.
- `"typeFilter"`: If specified, only executions of the type specified in the filter are
  returned.   closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
  exclusive. You can specify at most one of these in a request.
"""
function list_closed_workflow_executions(
    domain; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "ListClosedWorkflowExecutions",
        Dict{String,Any}("domain" => domain);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_closed_workflow_executions(
    domain, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "ListClosedWorkflowExecutions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("domain" => domain), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_domains(registration_status)
    list_domains(registration_status, params::Dict{String,<:Any})

Returns the list of domains registered in the account. The results may be split into
multiple pages. To retrieve subsequent pages, make the call again using the nextPageToken
returned by the initial call.  This operation is eventually consistent. The results are
best effort and may not exactly reflect recent updates and changes.   Access Control  You
can use IAM policies to control this action's access to Amazon SWF resources as follows:
Use a Resource element with the domain name to limit the action to only specified domains.
The element must be set to arn:aws:swf::AccountID:domain/*, where AccountID is the account
ID, with no dashes.   Use an Action element to allow or deny permission to call this
action.   You cannot use an IAM policy to constrain this action's parameters.   If the
caller doesn't have sufficient permissions to invoke the action, or the parameter values
fall outside the specified constraints, the action fails. The associated event attribute's
cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies,
see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `registration_status`: Specifies the registration status of the domains to list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maximumPageSize"`: The maximum number of results that are returned per call. Use
  nextPageToken to obtain further pages of results.
- `"nextPageToken"`: If NextPageToken is returned there are more results available. The
  value of NextPageToken is a unique pagination token for each page. Make the call again
  using the returned token to retrieve the next page. Keep all other arguments unchanged.
  Each pagination token expires after 24 hours. Using an expired pagination token will return
  a 400 error: \"Specified token has exceeded its maximum lifetime\".  The configured
  maximumPageSize determines how many results can be returned in a single call.
- `"reverseOrder"`: When set to true, returns the results in reverse order. By default, the
  results are returned in ascending alphabetical order by name of the domains.
"""
function list_domains(
    registrationStatus; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "ListDomains",
        Dict{String,Any}("registrationStatus" => registrationStatus);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_domains(
    registrationStatus,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "ListDomains",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("registrationStatus" => registrationStatus), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_open_workflow_executions(domain, start_time_filter)
    list_open_workflow_executions(domain, start_time_filter, params::Dict{String,<:Any})

Returns a list of open workflow executions in the specified domain that meet the filtering
criteria. The results may be split into multiple pages. To retrieve subsequent pages, make
the call again using the nextPageToken returned by the initial call.  This operation is
eventually consistent. The results are best effort and may not exactly reflect recent
updates and changes.   Access Control  You can use IAM policies to control this action's
access to Amazon SWF resources as follows:   Use a Resource element with the domain name to
limit the action to only specified domains.   Use an Action element to allow or deny
permission to call this action.   Constrain the following parameters by using a Condition
element with the appropriate keys.    tagFilter.tag: String constraint. The key is
swf:tagFilter.tag.    typeFilter.name: String constraint. The key is swf:typeFilter.name.
 typeFilter.version: String constraint. The key is swf:typeFilter.version.     If the
caller doesn't have sufficient permissions to invoke the action, or the parameter values
fall outside the specified constraints, the action fails. The associated event attribute's
cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies,
see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain that contains the workflow executions to list.
- `start_time_filter`: Workflow executions are included in the returned results based on
  whether their start times are within the range specified by this filter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"executionFilter"`: If specified, only workflow executions matching the workflow ID
  specified in the filter are returned.   executionFilter, typeFilter and tagFilter are
  mutually exclusive. You can specify at most one of these in a request.
- `"maximumPageSize"`: The maximum number of results that are returned per call. Use
  nextPageToken to obtain further pages of results.
- `"nextPageToken"`: If NextPageToken is returned there are more results available. The
  value of NextPageToken is a unique pagination token for each page. Make the call again
  using the returned token to retrieve the next page. Keep all other arguments unchanged.
  Each pagination token expires after 24 hours. Using an expired pagination token will return
  a 400 error: \"Specified token has exceeded its maximum lifetime\".  The configured
  maximumPageSize determines how many results can be returned in a single call.
- `"reverseOrder"`: When set to true, returns the results in reverse order. By default the
  results are returned in descending order of the start time of the executions.
- `"tagFilter"`: If specified, only executions that have the matching tag are listed.
  executionFilter, typeFilter and tagFilter are mutually exclusive. You can specify at most
  one of these in a request.
- `"typeFilter"`: If specified, only executions of the type specified in the filter are
  returned.   executionFilter, typeFilter and tagFilter are mutually exclusive. You can
  specify at most one of these in a request.
"""
function list_open_workflow_executions(
    domain, startTimeFilter; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "ListOpenWorkflowExecutions",
        Dict{String,Any}("domain" => domain, "startTimeFilter" => startTimeFilter);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_open_workflow_executions(
    domain,
    startTimeFilter,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "ListOpenWorkflowExecutions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domain" => domain, "startTimeFilter" => startTimeFilter),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

List tags for a given domain.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) for the Amazon SWF domain.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "ListTagsForResource",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_workflow_types(domain, registration_status)
    list_workflow_types(domain, registration_status, params::Dict{String,<:Any})

Returns information about workflow types in the specified domain. The results may be split
into multiple pages that can be retrieved by making the call repeatedly.  Access Control
You can use IAM policies to control this action's access to Amazon SWF resources as
follows:   Use a Resource element with the domain name to limit the action to only
specified domains.   Use an Action element to allow or deny permission to call this action.
  You cannot use an IAM policy to constrain this action's parameters.   If the caller
doesn't have sufficient permissions to invoke the action, or the parameter values fall
outside the specified constraints, the action fails. The associated event attribute's cause
parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see
Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain in which the workflow types have been registered.
- `registration_status`: Specifies the registration status of the workflow types to list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maximumPageSize"`: The maximum number of results that are returned per call. Use
  nextPageToken to obtain further pages of results.
- `"name"`: If specified, lists the workflow type with this name.
- `"nextPageToken"`: If NextPageToken is returned there are more results available. The
  value of NextPageToken is a unique pagination token for each page. Make the call again
  using the returned token to retrieve the next page. Keep all other arguments unchanged.
  Each pagination token expires after 24 hours. Using an expired pagination token will return
  a 400 error: \"Specified token has exceeded its maximum lifetime\".  The configured
  maximumPageSize determines how many results can be returned in a single call.
- `"reverseOrder"`: When set to true, returns the results in reverse order. By default the
  results are returned in ascending alphabetical order of the name of the workflow types.
"""
function list_workflow_types(
    domain, registrationStatus; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "ListWorkflowTypes",
        Dict{String,Any}("domain" => domain, "registrationStatus" => registrationStatus);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_workflow_types(
    domain,
    registrationStatus,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "ListWorkflowTypes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "domain" => domain, "registrationStatus" => registrationStatus
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    poll_for_activity_task(domain, task_list)
    poll_for_activity_task(domain, task_list, params::Dict{String,<:Any})

Used by workers to get an ActivityTask from the specified activity taskList. This initiates
a long poll, where the service holds the HTTP connection open and responds as soon as a
task becomes available. The maximum time the service holds on to the request before
responding is 60 seconds. If no task is available within 60 seconds, the poll returns an
empty result. An empty result, in this context, means that an ActivityTask is returned, but
that the value of taskToken is an empty string. If a task is returned, the worker should
use its type to identify and process it correctly.  Workers should set their client side
socket timeout to at least 70 seconds (10 seconds higher than the maximum time service may
hold the poll request).   Access Control  You can use IAM policies to control this action's
access to Amazon SWF resources as follows:   Use a Resource element with the domain name to
limit the action to only specified domains.   Use an Action element to allow or deny
permission to call this action.   Constrain the taskList.name parameter by using a
Condition element with the swf:taskList.name key to allow the action to access only certain
task lists.   If the caller doesn't have sufficient permissions to invoke the action, or
the parameter values fall outside the specified constraints, the action fails. The
associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details
and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the
Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain that contains the task lists being polled.
- `task_list`: Specifies the task list to poll for activity tasks. The specified string
  must not start or end with whitespace. It must not contain a : (colon), / (slash), |
  (vertical bar), or any control characters (u0000-u001f | u007f-u009f). Also, it must not be
  the literal string arn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"identity"`: Identity of the worker making the request, recorded in the
  ActivityTaskStarted event in the workflow history. This enables diagnostic tracing when
  problems arise. The form of this identity is user defined.
"""
function poll_for_activity_task(
    domain, taskList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "PollForActivityTask",
        Dict{String,Any}("domain" => domain, "taskList" => taskList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function poll_for_activity_task(
    domain,
    taskList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "PollForActivityTask",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("domain" => domain, "taskList" => taskList), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    poll_for_decision_task(domain, task_list)
    poll_for_decision_task(domain, task_list, params::Dict{String,<:Any})

Used by deciders to get a DecisionTask from the specified decision taskList. A decision
task may be returned for any open workflow execution that is using the specified task list.
The task includes a paginated view of the history of the workflow execution. The decider
should use the workflow type and the history to determine how to properly handle the task.
This action initiates a long poll, where the service holds the HTTP connection open and
responds as soon a task becomes available. If no decision task is available in the
specified task list before the timeout of 60 seconds expires, an empty result is returned.
An empty result, in this context, means that a DecisionTask is returned, but that the value
of taskToken is an empty string.  Deciders should set their client side socket timeout to
at least 70 seconds (10 seconds higher than the timeout).   Because the number of workflow
history events for a single workflow execution might be very large, the result returned
might be split up across a number of pages. To retrieve subsequent pages, make additional
calls to PollForDecisionTask using the nextPageToken returned by the initial call. Note
that you do not call GetWorkflowExecutionHistory with this nextPageToken. Instead, call
PollForDecisionTask again.   Access Control  You can use IAM policies to control this
action's access to Amazon SWF resources as follows:   Use a Resource element with the
domain name to limit the action to only specified domains.   Use an Action element to allow
or deny permission to call this action.   Constrain the taskList.name parameter by using a
Condition element with the swf:taskList.name key to allow the action to access only certain
task lists.   If the caller doesn't have sufficient permissions to invoke the action, or
the parameter values fall outside the specified constraints, the action fails. The
associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details
and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the
Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain containing the task lists to poll.
- `task_list`: Specifies the task list to poll for decision tasks. The specified string
  must not contain a : (colon), / (slash), | (vertical bar), or any control characters
  (u0000-u001f | u007f-u009f). Also, it must not be the literal string arn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"identity"`: Identity of the decider making the request, which is recorded in the
  DecisionTaskStarted event in the workflow history. This enables diagnostic tracing when
  problems arise. The form of this identity is user defined.
- `"maximumPageSize"`: The maximum number of results that are returned per call. Use
  nextPageToken to obtain further pages of results.  This is an upper limit only; the actual
  number of results returned per call may be fewer than the specified maximum.
- `"nextPageToken"`: If NextPageToken is returned there are more results available. The
  value of NextPageToken is a unique pagination token for each page. Make the call again
  using the returned token to retrieve the next page. Keep all other arguments unchanged.
  Each pagination token expires after 24 hours. Using an expired pagination token will return
  a 400 error: \"Specified token has exceeded its maximum lifetime\".  The configured
  maximumPageSize determines how many results can be returned in a single call.   The
  nextPageToken returned by this action cannot be used with GetWorkflowExecutionHistory to
  get the next page. You must call PollForDecisionTask again (with the nextPageToken) to
  retrieve the next page of history records. Calling PollForDecisionTask with a nextPageToken
  doesn't return a new decision task.
- `"reverseOrder"`: When set to true, returns the events in reverse order. By default the
  results are returned in ascending order of the eventTimestamp of the events.
- `"startAtPreviousStartedEvent"`: When set to true, returns the events with eventTimestamp
  greater than or equal to eventTimestamp of the most recent DecisionTaskStarted event. By
  default, this parameter is set to false.
"""
function poll_for_decision_task(
    domain, taskList; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "PollForDecisionTask",
        Dict{String,Any}("domain" => domain, "taskList" => taskList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function poll_for_decision_task(
    domain,
    taskList,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "PollForDecisionTask",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("domain" => domain, "taskList" => taskList), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    record_activity_task_heartbeat(task_token)
    record_activity_task_heartbeat(task_token, params::Dict{String,<:Any})

Used by activity workers to report to the service that the ActivityTask represented by the
specified taskToken is still making progress. The worker can also specify details of the
progress, for example percent complete, using the details parameter. This action can also
be used by the worker as a mechanism to check if cancellation is being requested for the
activity task. If a cancellation is being attempted for the specified task, then the
boolean cancelRequested flag returned by the service is set to true. This action resets the
taskHeartbeatTimeout clock. The taskHeartbeatTimeout is specified in RegisterActivityType.
This action doesn't in itself create an event in the workflow execution history. However,
if the task times out, the workflow execution history contains a ActivityTaskTimedOut event
that contains the information from the last heartbeat generated by the activity worker.
The taskStartToCloseTimeout of an activity type is the maximum duration of an activity
task, regardless of the number of RecordActivityTaskHeartbeat requests received. The
taskStartToCloseTimeout is also specified in RegisterActivityType.   This operation is only
useful for long-lived activities to report liveliness of the task and to determine if a
cancellation is being attempted.   If the cancelRequested flag returns true, a cancellation
is being attempted. If the worker can cancel the activity, it should respond with
RespondActivityTaskCanceled. Otherwise, it should ignore the cancellation request.   Access
Control  You can use IAM policies to control this action's access to Amazon SWF resources
as follows:   Use a Resource element with the domain name to limit the action to only
specified domains.   Use an Action element to allow or deny permission to call this action.
  You cannot use an IAM policy to constrain this action's parameters.   If the caller
doesn't have sufficient permissions to invoke the action, or the parameter values fall
outside the specified constraints, the action fails. The associated event attribute's cause
parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see
Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `task_token`: The taskToken of the ActivityTask.   taskToken is generated by the service
  and should be treated as an opaque value. If the task is passed to another process, its
  taskToken must also be passed. This enables it to provide its progress and respond with
  results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"details"`: If specified, contains details about the progress of the task.
"""
function record_activity_task_heartbeat(
    taskToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "RecordActivityTaskHeartbeat",
        Dict{String,Any}("taskToken" => taskToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function record_activity_task_heartbeat(
    taskToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "RecordActivityTaskHeartbeat",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("taskToken" => taskToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_activity_type(domain, name, version)
    register_activity_type(domain, name, version, params::Dict{String,<:Any})

Registers a new activity type along with its configuration settings in the specified
domain.  A TypeAlreadyExists fault is returned if the type already exists in the domain.
You cannot change any configuration settings of the type after its registration, and it
must be registered as a new version.   Access Control  You can use IAM policies to control
this action's access to Amazon SWF resources as follows:   Use a Resource element with the
domain name to limit the action to only specified domains.   Use an Action element to allow
or deny permission to call this action.   Constrain the following parameters by using a
Condition element with the appropriate keys.    defaultTaskList.name: String constraint.
The key is swf:defaultTaskList.name.    name: String constraint. The key is swf:name.
version: String constraint. The key is swf:version.     If the caller doesn't have
sufficient permissions to invoke the action, or the parameter values fall outside the
specified constraints, the action fails. The associated event attribute's cause parameter
is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to
Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain in which this activity is to be registered.
- `name`: The name of the activity type within the domain. The specified string must not
  contain a : (colon), / (slash), | (vertical bar), or any control characters (u0000-u001f |
  u007f-u009f). Also, it must not be the literal string arn.
- `version`: The version of the activity type.  The activity type consists of the name and
  version, the combination of which must be unique within the domain.  The specified string
  must not contain a : (colon), / (slash), | (vertical bar), or any control characters
  (u0000-u001f | u007f-u009f). Also, it must not be the literal string arn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"defaultTaskHeartbeatTimeout"`: If set, specifies the default maximum time before which
  a worker processing a task of this type must report progress by calling
  RecordActivityTaskHeartbeat. If the timeout is exceeded, the activity task is automatically
  timed out. This default can be overridden when scheduling an activity task using the
  ScheduleActivityTask Decision. If the activity worker subsequently attempts to record a
  heartbeat or returns a result, the activity worker receives an UnknownResource fault. In
  this case, Amazon SWF no longer considers the activity task to be valid; the activity
  worker should clean up the activity task. The duration is specified in seconds, an integer
  greater than or equal to 0. You can use NONE to specify unlimited duration.
- `"defaultTaskList"`: If set, specifies the default task list to use for scheduling tasks
  of this activity type. This default task list is used if a task list isn't provided when a
  task is scheduled through the ScheduleActivityTask Decision.
- `"defaultTaskPriority"`: The default task priority to assign to the activity type. If not
  assigned, then 0 is used. Valid values are integers that range from Java's
  Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate
  higher priority. For more information about setting task priority, see Setting Task
  Priority in the in the Amazon SWF Developer Guide..
- `"defaultTaskScheduleToCloseTimeout"`: If set, specifies the default maximum duration for
  a task of this activity type. This default can be overridden when scheduling an activity
  task using the ScheduleActivityTask Decision. The duration is specified in seconds, an
  integer greater than or equal to 0. You can use NONE to specify unlimited duration.
- `"defaultTaskScheduleToStartTimeout"`: If set, specifies the default maximum duration
  that a task of this activity type can wait before being assigned to a worker. This default
  can be overridden when scheduling an activity task using the ScheduleActivityTask Decision.
  The duration is specified in seconds, an integer greater than or equal to 0. You can use
  NONE to specify unlimited duration.
- `"defaultTaskStartToCloseTimeout"`: If set, specifies the default maximum duration that a
  worker can take to process tasks of this activity type. This default can be overridden when
  scheduling an activity task using the ScheduleActivityTask Decision. The duration is
  specified in seconds, an integer greater than or equal to 0. You can use NONE to specify
  unlimited duration.
- `"description"`: A textual description of the activity type.
"""
function register_activity_type(
    domain, name, version; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "RegisterActivityType",
        Dict{String,Any}("domain" => domain, "name" => name, "version" => version);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_activity_type(
    domain,
    name,
    version,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "RegisterActivityType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domain" => domain, "name" => name, "version" => version),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_domain(name, workflow_execution_retention_period_in_days)
    register_domain(name, workflow_execution_retention_period_in_days, params::Dict{String,<:Any})

Registers a new domain.  Access Control  You can use IAM policies to control this action's
access to Amazon SWF resources as follows:   You cannot use an IAM policy to control domain
access for this action. The name of the domain being registered is available as the
resource of this action.   Use an Action element to allow or deny permission to call this
action.   You cannot use an IAM policy to constrain this action's parameters.   If the
caller doesn't have sufficient permissions to invoke the action, or the parameter values
fall outside the specified constraints, the action fails. The associated event attribute's
cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM policies,
see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `name`: Name of the domain to register. The name must be unique in the region that the
  domain is registered in. The specified string must not start or end with whitespace. It
  must not contain a : (colon), / (slash), | (vertical bar), or any control characters
  (u0000-u001f | u007f-u009f). Also, it must not be the literal string arn.
- `workflow_execution_retention_period_in_days`: The duration (in days) that records and
  histories of workflow executions on the domain should be kept by the service. After the
  retention period, the workflow execution isn't available in the results of visibility
  calls. If you pass the value NONE or 0 (zero), then the workflow execution history isn't
  retained. As soon as the workflow execution completes, the execution record and its history
  are deleted. The maximum workflow execution retention period is 90 days. For more
  information about Amazon SWF service limits, see: Amazon SWF Service Limits in the Amazon
  SWF Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: A text description of the domain.
- `"tags"`: Tags to be added when registering a domain. Tags may only contain unicode
  letters, digits, whitespace, or these symbols: _ . : / = + - @.
"""
function register_domain(
    name,
    workflowExecutionRetentionPeriodInDays;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "RegisterDomain",
        Dict{String,Any}(
            "name" => name,
            "workflowExecutionRetentionPeriodInDays" =>
                workflowExecutionRetentionPeriodInDays,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_domain(
    name,
    workflowExecutionRetentionPeriodInDays,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "RegisterDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name,
                    "workflowExecutionRetentionPeriodInDays" =>
                        workflowExecutionRetentionPeriodInDays,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_workflow_type(domain, name, version)
    register_workflow_type(domain, name, version, params::Dict{String,<:Any})

Registers a new workflow type and its configuration settings in the specified domain. The
retention period for the workflow history is set by the RegisterDomain action.  If the type
already exists, then a TypeAlreadyExists fault is returned. You cannot change the
configuration settings of a workflow type once it is registered and it must be registered
as a new version.   Access Control  You can use IAM policies to control this action's
access to Amazon SWF resources as follows:   Use a Resource element with the domain name to
limit the action to only specified domains.   Use an Action element to allow or deny
permission to call this action.   Constrain the following parameters by using a Condition
element with the appropriate keys.    defaultTaskList.name: String constraint. The key is
swf:defaultTaskList.name.    name: String constraint. The key is swf:name.    version:
String constraint. The key is swf:version.     If the caller doesn't have sufficient
permissions to invoke the action, or the parameter values fall outside the specified
constraints, the action fails. The associated event attribute's cause parameter is set to
OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage
Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain in which to register the workflow type.
- `name`: The name of the workflow type. The specified string must not contain a : (colon),
  / (slash), | (vertical bar), or any control characters (u0000-u001f | u007f-u009f). Also,
  it must not be the literal string arn.
- `version`: The version of the workflow type.  The workflow type consists of the name and
  version, the combination of which must be unique within the domain. To get a list of all
  currently registered workflow types, use the ListWorkflowTypes action.  The specified
  string must not contain a : (colon), / (slash), | (vertical bar), or any control characters
  (u0000-u001f | u007f-u009f). Also, it must not be the literal string arn.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"defaultChildPolicy"`: If set, specifies the default policy to use for the child
  workflow executions when a workflow execution of this type is terminated, by calling the
  TerminateWorkflowExecution action explicitly or due to an expired timeout. This default can
  be overridden when starting a workflow execution using the StartWorkflowExecution action or
  the StartChildWorkflowExecution Decision. The supported child policies are:    TERMINATE
  – The child executions are terminated.    REQUEST_CANCEL – A request to cancel is
  attempted for each child execution by recording a WorkflowExecutionCancelRequested event in
  its history. It is up to the decider to take appropriate actions when it receives an
  execution history with this event.    ABANDON – No action is taken. The child executions
  continue to run.
- `"defaultExecutionStartToCloseTimeout"`: If set, specifies the default maximum duration
  for executions of this workflow type. You can override this default when starting an
  execution through the StartWorkflowExecution Action or StartChildWorkflowExecution
  Decision. The duration is specified in seconds; an integer greater than or equal to 0.
  Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a value of
  \"NONE\" for defaultExecutionStartToCloseTimeout; there is a one-year max limit on the time
  that a workflow execution can run. Exceeding this limit always causes the workflow
  execution to time out.
- `"defaultLambdaRole"`: The default IAM role attached to this workflow type.  Executions
  of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an
  IAM role when you start this workflow type, the default Lambda role is attached to the
  execution. For more information, see
  https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html in the Amazon
  SWF Developer Guide.
- `"defaultTaskList"`: If set, specifies the default task list to use for scheduling
  decision tasks for executions of this workflow type. This default is used only if a task
  list isn't provided when starting the execution through the StartWorkflowExecution Action
  or StartChildWorkflowExecution Decision.
- `"defaultTaskPriority"`: The default task priority to assign to the workflow type. If not
  assigned, then 0 is used. Valid values are integers that range from Java's
  Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate
  higher priority. For more information about setting task priority, see Setting Task
  Priority in the Amazon SWF Developer Guide.
- `"defaultTaskStartToCloseTimeout"`: If set, specifies the default maximum duration of
  decision tasks for this workflow type. This default can be overridden when starting a
  workflow execution using the StartWorkflowExecution action or the
  StartChildWorkflowExecution Decision. The duration is specified in seconds, an integer
  greater than or equal to 0. You can use NONE to specify unlimited duration.
- `"description"`: Textual description of the workflow type.
"""
function register_workflow_type(
    domain, name, version; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "RegisterWorkflowType",
        Dict{String,Any}("domain" => domain, "name" => name, "version" => version);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_workflow_type(
    domain,
    name,
    version,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "RegisterWorkflowType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domain" => domain, "name" => name, "version" => version),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    request_cancel_workflow_execution(domain, workflow_id)
    request_cancel_workflow_execution(domain, workflow_id, params::Dict{String,<:Any})

Records a WorkflowExecutionCancelRequested event in the currently running workflow
execution identified by the given domain, workflowId, and runId. This logically requests
the cancellation of the workflow execution as a whole. It is up to the decider to take
appropriate actions when it receives an execution history with this event.  If the runId
isn't specified, the WorkflowExecutionCancelRequested event is recorded in the history of
the current open workflow execution with the specified workflowId in the domain.   Because
this action allows the workflow to properly clean up and gracefully close, it should be
used instead of TerminateWorkflowExecution when possible.   Access Control  You can use IAM
policies to control this action's access to Amazon SWF resources as follows:   Use a
Resource element with the domain name to limit the action to only specified domains.   Use
an Action element to allow or deny permission to call this action.   You cannot use an IAM
policy to constrain this action's parameters.   If the caller doesn't have sufficient
permissions to invoke the action, or the parameter values fall outside the specified
constraints, the action fails. The associated event attribute's cause parameter is set to
OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage
Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain containing the workflow execution to cancel.
- `workflow_id`: The workflowId of the workflow execution to cancel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"runId"`: The runId of the workflow execution to cancel.
"""
function request_cancel_workflow_execution(
    domain, workflowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "RequestCancelWorkflowExecution",
        Dict{String,Any}("domain" => domain, "workflowId" => workflowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function request_cancel_workflow_execution(
    domain,
    workflowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "RequestCancelWorkflowExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domain" => domain, "workflowId" => workflowId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    respond_activity_task_canceled(task_token)
    respond_activity_task_canceled(task_token, params::Dict{String,<:Any})

Used by workers to tell the service that the ActivityTask identified by the taskToken was
successfully canceled. Additional details can be provided using the details argument. These
details (if provided) appear in the ActivityTaskCanceled event added to the workflow
history.  Only use this operation if the canceled flag of a RecordActivityTaskHeartbeat
request returns true and if the activity can be safely undone or abandoned.  A task is
considered open from the time that it is scheduled until it is closed. Therefore a task is
reported as open while a worker is processing it. A task is closed after it has been
specified in a call to RespondActivityTaskCompleted, RespondActivityTaskCanceled,
RespondActivityTaskFailed, or the task has timed out.  Access Control  You can use IAM
policies to control this action's access to Amazon SWF resources as follows:   Use a
Resource element with the domain name to limit the action to only specified domains.   Use
an Action element to allow or deny permission to call this action.   You cannot use an IAM
policy to constrain this action's parameters.   If the caller doesn't have sufficient
permissions to invoke the action, or the parameter values fall outside the specified
constraints, the action fails. The associated event attribute's cause parameter is set to
OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage
Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `task_token`: The taskToken of the ActivityTask.   taskToken is generated by the service
  and should be treated as an opaque value. If the task is passed to another process, its
  taskToken must also be passed. This enables it to provide its progress and respond with
  results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"details"`:  Information about the cancellation.
"""
function respond_activity_task_canceled(
    taskToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "RespondActivityTaskCanceled",
        Dict{String,Any}("taskToken" => taskToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function respond_activity_task_canceled(
    taskToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "RespondActivityTaskCanceled",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("taskToken" => taskToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    respond_activity_task_completed(task_token)
    respond_activity_task_completed(task_token, params::Dict{String,<:Any})

Used by workers to tell the service that the ActivityTask identified by the taskToken
completed successfully with a result (if provided). The result appears in the
ActivityTaskCompleted event in the workflow history.  If the requested task doesn't
complete successfully, use RespondActivityTaskFailed instead. If the worker finds that the
task is canceled through the canceled flag returned by RecordActivityTaskHeartbeat, it
should cancel the task, clean up and then call RespondActivityTaskCanceled.  A task is
considered open from the time that it is scheduled until it is closed. Therefore a task is
reported as open while a worker is processing it. A task is closed after it has been
specified in a call to RespondActivityTaskCompleted, RespondActivityTaskCanceled,
RespondActivityTaskFailed, or the task has timed out.  Access Control  You can use IAM
policies to control this action's access to Amazon SWF resources as follows:   Use a
Resource element with the domain name to limit the action to only specified domains.   Use
an Action element to allow or deny permission to call this action.   You cannot use an IAM
policy to constrain this action's parameters.   If the caller doesn't have sufficient
permissions to invoke the action, or the parameter values fall outside the specified
constraints, the action fails. The associated event attribute's cause parameter is set to
OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage
Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `task_token`: The taskToken of the ActivityTask.   taskToken is generated by the service
  and should be treated as an opaque value. If the task is passed to another process, its
  taskToken must also be passed. This enables it to provide its progress and respond with
  results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"result"`: The result of the activity task. It is a free form string that is
  implementation specific.
"""
function respond_activity_task_completed(
    taskToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "RespondActivityTaskCompleted",
        Dict{String,Any}("taskToken" => taskToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function respond_activity_task_completed(
    taskToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "RespondActivityTaskCompleted",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("taskToken" => taskToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    respond_activity_task_failed(task_token)
    respond_activity_task_failed(task_token, params::Dict{String,<:Any})

Used by workers to tell the service that the ActivityTask identified by the taskToken has
failed with reason (if specified). The reason and details appear in the ActivityTaskFailed
event added to the workflow history. A task is considered open from the time that it is
scheduled until it is closed. Therefore a task is reported as open while a worker is
processing it. A task is closed after it has been specified in a call to
RespondActivityTaskCompleted, RespondActivityTaskCanceled, RespondActivityTaskFailed, or
the task has timed out.  Access Control  You can use IAM policies to control this action's
access to Amazon SWF resources as follows:   Use a Resource element with the domain name to
limit the action to only specified domains.   Use an Action element to allow or deny
permission to call this action.   You cannot use an IAM policy to constrain this action's
parameters.   If the caller doesn't have sufficient permissions to invoke the action, or
the parameter values fall outside the specified constraints, the action fails. The
associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details
and example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows in the
Amazon SWF Developer Guide.

# Arguments
- `task_token`: The taskToken of the ActivityTask.   taskToken is generated by the service
  and should be treated as an opaque value. If the task is passed to another process, its
  taskToken must also be passed. This enables it to provide its progress and respond with
  results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"details"`:  Detailed information about the failure.
- `"reason"`: Description of the error that may assist in diagnostics.
"""
function respond_activity_task_failed(
    taskToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "RespondActivityTaskFailed",
        Dict{String,Any}("taskToken" => taskToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function respond_activity_task_failed(
    taskToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "RespondActivityTaskFailed",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("taskToken" => taskToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    respond_decision_task_completed(task_token)
    respond_decision_task_completed(task_token, params::Dict{String,<:Any})

Used by deciders to tell the service that the DecisionTask identified by the taskToken has
successfully completed. The decisions argument specifies the list of decisions made while
processing the task. A DecisionTaskCompleted event is added to the workflow history. The
executionContext specified is attached to the event in the workflow execution history.
Access Control  If an IAM policy grants permission to use RespondDecisionTaskCompleted, it
can express permissions for the list of decisions in the decisions parameter. Each of the
decisions has one or more parameters, much like a regular API call. To allow for policies
to be as readable as possible, you can express permissions on decisions as if they were
actual API calls, including applying conditions to some parameters. For more information,
see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `task_token`: The taskToken from the DecisionTask.   taskToken is generated by the
  service and should be treated as an opaque value. If the task is passed to another process,
  its taskToken must also be passed. This enables it to provide its progress and respond with
  results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"decisions"`: The list of decisions (possibly empty) made by the decider while
  processing this decision task. See the docs for the Decision structure for details.
- `"executionContext"`: User defined context to add to workflow execution.
- `"taskList"`: The task list to use for the future decision tasks of this workflow
  execution. This list overrides the original task list you specified while starting the
  workflow execution.
- `"taskListScheduleToStartTimeout"`: Specifies a timeout (in seconds) for the task list
  override. When this parameter is missing, the task list override is permanent. This
  parameter makes it possible to temporarily override the task list. If a decision task
  scheduled on the override task list is not started within the timeout, the decision task
  will time out. Amazon SWF will revert the override and schedule a new decision task to the
  original task list. If a decision task scheduled on the override task list is started
  within the timeout, but not completed within the start-to-close timeout, Amazon SWF will
  also revert the override and schedule a new decision task to the original task list.
"""
function respond_decision_task_completed(
    taskToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "RespondDecisionTaskCompleted",
        Dict{String,Any}("taskToken" => taskToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function respond_decision_task_completed(
    taskToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "RespondDecisionTaskCompleted",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("taskToken" => taskToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    signal_workflow_execution(domain, signal_name, workflow_id)
    signal_workflow_execution(domain, signal_name, workflow_id, params::Dict{String,<:Any})

Records a WorkflowExecutionSignaled event in the workflow execution history and creates a
decision task for the workflow execution identified by the given domain, workflowId and
runId. The event is recorded with the specified user defined signalName and input (if
provided).  If a runId isn't specified, then the WorkflowExecutionSignaled event is
recorded in the history of the current open workflow with the matching workflowId in the
domain.   If the specified workflow execution isn't open, this method fails with
UnknownResource.   Access Control  You can use IAM policies to control this action's access
to Amazon SWF resources as follows:   Use a Resource element with the domain name to limit
the action to only specified domains.   Use an Action element to allow or deny permission
to call this action.   You cannot use an IAM policy to constrain this action's parameters.
 If the caller doesn't have sufficient permissions to invoke the action, or the parameter
values fall outside the specified constraints, the action fails. The associated event
attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM
policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF
Developer Guide.

# Arguments
- `domain`: The name of the domain containing the workflow execution to signal.
- `signal_name`: The name of the signal. This name must be meaningful to the target
  workflow.
- `workflow_id`: The workflowId of the workflow execution to signal.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"input"`: Data to attach to the WorkflowExecutionSignaled event in the target workflow
  execution's history.
- `"runId"`: The runId of the workflow execution to signal.
"""
function signal_workflow_execution(
    domain, signalName, workflowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "SignalWorkflowExecution",
        Dict{String,Any}(
            "domain" => domain, "signalName" => signalName, "workflowId" => workflowId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function signal_workflow_execution(
    domain,
    signalName,
    workflowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "SignalWorkflowExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "domain" => domain,
                    "signalName" => signalName,
                    "workflowId" => workflowId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_workflow_execution(domain, workflow_id, workflow_type)
    start_workflow_execution(domain, workflow_id, workflow_type, params::Dict{String,<:Any})

Starts an execution of the workflow type in the specified domain using the provided
workflowId and input data. This action returns the newly started workflow execution.
Access Control  You can use IAM policies to control this action's access to Amazon SWF
resources as follows:   Use a Resource element with the domain name to limit the action to
only specified domains.   Use an Action element to allow or deny permission to call this
action.   Constrain the following parameters by using a Condition element with the
appropriate keys.    tagList.member.0: The key is swf:tagList.member.0.
tagList.member.1: The key is swf:tagList.member.1.    tagList.member.2: The key is
swf:tagList.member.2.    tagList.member.3: The key is swf:tagList.member.3.
tagList.member.4: The key is swf:tagList.member.4.    taskList: String constraint. The key
is swf:taskList.name.    workflowType.name: String constraint. The key is
swf:workflowType.name.    workflowType.version: String constraint. The key is
swf:workflowType.version.     If the caller doesn't have sufficient permissions to invoke
the action, or the parameter values fall outside the specified constraints, the action
fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF
Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain in which the workflow execution is created. The
  specified string must not contain a : (colon), / (slash), | (vertical bar), or any control
  characters (u0000-u001f | u007f-u009f). Also, it must not be the literal string arn.
- `workflow_id`: The user defined identifier associated with the workflow execution. You
  can use this to associate a custom identifier with the workflow execution. You may specify
  the same identifier if a workflow execution is logically a restart of a previous execution.
  You cannot have two open workflow executions with the same workflowId at the same time
  within the same domain. The specified string must not contain a : (colon), / (slash), |
  (vertical bar), or any control characters (u0000-u001f | u007f-u009f). Also, it must not be
  the literal string arn.
- `workflow_type`: The type of the workflow to start.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"childPolicy"`: If set, specifies the policy to use for the child workflow executions of
  this workflow execution if it is terminated, by calling the TerminateWorkflowExecution
  action explicitly or due to an expired timeout. This policy overrides the default child
  policy specified when registering the workflow type using RegisterWorkflowType. The
  supported child policies are:    TERMINATE – The child executions are terminated.
  REQUEST_CANCEL – A request to cancel is attempted for each child execution by recording a
  WorkflowExecutionCancelRequested event in its history. It is up to the decider to take
  appropriate actions when it receives an execution history with this event.    ABANDON –
  No action is taken. The child executions continue to run.    A child policy for this
  workflow execution must be specified either as a default for the workflow type or through
  this parameter. If neither this parameter is set nor a default child policy was specified
  at registration time then a fault is returned.
- `"executionStartToCloseTimeout"`: The total duration for this workflow execution. This
  overrides the defaultExecutionStartToCloseTimeout specified when registering the workflow
  type. The duration is specified in seconds; an integer greater than or equal to 0.
  Exceeding this limit causes the workflow execution to time out. Unlike some of the other
  timeout parameters in Amazon SWF, you cannot specify a value of \"NONE\" for this timeout;
  there is a one-year max limit on the time that a workflow execution can run.  An execution
  start-to-close timeout must be specified either through this parameter or as a default when
  the workflow type is registered. If neither this parameter nor a default execution
  start-to-close timeout is specified, a fault is returned.
- `"input"`: The input for the workflow execution. This is a free form string which should
  be meaningful to the workflow you are starting. This input is made available to the new
  workflow execution in the WorkflowExecutionStarted history event.
- `"lambdaRole"`: The IAM role to attach to this workflow execution.  Executions of this
  workflow type need IAM roles to invoke Lambda functions. If you don't attach an IAM role,
  any attempt to schedule a Lambda task fails. This results in a ScheduleLambdaFunctionFailed
  history event. For more information, see
  https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html in the Amazon
  SWF Developer Guide.
- `"tagList"`: The list of tags to associate with the workflow execution. You can specify a
  maximum of 5 tags. You can list workflow executions with a specific tag by calling
  ListOpenWorkflowExecutions or ListClosedWorkflowExecutions and specifying a TagFilter.
- `"taskList"`: The task list to use for the decision tasks generated for this workflow
  execution. This overrides the defaultTaskList specified when registering the workflow type.
   A task list for this workflow execution must be specified either as a default for the
  workflow type or through this parameter. If neither this parameter is set nor a default
  task list was specified at registration time then a fault is returned.  The specified
  string must not contain a : (colon), / (slash), | (vertical bar), or any control characters
  (u0000-u001f | u007f-u009f). Also, it must not be the literal string arn.
- `"taskPriority"`: The task priority to use for this workflow execution. This overrides
  any default priority that was assigned when the workflow type was registered. If not set,
  then the default task priority for the workflow type is used. Valid values are integers
  that range from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647).
  Higher numbers indicate higher priority. For more information about setting task priority,
  see Setting Task Priority in the Amazon SWF Developer Guide.
- `"taskStartToCloseTimeout"`: Specifies the maximum duration of decision tasks for this
  workflow execution. This parameter overrides the defaultTaskStartToCloseTimout specified
  when registering the workflow type using RegisterWorkflowType. The duration is specified in
  seconds, an integer greater than or equal to 0. You can use NONE to specify unlimited
  duration.  A task start-to-close timeout for this workflow execution must be specified
  either as a default for the workflow type or through this parameter. If neither this
  parameter is set nor a default task start-to-close timeout was specified at registration
  time then a fault is returned.
"""
function start_workflow_execution(
    domain, workflowId, workflowType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "StartWorkflowExecution",
        Dict{String,Any}(
            "domain" => domain, "workflowId" => workflowId, "workflowType" => workflowType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_workflow_execution(
    domain,
    workflowId,
    workflowType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "StartWorkflowExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "domain" => domain,
                    "workflowId" => workflowId,
                    "workflowType" => workflowType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Add a tag to a Amazon SWF domain.  Amazon SWF supports a maximum of 50 tags per resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) for the Amazon SWF domain.
- `tags`: The list of tags to add to a domain.  Tags may only contain unicode letters,
  digits, whitespace, or these symbols: _ . : / = + - @.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return swf(
        "TagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    terminate_workflow_execution(domain, workflow_id)
    terminate_workflow_execution(domain, workflow_id, params::Dict{String,<:Any})

Records a WorkflowExecutionTerminated event and forces closure of the workflow execution
identified by the given domain, runId, and workflowId. The child policy, registered with
the workflow type or specified when starting this execution, is applied to any open child
workflow executions of this workflow execution.  If the identified workflow execution was
in progress, it is terminated immediately.   If a runId isn't specified, then the
WorkflowExecutionTerminated event is recorded in the history of the current open workflow
with the matching workflowId in the domain.   You should consider using
RequestCancelWorkflowExecution action instead because it allows the workflow to gracefully
close while TerminateWorkflowExecution doesn't.   Access Control  You can use IAM policies
to control this action's access to Amazon SWF resources as follows:   Use a Resource
element with the domain name to limit the action to only specified domains.   Use an Action
element to allow or deny permission to call this action.   You cannot use an IAM policy to
constrain this action's parameters.   If the caller doesn't have sufficient permissions to
invoke the action, or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's cause parameter is set to
OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to Manage
Access to Amazon SWF Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The domain of the workflow execution to terminate.
- `workflow_id`: The workflowId of the workflow execution to terminate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"childPolicy"`: If set, specifies the policy to use for the child workflow executions of
  the workflow execution being terminated. This policy overrides the child policy specified
  for the workflow execution at registration time or when starting the execution. The
  supported child policies are:    TERMINATE – The child executions are terminated.
  REQUEST_CANCEL – A request to cancel is attempted for each child execution by recording a
  WorkflowExecutionCancelRequested event in its history. It is up to the decider to take
  appropriate actions when it receives an execution history with this event.    ABANDON –
  No action is taken. The child executions continue to run.    A child policy for this
  workflow execution must be specified either as a default for the workflow type or through
  this parameter. If neither this parameter is set nor a default child policy was specified
  at registration time then a fault is returned.
- `"details"`:  Details for terminating the workflow execution.
- `"reason"`:  A descriptive reason for terminating the workflow execution.
- `"runId"`: The runId of the workflow execution to terminate.
"""
function terminate_workflow_execution(
    domain, workflowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "TerminateWorkflowExecution",
        Dict{String,Any}("domain" => domain, "workflowId" => workflowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function terminate_workflow_execution(
    domain,
    workflowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "TerminateWorkflowExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domain" => domain, "workflowId" => workflowId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    undeprecate_activity_type(activity_type, domain)
    undeprecate_activity_type(activity_type, domain, params::Dict{String,<:Any})

Undeprecates a previously deprecated activity type. After an activity type has been
undeprecated, you can create new tasks of that activity type.  This operation is eventually
consistent. The results are best effort and may not exactly reflect recent updates and
changes.   Access Control  You can use IAM policies to control this action's access to
Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the
action to only specified domains.   Use an Action element to allow or deny permission to
call this action.   Constrain the following parameters by using a Condition element with
the appropriate keys.    activityType.name: String constraint. The key is
swf:activityType.name.    activityType.version: String constraint. The key is
swf:activityType.version.     If the caller doesn't have sufficient permissions to invoke
the action, or the parameter values fall outside the specified constraints, the action
fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF
Workflows in the Amazon SWF Developer Guide.

# Arguments
- `activity_type`: The activity type to undeprecate.
- `domain`: The name of the domain of the deprecated activity type.

"""
function undeprecate_activity_type(
    activityType, domain; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "UndeprecateActivityType",
        Dict{String,Any}("activityType" => activityType, "domain" => domain);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function undeprecate_activity_type(
    activityType,
    domain,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "UndeprecateActivityType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("activityType" => activityType, "domain" => domain),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    undeprecate_domain(name)
    undeprecate_domain(name, params::Dict{String,<:Any})

Undeprecates a previously deprecated domain. After a domain has been undeprecated it can be
used to create new workflow executions or register new types.  This operation is eventually
consistent. The results are best effort and may not exactly reflect recent updates and
changes.   Access Control  You can use IAM policies to control this action's access to
Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the
action to only specified domains.   Use an Action element to allow or deny permission to
call this action.   You cannot use an IAM policy to constrain this action's parameters.
If the caller doesn't have sufficient permissions to invoke the action, or the parameter
values fall outside the specified constraints, the action fails. The associated event
attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM
policies, see Using IAM to Manage Access to Amazon SWF Workflows in the Amazon SWF
Developer Guide.

# Arguments
- `name`: The name of the domain of the deprecated workflow type.

"""
function undeprecate_domain(name; aws_config::AbstractAWSConfig=current_aws_config())
    return swf(
        "UndeprecateDomain",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function undeprecate_domain(
    name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "UndeprecateDomain",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    undeprecate_workflow_type(domain, workflow_type)
    undeprecate_workflow_type(domain, workflow_type, params::Dict{String,<:Any})

Undeprecates a previously deprecated workflow type. After a workflow type has been
undeprecated, you can create new executions of that type.   This operation is eventually
consistent. The results are best effort and may not exactly reflect recent updates and
changes.   Access Control  You can use IAM policies to control this action's access to
Amazon SWF resources as follows:   Use a Resource element with the domain name to limit the
action to only specified domains.   Use an Action element to allow or deny permission to
call this action.   Constrain the following parameters by using a Condition element with
the appropriate keys.    workflowType.name: String constraint. The key is
swf:workflowType.name.    workflowType.version: String constraint. The key is
swf:workflowType.version.     If the caller doesn't have sufficient permissions to invoke
the action, or the parameter values fall outside the specified constraints, the action
fails. The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
For details and example IAM policies, see Using IAM to Manage Access to Amazon SWF
Workflows in the Amazon SWF Developer Guide.

# Arguments
- `domain`: The name of the domain of the deprecated workflow type.
- `workflow_type`: The name of the domain of the deprecated workflow type.

"""
function undeprecate_workflow_type(
    domain, workflowType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "UndeprecateWorkflowType",
        Dict{String,Any}("domain" => domain, "workflowType" => workflowType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function undeprecate_workflow_type(
    domain,
    workflowType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "UndeprecateWorkflowType",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("domain" => domain, "workflowType" => workflowType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Remove a tag from a Amazon SWF domain.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) for the Amazon SWF domain.
- `tag_keys`: The list of tags to remove from the Amazon SWF domain.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return swf(
        "UntagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return swf(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
