# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: transfer
using AWS.Compat
using AWS.UUIDs

"""
    create_access(external_id, role, server_id)
    create_access(external_id, role, server_id, params::Dict{String,<:Any})

Used by administrators to choose which groups in the directory should have access to upload
and download files over the enabled protocols using Transfer Family. For example, a
Microsoft Active Directory might contain 50,000 users, but only a small fraction might need
the ability to transfer files to the server. An administrator can use CreateAccess to limit
the access to the correct set of users who need this ability.

# Arguments
- `external_id`: A unique identifier that is required to identify specific groups within
  your directory. The users of the group that you associate have access to your Amazon S3 or
  Amazon EFS resources over the enabled protocols using Transfer Family. If you know the
  group name, you can view the SID values by running the following command using Windows
  PowerShell.  Get-ADGroup -Filter {samAccountName -like \"YourGroupName*\"} -Properties * |
  Select SamAccountName,ObjectSid  In that command, replace YourGroupName with the name of
  your Active Directory group. The regular expression used to validate this parameter is a
  string of characters consisting of uppercase and lowercase alphanumeric characters with no
  spaces. You can also include underscores or any of the following characters: =,.@:/-
- `role`: The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
  that controls your users' access to your Amazon S3 bucket or Amazon EFS file system. The
  policies attached to this role determine the level of access that you want to provide your
  users when transferring files into and out of your Amazon S3 bucket or Amazon EFS file
  system. The IAM role should also contain a trust relationship that allows the server to
  access your resources when servicing your users' transfer requests.
- `server_id`: A system-assigned unique identifier for a server instance. This is the
  specific server that you added your user to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"HomeDirectory"`: The landing directory (folder) for a user when they log in to the
  server using the client. A HomeDirectory example is /bucket_name/home/mydirectory.  The
  HomeDirectory parameter is only used if HomeDirectoryType is set to PATH.
- `"HomeDirectoryMappings"`: Logical directory mappings that specify what Amazon S3 or
  Amazon EFS paths and keys should be visible to your user and how you want to make them
  visible. You must specify the Entry and Target pair, where Entry shows how the path is made
  visible and Target is the actual Amazon S3 or Amazon EFS path. If you only specify a
  target, it is displayed as is. You also must ensure that your Identity and Access
  Management (IAM) role provides access to paths in Target. This value can be set only when
  HomeDirectoryType is set to LOGICAL. The following is an Entry and Target pair example.  [
  { \"Entry\": \"/directory1\", \"Target\": \"/bucket_name/home/mydirectory\" } ]  In most
  cases, you can use this value instead of the session policy to lock down your user to the
  designated home directory (\"chroot\"). To do this, you can set Entry to / and set Target
  to the HomeDirectory parameter value. The following is an Entry and Target pair example for
  chroot.  [ { \"Entry\": \"/\", \"Target\": \"/bucket_name/home/mydirectory\" } ]
- `"HomeDirectoryType"`: The type of landing directory (folder) that you want your users'
  home directory to be when they log in to the server. If you set it to PATH, the user will
  see the absolute Amazon S3 bucket or Amazon EFS path as is in their file transfer protocol
  clients. If you set it to LOGICAL, you need to provide mappings in the
  HomeDirectoryMappings for how you want to make Amazon S3 or Amazon EFS paths visible to
  your users.  If HomeDirectoryType is LOGICAL, you must provide mappings, using the
  HomeDirectoryMappings parameter. If, on the other hand, HomeDirectoryType is PATH, you
  provide an absolute path using the HomeDirectory parameter. You cannot have both
  HomeDirectory and HomeDirectoryMappings in your template.
- `"Policy"`: A session policy for your user so that you can use the same Identity and
  Access Management (IAM) role across multiple users. This policy scopes down a user's access
  to portions of their Amazon S3 bucket. Variables that you can use inside this policy
  include {Transfer:UserName}, {Transfer:HomeDirectory}, and {Transfer:HomeBucket}.  This
  policy applies only when the domain of ServerId is Amazon S3. Amazon EFS does not use
  session policies. For session policies, Transfer Family stores the policy as a JSON blob,
  instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob
  and pass it in the Policy argument. For an example of a session policy, see Example session
  policy. For more information, see AssumeRole in the Security Token Service API Reference.
- `"PosixProfile"`:
"""
function create_access(
    ExternalId, Role, ServerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "CreateAccess",
        Dict{String,Any}(
            "ExternalId" => ExternalId, "Role" => Role, "ServerId" => ServerId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_access(
    ExternalId,
    Role,
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "CreateAccess",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ExternalId" => ExternalId, "Role" => Role, "ServerId" => ServerId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_agreement(access_role, base_directory, local_profile_id, partner_profile_id, server_id)
    create_agreement(access_role, base_directory, local_profile_id, partner_profile_id, server_id, params::Dict{String,<:Any})

Creates an agreement. An agreement is a bilateral trading partner agreement, or
partnership, between an Transfer Family server and an AS2 process. The agreement defines
the file and message transfer relationship between the server and the AS2 process. To
define an agreement, Transfer Family combines a server, local profile, partner profile,
certificate, and other attributes. The partner is identified with the PartnerProfileId, and
the AS2 process is identified with the LocalProfileId.

# Arguments
- `access_role`: Connectors are used to send files using either the AS2 or SFTP protocol.
  For the access role, provide the Amazon Resource Name (ARN) of the Identity and Access
  Management role to use.  For AS2 connectors  With AS2, you can send files by calling
  StartFileTransfer and specifying the file paths in the request parameter, SendFilePaths. We
  use the file’s parent directory (for example, for --send-file-paths /bucket/dir/file.txt,
  parent directory is /bucket/dir/) to temporarily store a processed AS2 message file, store
  the MDN when we receive them from the partner, and write a final JSON file containing
  relevant metadata of the transmission. So, the AccessRole needs to provide read and write
  access to the parent directory of the file location used in the StartFileTransfer request.
  Additionally, you need to provide read and write access to the parent directory of the
  files that you intend to send with StartFileTransfer. If you are using Basic authentication
  for your AS2 connector, the access role requires the secretsmanager:GetSecretValue
  permission for the secret. If the secret is encrypted using a customer-managed key instead
  of the Amazon Web Services managed key in Secrets Manager, then the role also needs the
  kms:Decrypt permission for that key.  For SFTP connectors  Make sure that the access role
  provides read and write access to the parent directory of the file location that's used in
  the StartFileTransfer request. Additionally, make sure that the role provides
  secretsmanager:GetSecretValue permission to Secrets Manager.
- `base_directory`: The landing directory (folder) for files transferred by using the AS2
  protocol. A BaseDirectory example is /DOC-EXAMPLE-BUCKET/home/mydirectory.
- `local_profile_id`: A unique identifier for the AS2 local profile.
- `partner_profile_id`: A unique identifier for the partner profile used in the agreement.
- `server_id`: A system-assigned unique identifier for a server instance. This is the
  specific server that the agreement uses.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A name or short description to identify the agreement.
- `"Status"`: The status of the agreement. The agreement can be either ACTIVE or INACTIVE.
- `"Tags"`: Key-value pairs that can be used to group and search for agreements.
"""
function create_agreement(
    AccessRole,
    BaseDirectory,
    LocalProfileId,
    PartnerProfileId,
    ServerId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "CreateAgreement",
        Dict{String,Any}(
            "AccessRole" => AccessRole,
            "BaseDirectory" => BaseDirectory,
            "LocalProfileId" => LocalProfileId,
            "PartnerProfileId" => PartnerProfileId,
            "ServerId" => ServerId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_agreement(
    AccessRole,
    BaseDirectory,
    LocalProfileId,
    PartnerProfileId,
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "CreateAgreement",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccessRole" => AccessRole,
                    "BaseDirectory" => BaseDirectory,
                    "LocalProfileId" => LocalProfileId,
                    "PartnerProfileId" => PartnerProfileId,
                    "ServerId" => ServerId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_connector(access_role, url)
    create_connector(access_role, url, params::Dict{String,<:Any})

Creates the connector, which captures the parameters for a connection for the AS2 or SFTP
protocol. For AS2, the connector is required for sending files to an externally hosted AS2
server. For SFTP, the connector is required when sending files to an SFTP server or
receiving files from an SFTP server. For more details about connectors, see Configure AS2
connectors and Create SFTP connectors.  You must specify exactly one configuration object:
either for AS2 (As2Config) or SFTP (SftpConfig).

# Arguments
- `access_role`: Connectors are used to send files using either the AS2 or SFTP protocol.
  For the access role, provide the Amazon Resource Name (ARN) of the Identity and Access
  Management role to use.  For AS2 connectors  With AS2, you can send files by calling
  StartFileTransfer and specifying the file paths in the request parameter, SendFilePaths. We
  use the file’s parent directory (for example, for --send-file-paths /bucket/dir/file.txt,
  parent directory is /bucket/dir/) to temporarily store a processed AS2 message file, store
  the MDN when we receive them from the partner, and write a final JSON file containing
  relevant metadata of the transmission. So, the AccessRole needs to provide read and write
  access to the parent directory of the file location used in the StartFileTransfer request.
  Additionally, you need to provide read and write access to the parent directory of the
  files that you intend to send with StartFileTransfer. If you are using Basic authentication
  for your AS2 connector, the access role requires the secretsmanager:GetSecretValue
  permission for the secret. If the secret is encrypted using a customer-managed key instead
  of the Amazon Web Services managed key in Secrets Manager, then the role also needs the
  kms:Decrypt permission for that key.  For SFTP connectors  Make sure that the access role
  provides read and write access to the parent directory of the file location that's used in
  the StartFileTransfer request. Additionally, make sure that the role provides
  secretsmanager:GetSecretValue permission to Secrets Manager.
- `url`: The URL of the partner's AS2 or SFTP endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"As2Config"`: A structure that contains the parameters for an AS2 connector object.
- `"LoggingRole"`: The Amazon Resource Name (ARN) of the Identity and Access Management
  (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events. When
  set, you can view connector activity in your CloudWatch logs.
- `"SecurityPolicyName"`: Specifies the name of the security policy for the connector.
- `"SftpConfig"`: A structure that contains the parameters for an SFTP connector object.
- `"Tags"`: Key-value pairs that can be used to group and search for connectors. Tags are
  metadata attached to connectors for any purpose.
"""
function create_connector(
    AccessRole, Url; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "CreateConnector",
        Dict{String,Any}("AccessRole" => AccessRole, "Url" => Url);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_connector(
    AccessRole,
    Url,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "CreateConnector",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AccessRole" => AccessRole, "Url" => Url), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_profile(as2_id, profile_type)
    create_profile(as2_id, profile_type, params::Dict{String,<:Any})

Creates the local or partner profile to use for AS2 transfers.

# Arguments
- `as2_id`: The As2Id is the AS2-name, as defined in the RFC 4130. For inbound transfers,
  this is the AS2-From header for the AS2 messages sent from the partner. For outbound
  connectors, this is the AS2-To header for the AS2 messages sent to the partner using the
  StartFileTransfer API operation. This ID cannot include spaces.
- `profile_type`: Determines the type of profile to create:   Specify LOCAL to create a
  local profile. A local profile represents the AS2-enabled Transfer Family server
  organization or party.   Specify PARTNER to create a partner profile. A partner profile
  represents a remote organization, external to Transfer Family.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CertificateIds"`: An array of identifiers for the imported certificates. You use this
  identifier for working with profiles and partner profiles.
- `"Tags"`: Key-value pairs that can be used to group and search for AS2 profiles.
"""
function create_profile(
    As2Id, ProfileType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "CreateProfile",
        Dict{String,Any}("As2Id" => As2Id, "ProfileType" => ProfileType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_profile(
    As2Id,
    ProfileType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "CreateProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("As2Id" => As2Id, "ProfileType" => ProfileType),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_server()
    create_server(params::Dict{String,<:Any})

Instantiates an auto-scaling virtual server based on the selected file transfer protocol in
Amazon Web Services. When you make updates to your file transfer protocol-enabled server or
when you work with users, use the service-generated ServerId property that is assigned to
the newly created server.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Certificate"`: The Amazon Resource Name (ARN) of the Certificate Manager (ACM)
  certificate. Required when Protocols is set to FTPS. To request a new public certificate,
  see Request a public certificate in the Certificate Manager User Guide. To import an
  existing certificate into ACM, see Importing certificates into ACM in the Certificate
  Manager User Guide. To request a private certificate to use FTPS through private IP
  addresses, see Request a private certificate in the Certificate Manager User Guide.
  Certificates with the following cryptographic algorithms and key sizes are supported:
  2048-bit RSA (RSA_2048)   4096-bit RSA (RSA_4096)   Elliptic Prime Curve 256 bit
  (EC_prime256v1)   Elliptic Prime Curve 384 bit (EC_secp384r1)   Elliptic Prime Curve 521
  bit (EC_secp521r1)    The certificate must be a valid SSL/TLS X.509 version 3 certificate
  with FQDN or IP address specified and information about the issuer.
- `"Domain"`: The domain of the storage system that is used for file transfers. There are
  two domains available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File
  System (Amazon EFS). The default value is S3.  After the server is created, the domain
  cannot be changed.
- `"EndpointDetails"`: The virtual private cloud (VPC) endpoint settings that are
  configured for your server. When you host your endpoint within your VPC, you can make your
  endpoint accessible only to resources within your VPC, or you can attach Elastic IP
  addresses and make your endpoint accessible to clients over the internet. Your VPC's
  default security groups are automatically assigned to your endpoint.
- `"EndpointType"`: The type of endpoint that you want your server to use. You can choose
  to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC.
  With an endpoint that is hosted in a VPC, you can restrict access to your server and
  resources only within your VPC or choose to make it internet facing by attaching Elastic IP
  addresses directly to it.   After May 19, 2021, you won't be able to create a server using
  EndpointType=VPC_ENDPOINT in your Amazon Web Services account if your account hasn't
  already done so before May 19, 2021. If you have already created servers with
  EndpointType=VPC_ENDPOINT in your Amazon Web Services account on or before May 19, 2021,
  you will not be affected. After this date, use EndpointType=VPC. For more information, see
  https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vp
  c-endpoint. It is recommended that you use VPC as the EndpointType. With this endpoint
  type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP
  included) with your server's endpoint and use VPC security groups to restrict traffic by
  the client's public IP address. This is not possible with EndpointType set to VPC_ENDPOINT.
- `"HostKey"`: The RSA, ECDSA, or ED25519 private key to use for your SFTP-enabled server.
  You can add multiple host keys, in case you want to rotate keys, or have a set of active
  keys that use different algorithms. Use the following command to generate an RSA 2048 bit
  key with no passphrase:  ssh-keygen -t rsa -b 2048 -N \"\" -m PEM -f my-new-server-key. Use
  a minimum value of 2048 for the -b option. You can create a stronger key by using 3072 or
  4096. Use the following command to generate an ECDSA 256 bit key with no passphrase:
  ssh-keygen -t ecdsa -b 256 -N \"\" -m PEM -f my-new-server-key. Valid values for the -b
  option for ECDSA are 256, 384, and 521. Use the following command to generate an ED25519
  key with no passphrase:  ssh-keygen -t ed25519 -N \"\" -f my-new-server-key. For all of
  these commands, you can replace my-new-server-key with a string of your choice.  If you
  aren't planning to migrate existing users from an existing SFTP-enabled server to a new
  server, don't update the host key. Accidentally changing a server's host key can be
  disruptive.  For more information, see Manage host keys for your SFTP-enabled server in the
  Transfer Family User Guide.
- `"IdentityProviderDetails"`: Required when IdentityProviderType is set to
  AWS_DIRECTORY_SERVICE, Amazon Web Services_LAMBDA or API_GATEWAY. Accepts an array
  containing all of the information required to use a directory in AWS_DIRECTORY_SERVICE or
  invoke a customer-supplied authentication API, including the API Gateway URL. Not required
  when IdentityProviderType is set to SERVICE_MANAGED.
- `"IdentityProviderType"`: The mode of authentication for a server. The default value is
  SERVICE_MANAGED, which allows you to store and access user credentials within the Transfer
  Family service. Use AWS_DIRECTORY_SERVICE to provide access to Active Directory groups in
  Directory Service for Microsoft Active Directory or Microsoft Active Directory in your
  on-premises environment or in Amazon Web Services using AD Connector. This option also
  requires you to provide a Directory ID by using the IdentityProviderDetails parameter. Use
  the API_GATEWAY value to integrate with an identity provider of your choosing. The
  API_GATEWAY setting requires you to provide an Amazon API Gateway endpoint URL to call for
  authentication by using the IdentityProviderDetails parameter. Use the AWS_LAMBDA value to
  directly use an Lambda function as your identity provider. If you choose this value, you
  must specify the ARN for the Lambda function in the Function parameter for the
  IdentityProviderDetails data type.
- `"LoggingRole"`: The Amazon Resource Name (ARN) of the Identity and Access Management
  (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or
  Amazon EFSevents. When set, you can view user activity in your CloudWatch logs.
- `"PostAuthenticationLoginBanner"`: Specifies a string to display when users connect to a
  server. This string is displayed after the user authenticates.  The SFTP protocol does not
  support post-authentication display banners.
- `"PreAuthenticationLoginBanner"`: Specifies a string to display when users connect to a
  server. This string is displayed before the user authenticates. For example, the following
  banner displays details about using the system:  This system is for the use of authorized
  users only. Individuals using this computer system without authority, or in excess of their
  authority, are subject to having all of their activities on this system monitored and
  recorded by system personnel.
- `"ProtocolDetails"`: The protocol settings that are configured for your server.    To
  indicate passive mode (for FTP and FTPS protocols), use the PassiveIp parameter. Enter a
  single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or
  load balancer.    To ignore the error that is generated when the client attempts to use the
  SETSTAT command on a file that you are uploading to an Amazon S3 bucket, use the
  SetStatOption parameter. To have the Transfer Family server ignore the SETSTAT command and
  upload files without needing to make any changes to your SFTP client, set the value to
  ENABLE_NO_OP. If you set the SetStatOption parameter to ENABLE_NO_OP, Transfer Family
  generates a log entry to Amazon CloudWatch Logs, so that you can determine when the client
  is making a SETSTAT call.   To determine whether your Transfer Family server resumes
  recent, negotiated sessions through a unique session ID, use the TlsSessionResumptionMode
  parameter.    As2Transports indicates the transport method for the AS2 messages. Currently,
  only HTTP is supported.
- `"Protocols"`: Specifies the file transfer protocol or protocols over which your file
  transfer protocol client can connect to your server's endpoint. The available protocols
  are:    SFTP (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH    FTPS
  (File Transfer Protocol Secure): File transfer with TLS encryption    FTP (File Transfer
  Protocol): Unencrypted file transfer    AS2 (Applicability Statement 2): used for
  transporting structured business-to-business data      If you select FTPS, you must choose
  a certificate stored in Certificate Manager (ACM) which is used to identify your server
  when clients connect to it over FTPS.   If Protocol includes either FTP or FTPS, then the
  EndpointType must be VPC and the IdentityProviderType must be either AWS_DIRECTORY_SERVICE,
  AWS_LAMBDA, or API_GATEWAY.   If Protocol includes FTP, then AddressAllocationIds cannot be
  associated.   If Protocol is set only to SFTP, the EndpointType can be set to PUBLIC and
  the IdentityProviderType can be set any of the supported identity types: SERVICE_MANAGED,
  AWS_DIRECTORY_SERVICE, AWS_LAMBDA, or API_GATEWAY.   If Protocol includes AS2, then the
  EndpointType must be VPC, and domain must be Amazon S3.
- `"S3StorageOptions"`: Specifies whether or not performance for your Amazon S3 directories
  is optimized. This is disabled by default. By default, home directory mappings have a TYPE
  of DIRECTORY. If you enable this option, you would then need to explicitly set the
  HomeDirectoryMapEntry Type to FILE if you want a mapping to have a file target.
- `"SecurityPolicyName"`: Specifies the name of the security policy for the server.
- `"StructuredLogDestinations"`: Specifies the log groups to which your server logs are
  sent. To specify a log group, you must provide the ARN for an existing log group. In this
  case, the format of the log group is as follows:
  arn:aws:logs:region-name:amazon-account-id:log-group:log-group-name:*  For example,
  arn:aws:logs:us-east-1:111122223333:log-group:mytestgroup:*  If you have previously
  specified a log group for a server, you can clear it, and in effect turn off structured
  logging, by providing an empty value for this parameter in an update-server call. For
  example:  update-server --server-id s-1234567890abcdef0 --structured-log-destinations
- `"Tags"`: Key-value pairs that can be used to group and search for servers.
- `"WorkflowDetails"`: Specifies the workflow ID for the workflow to assign and the
  execution role that's used for executing the workflow. In addition to a workflow to execute
  when a file is uploaded completely, WorkflowDetails can also contain a workflow ID (and
  execution role) for a workflow to execute on partial upload. A partial upload occurs when
  the server session disconnects while the file is still being uploaded.
"""
function create_server(; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer("CreateServer"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function create_server(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "CreateServer", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    create_user(role, server_id, user_name)
    create_user(role, server_id, user_name, params::Dict{String,<:Any})

Creates a user and associates them with an existing file transfer protocol-enabled server.
You can only create and associate users with servers that have the IdentityProviderType set
to SERVICE_MANAGED. Using parameters for CreateUser, you can specify the user name, set the
home directory, store the user's public key, and assign the user's Identity and Access
Management (IAM) role. You can also optionally add a session policy, and assign metadata
with tags that can be used to group and search for users.

# Arguments
- `role`: The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
  that controls your users' access to your Amazon S3 bucket or Amazon EFS file system. The
  policies attached to this role determine the level of access that you want to provide your
  users when transferring files into and out of your Amazon S3 bucket or Amazon EFS file
  system. The IAM role should also contain a trust relationship that allows the server to
  access your resources when servicing your users' transfer requests.
- `server_id`: A system-assigned unique identifier for a server instance. This is the
  specific server that you added your user to.
- `user_name`: A unique string that identifies a user and is associated with a ServerId.
  This user name must be a minimum of 3 and a maximum of 100 characters long. The following
  are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen '-', period '.', and at sign
  '@'. The user name can't start with a hyphen, period, or at sign.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"HomeDirectory"`: The landing directory (folder) for a user when they log in to the
  server using the client. A HomeDirectory example is /bucket_name/home/mydirectory.  The
  HomeDirectory parameter is only used if HomeDirectoryType is set to PATH.
- `"HomeDirectoryMappings"`: Logical directory mappings that specify what Amazon S3 or
  Amazon EFS paths and keys should be visible to your user and how you want to make them
  visible. You must specify the Entry and Target pair, where Entry shows how the path is made
  visible and Target is the actual Amazon S3 or Amazon EFS path. If you only specify a
  target, it is displayed as is. You also must ensure that your Identity and Access
  Management (IAM) role provides access to paths in Target. This value can be set only when
  HomeDirectoryType is set to LOGICAL. The following is an Entry and Target pair example.  [
  { \"Entry\": \"/directory1\", \"Target\": \"/bucket_name/home/mydirectory\" } ]  In most
  cases, you can use this value instead of the session policy to lock your user down to the
  designated home directory (\"chroot\"). To do this, you can set Entry to / and set Target
  to the value the user should see for their home directory when they log in. The following
  is an Entry and Target pair example for chroot.  [ { \"Entry\": \"/\", \"Target\":
  \"/bucket_name/home/mydirectory\" } ]
- `"HomeDirectoryType"`: The type of landing directory (folder) that you want your users'
  home directory to be when they log in to the server. If you set it to PATH, the user will
  see the absolute Amazon S3 bucket or Amazon EFS path as is in their file transfer protocol
  clients. If you set it to LOGICAL, you need to provide mappings in the
  HomeDirectoryMappings for how you want to make Amazon S3 or Amazon EFS paths visible to
  your users.  If HomeDirectoryType is LOGICAL, you must provide mappings, using the
  HomeDirectoryMappings parameter. If, on the other hand, HomeDirectoryType is PATH, you
  provide an absolute path using the HomeDirectory parameter. You cannot have both
  HomeDirectory and HomeDirectoryMappings in your template.
- `"Policy"`: A session policy for your user so that you can use the same Identity and
  Access Management (IAM) role across multiple users. This policy scopes down a user's access
  to portions of their Amazon S3 bucket. Variables that you can use inside this policy
  include {Transfer:UserName}, {Transfer:HomeDirectory}, and {Transfer:HomeBucket}.  This
  policy applies only when the domain of ServerId is Amazon S3. Amazon EFS does not use
  session policies. For session policies, Transfer Family stores the policy as a JSON blob,
  instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob
  and pass it in the Policy argument. For an example of a session policy, see Example session
  policy. For more information, see AssumeRole in the Amazon Web Services Security Token
  Service API Reference.
- `"PosixProfile"`: Specifies the full POSIX identity, including user ID (Uid), group ID
  (Gid), and any secondary groups IDs (SecondaryGids), that controls your users' access to
  your Amazon EFS file systems. The POSIX permissions that are set on files and directories
  in Amazon EFS determine the level of access your users get when transferring files into and
  out of your Amazon EFS file systems.
- `"SshPublicKeyBody"`: The public portion of the Secure Shell (SSH) key used to
  authenticate the user to the server. The three standard SSH public key format elements are
  &lt;key type&gt;, &lt;body base64&gt;, and an optional &lt;comment&gt;, with spaces between
  each element. Transfer Family accepts RSA, ECDSA, and ED25519 keys.   For RSA keys, the key
  type is ssh-rsa.   For ED25519 keys, the key type is ssh-ed25519.   For ECDSA keys, the key
  type is either ecdsa-sha2-nistp256, ecdsa-sha2-nistp384, or ecdsa-sha2-nistp521, depending
  on the size of the key you generated.
- `"Tags"`: Key-value pairs that can be used to group and search for users. Tags are
  metadata attached to users for any purpose.
"""
function create_user(
    Role, ServerId, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "CreateUser",
        Dict{String,Any}("Role" => Role, "ServerId" => ServerId, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user(
    Role,
    ServerId,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "CreateUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Role" => Role, "ServerId" => ServerId, "UserName" => UserName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_workflow(steps)
    create_workflow(steps, params::Dict{String,<:Any})

 Allows you to create a workflow with specified steps and step details the workflow invokes
after file transfer completes. After creating a workflow, you can associate the workflow
created with any transfer servers by specifying the workflow-details field in CreateServer
and UpdateServer operations.

# Arguments
- `steps`: Specifies the details for the steps that are in the specified workflow.  The
  TYPE specifies which of the following actions is being taken for this step.      COPY  -
  Copy the file to another location.     CUSTOM  - Perform a custom step with an Lambda
  function target.     DECRYPT  - Decrypt a file that was encrypted before it was uploaded.
    DELETE  - Delete the file.     TAG  - Add a tag to the file.     Currently, copying and
  tagging are supported only on S3.    For file location, you specify either the Amazon S3
  bucket and key, or the Amazon EFS file system ID and path.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A textual description for the workflow.
- `"OnExceptionSteps"`: Specifies the steps (actions) to take if errors are encountered
  during execution of the workflow.  For custom steps, the Lambda function needs to send
  FAILURE to the call back API to kick off the exception steps. Additionally, if the Lambda
  does not send SUCCESS before it times out, the exception steps are executed.
- `"Tags"`: Key-value pairs that can be used to group and search for workflows. Tags are
  metadata attached to workflows for any purpose.
"""
function create_workflow(Steps; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "CreateWorkflow",
        Dict{String,Any}("Steps" => Steps);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_workflow(
    Steps, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "CreateWorkflow",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Steps" => Steps), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_access(external_id, server_id)
    delete_access(external_id, server_id, params::Dict{String,<:Any})

Allows you to delete the access specified in the ServerID and ExternalID parameters.

# Arguments
- `external_id`: A unique identifier that is required to identify specific groups within
  your directory. The users of the group that you associate have access to your Amazon S3 or
  Amazon EFS resources over the enabled protocols using Transfer Family. If you know the
  group name, you can view the SID values by running the following command using Windows
  PowerShell.  Get-ADGroup -Filter {samAccountName -like \"YourGroupName*\"} -Properties * |
  Select SamAccountName,ObjectSid  In that command, replace YourGroupName with the name of
  your Active Directory group. The regular expression used to validate this parameter is a
  string of characters consisting of uppercase and lowercase alphanumeric characters with no
  spaces. You can also include underscores or any of the following characters: =,.@:/-
- `server_id`: A system-assigned unique identifier for a server that has this user assigned.

"""
function delete_access(
    ExternalId, ServerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "DeleteAccess",
        Dict{String,Any}("ExternalId" => ExternalId, "ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_access(
    ExternalId,
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DeleteAccess",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ExternalId" => ExternalId, "ServerId" => ServerId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_agreement(agreement_id, server_id)
    delete_agreement(agreement_id, server_id, params::Dict{String,<:Any})

Delete the agreement that's specified in the provided AgreementId.

# Arguments
- `agreement_id`: A unique identifier for the agreement. This identifier is returned when
  you create an agreement.
- `server_id`: The server identifier associated with the agreement that you are deleting.

"""
function delete_agreement(
    AgreementId, ServerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "DeleteAgreement",
        Dict{String,Any}("AgreementId" => AgreementId, "ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_agreement(
    AgreementId,
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DeleteAgreement",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AgreementId" => AgreementId, "ServerId" => ServerId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_certificate(certificate_id)
    delete_certificate(certificate_id, params::Dict{String,<:Any})

Deletes the certificate that's specified in the CertificateId parameter.

# Arguments
- `certificate_id`: The identifier of the certificate object that you are deleting.

"""
function delete_certificate(
    CertificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "DeleteCertificate",
        Dict{String,Any}("CertificateId" => CertificateId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_certificate(
    CertificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DeleteCertificate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CertificateId" => CertificateId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_connector(connector_id)
    delete_connector(connector_id, params::Dict{String,<:Any})

Deletes the connector that's specified in the provided ConnectorId.

# Arguments
- `connector_id`: The unique identifier for the connector.

"""
function delete_connector(ConnectorId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "DeleteConnector",
        Dict{String,Any}("ConnectorId" => ConnectorId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_connector(
    ConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DeleteConnector",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConnectorId" => ConnectorId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_host_key(host_key_id, server_id)
    delete_host_key(host_key_id, server_id, params::Dict{String,<:Any})

Deletes the host key that's specified in the HostKeyId parameter.

# Arguments
- `host_key_id`: The identifier of the host key that you are deleting.
- `server_id`: The identifier of the server that contains the host key that you are
  deleting.

"""
function delete_host_key(
    HostKeyId, ServerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "DeleteHostKey",
        Dict{String,Any}("HostKeyId" => HostKeyId, "ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_host_key(
    HostKeyId,
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DeleteHostKey",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("HostKeyId" => HostKeyId, "ServerId" => ServerId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_profile(profile_id)
    delete_profile(profile_id, params::Dict{String,<:Any})

Deletes the profile that's specified in the ProfileId parameter.

# Arguments
- `profile_id`: The identifier of the profile that you are deleting.

"""
function delete_profile(ProfileId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "DeleteProfile",
        Dict{String,Any}("ProfileId" => ProfileId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_profile(
    ProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DeleteProfile",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ProfileId" => ProfileId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_server(server_id)
    delete_server(server_id, params::Dict{String,<:Any})

Deletes the file transfer protocol-enabled server that you specify. No response returns
from this operation.

# Arguments
- `server_id`: A unique system-assigned identifier for a server instance.

"""
function delete_server(ServerId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "DeleteServer",
        Dict{String,Any}("ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_server(
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DeleteServer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ServerId" => ServerId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_ssh_public_key(server_id, ssh_public_key_id, user_name)
    delete_ssh_public_key(server_id, ssh_public_key_id, user_name, params::Dict{String,<:Any})

Deletes a user's Secure Shell (SSH) public key.

# Arguments
- `server_id`: A system-assigned unique identifier for a file transfer protocol-enabled
  server instance that has the user assigned to it.
- `ssh_public_key_id`: A unique identifier used to reference your user's specific SSH key.
- `user_name`: A unique string that identifies a user whose public key is being deleted.

"""
function delete_ssh_public_key(
    ServerId, SshPublicKeyId, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "DeleteSshPublicKey",
        Dict{String,Any}(
            "ServerId" => ServerId,
            "SshPublicKeyId" => SshPublicKeyId,
            "UserName" => UserName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_ssh_public_key(
    ServerId,
    SshPublicKeyId,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DeleteSshPublicKey",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ServerId" => ServerId,
                    "SshPublicKeyId" => SshPublicKeyId,
                    "UserName" => UserName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user(server_id, user_name)
    delete_user(server_id, user_name, params::Dict{String,<:Any})

Deletes the user belonging to a file transfer protocol-enabled server you specify. No
response returns from this operation.  When you delete a user from a server, the user's
information is lost.

# Arguments
- `server_id`: A system-assigned unique identifier for a server instance that has the user
  assigned to it.
- `user_name`: A unique string that identifies a user that is being deleted from a server.

"""
function delete_user(ServerId, UserName; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "DeleteUser",
        Dict{String,Any}("ServerId" => ServerId, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user(
    ServerId,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DeleteUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ServerId" => ServerId, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_workflow(workflow_id)
    delete_workflow(workflow_id, params::Dict{String,<:Any})

Deletes the specified workflow.

# Arguments
- `workflow_id`: A unique identifier for the workflow.

"""
function delete_workflow(WorkflowId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "DeleteWorkflow",
        Dict{String,Any}("WorkflowId" => WorkflowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_workflow(
    WorkflowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DeleteWorkflow",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WorkflowId" => WorkflowId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_access(external_id, server_id)
    describe_access(external_id, server_id, params::Dict{String,<:Any})

Describes the access that is assigned to the specific file transfer protocol-enabled
server, as identified by its ServerId property and its ExternalId. The response from this
call returns the properties of the access that is associated with the ServerId value that
was specified.

# Arguments
- `external_id`: A unique identifier that is required to identify specific groups within
  your directory. The users of the group that you associate have access to your Amazon S3 or
  Amazon EFS resources over the enabled protocols using Transfer Family. If you know the
  group name, you can view the SID values by running the following command using Windows
  PowerShell.  Get-ADGroup -Filter {samAccountName -like \"YourGroupName*\"} -Properties * |
  Select SamAccountName,ObjectSid  In that command, replace YourGroupName with the name of
  your Active Directory group. The regular expression used to validate this parameter is a
  string of characters consisting of uppercase and lowercase alphanumeric characters with no
  spaces. You can also include underscores or any of the following characters: =,.@:/-
- `server_id`: A system-assigned unique identifier for a server that has this access
  assigned.

"""
function describe_access(
    ExternalId, ServerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "DescribeAccess",
        Dict{String,Any}("ExternalId" => ExternalId, "ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_access(
    ExternalId,
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DescribeAccess",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ExternalId" => ExternalId, "ServerId" => ServerId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_agreement(agreement_id, server_id)
    describe_agreement(agreement_id, server_id, params::Dict{String,<:Any})

Describes the agreement that's identified by the AgreementId.

# Arguments
- `agreement_id`: A unique identifier for the agreement. This identifier is returned when
  you create an agreement.
- `server_id`: The server identifier that's associated with the agreement.

"""
function describe_agreement(
    AgreementId, ServerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "DescribeAgreement",
        Dict{String,Any}("AgreementId" => AgreementId, "ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_agreement(
    AgreementId,
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DescribeAgreement",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AgreementId" => AgreementId, "ServerId" => ServerId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_certificate(certificate_id)
    describe_certificate(certificate_id, params::Dict{String,<:Any})

Describes the certificate that's identified by the CertificateId.

# Arguments
- `certificate_id`: An array of identifiers for the imported certificates. You use this
  identifier for working with profiles and partner profiles.

"""
function describe_certificate(
    CertificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "DescribeCertificate",
        Dict{String,Any}("CertificateId" => CertificateId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_certificate(
    CertificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DescribeCertificate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CertificateId" => CertificateId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_connector(connector_id)
    describe_connector(connector_id, params::Dict{String,<:Any})

Describes the connector that's identified by the ConnectorId.

# Arguments
- `connector_id`: The unique identifier for the connector.

"""
function describe_connector(ConnectorId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "DescribeConnector",
        Dict{String,Any}("ConnectorId" => ConnectorId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_connector(
    ConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DescribeConnector",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConnectorId" => ConnectorId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_execution(execution_id, workflow_id)
    describe_execution(execution_id, workflow_id, params::Dict{String,<:Any})

You can use DescribeExecution to check the details of the execution of the specified
workflow.  This API call only returns details for in-progress workflows.  If you provide an
ID for an execution that is not in progress, or if the execution doesn't match the
specified workflow ID, you receive a ResourceNotFound exception.

# Arguments
- `execution_id`: A unique identifier for the execution of a workflow.
- `workflow_id`: A unique identifier for the workflow.

"""
function describe_execution(
    ExecutionId, WorkflowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "DescribeExecution",
        Dict{String,Any}("ExecutionId" => ExecutionId, "WorkflowId" => WorkflowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_execution(
    ExecutionId,
    WorkflowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DescribeExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ExecutionId" => ExecutionId, "WorkflowId" => WorkflowId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_host_key(host_key_id, server_id)
    describe_host_key(host_key_id, server_id, params::Dict{String,<:Any})

Returns the details of the host key that's specified by the HostKeyId and ServerId.

# Arguments
- `host_key_id`: The identifier of the host key that you want described.
- `server_id`: The identifier of the server that contains the host key that you want
  described.

"""
function describe_host_key(
    HostKeyId, ServerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "DescribeHostKey",
        Dict{String,Any}("HostKeyId" => HostKeyId, "ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_host_key(
    HostKeyId,
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DescribeHostKey",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("HostKeyId" => HostKeyId, "ServerId" => ServerId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_profile(profile_id)
    describe_profile(profile_id, params::Dict{String,<:Any})

Returns the details of the profile that's specified by the ProfileId.

# Arguments
- `profile_id`: The identifier of the profile that you want described.

"""
function describe_profile(ProfileId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "DescribeProfile",
        Dict{String,Any}("ProfileId" => ProfileId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_profile(
    ProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DescribeProfile",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ProfileId" => ProfileId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_security_policy(security_policy_name)
    describe_security_policy(security_policy_name, params::Dict{String,<:Any})

Describes the security policy that is attached to your server or SFTP connector. The
response contains a description of the security policy's properties. For more information
about security policies, see Working with security policies for servers or Working with
security policies for SFTP connectors.

# Arguments
- `security_policy_name`: Specify the text name of the security policy for which you want
  the details.

"""
function describe_security_policy(
    SecurityPolicyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "DescribeSecurityPolicy",
        Dict{String,Any}("SecurityPolicyName" => SecurityPolicyName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_security_policy(
    SecurityPolicyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DescribeSecurityPolicy",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SecurityPolicyName" => SecurityPolicyName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_server(server_id)
    describe_server(server_id, params::Dict{String,<:Any})

Describes a file transfer protocol-enabled server that you specify by passing the ServerId
parameter. The response contains a description of a server's properties. When you set
EndpointType to VPC, the response will contain the EndpointDetails.

# Arguments
- `server_id`: A system-assigned unique identifier for a server.

"""
function describe_server(ServerId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "DescribeServer",
        Dict{String,Any}("ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_server(
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DescribeServer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ServerId" => ServerId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_user(server_id, user_name)
    describe_user(server_id, user_name, params::Dict{String,<:Any})

Describes the user assigned to the specific file transfer protocol-enabled server, as
identified by its ServerId property. The response from this call returns the properties of
the user associated with the ServerId value that was specified.

# Arguments
- `server_id`: A system-assigned unique identifier for a server that has this user assigned.
- `user_name`: The name of the user assigned to one or more servers. User names are part of
  the sign-in credentials to use the Transfer Family service and perform file transfer tasks.

"""
function describe_user(
    ServerId, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "DescribeUser",
        Dict{String,Any}("ServerId" => ServerId, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_user(
    ServerId,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DescribeUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ServerId" => ServerId, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_workflow(workflow_id)
    describe_workflow(workflow_id, params::Dict{String,<:Any})

Describes the specified workflow.

# Arguments
- `workflow_id`: A unique identifier for the workflow.

"""
function describe_workflow(WorkflowId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "DescribeWorkflow",
        Dict{String,Any}("WorkflowId" => WorkflowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_workflow(
    WorkflowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "DescribeWorkflow",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WorkflowId" => WorkflowId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_certificate(certificate, usage)
    import_certificate(certificate, usage, params::Dict{String,<:Any})

Imports the signing and encryption certificates that you need to create local (AS2)
profiles and partner profiles.

# Arguments
- `certificate`:   For the CLI, provide a file path for a certificate in URI format. For
  example, --certificate file://encryption-cert.pem. Alternatively, you can provide the raw
  content.   For the SDK, specify the raw content of a certificate file. For example,
  --certificate \"`cat encryption-cert.pem`\".
- `usage`: Specifies how this certificate is used. It can be used in the following ways:
  SIGNING: For signing AS2 messages    ENCRYPTION: For encrypting AS2 messages    TLS: For
  securing AS2 communications sent over HTTPS

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ActiveDate"`: An optional date that specifies when the certificate becomes active.
- `"CertificateChain"`: An optional list of certificates that make up the chain for the
  certificate that's being imported.
- `"Description"`: A short description that helps identify the certificate.
- `"InactiveDate"`: An optional date that specifies when the certificate becomes inactive.
- `"PrivateKey"`:   For the CLI, provide a file path for a private key in URI format.For
  example, --private-key file://encryption-key.pem. Alternatively, you can provide the raw
  content of the private key file.   For the SDK, specify the raw content of a private key
  file. For example, --private-key \"`cat encryption-key.pem`\"
- `"Tags"`: Key-value pairs that can be used to group and search for certificates.
"""
function import_certificate(
    Certificate, Usage; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "ImportCertificate",
        Dict{String,Any}("Certificate" => Certificate, "Usage" => Usage);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_certificate(
    Certificate,
    Usage,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "ImportCertificate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Certificate" => Certificate, "Usage" => Usage),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_host_key(host_key_body, server_id)
    import_host_key(host_key_body, server_id, params::Dict{String,<:Any})

Adds a host key to the server that's specified by the ServerId parameter.

# Arguments
- `host_key_body`: The private key portion of an SSH key pair. Transfer Family accepts RSA,
  ECDSA, and ED25519 keys.
- `server_id`: The identifier of the server that contains the host key that you are
  importing.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The text description that identifies this host key.
- `"Tags"`: Key-value pairs that can be used to group and search for host keys.
"""
function import_host_key(
    HostKeyBody, ServerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "ImportHostKey",
        Dict{String,Any}("HostKeyBody" => HostKeyBody, "ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_host_key(
    HostKeyBody,
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "ImportHostKey",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("HostKeyBody" => HostKeyBody, "ServerId" => ServerId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_ssh_public_key(server_id, ssh_public_key_body, user_name)
    import_ssh_public_key(server_id, ssh_public_key_body, user_name, params::Dict{String,<:Any})

Adds a Secure Shell (SSH) public key to a Transfer Family user identified by a UserName
value assigned to the specific file transfer protocol-enabled server, identified by
ServerId. The response returns the UserName value, the ServerId value, and the name of the
SshPublicKeyId.

# Arguments
- `server_id`: A system-assigned unique identifier for a server.
- `ssh_public_key_body`: The public key portion of an SSH key pair. Transfer Family accepts
  RSA, ECDSA, and ED25519 keys.
- `user_name`: The name of the Transfer Family user that is assigned to one or more servers.

"""
function import_ssh_public_key(
    ServerId, SshPublicKeyBody, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "ImportSshPublicKey",
        Dict{String,Any}(
            "ServerId" => ServerId,
            "SshPublicKeyBody" => SshPublicKeyBody,
            "UserName" => UserName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_ssh_public_key(
    ServerId,
    SshPublicKeyBody,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "ImportSshPublicKey",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ServerId" => ServerId,
                    "SshPublicKeyBody" => SshPublicKeyBody,
                    "UserName" => UserName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_accesses(server_id)
    list_accesses(server_id, params::Dict{String,<:Any})

Lists the details for all the accesses you have on your server.

# Arguments
- `server_id`: A system-assigned unique identifier for a server that has users assigned to
  it.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Specifies the maximum number of access SIDs to return.
- `"NextToken"`: When you can get additional results from the ListAccesses call, a
  NextToken parameter is returned in the output. You can then pass in a subsequent command to
  the NextToken parameter to continue listing additional accesses.
"""
function list_accesses(ServerId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "ListAccesses",
        Dict{String,Any}("ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_accesses(
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "ListAccesses",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ServerId" => ServerId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_agreements(server_id)
    list_agreements(server_id, params::Dict{String,<:Any})

Returns a list of the agreements for the server that's identified by the ServerId that you
supply. If you want to limit the results to a certain number, supply a value for the
MaxResults parameter. If you ran the command previously and received a value for NextToken,
you can supply that value to continue listing agreements from where you left off.

# Arguments
- `server_id`: The identifier of the server for which you want a list of agreements.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of agreements to return.
- `"NextToken"`: When you can get additional results from the ListAgreements call, a
  NextToken parameter is returned in the output. You can then pass in a subsequent command to
  the NextToken parameter to continue listing additional agreements.
"""
function list_agreements(ServerId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "ListAgreements",
        Dict{String,Any}("ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_agreements(
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "ListAgreements",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ServerId" => ServerId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_certificates()
    list_certificates(params::Dict{String,<:Any})

Returns a list of the current certificates that have been imported into Transfer Family. If
you want to limit the results to a certain number, supply a value for the MaxResults
parameter. If you ran the command previously and received a value for the NextToken
parameter, you can supply that value to continue listing certificates from where you left
off.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of certificates to return.
- `"NextToken"`: When you can get additional results from the ListCertificates call, a
  NextToken parameter is returned in the output. You can then pass in a subsequent command to
  the NextToken parameter to continue listing additional certificates.
"""
function list_certificates(; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "ListCertificates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_certificates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "ListCertificates", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_connectors()
    list_connectors(params::Dict{String,<:Any})

Lists the connectors for the specified Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of connectors to return.
- `"NextToken"`: When you can get additional results from the ListConnectors call, a
  NextToken parameter is returned in the output. You can then pass in a subsequent command to
  the NextToken parameter to continue listing additional connectors.
"""
function list_connectors(; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "ListConnectors"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_connectors(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "ListConnectors", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_executions(workflow_id)
    list_executions(workflow_id, params::Dict{String,<:Any})

Lists all in-progress executions for the specified workflow.  If the specified workflow ID
cannot be found, ListExecutions returns a ResourceNotFound exception.

# Arguments
- `workflow_id`: A unique identifier for the workflow.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Specifies the maximum number of executions to return.
- `"NextToken"`:  ListExecutions returns the NextToken parameter in the output. You can
  then pass the NextToken parameter in a subsequent command to continue listing additional
  executions.  This is useful for pagination, for instance. If you have 100 executions for a
  workflow, you might only want to list first 10. If so, call the API by specifying the
  max-results:   aws transfer list-executions --max-results 10   This returns details for the
  first 10 executions, as well as the pointer (NextToken) to the eleventh execution. You can
  now call the API again, supplying the NextToken value you received:   aws transfer
  list-executions --max-results 10 --next-token somePointerReturnedFromPreviousListResult
  This call returns the next 10 executions, the 11th through the 20th. You can then repeat
  the call until the details for all 100 executions have been returned.
"""
function list_executions(WorkflowId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "ListExecutions",
        Dict{String,Any}("WorkflowId" => WorkflowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_executions(
    WorkflowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "ListExecutions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WorkflowId" => WorkflowId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_host_keys(server_id)
    list_host_keys(server_id, params::Dict{String,<:Any})

Returns a list of host keys for the server that's specified by the ServerId parameter.

# Arguments
- `server_id`: The identifier of the server that contains the host keys that you want to
  view.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of host keys to return.
- `"NextToken"`: When there are additional results that were not returned, a NextToken
  parameter is returned. You can use that value for a subsequent call to ListHostKeys to
  continue listing results.
"""
function list_host_keys(ServerId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "ListHostKeys",
        Dict{String,Any}("ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_host_keys(
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "ListHostKeys",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ServerId" => ServerId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_profiles()
    list_profiles(params::Dict{String,<:Any})

Returns a list of the profiles for your system. If you want to limit the results to a
certain number, supply a value for the MaxResults parameter. If you ran the command
previously and received a value for NextToken, you can supply that value to continue
listing profiles from where you left off.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of profiles to return.
- `"NextToken"`: When there are additional results that were not returned, a NextToken
  parameter is returned. You can use that value for a subsequent call to ListProfiles to
  continue listing results.
- `"ProfileType"`: Indicates whether to list only LOCAL type profiles or only PARTNER type
  profiles. If not supplied in the request, the command lists all types of profiles.
"""
function list_profiles(; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer("ListProfiles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_profiles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "ListProfiles", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_security_policies()
    list_security_policies(params::Dict{String,<:Any})

Lists the security policies that are attached to your servers and SFTP connectors. For more
information about security policies, see Working with security policies for servers or
Working with security policies for SFTP connectors.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Specifies the number of security policies to return as a response to the
  ListSecurityPolicies query.
- `"NextToken"`: When additional results are obtained from the ListSecurityPolicies
  command, a NextToken parameter is returned in the output. You can then pass the NextToken
  parameter in a subsequent command to continue listing additional security policies.
"""
function list_security_policies(; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "ListSecurityPolicies"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_security_policies(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "ListSecurityPolicies",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_servers()
    list_servers(params::Dict{String,<:Any})

Lists the file transfer protocol-enabled servers that are associated with your Amazon Web
Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Specifies the number of servers to return as a response to the
  ListServers query.
- `"NextToken"`: When additional results are obtained from the ListServers command, a
  NextToken parameter is returned in the output. You can then pass the NextToken parameter in
  a subsequent command to continue listing additional servers.
"""
function list_servers(; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer("ListServers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_servers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "ListServers", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(arn)
    list_tags_for_resource(arn, params::Dict{String,<:Any})

Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The
resource can be a user, server, or role.

# Arguments
- `arn`: Requests the tags associated with a particular Amazon Resource Name (ARN). An ARN
  is an identifier for a specific Amazon Web Services resource, such as a server, user, or
  role.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Specifies the number of tags to return as a response to the
  ListTagsForResource request.
- `"NextToken"`: When you request additional results from the ListTagsForResource
  operation, a NextToken parameter is returned in the input. You can then pass in a
  subsequent command to the NextToken parameter to continue listing additional tags.
"""
function list_tags_for_resource(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "ListTagsForResource",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "ListTagsForResource",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_users(server_id)
    list_users(server_id, params::Dict{String,<:Any})

Lists the users for a file transfer protocol-enabled server that you specify by passing the
ServerId parameter.

# Arguments
- `server_id`: A system-assigned unique identifier for a server that has users assigned to
  it.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Specifies the number of users to return as a response to the ListUsers
  request.
- `"NextToken"`: If there are additional results from the ListUsers call, a NextToken
  parameter is returned in the output. You can then pass the NextToken to a subsequent
  ListUsers command, to continue listing additional users.
"""
function list_users(ServerId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "ListUsers",
        Dict{String,Any}("ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_users(
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "ListUsers",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ServerId" => ServerId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_workflows()
    list_workflows(params::Dict{String,<:Any})

Lists all workflows associated with your Amazon Web Services account for your current
region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Specifies the maximum number of workflows to return.
- `"NextToken"`:  ListWorkflows returns the NextToken parameter in the output. You can then
  pass the NextToken parameter in a subsequent command to continue listing additional
  workflows.
"""
function list_workflows(; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer("ListWorkflows"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_workflows(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "ListWorkflows", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    send_workflow_step_state(execution_id, status, token, workflow_id)
    send_workflow_step_state(execution_id, status, token, workflow_id, params::Dict{String,<:Any})

Sends a callback for asynchronous custom steps.  The ExecutionId, WorkflowId, and Token are
passed to the target resource during execution of a custom step of a workflow. You must
include those with their callback as well as providing a status.

# Arguments
- `execution_id`: A unique identifier for the execution of a workflow.
- `status`: Indicates whether the specified step succeeded or failed.
- `token`: Used to distinguish between multiple callbacks for multiple Lambda steps within
  the same execution.
- `workflow_id`: A unique identifier for the workflow.

"""
function send_workflow_step_state(
    ExecutionId,
    Status,
    Token,
    WorkflowId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "SendWorkflowStepState",
        Dict{String,Any}(
            "ExecutionId" => ExecutionId,
            "Status" => Status,
            "Token" => Token,
            "WorkflowId" => WorkflowId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_workflow_step_state(
    ExecutionId,
    Status,
    Token,
    WorkflowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "SendWorkflowStepState",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ExecutionId" => ExecutionId,
                    "Status" => Status,
                    "Token" => Token,
                    "WorkflowId" => WorkflowId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_directory_listing(connector_id, output_directory_path, remote_directory_path)
    start_directory_listing(connector_id, output_directory_path, remote_directory_path, params::Dict{String,<:Any})

Retrieves a list of the contents of a directory from a remote SFTP server. You specify the
connector ID, the output path, and the remote directory path. You can also specify the
optional MaxItems value to control the maximum number of items that are listed from the
remote directory. This API returns a list of all files and directories in the remote
directory (up to the maximum value), but does not return files or folders in
sub-directories. That is, it only returns a list of files and directories one-level deep.
After you receive the listing file, you can provide the files that you want to transfer to
the RetrieveFilePaths parameter of the StartFileTransfer API call. The naming convention
for the output file is  connector-ID-listing-ID.json. The output file contains the
following information:    filePath: the complete path of a remote file, relative to the
directory of the listing request for your SFTP connector on the remote server.
modifiedTimestamp: the last time the file was modified, in UTC time format. This field is
optional. If the remote file attributes don't contain a timestamp, it is omitted from the
file listing.    size: the size of the file, in bytes. This field is optional. If the
remote file attributes don't contain a file size, it is omitted from the file listing.
path: the complete path of a remote directory, relative to the directory of the listing
request for your SFTP connector on the remote server.    truncated: a flag indicating
whether the list output contains all of the items contained in the remote directory or not.
If your Truncated output value is true, you can increase the value provided in the optional
max-items input attribute to be able to list more items (up to the maximum allowed list
size of 10,000 items).

# Arguments
- `connector_id`: The unique identifier for the connector.
- `output_directory_path`: Specifies the path (bucket and prefix) in Amazon S3 storage to
  store the results of the directory listing.
- `remote_directory_path`: Specifies the directory on the remote SFTP server for which you
  want to list its contents.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxItems"`: An optional parameter where you can specify the maximum number of
  file/directory names to retrieve. The default value is 1,000.
"""
function start_directory_listing(
    ConnectorId,
    OutputDirectoryPath,
    RemoteDirectoryPath;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "StartDirectoryListing",
        Dict{String,Any}(
            "ConnectorId" => ConnectorId,
            "OutputDirectoryPath" => OutputDirectoryPath,
            "RemoteDirectoryPath" => RemoteDirectoryPath,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_directory_listing(
    ConnectorId,
    OutputDirectoryPath,
    RemoteDirectoryPath,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "StartDirectoryListing",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConnectorId" => ConnectorId,
                    "OutputDirectoryPath" => OutputDirectoryPath,
                    "RemoteDirectoryPath" => RemoteDirectoryPath,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_file_transfer(connector_id)
    start_file_transfer(connector_id, params::Dict{String,<:Any})

Begins a file transfer between local Amazon Web Services storage and a remote AS2 or SFTP
server.   For an AS2 connector, you specify the ConnectorId and one or more SendFilePaths
to identify the files you want to transfer.   For an SFTP connector, the file transfer can
be either outbound or inbound. In both cases, you specify the ConnectorId. Depending on the
direction of the transfer, you also specify the following items:   If you are transferring
file from a partner's SFTP server to Amazon Web Services storage, you specify one or more
RetrieveFilePaths to identify the files you want to transfer, and a LocalDirectoryPath to
specify the destination folder.   If you are transferring file to a partner's SFTP server
from Amazon Web Services storage, you specify one or more SendFilePaths to identify the
files you want to transfer, and a RemoteDirectoryPath to specify the destination folder.

# Arguments
- `connector_id`: The unique identifier for the connector.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LocalDirectoryPath"`: For an inbound transfer, the LocaDirectoryPath specifies the
  destination for one or more files that are transferred from the partner's SFTP server.
- `"RemoteDirectoryPath"`: For an outbound transfer, the RemoteDirectoryPath specifies the
  destination for one or more files that are transferred to the partner's SFTP server. If you
  don't specify a RemoteDirectoryPath, the destination for transferred files is the SFTP
  user's home directory.
- `"RetrieveFilePaths"`: One or more source paths for the partner's SFTP server. Each
  string represents a source file path for one inbound file transfer.
- `"SendFilePaths"`: One or more source paths for the Amazon S3 storage. Each string
  represents a source file path for one outbound file transfer. For example,
  DOC-EXAMPLE-BUCKET/myfile.txt .  Replace  DOC-EXAMPLE-BUCKET  with one of your actual
  buckets.
"""
function start_file_transfer(
    ConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "StartFileTransfer",
        Dict{String,Any}("ConnectorId" => ConnectorId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_file_transfer(
    ConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "StartFileTransfer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConnectorId" => ConnectorId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_server(server_id)
    start_server(server_id, params::Dict{String,<:Any})

Changes the state of a file transfer protocol-enabled server from OFFLINE to ONLINE. It has
no impact on a server that is already ONLINE. An ONLINE server can accept and process file
transfer jobs. The state of STARTING indicates that the server is in an intermediate state,
either not fully able to respond, or not fully online. The values of START_FAILED can
indicate an error condition. No response is returned from this call.

# Arguments
- `server_id`: A system-assigned unique identifier for a server that you start.

"""
function start_server(ServerId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "StartServer",
        Dict{String,Any}("ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_server(
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "StartServer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ServerId" => ServerId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_server(server_id)
    stop_server(server_id, params::Dict{String,<:Any})

Changes the state of a file transfer protocol-enabled server from ONLINE to OFFLINE. An
OFFLINE server cannot accept and process file transfer jobs. Information tied to your
server, such as server and user properties, are not affected by stopping your server.
Stopping the server does not reduce or impact your file transfer protocol endpoint billing;
you must delete the server to stop being billed.  The state of STOPPING indicates that the
server is in an intermediate state, either not fully able to respond, or not fully offline.
The values of STOP_FAILED can indicate an error condition. No response is returned from
this call.

# Arguments
- `server_id`: A system-assigned unique identifier for a server that you stopped.

"""
function stop_server(ServerId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "StopServer",
        Dict{String,Any}("ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_server(
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "StopServer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ServerId" => ServerId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(arn, tags)
    tag_resource(arn, tags, params::Dict{String,<:Any})

Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN).
Resources are users, servers, roles, and other entities. There is no response returned from
this call.

# Arguments
- `arn`: An Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as
  a server, user, or role.
- `tags`: Key-value pairs assigned to ARNs that you can use to group and search for
  resources by type. You can attach this metadata to resources (servers, users, workflows,
  and so on) for any purpose.

"""
function tag_resource(Arn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "TagResource",
        Dict{String,Any}("Arn" => Arn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    Arn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "TagResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Arn" => Arn, "Tags" => Tags), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_connection(connector_id)
    test_connection(connector_id, params::Dict{String,<:Any})

Tests whether your SFTP connector is set up successfully. We highly recommend that you call
this operation to test your ability to transfer files between local Amazon Web Services
storage and a trading partner's SFTP server.

# Arguments
- `connector_id`: The unique identifier for the connector.

"""
function test_connection(ConnectorId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "TestConnection",
        Dict{String,Any}("ConnectorId" => ConnectorId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_connection(
    ConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "TestConnection",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConnectorId" => ConnectorId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_identity_provider(server_id, user_name)
    test_identity_provider(server_id, user_name, params::Dict{String,<:Any})

If the IdentityProviderType of a file transfer protocol-enabled server is
AWS_DIRECTORY_SERVICE or API_Gateway, tests whether your identity provider is set up
successfully. We highly recommend that you call this operation to test your authentication
method as soon as you create your server. By doing so, you can troubleshoot issues with the
identity provider integration to ensure that your users can successfully use the service.
The ServerId and UserName parameters are required. The ServerProtocol, SourceIp, and
UserPassword are all optional.  Note the following:    You cannot use TestIdentityProvider
if the IdentityProviderType of your server is SERVICE_MANAGED.    TestIdentityProvider does
not work with keys: it only accepts passwords.    TestIdentityProvider can test the
password operation for a custom Identity Provider that handles keys and passwords.    If
you provide any incorrect values for any parameters, the Response field is empty.     If
you provide a server ID for a server that uses service-managed users, you get an error:
An error occurred (InvalidRequestException) when calling the TestIdentityProvider
operation: s-server-ID not configured for external auth      If you enter a Server ID for
the --server-id parameter that does not identify an actual Transfer server, you receive the
following error:   An error occurred (ResourceNotFoundException) when calling the
TestIdentityProvider operation: Unknown server.  It is possible your sever is in a
different region. You can specify a region by adding the following: --region region-code,
such as --region us-east-2 to specify a server in US East (Ohio).

# Arguments
- `server_id`: A system-assigned identifier for a specific server. That server's user
  authentication method is tested with a user name and password.
- `user_name`: The name of the account to be tested.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ServerProtocol"`: The type of file transfer protocol to be tested. The available
  protocols are:   Secure Shell (SSH) File Transfer Protocol (SFTP)   File Transfer Protocol
  Secure (FTPS)   File Transfer Protocol (FTP)   Applicability Statement 2 (AS2)
- `"SourceIp"`: The source IP address of the account to be tested.
- `"UserPassword"`: The password of the account to be tested.
"""
function test_identity_provider(
    ServerId, UserName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "TestIdentityProvider",
        Dict{String,Any}("ServerId" => ServerId, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_identity_provider(
    ServerId,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "TestIdentityProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ServerId" => ServerId, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(arn, tag_keys)
    untag_resource(arn, tag_keys, params::Dict{String,<:Any})

Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN).
Resources are users, servers, roles, and other entities. No response is returned from this
call.

# Arguments
- `arn`: The value of the resource that will have the tag removed. An Amazon Resource Name
  (ARN) is an identifier for a specific Amazon Web Services resource, such as a server, user,
  or role.
- `tag_keys`: TagKeys are key-value pairs assigned to ARNs that can be used to group and
  search for resources by type. This metadata can be attached to resources for any purpose.

"""
function untag_resource(Arn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "UntagResource",
        Dict{String,Any}("Arn" => Arn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    Arn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "UntagResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Arn" => Arn, "TagKeys" => TagKeys), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_access(external_id, server_id)
    update_access(external_id, server_id, params::Dict{String,<:Any})

Allows you to update parameters for the access specified in the ServerID and ExternalID
parameters.

# Arguments
- `external_id`: A unique identifier that is required to identify specific groups within
  your directory. The users of the group that you associate have access to your Amazon S3 or
  Amazon EFS resources over the enabled protocols using Transfer Family. If you know the
  group name, you can view the SID values by running the following command using Windows
  PowerShell.  Get-ADGroup -Filter {samAccountName -like \"YourGroupName*\"} -Properties * |
  Select SamAccountName,ObjectSid  In that command, replace YourGroupName with the name of
  your Active Directory group. The regular expression used to validate this parameter is a
  string of characters consisting of uppercase and lowercase alphanumeric characters with no
  spaces. You can also include underscores or any of the following characters: =,.@:/-
- `server_id`: A system-assigned unique identifier for a server instance. This is the
  specific server that you added your user to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"HomeDirectory"`: The landing directory (folder) for a user when they log in to the
  server using the client. A HomeDirectory example is /bucket_name/home/mydirectory.  The
  HomeDirectory parameter is only used if HomeDirectoryType is set to PATH.
- `"HomeDirectoryMappings"`: Logical directory mappings that specify what Amazon S3 or
  Amazon EFS paths and keys should be visible to your user and how you want to make them
  visible. You must specify the Entry and Target pair, where Entry shows how the path is made
  visible and Target is the actual Amazon S3 or Amazon EFS path. If you only specify a
  target, it is displayed as is. You also must ensure that your Identity and Access
  Management (IAM) role provides access to paths in Target. This value can be set only when
  HomeDirectoryType is set to LOGICAL. The following is an Entry and Target pair example.  [
  { \"Entry\": \"/directory1\", \"Target\": \"/bucket_name/home/mydirectory\" } ]  In most
  cases, you can use this value instead of the session policy to lock down your user to the
  designated home directory (\"chroot\"). To do this, you can set Entry to / and set Target
  to the HomeDirectory parameter value. The following is an Entry and Target pair example for
  chroot.  [ { \"Entry\": \"/\", \"Target\": \"/bucket_name/home/mydirectory\" } ]
- `"HomeDirectoryType"`: The type of landing directory (folder) that you want your users'
  home directory to be when they log in to the server. If you set it to PATH, the user will
  see the absolute Amazon S3 bucket or Amazon EFS path as is in their file transfer protocol
  clients. If you set it to LOGICAL, you need to provide mappings in the
  HomeDirectoryMappings for how you want to make Amazon S3 or Amazon EFS paths visible to
  your users.  If HomeDirectoryType is LOGICAL, you must provide mappings, using the
  HomeDirectoryMappings parameter. If, on the other hand, HomeDirectoryType is PATH, you
  provide an absolute path using the HomeDirectory parameter. You cannot have both
  HomeDirectory and HomeDirectoryMappings in your template.
- `"Policy"`: A session policy for your user so that you can use the same Identity and
  Access Management (IAM) role across multiple users. This policy scopes down a user's access
  to portions of their Amazon S3 bucket. Variables that you can use inside this policy
  include {Transfer:UserName}, {Transfer:HomeDirectory}, and {Transfer:HomeBucket}.  This
  policy applies only when the domain of ServerId is Amazon S3. Amazon EFS does not use
  session policies. For session policies, Transfer Family stores the policy as a JSON blob,
  instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob
  and pass it in the Policy argument. For an example of a session policy, see Example session
  policy. For more information, see AssumeRole in the Amazon Web ServicesSecurity Token
  Service API Reference.
- `"PosixProfile"`:
- `"Role"`: The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
  that controls your users' access to your Amazon S3 bucket or Amazon EFS file system. The
  policies attached to this role determine the level of access that you want to provide your
  users when transferring files into and out of your Amazon S3 bucket or Amazon EFS file
  system. The IAM role should also contain a trust relationship that allows the server to
  access your resources when servicing your users' transfer requests.
"""
function update_access(
    ExternalId, ServerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "UpdateAccess",
        Dict{String,Any}("ExternalId" => ExternalId, "ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_access(
    ExternalId,
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "UpdateAccess",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ExternalId" => ExternalId, "ServerId" => ServerId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_agreement(agreement_id, server_id)
    update_agreement(agreement_id, server_id, params::Dict{String,<:Any})

Updates some of the parameters for an existing agreement. Provide the AgreementId and the
ServerId for the agreement that you want to update, along with the new values for the
parameters to update.

# Arguments
- `agreement_id`: A unique identifier for the agreement. This identifier is returned when
  you create an agreement.
- `server_id`: A system-assigned unique identifier for a server instance. This is the
  specific server that the agreement uses.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessRole"`: Connectors are used to send files using either the AS2 or SFTP protocol.
  For the access role, provide the Amazon Resource Name (ARN) of the Identity and Access
  Management role to use.  For AS2 connectors  With AS2, you can send files by calling
  StartFileTransfer and specifying the file paths in the request parameter, SendFilePaths. We
  use the file’s parent directory (for example, for --send-file-paths /bucket/dir/file.txt,
  parent directory is /bucket/dir/) to temporarily store a processed AS2 message file, store
  the MDN when we receive them from the partner, and write a final JSON file containing
  relevant metadata of the transmission. So, the AccessRole needs to provide read and write
  access to the parent directory of the file location used in the StartFileTransfer request.
  Additionally, you need to provide read and write access to the parent directory of the
  files that you intend to send with StartFileTransfer. If you are using Basic authentication
  for your AS2 connector, the access role requires the secretsmanager:GetSecretValue
  permission for the secret. If the secret is encrypted using a customer-managed key instead
  of the Amazon Web Services managed key in Secrets Manager, then the role also needs the
  kms:Decrypt permission for that key.  For SFTP connectors  Make sure that the access role
  provides read and write access to the parent directory of the file location that's used in
  the StartFileTransfer request. Additionally, make sure that the role provides
  secretsmanager:GetSecretValue permission to Secrets Manager.
- `"BaseDirectory"`: To change the landing directory (folder) for files that are
  transferred, provide the bucket folder that you want to use; for example,
  /DOC-EXAMPLE-BUCKET/home/mydirectory .
- `"Description"`: To replace the existing description, provide a short description for the
  agreement.
- `"LocalProfileId"`: A unique identifier for the AS2 local profile. To change the local
  profile identifier, provide a new value here.
- `"PartnerProfileId"`: A unique identifier for the partner profile. To change the partner
  profile identifier, provide a new value here.
- `"Status"`: You can update the status for the agreement, either activating an inactive
  agreement or the reverse.
"""
function update_agreement(
    AgreementId, ServerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "UpdateAgreement",
        Dict{String,Any}("AgreementId" => AgreementId, "ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_agreement(
    AgreementId,
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "UpdateAgreement",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AgreementId" => AgreementId, "ServerId" => ServerId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_certificate(certificate_id)
    update_certificate(certificate_id, params::Dict{String,<:Any})

Updates the active and inactive dates for a certificate.

# Arguments
- `certificate_id`: The identifier of the certificate object that you are updating.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ActiveDate"`: An optional date that specifies when the certificate becomes active.
- `"Description"`: A short description to help identify the certificate.
- `"InactiveDate"`: An optional date that specifies when the certificate becomes inactive.
"""
function update_certificate(
    CertificateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "UpdateCertificate",
        Dict{String,Any}("CertificateId" => CertificateId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_certificate(
    CertificateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "UpdateCertificate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CertificateId" => CertificateId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_connector(connector_id)
    update_connector(connector_id, params::Dict{String,<:Any})

Updates some of the parameters for an existing connector. Provide the ConnectorId for the
connector that you want to update, along with the new values for the parameters to update.

# Arguments
- `connector_id`: The unique identifier for the connector.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessRole"`: Connectors are used to send files using either the AS2 or SFTP protocol.
  For the access role, provide the Amazon Resource Name (ARN) of the Identity and Access
  Management role to use.  For AS2 connectors  With AS2, you can send files by calling
  StartFileTransfer and specifying the file paths in the request parameter, SendFilePaths. We
  use the file’s parent directory (for example, for --send-file-paths /bucket/dir/file.txt,
  parent directory is /bucket/dir/) to temporarily store a processed AS2 message file, store
  the MDN when we receive them from the partner, and write a final JSON file containing
  relevant metadata of the transmission. So, the AccessRole needs to provide read and write
  access to the parent directory of the file location used in the StartFileTransfer request.
  Additionally, you need to provide read and write access to the parent directory of the
  files that you intend to send with StartFileTransfer. If you are using Basic authentication
  for your AS2 connector, the access role requires the secretsmanager:GetSecretValue
  permission for the secret. If the secret is encrypted using a customer-managed key instead
  of the Amazon Web Services managed key in Secrets Manager, then the role also needs the
  kms:Decrypt permission for that key.  For SFTP connectors  Make sure that the access role
  provides read and write access to the parent directory of the file location that's used in
  the StartFileTransfer request. Additionally, make sure that the role provides
  secretsmanager:GetSecretValue permission to Secrets Manager.
- `"As2Config"`: A structure that contains the parameters for an AS2 connector object.
- `"LoggingRole"`: The Amazon Resource Name (ARN) of the Identity and Access Management
  (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events. When
  set, you can view connector activity in your CloudWatch logs.
- `"SecurityPolicyName"`: Specifies the name of the security policy for the connector.
- `"SftpConfig"`: A structure that contains the parameters for an SFTP connector object.
- `"Url"`: The URL of the partner's AS2 or SFTP endpoint.
"""
function update_connector(ConnectorId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "UpdateConnector",
        Dict{String,Any}("ConnectorId" => ConnectorId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_connector(
    ConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "UpdateConnector",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ConnectorId" => ConnectorId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_host_key(description, host_key_id, server_id)
    update_host_key(description, host_key_id, server_id, params::Dict{String,<:Any})

Updates the description for the host key that's specified by the ServerId and HostKeyId
parameters.

# Arguments
- `description`: An updated description for the host key.
- `host_key_id`: The identifier of the host key that you are updating.
- `server_id`: The identifier of the server that contains the host key that you are
  updating.

"""
function update_host_key(
    Description, HostKeyId, ServerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return transfer(
        "UpdateHostKey",
        Dict{String,Any}(
            "Description" => Description, "HostKeyId" => HostKeyId, "ServerId" => ServerId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_host_key(
    Description,
    HostKeyId,
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "UpdateHostKey",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Description" => Description,
                    "HostKeyId" => HostKeyId,
                    "ServerId" => ServerId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_profile(profile_id)
    update_profile(profile_id, params::Dict{String,<:Any})

Updates some of the parameters for an existing profile. Provide the ProfileId for the
profile that you want to update, along with the new values for the parameters to update.

# Arguments
- `profile_id`: The identifier of the profile object that you are updating.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CertificateIds"`: An array of identifiers for the imported certificates. You use this
  identifier for working with profiles and partner profiles.
"""
function update_profile(ProfileId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "UpdateProfile",
        Dict{String,Any}("ProfileId" => ProfileId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_profile(
    ProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "UpdateProfile",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ProfileId" => ProfileId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_server(server_id)
    update_server(server_id, params::Dict{String,<:Any})

Updates the file transfer protocol-enabled server's properties after that server has been
created. The UpdateServer call returns the ServerId of the server you updated.

# Arguments
- `server_id`: A system-assigned unique identifier for a server instance that the Transfer
  Family user is assigned to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Certificate"`: The Amazon Resource Name (ARN) of the Amazon Web ServicesCertificate
  Manager (ACM) certificate. Required when Protocols is set to FTPS. To request a new public
  certificate, see Request a public certificate in the  Amazon Web ServicesCertificate
  Manager User Guide. To import an existing certificate into ACM, see Importing certificates
  into ACM in the  Amazon Web ServicesCertificate Manager User Guide. To request a private
  certificate to use FTPS through private IP addresses, see Request a private certificate in
  the  Amazon Web ServicesCertificate Manager User Guide. Certificates with the following
  cryptographic algorithms and key sizes are supported:   2048-bit RSA (RSA_2048)   4096-bit
  RSA (RSA_4096)   Elliptic Prime Curve 256 bit (EC_prime256v1)   Elliptic Prime Curve 384
  bit (EC_secp384r1)   Elliptic Prime Curve 521 bit (EC_secp521r1)    The certificate must be
  a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and
  information about the issuer.
- `"EndpointDetails"`: The virtual private cloud (VPC) endpoint settings that are
  configured for your server. When you host your endpoint within your VPC, you can make your
  endpoint accessible only to resources within your VPC, or you can attach Elastic IP
  addresses and make your endpoint accessible to clients over the internet. Your VPC's
  default security groups are automatically assigned to your endpoint.
- `"EndpointType"`: The type of endpoint that you want your server to use. You can choose
  to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC.
  With an endpoint that is hosted in a VPC, you can restrict access to your server and
  resources only within your VPC or choose to make it internet facing by attaching Elastic IP
  addresses directly to it.   After May 19, 2021, you won't be able to create a server using
  EndpointType=VPC_ENDPOINT in your Amazon Web Servicesaccount if your account hasn't already
  done so before May 19, 2021. If you have already created servers with
  EndpointType=VPC_ENDPOINT in your Amazon Web Servicesaccount on or before May 19, 2021, you
  will not be affected. After this date, use EndpointType=VPC. For more information, see
  https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vp
  c-endpoint. It is recommended that you use VPC as the EndpointType. With this endpoint
  type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP
  included) with your server's endpoint and use VPC security groups to restrict traffic by
  the client's public IP address. This is not possible with EndpointType set to VPC_ENDPOINT.
- `"HostKey"`: The RSA, ECDSA, or ED25519 private key to use for your SFTP-enabled server.
  You can add multiple host keys, in case you want to rotate keys, or have a set of active
  keys that use different algorithms. Use the following command to generate an RSA 2048 bit
  key with no passphrase:  ssh-keygen -t rsa -b 2048 -N \"\" -m PEM -f my-new-server-key. Use
  a minimum value of 2048 for the -b option. You can create a stronger key by using 3072 or
  4096. Use the following command to generate an ECDSA 256 bit key with no passphrase:
  ssh-keygen -t ecdsa -b 256 -N \"\" -m PEM -f my-new-server-key. Valid values for the -b
  option for ECDSA are 256, 384, and 521. Use the following command to generate an ED25519
  key with no passphrase:  ssh-keygen -t ed25519 -N \"\" -f my-new-server-key. For all of
  these commands, you can replace my-new-server-key with a string of your choice.  If you
  aren't planning to migrate existing users from an existing SFTP-enabled server to a new
  server, don't update the host key. Accidentally changing a server's host key can be
  disruptive.  For more information, see Manage host keys for your SFTP-enabled server in the
  Transfer Family User Guide.
- `"IdentityProviderDetails"`: An array containing all of the information required to call
  a customer's authentication API method.
- `"LoggingRole"`: The Amazon Resource Name (ARN) of the Identity and Access Management
  (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or
  Amazon EFSevents. When set, you can view user activity in your CloudWatch logs.
- `"PostAuthenticationLoginBanner"`: Specifies a string to display when users connect to a
  server. This string is displayed after the user authenticates.  The SFTP protocol does not
  support post-authentication display banners.
- `"PreAuthenticationLoginBanner"`: Specifies a string to display when users connect to a
  server. This string is displayed before the user authenticates. For example, the following
  banner displays details about using the system:  This system is for the use of authorized
  users only. Individuals using this computer system without authority, or in excess of their
  authority, are subject to having all of their activities on this system monitored and
  recorded by system personnel.
- `"ProtocolDetails"`: The protocol settings that are configured for your server.    To
  indicate passive mode (for FTP and FTPS protocols), use the PassiveIp parameter. Enter a
  single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or
  load balancer.    To ignore the error that is generated when the client attempts to use the
  SETSTAT command on a file that you are uploading to an Amazon S3 bucket, use the
  SetStatOption parameter. To have the Transfer Family server ignore the SETSTAT command and
  upload files without needing to make any changes to your SFTP client, set the value to
  ENABLE_NO_OP. If you set the SetStatOption parameter to ENABLE_NO_OP, Transfer Family
  generates a log entry to Amazon CloudWatch Logs, so that you can determine when the client
  is making a SETSTAT call.   To determine whether your Transfer Family server resumes
  recent, negotiated sessions through a unique session ID, use the TlsSessionResumptionMode
  parameter.    As2Transports indicates the transport method for the AS2 messages. Currently,
  only HTTP is supported.
- `"Protocols"`: Specifies the file transfer protocol or protocols over which your file
  transfer protocol client can connect to your server's endpoint. The available protocols
  are:    SFTP (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH    FTPS
  (File Transfer Protocol Secure): File transfer with TLS encryption    FTP (File Transfer
  Protocol): Unencrypted file transfer    AS2 (Applicability Statement 2): used for
  transporting structured business-to-business data      If you select FTPS, you must choose
  a certificate stored in Certificate Manager (ACM) which is used to identify your server
  when clients connect to it over FTPS.   If Protocol includes either FTP or FTPS, then the
  EndpointType must be VPC and the IdentityProviderType must be either AWS_DIRECTORY_SERVICE,
  AWS_LAMBDA, or API_GATEWAY.   If Protocol includes FTP, then AddressAllocationIds cannot be
  associated.   If Protocol is set only to SFTP, the EndpointType can be set to PUBLIC and
  the IdentityProviderType can be set any of the supported identity types: SERVICE_MANAGED,
  AWS_DIRECTORY_SERVICE, AWS_LAMBDA, or API_GATEWAY.   If Protocol includes AS2, then the
  EndpointType must be VPC, and domain must be Amazon S3.
- `"S3StorageOptions"`: Specifies whether or not performance for your Amazon S3 directories
  is optimized. This is disabled by default. By default, home directory mappings have a TYPE
  of DIRECTORY. If you enable this option, you would then need to explicitly set the
  HomeDirectoryMapEntry Type to FILE if you want a mapping to have a file target.
- `"SecurityPolicyName"`: Specifies the name of the security policy for the server.
- `"StructuredLogDestinations"`: Specifies the log groups to which your server logs are
  sent. To specify a log group, you must provide the ARN for an existing log group. In this
  case, the format of the log group is as follows:
  arn:aws:logs:region-name:amazon-account-id:log-group:log-group-name:*  For example,
  arn:aws:logs:us-east-1:111122223333:log-group:mytestgroup:*  If you have previously
  specified a log group for a server, you can clear it, and in effect turn off structured
  logging, by providing an empty value for this parameter in an update-server call. For
  example:  update-server --server-id s-1234567890abcdef0 --structured-log-destinations
- `"WorkflowDetails"`: Specifies the workflow ID for the workflow to assign and the
  execution role that's used for executing the workflow. In addition to a workflow to execute
  when a file is uploaded completely, WorkflowDetails can also contain a workflow ID (and
  execution role) for a workflow to execute on partial upload. A partial upload occurs when
  the server session disconnects while the file is still being uploaded. To remove an
  associated workflow from a server, you can provide an empty OnUpload object, as in the
  following example.  aws transfer update-server --server-id s-01234567890abcdef
  --workflow-details '{\"OnUpload\":[]}'
"""
function update_server(ServerId; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "UpdateServer",
        Dict{String,Any}("ServerId" => ServerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_server(
    ServerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "UpdateServer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ServerId" => ServerId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_user(server_id, user_name)
    update_user(server_id, user_name, params::Dict{String,<:Any})

Assigns new properties to a user. Parameters you pass modify any or all of the following:
the home directory, role, and policy for the UserName and ServerId you specify. The
response returns the ServerId and the UserName for the updated user. In the console, you
can select Restricted when you create or update a user. This ensures that the user can't
access anything outside of their home directory. The programmatic way to configure this
behavior is to update the user. Set their HomeDirectoryType to LOGICAL, and specify
HomeDirectoryMappings with Entry as root (/) and Target as their home directory. For
example, if the user's home directory is /test/admin-user, the following command updates
the user so that their configuration in the console shows the Restricted flag as selected.
 aws transfer update-user --server-id &lt;server-id&gt; --user-name admin-user
--home-directory-type LOGICAL --home-directory-mappings \"[{\"Entry\":\"/\",
\"Target\":\"/test/admin-user\"}]\"

# Arguments
- `server_id`: A system-assigned unique identifier for a Transfer Family server instance
  that the user is assigned to.
- `user_name`: A unique string that identifies a user and is associated with a server as
  specified by the ServerId. This user name must be a minimum of 3 and a maximum of 100
  characters long. The following are valid characters: a-z, A-Z, 0-9, underscore '_', hyphen
  '-', period '.', and at sign '@'. The user name can't start with a hyphen, period, or at
  sign.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"HomeDirectory"`: The landing directory (folder) for a user when they log in to the
  server using the client. A HomeDirectory example is /bucket_name/home/mydirectory.  The
  HomeDirectory parameter is only used if HomeDirectoryType is set to PATH.
- `"HomeDirectoryMappings"`: Logical directory mappings that specify what Amazon S3 or
  Amazon EFS paths and keys should be visible to your user and how you want to make them
  visible. You must specify the Entry and Target pair, where Entry shows how the path is made
  visible and Target is the actual Amazon S3 or Amazon EFS path. If you only specify a
  target, it is displayed as is. You also must ensure that your Identity and Access
  Management (IAM) role provides access to paths in Target. This value can be set only when
  HomeDirectoryType is set to LOGICAL. The following is an Entry and Target pair example.  [
  { \"Entry\": \"/directory1\", \"Target\": \"/bucket_name/home/mydirectory\" } ]  In most
  cases, you can use this value instead of the session policy to lock down your user to the
  designated home directory (\"chroot\"). To do this, you can set Entry to '/' and set Target
  to the HomeDirectory parameter value. The following is an Entry and Target pair example for
  chroot.  [ { \"Entry\": \"/\", \"Target\": \"/bucket_name/home/mydirectory\" } ]
- `"HomeDirectoryType"`: The type of landing directory (folder) that you want your users'
  home directory to be when they log in to the server. If you set it to PATH, the user will
  see the absolute Amazon S3 bucket or Amazon EFS path as is in their file transfer protocol
  clients. If you set it to LOGICAL, you need to provide mappings in the
  HomeDirectoryMappings for how you want to make Amazon S3 or Amazon EFS paths visible to
  your users.  If HomeDirectoryType is LOGICAL, you must provide mappings, using the
  HomeDirectoryMappings parameter. If, on the other hand, HomeDirectoryType is PATH, you
  provide an absolute path using the HomeDirectory parameter. You cannot have both
  HomeDirectory and HomeDirectoryMappings in your template.
- `"Policy"`: A session policy for your user so that you can use the same Identity and
  Access Management (IAM) role across multiple users. This policy scopes down a user's access
  to portions of their Amazon S3 bucket. Variables that you can use inside this policy
  include {Transfer:UserName}, {Transfer:HomeDirectory}, and {Transfer:HomeBucket}.  This
  policy applies only when the domain of ServerId is Amazon S3. Amazon EFS does not use
  session policies. For session policies, Transfer Family stores the policy as a JSON blob,
  instead of the Amazon Resource Name (ARN) of the policy. You save the policy as a JSON blob
  and pass it in the Policy argument. For an example of a session policy, see Creating a
  session policy. For more information, see AssumeRole in the Amazon Web Services Security
  Token Service API Reference.
- `"PosixProfile"`: Specifies the full POSIX identity, including user ID (Uid), group ID
  (Gid), and any secondary groups IDs (SecondaryGids), that controls your users' access to
  your Amazon Elastic File Systems (Amazon EFS). The POSIX permissions that are set on files
  and directories in your file system determines the level of access your users get when
  transferring files into and out of your Amazon EFS file systems.
- `"Role"`: The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role
  that controls your users' access to your Amazon S3 bucket or Amazon EFS file system. The
  policies attached to this role determine the level of access that you want to provide your
  users when transferring files into and out of your Amazon S3 bucket or Amazon EFS file
  system. The IAM role should also contain a trust relationship that allows the server to
  access your resources when servicing your users' transfer requests.
"""
function update_user(ServerId, UserName; aws_config::AbstractAWSConfig=current_aws_config())
    return transfer(
        "UpdateUser",
        Dict{String,Any}("ServerId" => ServerId, "UserName" => UserName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_user(
    ServerId,
    UserName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return transfer(
        "UpdateUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ServerId" => ServerId, "UserName" => UserName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
