# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: workspaces
using AWS.Compat
using AWS.UUIDs

"""
    accept_account_link_invitation(link_id)
    accept_account_link_invitation(link_id, params::Dict{String,<:Any})

Accepts the account link invitation.  There's currently no unlinking capability after you
accept the account linking invitation.

# Arguments
- `link_id`: The identifier of the account link.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A string of up to 64 ASCII characters that Amazon EFS uses to ensure
  idempotent creation.
"""
function accept_account_link_invitation(
    LinkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "AcceptAccountLinkInvitation",
        Dict{String,Any}("LinkId" => LinkId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_account_link_invitation(
    LinkId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "AcceptAccountLinkInvitation",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("LinkId" => LinkId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_connection_alias(alias_id, resource_id)
    associate_connection_alias(alias_id, resource_id, params::Dict{String,<:Any})

Associates the specified connection alias with the specified directory to enable
cross-Region redirection. For more information, see  Cross-Region Redirection for Amazon
WorkSpaces.  Before performing this operation, call  DescribeConnectionAliases to make sure
that the current state of the connection alias is CREATED.

# Arguments
- `alias_id`: The identifier of the connection alias.
- `resource_id`: The identifier of the directory to associate the connection alias with.

"""
function associate_connection_alias(
    AliasId, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "AssociateConnectionAlias",
        Dict{String,Any}("AliasId" => AliasId, "ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_connection_alias(
    AliasId,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "AssociateConnectionAlias",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AliasId" => AliasId, "ResourceId" => ResourceId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_ip_groups(directory_id, group_ids)
    associate_ip_groups(directory_id, group_ids, params::Dict{String,<:Any})

Associates the specified IP access control group with the specified directory.

# Arguments
- `directory_id`: The identifier of the directory.
- `group_ids`: The identifiers of one or more IP access control groups.

"""
function associate_ip_groups(
    DirectoryId, GroupIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "AssociateIpGroups",
        Dict{String,Any}("DirectoryId" => DirectoryId, "GroupIds" => GroupIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_ip_groups(
    DirectoryId,
    GroupIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "AssociateIpGroups",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DirectoryId" => DirectoryId, "GroupIds" => GroupIds),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_workspace_application(application_id, workspace_id)
    associate_workspace_application(application_id, workspace_id, params::Dict{String,<:Any})

Associates the specified application to the specified WorkSpace.

# Arguments
- `application_id`: The identifier of the application.
- `workspace_id`: The identifier of the WorkSpace.

"""
function associate_workspace_application(
    ApplicationId, WorkspaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "AssociateWorkspaceApplication",
        Dict{String,Any}("ApplicationId" => ApplicationId, "WorkspaceId" => WorkspaceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_workspace_application(
    ApplicationId,
    WorkspaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "AssociateWorkspaceApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationId" => ApplicationId, "WorkspaceId" => WorkspaceId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    authorize_ip_rules(group_id, user_rules)
    authorize_ip_rules(group_id, user_rules, params::Dict{String,<:Any})

Adds one or more rules to the specified IP access control group. This action gives users
permission to access their WorkSpaces from the CIDR address ranges specified in the rules.

# Arguments
- `group_id`: The identifier of the group.
- `user_rules`: The rules to add to the group.

"""
function authorize_ip_rules(
    GroupId, UserRules; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "AuthorizeIpRules",
        Dict{String,Any}("GroupId" => GroupId, "UserRules" => UserRules);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function authorize_ip_rules(
    GroupId,
    UserRules,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "AuthorizeIpRules",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupId" => GroupId, "UserRules" => UserRules),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_workspace_image(name, source_image_id, source_region)
    copy_workspace_image(name, source_image_id, source_region, params::Dict{String,<:Any})

Copies the specified image from the specified Region to the current Region. For more
information about copying images, see  Copy a Custom WorkSpaces Image. In the China
(Ningxia) Region, you can copy images only within the same Region. In Amazon Web Services
GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services
Support.  Before copying a shared image, be sure to verify that it has been shared from the
correct Amazon Web Services account. To determine if an image has been shared and to see
the ID of the Amazon Web Services account that owns an image, use the
DescribeWorkSpaceImages and DescribeWorkspaceImagePermissions API operations.

# Arguments
- `name`: The name of the image.
- `source_image_id`: The identifier of the source image.
- `source_region`: The identifier of the source Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the image.
- `"Tags"`: The tags for the image.
"""
function copy_workspace_image(
    Name, SourceImageId, SourceRegion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "CopyWorkspaceImage",
        Dict{String,Any}(
            "Name" => Name, "SourceImageId" => SourceImageId, "SourceRegion" => SourceRegion
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_workspace_image(
    Name,
    SourceImageId,
    SourceRegion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "CopyWorkspaceImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name,
                    "SourceImageId" => SourceImageId,
                    "SourceRegion" => SourceRegion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_account_link_invitation(target_account_id)
    create_account_link_invitation(target_account_id, params::Dict{String,<:Any})

Creates the account link invitation.

# Arguments
- `target_account_id`: The identifier of the target account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A string of up to 64 ASCII characters that Amazon EFS uses to ensure
  idempotent creation.
"""
function create_account_link_invitation(
    TargetAccountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "CreateAccountLinkInvitation",
        Dict{String,Any}("TargetAccountId" => TargetAccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_account_link_invitation(
    TargetAccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "CreateAccountLinkInvitation",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("TargetAccountId" => TargetAccountId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_connect_client_add_in(name, resource_id, url)
    create_connect_client_add_in(name, resource_id, url, params::Dict{String,<:Any})

Creates a client-add-in for Amazon Connect within a directory. You can create only one
Amazon Connect client add-in within a directory. This client add-in allows WorkSpaces users
to seamlessly connect to Amazon Connect.

# Arguments
- `name`: The name of the client add-in.
- `resource_id`: The directory identifier for which to configure the client add-in.
- `url`: The endpoint URL of the Amazon Connect client add-in.

"""
function create_connect_client_add_in(
    Name, ResourceId, URL; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "CreateConnectClientAddIn",
        Dict{String,Any}("Name" => Name, "ResourceId" => ResourceId, "URL" => URL);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_connect_client_add_in(
    Name,
    ResourceId,
    URL,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "CreateConnectClientAddIn",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "ResourceId" => ResourceId, "URL" => URL),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_connection_alias(connection_string)
    create_connection_alias(connection_string, params::Dict{String,<:Any})

Creates the specified connection alias for use with cross-Region redirection. For more
information, see  Cross-Region Redirection for Amazon WorkSpaces.

# Arguments
- `connection_string`: A connection string in the form of a fully qualified domain name
  (FQDN), such as www.example.com.  After you create a connection string, it is always
  associated to your Amazon Web Services account. You cannot recreate the same connection
  string with a different account, even if you delete all instances of it from the original
  account. The connection string is globally reserved for your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: The tags to associate with the connection alias.
"""
function create_connection_alias(
    ConnectionString; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "CreateConnectionAlias",
        Dict{String,Any}("ConnectionString" => ConnectionString);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_connection_alias(
    ConnectionString,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "CreateConnectionAlias",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ConnectionString" => ConnectionString), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_ip_group(group_name)
    create_ip_group(group_name, params::Dict{String,<:Any})

Creates an IP access control group. An IP access control group provides you with the
ability to control the IP addresses from which users are allowed to access their
WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group
and then associate the group with your directory. You can add rules when you create the
group or at any time using AuthorizeIpRules. There is a default IP access control group
associated with your directory. If you don't associate an IP access control group with your
directory, the default group is used. The default group includes a default rule that allows
users to access their WorkSpaces from anywhere. You cannot modify the default IP access
control group for your directory.

# Arguments
- `group_name`: The name of the group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GroupDesc"`: The description of the group.
- `"Tags"`: The tags. Each WorkSpaces resource can have a maximum of 50 tags.
- `"UserRules"`: The rules to add to the group.
"""
function create_ip_group(GroupName; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "CreateIpGroup",
        Dict{String,Any}("GroupName" => GroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_ip_group(
    GroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "CreateIpGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GroupName" => GroupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_standby_workspaces(primary_region, standby_workspaces)
    create_standby_workspaces(primary_region, standby_workspaces, params::Dict{String,<:Any})

Creates a standby WorkSpace in a secondary Region.

# Arguments
- `primary_region`: The Region of the primary WorkSpace.
- `standby_workspaces`: Information about the standby WorkSpace to be created.

"""
function create_standby_workspaces(
    PrimaryRegion, StandbyWorkspaces; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "CreateStandbyWorkspaces",
        Dict{String,Any}(
            "PrimaryRegion" => PrimaryRegion, "StandbyWorkspaces" => StandbyWorkspaces
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_standby_workspaces(
    PrimaryRegion,
    StandbyWorkspaces,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "CreateStandbyWorkspaces",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PrimaryRegion" => PrimaryRegion,
                    "StandbyWorkspaces" => StandbyWorkspaces,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_tags(resource_id, tags)
    create_tags(resource_id, tags, params::Dict{String,<:Any})

Creates the specified tags for the specified WorkSpaces resource.

# Arguments
- `resource_id`: The identifier of the WorkSpaces resource. The supported resource types
  are WorkSpaces, registered directories, images, custom bundles, IP access control groups,
  and connection aliases.
- `tags`: The tags. Each WorkSpaces resource can have a maximum of 50 tags.

"""
function create_tags(ResourceId, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "CreateTags",
        Dict{String,Any}("ResourceId" => ResourceId, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_tags(
    ResourceId,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "CreateTags",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ResourceId" => ResourceId, "Tags" => Tags), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_updated_workspace_image(description, name, source_image_id)
    create_updated_workspace_image(description, name, source_image_id, params::Dict{String,<:Any})

Creates a new updated WorkSpace image based on the specified source image. The new updated
WorkSpace image has the latest drivers and other updates required by the Amazon WorkSpaces
components. To determine which WorkSpace images need to be updated with the latest Amazon
WorkSpaces requirements, use  DescribeWorkspaceImages.    Only Windows 10, Windows Server
2016, and Windows Server 2019 WorkSpace images can be programmatically updated at this
time.   Microsoft Windows updates and other application updates are not included in the
update process.   The source WorkSpace image is not deleted. You can delete the source
image after you've verified your new updated image and created a new bundle.

# Arguments
- `description`: A description of whether updates for the WorkSpace image are available.
- `name`: The name of the new updated WorkSpace image.
- `source_image_id`: The identifier of the source WorkSpace image.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: The tags that you want to add to the new updated WorkSpace image.  To add tags
  at the same time when you're creating the updated image, you must create an IAM policy that
  grants your IAM user permissions to use workspaces:CreateTags.
"""
function create_updated_workspace_image(
    Description, Name, SourceImageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "CreateUpdatedWorkspaceImage",
        Dict{String,Any}(
            "Description" => Description, "Name" => Name, "SourceImageId" => SourceImageId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_updated_workspace_image(
    Description,
    Name,
    SourceImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "CreateUpdatedWorkspaceImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Description" => Description,
                    "Name" => Name,
                    "SourceImageId" => SourceImageId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_workspace_bundle(bundle_description, bundle_name, compute_type, image_id, user_storage)
    create_workspace_bundle(bundle_description, bundle_name, compute_type, image_id, user_storage, params::Dict{String,<:Any})

Creates the specified WorkSpace bundle. For more information about creating WorkSpace
bundles, see  Create a Custom WorkSpaces Image and Bundle.

# Arguments
- `bundle_description`: The description of the bundle.
- `bundle_name`: The name of the bundle.
- `compute_type`:
- `image_id`: The identifier of the image that is used to create the bundle.
- `user_storage`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"RootStorage"`:
- `"Tags"`: The tags associated with the bundle.  To add tags at the same time when you're
  creating the bundle, you must create an IAM policy that grants your IAM user permissions to
  use workspaces:CreateTags.
"""
function create_workspace_bundle(
    BundleDescription,
    BundleName,
    ComputeType,
    ImageId,
    UserStorage;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "CreateWorkspaceBundle",
        Dict{String,Any}(
            "BundleDescription" => BundleDescription,
            "BundleName" => BundleName,
            "ComputeType" => ComputeType,
            "ImageId" => ImageId,
            "UserStorage" => UserStorage,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_workspace_bundle(
    BundleDescription,
    BundleName,
    ComputeType,
    ImageId,
    UserStorage,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "CreateWorkspaceBundle",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BundleDescription" => BundleDescription,
                    "BundleName" => BundleName,
                    "ComputeType" => ComputeType,
                    "ImageId" => ImageId,
                    "UserStorage" => UserStorage,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_workspace_image(description, name, workspace_id)
    create_workspace_image(description, name, workspace_id, params::Dict{String,<:Any})

Creates a new WorkSpace image from an existing WorkSpace.

# Arguments
- `description`: The description of the new WorkSpace image.
- `name`: The name of the new WorkSpace image.
- `workspace_id`: The identifier of the source WorkSpace

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: The tags that you want to add to the new WorkSpace image. To add tags when
  you're creating the image, you must create an IAM policy that grants your IAM user
  permission to use workspaces:CreateTags.
"""
function create_workspace_image(
    Description, Name, WorkspaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "CreateWorkspaceImage",
        Dict{String,Any}(
            "Description" => Description, "Name" => Name, "WorkspaceId" => WorkspaceId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_workspace_image(
    Description,
    Name,
    WorkspaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "CreateWorkspaceImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Description" => Description,
                    "Name" => Name,
                    "WorkspaceId" => WorkspaceId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_workspaces(workspaces)
    create_workspaces(workspaces, params::Dict{String,<:Any})

Creates one or more WorkSpaces. This operation is asynchronous and returns before the
WorkSpaces are created.    The MANUAL running mode value is only supported by Amazon
WorkSpaces Core. Contact your account team to be allow-listed to use this value. For more
information, see Amazon WorkSpaces Core.   You don't need to specify the PCOIP protocol for
Linux bundles because WSP is the default protocol for those bundles.   User-decoupled
WorkSpaces are only supported by Amazon WorkSpaces Core.

# Arguments
- `workspaces`: The WorkSpaces to create. You can specify up to 25 WorkSpaces.

"""
function create_workspaces(Workspaces; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "CreateWorkspaces",
        Dict{String,Any}("Workspaces" => Workspaces);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_workspaces(
    Workspaces,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "CreateWorkspaces",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Workspaces" => Workspaces), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_account_link_invitation(link_id)
    delete_account_link_invitation(link_id, params::Dict{String,<:Any})

Deletes the account link invitation.

# Arguments
- `link_id`: The identifier of the account link.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A string of up to 64 ASCII characters that Amazon EFS uses to ensure
  idempotent creation.
"""
function delete_account_link_invitation(
    LinkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DeleteAccountLinkInvitation",
        Dict{String,Any}("LinkId" => LinkId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_account_link_invitation(
    LinkId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DeleteAccountLinkInvitation",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("LinkId" => LinkId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_client_branding(platforms, resource_id)
    delete_client_branding(platforms, resource_id, params::Dict{String,<:Any})

Deletes customized client branding. Client branding allows you to customize your
WorkSpace's client login portal. You can tailor your login portal company logo, the support
email address, support link, link to reset password, and a custom message for users trying
to sign in. After you delete your customized client branding, your login portal reverts to
the default client branding.

# Arguments
- `platforms`: The device type for which you want to delete client branding.
- `resource_id`: The directory identifier of the WorkSpace for which you want to delete
  client branding.

"""
function delete_client_branding(
    Platforms, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DeleteClientBranding",
        Dict{String,Any}("Platforms" => Platforms, "ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_client_branding(
    Platforms,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DeleteClientBranding",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Platforms" => Platforms, "ResourceId" => ResourceId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_connect_client_add_in(add_in_id, resource_id)
    delete_connect_client_add_in(add_in_id, resource_id, params::Dict{String,<:Any})

Deletes a client-add-in for Amazon Connect that is configured within a directory.

# Arguments
- `add_in_id`: The identifier of the client add-in to delete.
- `resource_id`: The directory identifier for which the client add-in is configured.

"""
function delete_connect_client_add_in(
    AddInId, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DeleteConnectClientAddIn",
        Dict{String,Any}("AddInId" => AddInId, "ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_connect_client_add_in(
    AddInId,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DeleteConnectClientAddIn",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AddInId" => AddInId, "ResourceId" => ResourceId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_connection_alias(alias_id)
    delete_connection_alias(alias_id, params::Dict{String,<:Any})

Deletes the specified connection alias. For more information, see  Cross-Region Redirection
for Amazon WorkSpaces.   If you will no longer be using a fully qualified domain name
(FQDN) as the registration code for your WorkSpaces users, you must take certain
precautions to prevent potential security issues. For more information, see  Security
Considerations if You Stop Using Cross-Region Redirection.   To delete a connection alias
that has been shared, the shared account must first disassociate the connection alias from
any directories it has been associated with. Then you must unshare the connection alias
from the account it has been shared with. You can delete a connection alias only after it
is no longer shared with any accounts or associated with any directories.

# Arguments
- `alias_id`: The identifier of the connection alias to delete.

"""
function delete_connection_alias(
    AliasId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DeleteConnectionAlias",
        Dict{String,Any}("AliasId" => AliasId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_connection_alias(
    AliasId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DeleteConnectionAlias",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("AliasId" => AliasId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_ip_group(group_id)
    delete_ip_group(group_id, params::Dict{String,<:Any})

Deletes the specified IP access control group. You cannot delete an IP access control group
that is associated with a directory.

# Arguments
- `group_id`: The identifier of the IP access control group.

"""
function delete_ip_group(GroupId; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "DeleteIpGroup",
        Dict{String,Any}("GroupId" => GroupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_ip_group(
    GroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DeleteIpGroup",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("GroupId" => GroupId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_tags(resource_id, tag_keys)
    delete_tags(resource_id, tag_keys, params::Dict{String,<:Any})

Deletes the specified tags from the specified WorkSpaces resource.

# Arguments
- `resource_id`: The identifier of the WorkSpaces resource. The supported resource types
  are WorkSpaces, registered directories, images, custom bundles, IP access control groups,
  and connection aliases.
- `tag_keys`: The tag keys.

"""
function delete_tags(
    ResourceId, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DeleteTags",
        Dict{String,Any}("ResourceId" => ResourceId, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_tags(
    ResourceId,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DeleteTags",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceId" => ResourceId, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_workspace_bundle()
    delete_workspace_bundle(params::Dict{String,<:Any})

Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace
bundles, see  Delete a Custom WorkSpaces Bundle or Image.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BundleId"`: The identifier of the bundle.
"""
function delete_workspace_bundle(; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "DeleteWorkspaceBundle"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_workspace_bundle(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DeleteWorkspaceBundle",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_workspace_image(image_id)
    delete_workspace_image(image_id, params::Dict{String,<:Any})

Deletes the specified image from your account. To delete an image, you must first delete
any bundles that are associated with the image and unshare the image if it is shared with
other accounts.

# Arguments
- `image_id`: The identifier of the image.

"""
function delete_workspace_image(ImageId; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "DeleteWorkspaceImage",
        Dict{String,Any}("ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_workspace_image(
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DeleteWorkspaceImage",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ImageId" => ImageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deploy_workspace_applications(workspace_id)
    deploy_workspace_applications(workspace_id, params::Dict{String,<:Any})

Deploys associated applications to the specified WorkSpace

# Arguments
- `workspace_id`: The identifier of the WorkSpace.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Force"`: Indicates whether the force flag is applied for the specified WorkSpace. When
  the force flag is enabled, it allows previously failed deployments to be retried.
"""
function deploy_workspace_applications(
    WorkspaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DeployWorkspaceApplications",
        Dict{String,Any}("WorkspaceId" => WorkspaceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deploy_workspace_applications(
    WorkspaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DeployWorkspaceApplications",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WorkspaceId" => WorkspaceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_workspace_directory(directory_id)
    deregister_workspace_directory(directory_id, params::Dict{String,<:Any})

Deregisters the specified directory. This operation is asynchronous and returns before the
WorkSpace directory is deregistered. If any WorkSpaces are registered to this directory,
you must remove them before you can deregister the directory.  Simple AD and AD Connector
are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces
being used with your Simple AD or AD Connector directory for 30 consecutive days, this
directory will be automatically deregistered for use with Amazon WorkSpaces, and you will
be charged for this directory as per the Directory Service pricing terms. To delete empty
directories, see  Delete the Directory for Your WorkSpaces. If you delete your Simple AD or
AD Connector directory, you can always create a new one when you want to start using
WorkSpaces again.

# Arguments
- `directory_id`: The identifier of the directory. If any WorkSpaces are registered to this
  directory, you must remove them before you deregister the directory, or you will receive an
  OperationNotSupportedException error.

"""
function deregister_workspace_directory(
    DirectoryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DeregisterWorkspaceDirectory",
        Dict{String,Any}("DirectoryId" => DirectoryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_workspace_directory(
    DirectoryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DeregisterWorkspaceDirectory",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DirectoryId" => DirectoryId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_account()
    describe_account(params::Dict{String,<:Any})

Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the
specified account.

"""
function describe_account(; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "DescribeAccount"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_account(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeAccount", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_account_modifications()
    describe_account_modifications(params::Dict{String,<:Any})

Retrieves a list that describes modifications to the configuration of Bring Your Own
License (BYOL) for the specified account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: If you received a NextToken from a previous call that was paginated,
  provide this token to receive the next set of results.
"""
function describe_account_modifications(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeAccountModifications";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_account_modifications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeAccountModifications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_application_associations(application_id, associated_resource_types)
    describe_application_associations(application_id, associated_resource_types, params::Dict{String,<:Any})

Describes the associations between the application and the specified associated resources.

# Arguments
- `application_id`: The identifier of the specified application.
- `associated_resource_types`: The resource type of the associated resources.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of associations to return.
- `"NextToken"`: If you received a NextToken from a previous call that was paginated,
  provide this token to receive the next set of results.
"""
function describe_application_associations(
    ApplicationId,
    AssociatedResourceTypes;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DescribeApplicationAssociations",
        Dict{String,Any}(
            "ApplicationId" => ApplicationId,
            "AssociatedResourceTypes" => AssociatedResourceTypes,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_application_associations(
    ApplicationId,
    AssociatedResourceTypes,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DescribeApplicationAssociations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationId" => ApplicationId,
                    "AssociatedResourceTypes" => AssociatedResourceTypes,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_applications()
    describe_applications(params::Dict{String,<:Any})

Describes the specified applications by filtering based on their compute types, license
availability, operating systems, and owners.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApplicationIds"`: The identifiers of one or more applications.
- `"ComputeTypeNames"`: The compute types supported by the applications.
- `"LicenseType"`: The license availability for the applications.
- `"MaxResults"`: The maximum number of applications to return.
- `"NextToken"`: If you received a NextToken from a previous call that was paginated,
  provide this token to receive the next set of results.
- `"OperatingSystemNames"`: The operating systems supported by the applications.
- `"Owner"`: The owner of the applications.
"""
function describe_applications(; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "DescribeApplications"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeApplications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_bundle_associations(associated_resource_types, bundle_id)
    describe_bundle_associations(associated_resource_types, bundle_id, params::Dict{String,<:Any})

Describes the associations between the applications and the specified bundle.

# Arguments
- `associated_resource_types`: The resource types of the associated resource.
- `bundle_id`: The identifier of the bundle.

"""
function describe_bundle_associations(
    AssociatedResourceTypes, BundleId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeBundleAssociations",
        Dict{String,Any}(
            "AssociatedResourceTypes" => AssociatedResourceTypes, "BundleId" => BundleId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_bundle_associations(
    AssociatedResourceTypes,
    BundleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DescribeBundleAssociations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AssociatedResourceTypes" => AssociatedResourceTypes,
                    "BundleId" => BundleId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_client_branding(resource_id)
    describe_client_branding(resource_id, params::Dict{String,<:Any})

Describes the specified client branding. Client branding allows you to customize the log in
page of various device types for your users. You can add your company logo, the support
email address, support link, link to reset password, and a custom message for users trying
to sign in.  Only device types that have branding information configured will be shown in
the response.

# Arguments
- `resource_id`: The directory identifier of the WorkSpace for which you want to view
  client branding information.

"""
function describe_client_branding(
    ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeClientBranding",
        Dict{String,Any}("ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_client_branding(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DescribeClientBranding",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceId" => ResourceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_client_properties(resource_ids)
    describe_client_properties(resource_ids, params::Dict{String,<:Any})

Retrieves a list that describes one or more specified Amazon WorkSpaces clients.

# Arguments
- `resource_ids`: The resource identifier, in the form of directory IDs.

"""
function describe_client_properties(
    ResourceIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeClientProperties",
        Dict{String,Any}("ResourceIds" => ResourceIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_client_properties(
    ResourceIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DescribeClientProperties",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceIds" => ResourceIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_connect_client_add_ins(resource_id)
    describe_connect_client_add_ins(resource_id, params::Dict{String,<:Any})

Retrieves a list of Amazon Connect client add-ins that have been created.

# Arguments
- `resource_id`: The directory identifier for which the client add-in is configured.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return.
- `"NextToken"`: If you received a NextToken from a previous call that was paginated,
  provide this token to receive the next set of results.
"""
function describe_connect_client_add_ins(
    ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeConnectClientAddIns",
        Dict{String,Any}("ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_connect_client_add_ins(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DescribeConnectClientAddIns",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceId" => ResourceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_connection_alias_permissions(alias_id)
    describe_connection_alias_permissions(alias_id, params::Dict{String,<:Any})

Describes the permissions that the owner of a connection alias has granted to another
Amazon Web Services account for the specified connection alias. For more information, see
Cross-Region Redirection for Amazon WorkSpaces.

# Arguments
- `alias_id`: The identifier of the connection alias.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results to return.
- `"NextToken"`: If you received a NextToken from a previous call that was paginated,
  provide this token to receive the next set of results.
"""
function describe_connection_alias_permissions(
    AliasId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeConnectionAliasPermissions",
        Dict{String,Any}("AliasId" => AliasId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_connection_alias_permissions(
    AliasId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DescribeConnectionAliasPermissions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("AliasId" => AliasId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_connection_aliases()
    describe_connection_aliases(params::Dict{String,<:Any})

Retrieves a list that describes the connection aliases used for cross-Region redirection.
For more information, see  Cross-Region Redirection for Amazon WorkSpaces.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AliasIds"`: The identifiers of the connection aliases to describe.
- `"Limit"`: The maximum number of connection aliases to return.
- `"NextToken"`: If you received a NextToken from a previous call that was paginated,
  provide this token to receive the next set of results.
- `"ResourceId"`: The identifier of the directory associated with the connection alias.
"""
function describe_connection_aliases(; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "DescribeConnectionAliases"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_connection_aliases(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeConnectionAliases",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_image_associations(associated_resource_types, image_id)
    describe_image_associations(associated_resource_types, image_id, params::Dict{String,<:Any})

Describes the associations between the applications and the specified image.

# Arguments
- `associated_resource_types`: The resource types of the associated resource.
- `image_id`: The identifier of the image.

"""
function describe_image_associations(
    AssociatedResourceTypes, ImageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeImageAssociations",
        Dict{String,Any}(
            "AssociatedResourceTypes" => AssociatedResourceTypes, "ImageId" => ImageId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_image_associations(
    AssociatedResourceTypes,
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DescribeImageAssociations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AssociatedResourceTypes" => AssociatedResourceTypes,
                    "ImageId" => ImageId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_ip_groups()
    describe_ip_groups(params::Dict{String,<:Any})

Describes one or more of your IP access control groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GroupIds"`: The identifiers of one or more IP access control groups.
- `"MaxResults"`: The maximum number of items to return.
- `"NextToken"`: If you received a NextToken from a previous call that was paginated,
  provide this token to receive the next set of results.
"""
function describe_ip_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "DescribeIpGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_ip_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeIpGroups", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_tags(resource_id)
    describe_tags(resource_id, params::Dict{String,<:Any})

Describes the specified tags for the specified WorkSpaces resource.

# Arguments
- `resource_id`: The identifier of the WorkSpaces resource. The supported resource types
  are WorkSpaces, registered directories, images, custom bundles, IP access control groups,
  and connection aliases.

"""
function describe_tags(ResourceId; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "DescribeTags",
        Dict{String,Any}("ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_tags(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DescribeTags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceId" => ResourceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_workspace_associations(associated_resource_types, workspace_id)
    describe_workspace_associations(associated_resource_types, workspace_id, params::Dict{String,<:Any})

Describes the associations betweens applications and the specified WorkSpace.

# Arguments
- `associated_resource_types`: The resource types of the associated resources.
- `workspace_id`: The identifier of the WorkSpace.

"""
function describe_workspace_associations(
    AssociatedResourceTypes, WorkspaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeWorkspaceAssociations",
        Dict{String,Any}(
            "AssociatedResourceTypes" => AssociatedResourceTypes,
            "WorkspaceId" => WorkspaceId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_workspace_associations(
    AssociatedResourceTypes,
    WorkspaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DescribeWorkspaceAssociations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AssociatedResourceTypes" => AssociatedResourceTypes,
                    "WorkspaceId" => WorkspaceId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_workspace_bundles()
    describe_workspace_bundles(params::Dict{String,<:Any})

Retrieves a list that describes the available WorkSpace bundles. You can filter the results
using either bundle ID or owner, but not both.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BundleIds"`: The identifiers of the bundles. You cannot combine this parameter with any
  other filter.
- `"NextToken"`: The token for the next set of results. (You received this token from a
  previous call.)
- `"Owner"`: The owner of the bundles. You cannot combine this parameter with any other
  filter. To describe the bundles provided by Amazon Web Services, specify AMAZON. To
  describe the bundles that belong to your account, don't specify a value.
"""
function describe_workspace_bundles(; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "DescribeWorkspaceBundles"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_workspace_bundles(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeWorkspaceBundles",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_workspace_directories()
    describe_workspace_directories(params::Dict{String,<:Any})

Describes the available directories that are registered with Amazon WorkSpaces.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DirectoryIds"`: The identifiers of the directories. If the value is null, all
  directories are retrieved.
- `"Limit"`: The maximum number of directories to return.
- `"NextToken"`: If you received a NextToken from a previous call that was paginated,
  provide this token to receive the next set of results.
"""
function describe_workspace_directories(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeWorkspaceDirectories";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_workspace_directories(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeWorkspaceDirectories",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_workspace_image_permissions(image_id)
    describe_workspace_image_permissions(image_id, params::Dict{String,<:Any})

Describes the permissions that the owner of an image has granted to other Amazon Web
Services accounts for an image.

# Arguments
- `image_id`: The identifier of the image.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return.
- `"NextToken"`: If you received a NextToken from a previous call that was paginated,
  provide this token to receive the next set of results.
"""
function describe_workspace_image_permissions(
    ImageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeWorkspaceImagePermissions",
        Dict{String,Any}("ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_workspace_image_permissions(
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DescribeWorkspaceImagePermissions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ImageId" => ImageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_workspace_images()
    describe_workspace_images(params::Dict{String,<:Any})

Retrieves a list that describes one or more specified images, if the image identifiers are
provided. Otherwise, all images in the account are described.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ImageIds"`: The identifier of the image.
- `"ImageType"`: The type (owned or shared) of the image.
- `"MaxResults"`: The maximum number of items to return.
- `"NextToken"`: If you received a NextToken from a previous call that was paginated,
  provide this token to receive the next set of results.
"""
function describe_workspace_images(; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "DescribeWorkspaceImages"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_workspace_images(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeWorkspaceImages",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_workspace_snapshots(workspace_id)
    describe_workspace_snapshots(workspace_id, params::Dict{String,<:Any})

Describes the snapshots for the specified WorkSpace.

# Arguments
- `workspace_id`: The identifier of the WorkSpace.

"""
function describe_workspace_snapshots(
    WorkspaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeWorkspaceSnapshots",
        Dict{String,Any}("WorkspaceId" => WorkspaceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_workspace_snapshots(
    WorkspaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DescribeWorkspaceSnapshots",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WorkspaceId" => WorkspaceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_workspaces()
    describe_workspaces(params::Dict{String,<:Any})

Describes the specified WorkSpaces. You can filter the results by using the bundle
identifier, directory identifier, or owner, but you can specify only one filter at a time.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BundleId"`: The identifier of the bundle. All WorkSpaces that are created from this
  bundle are retrieved. You cannot combine this parameter with any other filter.
- `"DirectoryId"`: The identifier of the directory. In addition, you can optionally specify
  a specific directory user (see UserName). You cannot combine this parameter with any other
  filter.
- `"Limit"`: The maximum number of items to return.
- `"NextToken"`: If you received a NextToken from a previous call that was paginated,
  provide this token to receive the next set of results.
- `"UserName"`: The name of the directory user. You must specify this parameter with
  DirectoryId.
- `"WorkspaceIds"`: The identifiers of the WorkSpaces. You cannot combine this parameter
  with any other filter. Because the CreateWorkspaces operation is asynchronous, the
  identifier it returns is not immediately available. If you immediately call
  DescribeWorkspaces with this identifier, no information is returned.
- `"WorkspaceName"`: The name of the user-decoupled WorkSpace.
"""
function describe_workspaces(; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "DescribeWorkspaces"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_workspaces(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeWorkspaces", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_workspaces_connection_status()
    describe_workspaces_connection_status(params::Dict{String,<:Any})

Describes the connection status of the specified WorkSpaces.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: If you received a NextToken from a previous call that was paginated,
  provide this token to receive the next set of results.
- `"WorkspaceIds"`: The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.
"""
function describe_workspaces_connection_status(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeWorkspacesConnectionStatus";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_workspaces_connection_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DescribeWorkspacesConnectionStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_connection_alias(alias_id)
    disassociate_connection_alias(alias_id, params::Dict{String,<:Any})

Disassociates a connection alias from a directory. Disassociating a connection alias
disables cross-Region redirection between two directories in different Regions. For more
information, see  Cross-Region Redirection for Amazon WorkSpaces.  Before performing this
operation, call  DescribeConnectionAliases to make sure that the current state of the
connection alias is CREATED.

# Arguments
- `alias_id`: The identifier of the connection alias to disassociate.

"""
function disassociate_connection_alias(
    AliasId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DisassociateConnectionAlias",
        Dict{String,Any}("AliasId" => AliasId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_connection_alias(
    AliasId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DisassociateConnectionAlias",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("AliasId" => AliasId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_ip_groups(directory_id, group_ids)
    disassociate_ip_groups(directory_id, group_ids, params::Dict{String,<:Any})

Disassociates the specified IP access control group from the specified directory.

# Arguments
- `directory_id`: The identifier of the directory.
- `group_ids`: The identifiers of one or more IP access control groups.

"""
function disassociate_ip_groups(
    DirectoryId, GroupIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DisassociateIpGroups",
        Dict{String,Any}("DirectoryId" => DirectoryId, "GroupIds" => GroupIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_ip_groups(
    DirectoryId,
    GroupIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DisassociateIpGroups",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DirectoryId" => DirectoryId, "GroupIds" => GroupIds),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_workspace_application(application_id, workspace_id)
    disassociate_workspace_application(application_id, workspace_id, params::Dict{String,<:Any})

Disassociates the specified application from a WorkSpace.

# Arguments
- `application_id`: The identifier of the application.
- `workspace_id`: The identifier of the WorkSpace.

"""
function disassociate_workspace_application(
    ApplicationId, WorkspaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "DisassociateWorkspaceApplication",
        Dict{String,Any}("ApplicationId" => ApplicationId, "WorkspaceId" => WorkspaceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_workspace_application(
    ApplicationId,
    WorkspaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "DisassociateWorkspaceApplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationId" => ApplicationId, "WorkspaceId" => WorkspaceId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_account_link()
    get_account_link(params::Dict{String,<:Any})

Retrieves account link information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LinkId"`: The identifier of the account to link.
- `"LinkedAccountId"`: The identifier of the account link
"""
function get_account_link(; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "GetAccountLink"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_account_link(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "GetAccountLink", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    import_client_branding(resource_id)
    import_client_branding(resource_id, params::Dict{String,<:Any})

Imports client branding. Client branding allows you to customize your WorkSpace's client
login portal. You can tailor your login portal company logo, the support email address,
support link, link to reset password, and a custom message for users trying to sign in.
After you import client branding, the default branding experience for the specified
platform type is replaced with the imported experience    You must specify at least one
platform type when importing client branding.   You can import up to 6 MB of data with each
request. If your request exceeds this limit, you can import client branding for different
platform types using separate requests.   In each platform type, the SupportEmail and
SupportLink parameters are mutually exclusive. You can specify only one parameter for each
platform type, but not both.   Imported data can take up to a minute to appear in the
WorkSpaces client.

# Arguments
- `resource_id`: The directory identifier of the WorkSpace for which you want to import
  client branding.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeviceTypeAndroid"`: The branding information to import for Android devices.
- `"DeviceTypeIos"`: The branding information to import for iOS devices.
- `"DeviceTypeLinux"`: The branding information to import for Linux devices.
- `"DeviceTypeOsx"`: The branding information to import for macOS devices.
- `"DeviceTypeWeb"`: The branding information to import for web access.
- `"DeviceTypeWindows"`: The branding information to import for Windows devices.
"""
function import_client_branding(
    ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "ImportClientBranding",
        Dict{String,Any}("ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_client_branding(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ImportClientBranding",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceId" => ResourceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    import_workspace_image(ec2_image_id, image_description, image_name, ingestion_process)
    import_workspace_image(ec2_image_id, image_description, image_name, ingestion_process, params::Dict{String,<:Any})

Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon
WorkSpaces. The image must be an already licensed Amazon EC2 image that is in your Amazon
Web Services account, and you must own the image. For more information about creating BYOL
images, see  Bring Your Own Windows Desktop Licenses.

# Arguments
- `ec2_image_id`: The identifier of the EC2 image.
- `image_description`: The description of the WorkSpace image.
- `image_name`: The name of the WorkSpace image.
- `ingestion_process`: The ingestion process to be used when importing the image, depending
  on which protocol you want to use for your BYOL Workspace image, either PCoIP, WorkSpaces
  Streaming Protocol (WSP), or bring your own protocol (BYOP). To use WSP, specify a value
  that ends in _WSP. To use PCoIP, specify a value that does not end in _WSP. To use BYOP,
  specify a value that ends in _BYOP. For non-GPU-enabled bundles (bundles other than
  Graphics or GraphicsPro), specify BYOL_REGULAR, BYOL_REGULAR_WSP, or BYOL_REGULAR_BYOP,
  depending on the protocol.  The BYOL_REGULAR_BYOP and BYOL_GRAPHICS_G4DN_BYOP values are
  only supported by Amazon WorkSpaces Core. Contact your account team to be allow-listed to
  use these values. For more information, see Amazon WorkSpaces Core.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Applications"`: If specified, the version of Microsoft Office to subscribe to. Valid
  only for Windows 10 and 11 BYOL images. For more information about subscribing to Office
  for BYOL images, see  Bring Your Own Windows Desktop Licenses.    Although this parameter
  is an array, only one item is allowed at this time.   Windows 11 only supports
  Microsoft_Office_2019.
- `"Tags"`: The tags. Each WorkSpaces resource can have a maximum of 50 tags.
"""
function import_workspace_image(
    Ec2ImageId,
    ImageDescription,
    ImageName,
    IngestionProcess;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ImportWorkspaceImage",
        Dict{String,Any}(
            "Ec2ImageId" => Ec2ImageId,
            "ImageDescription" => ImageDescription,
            "ImageName" => ImageName,
            "IngestionProcess" => IngestionProcess,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function import_workspace_image(
    Ec2ImageId,
    ImageDescription,
    ImageName,
    IngestionProcess,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ImportWorkspaceImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Ec2ImageId" => Ec2ImageId,
                    "ImageDescription" => ImageDescription,
                    "ImageName" => ImageName,
                    "IngestionProcess" => IngestionProcess,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_account_links()
    list_account_links(params::Dict{String,<:Any})

Lists all account links.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LinkStatusFilter"`: Filters the account based on their link status.
- `"MaxResults"`: The maximum number of accounts to return.
- `"NextToken"`: The token to use to retrieve the next page of results. This value is null
  when there are no more results to return.
"""
function list_account_links(; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "ListAccountLinks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_account_links(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "ListAccountLinks", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_available_management_cidr_ranges(management_cidr_range_constraint)
    list_available_management_cidr_ranges(management_cidr_range_constraint, params::Dict{String,<:Any})

Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for
the network management interface when you enable Bring Your Own License (BYOL).  This
operation can be run only by Amazon Web Services accounts that are enabled for BYOL. If
your account isn't enabled for BYOL, you'll receive an AccessDeniedException error. The
management network interface is connected to a secure Amazon WorkSpaces management network.
It is used for interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients,
and to allow Amazon WorkSpaces to manage the WorkSpace.

# Arguments
- `management_cidr_range_constraint`: The IP address range to search. Specify an IP address
  range that is compatible with your network and in CIDR notation (that is, specify the range
  as an IPv4 CIDR block).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return.
- `"NextToken"`: If you received a NextToken from a previous call that was paginated,
  provide this token to receive the next set of results.
"""
function list_available_management_cidr_ranges(
    ManagementCidrRangeConstraint; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "ListAvailableManagementCidrRanges",
        Dict{String,Any}("ManagementCidrRangeConstraint" => ManagementCidrRangeConstraint);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_available_management_cidr_ranges(
    ManagementCidrRangeConstraint,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ListAvailableManagementCidrRanges",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ManagementCidrRangeConstraint" => ManagementCidrRangeConstraint
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    migrate_workspace(bundle_id, source_workspace_id)
    migrate_workspace(bundle_id, source_workspace_id, params::Dict{String,<:Any})

Migrates a WorkSpace from one operating system or bundle type to another, while retaining
the data on the user volume. The migration process recreates the WorkSpace by using a new
root volume from the target bundle image and the user volume from the last available
snapshot of the original WorkSpace. During migration, the original D:Users%USERNAME% user
profile folder is renamed to D:Users%USERNAME%MMddyyTHHmmss%.NotMigrated. A new
D:Users%USERNAME% folder is generated by the new OS. Certain files in the old user profile
are moved to the new user profile. For available migration scenarios, details about what
happens during migration, and best practices, see Migrate a WorkSpace.

# Arguments
- `bundle_id`: The identifier of the target bundle type to migrate the WorkSpace to.
- `source_workspace_id`: The identifier of the WorkSpace to migrate from.

"""
function migrate_workspace(
    BundleId, SourceWorkspaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "MigrateWorkspace",
        Dict{String,Any}("BundleId" => BundleId, "SourceWorkspaceId" => SourceWorkspaceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function migrate_workspace(
    BundleId,
    SourceWorkspaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "MigrateWorkspace",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BundleId" => BundleId, "SourceWorkspaceId" => SourceWorkspaceId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_account()
    modify_account(params::Dict{String,<:Any})

Modifies the configuration of Bring Your Own License (BYOL) for the specified account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DedicatedTenancyManagementCidrRange"`: The IP address range, specified as an IPv4 CIDR
  block, for the management network interface. Specify an IP address range that is compatible
  with your network and in CIDR notation (that is, specify the range as an IPv4 CIDR block).
  The CIDR block size must be /16 (for example, 203.0.113.25/16). It must also be specified
  as available by the ListAvailableManagementCidrRanges operation.
- `"DedicatedTenancySupport"`: The status of BYOL.
"""
function modify_account(; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "ModifyAccount"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function modify_account(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "ModifyAccount", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    modify_certificate_based_auth_properties(resource_id)
    modify_certificate_based_auth_properties(resource_id, params::Dict{String,<:Any})

Modifies the properties of the certificate-based authentication you want to use with your
WorkSpaces.

# Arguments
- `resource_id`: The resource identifiers, in the form of directory IDs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CertificateBasedAuthProperties"`: The properties of the certificate-based
  authentication.
- `"PropertiesToDelete"`: The properties of the certificate-based authentication you want
  to delete.
"""
function modify_certificate_based_auth_properties(
    ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "ModifyCertificateBasedAuthProperties",
        Dict{String,Any}("ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_certificate_based_auth_properties(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ModifyCertificateBasedAuthProperties",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceId" => ResourceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_client_properties(client_properties, resource_id)
    modify_client_properties(client_properties, resource_id, params::Dict{String,<:Any})

Modifies the properties of the specified Amazon WorkSpaces clients.

# Arguments
- `client_properties`: Information about the Amazon WorkSpaces client.
- `resource_id`: The resource identifiers, in the form of directory IDs.

"""
function modify_client_properties(
    ClientProperties, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "ModifyClientProperties",
        Dict{String,Any}(
            "ClientProperties" => ClientProperties, "ResourceId" => ResourceId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_client_properties(
    ClientProperties,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ModifyClientProperties",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientProperties" => ClientProperties, "ResourceId" => ResourceId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_saml_properties(resource_id)
    modify_saml_properties(resource_id, params::Dict{String,<:Any})

Modifies multiple properties related to SAML 2.0 authentication, including the enablement
status, user access URL, and relay state parameter name that are used for configuring
federation with an SAML 2.0 identity provider.

# Arguments
- `resource_id`: The directory identifier for which you want to configure SAML properties.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PropertiesToDelete"`: The SAML properties to delete as part of your request. Specify
  one of the following options:    SAML_PROPERTIES_USER_ACCESS_URL to delete the user access
  URL.    SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME to delete the relay state parameter
  name.
- `"SamlProperties"`: The properties for configuring SAML 2.0 authentication.
"""
function modify_saml_properties(
    ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "ModifySamlProperties",
        Dict{String,Any}("ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_saml_properties(
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ModifySamlProperties",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceId" => ResourceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_selfservice_permissions(resource_id, selfservice_permissions)
    modify_selfservice_permissions(resource_id, selfservice_permissions, params::Dict{String,<:Any})

Modifies the self-service WorkSpace management capabilities for your users. For more
information, see Enable Self-Service WorkSpace Management Capabilities for Your Users.

# Arguments
- `resource_id`: The identifier of the directory.
- `selfservice_permissions`: The permissions to enable or disable self-service capabilities.

"""
function modify_selfservice_permissions(
    ResourceId, SelfservicePermissions; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "ModifySelfservicePermissions",
        Dict{String,Any}(
            "ResourceId" => ResourceId, "SelfservicePermissions" => SelfservicePermissions
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_selfservice_permissions(
    ResourceId,
    SelfservicePermissions,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ModifySelfservicePermissions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceId" => ResourceId,
                    "SelfservicePermissions" => SelfservicePermissions,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_workspace_access_properties(resource_id, workspace_access_properties)
    modify_workspace_access_properties(resource_id, workspace_access_properties, params::Dict{String,<:Any})

Specifies which devices and operating systems users can use to access their WorkSpaces. For
more information, see  Control Device Access.

# Arguments
- `resource_id`: The identifier of the directory.
- `workspace_access_properties`: The device types and operating systems to enable or
  disable for access.

"""
function modify_workspace_access_properties(
    ResourceId,
    WorkspaceAccessProperties;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ModifyWorkspaceAccessProperties",
        Dict{String,Any}(
            "ResourceId" => ResourceId,
            "WorkspaceAccessProperties" => WorkspaceAccessProperties,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_workspace_access_properties(
    ResourceId,
    WorkspaceAccessProperties,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ModifyWorkspaceAccessProperties",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceId" => ResourceId,
                    "WorkspaceAccessProperties" => WorkspaceAccessProperties,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_workspace_creation_properties(resource_id, workspace_creation_properties)
    modify_workspace_creation_properties(resource_id, workspace_creation_properties, params::Dict{String,<:Any})

Modify the default properties used to create WorkSpaces.

# Arguments
- `resource_id`: The identifier of the directory.
- `workspace_creation_properties`: The default properties for creating WorkSpaces.

"""
function modify_workspace_creation_properties(
    ResourceId,
    WorkspaceCreationProperties;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ModifyWorkspaceCreationProperties",
        Dict{String,Any}(
            "ResourceId" => ResourceId,
            "WorkspaceCreationProperties" => WorkspaceCreationProperties,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_workspace_creation_properties(
    ResourceId,
    WorkspaceCreationProperties,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ModifyWorkspaceCreationProperties",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceId" => ResourceId,
                    "WorkspaceCreationProperties" => WorkspaceCreationProperties,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_workspace_properties(workspace_id)
    modify_workspace_properties(workspace_id, params::Dict{String,<:Any})

Modifies the specified WorkSpace properties. For important information about how to modify
the size of the root and user volumes, see  Modify a WorkSpace.   The MANUAL running mode
value is only supported by Amazon WorkSpaces Core. Contact your account team to be
allow-listed to use this value. For more information, see Amazon WorkSpaces Core.

# Arguments
- `workspace_id`: The identifier of the WorkSpace.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataReplication"`: Indicates the data replication status.
- `"WorkspaceProperties"`: The properties of the WorkSpace.
"""
function modify_workspace_properties(
    WorkspaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "ModifyWorkspaceProperties",
        Dict{String,Any}("WorkspaceId" => WorkspaceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_workspace_properties(
    WorkspaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ModifyWorkspaceProperties",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WorkspaceId" => WorkspaceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_workspace_state(workspace_id, workspace_state)
    modify_workspace_state(workspace_id, workspace_state, params::Dict{String,<:Any})

Sets the state of the specified WorkSpace. To maintain a WorkSpace without being
interrupted, set the WorkSpace state to ADMIN_MAINTENANCE. WorkSpaces in this state do not
respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop WorkSpace in
this state is not stopped. Users cannot log into a WorkSpace in the ADMIN_MAINTENANCE state.

# Arguments
- `workspace_id`: The identifier of the WorkSpace.
- `workspace_state`: The WorkSpace state.

"""
function modify_workspace_state(
    WorkspaceId, WorkspaceState; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "ModifyWorkspaceState",
        Dict{String,Any}("WorkspaceId" => WorkspaceId, "WorkspaceState" => WorkspaceState);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_workspace_state(
    WorkspaceId,
    WorkspaceState,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "ModifyWorkspaceState",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "WorkspaceId" => WorkspaceId, "WorkspaceState" => WorkspaceState
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reboot_workspaces(reboot_workspace_requests)
    reboot_workspaces(reboot_workspace_requests, params::Dict{String,<:Any})

Reboots the specified WorkSpaces. You cannot reboot a WorkSpace unless its state is
AVAILABLE, UNHEALTHY, or REBOOTING. Reboot a WorkSpace in the REBOOTING state only if your
WorkSpace has been stuck in the REBOOTING state for over 20 minutes. This operation is
asynchronous and returns before the WorkSpaces have rebooted.

# Arguments
- `reboot_workspace_requests`: The WorkSpaces to reboot. You can specify up to 25
  WorkSpaces.

"""
function reboot_workspaces(
    RebootWorkspaceRequests; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "RebootWorkspaces",
        Dict{String,Any}("RebootWorkspaceRequests" => RebootWorkspaceRequests);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reboot_workspaces(
    RebootWorkspaceRequests,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "RebootWorkspaces",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("RebootWorkspaceRequests" => RebootWorkspaceRequests),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    rebuild_workspaces(rebuild_workspace_requests)
    rebuild_workspaces(rebuild_workspace_requests, params::Dict{String,<:Any})

Rebuilds the specified WorkSpace. You cannot rebuild a WorkSpace unless its state is
AVAILABLE, ERROR, UNHEALTHY, STOPPED, or REBOOTING. Rebuilding a WorkSpace is a potentially
destructive action that can result in the loss of data. For more information, see Rebuild a
WorkSpace. This operation is asynchronous and returns before the WorkSpaces have been
completely rebuilt.

# Arguments
- `rebuild_workspace_requests`: The WorkSpace to rebuild. You can specify a single
  WorkSpace.

"""
function rebuild_workspaces(
    RebuildWorkspaceRequests; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "RebuildWorkspaces",
        Dict{String,Any}("RebuildWorkspaceRequests" => RebuildWorkspaceRequests);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function rebuild_workspaces(
    RebuildWorkspaceRequests,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "RebuildWorkspaces",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("RebuildWorkspaceRequests" => RebuildWorkspaceRequests),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_workspace_directory(directory_id, enable_work_docs)
    register_workspace_directory(directory_id, enable_work_docs, params::Dict{String,<:Any})

Registers the specified directory. This operation is asynchronous and returns before the
WorkSpace directory is registered. If this is the first time you are registering a
directory, you will need to create the workspaces_DefaultRole role before you can register
a directory. For more information, see  Creating the workspaces_DefaultRole Role.

# Arguments
- `directory_id`: The identifier of the directory. You cannot register a directory if it
  does not have a status of Active. If the directory does not have a status of Active, you
  will receive an InvalidResourceStateException error. If you have already registered the
  maximum number of directories that you can register with Amazon WorkSpaces, you will
  receive a ResourceLimitExceededException error. Deregister directories that you are not
  using for WorkSpaces, and try again.
- `enable_work_docs`: Indicates whether Amazon WorkDocs is enabled or disabled. If you have
  enabled this parameter and WorkDocs is not available in the Region, you will receive an
  OperationNotSupportedException error. Set EnableWorkDocs to disabled, and try again.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EnableSelfService"`: Indicates whether self-service capabilities are enabled or
  disabled.
- `"SubnetIds"`: The identifiers of the subnets for your virtual private cloud (VPC). Make
  sure that the subnets are in supported Availability Zones. The subnets must also be in
  separate Availability Zones. If these conditions are not met, you will receive an
  OperationNotSupportedException error.
- `"Tags"`: The tags associated with the directory.
- `"Tenancy"`: Indicates whether your WorkSpace directory is dedicated or shared. To use
  Bring Your Own License (BYOL) images, this value must be set to DEDICATED and your Amazon
  Web Services account must be enabled for BYOL. If your account has not been enabled for
  BYOL, you will receive an InvalidParameterValuesException error. For more information about
  BYOL images, see Bring Your Own Windows Desktop Images.
"""
function register_workspace_directory(
    DirectoryId, EnableWorkDocs; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "RegisterWorkspaceDirectory",
        Dict{String,Any}("DirectoryId" => DirectoryId, "EnableWorkDocs" => EnableWorkDocs);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_workspace_directory(
    DirectoryId,
    EnableWorkDocs,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "RegisterWorkspaceDirectory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DirectoryId" => DirectoryId, "EnableWorkDocs" => EnableWorkDocs
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reject_account_link_invitation(link_id)
    reject_account_link_invitation(link_id, params::Dict{String,<:Any})

Rejects the account link invitation.

# Arguments
- `link_id`: The identifier of the account link

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: The client token of the account link invitation to reject.
"""
function reject_account_link_invitation(
    LinkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "RejectAccountLinkInvitation",
        Dict{String,Any}("LinkId" => LinkId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reject_account_link_invitation(
    LinkId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "RejectAccountLinkInvitation",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("LinkId" => LinkId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_workspace(workspace_id)
    restore_workspace(workspace_id, params::Dict{String,<:Any})

Restores the specified WorkSpace to its last known healthy state. You cannot restore a
WorkSpace unless its state is  AVAILABLE, ERROR, UNHEALTHY, or STOPPED. Restoring a
WorkSpace is a potentially destructive action that can result in the loss of data. For more
information, see Restore a WorkSpace. This operation is asynchronous and returns before the
WorkSpace is completely restored.

# Arguments
- `workspace_id`: The identifier of the WorkSpace.

"""
function restore_workspace(WorkspaceId; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "RestoreWorkspace",
        Dict{String,Any}("WorkspaceId" => WorkspaceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_workspace(
    WorkspaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "RestoreWorkspace",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("WorkspaceId" => WorkspaceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    revoke_ip_rules(group_id, user_rules)
    revoke_ip_rules(group_id, user_rules, params::Dict{String,<:Any})

Removes one or more rules from the specified IP access control group.

# Arguments
- `group_id`: The identifier of the group.
- `user_rules`: The rules to remove from the group.

"""
function revoke_ip_rules(
    GroupId, UserRules; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "RevokeIpRules",
        Dict{String,Any}("GroupId" => GroupId, "UserRules" => UserRules);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function revoke_ip_rules(
    GroupId,
    UserRules,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "RevokeIpRules",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupId" => GroupId, "UserRules" => UserRules),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_workspaces(start_workspace_requests)
    start_workspaces(start_workspace_requests, params::Dict{String,<:Any})

Starts the specified WorkSpaces. You cannot start a WorkSpace unless it has a running mode
of AutoStop and a state of STOPPED.

# Arguments
- `start_workspace_requests`: The WorkSpaces to start. You can specify up to 25 WorkSpaces.

"""
function start_workspaces(
    StartWorkspaceRequests; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "StartWorkspaces",
        Dict{String,Any}("StartWorkspaceRequests" => StartWorkspaceRequests);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_workspaces(
    StartWorkspaceRequests,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "StartWorkspaces",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("StartWorkspaceRequests" => StartWorkspaceRequests),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_workspaces(stop_workspace_requests)
    stop_workspaces(stop_workspace_requests, params::Dict{String,<:Any})

 Stops the specified WorkSpaces. You cannot stop a WorkSpace unless it has a running mode
of AutoStop and a state of AVAILABLE, IMPAIRED, UNHEALTHY, or ERROR.

# Arguments
- `stop_workspace_requests`: The WorkSpaces to stop. You can specify up to 25 WorkSpaces.

"""
function stop_workspaces(
    StopWorkspaceRequests; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "StopWorkspaces",
        Dict{String,Any}("StopWorkspaceRequests" => StopWorkspaceRequests);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_workspaces(
    StopWorkspaceRequests,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "StopWorkspaces",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("StopWorkspaceRequests" => StopWorkspaceRequests),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    terminate_workspaces(terminate_workspace_requests)
    terminate_workspaces(terminate_workspace_requests, params::Dict{String,<:Any})

Terminates the specified WorkSpaces.  Terminating a WorkSpace is a permanent action and
cannot be undone. The user's data is destroyed. If you need to archive any user data,
contact Amazon Web Services Support before terminating the WorkSpace.  You can terminate a
WorkSpace that is in any state except SUSPENDED. This operation is asynchronous and returns
before the WorkSpaces have been completely terminated. After a WorkSpace is terminated, the
TERMINATED state is returned only briefly before the WorkSpace directory metadata is
cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated,
check for the WorkSpace ID by using  DescribeWorkSpaces. If the WorkSpace ID isn't
returned, then the WorkSpace has been successfully terminated.  Simple AD and AD Connector
are made available to you free of charge to use with WorkSpaces. If there are no WorkSpaces
being used with your Simple AD or AD Connector directory for 30 consecutive days, this
directory will be automatically deregistered for use with Amazon WorkSpaces, and you will
be charged for this directory as per the Directory Service pricing terms. To delete empty
directories, see  Delete the Directory for Your WorkSpaces. If you delete your Simple AD or
AD Connector directory, you can always create a new one when you want to start using
WorkSpaces again.

# Arguments
- `terminate_workspace_requests`: The WorkSpaces to terminate. You can specify up to 25
  WorkSpaces.

"""
function terminate_workspaces(
    TerminateWorkspaceRequests; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "TerminateWorkspaces",
        Dict{String,Any}("TerminateWorkspaceRequests" => TerminateWorkspaceRequests);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function terminate_workspaces(
    TerminateWorkspaceRequests,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "TerminateWorkspaces",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TerminateWorkspaceRequests" => TerminateWorkspaceRequests
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_connect_client_add_in(add_in_id, resource_id)
    update_connect_client_add_in(add_in_id, resource_id, params::Dict{String,<:Any})

Updates a Amazon Connect client add-in. Use this action to update the name and endpoint URL
of a Amazon Connect client add-in.

# Arguments
- `add_in_id`: The identifier of the client add-in to update.
- `resource_id`: The directory identifier for which the client add-in is configured.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Name"`: The name of the client add-in.
- `"URL"`: The endpoint URL of the Amazon Connect client add-in.
"""
function update_connect_client_add_in(
    AddInId, ResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "UpdateConnectClientAddIn",
        Dict{String,Any}("AddInId" => AddInId, "ResourceId" => ResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_connect_client_add_in(
    AddInId,
    ResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "UpdateConnectClientAddIn",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AddInId" => AddInId, "ResourceId" => ResourceId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_connection_alias_permission(alias_id, connection_alias_permission)
    update_connection_alias_permission(alias_id, connection_alias_permission, params::Dict{String,<:Any})

Shares or unshares a connection alias with one account by specifying whether that account
has permission to associate the connection alias with a directory. If the association
permission is granted, the connection alias is shared with that account. If the association
permission is revoked, the connection alias is unshared with the account. For more
information, see  Cross-Region Redirection for Amazon WorkSpaces.    Before performing this
operation, call  DescribeConnectionAliases to make sure that the current state of the
connection alias is CREATED.   To delete a connection alias that has been shared, the
shared account must first disassociate the connection alias from any directories it has
been associated with. Then you must unshare the connection alias from the account it has
been shared with. You can delete a connection alias only after it is no longer shared with
any accounts or associated with any directories.

# Arguments
- `alias_id`: The identifier of the connection alias that you want to update permissions
  for.
- `connection_alias_permission`: Indicates whether to share or unshare the connection alias
  with the specified Amazon Web Services account.

"""
function update_connection_alias_permission(
    AliasId, ConnectionAliasPermission; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "UpdateConnectionAliasPermission",
        Dict{String,Any}(
            "AliasId" => AliasId, "ConnectionAliasPermission" => ConnectionAliasPermission
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_connection_alias_permission(
    AliasId,
    ConnectionAliasPermission,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "UpdateConnectionAliasPermission",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AliasId" => AliasId,
                    "ConnectionAliasPermission" => ConnectionAliasPermission,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_rules_of_ip_group(group_id, user_rules)
    update_rules_of_ip_group(group_id, user_rules, params::Dict{String,<:Any})

Replaces the current rules of the specified IP access control group with the specified
rules.

# Arguments
- `group_id`: The identifier of the group.
- `user_rules`: One or more rules.

"""
function update_rules_of_ip_group(
    GroupId, UserRules; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "UpdateRulesOfIpGroup",
        Dict{String,Any}("GroupId" => GroupId, "UserRules" => UserRules);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_rules_of_ip_group(
    GroupId,
    UserRules,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "UpdateRulesOfIpGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupId" => GroupId, "UserRules" => UserRules),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_workspace_bundle()
    update_workspace_bundle(params::Dict{String,<:Any})

Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace
bundles, see  Update a Custom WorkSpaces Bundle.  Existing WorkSpaces aren't automatically
updated when you update the bundle that they're based on. To update existing WorkSpaces
that are based on a bundle that you've updated, you must either rebuild the WorkSpaces or
delete and recreate them.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BundleId"`: The identifier of the bundle.
- `"ImageId"`: The identifier of the image.
"""
function update_workspace_bundle(; aws_config::AbstractAWSConfig=current_aws_config())
    return workspaces(
        "UpdateWorkspaceBundle"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function update_workspace_bundle(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return workspaces(
        "UpdateWorkspaceBundle",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_workspace_image_permission(allow_copy_image, image_id, shared_account_id)
    update_workspace_image_permission(allow_copy_image, image_id, shared_account_id, params::Dict{String,<:Any})

Shares or unshares an image with one account in the same Amazon Web Services Region by
specifying whether that account has permission to copy the image. If the copy image
permission is granted, the image is shared with that account. If the copy image permission
is revoked, the image is unshared with the account. After an image has been shared, the
recipient account can copy the image to other Regions as needed. In the China (Ningxia)
Region, you can copy images only within the same Region. In Amazon Web Services GovCloud
(US), to copy images to and from other Regions, contact Amazon Web Services Support. For
more information about sharing images, see  Share or Unshare a Custom WorkSpaces Image.
To delete an image that has been shared, you must unshare the image before you delete it.
Sharing Bring Your Own License (BYOL) images across Amazon Web Services accounts isn't
supported at this time in Amazon Web Services GovCloud (US). To share BYOL images across
accounts in Amazon Web Services GovCloud (US), contact Amazon Web Services Support.

# Arguments
- `allow_copy_image`: The permission to copy the image. This permission can be revoked only
  after an image has been shared.
- `image_id`: The identifier of the image.
- `shared_account_id`: The identifier of the Amazon Web Services account to share or
  unshare the image with.  Before sharing the image, confirm that you are sharing to the
  correct Amazon Web Services account ID.

"""
function update_workspace_image_permission(
    AllowCopyImage,
    ImageId,
    SharedAccountId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "UpdateWorkspaceImagePermission",
        Dict{String,Any}(
            "AllowCopyImage" => AllowCopyImage,
            "ImageId" => ImageId,
            "SharedAccountId" => SharedAccountId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_workspace_image_permission(
    AllowCopyImage,
    ImageId,
    SharedAccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return workspaces(
        "UpdateWorkspaceImagePermission",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AllowCopyImage" => AllowCopyImage,
                    "ImageId" => ImageId,
                    "SharedAccountId" => SharedAccountId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
