# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: codecommit
using AWS.Compat
using AWS.UUIDs

"""
    associate_approval_rule_template_with_repository(approval_rule_template_name, repository_name)
    associate_approval_rule_template_with_repository(approval_rule_template_name, repository_name, params::Dict{String,<:Any})

Creates an association between an approval rule template and a specified repository. Then,
the next time a pull request is created in the repository where the destination reference
(if specified) matches the destination reference (branch) for the pull request, an approval
rule that matches the template conditions is automatically created for that pull request.
If no destination references are specified in the template, an approval rule that matches
the template contents is created for all pull requests in that repository.

# Arguments
- `approval_rule_template_name`: The name for the approval rule template.
- `repository_name`: The name of the repository that you want to associate with the
  template.

"""
function associate_approval_rule_template_with_repository(
    approvalRuleTemplateName,
    repositoryName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "AssociateApprovalRuleTemplateWithRepository",
        Dict{String,Any}(
            "approvalRuleTemplateName" => approvalRuleTemplateName,
            "repositoryName" => repositoryName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_approval_rule_template_with_repository(
    approvalRuleTemplateName,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "AssociateApprovalRuleTemplateWithRepository",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "approvalRuleTemplateName" => approvalRuleTemplateName,
                    "repositoryName" => repositoryName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_associate_approval_rule_template_with_repositories(approval_rule_template_name, repository_names)
    batch_associate_approval_rule_template_with_repositories(approval_rule_template_name, repository_names, params::Dict{String,<:Any})

Creates an association between an approval rule template and one or more specified
repositories.

# Arguments
- `approval_rule_template_name`: The name of the template you want to associate with one or
  more repositories.
- `repository_names`: The names of the repositories you want to associate with the
  template.  The length constraint limit is for each string in the array. The array itself
  can be empty.

"""
function batch_associate_approval_rule_template_with_repositories(
    approvalRuleTemplateName,
    repositoryNames;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "BatchAssociateApprovalRuleTemplateWithRepositories",
        Dict{String,Any}(
            "approvalRuleTemplateName" => approvalRuleTemplateName,
            "repositoryNames" => repositoryNames,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_associate_approval_rule_template_with_repositories(
    approvalRuleTemplateName,
    repositoryNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "BatchAssociateApprovalRuleTemplateWithRepositories",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "approvalRuleTemplateName" => approvalRuleTemplateName,
                    "repositoryNames" => repositoryNames,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_describe_merge_conflicts(destination_commit_specifier, merge_option, repository_name, source_commit_specifier)
    batch_describe_merge_conflicts(destination_commit_specifier, merge_option, repository_name, source_commit_specifier, params::Dict{String,<:Any})

Returns information about one or more merge conflicts in the attempted merge of two commit
specifiers using the squash or three-way merge strategy.

# Arguments
- `destination_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference
  used to identify a commit (for example, a branch name or a full commit ID).
- `merge_option`: The merge option or strategy you want to use to merge the code.
- `repository_name`: The name of the repository that contains the merge conflicts you want
  to review.
- `source_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference used
  to identify a commit (for example, a branch name or a full commit ID).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"conflictDetailLevel"`: The level of conflict detail to use. If unspecified, the default
  FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences
  in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the
  same file in both branches has differences on the same line.
- `"conflictResolutionStrategy"`: Specifies which branch to use when resolving conflicts,
  or whether to attempt automatically merging two versions of a file. The default is NONE,
  which requires any conflicts to be resolved manually before the merge operation is
  successful.
- `"filePaths"`: The path of the target files used to describe the conflicts. If not
  specified, the default is all conflict files.
- `"maxConflictFiles"`: The maximum number of files to include in the output.
- `"maxMergeHunks"`: The maximum number of merge hunks to include in the output.
- `"nextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
"""
function batch_describe_merge_conflicts(
    destinationCommitSpecifier,
    mergeOption,
    repositoryName,
    sourceCommitSpecifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "BatchDescribeMergeConflicts",
        Dict{String,Any}(
            "destinationCommitSpecifier" => destinationCommitSpecifier,
            "mergeOption" => mergeOption,
            "repositoryName" => repositoryName,
            "sourceCommitSpecifier" => sourceCommitSpecifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_describe_merge_conflicts(
    destinationCommitSpecifier,
    mergeOption,
    repositoryName,
    sourceCommitSpecifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "BatchDescribeMergeConflicts",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationCommitSpecifier" => destinationCommitSpecifier,
                    "mergeOption" => mergeOption,
                    "repositoryName" => repositoryName,
                    "sourceCommitSpecifier" => sourceCommitSpecifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_disassociate_approval_rule_template_from_repositories(approval_rule_template_name, repository_names)
    batch_disassociate_approval_rule_template_from_repositories(approval_rule_template_name, repository_names, params::Dict{String,<:Any})

Removes the association between an approval rule template and one or more specified
repositories.

# Arguments
- `approval_rule_template_name`: The name of the template that you want to disassociate
  from one or more repositories.
- `repository_names`: The repository names that you want to disassociate from the approval
  rule template.  The length constraint limit is for each string in the array. The array
  itself can be empty.

"""
function batch_disassociate_approval_rule_template_from_repositories(
    approvalRuleTemplateName,
    repositoryNames;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "BatchDisassociateApprovalRuleTemplateFromRepositories",
        Dict{String,Any}(
            "approvalRuleTemplateName" => approvalRuleTemplateName,
            "repositoryNames" => repositoryNames,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_disassociate_approval_rule_template_from_repositories(
    approvalRuleTemplateName,
    repositoryNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "BatchDisassociateApprovalRuleTemplateFromRepositories",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "approvalRuleTemplateName" => approvalRuleTemplateName,
                    "repositoryNames" => repositoryNames,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_get_commits(commit_ids, repository_name)
    batch_get_commits(commit_ids, repository_name, params::Dict{String,<:Any})

Returns information about the contents of one or more commits in a repository.

# Arguments
- `commit_ids`: The full commit IDs of the commits to get information about.  You must
  supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.
- `repository_name`: The name of the repository that contains the commits.

"""
function batch_get_commits(
    commitIds, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "BatchGetCommits",
        Dict{String,Any}("commitIds" => commitIds, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_commits(
    commitIds,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "BatchGetCommits",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "commitIds" => commitIds, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_get_repositories(repository_names)
    batch_get_repositories(repository_names, params::Dict{String,<:Any})

Returns information about one or more repositories.  The description field for a repository
accepts all HTML characters and all valid Unicode characters. Applications that do not
HTML-encode the description and display it in a webpage can expose users to potentially
malicious code. Make sure that you HTML-encode the description field in any application
that uses this API to display the repository description on a webpage.

# Arguments
- `repository_names`: The names of the repositories to get information about.  The length
  constraint limit is for each string in the array. The array itself can be empty.

"""
function batch_get_repositories(
    repositoryNames; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "BatchGetRepositories",
        Dict{String,Any}("repositoryNames" => repositoryNames);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_repositories(
    repositoryNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "BatchGetRepositories",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("repositoryNames" => repositoryNames), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_approval_rule_template(approval_rule_template_content, approval_rule_template_name)
    create_approval_rule_template(approval_rule_template_content, approval_rule_template_name, params::Dict{String,<:Any})

Creates a template for approval rules that can then be associated with one or more
repositories in your Amazon Web Services account. When you associate a template with a
repository, CodeCommit creates an approval rule that matches the conditions of the template
for all pull requests that meet the conditions of the template. For more information, see
AssociateApprovalRuleTemplateWithRepository.

# Arguments
- `approval_rule_template_content`: The content of the approval rule that is created on
  pull requests in associated repositories. If you specify one or more destination references
  (branches), approval rules are created in an associated repository only if their
  destination references (branches) match those specified in the template.  When you create
  the content of the approval rule template, you can specify approvers in an approval pool in
  one of two ways:    CodeCommitApprovers: This option only requires an Amazon Web Services
  account and a resource. It can be used for both IAM users and federated access users whose
  name matches the provided resource name. This is a very powerful option that offers a great
  deal of flexibility. For example, if you specify the Amazon Web Services account
  123456789012 and Mary_Major, all of the following are counted as approvals coming from that
  user:   An IAM user in the account (arn:aws:iam::123456789012:user/Mary_Major)   A
  federated user identified in IAM as Mary_Major
  (arn:aws:sts::123456789012:federated-user/Mary_Major)   This option does not recognize an
  active session of someone assuming the role of CodeCommitReview with a role session name of
  Mary_Major (arn:aws:sts::123456789012:assumed-role/CodeCommitReview/Mary_Major) unless you
  include a wildcard (*Mary_Major).    Fully qualified ARN: This option allows you to specify
  the fully qualified Amazon Resource Name (ARN) of the IAM user or role.    For more
  information about IAM ARNs, wildcards, and formats, see IAM Identifiers in the IAM User
  Guide.
- `approval_rule_template_name`: The name of the approval rule template. Provide
  descriptive names, because this name is applied to the approval rules created automatically
  in associated repositories.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"approvalRuleTemplateDescription"`: The description of the approval rule template.
  Consider providing a description that explains what this template does and when it might be
  appropriate to associate it with repositories.
"""
function create_approval_rule_template(
    approvalRuleTemplateContent,
    approvalRuleTemplateName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "CreateApprovalRuleTemplate",
        Dict{String,Any}(
            "approvalRuleTemplateContent" => approvalRuleTemplateContent,
            "approvalRuleTemplateName" => approvalRuleTemplateName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_approval_rule_template(
    approvalRuleTemplateContent,
    approvalRuleTemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "CreateApprovalRuleTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "approvalRuleTemplateContent" => approvalRuleTemplateContent,
                    "approvalRuleTemplateName" => approvalRuleTemplateName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_branch(branch_name, commit_id, repository_name)
    create_branch(branch_name, commit_id, repository_name, params::Dict{String,<:Any})

Creates a branch in a repository and points the branch to a commit.  Calling the create
branch operation does not set a repository's default branch. To do this, call the update
default branch operation.

# Arguments
- `branch_name`: The name of the new branch to create.
- `commit_id`: The ID of the commit to point the new branch to.
- `repository_name`: The name of the repository in which you want to create the new branch.

"""
function create_branch(
    branchName, commitId, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "CreateBranch",
        Dict{String,Any}(
            "branchName" => branchName,
            "commitId" => commitId,
            "repositoryName" => repositoryName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_branch(
    branchName,
    commitId,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "CreateBranch",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "branchName" => branchName,
                    "commitId" => commitId,
                    "repositoryName" => repositoryName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_commit(branch_name, repository_name)
    create_commit(branch_name, repository_name, params::Dict{String,<:Any})

Creates a commit for a repository on the tip of a specified branch.

# Arguments
- `branch_name`: The name of the branch where you create the commit.
- `repository_name`: The name of the repository where you create the commit.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authorName"`: The name of the author who created the commit. This information is used
  as both the author and committer for the commit.
- `"commitMessage"`: The commit message you want to include in the commit. Commit messages
  are limited to 256 KB. If no message is specified, a default message is used.
- `"deleteFiles"`: The files to delete in this commit. These files still exist in earlier
  commits.
- `"email"`: The email address of the person who created the commit.
- `"keepEmptyFolders"`: If the commit contains deletions, whether to keep a folder or
  folder structure if the changes leave the folders empty. If true, a ..gitkeep file is
  created for empty folders. The default is false.
- `"parentCommitId"`: The ID of the commit that is the parent of the commit you create. Not
  required if this is an empty repository.
- `"putFiles"`: The files to add or update in this commit.
- `"setFileModes"`: The file modes to update for files in this commit.
"""
function create_commit(
    branchName, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "CreateCommit",
        Dict{String,Any}("branchName" => branchName, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_commit(
    branchName,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "CreateCommit",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "branchName" => branchName, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_pull_request(targets, title)
    create_pull_request(targets, title, params::Dict{String,<:Any})

Creates a pull request in the specified repository.

# Arguments
- `targets`: The targets for the pull request, including the source of the code to be
  reviewed (the source branch) and the destination where the creator of the pull request
  intends the code to be merged after the pull request is closed (the destination branch).
- `title`: The title of the pull request. This title is used to identify the pull request
  to other users in the repository.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientRequestToken"`: A unique, client-generated idempotency token that, when provided
  in a request, ensures the request cannot be repeated with a changed parameter. If a request
  is received with the same parameters and a token is included, the request returns
  information about the initial request that used that token.  The Amazon Web ServicesSDKs
  prepopulate client request tokens. If you are using an Amazon Web ServicesSDK, an
  idempotency token is created for you.
- `"description"`: A description of the pull request.
"""
function create_pull_request(
    targets, title; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "CreatePullRequest",
        Dict{String,Any}(
            "targets" => targets, "title" => title, "clientRequestToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_pull_request(
    targets,
    title,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "CreatePullRequest",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "targets" => targets,
                    "title" => title,
                    "clientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_pull_request_approval_rule(approval_rule_content, approval_rule_name, pull_request_id)
    create_pull_request_approval_rule(approval_rule_content, approval_rule_name, pull_request_id, params::Dict{String,<:Any})

Creates an approval rule for a pull request.

# Arguments
- `approval_rule_content`: The content of the approval rule, including the number of
  approvals needed and the structure of an approval pool defined for approvals, if any. For
  more information about approval pools, see the CodeCommit User Guide.  When you create the
  content of the approval rule, you can specify approvers in an approval pool in one of two
  ways:    CodeCommitApprovers: This option only requires an Amazon Web Services account and
  a resource. It can be used for both IAM users and federated access users whose name matches
  the provided resource name. This is a very powerful option that offers a great deal of
  flexibility. For example, if you specify the Amazon Web Services account 123456789012 and
  Mary_Major, all of the following would be counted as approvals coming from that user:   An
  IAM user in the account (arn:aws:iam::123456789012:user/Mary_Major)   A federated user
  identified in IAM as Mary_Major (arn:aws:sts::123456789012:federated-user/Mary_Major)
  This option does not recognize an active session of someone assuming the role of
  CodeCommitReview with a role session name of Mary_Major
  (arn:aws:sts::123456789012:assumed-role/CodeCommitReview/Mary_Major) unless you include a
  wildcard (*Mary_Major).    Fully qualified ARN: This option allows you to specify the fully
  qualified Amazon Resource Name (ARN) of the IAM user or role.    For more information about
  IAM ARNs, wildcards, and formats, see IAM Identifiers in the IAM User Guide.
- `approval_rule_name`: The name for the approval rule.
- `pull_request_id`: The system-generated ID of the pull request for which you want to
  create the approval rule.

"""
function create_pull_request_approval_rule(
    approvalRuleContent,
    approvalRuleName,
    pullRequestId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "CreatePullRequestApprovalRule",
        Dict{String,Any}(
            "approvalRuleContent" => approvalRuleContent,
            "approvalRuleName" => approvalRuleName,
            "pullRequestId" => pullRequestId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_pull_request_approval_rule(
    approvalRuleContent,
    approvalRuleName,
    pullRequestId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "CreatePullRequestApprovalRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "approvalRuleContent" => approvalRuleContent,
                    "approvalRuleName" => approvalRuleName,
                    "pullRequestId" => pullRequestId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_repository(repository_name)
    create_repository(repository_name, params::Dict{String,<:Any})

Creates a new, empty repository.

# Arguments
- `repository_name`: The name of the new repository to be created.  The repository name
  must be unique across the calling Amazon Web Services account. Repository names are limited
  to 100 alphanumeric, dash, and underscore characters, and cannot include certain
  characters. For more information about the limits on repository names, see Quotas in the
  CodeCommit User Guide. The suffix .git is prohibited.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"kmsKeyId"`: The ID of the encryption key. You can view the ID of an encryption key in
  the KMS console, or use the KMS APIs to programmatically retrieve a key ID. For more
  information about acceptable values for kmsKeyID, see KeyId in the Decrypt API description
  in the Key Management Service API Reference. If no key is specified, the default
  aws/codecommit Amazon Web Services managed key is used.
- `"repositoryDescription"`: A comment or description about the new repository.  The
  description field for a repository accepts all HTML characters and all valid Unicode
  characters. Applications that do not HTML-encode the description and display it in a
  webpage can expose users to potentially malicious code. Make sure that you HTML-encode the
  description field in any application that uses this API to display the repository
  description on a webpage.
- `"tags"`: One or more tag key-value pairs to use when tagging this repository.
"""
function create_repository(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "CreateRepository",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_repository(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "CreateRepository",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_unreferenced_merge_commit(destination_commit_specifier, merge_option, repository_name, source_commit_specifier)
    create_unreferenced_merge_commit(destination_commit_specifier, merge_option, repository_name, source_commit_specifier, params::Dict{String,<:Any})

Creates an unreferenced commit that represents the result of merging two branches using a
specified merge strategy. This can help you determine the outcome of a potential merge.
This API cannot be used with the fast-forward merge strategy because that strategy does not
create a merge commit.  This unreferenced merge commit can only be accessed using the
GetCommit API or through git commands such as git fetch. To retrieve this commit, you must
specify its commit ID or otherwise reference it.

# Arguments
- `destination_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference
  used to identify a commit (for example, a branch name or a full commit ID).
- `merge_option`: The merge option or strategy you want to use to merge the code.
- `repository_name`: The name of the repository where you want to create the unreferenced
  merge commit.
- `source_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference used
  to identify a commit (for example, a branch name or a full commit ID).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authorName"`: The name of the author who created the unreferenced commit. This
  information is used as both the author and committer for the commit.
- `"commitMessage"`: The commit message for the unreferenced commit.
- `"conflictDetailLevel"`: The level of conflict detail to use. If unspecified, the default
  FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences
  in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the
  same file in both branches has differences on the same line.
- `"conflictResolution"`: If AUTOMERGE is the conflict resolution strategy, a list of
  inputs to use when resolving conflicts during a merge.
- `"conflictResolutionStrategy"`: Specifies which branch to use when resolving conflicts,
  or whether to attempt automatically merging two versions of a file. The default is NONE,
  which requires any conflicts to be resolved manually before the merge operation is
  successful.
- `"email"`: The email address for the person who created the unreferenced commit.
- `"keepEmptyFolders"`: If the commit contains deletions, whether to keep a folder or
  folder structure if the changes leave the folders empty. If this is specified as true, a
  .gitkeep file is created for empty folders. The default is false.
"""
function create_unreferenced_merge_commit(
    destinationCommitSpecifier,
    mergeOption,
    repositoryName,
    sourceCommitSpecifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "CreateUnreferencedMergeCommit",
        Dict{String,Any}(
            "destinationCommitSpecifier" => destinationCommitSpecifier,
            "mergeOption" => mergeOption,
            "repositoryName" => repositoryName,
            "sourceCommitSpecifier" => sourceCommitSpecifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_unreferenced_merge_commit(
    destinationCommitSpecifier,
    mergeOption,
    repositoryName,
    sourceCommitSpecifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "CreateUnreferencedMergeCommit",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationCommitSpecifier" => destinationCommitSpecifier,
                    "mergeOption" => mergeOption,
                    "repositoryName" => repositoryName,
                    "sourceCommitSpecifier" => sourceCommitSpecifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_approval_rule_template(approval_rule_template_name)
    delete_approval_rule_template(approval_rule_template_name, params::Dict{String,<:Any})

Deletes a specified approval rule template. Deleting a template does not remove approval
rules on pull requests already created with the template.

# Arguments
- `approval_rule_template_name`: The name of the approval rule template to delete.

"""
function delete_approval_rule_template(
    approvalRuleTemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "DeleteApprovalRuleTemplate",
        Dict{String,Any}("approvalRuleTemplateName" => approvalRuleTemplateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_approval_rule_template(
    approvalRuleTemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "DeleteApprovalRuleTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("approvalRuleTemplateName" => approvalRuleTemplateName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_branch(branch_name, repository_name)
    delete_branch(branch_name, repository_name, params::Dict{String,<:Any})

Deletes a branch from a repository, unless that branch is the default branch for the
repository.

# Arguments
- `branch_name`: The name of the branch to delete.
- `repository_name`: The name of the repository that contains the branch to be deleted.

"""
function delete_branch(
    branchName, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "DeleteBranch",
        Dict{String,Any}("branchName" => branchName, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_branch(
    branchName,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "DeleteBranch",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "branchName" => branchName, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_comment_content(comment_id)
    delete_comment_content(comment_id, params::Dict{String,<:Any})

Deletes the content of a comment made on a change, file, or commit in a repository.

# Arguments
- `comment_id`: The unique, system-generated ID of the comment. To get this ID, use
  GetCommentsForComparedCommit or GetCommentsForPullRequest.

"""
function delete_comment_content(
    commentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "DeleteCommentContent",
        Dict{String,Any}("commentId" => commentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_comment_content(
    commentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "DeleteCommentContent",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("commentId" => commentId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_file(branch_name, file_path, parent_commit_id, repository_name)
    delete_file(branch_name, file_path, parent_commit_id, repository_name, params::Dict{String,<:Any})

Deletes a specified file from a specified branch. A commit is created on the branch that
contains the revision. The file still exists in the commits earlier to the commit that
contains the deletion.

# Arguments
- `branch_name`: The name of the branch where the commit that deletes the file is made.
- `file_path`: The fully qualified path to the file that to be deleted, including the full
  name and extension of that file. For example, /examples/file.md is a fully qualified path
  to a file named file.md in a folder named examples.
- `parent_commit_id`: The ID of the commit that is the tip of the branch where you want to
  create the commit that deletes the file. This must be the HEAD commit for the branch. The
  commit that deletes the file is created from this commit ID.
- `repository_name`: The name of the repository that contains the file to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"commitMessage"`: The commit message you want to include as part of deleting the file.
  Commit messages are limited to 256 KB. If no message is specified, a default message is
  used.
- `"email"`: The email address for the commit that deletes the file. If no email address is
  specified, the email address is left blank.
- `"keepEmptyFolders"`: If a file is the only object in the folder or directory, specifies
  whether to delete the folder or directory that contains the file. By default, empty folders
  are deleted. This includes empty folders that are part of the directory structure. For
  example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty,
  deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.
- `"name"`: The name of the author of the commit that deletes the file. If no name is
  specified, the user's ARN is used as the author name and committer name.
"""
function delete_file(
    branchName,
    filePath,
    parentCommitId,
    repositoryName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "DeleteFile",
        Dict{String,Any}(
            "branchName" => branchName,
            "filePath" => filePath,
            "parentCommitId" => parentCommitId,
            "repositoryName" => repositoryName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_file(
    branchName,
    filePath,
    parentCommitId,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "DeleteFile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "branchName" => branchName,
                    "filePath" => filePath,
                    "parentCommitId" => parentCommitId,
                    "repositoryName" => repositoryName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_pull_request_approval_rule(approval_rule_name, pull_request_id)
    delete_pull_request_approval_rule(approval_rule_name, pull_request_id, params::Dict{String,<:Any})

Deletes an approval rule from a specified pull request. Approval rules can be deleted from
a pull request only if the pull request is open, and if the approval rule was created
specifically for a pull request and not generated from an approval rule template associated
with the repository where the pull request was created. You cannot delete an approval rule
from a merged or closed pull request.

# Arguments
- `approval_rule_name`: The name of the approval rule you want to delete.
- `pull_request_id`: The system-generated ID of the pull request that contains the approval
  rule you want to delete.

"""
function delete_pull_request_approval_rule(
    approvalRuleName, pullRequestId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "DeletePullRequestApprovalRule",
        Dict{String,Any}(
            "approvalRuleName" => approvalRuleName, "pullRequestId" => pullRequestId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_pull_request_approval_rule(
    approvalRuleName,
    pullRequestId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "DeletePullRequestApprovalRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "approvalRuleName" => approvalRuleName, "pullRequestId" => pullRequestId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_repository(repository_name)
    delete_repository(repository_name, params::Dict{String,<:Any})

Deletes a repository. If a specified repository was already deleted, a null repository ID
is returned.  Deleting a repository also deletes all associated objects and metadata. After
a repository is deleted, all future push calls to the deleted repository fail.

# Arguments
- `repository_name`: The name of the repository to delete.

"""
function delete_repository(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "DeleteRepository",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_repository(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "DeleteRepository",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_merge_conflicts(destination_commit_specifier, file_path, merge_option, repository_name, source_commit_specifier)
    describe_merge_conflicts(destination_commit_specifier, file_path, merge_option, repository_name, source_commit_specifier, params::Dict{String,<:Any})

Returns information about one or more merge conflicts in the attempted merge of two commit
specifiers using the squash or three-way merge strategy. If the merge option for the
attempted merge is specified as FAST_FORWARD_MERGE, an exception is thrown.

# Arguments
- `destination_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference
  used to identify a commit (for example, a branch name or a full commit ID).
- `file_path`: The path of the target files used to describe the conflicts.
- `merge_option`: The merge option or strategy you want to use to merge the code.
- `repository_name`: The name of the repository where you want to get information about a
  merge conflict.
- `source_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference used
  to identify a commit (for example, a branch name or a full commit ID).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"conflictDetailLevel"`: The level of conflict detail to use. If unspecified, the default
  FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences
  in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the
  same file in both branches has differences on the same line.
- `"conflictResolutionStrategy"`: Specifies which branch to use when resolving conflicts,
  or whether to attempt automatically merging two versions of a file. The default is NONE,
  which requires any conflicts to be resolved manually before the merge operation is
  successful.
- `"maxMergeHunks"`: The maximum number of merge hunks to include in the output.
- `"nextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
"""
function describe_merge_conflicts(
    destinationCommitSpecifier,
    filePath,
    mergeOption,
    repositoryName,
    sourceCommitSpecifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "DescribeMergeConflicts",
        Dict{String,Any}(
            "destinationCommitSpecifier" => destinationCommitSpecifier,
            "filePath" => filePath,
            "mergeOption" => mergeOption,
            "repositoryName" => repositoryName,
            "sourceCommitSpecifier" => sourceCommitSpecifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_merge_conflicts(
    destinationCommitSpecifier,
    filePath,
    mergeOption,
    repositoryName,
    sourceCommitSpecifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "DescribeMergeConflicts",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationCommitSpecifier" => destinationCommitSpecifier,
                    "filePath" => filePath,
                    "mergeOption" => mergeOption,
                    "repositoryName" => repositoryName,
                    "sourceCommitSpecifier" => sourceCommitSpecifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_pull_request_events(pull_request_id)
    describe_pull_request_events(pull_request_id, params::Dict{String,<:Any})

Returns information about one or more pull request events.

# Arguments
- `pull_request_id`: The system-generated ID of the pull request. To get this ID, use
  ListPullRequests.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"actorArn"`: The Amazon Resource Name (ARN) of the user whose actions resulted in the
  event. Examples include updating the pull request with more commits or changing the status
  of a pull request.
- `"maxResults"`: A non-zero, non-negative integer used to limit the number of returned
  results. The default is 100 events, which is also the maximum number of events that can be
  returned in a result.
- `"nextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
- `"pullRequestEventType"`: Optional. The pull request event type about which you want to
  return information.
"""
function describe_pull_request_events(
    pullRequestId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "DescribePullRequestEvents",
        Dict{String,Any}("pullRequestId" => pullRequestId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_pull_request_events(
    pullRequestId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "DescribePullRequestEvents",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("pullRequestId" => pullRequestId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_approval_rule_template_from_repository(approval_rule_template_name, repository_name)
    disassociate_approval_rule_template_from_repository(approval_rule_template_name, repository_name, params::Dict{String,<:Any})

Removes the association between a template and a repository so that approval rules based on
the template are not automatically created when pull requests are created in the specified
repository. This does not delete any approval rules previously created for pull requests
through the template association.

# Arguments
- `approval_rule_template_name`: The name of the approval rule template to disassociate
  from a specified repository.
- `repository_name`: The name of the repository you want to disassociate from the template.

"""
function disassociate_approval_rule_template_from_repository(
    approvalRuleTemplateName,
    repositoryName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "DisassociateApprovalRuleTemplateFromRepository",
        Dict{String,Any}(
            "approvalRuleTemplateName" => approvalRuleTemplateName,
            "repositoryName" => repositoryName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_approval_rule_template_from_repository(
    approvalRuleTemplateName,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "DisassociateApprovalRuleTemplateFromRepository",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "approvalRuleTemplateName" => approvalRuleTemplateName,
                    "repositoryName" => repositoryName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    evaluate_pull_request_approval_rules(pull_request_id, revision_id)
    evaluate_pull_request_approval_rules(pull_request_id, revision_id, params::Dict{String,<:Any})

Evaluates whether a pull request has met all the conditions specified in its associated
approval rules.

# Arguments
- `pull_request_id`: The system-generated ID of the pull request you want to evaluate.
- `revision_id`: The system-generated ID for the pull request revision. To retrieve the
  most recent revision ID for a pull request, use GetPullRequest.

"""
function evaluate_pull_request_approval_rules(
    pullRequestId, revisionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "EvaluatePullRequestApprovalRules",
        Dict{String,Any}("pullRequestId" => pullRequestId, "revisionId" => revisionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function evaluate_pull_request_approval_rules(
    pullRequestId,
    revisionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "EvaluatePullRequestApprovalRules",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "pullRequestId" => pullRequestId, "revisionId" => revisionId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_approval_rule_template(approval_rule_template_name)
    get_approval_rule_template(approval_rule_template_name, params::Dict{String,<:Any})

Returns information about a specified approval rule template.

# Arguments
- `approval_rule_template_name`: The name of the approval rule template for which you want
  to get information.

"""
function get_approval_rule_template(
    approvalRuleTemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "GetApprovalRuleTemplate",
        Dict{String,Any}("approvalRuleTemplateName" => approvalRuleTemplateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_approval_rule_template(
    approvalRuleTemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetApprovalRuleTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("approvalRuleTemplateName" => approvalRuleTemplateName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_blob(blob_id, repository_name)
    get_blob(blob_id, repository_name, params::Dict{String,<:Any})

Returns the base-64 encoded content of an individual blob in a repository.

# Arguments
- `blob_id`: The ID of the blob, which is its SHA-1 pointer.
- `repository_name`: The name of the repository that contains the blob.

"""
function get_blob(
    blobId, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "GetBlob",
        Dict{String,Any}("blobId" => blobId, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_blob(
    blobId,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetBlob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("blobId" => blobId, "repositoryName" => repositoryName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_branch()
    get_branch(params::Dict{String,<:Any})

Returns information about a repository branch, including its name and the last commit ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"branchName"`: The name of the branch for which you want to retrieve information.
- `"repositoryName"`: The name of the repository that contains the branch for which you
  want to retrieve information.
"""
function get_branch(; aws_config::AbstractAWSConfig=current_aws_config())
    return codecommit("GetBranch"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_branch(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "GetBranch", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_comment(comment_id)
    get_comment(comment_id, params::Dict{String,<:Any})

Returns the content of a comment made on a change, file, or commit in a repository.
Reaction counts might include numbers from user identities who were deleted after the
reaction was made. For a count of reactions from active identities, use
GetCommentReactions.

# Arguments
- `comment_id`: The unique, system-generated ID of the comment. To get this ID, use
  GetCommentsForComparedCommit or GetCommentsForPullRequest.

"""
function get_comment(commentId; aws_config::AbstractAWSConfig=current_aws_config())
    return codecommit(
        "GetComment",
        Dict{String,Any}("commentId" => commentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_comment(
    commentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetComment",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("commentId" => commentId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_comment_reactions(comment_id)
    get_comment_reactions(comment_id, params::Dict{String,<:Any})

Returns information about reactions to a specified comment ID. Reactions from users who
have been deleted will not be included in the count.

# Arguments
- `comment_id`: The ID of the comment for which you want to get reactions information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: A non-zero, non-negative integer used to limit the number of returned
  results. The default is the same as the allowed maximum, 1,000.
- `"nextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
- `"reactionUserArn"`: Optional. The Amazon Resource Name (ARN) of the user or identity for
  which you want to get reaction information.
"""
function get_comment_reactions(
    commentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "GetCommentReactions",
        Dict{String,Any}("commentId" => commentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_comment_reactions(
    commentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetCommentReactions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("commentId" => commentId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_comments_for_compared_commit(after_commit_id, repository_name)
    get_comments_for_compared_commit(after_commit_id, repository_name, params::Dict{String,<:Any})

Returns information about comments made on the comparison between two commits.  Reaction
counts might include numbers from user identities who were deleted after the reaction was
made. For a count of reactions from active identities, use GetCommentReactions.

# Arguments
- `after_commit_id`: To establish the directionality of the comparison, the full commit ID
  of the after commit.
- `repository_name`: The name of the repository where you want to compare commits.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"beforeCommitId"`: To establish the directionality of the comparison, the full commit ID
  of the before commit.
- `"maxResults"`: A non-zero, non-negative integer used to limit the number of returned
  results. The default is 100 comments, but you can configure up to 500.
- `"nextToken"`: An enumeration token that when provided in a request, returns the next
  batch of the results.
"""
function get_comments_for_compared_commit(
    afterCommitId, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "GetCommentsForComparedCommit",
        Dict{String,Any}(
            "afterCommitId" => afterCommitId, "repositoryName" => repositoryName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_comments_for_compared_commit(
    afterCommitId,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetCommentsForComparedCommit",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "afterCommitId" => afterCommitId, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_comments_for_pull_request(pull_request_id)
    get_comments_for_pull_request(pull_request_id, params::Dict{String,<:Any})

Returns comments made on a pull request.  Reaction counts might include numbers from user
identities who were deleted after the reaction was made. For a count of reactions from
active identities, use GetCommentReactions.

# Arguments
- `pull_request_id`: The system-generated ID of the pull request. To get this ID, use
  ListPullRequests.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"afterCommitId"`: The full commit ID of the commit in the source branch that was the tip
  of the branch at the time the comment was made. Requirement is conditional: afterCommitId
  must be specified when repositoryName is included.
- `"beforeCommitId"`: The full commit ID of the commit in the destination branch that was
  the tip of the branch at the time the pull request was created. Requirement is conditional:
  beforeCommitId must be specified when repositoryName is included.
- `"maxResults"`: A non-zero, non-negative integer used to limit the number of returned
  results. The default is 100 comments. You can return up to 500 comments with a single
  request.
- `"nextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
- `"repositoryName"`: The name of the repository that contains the pull request.
  Requirement is conditional: repositoryName must be specified when beforeCommitId and
  afterCommitId are included.
"""
function get_comments_for_pull_request(
    pullRequestId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "GetCommentsForPullRequest",
        Dict{String,Any}("pullRequestId" => pullRequestId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_comments_for_pull_request(
    pullRequestId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetCommentsForPullRequest",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("pullRequestId" => pullRequestId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_commit(commit_id, repository_name)
    get_commit(commit_id, repository_name, params::Dict{String,<:Any})

Returns information about a commit, including commit message and committer information.

# Arguments
- `commit_id`: The commit ID. Commit IDs are the full SHA ID of the commit.
- `repository_name`: The name of the repository to which the commit was made.

"""
function get_commit(
    commitId, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "GetCommit",
        Dict{String,Any}("commitId" => commitId, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_commit(
    commitId,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetCommit",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "commitId" => commitId, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_differences(after_commit_specifier, repository_name)
    get_differences(after_commit_specifier, repository_name, params::Dict{String,<:Any})

Returns information about the differences in a valid commit specifier (such as a branch,
tag, HEAD, commit ID, or other fully qualified reference). Results can be limited to a
specified path.

# Arguments
- `after_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference used
  to identify a commit.
- `repository_name`: The name of the repository where you want to get differences.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: A non-zero, non-negative integer used to limit the number of returned
  results.
- `"NextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
- `"afterPath"`: The file path in which to check differences. Limits the results to this
  path. Can also be used to specify the changed name of a directory or folder, if it has
  changed. If not specified, differences are shown for all paths.
- `"beforeCommitSpecifier"`: The branch, tag, HEAD, or other fully qualified reference used
  to identify a commit (for example, the full commit ID). Optional. If not specified, all
  changes before the afterCommitSpecifier value are shown. If you do not use
  beforeCommitSpecifier in your request, consider limiting the results with maxResults.
- `"beforePath"`: The file path in which to check for differences. Limits the results to
  this path. Can also be used to specify the previous name of a directory or folder. If
  beforePath and afterPath are not specified, differences are shown for all paths.
"""
function get_differences(
    afterCommitSpecifier, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "GetDifferences",
        Dict{String,Any}(
            "afterCommitSpecifier" => afterCommitSpecifier,
            "repositoryName" => repositoryName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_differences(
    afterCommitSpecifier,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetDifferences",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "afterCommitSpecifier" => afterCommitSpecifier,
                    "repositoryName" => repositoryName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_file(file_path, repository_name)
    get_file(file_path, repository_name, params::Dict{String,<:Any})

Returns the base-64 encoded contents of a specified file and its metadata.

# Arguments
- `file_path`: The fully qualified path to the file, including the full name and extension
  of the file. For example, /examples/file.md is the fully qualified path to a file named
  file.md in a folder named examples.
- `repository_name`: The name of the repository that contains the file.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"commitSpecifier"`: The fully quaified reference that identifies the commit that
  contains the file. For example, you can specify a full commit ID, a tag, a branch name, or
  a reference such as refs/heads/main. If none is provided, the head commit is used.
"""
function get_file(
    filePath, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "GetFile",
        Dict{String,Any}("filePath" => filePath, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_file(
    filePath,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetFile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "filePath" => filePath, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_folder(folder_path, repository_name)
    get_folder(folder_path, repository_name, params::Dict{String,<:Any})

Returns the contents of a specified folder in a repository.

# Arguments
- `folder_path`: The fully qualified path to the folder whose contents are returned,
  including the folder name. For example, /examples is a fully-qualified path to a folder
  named examples that was created off of the root directory (/) of a repository.
- `repository_name`: The name of the repository.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"commitSpecifier"`: A fully qualified reference used to identify a commit that contains
  the version of the folder's content to return. A fully qualified reference can be a commit
  ID, branch name, tag, or reference such as HEAD. If no specifier is provided, the folder
  content is returned as it exists in the HEAD commit.
"""
function get_folder(
    folderPath, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "GetFolder",
        Dict{String,Any}("folderPath" => folderPath, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_folder(
    folderPath,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetFolder",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "folderPath" => folderPath, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_merge_commit(destination_commit_specifier, repository_name, source_commit_specifier)
    get_merge_commit(destination_commit_specifier, repository_name, source_commit_specifier, params::Dict{String,<:Any})

Returns information about a specified merge commit.

# Arguments
- `destination_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference
  used to identify a commit (for example, a branch name or a full commit ID).
- `repository_name`: The name of the repository that contains the merge commit about which
  you want to get information.
- `source_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference used
  to identify a commit (for example, a branch name or a full commit ID).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"conflictDetailLevel"`: The level of conflict detail to use. If unspecified, the default
  FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences
  in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the
  same file in both branches has differences on the same line.
- `"conflictResolutionStrategy"`: Specifies which branch to use when resolving conflicts,
  or whether to attempt automatically merging two versions of a file. The default is NONE,
  which requires any conflicts to be resolved manually before the merge operation is
  successful.
"""
function get_merge_commit(
    destinationCommitSpecifier,
    repositoryName,
    sourceCommitSpecifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetMergeCommit",
        Dict{String,Any}(
            "destinationCommitSpecifier" => destinationCommitSpecifier,
            "repositoryName" => repositoryName,
            "sourceCommitSpecifier" => sourceCommitSpecifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_merge_commit(
    destinationCommitSpecifier,
    repositoryName,
    sourceCommitSpecifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetMergeCommit",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationCommitSpecifier" => destinationCommitSpecifier,
                    "repositoryName" => repositoryName,
                    "sourceCommitSpecifier" => sourceCommitSpecifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_merge_conflicts(destination_commit_specifier, merge_option, repository_name, source_commit_specifier)
    get_merge_conflicts(destination_commit_specifier, merge_option, repository_name, source_commit_specifier, params::Dict{String,<:Any})

Returns information about merge conflicts between the before and after commit IDs for a
pull request in a repository.

# Arguments
- `destination_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference
  used to identify a commit (for example, a branch name or a full commit ID).
- `merge_option`: The merge option or strategy you want to use to merge the code.
- `repository_name`: The name of the repository where the pull request was created.
- `source_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference used
  to identify a commit (for example, a branch name or a full commit ID).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"conflictDetailLevel"`: The level of conflict detail to use. If unspecified, the default
  FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences
  in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the
  same file in both branches has differences on the same line.
- `"conflictResolutionStrategy"`: Specifies which branch to use when resolving conflicts,
  or whether to attempt automatically merging two versions of a file. The default is NONE,
  which requires any conflicts to be resolved manually before the merge operation is
  successful.
- `"maxConflictFiles"`: The maximum number of files to include in the output.
- `"nextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
"""
function get_merge_conflicts(
    destinationCommitSpecifier,
    mergeOption,
    repositoryName,
    sourceCommitSpecifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetMergeConflicts",
        Dict{String,Any}(
            "destinationCommitSpecifier" => destinationCommitSpecifier,
            "mergeOption" => mergeOption,
            "repositoryName" => repositoryName,
            "sourceCommitSpecifier" => sourceCommitSpecifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_merge_conflicts(
    destinationCommitSpecifier,
    mergeOption,
    repositoryName,
    sourceCommitSpecifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetMergeConflicts",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationCommitSpecifier" => destinationCommitSpecifier,
                    "mergeOption" => mergeOption,
                    "repositoryName" => repositoryName,
                    "sourceCommitSpecifier" => sourceCommitSpecifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_merge_options(destination_commit_specifier, repository_name, source_commit_specifier)
    get_merge_options(destination_commit_specifier, repository_name, source_commit_specifier, params::Dict{String,<:Any})

Returns information about the merge options available for merging two specified branches.
For details about why a merge option is not available, use GetMergeConflicts or
DescribeMergeConflicts.

# Arguments
- `destination_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference
  used to identify a commit (for example, a branch name or a full commit ID).
- `repository_name`: The name of the repository that contains the commits about which you
  want to get merge options.
- `source_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference used
  to identify a commit (for example, a branch name or a full commit ID).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"conflictDetailLevel"`: The level of conflict detail to use. If unspecified, the default
  FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences
  in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the
  same file in both branches has differences on the same line.
- `"conflictResolutionStrategy"`: Specifies which branch to use when resolving conflicts,
  or whether to attempt automatically merging two versions of a file. The default is NONE,
  which requires any conflicts to be resolved manually before the merge operation is
  successful.
"""
function get_merge_options(
    destinationCommitSpecifier,
    repositoryName,
    sourceCommitSpecifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetMergeOptions",
        Dict{String,Any}(
            "destinationCommitSpecifier" => destinationCommitSpecifier,
            "repositoryName" => repositoryName,
            "sourceCommitSpecifier" => sourceCommitSpecifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_merge_options(
    destinationCommitSpecifier,
    repositoryName,
    sourceCommitSpecifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetMergeOptions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationCommitSpecifier" => destinationCommitSpecifier,
                    "repositoryName" => repositoryName,
                    "sourceCommitSpecifier" => sourceCommitSpecifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_pull_request(pull_request_id)
    get_pull_request(pull_request_id, params::Dict{String,<:Any})

Gets information about a pull request in a specified repository.

# Arguments
- `pull_request_id`: The system-generated ID of the pull request. To get this ID, use
  ListPullRequests.

"""
function get_pull_request(pullRequestId; aws_config::AbstractAWSConfig=current_aws_config())
    return codecommit(
        "GetPullRequest",
        Dict{String,Any}("pullRequestId" => pullRequestId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_pull_request(
    pullRequestId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetPullRequest",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("pullRequestId" => pullRequestId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_pull_request_approval_states(pull_request_id, revision_id)
    get_pull_request_approval_states(pull_request_id, revision_id, params::Dict{String,<:Any})

Gets information about the approval states for a specified pull request. Approval states
only apply to pull requests that have one or more approval rules applied to them.

# Arguments
- `pull_request_id`: The system-generated ID for the pull request.
- `revision_id`: The system-generated ID for the pull request revision.

"""
function get_pull_request_approval_states(
    pullRequestId, revisionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "GetPullRequestApprovalStates",
        Dict{String,Any}("pullRequestId" => pullRequestId, "revisionId" => revisionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_pull_request_approval_states(
    pullRequestId,
    revisionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetPullRequestApprovalStates",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "pullRequestId" => pullRequestId, "revisionId" => revisionId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_pull_request_override_state(pull_request_id, revision_id)
    get_pull_request_override_state(pull_request_id, revision_id, params::Dict{String,<:Any})

Returns information about whether approval rules have been set aside (overridden) for a
pull request, and if so, the Amazon Resource Name (ARN) of the user or identity that
overrode the rules and their requirements for the pull request.

# Arguments
- `pull_request_id`: The ID of the pull request for which you want to get information about
  whether approval rules have been set aside (overridden).
- `revision_id`: The system-generated ID of the revision for the pull request. To retrieve
  the most recent revision ID, use GetPullRequest.

"""
function get_pull_request_override_state(
    pullRequestId, revisionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "GetPullRequestOverrideState",
        Dict{String,Any}("pullRequestId" => pullRequestId, "revisionId" => revisionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_pull_request_override_state(
    pullRequestId,
    revisionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetPullRequestOverrideState",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "pullRequestId" => pullRequestId, "revisionId" => revisionId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_repository(repository_name)
    get_repository(repository_name, params::Dict{String,<:Any})

Returns information about a repository.  The description field for a repository accepts all
HTML characters and all valid Unicode characters. Applications that do not HTML-encode the
description and display it in a webpage can expose users to potentially malicious code.
Make sure that you HTML-encode the description field in any application that uses this API
to display the repository description on a webpage.

# Arguments
- `repository_name`: The name of the repository to get information about.

"""
function get_repository(repositoryName; aws_config::AbstractAWSConfig=current_aws_config())
    return codecommit(
        "GetRepository",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_repository(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetRepository",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_repository_triggers(repository_name)
    get_repository_triggers(repository_name, params::Dict{String,<:Any})

Gets information about triggers configured for a repository.

# Arguments
- `repository_name`: The name of the repository for which the trigger is configured.

"""
function get_repository_triggers(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "GetRepositoryTriggers",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_repository_triggers(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "GetRepositoryTriggers",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_approval_rule_templates()
    list_approval_rule_templates(params::Dict{String,<:Any})

Lists all approval rule templates in the specified Amazon Web Services Region in your
Amazon Web Services account. If an Amazon Web Services Region is not specified, the Amazon
Web Services Region where you are signed in is used.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: A non-zero, non-negative integer used to limit the number of returned
  results.
- `"nextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
"""
function list_approval_rule_templates(; aws_config::AbstractAWSConfig=current_aws_config())
    return codecommit(
        "ListApprovalRuleTemplates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_approval_rule_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "ListApprovalRuleTemplates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_associated_approval_rule_templates_for_repository(repository_name)
    list_associated_approval_rule_templates_for_repository(repository_name, params::Dict{String,<:Any})

Lists all approval rule templates that are associated with a specified repository.

# Arguments
- `repository_name`: The name of the repository for which you want to list all associated
  approval rule templates.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: A non-zero, non-negative integer used to limit the number of returned
  results.
- `"nextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
"""
function list_associated_approval_rule_templates_for_repository(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "ListAssociatedApprovalRuleTemplatesForRepository",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_associated_approval_rule_templates_for_repository(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "ListAssociatedApprovalRuleTemplatesForRepository",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_branches(repository_name)
    list_branches(repository_name, params::Dict{String,<:Any})

Gets information about one or more branches in a repository.

# Arguments
- `repository_name`: The name of the repository that contains the branches.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An enumeration token that allows the operation to batch the results.
"""
function list_branches(repositoryName; aws_config::AbstractAWSConfig=current_aws_config())
    return codecommit(
        "ListBranches",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_branches(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "ListBranches",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_file_commit_history(file_path, repository_name)
    list_file_commit_history(file_path, repository_name, params::Dict{String,<:Any})

Retrieves a list of commits and changes to a specified file.

# Arguments
- `file_path`: The full path of the file whose history you want to retrieve, including the
  name of the file.
- `repository_name`: The name of the repository that contains the file.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"commitSpecifier"`: The fully quaified reference that identifies the commit that
  contains the file. For example, you can specify a full commit ID, a tag, a branch name, or
  a reference such as refs/heads/main. If none is provided, the head commit is used.
- `"maxResults"`: A non-zero, non-negative integer used to limit the number of returned
  results.
- `"nextToken"`: An enumeration token that allows the operation to batch the results.
"""
function list_file_commit_history(
    filePath, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "ListFileCommitHistory",
        Dict{String,Any}("filePath" => filePath, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_file_commit_history(
    filePath,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "ListFileCommitHistory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "filePath" => filePath, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_pull_requests(repository_name)
    list_pull_requests(repository_name, params::Dict{String,<:Any})

Returns a list of pull requests for a specified repository. The return list can be refined
by pull request status or pull request author ARN.

# Arguments
- `repository_name`: The name of the repository for which you want to list pull requests.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authorArn"`: Optional. The Amazon Resource Name (ARN) of the user who created the pull
  request. If used, this filters the results to pull requests created by that user.
- `"maxResults"`: A non-zero, non-negative integer used to limit the number of returned
  results.
- `"nextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
- `"pullRequestStatus"`: Optional. The status of the pull request. If used, this refines
  the results to the pull requests that match the specified status.
"""
function list_pull_requests(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "ListPullRequests",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_pull_requests(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "ListPullRequests",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_repositories()
    list_repositories(params::Dict{String,<:Any})

Gets information about one or more repositories.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An enumeration token that allows the operation to batch the results of the
  operation. Batch sizes are 1,000 for list repository operations. When the client sends the
  token back to CodeCommit, another page of 1,000 records is retrieved.
- `"order"`: The order in which to sort the results of a list repositories operation.
- `"sortBy"`: The criteria used to sort the results of a list repositories operation.
"""
function list_repositories(; aws_config::AbstractAWSConfig=current_aws_config())
    return codecommit(
        "ListRepositories"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_repositories(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "ListRepositories", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_repositories_for_approval_rule_template(approval_rule_template_name)
    list_repositories_for_approval_rule_template(approval_rule_template_name, params::Dict{String,<:Any})

Lists all repositories associated with the specified approval rule template.

# Arguments
- `approval_rule_template_name`: The name of the approval rule template for which you want
  to list repositories that are associated with that template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: A non-zero, non-negative integer used to limit the number of returned
  results.
- `"nextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
"""
function list_repositories_for_approval_rule_template(
    approvalRuleTemplateName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "ListRepositoriesForApprovalRuleTemplate",
        Dict{String,Any}("approvalRuleTemplateName" => approvalRuleTemplateName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_repositories_for_approval_rule_template(
    approvalRuleTemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "ListRepositoriesForApprovalRuleTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("approvalRuleTemplateName" => approvalRuleTemplateName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Gets information about Amazon Web Servicestags for a specified Amazon Resource Name (ARN)
in CodeCommit. For a list of valid resources in CodeCommit, see CodeCommit Resources and
Operations in the CodeCommit User Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource for which you want to get
  information about tags, if any.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "ListTagsForResource",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    merge_branches_by_fast_forward(destination_commit_specifier, repository_name, source_commit_specifier)
    merge_branches_by_fast_forward(destination_commit_specifier, repository_name, source_commit_specifier, params::Dict{String,<:Any})

Merges two branches using the fast-forward merge strategy.

# Arguments
- `destination_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference
  used to identify a commit (for example, a branch name or a full commit ID).
- `repository_name`: The name of the repository where you want to merge two branches.
- `source_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference used
  to identify a commit (for example, a branch name or a full commit ID).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"targetBranch"`: The branch where the merge is applied.
"""
function merge_branches_by_fast_forward(
    destinationCommitSpecifier,
    repositoryName,
    sourceCommitSpecifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "MergeBranchesByFastForward",
        Dict{String,Any}(
            "destinationCommitSpecifier" => destinationCommitSpecifier,
            "repositoryName" => repositoryName,
            "sourceCommitSpecifier" => sourceCommitSpecifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function merge_branches_by_fast_forward(
    destinationCommitSpecifier,
    repositoryName,
    sourceCommitSpecifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "MergeBranchesByFastForward",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationCommitSpecifier" => destinationCommitSpecifier,
                    "repositoryName" => repositoryName,
                    "sourceCommitSpecifier" => sourceCommitSpecifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    merge_branches_by_squash(destination_commit_specifier, repository_name, source_commit_specifier)
    merge_branches_by_squash(destination_commit_specifier, repository_name, source_commit_specifier, params::Dict{String,<:Any})

Merges two branches using the squash merge strategy.

# Arguments
- `destination_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference
  used to identify a commit (for example, a branch name or a full commit ID).
- `repository_name`: The name of the repository where you want to merge two branches.
- `source_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference used
  to identify a commit (for example, a branch name or a full commit ID).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authorName"`: The name of the author who created the commit. This information is used
  as both the author and committer for the commit.
- `"commitMessage"`: The commit message for the merge.
- `"conflictDetailLevel"`: The level of conflict detail to use. If unspecified, the default
  FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences
  in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the
  same file in both branches has differences on the same line.
- `"conflictResolution"`: If AUTOMERGE is the conflict resolution strategy, a list of
  inputs to use when resolving conflicts during a merge.
- `"conflictResolutionStrategy"`: Specifies which branch to use when resolving conflicts,
  or whether to attempt automatically merging two versions of a file. The default is NONE,
  which requires any conflicts to be resolved manually before the merge operation is
  successful.
- `"email"`: The email address of the person merging the branches. This information is used
  in the commit information for the merge.
- `"keepEmptyFolders"`: If the commit contains deletions, whether to keep a folder or
  folder structure if the changes leave the folders empty. If this is specified as true, a
  .gitkeep file is created for empty folders. The default is false.
- `"targetBranch"`: The branch where the merge is applied.
"""
function merge_branches_by_squash(
    destinationCommitSpecifier,
    repositoryName,
    sourceCommitSpecifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "MergeBranchesBySquash",
        Dict{String,Any}(
            "destinationCommitSpecifier" => destinationCommitSpecifier,
            "repositoryName" => repositoryName,
            "sourceCommitSpecifier" => sourceCommitSpecifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function merge_branches_by_squash(
    destinationCommitSpecifier,
    repositoryName,
    sourceCommitSpecifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "MergeBranchesBySquash",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationCommitSpecifier" => destinationCommitSpecifier,
                    "repositoryName" => repositoryName,
                    "sourceCommitSpecifier" => sourceCommitSpecifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    merge_branches_by_three_way(destination_commit_specifier, repository_name, source_commit_specifier)
    merge_branches_by_three_way(destination_commit_specifier, repository_name, source_commit_specifier, params::Dict{String,<:Any})

Merges two specified branches using the three-way merge strategy.

# Arguments
- `destination_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference
  used to identify a commit (for example, a branch name or a full commit ID).
- `repository_name`: The name of the repository where you want to merge two branches.
- `source_commit_specifier`: The branch, tag, HEAD, or other fully qualified reference used
  to identify a commit (for example, a branch name or a full commit ID).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authorName"`: The name of the author who created the commit. This information is used
  as both the author and committer for the commit.
- `"commitMessage"`: The commit message to include in the commit information for the merge.
- `"conflictDetailLevel"`: The level of conflict detail to use. If unspecified, the default
  FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences
  in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the
  same file in both branches has differences on the same line.
- `"conflictResolution"`: If AUTOMERGE is the conflict resolution strategy, a list of
  inputs to use when resolving conflicts during a merge.
- `"conflictResolutionStrategy"`: Specifies which branch to use when resolving conflicts,
  or whether to attempt automatically merging two versions of a file. The default is NONE,
  which requires any conflicts to be resolved manually before the merge operation is
  successful.
- `"email"`: The email address of the person merging the branches. This information is used
  in the commit information for the merge.
- `"keepEmptyFolders"`: If the commit contains deletions, whether to keep a folder or
  folder structure if the changes leave the folders empty. If true, a .gitkeep file is
  created for empty folders. The default is false.
- `"targetBranch"`: The branch where the merge is applied.
"""
function merge_branches_by_three_way(
    destinationCommitSpecifier,
    repositoryName,
    sourceCommitSpecifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "MergeBranchesByThreeWay",
        Dict{String,Any}(
            "destinationCommitSpecifier" => destinationCommitSpecifier,
            "repositoryName" => repositoryName,
            "sourceCommitSpecifier" => sourceCommitSpecifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function merge_branches_by_three_way(
    destinationCommitSpecifier,
    repositoryName,
    sourceCommitSpecifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "MergeBranchesByThreeWay",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "destinationCommitSpecifier" => destinationCommitSpecifier,
                    "repositoryName" => repositoryName,
                    "sourceCommitSpecifier" => sourceCommitSpecifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    merge_pull_request_by_fast_forward(pull_request_id, repository_name)
    merge_pull_request_by_fast_forward(pull_request_id, repository_name, params::Dict{String,<:Any})

Attempts to merge the source commit of a pull request into the specified destination branch
for that pull request at the specified commit using the fast-forward merge strategy. If the
merge is successful, it closes the pull request.

# Arguments
- `pull_request_id`: The system-generated ID of the pull request. To get this ID, use
  ListPullRequests.
- `repository_name`: The name of the repository where the pull request was created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"sourceCommitId"`: The full commit ID of the original or updated commit in the pull
  request source branch. Pass this value if you want an exception thrown if the current
  commit ID of the tip of the source branch does not match this commit ID.
"""
function merge_pull_request_by_fast_forward(
    pullRequestId, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "MergePullRequestByFastForward",
        Dict{String,Any}(
            "pullRequestId" => pullRequestId, "repositoryName" => repositoryName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function merge_pull_request_by_fast_forward(
    pullRequestId,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "MergePullRequestByFastForward",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "pullRequestId" => pullRequestId, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    merge_pull_request_by_squash(pull_request_id, repository_name)
    merge_pull_request_by_squash(pull_request_id, repository_name, params::Dict{String,<:Any})

Attempts to merge the source commit of a pull request into the specified destination branch
for that pull request at the specified commit using the squash merge strategy. If the merge
is successful, it closes the pull request.

# Arguments
- `pull_request_id`: The system-generated ID of the pull request. To get this ID, use
  ListPullRequests.
- `repository_name`: The name of the repository where the pull request was created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authorName"`: The name of the author who created the commit. This information is used
  as both the author and committer for the commit.
- `"commitMessage"`: The commit message to include in the commit information for the merge.
- `"conflictDetailLevel"`: The level of conflict detail to use. If unspecified, the default
  FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences
  in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the
  same file in both branches has differences on the same line.
- `"conflictResolution"`: If AUTOMERGE is the conflict resolution strategy, a list of
  inputs to use when resolving conflicts during a merge.
- `"conflictResolutionStrategy"`: Specifies which branch to use when resolving conflicts,
  or whether to attempt automatically merging two versions of a file. The default is NONE,
  which requires any conflicts to be resolved manually before the merge operation is
  successful.
- `"email"`: The email address of the person merging the branches. This information is used
  in the commit information for the merge.
- `"keepEmptyFolders"`: If the commit contains deletions, whether to keep a folder or
  folder structure if the changes leave the folders empty. If true, a .gitkeep file is
  created for empty folders. The default is false.
- `"sourceCommitId"`: The full commit ID of the original or updated commit in the pull
  request source branch. Pass this value if you want an exception thrown if the current
  commit ID of the tip of the source branch does not match this commit ID.
"""
function merge_pull_request_by_squash(
    pullRequestId, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "MergePullRequestBySquash",
        Dict{String,Any}(
            "pullRequestId" => pullRequestId, "repositoryName" => repositoryName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function merge_pull_request_by_squash(
    pullRequestId,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "MergePullRequestBySquash",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "pullRequestId" => pullRequestId, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    merge_pull_request_by_three_way(pull_request_id, repository_name)
    merge_pull_request_by_three_way(pull_request_id, repository_name, params::Dict{String,<:Any})

Attempts to merge the source commit of a pull request into the specified destination branch
for that pull request at the specified commit using the three-way merge strategy. If the
merge is successful, it closes the pull request.

# Arguments
- `pull_request_id`: The system-generated ID of the pull request. To get this ID, use
  ListPullRequests.
- `repository_name`: The name of the repository where the pull request was created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"authorName"`: The name of the author who created the commit. This information is used
  as both the author and committer for the commit.
- `"commitMessage"`: The commit message to include in the commit information for the merge.
- `"conflictDetailLevel"`: The level of conflict detail to use. If unspecified, the default
  FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences
  in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the
  same file in both branches has differences on the same line.
- `"conflictResolution"`: If AUTOMERGE is the conflict resolution strategy, a list of
  inputs to use when resolving conflicts during a merge.
- `"conflictResolutionStrategy"`: Specifies which branch to use when resolving conflicts,
  or whether to attempt automatically merging two versions of a file. The default is NONE,
  which requires any conflicts to be resolved manually before the merge operation is
  successful.
- `"email"`: The email address of the person merging the branches. This information is used
  in the commit information for the merge.
- `"keepEmptyFolders"`: If the commit contains deletions, whether to keep a folder or
  folder structure if the changes leave the folders empty. If true, a .gitkeep file is
  created for empty folders. The default is false.
- `"sourceCommitId"`: The full commit ID of the original or updated commit in the pull
  request source branch. Pass this value if you want an exception thrown if the current
  commit ID of the tip of the source branch does not match this commit ID.
"""
function merge_pull_request_by_three_way(
    pullRequestId, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "MergePullRequestByThreeWay",
        Dict{String,Any}(
            "pullRequestId" => pullRequestId, "repositoryName" => repositoryName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function merge_pull_request_by_three_way(
    pullRequestId,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "MergePullRequestByThreeWay",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "pullRequestId" => pullRequestId, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    override_pull_request_approval_rules(override_status, pull_request_id, revision_id)
    override_pull_request_approval_rules(override_status, pull_request_id, revision_id, params::Dict{String,<:Any})

Sets aside (overrides) all approval rule requirements for a specified pull request.

# Arguments
- `override_status`: Whether you want to set aside approval rule requirements for the pull
  request (OVERRIDE) or revoke a previous override and apply approval rule requirements
  (REVOKE). REVOKE status is not stored.
- `pull_request_id`: The system-generated ID of the pull request for which you want to
  override all approval rule requirements. To get this information, use GetPullRequest.
- `revision_id`: The system-generated ID of the most recent revision of the pull request.
  You cannot override approval rules for anything but the most recent revision of a pull
  request. To get the revision ID, use GetPullRequest.

"""
function override_pull_request_approval_rules(
    overrideStatus,
    pullRequestId,
    revisionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "OverridePullRequestApprovalRules",
        Dict{String,Any}(
            "overrideStatus" => overrideStatus,
            "pullRequestId" => pullRequestId,
            "revisionId" => revisionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function override_pull_request_approval_rules(
    overrideStatus,
    pullRequestId,
    revisionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "OverridePullRequestApprovalRules",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "overrideStatus" => overrideStatus,
                    "pullRequestId" => pullRequestId,
                    "revisionId" => revisionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    post_comment_for_compared_commit(after_commit_id, content, repository_name)
    post_comment_for_compared_commit(after_commit_id, content, repository_name, params::Dict{String,<:Any})

Posts a comment on the comparison between two commits.

# Arguments
- `after_commit_id`: To establish the directionality of the comparison, the full commit ID
  of the after commit.
- `content`: The content of the comment you want to make.
- `repository_name`: The name of the repository where you want to post a comment on the
  comparison between commits.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"beforeCommitId"`: To establish the directionality of the comparison, the full commit ID
  of the before commit. Required for commenting on any commit unless that commit is the
  initial commit.
- `"clientRequestToken"`: A unique, client-generated idempotency token that, when provided
  in a request, ensures the request cannot be repeated with a changed parameter. If a request
  is received with the same parameters and a token is included, the request returns
  information about the initial request that used that token.
- `"location"`: The location of the comparison where you want to comment.
"""
function post_comment_for_compared_commit(
    afterCommitId,
    content,
    repositoryName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "PostCommentForComparedCommit",
        Dict{String,Any}(
            "afterCommitId" => afterCommitId,
            "content" => content,
            "repositoryName" => repositoryName,
            "clientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function post_comment_for_compared_commit(
    afterCommitId,
    content,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "PostCommentForComparedCommit",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "afterCommitId" => afterCommitId,
                    "content" => content,
                    "repositoryName" => repositoryName,
                    "clientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    post_comment_for_pull_request(after_commit_id, before_commit_id, content, pull_request_id, repository_name)
    post_comment_for_pull_request(after_commit_id, before_commit_id, content, pull_request_id, repository_name, params::Dict{String,<:Any})

Posts a comment on a pull request.

# Arguments
- `after_commit_id`: The full commit ID of the commit in the source branch that is the
  current tip of the branch for the pull request when you post the comment.
- `before_commit_id`: The full commit ID of the commit in the destination branch that was
  the tip of the branch at the time the pull request was created.
- `content`: The content of your comment on the change.
- `pull_request_id`: The system-generated ID of the pull request. To get this ID, use
  ListPullRequests.
- `repository_name`: The name of the repository where you want to post a comment on a pull
  request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientRequestToken"`: A unique, client-generated idempotency token that, when provided
  in a request, ensures the request cannot be repeated with a changed parameter. If a request
  is received with the same parameters and a token is included, the request returns
  information about the initial request that used that token.
- `"location"`: The location of the change where you want to post your comment. If no
  location is provided, the comment is posted as a general comment on the pull request
  difference between the before commit ID and the after commit ID.
"""
function post_comment_for_pull_request(
    afterCommitId,
    beforeCommitId,
    content,
    pullRequestId,
    repositoryName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "PostCommentForPullRequest",
        Dict{String,Any}(
            "afterCommitId" => afterCommitId,
            "beforeCommitId" => beforeCommitId,
            "content" => content,
            "pullRequestId" => pullRequestId,
            "repositoryName" => repositoryName,
            "clientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function post_comment_for_pull_request(
    afterCommitId,
    beforeCommitId,
    content,
    pullRequestId,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "PostCommentForPullRequest",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "afterCommitId" => afterCommitId,
                    "beforeCommitId" => beforeCommitId,
                    "content" => content,
                    "pullRequestId" => pullRequestId,
                    "repositoryName" => repositoryName,
                    "clientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    post_comment_reply(content, in_reply_to)
    post_comment_reply(content, in_reply_to, params::Dict{String,<:Any})

Posts a comment in reply to an existing comment on a comparison between commits or a pull
request.

# Arguments
- `content`: The contents of your reply to a comment.
- `in_reply_to`: The system-generated ID of the comment to which you want to reply. To get
  this ID, use GetCommentsForComparedCommit or GetCommentsForPullRequest.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientRequestToken"`: A unique, client-generated idempotency token that, when provided
  in a request, ensures the request cannot be repeated with a changed parameter. If a request
  is received with the same parameters and a token is included, the request returns
  information about the initial request that used that token.
"""
function post_comment_reply(
    content, inReplyTo; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "PostCommentReply",
        Dict{String,Any}(
            "content" => content,
            "inReplyTo" => inReplyTo,
            "clientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function post_comment_reply(
    content,
    inReplyTo,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "PostCommentReply",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "content" => content,
                    "inReplyTo" => inReplyTo,
                    "clientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_comment_reaction(comment_id, reaction_value)
    put_comment_reaction(comment_id, reaction_value, params::Dict{String,<:Any})

Adds or updates a reaction to a specified comment for the user whose identity is used to
make the request. You can only add or update a reaction for yourself. You cannot add,
modify, or delete a reaction for another user.

# Arguments
- `comment_id`: The ID of the comment to which you want to add or update a reaction.
- `reaction_value`: The emoji reaction you want to add or update. To remove a reaction,
  provide a value of blank or null. You can also provide the value of none. For information
  about emoji reaction values supported in CodeCommit, see the CodeCommit User Guide.

"""
function put_comment_reaction(
    commentId, reactionValue; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "PutCommentReaction",
        Dict{String,Any}("commentId" => commentId, "reactionValue" => reactionValue);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_comment_reaction(
    commentId,
    reactionValue,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "PutCommentReaction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "commentId" => commentId, "reactionValue" => reactionValue
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_file(branch_name, file_content, file_path, repository_name)
    put_file(branch_name, file_content, file_path, repository_name, params::Dict{String,<:Any})

Adds or updates a file in a branch in an CodeCommit repository, and generates a commit for
the addition in the specified branch.

# Arguments
- `branch_name`: The name of the branch where you want to add or update the file. If this
  is an empty repository, this branch is created.
- `file_content`: The content of the file, in binary object format.
- `file_path`: The name of the file you want to add or update, including the relative path
  to the file in the repository.  If the path does not currently exist in the repository, the
  path is created as part of adding the file.
- `repository_name`: The name of the repository where you want to add or update the file.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"commitMessage"`: A message about why this file was added or updated. Although it is
  optional, a message makes the commit history for your repository more useful.
- `"email"`: An email address for the person adding or updating the file.
- `"fileMode"`: The file mode permissions of the blob. Valid file mode permissions are
  listed here.
- `"name"`: The name of the person adding or updating the file. Although it is optional, a
  name makes the commit history for your repository more useful.
- `"parentCommitId"`: The full commit ID of the head commit in the branch where you want to
  add or update the file. If this is an empty repository, no commit ID is required. If this
  is not an empty repository, a commit ID is required.  The commit ID must match the ID of
  the head commit at the time of the operation. Otherwise, an error occurs, and the file is
  not added or updated.
"""
function put_file(
    branchName,
    fileContent,
    filePath,
    repositoryName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "PutFile",
        Dict{String,Any}(
            "branchName" => branchName,
            "fileContent" => fileContent,
            "filePath" => filePath,
            "repositoryName" => repositoryName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_file(
    branchName,
    fileContent,
    filePath,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "PutFile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "branchName" => branchName,
                    "fileContent" => fileContent,
                    "filePath" => filePath,
                    "repositoryName" => repositoryName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_repository_triggers(repository_name, triggers)
    put_repository_triggers(repository_name, triggers, params::Dict{String,<:Any})

Replaces all triggers for a repository. Used to create or delete triggers.

# Arguments
- `repository_name`: The name of the repository where you want to create or update the
  trigger.
- `triggers`: The JSON block of configuration information for each trigger.

"""
function put_repository_triggers(
    repositoryName, triggers; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "PutRepositoryTriggers",
        Dict{String,Any}("repositoryName" => repositoryName, "triggers" => triggers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_repository_triggers(
    repositoryName,
    triggers,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "PutRepositoryTriggers",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "repositoryName" => repositoryName, "triggers" => triggers
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds or updates tags for a resource in CodeCommit. For a list of valid resources in
CodeCommit, see CodeCommit Resources and Operations in the CodeCommit User Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to which you want to add
  or update tags.
- `tags`: The key-value pair to use when tagging this repository.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return codecommit(
        "TagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    test_repository_triggers(repository_name, triggers)
    test_repository_triggers(repository_name, triggers, params::Dict{String,<:Any})

Tests the functionality of repository triggers by sending information to the trigger
target. If real data is available in the repository, the test sends data from the last
commit. If no data is available, sample data is generated.

# Arguments
- `repository_name`: The name of the repository in which to test the triggers.
- `triggers`: The list of triggers to test.

"""
function test_repository_triggers(
    repositoryName, triggers; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "TestRepositoryTriggers",
        Dict{String,Any}("repositoryName" => repositoryName, "triggers" => triggers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function test_repository_triggers(
    repositoryName,
    triggers,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "TestRepositoryTriggers",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "repositoryName" => repositoryName, "triggers" => triggers
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags for a resource in CodeCommit. For a list of valid resources in CodeCommit, see
CodeCommit Resources and Operations in the CodeCommit User Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to which you want to
  remove tags.
- `tag_keys`: The tag key for each tag that you want to remove from the resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "UntagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_approval_rule_template_content(approval_rule_template_name, new_rule_content)
    update_approval_rule_template_content(approval_rule_template_name, new_rule_content, params::Dict{String,<:Any})

Updates the content of an approval rule template. You can change the number of required
approvals, the membership of the approval rule, and whether an approval pool is defined.

# Arguments
- `approval_rule_template_name`: The name of the approval rule template where you want to
  update the content of the rule.
- `new_rule_content`: The content that replaces the existing content of the rule. Content
  statements must be complete. You cannot provide only the changes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"existingRuleContentSha256"`: The SHA-256 hash signature for the content of the approval
  rule. You can retrieve this information by using GetPullRequest.
"""
function update_approval_rule_template_content(
    approvalRuleTemplateName,
    newRuleContent;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdateApprovalRuleTemplateContent",
        Dict{String,Any}(
            "approvalRuleTemplateName" => approvalRuleTemplateName,
            "newRuleContent" => newRuleContent,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_approval_rule_template_content(
    approvalRuleTemplateName,
    newRuleContent,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdateApprovalRuleTemplateContent",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "approvalRuleTemplateName" => approvalRuleTemplateName,
                    "newRuleContent" => newRuleContent,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_approval_rule_template_description(approval_rule_template_description, approval_rule_template_name)
    update_approval_rule_template_description(approval_rule_template_description, approval_rule_template_name, params::Dict{String,<:Any})

Updates the description for a specified approval rule template.

# Arguments
- `approval_rule_template_description`: The updated description of the approval rule
  template.
- `approval_rule_template_name`: The name of the template for which you want to update the
  description.

"""
function update_approval_rule_template_description(
    approvalRuleTemplateDescription,
    approvalRuleTemplateName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdateApprovalRuleTemplateDescription",
        Dict{String,Any}(
            "approvalRuleTemplateDescription" => approvalRuleTemplateDescription,
            "approvalRuleTemplateName" => approvalRuleTemplateName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_approval_rule_template_description(
    approvalRuleTemplateDescription,
    approvalRuleTemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdateApprovalRuleTemplateDescription",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "approvalRuleTemplateDescription" => approvalRuleTemplateDescription,
                    "approvalRuleTemplateName" => approvalRuleTemplateName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_approval_rule_template_name(new_approval_rule_template_name, old_approval_rule_template_name)
    update_approval_rule_template_name(new_approval_rule_template_name, old_approval_rule_template_name, params::Dict{String,<:Any})

Updates the name of a specified approval rule template.

# Arguments
- `new_approval_rule_template_name`: The new name you want to apply to the approval rule
  template.
- `old_approval_rule_template_name`: The current name of the approval rule template.

"""
function update_approval_rule_template_name(
    newApprovalRuleTemplateName,
    oldApprovalRuleTemplateName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdateApprovalRuleTemplateName",
        Dict{String,Any}(
            "newApprovalRuleTemplateName" => newApprovalRuleTemplateName,
            "oldApprovalRuleTemplateName" => oldApprovalRuleTemplateName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_approval_rule_template_name(
    newApprovalRuleTemplateName,
    oldApprovalRuleTemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdateApprovalRuleTemplateName",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "newApprovalRuleTemplateName" => newApprovalRuleTemplateName,
                    "oldApprovalRuleTemplateName" => oldApprovalRuleTemplateName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_comment(comment_id, content)
    update_comment(comment_id, content, params::Dict{String,<:Any})

Replaces the contents of a comment.

# Arguments
- `comment_id`: The system-generated ID of the comment you want to update. To get this ID,
  use GetCommentsForComparedCommit or GetCommentsForPullRequest.
- `content`: The updated content to replace the existing content of the comment.

"""
function update_comment(
    commentId, content; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "UpdateComment",
        Dict{String,Any}("commentId" => commentId, "content" => content);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_comment(
    commentId,
    content,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdateComment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("commentId" => commentId, "content" => content),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_default_branch(default_branch_name, repository_name)
    update_default_branch(default_branch_name, repository_name, params::Dict{String,<:Any})

Sets or changes the default branch name for the specified repository.  If you use this
operation to change the default branch name to the current default branch name, a success
message is returned even though the default branch did not change.

# Arguments
- `default_branch_name`: The name of the branch to set as the default branch.
- `repository_name`: The name of the repository for which you want to set or change the
  default branch.

"""
function update_default_branch(
    defaultBranchName, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "UpdateDefaultBranch",
        Dict{String,Any}(
            "defaultBranchName" => defaultBranchName, "repositoryName" => repositoryName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_default_branch(
    defaultBranchName,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdateDefaultBranch",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "defaultBranchName" => defaultBranchName,
                    "repositoryName" => repositoryName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_pull_request_approval_rule_content(approval_rule_name, new_rule_content, pull_request_id)
    update_pull_request_approval_rule_content(approval_rule_name, new_rule_content, pull_request_id, params::Dict{String,<:Any})

Updates the structure of an approval rule created specifically for a pull request. For
example, you can change the number of required approvers and the approval pool for
approvers.

# Arguments
- `approval_rule_name`: The name of the approval rule you want to update.
- `new_rule_content`: The updated content for the approval rule.  When you update the
  content of the approval rule, you can specify approvers in an approval pool in one of two
  ways:    CodeCommitApprovers: This option only requires an Amazon Web Services account and
  a resource. It can be used for both IAM users and federated access users whose name matches
  the provided resource name. This is a very powerful option that offers a great deal of
  flexibility. For example, if you specify the Amazon Web Services account 123456789012 and
  Mary_Major, all of the following are counted as approvals coming from that user:   An IAM
  user in the account (arn:aws:iam::123456789012:user/Mary_Major)   A federated user
  identified in IAM as Mary_Major (arn:aws:sts::123456789012:federated-user/Mary_Major)
  This option does not recognize an active session of someone assuming the role of
  CodeCommitReview with a role session name of Mary_Major
  (arn:aws:sts::123456789012:assumed-role/CodeCommitReview/Mary_Major) unless you include a
  wildcard (*Mary_Major).    Fully qualified ARN: This option allows you to specify the fully
  qualified Amazon Resource Name (ARN) of the IAM user or role.    For more information about
  IAM ARNs, wildcards, and formats, see IAM Identifiers in the IAM User Guide.
- `pull_request_id`: The system-generated ID of the pull request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"existingRuleContentSha256"`: The SHA-256 hash signature for the content of the approval
  rule. You can retrieve this information by using GetPullRequest.
"""
function update_pull_request_approval_rule_content(
    approvalRuleName,
    newRuleContent,
    pullRequestId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdatePullRequestApprovalRuleContent",
        Dict{String,Any}(
            "approvalRuleName" => approvalRuleName,
            "newRuleContent" => newRuleContent,
            "pullRequestId" => pullRequestId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_pull_request_approval_rule_content(
    approvalRuleName,
    newRuleContent,
    pullRequestId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdatePullRequestApprovalRuleContent",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "approvalRuleName" => approvalRuleName,
                    "newRuleContent" => newRuleContent,
                    "pullRequestId" => pullRequestId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_pull_request_approval_state(approval_state, pull_request_id, revision_id)
    update_pull_request_approval_state(approval_state, pull_request_id, revision_id, params::Dict{String,<:Any})

Updates the state of a user's approval on a pull request. The user is derived from the
signed-in account when the request is made.

# Arguments
- `approval_state`: The approval state to associate with the user on the pull request.
- `pull_request_id`: The system-generated ID of the pull request.
- `revision_id`: The system-generated ID of the revision.

"""
function update_pull_request_approval_state(
    approvalState,
    pullRequestId,
    revisionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdatePullRequestApprovalState",
        Dict{String,Any}(
            "approvalState" => approvalState,
            "pullRequestId" => pullRequestId,
            "revisionId" => revisionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_pull_request_approval_state(
    approvalState,
    pullRequestId,
    revisionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdatePullRequestApprovalState",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "approvalState" => approvalState,
                    "pullRequestId" => pullRequestId,
                    "revisionId" => revisionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_pull_request_description(description, pull_request_id)
    update_pull_request_description(description, pull_request_id, params::Dict{String,<:Any})

Replaces the contents of the description of a pull request.

# Arguments
- `description`: The updated content of the description for the pull request. This content
  replaces the existing description.
- `pull_request_id`: The system-generated ID of the pull request. To get this ID, use
  ListPullRequests.

"""
function update_pull_request_description(
    description, pullRequestId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "UpdatePullRequestDescription",
        Dict{String,Any}("description" => description, "pullRequestId" => pullRequestId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_pull_request_description(
    description,
    pullRequestId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdatePullRequestDescription",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "description" => description, "pullRequestId" => pullRequestId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_pull_request_status(pull_request_id, pull_request_status)
    update_pull_request_status(pull_request_id, pull_request_status, params::Dict{String,<:Any})

Updates the status of a pull request.

# Arguments
- `pull_request_id`: The system-generated ID of the pull request. To get this ID, use
  ListPullRequests.
- `pull_request_status`: The status of the pull request. The only valid operations are to
  update the status from OPEN to OPEN, OPEN to CLOSED or from CLOSED to CLOSED.

"""
function update_pull_request_status(
    pullRequestId, pullRequestStatus; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "UpdatePullRequestStatus",
        Dict{String,Any}(
            "pullRequestId" => pullRequestId, "pullRequestStatus" => pullRequestStatus
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_pull_request_status(
    pullRequestId,
    pullRequestStatus,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdatePullRequestStatus",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "pullRequestId" => pullRequestId,
                    "pullRequestStatus" => pullRequestStatus,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_pull_request_title(pull_request_id, title)
    update_pull_request_title(pull_request_id, title, params::Dict{String,<:Any})

Replaces the title of a pull request.

# Arguments
- `pull_request_id`: The system-generated ID of the pull request. To get this ID, use
  ListPullRequests.
- `title`: The updated title of the pull request. This replaces the existing title.

"""
function update_pull_request_title(
    pullRequestId, title; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "UpdatePullRequestTitle",
        Dict{String,Any}("pullRequestId" => pullRequestId, "title" => title);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_pull_request_title(
    pullRequestId,
    title,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdatePullRequestTitle",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("pullRequestId" => pullRequestId, "title" => title),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_repository_description(repository_name)
    update_repository_description(repository_name, params::Dict{String,<:Any})

Sets or changes the comment or description for a repository.  The description field for a
repository accepts all HTML characters and all valid Unicode characters. Applications that
do not HTML-encode the description and display it in a webpage can expose users to
potentially malicious code. Make sure that you HTML-encode the description field in any
application that uses this API to display the repository description on a webpage.

# Arguments
- `repository_name`: The name of the repository to set or change the comment or description
  for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"repositoryDescription"`: The new comment or description for the specified repository.
  Repository descriptions are limited to 1,000 characters.
"""
function update_repository_description(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "UpdateRepositoryDescription",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_repository_description(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdateRepositoryDescription",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_repository_encryption_key(kms_key_id, repository_name)
    update_repository_encryption_key(kms_key_id, repository_name, params::Dict{String,<:Any})

Updates the Key Management Service encryption key used to encrypt and decrypt a CodeCommit
repository.

# Arguments
- `kms_key_id`: The ID of the encryption key. You can view the ID of an encryption key in
  the KMS console, or use the KMS APIs to programmatically retrieve a key ID. For more
  information about acceptable values for keyID, see KeyId in the Decrypt API description in
  the Key Management Service API Reference.
- `repository_name`: The name of the repository for which you want to update the KMS
  encryption key used to encrypt and decrypt the repository.

"""
function update_repository_encryption_key(
    kmsKeyId, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "UpdateRepositoryEncryptionKey",
        Dict{String,Any}("kmsKeyId" => kmsKeyId, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_repository_encryption_key(
    kmsKeyId,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdateRepositoryEncryptionKey",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "kmsKeyId" => kmsKeyId, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_repository_name(new_name, old_name)
    update_repository_name(new_name, old_name, params::Dict{String,<:Any})

Renames a repository. The repository name must be unique across the calling Amazon Web
Services account. Repository names are limited to 100 alphanumeric, dash, and underscore
characters, and cannot include certain characters. The suffix .git is prohibited. For more
information about the limits on repository names, see Quotas in the CodeCommit User Guide.

# Arguments
- `new_name`: The new name for the repository.
- `old_name`: The current name of the repository.

"""
function update_repository_name(
    newName, oldName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codecommit(
        "UpdateRepositoryName",
        Dict{String,Any}("newName" => newName, "oldName" => oldName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_repository_name(
    newName,
    oldName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codecommit(
        "UpdateRepositoryName",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("newName" => newName, "oldName" => oldName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
