# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: cognito_identity_provider
using AWS.Compat
using AWS.UUIDs

"""
    add_custom_attributes(custom_attributes, user_pool_id)
    add_custom_attributes(custom_attributes, user_pool_id, params::Dict{String,<:Any})

Adds additional user attributes to the user pool schema.  Amazon Cognito evaluates Identity
and Access Management (IAM) policies in requests for this API operation. For this
operation, you must use IAM credentials to authorize requests, and you must grant yourself
the corresponding IAM permission in a policy.  Learn more     Signing Amazon Web Services
API Requests     Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `custom_attributes`: An array of custom attributes, such as Mutable and Name.
- `user_pool_id`: The user pool ID for the user pool where you want to add custom
  attributes.

"""
function add_custom_attributes(
    CustomAttributes, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AddCustomAttributes",
        Dict{String,Any}(
            "CustomAttributes" => CustomAttributes, "UserPoolId" => UserPoolId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_custom_attributes(
    CustomAttributes,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AddCustomAttributes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CustomAttributes" => CustomAttributes, "UserPoolId" => UserPoolId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_add_user_to_group(group_name, user_pool_id, username)
    admin_add_user_to_group(group_name, user_pool_id, username, params::Dict{String,<:Any})

Adds a user to a group. A user who is in a group can present a preferred-role claim to an
identity pool, and populates a cognito:groups claim to their access and identity tokens.
Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this
API operation. For this operation, you must use IAM credentials to authorize requests, and
you must grant yourself the corresponding IAM permission in a policy.  Learn more
Signing Amazon Web Services API Requests     Using the Amazon Cognito user pools API and
user pool endpoints

# Arguments
- `group_name`: The name of the group that you want to add your user to.
- `user_pool_id`: The user pool ID for the user pool.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

"""
function admin_add_user_to_group(
    GroupName, UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminAddUserToGroup",
        Dict{String,Any}(
            "GroupName" => GroupName, "UserPoolId" => UserPoolId, "Username" => Username
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_add_user_to_group(
    GroupName,
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminAddUserToGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GroupName" => GroupName,
                    "UserPoolId" => UserPoolId,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_confirm_sign_up(user_pool_id, username)
    admin_confirm_sign_up(user_pool_id, username, params::Dict{String,<:Any})

This IAM-authenticated API operation provides a code that Amazon Cognito sent to your user
when they signed up in your user pool. After your user enters their code, they confirm
ownership of the email address or phone number that they provided, and their user account
becomes active. Depending on your user pool configuration, your users will receive their
confirmation code in an email or SMS message. Local users who signed up in your user pool
are the only type of user who can confirm sign-up with a code. Users who federate through
an external identity provider (IdP) have already been confirmed by their IdP.
Administrator-created users confirm their accounts when they respond to their invitation
email message and choose a password.  Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID for which you want to confirm user registration.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for any
  custom workflows that this action triggers. If your user pool configuration includes
  triggers, the AdminConfirmSignUp API action invokes the Lambda function that is specified
  for the post confirmation trigger. When Amazon Cognito invokes this function, it passes a
  JSON payload, which the function receives as input. In this payload, the clientMetadata
  attribute provides the data that you assigned to the ClientMetadata parameter in your
  AdminConfirmSignUp request. In your function code in Lambda, you can process the
  ClientMetadata value to enhance your workflow for your specific needs. For more
  information, see  Customizing user pool Workflows with Lambda Triggers in the Amazon
  Cognito Developer Guide.  When you use the ClientMetadata parameter, remember that Amazon
  Cognito won't do the following:   Store the ClientMetadata value. This data is available
  only to Lambda triggers that are assigned to a user pool to support custom workflows. If
  your user pool configuration doesn't include triggers, the ClientMetadata parameter serves
  no purpose.   Validate the ClientMetadata value.   Encrypt the ClientMetadata value. Don't
  use Amazon Cognito to provide sensitive information.
"""
function admin_confirm_sign_up(
    UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminConfirmSignUp",
        Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_confirm_sign_up(
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminConfirmSignUp",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_create_user(user_pool_id, username)
    admin_create_user(user_pool_id, username, params::Dict{String,<:Any})

Creates a new user in the specified user pool. If MessageAction isn't set, the default is
to send a welcome message via email or phone (SMS).  This action might generate an SMS text
message. Starting June 1, 2021, US telecom carriers require you to register an origination
phone number before you can send SMS messages to US phone numbers. If you use SMS text
messages in Amazon Cognito, you must register a phone number with Amazon Pinpoint. Amazon
Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must
receive SMS messages might not be able to sign up, activate their accounts, or sign in. If
you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service,
Amazon Simple Notification Service might place your account in the SMS sandbox. In  sandbox
mode , you can send messages only to verified phone numbers. After you test your app while
in the sandbox environment, you can move out of the sandbox and into production. For more
information, see  SMS message settings for Amazon Cognito user pools in the Amazon Cognito
Developer Guide.  This message is based on a template that you configured in your call to
create or update a user pool. This template includes your custom sign-up instructions and
placeholders for user name and temporary password. Alternatively, you can call
AdminCreateUser with SUPPRESS for the MessageAction parameter, and Amazon Cognito won't
send any email.  In either case, the user will be in the FORCE_CHANGE_PASSWORD state until
they sign in and change their password.  Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID for the user pool where the user will be created.
- `username`: The value that you want to set as the username sign-in attribute. The
  following conditions apply to the username parameter.   The username can't be a duplicate
  of another username in the same user pool.   You can't change the value of a username after
  you create it.   You can only provide a value if usernames are a valid sign-in attribute
  for your user pool. If your user pool only supports phone numbers or email addresses as
  sign-in attributes, Amazon Cognito automatically generates a username value. For more
  information, see Customizing sign-in attributes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for any
  custom workflows that this action triggers. You create custom workflows by assigning Lambda
  functions to user pool triggers. When you use the AdminCreateUser API action, Amazon
  Cognito invokes the function that is assigned to the pre sign-up trigger. When Amazon
  Cognito invokes this function, it passes a JSON payload, which the function receives as
  input. This payload contains a clientMetadata attribute, which provides the data that you
  assigned to the ClientMetadata parameter in your AdminCreateUser request. In your function
  code in Lambda, you can process the clientMetadata value to enhance your workflow for your
  specific needs. For more information, see  Customizing user pool Workflows with Lambda
  Triggers in the Amazon Cognito Developer Guide.  When you use the ClientMetadata parameter,
  remember that Amazon Cognito won't do the following:   Store the ClientMetadata value. This
  data is available only to Lambda triggers that are assigned to a user pool to support
  custom workflows. If your user pool configuration doesn't include triggers, the
  ClientMetadata parameter serves no purpose.   Validate the ClientMetadata value.   Encrypt
  the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
- `"DesiredDeliveryMediums"`: Specify \"EMAIL\" if email will be used to send the welcome
  message. Specify \"SMS\" if the phone number will be used. The default value is \"SMS\".
  You can specify more than one value.
- `"ForceAliasCreation"`: This parameter is used only if the phone_number_verified or
  email_verified attribute is set to True. Otherwise, it is ignored. If this parameter is set
  to True and the phone number or email address specified in the UserAttributes parameter
  already exists as an alias with a different user, the API call will migrate the alias from
  the previous user to the newly created user. The previous user will no longer be able to
  log in using that alias. If this parameter is set to False, the API throws an
  AliasExistsException error if the alias already exists. The default value is False.
- `"MessageAction"`: Set to RESEND to resend the invitation message to a user that already
  exists and reset the expiration limit on the user's account. Set to SUPPRESS to suppress
  sending the message. You can specify only one value.
- `"TemporaryPassword"`: The user's temporary password. This password must conform to the
  password policy that you specified when you created the user pool. The temporary password
  is valid only once. To complete the Admin Create User flow, the user must enter the
  temporary password in the sign-in page, along with a new password to be used in all future
  sign-ins. This parameter isn't required. If you don't specify a value, Amazon Cognito
  generates one for you. The temporary password can only be used until the user account
  expiration limit that you set for your user pool. To reset the account after that time
  limit, you must call AdminCreateUser again and specify RESEND for the MessageAction
  parameter.
- `"UserAttributes"`: An array of name-value pairs that contain user attributes and
  attribute values to be set for the user to be created. You can create a user without
  specifying any attributes other than Username. However, any attributes that you specify as
  required (when creating a user pool or in the Attributes tab of the console) either you
  should supply (in your call to AdminCreateUser) or the user should supply (when they sign
  up in response to your welcome message). For custom attributes, you must prepend the
  custom: prefix to the attribute name. To send a message inviting the user to sign up, you
  must specify the user's email address or phone number. You can do this in your call to
  AdminCreateUser or in the Users tab of the Amazon Cognito console for managing your user
  pools. In your call to AdminCreateUser, you can set the email_verified attribute to True,
  and you can set the phone_number_verified attribute to True. You can also do this by
  calling AdminUpdateUserAttributes.    email: The email address of the user to whom the
  message that contains the code and username will be sent. Required if the email_verified
  attribute is set to True, or if \"EMAIL\" is specified in the DesiredDeliveryMediums
  parameter.    phone_number: The phone number of the user to whom the message that contains
  the code and username will be sent. Required if the phone_number_verified attribute is set
  to True, or if \"SMS\" is specified in the DesiredDeliveryMediums parameter.
- `"ValidationData"`: Temporary user attributes that contribute to the outcomes of your pre
  sign-up Lambda trigger. This set of key-value pairs are for custom validation of
  information that you collect from your users but don't need to retain. Your Lambda function
  can analyze this additional data and act on it. Your function might perform external API
  operations like logging user attributes and validation data to Amazon CloudWatch Logs.
  Validation data might also affect the response that your function returns to Amazon
  Cognito, like automatically confirming the user if they sign up from within your network.
  For more information about the pre sign-up Lambda trigger, see Pre sign-up Lambda trigger.
"""
function admin_create_user(
    UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminCreateUser",
        Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_create_user(
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminCreateUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_delete_user(user_pool_id, username)
    admin_delete_user(user_pool_id, username, params::Dict{String,<:Any})

Deletes a user as an administrator. Works on any user.  Amazon Cognito evaluates Identity
and Access Management (IAM) policies in requests for this API operation. For this
operation, you must use IAM credentials to authorize requests, and you must grant yourself
the corresponding IAM permission in a policy.  Learn more     Signing Amazon Web Services
API Requests     Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID for the user pool where you want to delete the user.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

"""
function admin_delete_user(
    UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminDeleteUser",
        Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_delete_user(
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminDeleteUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_delete_user_attributes(user_attribute_names, user_pool_id, username)
    admin_delete_user_attributes(user_attribute_names, user_pool_id, username, params::Dict{String,<:Any})

Deletes the user attributes in a user pool as an administrator. Works on any user.  Amazon
Cognito evaluates Identity and Access Management (IAM) policies in requests for this API
operation. For this operation, you must use IAM credentials to authorize requests, and you
must grant yourself the corresponding IAM permission in a policy.  Learn more     Signing
Amazon Web Services API Requests     Using the Amazon Cognito user pools API and user pool
endpoints

# Arguments
- `user_attribute_names`: An array of strings representing the user attribute names you
  want to delete. For custom attributes, you must prepend the custom: prefix to the attribute
  name.
- `user_pool_id`: The user pool ID for the user pool where you want to delete user
  attributes.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

"""
function admin_delete_user_attributes(
    UserAttributeNames,
    UserPoolId,
    Username;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminDeleteUserAttributes",
        Dict{String,Any}(
            "UserAttributeNames" => UserAttributeNames,
            "UserPoolId" => UserPoolId,
            "Username" => Username,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_delete_user_attributes(
    UserAttributeNames,
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminDeleteUserAttributes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "UserAttributeNames" => UserAttributeNames,
                    "UserPoolId" => UserPoolId,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_disable_provider_for_user(user, user_pool_id)
    admin_disable_provider_for_user(user, user_pool_id, params::Dict{String,<:Any})

Prevents the user from signing in with the specified external (SAML or social) identity
provider (IdP). If the user that you want to deactivate is a Amazon Cognito user pools
native username + password user, they can't use their password to sign in. If the user to
deactivate is a linked external IdP user, any link between that user and an existing user
is removed. When the external user signs in again, and the user is no longer attached to
the previously linked DestinationUser, the user must create a new user account. See
AdminLinkProviderForUser. The ProviderName must match the value specified when creating an
IdP for the pool.  To deactivate a native username + password user, the ProviderName value
must be Cognito and the ProviderAttributeName must be Cognito_Subject. The
ProviderAttributeValue must be the name that is used in the user pool for the user. The
ProviderAttributeName must always be Cognito_Subject for social IdPs. The
ProviderAttributeValue must always be the exact subject that was used when the user was
originally linked as a source user. For de-linking a SAML identity, there are two
scenarios. If the linked identity has not yet been used to sign in, the
ProviderAttributeName and ProviderAttributeValue must be the same values that were used for
the SourceUser when the identities were originally linked using  AdminLinkProviderForUser
call. (If the linking was done with ProviderAttributeName set to Cognito_Subject, the same
applies here). However, if the user has already signed in, the ProviderAttributeName must
be Cognito_Subject and ProviderAttributeValue must be the subject of the SAML assertion.
Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this
API operation. For this operation, you must use IAM credentials to authorize requests, and
you must grant yourself the corresponding IAM permission in a policy.  Learn more
Signing Amazon Web Services API Requests     Using the Amazon Cognito user pools API and
user pool endpoints

# Arguments
- `user`: The user to be disabled.
- `user_pool_id`: The user pool ID for the user pool.

"""
function admin_disable_provider_for_user(
    User, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminDisableProviderForUser",
        Dict{String,Any}("User" => User, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_disable_provider_for_user(
    User,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminDisableProviderForUser",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("User" => User, "UserPoolId" => UserPoolId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_disable_user(user_pool_id, username)
    admin_disable_user(user_pool_id, username, params::Dict{String,<:Any})

Deactivates a user and revokes all access tokens for the user. A deactivated user can't
sign in, but still appears in the responses to GetUser and ListUsers API requests.  Amazon
Cognito evaluates Identity and Access Management (IAM) policies in requests for this API
operation. For this operation, you must use IAM credentials to authorize requests, and you
must grant yourself the corresponding IAM permission in a policy.  Learn more     Signing
Amazon Web Services API Requests     Using the Amazon Cognito user pools API and user pool
endpoints

# Arguments
- `user_pool_id`: The user pool ID for the user pool where you want to disable the user.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

"""
function admin_disable_user(
    UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminDisableUser",
        Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_disable_user(
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminDisableUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_enable_user(user_pool_id, username)
    admin_enable_user(user_pool_id, username, params::Dict{String,<:Any})

Enables the specified user as an administrator. Works on any user.  Amazon Cognito
evaluates Identity and Access Management (IAM) policies in requests for this API operation.
For this operation, you must use IAM credentials to authorize requests, and you must grant
yourself the corresponding IAM permission in a policy.  Learn more     Signing Amazon Web
Services API Requests     Using the Amazon Cognito user pools API and user pool endpoints


# Arguments
- `user_pool_id`: The user pool ID for the user pool where you want to enable the user.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

"""
function admin_enable_user(
    UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminEnableUser",
        Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_enable_user(
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminEnableUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_forget_device(device_key, user_pool_id, username)
    admin_forget_device(device_key, user_pool_id, username, params::Dict{String,<:Any})

Forgets the device, as an administrator.  Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `device_key`: The device key.
- `user_pool_id`: The user pool ID.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

"""
function admin_forget_device(
    DeviceKey, UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminForgetDevice",
        Dict{String,Any}(
            "DeviceKey" => DeviceKey, "UserPoolId" => UserPoolId, "Username" => Username
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_forget_device(
    DeviceKey,
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminForgetDevice",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DeviceKey" => DeviceKey,
                    "UserPoolId" => UserPoolId,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_get_device(device_key, user_pool_id, username)
    admin_get_device(device_key, user_pool_id, username, params::Dict{String,<:Any})

Gets the device, as an administrator.  Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `device_key`: The device key.
- `user_pool_id`: The user pool ID.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

"""
function admin_get_device(
    DeviceKey, UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminGetDevice",
        Dict{String,Any}(
            "DeviceKey" => DeviceKey, "UserPoolId" => UserPoolId, "Username" => Username
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_get_device(
    DeviceKey,
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminGetDevice",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DeviceKey" => DeviceKey,
                    "UserPoolId" => UserPoolId,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_get_user(user_pool_id, username)
    admin_get_user(user_pool_id, username, params::Dict{String,<:Any})

Gets the specified user by user name in a user pool as an administrator. Works on any user.
 Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for
this API operation. For this operation, you must use IAM credentials to authorize requests,
and you must grant yourself the corresponding IAM permission in a policy.  Learn more
Signing Amazon Web Services API Requests     Using the Amazon Cognito user pools API and
user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID for the user pool where you want to get information
  about the user.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

"""
function admin_get_user(
    UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminGetUser",
        Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_get_user(
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminGetUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_initiate_auth(auth_flow, client_id, user_pool_id)
    admin_initiate_auth(auth_flow, client_id, user_pool_id, params::Dict{String,<:Any})

Initiates the authentication flow, as an administrator.  This action might generate an SMS
text message. Starting June 1, 2021, US telecom carriers require you to register an
origination phone number before you can send SMS messages to US phone numbers. If you use
SMS text messages in Amazon Cognito, you must register a phone number with Amazon Pinpoint.
Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users
who must receive SMS messages might not be able to sign up, activate their accounts, or
sign in. If you have never used SMS text messages with Amazon Cognito or any other Amazon
Web Service, Amazon Simple Notification Service might place your account in the SMS
sandbox. In  sandbox mode , you can send messages only to verified phone numbers. After you
test your app while in the sandbox environment, you can move out of the sandbox and into
production. For more information, see  SMS message settings for Amazon Cognito user pools
in the Amazon Cognito Developer Guide.   Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `auth_flow`: The authentication flow for this call to run. The API action will depend on
  this value. For example:    REFRESH_TOKEN_AUTH will take in a valid refresh token and
  return new tokens.    USER_SRP_AUTH will take in USERNAME and SRP_A and return the Secure
  Remote Password (SRP) protocol variables to be used for next challenge execution.
  ADMIN_USER_PASSWORD_AUTH will take in USERNAME and PASSWORD and return the next challenge
  or tokens.   Valid values include:    USER_SRP_AUTH: Authentication flow for the Secure
  Remote Password (SRP) protocol.    REFRESH_TOKEN_AUTH/REFRESH_TOKEN: Authentication flow
  for refreshing the access token and ID token by supplying a valid refresh token.
  CUSTOM_AUTH: Custom authentication flow.    ADMIN_NO_SRP_AUTH: Non-SRP authentication flow;
  you can pass in the USERNAME and PASSWORD directly if the flow is enabled for calling the
  app client.    ADMIN_USER_PASSWORD_AUTH: Admin-based user password authentication. This
  replaces the ADMIN_NO_SRP_AUTH authentication flow. In this flow, Amazon Cognito receives
  the password in the request instead of using the SRP process to verify passwords.
- `client_id`: The app client ID.
- `user_pool_id`: The ID of the Amazon Cognito user pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnalyticsMetadata"`: The analytics metadata for collecting Amazon Pinpoint metrics for
  AdminInitiateAuth calls.
- `"AuthParameters"`: The authentication parameters. These are inputs corresponding to the
  AuthFlow that you're invoking. The required values depend on the value of AuthFlow:   For
  USER_SRP_AUTH: USERNAME (required), SRP_A (required), SECRET_HASH (required if the app
  client is configured with a client secret), DEVICE_KEY.   For ADMIN_USER_PASSWORD_AUTH:
  USERNAME (required), PASSWORD (required), SECRET_HASH (required if the app client is
  configured with a client secret), DEVICE_KEY.   For REFRESH_TOKEN_AUTH/REFRESH_TOKEN:
  REFRESH_TOKEN (required), SECRET_HASH (required if the app client is configured with a
  client secret), DEVICE_KEY.   For CUSTOM_AUTH: USERNAME (required), SECRET_HASH (if app
  client is configured with client secret), DEVICE_KEY. To start the authentication flow with
  password verification, include ChallengeName: SRP_A and SRP_A: (The SRP_A Value).   For
  more information about SECRET_HASH, see Computing secret hash values. For information about
  DEVICE_KEY, see Working with user devices in your user pool.
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for
  certain custom workflows that this action triggers. You create custom workflows by
  assigning Lambda functions to user pool triggers. When you use the AdminInitiateAuth API
  action, Amazon Cognito invokes the Lambda functions that are specified for various
  triggers. The ClientMetadata value is passed as input to the functions for only the
  following triggers:   Pre signup   Pre authentication   User migration   When Amazon
  Cognito invokes the functions for these triggers, it passes a JSON payload, which the
  function receives as input. This payload contains a validationData attribute, which
  provides the data that you assigned to the ClientMetadata parameter in your
  AdminInitiateAuth request. In your function code in Lambda, you can process the
  validationData value to enhance your workflow for your specific needs. When you use the
  AdminInitiateAuth API action, Amazon Cognito also invokes the functions for the following
  triggers, but it doesn't provide the ClientMetadata value as input:   Post authentication
  Custom message   Pre token generation   Create auth challenge   Define auth challenge   For
  more information, see  Customizing user pool Workflows with Lambda Triggers in the Amazon
  Cognito Developer Guide.  When you use the ClientMetadata parameter, remember that Amazon
  Cognito won't do the following:   Store the ClientMetadata value. This data is available
  only to Lambda triggers that are assigned to a user pool to support custom workflows. If
  your user pool configuration doesn't include triggers, the ClientMetadata parameter serves
  no purpose.   Validate the ClientMetadata value.   Encrypt the ClientMetadata value. Don't
  use Amazon Cognito to provide sensitive information.
- `"ContextData"`: Contextual data about your user session, such as the device fingerprint,
  IP address, or location. Amazon Cognito advanced security evaluates the risk of an
  authentication event based on the context that your app generates and passes to Amazon
  Cognito when it makes API requests.
"""
function admin_initiate_auth(
    AuthFlow, ClientId, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminInitiateAuth",
        Dict{String,Any}(
            "AuthFlow" => AuthFlow, "ClientId" => ClientId, "UserPoolId" => UserPoolId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_initiate_auth(
    AuthFlow,
    ClientId,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminInitiateAuth",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AuthFlow" => AuthFlow,
                    "ClientId" => ClientId,
                    "UserPoolId" => UserPoolId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_link_provider_for_user(destination_user, source_user, user_pool_id)
    admin_link_provider_for_user(destination_user, source_user, user_pool_id, params::Dict{String,<:Any})

Links an existing user account in a user pool (DestinationUser) to an identity from an
external IdP (SourceUser) based on a specified attribute name and value from the external
IdP. This allows you to create a link from the existing user account to an external
federated user identity that has not yet been used to sign in. You can then use the
federated user identity to sign in as the existing user account.   For example, if there is
an existing user with a username and password, this API links that user to a federated user
identity. When the user signs in with a federated user identity, they sign in as the
existing user account.  The maximum number of federated identities linked to a user is
five.   Because this API allows a user with an external federated identity to sign in as an
existing user in the user pool, it is critical that it only be used with external IdPs and
provider attributes that have been trusted by the application owner.   Amazon Cognito
evaluates Identity and Access Management (IAM) policies in requests for this API operation.
For this operation, you must use IAM credentials to authorize requests, and you must grant
yourself the corresponding IAM permission in a policy.  Learn more     Signing Amazon Web
Services API Requests     Using the Amazon Cognito user pools API and user pool endpoints


# Arguments
- `destination_user`: The existing user in the user pool that you want to assign to the
  external IdP user account. This user can be a local (Username + Password) Amazon Cognito
  user pools user or a federated user (for example, a SAML or Facebook user). If the user
  doesn't exist, Amazon Cognito generates an exception. Amazon Cognito returns this user when
  the new user (with the linked IdP attribute) signs in. For a native username + password
  user, the ProviderAttributeValue for the DestinationUser should be the username in the user
  pool. For a federated user, it should be the provider-specific user_id. The
  ProviderAttributeName of the DestinationUser is ignored. The ProviderName should be set to
  Cognito for users in Cognito user pools.  All attributes in the DestinationUser profile
  must be mutable. If you have assigned the user any immutable custom attributes, the
  operation won't succeed.
- `source_user`: An external IdP account for a user who doesn't exist yet in the user pool.
  This user must be a federated user (for example, a SAML or Facebook user), not another
  native user. If the SourceUser is using a federated social IdP, such as Facebook, Google,
  or Login with Amazon, you must set the ProviderAttributeName to Cognito_Subject. For social
  IdPs, the ProviderName will be Facebook, Google, or LoginWithAmazon, and Amazon Cognito
  will automatically parse the Facebook, Google, and Login with Amazon tokens for id, sub,
  and user_id, respectively. The ProviderAttributeValue for the user must be the same value
  as the id, sub, or user_id value found in the social IdP token.  For OIDC, the
  ProviderAttributeName can be any value that matches a claim in the ID token, or that your
  app retrieves from the userInfo endpoint. You must map the claim to a user pool attribute
  in your IdP configuration, and set the user pool attribute name as the value of
  ProviderAttributeName in your AdminLinkProviderForUser request. For SAML, the
  ProviderAttributeName can be any value that matches a claim in the SAML assertion. To link
  SAML users based on the subject of the SAML assertion, map the subject to a claim through
  the SAML IdP and set that claim name as the value of ProviderAttributeName in your
  AdminLinkProviderForUser request. For both OIDC and SAML users, when you set
  ProviderAttributeName to Cognito_Subject, Amazon Cognito will automatically parse the
  default unique identifier found in the subject from the IdP token.
- `user_pool_id`: The user pool ID for the user pool.

"""
function admin_link_provider_for_user(
    DestinationUser,
    SourceUser,
    UserPoolId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminLinkProviderForUser",
        Dict{String,Any}(
            "DestinationUser" => DestinationUser,
            "SourceUser" => SourceUser,
            "UserPoolId" => UserPoolId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_link_provider_for_user(
    DestinationUser,
    SourceUser,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminLinkProviderForUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationUser" => DestinationUser,
                    "SourceUser" => SourceUser,
                    "UserPoolId" => UserPoolId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_list_devices(user_pool_id, username)
    admin_list_devices(user_pool_id, username, params::Dict{String,<:Any})

Lists devices, as an administrator.  Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The limit of the devices request.
- `"PaginationToken"`: This API operation returns a limited number of results. The
  pagination token is an identifier that you can present in an additional API request with
  the same parameters. When you include the pagination token, Amazon Cognito returns the next
  set of items after the current list. Subsequent requests return a new pagination token. By
  use of this token, you can paginate through the full list of items.
"""
function admin_list_devices(
    UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminListDevices",
        Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_list_devices(
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminListDevices",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_list_groups_for_user(user_pool_id, username)
    admin_list_groups_for_user(user_pool_id, username, params::Dict{String,<:Any})

Lists the groups that a user belongs to.  Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID for the user pool.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The limit of the request to list groups.
- `"NextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function admin_list_groups_for_user(
    UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminListGroupsForUser",
        Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_list_groups_for_user(
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminListGroupsForUser",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_list_user_auth_events(user_pool_id, username)
    admin_list_user_auth_events(user_pool_id, username, params::Dict{String,<:Any})

A history of user activity and any risks detected as part of Amazon Cognito advanced
security.  Amazon Cognito evaluates Identity and Access Management (IAM) policies in
requests for this API operation. For this operation, you must use IAM credentials to
authorize requests, and you must grant yourself the corresponding IAM permission in a
policy.  Learn more     Signing Amazon Web Services API Requests     Using the Amazon
Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of authentication events to return. Returns 60 events
  if you set MaxResults to 0, or if you don't include a MaxResults parameter.
- `"NextToken"`: A pagination token.
"""
function admin_list_user_auth_events(
    UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminListUserAuthEvents",
        Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_list_user_auth_events(
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminListUserAuthEvents",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_remove_user_from_group(group_name, user_pool_id, username)
    admin_remove_user_from_group(group_name, user_pool_id, username, params::Dict{String,<:Any})

Removes the specified user from the specified group.  Amazon Cognito evaluates Identity and
Access Management (IAM) policies in requests for this API operation. For this operation,
you must use IAM credentials to authorize requests, and you must grant yourself the
corresponding IAM permission in a policy.  Learn more     Signing Amazon Web Services API
Requests     Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `group_name`: The group name.
- `user_pool_id`: The user pool ID for the user pool.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

"""
function admin_remove_user_from_group(
    GroupName, UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminRemoveUserFromGroup",
        Dict{String,Any}(
            "GroupName" => GroupName, "UserPoolId" => UserPoolId, "Username" => Username
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_remove_user_from_group(
    GroupName,
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminRemoveUserFromGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GroupName" => GroupName,
                    "UserPoolId" => UserPoolId,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_reset_user_password(user_pool_id, username)
    admin_reset_user_password(user_pool_id, username, params::Dict{String,<:Any})

Resets the specified user's password in a user pool as an administrator. Works on any user.
To use this API operation, your user pool must have self-service account recovery
configured. Use AdminSetUserPassword if you manage passwords as an administrator.  This
action might generate an SMS text message. Starting June 1, 2021, US telecom carriers
require you to register an origination phone number before you can send SMS messages to US
phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone
number with Amazon Pinpoint. Amazon Cognito uses the registered number automatically.
Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
activate their accounts, or sign in. If you have never used SMS text messages with Amazon
Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place
your account in the SMS sandbox. In  sandbox mode , you can send messages only to verified
phone numbers. After you test your app while in the sandbox environment, you can move out
of the sandbox and into production. For more information, see  SMS message settings for
Amazon Cognito user pools in the Amazon Cognito Developer Guide.  Deactivates a user's
password, requiring them to change it. If a user tries to sign in after the API is called,
Amazon Cognito responds with a PasswordResetRequiredException error. Your app must then
perform the actions that reset your user's password: the forgot-password flow. In addition,
if the user pool has phone verification selected and a verified phone number exists for the
user, or if email verification is selected and a verified email exists for the user,
calling this API will also result in sending a message to the end user with the code to
change their password.  Amazon Cognito evaluates Identity and Access Management (IAM)
policies in requests for this API operation. For this operation, you must use IAM
credentials to authorize requests, and you must grant yourself the corresponding IAM
permission in a policy.  Learn more     Signing Amazon Web Services API Requests     Using
the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID for the user pool where you want to reset the user's
  password.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for any
  custom workflows that this action triggers. You create custom workflows by assigning Lambda
  functions to user pool triggers. When you use the AdminResetUserPassword API action, Amazon
  Cognito invokes the function that is assigned to the custom message trigger. When Amazon
  Cognito invokes this function, it passes a JSON payload, which the function receives as
  input. This payload contains a clientMetadata attribute, which provides the data that you
  assigned to the ClientMetadata parameter in your AdminResetUserPassword request. In your
  function code in Lambda, you can process the clientMetadata value to enhance your workflow
  for your specific needs.  For more information, see  Customizing user pool Workflows with
  Lambda Triggers in the Amazon Cognito Developer Guide.  When you use the ClientMetadata
  parameter, remember that Amazon Cognito won't do the following:   Store the ClientMetadata
  value. This data is available only to Lambda triggers that are assigned to a user pool to
  support custom workflows. If your user pool configuration doesn't include triggers, the
  ClientMetadata parameter serves no purpose.   Validate the ClientMetadata value.   Encrypt
  the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
"""
function admin_reset_user_password(
    UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminResetUserPassword",
        Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_reset_user_password(
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminResetUserPassword",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_respond_to_auth_challenge(challenge_name, client_id, user_pool_id)
    admin_respond_to_auth_challenge(challenge_name, client_id, user_pool_id, params::Dict{String,<:Any})

Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for
device authentication that bypasses MFA, or for a custom authentication challenge. An
AdminRespondToAuthChallenge API request provides the answer to that challenge, like a code
or a secure remote password (SRP). The parameters of a response to an authentication
challenge vary with the type of challenge. For more information about custom authentication
challenges, see Custom authentication challenge Lambda triggers.  This action might
generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
register an origination phone number before you can send SMS messages to US phone numbers.
If you use SMS text messages in Amazon Cognito, you must register a phone number with
Amazon Pinpoint. Amazon Cognito uses the registered number automatically. Otherwise, Amazon
Cognito users who must receive SMS messages might not be able to sign up, activate their
accounts, or sign in. If you have never used SMS text messages with Amazon Cognito or any
other Amazon Web Service, Amazon Simple Notification Service might place your account in
the SMS sandbox. In  sandbox mode , you can send messages only to verified phone numbers.
After you test your app while in the sandbox environment, you can move out of the sandbox
and into production. For more information, see  SMS message settings for Amazon Cognito
user pools in the Amazon Cognito Developer Guide.   Amazon Cognito evaluates Identity and
Access Management (IAM) policies in requests for this API operation. For this operation,
you must use IAM credentials to authorize requests, and you must grant yourself the
corresponding IAM permission in a policy.  Learn more     Signing Amazon Web Services API
Requests     Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `challenge_name`: The challenge name. For more information, see AdminInitiateAuth.
- `client_id`: The app client ID.
- `user_pool_id`: The ID of the Amazon Cognito user pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnalyticsMetadata"`: The analytics metadata for collecting Amazon Pinpoint metrics for
  AdminRespondToAuthChallenge calls.
- `"ChallengeResponses"`: The responses to the challenge that you received in the previous
  request. Each challenge has its own required response parameters. The following examples
  are partial JSON request bodies that highlight challenge-response parameters.  You must
  provide a SECRET_HASH parameter in all challenge responses to an app client that has a
  client secret.   SMS_MFA   \"ChallengeName\": \"SMS_MFA\", \"ChallengeResponses\":
  {\"SMS_MFA_CODE\": \"[SMS_code]\", \"USERNAME\": \"[username]\"}   PASSWORD_VERIFIER
  \"ChallengeName\": \"PASSWORD_VERIFIER\", \"ChallengeResponses\":
  {\"PASSWORD_CLAIM_SIGNATURE\": \"[claim_signature]\", \"PASSWORD_CLAIM_SECRET_BLOCK\":
  \"[secret_block]\", \"TIMESTAMP\": [timestamp], \"USERNAME\": \"[username]\"}  Add
  \"DEVICE_KEY\" when you sign in with a remembered device.  CUSTOM_CHALLENGE
  \"ChallengeName\": \"CUSTOM_CHALLENGE\", \"ChallengeResponses\": {\"USERNAME\":
  \"[username]\", \"ANSWER\": \"[challenge_answer]\"}  Add \"DEVICE_KEY\" when you sign in
  with a remembered device.  NEW_PASSWORD_REQUIRED   \"ChallengeName\":
  \"NEW_PASSWORD_REQUIRED\", \"ChallengeResponses\": {\"NEW_PASSWORD\": \"[new_password]\",
  \"USERNAME\": \"[username]\"}  To set any required attributes that InitiateAuth returned in
  an requiredAttributes parameter, add \"userAttributes.[attribute_name]\":
  \"[attribute_value]\". This parameter can also set values for writable attributes that
  aren't required by your user pool.  In a NEW_PASSWORD_REQUIRED challenge response, you
  can't modify a required attribute that already has a value. In RespondToAuthChallenge, set
  a value for any keys that Amazon Cognito returned in the requiredAttributes parameter, then
  use the UpdateUserAttributes API operation to modify the value of any additional
  attributes.   SOFTWARE_TOKEN_MFA   \"ChallengeName\": \"SOFTWARE_TOKEN_MFA\",
  \"ChallengeResponses\": {\"USERNAME\": \"[username]\", \"SOFTWARE_TOKEN_MFA_CODE\":
  [authenticator_code]}   DEVICE_SRP_AUTH   \"ChallengeName\": \"DEVICE_SRP_AUTH\",
  \"ChallengeResponses\": {\"USERNAME\": \"[username]\", \"DEVICE_KEY\": \"[device_key]\",
  \"SRP_A\": \"[srp_a]\"}   DEVICE_PASSWORD_VERIFIER   \"ChallengeName\":
  \"DEVICE_PASSWORD_VERIFIER\", \"ChallengeResponses\": {\"DEVICE_KEY\": \"[device_key]\",
  \"PASSWORD_CLAIM_SIGNATURE\": \"[claim_signature]\", \"PASSWORD_CLAIM_SECRET_BLOCK\":
  \"[secret_block]\", \"TIMESTAMP\": [timestamp], \"USERNAME\": \"[username]\"}   MFA_SETUP
  \"ChallengeName\": \"MFA_SETUP\", \"ChallengeResponses\": {\"USERNAME\": \"[username]\"},
  \"SESSION\": \"[Session ID from VerifySoftwareToken]\"   SELECT_MFA_TYPE
  \"ChallengeName\": \"SELECT_MFA_TYPE\", \"ChallengeResponses\": {\"USERNAME\":
  \"[username]\", \"ANSWER\": \"[SMS_MFA or SOFTWARE_TOKEN_MFA]\"}    For more information
  about SECRET_HASH, see Computing secret hash values. For information about DEVICE_KEY, see
  Working with user devices in your user pool.
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for any
  custom workflows that this action triggers. You create custom workflows by assigning Lambda
  functions to user pool triggers. When you use the AdminRespondToAuthChallenge API action,
  Amazon Cognito invokes any functions that you have assigned to the following triggers:
  pre sign-up   custom message   post authentication   user migration   pre token generation
   define auth challenge   create auth challenge   verify auth challenge response   When
  Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function
  receives as input. This payload contains a clientMetadata attribute that provides the data
  that you assigned to the ClientMetadata parameter in your AdminRespondToAuthChallenge
  request. In your function code in Lambda, you can process the clientMetadata value to
  enhance your workflow for your specific needs. For more information, see  Customizing user
  pool Workflows with Lambda Triggers in the Amazon Cognito Developer Guide.  When you use
  the ClientMetadata parameter, remember that Amazon Cognito won't do the following:   Store
  the ClientMetadata value. This data is available only to Lambda triggers that are assigned
  to a user pool to support custom workflows. If your user pool configuration doesn't include
  triggers, the ClientMetadata parameter serves no purpose.   Validate the ClientMetadata
  value.   Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive
  information.
- `"ContextData"`: Contextual data about your user session, such as the device fingerprint,
  IP address, or location. Amazon Cognito advanced security evaluates the risk of an
  authentication event based on the context that your app generates and passes to Amazon
  Cognito when it makes API requests.
- `"Session"`: The session that should be passed both ways in challenge-response calls to
  the service. If an InitiateAuth or RespondToAuthChallenge API call determines that the
  caller must pass another challenge, it returns a session with other challenge parameters.
  This session should be passed as it is to the next RespondToAuthChallenge API call.
"""
function admin_respond_to_auth_challenge(
    ChallengeName, ClientId, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminRespondToAuthChallenge",
        Dict{String,Any}(
            "ChallengeName" => ChallengeName,
            "ClientId" => ClientId,
            "UserPoolId" => UserPoolId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_respond_to_auth_challenge(
    ChallengeName,
    ClientId,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminRespondToAuthChallenge",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChallengeName" => ChallengeName,
                    "ClientId" => ClientId,
                    "UserPoolId" => UserPoolId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_set_user_mfapreference(user_pool_id, username)
    admin_set_user_mfapreference(user_pool_id, username, params::Dict{String,<:Any})

The user's multi-factor authentication (MFA) preference, including which MFA options are
activated, and if any are preferred. Only one factor can be set as preferred. The preferred
MFA factor will be used to authenticate a user if multiple factors are activated. If
multiple options are activated and no preference is set, a challenge to choose an MFA
option will be returned during sign-in.  Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SMSMfaSettings"`: The SMS text message MFA settings.
- `"SoftwareTokenMfaSettings"`: The time-based one-time password software token MFA
  settings.
"""
function admin_set_user_mfapreference(
    UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminSetUserMFAPreference",
        Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_set_user_mfapreference(
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminSetUserMFAPreference",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_set_user_password(password, user_pool_id, username)
    admin_set_user_password(password, user_pool_id, username, params::Dict{String,<:Any})

Sets the specified user's password in a user pool as an administrator. Works on any user.
The password can be temporary or permanent. If it is temporary, the user status enters the
FORCE_CHANGE_PASSWORD state. When the user next tries to sign in, the
InitiateAuth/AdminInitiateAuth response will contain the NEW_PASSWORD_REQUIRED challenge.
If the user doesn't sign in before it expires, the user won't be able to sign in, and an
administrator must reset their password.  Once the user has set a new password, or the
password is permanent, the user status is set to Confirmed.  AdminSetUserPassword can set a
password for the user profile that Amazon Cognito creates for third-party federated users.
When you set a password, the federated user's status changes from EXTERNAL_PROVIDER to
CONFIRMED. A user in this state can sign in as a federated user, and initiate
authentication flows in the API like a linked native user. They can also modify their
password and attributes in token-authenticated API requests like ChangePassword and
UpdateUserAttributes. As a best security practice and to keep users in sync with your
external IdP, don't set passwords on federated user profiles. To set up a federated user
for native sign-in with a linked native user, refer to Linking federated users to an
existing user profile.  Amazon Cognito evaluates Identity and Access Management (IAM)
policies in requests for this API operation. For this operation, you must use IAM
credentials to authorize requests, and you must grant yourself the corresponding IAM
permission in a policy.  Learn more     Signing Amazon Web Services API Requests     Using
the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `password`: The password for the user.
- `user_pool_id`: The user pool ID for the user pool where you want to set the user's
  password.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Permanent"`:  True if the password is permanent, False if it is temporary.
"""
function admin_set_user_password(
    Password, UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminSetUserPassword",
        Dict{String,Any}(
            "Password" => Password, "UserPoolId" => UserPoolId, "Username" => Username
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_set_user_password(
    Password,
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminSetUserPassword",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Password" => Password,
                    "UserPoolId" => UserPoolId,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_set_user_settings(mfaoptions, user_pool_id, username)
    admin_set_user_settings(mfaoptions, user_pool_id, username, params::Dict{String,<:Any})

 This action is no longer supported. You can use it to configure only SMS MFA. You can't
use it to configure time-based one-time password (TOTP) software token MFA. To configure
either type of MFA, use AdminSetUserMFAPreference instead.  Amazon Cognito evaluates
Identity and Access Management (IAM) policies in requests for this API operation. For this
operation, you must use IAM credentials to authorize requests, and you must grant yourself
the corresponding IAM permission in a policy.  Learn more     Signing Amazon Web Services
API Requests     Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `mfaoptions`: You can use this parameter only to set an SMS configuration that uses SMS
  for delivery.
- `user_pool_id`: The ID of the user pool that contains the user whose options you're
  setting.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

"""
function admin_set_user_settings(
    MFAOptions, UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminSetUserSettings",
        Dict{String,Any}(
            "MFAOptions" => MFAOptions, "UserPoolId" => UserPoolId, "Username" => Username
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_set_user_settings(
    MFAOptions,
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminSetUserSettings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "MFAOptions" => MFAOptions,
                    "UserPoolId" => UserPoolId,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_update_auth_event_feedback(event_id, feedback_value, user_pool_id, username)
    admin_update_auth_event_feedback(event_id, feedback_value, user_pool_id, username, params::Dict{String,<:Any})

Provides feedback for an authentication event indicating if it was from a valid user. This
feedback is used for improving the risk evaluation decision for the user pool as part of
Amazon Cognito advanced security.  Amazon Cognito evaluates Identity and Access Management
(IAM) policies in requests for this API operation. For this operation, you must use IAM
credentials to authorize requests, and you must grant yourself the corresponding IAM
permission in a policy.  Learn more     Signing Amazon Web Services API Requests     Using
the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `event_id`: The authentication event ID.
- `feedback_value`: The authentication event feedback value. When you provide a
  FeedbackValue value of valid, you tell Amazon Cognito that you trust a user session where
  Amazon Cognito has evaluated some level of risk. When you provide a FeedbackValue value of
  invalid, you tell Amazon Cognito that you don't trust a user session, or you don't believe
  that Amazon Cognito evaluated a high-enough risk level.
- `user_pool_id`: The user pool ID.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

"""
function admin_update_auth_event_feedback(
    EventId,
    FeedbackValue,
    UserPoolId,
    Username;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminUpdateAuthEventFeedback",
        Dict{String,Any}(
            "EventId" => EventId,
            "FeedbackValue" => FeedbackValue,
            "UserPoolId" => UserPoolId,
            "Username" => Username,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_update_auth_event_feedback(
    EventId,
    FeedbackValue,
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminUpdateAuthEventFeedback",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EventId" => EventId,
                    "FeedbackValue" => FeedbackValue,
                    "UserPoolId" => UserPoolId,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_update_device_status(device_key, user_pool_id, username)
    admin_update_device_status(device_key, user_pool_id, username, params::Dict{String,<:Any})

Updates the device status as an administrator.  Amazon Cognito evaluates Identity and
Access Management (IAM) policies in requests for this API operation. For this operation,
you must use IAM credentials to authorize requests, and you must grant yourself the
corresponding IAM permission in a policy.  Learn more     Signing Amazon Web Services API
Requests     Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `device_key`: The device key.
- `user_pool_id`: The user pool ID.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeviceRememberedStatus"`: The status indicating whether a device has been remembered or
  not.
"""
function admin_update_device_status(
    DeviceKey, UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminUpdateDeviceStatus",
        Dict{String,Any}(
            "DeviceKey" => DeviceKey, "UserPoolId" => UserPoolId, "Username" => Username
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_update_device_status(
    DeviceKey,
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminUpdateDeviceStatus",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DeviceKey" => DeviceKey,
                    "UserPoolId" => UserPoolId,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_update_user_attributes(user_attributes, user_pool_id, username)
    admin_update_user_attributes(user_attributes, user_pool_id, username, params::Dict{String,<:Any})

 This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers
require you to register an origination phone number before you can send SMS messages to US
phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone
number with Amazon Pinpoint. Amazon Cognito uses the registered number automatically.
Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
activate their accounts, or sign in. If you have never used SMS text messages with Amazon
Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place
your account in the SMS sandbox. In  sandbox mode , you can send messages only to verified
phone numbers. After you test your app while in the sandbox environment, you can move out
of the sandbox and into production. For more information, see  SMS message settings for
Amazon Cognito user pools in the Amazon Cognito Developer Guide.  Updates the specified
user's attributes, including developer attributes, as an administrator. Works on any user.
To delete an attribute from your user, submit the attribute in your API request with a
blank value. For custom attributes, you must prepend the custom: prefix to the attribute
name. In addition to updating user attributes, this API can also be used to mark phone and
email as verified.  Amazon Cognito evaluates Identity and Access Management (IAM) policies
in requests for this API operation. For this operation, you must use IAM credentials to
authorize requests, and you must grant yourself the corresponding IAM permission in a
policy.  Learn more     Signing Amazon Web Services API Requests     Using the Amazon
Cognito user pools API and user pool endpoints

# Arguments
- `user_attributes`: An array of name-value pairs representing user attributes. For custom
  attributes, you must prepend the custom: prefix to the attribute name. If your user pool
  requires verification before Amazon Cognito updates an attribute value that you specify in
  this request, Amazon Cognito doesn’t immediately update the value of that attribute.
  After your user receives and responds to a verification message to verify the new value,
  Amazon Cognito updates the attribute value. Your user can sign in and receive messages with
  the original attribute value until they verify the new value. To update the value of an
  attribute that requires verification in the same API request, include the email_verified or
  phone_number_verified attribute, with a value of true. If you set the email_verified or
  phone_number_verified value for an email or phone_number attribute that requires
  verification to true, Amazon Cognito doesn’t send a verification message to your user.
- `user_pool_id`: The user pool ID for the user pool where you want to update user
  attributes.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for any
  custom workflows that this action triggers. You create custom workflows by assigning Lambda
  functions to user pool triggers. When you use the AdminUpdateUserAttributes API action,
  Amazon Cognito invokes the function that is assigned to the custom message trigger. When
  Amazon Cognito invokes this function, it passes a JSON payload, which the function receives
  as input. This payload contains a clientMetadata attribute, which provides the data that
  you assigned to the ClientMetadata parameter in your AdminUpdateUserAttributes request. In
  your function code in Lambda, you can process the clientMetadata value to enhance your
  workflow for your specific needs. For more information, see  Customizing user pool
  Workflows with Lambda Triggers in the Amazon Cognito Developer Guide.  When you use the
  ClientMetadata parameter, remember that Amazon Cognito won't do the following:   Store the
  ClientMetadata value. This data is available only to Lambda triggers that are assigned to a
  user pool to support custom workflows. If your user pool configuration doesn't include
  triggers, the ClientMetadata parameter serves no purpose.   Validate the ClientMetadata
  value.   Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive
  information.
"""
function admin_update_user_attributes(
    UserAttributes, UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminUpdateUserAttributes",
        Dict{String,Any}(
            "UserAttributes" => UserAttributes,
            "UserPoolId" => UserPoolId,
            "Username" => Username,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_update_user_attributes(
    UserAttributes,
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminUpdateUserAttributes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "UserAttributes" => UserAttributes,
                    "UserPoolId" => UserPoolId,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    admin_user_global_sign_out(user_pool_id, username)
    admin_user_global_sign_out(user_pool_id, username, params::Dict{String,<:Any})

Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user.
Call this operation with your administrative credentials when your user signs out of your
app. This results in the following behavior.    Amazon Cognito no longer accepts
token-authorized user operations that you authorize with a signed-out user's access tokens.
For more information, see Using the Amazon Cognito user pools API and user pool endpoints.
Amazon Cognito returns an Access Token has been revoked error when your app attempts to
authorize a user pools API request with a revoked access token that contains the scope
aws.cognito.signin.user.admin.   Amazon Cognito no longer accepts a signed-out user's ID
token in a GetId  request to an identity pool with ServerSideTokenCheck enabled for its
user pool IdP configuration in CognitoIdentityProvider.   Amazon Cognito no longer accepts
a signed-out user's refresh tokens in refresh requests.   Other requests might be valid
until your user's token expires.  Amazon Cognito evaluates Identity and Access Management
(IAM) policies in requests for this API operation. For this operation, you must use IAM
credentials to authorize requests, and you must grant yourself the corresponding IAM
permission in a policy.  Learn more     Signing Amazon Web Services API Requests     Using
the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

"""
function admin_user_global_sign_out(
    UserPoolId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AdminUserGlobalSignOut",
        Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function admin_user_global_sign_out(
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "AdminUserGlobalSignOut",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UserPoolId" => UserPoolId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_software_token()
    associate_software_token(params::Dict{String,<:Any})

Begins setup of time-based one-time password (TOTP) multi-factor authentication (MFA) for a
user, with a unique private key that Amazon Cognito generates and returns in the API
response. You can authorize an AssociateSoftwareToken request with either the user's access
token, or a session string from a challenge response that you received from Amazon Cognito.
 Amazon Cognito disassociates an existing software token when you verify the new token in a
 VerifySoftwareToken API request. If you don't verify the software token and your user pool
doesn't require MFA, the user can then authenticate with user name and password credentials
alone. If your user pool requires TOTP MFA, Amazon Cognito generates an MFA_SETUP or
SOFTWARE_TOKEN_SETUP challenge each time your user signs. Complete setup with
AssociateSoftwareToken and VerifySoftwareToken. After you set up software token MFA for
your user, Amazon Cognito generates a SOFTWARE_TOKEN_MFA challenge when they authenticate.
Respond to this challenge with your user's TOTP.   Amazon Cognito doesn't evaluate Identity
and Access Management (IAM) policies in requests for this API operation. For this
operation, you can't use IAM credentials to authorize requests, and you can't grant IAM
permissions in policies. For more information about authorization models in Amazon Cognito,
see Using the Amazon Cognito user pools API and user pool endpoints.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessToken"`: A valid access token that Amazon Cognito issued to the user whose
  software token you want to generate.
- `"Session"`: The session that should be passed both ways in challenge-response calls to
  the service. This allows authentication of the user as part of the MFA setup process.
"""
function associate_software_token(; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "AssociateSoftwareToken"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function associate_software_token(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "AssociateSoftwareToken",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    change_password(access_token, previous_password, proposed_password)
    change_password(access_token, previous_password, proposed_password, params::Dict{String,<:Any})

Changes the password for a specified user in a user pool. Authorize this action with a
signed-in user's access token. It must include the scope aws.cognito.signin.user.admin.
Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests
for this API operation. For this operation, you can't use IAM credentials to authorize
requests, and you can't grant IAM permissions in policies. For more information about
authorization models in Amazon Cognito, see Using the Amazon Cognito user pools API and
user pool endpoints.

# Arguments
- `access_token`: A valid access token that Amazon Cognito issued to the user whose
  password you want to change.
- `previous_password`: The old password.
- `proposed_password`: The new password.

"""
function change_password(
    AccessToken,
    PreviousPassword,
    ProposedPassword;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ChangePassword",
        Dict{String,Any}(
            "AccessToken" => AccessToken,
            "PreviousPassword" => PreviousPassword,
            "ProposedPassword" => ProposedPassword,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function change_password(
    AccessToken,
    PreviousPassword,
    ProposedPassword,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ChangePassword",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccessToken" => AccessToken,
                    "PreviousPassword" => PreviousPassword,
                    "ProposedPassword" => ProposedPassword,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    confirm_device(access_token, device_key)
    confirm_device(access_token, device_key, params::Dict{String,<:Any})

Confirms tracking of the device. This API call is the call that begins device tracking. For
more information about device authentication, see Working with user devices in your user
pool. Authorize this action with a signed-in user's access token. It must include the scope
aws.cognito.signin.user.admin.  Amazon Cognito doesn't evaluate Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you can't
use IAM credentials to authorize requests, and you can't grant IAM permissions in policies.
For more information about authorization models in Amazon Cognito, see Using the Amazon
Cognito user pools API and user pool endpoints.

# Arguments
- `access_token`: A valid access token that Amazon Cognito issued to the user whose device
  you want to confirm.
- `device_key`: The device key.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeviceName"`: The device name.
- `"DeviceSecretVerifierConfig"`: The configuration of the device secret verifier.
"""
function confirm_device(
    AccessToken, DeviceKey; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "ConfirmDevice",
        Dict{String,Any}("AccessToken" => AccessToken, "DeviceKey" => DeviceKey);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function confirm_device(
    AccessToken,
    DeviceKey,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ConfirmDevice",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccessToken" => AccessToken, "DeviceKey" => DeviceKey),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    confirm_forgot_password(client_id, confirmation_code, password, username)
    confirm_forgot_password(client_id, confirmation_code, password, username, params::Dict{String,<:Any})

Allows a user to enter a confirmation code to reset a forgotten password.  Amazon Cognito
doesn't evaluate Identity and Access Management (IAM) policies in requests for this API
operation. For this operation, you can't use IAM credentials to authorize requests, and you
can't grant IAM permissions in policies. For more information about authorization models in
Amazon Cognito, see Using the Amazon Cognito user pools API and user pool endpoints.

# Arguments
- `client_id`: The app client ID of the app associated with the user pool.
- `confirmation_code`: The confirmation code from your user's request to reset their
  password. For more information, see ForgotPassword.
- `password`: The new password that your user wants to set.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnalyticsMetadata"`: The Amazon Pinpoint analytics metadata for collecting metrics for
  ConfirmForgotPassword calls.
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for any
  custom workflows that this action triggers. You create custom workflows by assigning Lambda
  functions to user pool triggers. When you use the ConfirmForgotPassword API action, Amazon
  Cognito invokes the function that is assigned to the post confirmation trigger. When Amazon
  Cognito invokes this function, it passes a JSON payload, which the function receives as
  input. This payload contains a clientMetadata attribute, which provides the data that you
  assigned to the ClientMetadata parameter in your ConfirmForgotPassword request. In your
  function code in Lambda, you can process the clientMetadata value to enhance your workflow
  for your specific needs. For more information, see  Customizing user pool Workflows with
  Lambda Triggers in the Amazon Cognito Developer Guide.  When you use the ClientMetadata
  parameter, remember that Amazon Cognito won't do the following:   Store the ClientMetadata
  value. This data is available only to Lambda triggers that are assigned to a user pool to
  support custom workflows. If your user pool configuration doesn't include triggers, the
  ClientMetadata parameter serves no purpose.   Validate the ClientMetadata value.   Encrypt
  the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
- `"SecretHash"`: A keyed-hash message authentication code (HMAC) calculated using the
  secret key of a user pool client and username plus the client ID in the message. For more
  information about SecretHash, see Computing secret hash values.
- `"UserContextData"`: Contextual data about your user session, such as the device
  fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk
  of an authentication event based on the context that your app generates and passes to
  Amazon Cognito when it makes API requests.
"""
function confirm_forgot_password(
    ClientId,
    ConfirmationCode,
    Password,
    Username;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ConfirmForgotPassword",
        Dict{String,Any}(
            "ClientId" => ClientId,
            "ConfirmationCode" => ConfirmationCode,
            "Password" => Password,
            "Username" => Username,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function confirm_forgot_password(
    ClientId,
    ConfirmationCode,
    Password,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ConfirmForgotPassword",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientId" => ClientId,
                    "ConfirmationCode" => ConfirmationCode,
                    "Password" => Password,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    confirm_sign_up(client_id, confirmation_code, username)
    confirm_sign_up(client_id, confirmation_code, username, params::Dict{String,<:Any})

This public API operation provides a code that Amazon Cognito sent to your user when they
signed up in your user pool via the SignUp API operation. After your user enters their
code, they confirm ownership of the email address or phone number that they provided, and
their user account becomes active. Depending on your user pool configuration, your users
will receive their confirmation code in an email or SMS message. Local users who signed up
in your user pool are the only type of user who can confirm sign-up with a code. Users who
federate through an external identity provider (IdP) have already been confirmed by their
IdP. Administrator-created users, users created with the AdminCreateUser API operation,
confirm their accounts when they respond to their invitation email message and choose a
password. They do not receive a confirmation code. Instead, they receive a temporary
password.  Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in
requests for this API operation. For this operation, you can't use IAM credentials to
authorize requests, and you can't grant IAM permissions in policies. For more information
about authorization models in Amazon Cognito, see Using the Amazon Cognito user pools API
and user pool endpoints.

# Arguments
- `client_id`: The ID of the app client associated with the user pool.
- `confirmation_code`: The confirmation code sent by a user's request to confirm
  registration.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnalyticsMetadata"`: The Amazon Pinpoint analytics metadata for collecting metrics for
  ConfirmSignUp calls.
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for any
  custom workflows that this action triggers. You create custom workflows by assigning Lambda
  functions to user pool triggers. When you use the ConfirmSignUp API action, Amazon Cognito
  invokes the function that is assigned to the post confirmation trigger. When Amazon Cognito
  invokes this function, it passes a JSON payload, which the function receives as input. This
  payload contains a clientMetadata attribute, which provides the data that you assigned to
  the ClientMetadata parameter in your ConfirmSignUp request. In your function code in
  Lambda, you can process the clientMetadata value to enhance your workflow for your specific
  needs. For more information, see  Customizing user pool Workflows with Lambda Triggers in
  the Amazon Cognito Developer Guide.  When you use the ClientMetadata parameter, remember
  that Amazon Cognito won't do the following:   Store the ClientMetadata value. This data is
  available only to Lambda triggers that are assigned to a user pool to support custom
  workflows. If your user pool configuration doesn't include triggers, the ClientMetadata
  parameter serves no purpose.   Validate the ClientMetadata value.   Encrypt the
  ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
- `"ForceAliasCreation"`: Boolean to be specified to force user confirmation irrespective
  of existing alias. By default set to False. If this parameter is set to True and the phone
  number/email used for sign up confirmation already exists as an alias with a different
  user, the API call will migrate the alias from the previous user to the newly created user
  being confirmed. If set to False, the API will throw an AliasExistsException error.
- `"SecretHash"`: A keyed-hash message authentication code (HMAC) calculated using the
  secret key of a user pool client and username plus the client ID in the message.
- `"UserContextData"`: Contextual data about your user session, such as the device
  fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk
  of an authentication event based on the context that your app generates and passes to
  Amazon Cognito when it makes API requests.
"""
function confirm_sign_up(
    ClientId, ConfirmationCode, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "ConfirmSignUp",
        Dict{String,Any}(
            "ClientId" => ClientId,
            "ConfirmationCode" => ConfirmationCode,
            "Username" => Username,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function confirm_sign_up(
    ClientId,
    ConfirmationCode,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ConfirmSignUp",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientId" => ClientId,
                    "ConfirmationCode" => ConfirmationCode,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_group(group_name, user_pool_id)
    create_group(group_name, user_pool_id, params::Dict{String,<:Any})

Creates a new group in the specified user pool.  Amazon Cognito evaluates Identity and
Access Management (IAM) policies in requests for this API operation. For this operation,
you must use IAM credentials to authorize requests, and you must grant yourself the
corresponding IAM permission in a policy.  Learn more     Signing Amazon Web Services API
Requests     Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `group_name`: The name of the group. Must be unique.
- `user_pool_id`: The user pool ID for the user pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A string containing the description of the group.
- `"Precedence"`: A non-negative integer value that specifies the precedence of this group
  relative to the other groups that a user can belong to in the user pool. Zero is the
  highest precedence value. Groups with lower Precedence values take precedence over groups
  with higher or null Precedence values. If a user belongs to two or more groups, it is the
  group with the lowest precedence value whose role ARN is given in the user's tokens for the
  cognito:roles and cognito:preferred_role claims. Two groups can have the same Precedence
  value. If this happens, neither group takes precedence over the other. If two groups with
  the same Precedence have the same role ARN, that role is used in the cognito:preferred_role
  claim in tokens for users in each group. If the two groups have different role ARNs, the
  cognito:preferred_role claim isn't set in users' tokens. The default Precedence value is
  null. The maximum Precedence value is 2^31-1.
- `"RoleArn"`: The role Amazon Resource Name (ARN) for the group.
"""
function create_group(
    GroupName, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "CreateGroup",
        Dict{String,Any}("GroupName" => GroupName, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_group(
    GroupName,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "CreateGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupName" => GroupName, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_identity_provider(provider_details, provider_name, provider_type, user_pool_id)
    create_identity_provider(provider_details, provider_name, provider_type, user_pool_id, params::Dict{String,<:Any})

Adds a configuration and trust relationship between a third-party identity provider (IdP)
and a user pool.  Amazon Cognito evaluates Identity and Access Management (IAM) policies in
requests for this API operation. For this operation, you must use IAM credentials to
authorize requests, and you must grant yourself the corresponding IAM permission in a
policy.  Learn more     Signing Amazon Web Services API Requests     Using the Amazon
Cognito user pools API and user pool endpoints

# Arguments
- `provider_details`: The scopes, URLs, and identifiers for your external identity
  provider. The following examples describe the provider detail keys for each IdP type. These
  values and their schema are subject to change. Social IdP authorize_scopes values must
  match the values listed here.  OpenID Connect (OIDC)  Amazon Cognito accepts the following
  elements when it can't discover endpoint URLs from oidc_issuer: attributes_url,
  authorize_url, jwks_uri, token_url. Create or update request: \"ProviderDetails\": {
  \"attributes_request_method\": \"GET\", \"attributes_url\":
  \"https://auth.example.com/userInfo\", \"authorize_scopes\": \"openid profile email\",
  \"authorize_url\": \"https://auth.example.com/authorize\", \"client_id\":
  \"1example23456789\", \"client_secret\": \"provider-app-client-secret\", \"jwks_uri\":
  \"https://auth.example.com/.well-known/jwks.json\", \"oidc_issuer\":
  \"https://auth.example.com\", \"token_url\": \"https://example.com/token\" }  Describe
  response: \"ProviderDetails\": { \"attributes_request_method\": \"GET\",
  \"attributes_url\": \"https://auth.example.com/userInfo\",
  \"attributes_url_add_attributes\": \"false\", \"authorize_scopes\": \"openid profile
  email\", \"authorize_url\": \"https://auth.example.com/authorize\", \"client_id\":
  \"1example23456789\", \"client_secret\": \"provider-app-client-secret\", \"jwks_uri\":
  \"https://auth.example.com/.well-known/jwks.json\", \"oidc_issuer\":
  \"https://auth.example.com\", \"token_url\": \"https://example.com/token\" }   SAML  Create
  or update request with Metadata URL: \"ProviderDetails\": { \"IDPInit\": \"true\",
  \"IDPSignout\": \"true\", \"EncryptedResponses\" : \"true\", \"MetadataURL\":
  \"https://auth.example.com/sso/saml/metadata\", \"RequestSigningAlgorithm\": \"rsa-sha256\"
  }  Create or update request with Metadata file: \"ProviderDetails\": { \"IDPInit\":
  \"true\", \"IDPSignout\": \"true\", \"EncryptedResponses\" : \"true\", \"MetadataFile\":
  \"[metadata XML]\", \"RequestSigningAlgorithm\": \"rsa-sha256\" }  The value of
  MetadataFile must be the plaintext metadata document with all quote (\") characters escaped
  by backslashes. Describe response: \"ProviderDetails\": { \"IDPInit\": \"true\",
  \"IDPSignout\": \"true\", \"EncryptedResponses\" : \"true\",
  \"ActiveEncryptionCertificate\": \"[certificate]\", \"MetadataURL\":
  \"https://auth.example.com/sso/saml/metadata\", \"RequestSigningAlgorithm\":
  \"rsa-sha256\", \"SLORedirectBindingURI\": \"https://auth.example.com/slo/saml\",
  \"SSORedirectBindingURI\": \"https://auth.example.com/sso/saml\" }   LoginWithAmazon
  Create or update request: \"ProviderDetails\": { \"authorize_scopes\": \"profile
  postal_code\", \"client_id\": \"amzn1.application-oa2-client.1example23456789\",
  \"client_secret\": \"provider-app-client-secret\"  Describe response: \"ProviderDetails\":
  { \"attributes_url\": \"https://api.amazon.com/user/profile\",
  \"attributes_url_add_attributes\": \"false\", \"authorize_scopes\": \"profile
  postal_code\", \"authorize_url\": \"https://www.amazon.com/ap/oa\", \"client_id\":
  \"amzn1.application-oa2-client.1example23456789\", \"client_secret\":
  \"provider-app-client-secret\", \"token_request_method\": \"POST\", \"token_url\":
  \"https://api.amazon.com/auth/o2/token\" }   Google  Create or update request:
  \"ProviderDetails\": { \"authorize_scopes\": \"email profile openid\", \"client_id\":
  \"1example23456789.apps.googleusercontent.com\", \"client_secret\":
  \"provider-app-client-secret\" }  Describe response: \"ProviderDetails\": {
  \"attributes_url\": \"https://people.googleapis.com/v1/people/me?personFields=\",
  \"attributes_url_add_attributes\": \"true\", \"authorize_scopes\": \"email profile
  openid\", \"authorize_url\": \"https://accounts.google.com/o/oauth2/v2/auth\",
  \"client_id\": \"1example23456789.apps.googleusercontent.com\", \"client_secret\":
  \"provider-app-client-secret\", \"oidc_issuer\": \"https://accounts.google.com\",
  \"token_request_method\": \"POST\", \"token_url\":
  \"https://www.googleapis.com/oauth2/v4/token\" }   SignInWithApple  Create or update
  request: \"ProviderDetails\": { \"authorize_scopes\": \"email name\", \"client_id\":
  \"com.example.cognito\", \"private_key\": \"1EXAMPLE\", \"key_id\": \"2EXAMPLE\",
  \"team_id\": \"3EXAMPLE\" }  Describe response: \"ProviderDetails\": {
  \"attributes_url_add_attributes\": \"false\", \"authorize_scopes\": \"email name\",
  \"authorize_url\": \"https://appleid.apple.com/auth/authorize\", \"client_id\":
  \"com.example.cognito\", \"key_id\": \"1EXAMPLE\", \"oidc_issuer\":
  \"https://appleid.apple.com\", \"team_id\": \"2EXAMPLE\", \"token_request_method\":
  \"POST\", \"token_url\": \"https://appleid.apple.com/auth/token\" }   Facebook  Create or
  update request: \"ProviderDetails\": { \"api_version\": \"v17.0\", \"authorize_scopes\":
  \"public_profile, email\", \"client_id\": \"1example23456789\", \"client_secret\":
  \"provider-app-client-secret\" }  Describe response: \"ProviderDetails\": {
  \"api_version\": \"v17.0\", \"attributes_url\":
  \"https://graph.facebook.com/v17.0/me?fields=\", \"attributes_url_add_attributes\":
  \"true\", \"authorize_scopes\": \"public_profile, email\", \"authorize_url\":
  \"https://www.facebook.com/v17.0/dialog/oauth\", \"client_id\": \"1example23456789\",
  \"client_secret\": \"provider-app-client-secret\", \"token_request_method\": \"GET\",
  \"token_url\": \"https://graph.facebook.com/v17.0/oauth/access_token\" }
- `provider_name`: The IdP name.
- `provider_type`: The IdP type.
- `user_pool_id`: The user pool ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributeMapping"`: A mapping of IdP attributes to standard and custom user pool
  attributes.
- `"IdpIdentifiers"`: A list of IdP identifiers.
"""
function create_identity_provider(
    ProviderDetails,
    ProviderName,
    ProviderType,
    UserPoolId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "CreateIdentityProvider",
        Dict{String,Any}(
            "ProviderDetails" => ProviderDetails,
            "ProviderName" => ProviderName,
            "ProviderType" => ProviderType,
            "UserPoolId" => UserPoolId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_identity_provider(
    ProviderDetails,
    ProviderName,
    ProviderType,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "CreateIdentityProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ProviderDetails" => ProviderDetails,
                    "ProviderName" => ProviderName,
                    "ProviderType" => ProviderType,
                    "UserPoolId" => UserPoolId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_resource_server(identifier, name, user_pool_id)
    create_resource_server(identifier, name, user_pool_id, params::Dict{String,<:Any})

Creates a new OAuth2.0 resource server and defines custom scopes within it.  Amazon Cognito
evaluates Identity and Access Management (IAM) policies in requests for this API operation.
For this operation, you must use IAM credentials to authorize requests, and you must grant
yourself the corresponding IAM permission in a policy.  Learn more     Signing Amazon Web
Services API Requests     Using the Amazon Cognito user pools API and user pool endpoints


# Arguments
- `identifier`: A unique resource server identifier for the resource server. The identifier
  can be an API friendly name like solar-system-data. You can also set an API URL like
  https://solar-system-data-api.example.com as your identifier. Amazon Cognito represents
  scopes in the access token in the format resource-server-identifier/scope. Longer
  scope-identifier strings increase the size of your access tokens.
- `name`: A friendly name for the resource server.
- `user_pool_id`: The user pool ID for the user pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Scopes"`: A list of scopes. Each scope is a key-value map with the keys name and
  description.
"""
function create_resource_server(
    Identifier, Name, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "CreateResourceServer",
        Dict{String,Any}(
            "Identifier" => Identifier, "Name" => Name, "UserPoolId" => UserPoolId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_resource_server(
    Identifier,
    Name,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "CreateResourceServer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Identifier" => Identifier, "Name" => Name, "UserPoolId" => UserPoolId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_user_import_job(cloud_watch_logs_role_arn, job_name, user_pool_id)
    create_user_import_job(cloud_watch_logs_role_arn, job_name, user_pool_id, params::Dict{String,<:Any})

Creates a user import job.  Amazon Cognito evaluates Identity and Access Management (IAM)
policies in requests for this API operation. For this operation, you must use IAM
credentials to authorize requests, and you must grant yourself the corresponding IAM
permission in a policy.  Learn more     Signing Amazon Web Services API Requests     Using
the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `cloud_watch_logs_role_arn`: The role ARN for the Amazon CloudWatch Logs Logging role for
  the user import job.
- `job_name`: The job name for the user import job.
- `user_pool_id`: The user pool ID for the user pool that the users are being imported into.

"""
function create_user_import_job(
    CloudWatchLogsRoleArn,
    JobName,
    UserPoolId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "CreateUserImportJob",
        Dict{String,Any}(
            "CloudWatchLogsRoleArn" => CloudWatchLogsRoleArn,
            "JobName" => JobName,
            "UserPoolId" => UserPoolId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user_import_job(
    CloudWatchLogsRoleArn,
    JobName,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "CreateUserImportJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CloudWatchLogsRoleArn" => CloudWatchLogsRoleArn,
                    "JobName" => JobName,
                    "UserPoolId" => UserPoolId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_user_pool(pool_name)
    create_user_pool(pool_name, params::Dict{String,<:Any})

 This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers
require you to register an origination phone number before you can send SMS messages to US
phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone
number with Amazon Pinpoint. Amazon Cognito uses the registered number automatically.
Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
activate their accounts, or sign in. If you have never used SMS text messages with Amazon
Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place
your account in the SMS sandbox. In  sandbox mode , you can send messages only to verified
phone numbers. After you test your app while in the sandbox environment, you can move out
of the sandbox and into production. For more information, see  SMS message settings for
Amazon Cognito user pools in the Amazon Cognito Developer Guide.  Creates a new Amazon
Cognito user pool and sets the password policy for the pool.  If you don't provide a value
for an attribute, Amazon Cognito sets it to its default value.   Amazon Cognito evaluates
Identity and Access Management (IAM) policies in requests for this API operation. For this
operation, you must use IAM credentials to authorize requests, and you must grant yourself
the corresponding IAM permission in a policy.  Learn more     Signing Amazon Web Services
API Requests     Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `pool_name`: A string used to name the user pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountRecoverySetting"`: The available verified method a user can use to recover their
  password when they call ForgotPassword. You can use this setting to define a preferred
  method when a user has more than one method available. With this setting, SMS doesn't
  qualify for a valid password recovery mechanism if the user also has SMS multi-factor
  authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the
  legacy behavior to determine the recovery method where SMS is preferred through email.
- `"AdminCreateUserConfig"`: The configuration for AdminCreateUser requests.
- `"AliasAttributes"`: Attributes supported as an alias for this user pool. Possible
  values: phone_number, email, or preferred_username.
- `"AutoVerifiedAttributes"`: The attributes to be auto-verified. Possible values: email,
  phone_number.
- `"DeletionProtection"`: When active, DeletionProtection prevents accidental deletion of
  your user pool. Before you can delete a user pool that you have protected against deletion,
  you must deactivate this feature. When you try to delete a protected user pool in a
  DeleteUserPool API request, Amazon Cognito returns an InvalidParameterException error. To
  delete a protected user pool, send a new DeleteUserPool request after you deactivate
  deletion protection in an UpdateUserPool API request.
- `"DeviceConfiguration"`: The device-remembering configuration for a user pool. A null
  value indicates that you have deactivated device remembering in your user pool.  When you
  provide a value for any DeviceConfiguration field, you activate the Amazon Cognito
  device-remembering feature.
- `"EmailConfiguration"`: The email configuration of your user pool. The email
  configuration type sets your preferred sending method, Amazon Web Services Region, and
  sender for messages from your user pool.
- `"EmailVerificationMessage"`: This parameter is no longer used. See
  VerificationMessageTemplateType.
- `"EmailVerificationSubject"`: This parameter is no longer used. See
  VerificationMessageTemplateType.
- `"LambdaConfig"`: The Lambda trigger configuration information for the new user pool.  In
  a push model, event sources (such as Amazon S3 and custom applications) need permission to
  invoke a function. So you must make an extra call to add permission for these event sources
  to invoke your Lambda function.  For more information on using the Lambda API to add
  permission, see AddPermission .  For adding permission using the CLI, see add-permission .
- `"MfaConfiguration"`: Specifies MFA configuration details.
- `"Policies"`: The policies associated with the new user pool.
- `"Schema"`: An array of schema attributes for the new user pool. These attributes can be
  standard or custom attributes.
- `"SmsAuthenticationMessage"`: A string representing the SMS authentication message.
- `"SmsConfiguration"`: The SMS configuration with the settings that your Amazon Cognito
  user pool must use to send an SMS message from your Amazon Web Services account through
  Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web
  Services Region that you want, the Amazon Cognito user pool uses an Identity and Access
  Management (IAM) role in your Amazon Web Services account.
- `"SmsVerificationMessage"`: This parameter is no longer used. See
  VerificationMessageTemplateType.
- `"UserAttributeUpdateSettings"`: The settings for updates to user attributes. These
  settings include the property AttributesRequireVerificationBeforeUpdate, a user-pool
  setting that tells Amazon Cognito how to handle changes to the value of your users' email
  address and phone number attributes. For more information, see  Verifying updates to email
  addresses and phone numbers.
- `"UserPoolAddOns"`: User pool add-ons. Contains settings for activation of advanced
  security features. To log user security information but take no action, set to AUDIT. To
  configure automatic security responses to risky traffic to your user pool, set to ENFORCED.
  For more information, see Adding advanced security to a user pool.
- `"UserPoolTags"`: The tag keys and values to assign to the user pool. A tag is a label
  that you can use to categorize and manage user pools in different ways, such as by purpose,
  owner, environment, or other criteria.
- `"UsernameAttributes"`: Specifies whether a user can use an email address or phone number
  as a username when they sign up.
- `"UsernameConfiguration"`: Case sensitivity on the username input for the selected
  sign-in option. When case sensitivity is set to False (case insensitive), users can sign in
  with any combination of capital and lowercase letters. For example, username, USERNAME, or
  UserName, or for email, email@example.com or EMaiL@eXamplE.Com. For most use cases, set
  case sensitivity to False (case insensitive) as a best practice. When usernames and email
  addresses are case insensitive, Amazon Cognito treats any variation in case as the same
  user, and prevents a case variation from being assigned to the same attribute for a
  different user. This configuration is immutable after you set it. For more information, see
  UsernameConfigurationType.
- `"VerificationMessageTemplate"`: The template for the verification message that the user
  sees when the app requests permission to access the user's information.
"""
function create_user_pool(PoolName; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "CreateUserPool",
        Dict{String,Any}("PoolName" => PoolName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user_pool(
    PoolName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "CreateUserPool",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PoolName" => PoolName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_user_pool_client(client_name, user_pool_id)
    create_user_pool_client(client_name, user_pool_id, params::Dict{String,<:Any})

Creates the user pool client. When you create a new user pool client, token revocation is
automatically activated. For more information about revoking tokens, see RevokeToken.  If
you don't provide a value for an attribute, Amazon Cognito sets it to its default value.
Amazon Cognito evaluates Identity and Access Management (IAM) policies in requests for this
API operation. For this operation, you must use IAM credentials to authorize requests, and
you must grant yourself the corresponding IAM permission in a policy.  Learn more
Signing Amazon Web Services API Requests     Using the Amazon Cognito user pools API and
user pool endpoints

# Arguments
- `client_name`: The client name for the user pool client you would like to create.
- `user_pool_id`: The user pool ID for the user pool where you want to create a user pool
  client.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessTokenValidity"`: The access token time limit. After this limit expires, your user
  can't use their access token. To specify the time unit for AccessTokenValidity as seconds,
  minutes, hours, or days, set a TokenValidityUnits value in your API request. For example,
  when you set AccessTokenValidity to 10 and TokenValidityUnits to hours, your user can
  authorize access with their access token for 10 hours. The default time unit for
  AccessTokenValidity in an API request is hours. Valid range is displayed below in seconds.
  If you don't specify otherwise in the configuration of your app client, your access tokens
  are valid for one hour.
- `"AllowedOAuthFlows"`: The OAuth grant types that you want your app client to generate.
  To create an app client that generates client credentials grants, you must add
  client_credentials as the only allowed OAuth flow.  code  Use a code grant flow, which
  provides an authorization code as the response. This code can be exchanged for access
  tokens with the /oauth2/token endpoint.  implicit  Issue the access token (and, optionally,
  ID token, based on scopes) directly to your user.  client_credentials  Issue the access
  token from the /oauth2/token endpoint directly to a non-person user using a combination of
  the client ID and client secret.
- `"AllowedOAuthFlowsUserPoolClient"`: Set to true to use OAuth 2.0 features in your user
  pool app client.  AllowedOAuthFlowsUserPoolClient must be true before you can configure the
  following features in your app client.    CallBackURLs: Callback URLs.    LogoutURLs:
  Sign-out redirect URLs.    AllowedOAuthScopes: OAuth 2.0 scopes.    AllowedOAuthFlows:
  Support for authorization code, implicit, and client credentials OAuth 2.0 grants.   To use
  OAuth 2.0 features, configure one of these features in the Amazon Cognito console or set
  AllowedOAuthFlowsUserPoolClient to true in a CreateUserPoolClient or UpdateUserPoolClient
  API request. If you don't set a value for AllowedOAuthFlowsUserPoolClient in a request with
  the CLI or SDKs, it defaults to false.
- `"AllowedOAuthScopes"`: The allowed OAuth scopes. Possible values provided by OAuth are
  phone, email, openid, and profile. Possible values provided by Amazon Web Services are
  aws.cognito.signin.user.admin. Custom scopes created in Resource Servers are also supported.
- `"AnalyticsConfiguration"`: The user pool analytics configuration for collecting metrics
  and sending them to your Amazon Pinpoint campaign.  In Amazon Web Services Regions where
  Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint
  projects in Amazon Web Services Region us-east-1. In Regions where Amazon Pinpoint is
  available, user pools support sending events to Amazon Pinpoint projects within that same
  Region.
- `"AuthSessionValidity"`: Amazon Cognito creates a session token for each API request in
  an authentication flow. AuthSessionValidity is the duration, in minutes, of that session
  token. Your user pool native user must respond to each authentication challenge before the
  session expires.
- `"CallbackURLs"`: A list of allowed redirect (callback) URLs for the IdPs. A redirect URI
  must:   Be an absolute URI.   Be registered with the authorization server.   Not include a
  fragment component.   See OAuth 2.0 - Redirection Endpoint. Amazon Cognito requires HTTPS
  over HTTP except for http://localhost for testing purposes only. App callback URLs such as
  myapp://example are also supported.
- `"DefaultRedirectURI"`: The default redirect URI. In app clients with one assigned IdP,
  replaces redirect_uri in authentication requests. Must be in the CallbackURLs list. A
  redirect URI must:   Be an absolute URI.   Be registered with the authorization server.
  Not include a fragment component.   For more information, see Default redirect URI. Amazon
  Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only. App
  callback URLs such as myapp://example are also supported.
- `"EnablePropagateAdditionalUserContextData"`: Activates the propagation of additional
  user context data. For more information about propagation of user context data, see  Adding
  advanced security to a user pool. If you don’t include this parameter, you can't send
  device fingerprint information, including source IP address, to Amazon Cognito advanced
  security. You can only activate EnablePropagateAdditionalUserContextData in an app client
  that has a client secret.
- `"EnableTokenRevocation"`: Activates or deactivates token revocation. For more
  information about revoking tokens, see RevokeToken. If you don't include this parameter,
  token revocation is automatically activated for the new user pool client.
- `"ExplicitAuthFlows"`: The authentication flows that you want your user pool client to
  support. For each app client in your user pool, you can sign in your users with any
  combination of one or more flows, including with a user name and Secure Remote Password
  (SRP), a user name and password, or a custom authentication process that you define with
  Lambda functions.  If you don't specify a value for ExplicitAuthFlows, your user client
  supports ALLOW_REFRESH_TOKEN_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_CUSTOM_AUTH.  Valid
  values include:    ALLOW_ADMIN_USER_PASSWORD_AUTH: Enable admin based user password
  authentication flow ADMIN_USER_PASSWORD_AUTH. This setting replaces the ADMIN_NO_SRP_AUTH
  setting. With this authentication flow, your app passes a user name and password to Amazon
  Cognito in the request, instead of using the Secure Remote Password (SRP) protocol to
  securely transmit the password.    ALLOW_CUSTOM_AUTH: Enable Lambda trigger based
  authentication.    ALLOW_USER_PASSWORD_AUTH: Enable user password-based authentication. In
  this flow, Amazon Cognito receives the password in the request instead of using the SRP
  protocol to verify passwords.    ALLOW_USER_SRP_AUTH: Enable SRP-based authentication.
  ALLOW_REFRESH_TOKEN_AUTH: Enable authflow to refresh tokens.   In some environments, you
  will see the values ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, or USER_PASSWORD_AUTH. You
  can't assign these legacy ExplicitAuthFlows values to user pool clients at the same time as
  values that begin with ALLOW_, like ALLOW_USER_SRP_AUTH.
- `"GenerateSecret"`: Boolean to specify whether you want to generate a secret for the user
  pool client being created.
- `"IdTokenValidity"`: The ID token time limit. After this limit expires, your user can't
  use their ID token. To specify the time unit for IdTokenValidity as seconds, minutes,
  hours, or days, set a TokenValidityUnits value in your API request. For example, when you
  set IdTokenValidity as 10 and TokenValidityUnits as hours, your user can authenticate their
  session with their ID token for 10 hours. The default time unit for IdTokenValidity in an
  API request is hours. Valid range is displayed below in seconds. If you don't specify
  otherwise in the configuration of your app client, your ID tokens are valid for one hour.
- `"LogoutURLs"`: A list of allowed logout URLs for the IdPs.
- `"PreventUserExistenceErrors"`: Errors and responses that you want Amazon Cognito APIs to
  return during authentication, account confirmation, and password recovery when the user
  doesn't exist in the user pool. When set to ENABLED and the user doesn't exist,
  authentication returns an error indicating either the username or password was incorrect.
  Account confirmation and password recovery return a response indicating a code was sent to
  a simulated destination. When set to LEGACY, those APIs return a UserNotFoundException
  exception if the user doesn't exist in the user pool. Valid values include:    ENABLED -
  This prevents user existence-related errors.    LEGACY - This represents the early behavior
  of Amazon Cognito where user existence related errors aren't prevented.
- `"ReadAttributes"`: The list of user attributes that you want your app client to have
  read-only access to. After your user authenticates in your app, their access token
  authorizes them to read their own attribute value for any attribute in this list. An
  example of this kind of activity is when your user selects a link to view their profile
  information. Your app makes a GetUser API request to retrieve and display your user's
  profile data. When you don't specify the ReadAttributes for your app client, your app can
  read the values of email_verified, phone_number_verified, and the Standard attributes of
  your user pool. When your user pool has read access to these default attributes,
  ReadAttributes doesn't return any information. Amazon Cognito only populates ReadAttributes
  in the API response if you have specified your own custom set of read attributes.
- `"RefreshTokenValidity"`: The refresh token time limit. After this limit expires, your
  user can't use their refresh token. To specify the time unit for RefreshTokenValidity as
  seconds, minutes, hours, or days, set a TokenValidityUnits value in your API request. For
  example, when you set RefreshTokenValidity as 10 and TokenValidityUnits as days, your user
  can refresh their session and retrieve new access and ID tokens for 10 days. The default
  time unit for RefreshTokenValidity in an API request is days. You can't set
  RefreshTokenValidity to 0. If you do, Amazon Cognito overrides the value with the default
  value of 30 days. Valid range is displayed below in seconds. If you don't specify otherwise
  in the configuration of your app client, your refresh tokens are valid for 30 days.
- `"SupportedIdentityProviders"`: A list of provider names for the identity providers
  (IdPs) that are supported on this client. The following are supported: COGNITO, Facebook,
  Google, SignInWithApple, and LoginWithAmazon. You can also specify the names that you
  configured for the SAML and OIDC IdPs in your user pool, for example MySAMLIdP or MyOIDCIdP.
- `"TokenValidityUnits"`: The units in which the validity times are represented. The
  default unit for RefreshToken is days, and default for ID and access tokens are hours.
- `"WriteAttributes"`: The list of user attributes that you want your app client to have
  write access to. After your user authenticates in your app, their access token authorizes
  them to set or modify their own attribute value for any attribute in this list. An example
  of this kind of activity is when you present your user with a form to update their profile
  information and they change their last name. Your app then makes an UpdateUserAttributes
  API request and sets family_name to the new value.  When you don't specify the
  WriteAttributes for your app client, your app can write the values of the Standard
  attributes of your user pool. When your user pool has write access to these default
  attributes, WriteAttributes doesn't return any information. Amazon Cognito only populates
  WriteAttributes in the API response if you have specified your own custom set of write
  attributes. If your app client allows users to sign in through an IdP, this array must
  include all attributes that you have mapped to IdP attributes. Amazon Cognito updates
  mapped attributes when users sign in to your application through an IdP. If your app client
  does not have write access to a mapped attribute, Amazon Cognito throws an error when it
  tries to update the attribute. For more information, see Specifying IdP Attribute Mappings
  for Your user pool.
"""
function create_user_pool_client(
    ClientName, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "CreateUserPoolClient",
        Dict{String,Any}("ClientName" => ClientName, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user_pool_client(
    ClientName,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "CreateUserPoolClient",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientName" => ClientName, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_user_pool_domain(domain, user_pool_id)
    create_user_pool_domain(domain, user_pool_id, params::Dict{String,<:Any})

Creates a new domain for a user pool.  Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `domain`: The domain string. For custom domains, this is the fully-qualified domain name,
  such as auth.example.com. For Amazon Cognito prefix domains, this is the prefix alone, such
  as auth.
- `user_pool_id`: The user pool ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CustomDomainConfig"`: The configuration for a custom domain that hosts the sign-up and
  sign-in webpages for your application. Provide this parameter only if you want to use a
  custom domain for your user pool. Otherwise, you can exclude this parameter and use the
  Amazon Cognito hosted domain instead. For more information about the hosted domain and
  custom domains, see Configuring a User Pool Domain.
"""
function create_user_pool_domain(
    Domain, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "CreateUserPoolDomain",
        Dict{String,Any}("Domain" => Domain, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user_pool_domain(
    Domain,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "CreateUserPoolDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Domain" => Domain, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_group(group_name, user_pool_id)
    delete_group(group_name, user_pool_id, params::Dict{String,<:Any})

Deletes a group. Calling this action requires developer credentials.

# Arguments
- `group_name`: The name of the group.
- `user_pool_id`: The user pool ID for the user pool.

"""
function delete_group(
    GroupName, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "DeleteGroup",
        Dict{String,Any}("GroupName" => GroupName, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_group(
    GroupName,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DeleteGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupName" => GroupName, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_identity_provider(provider_name, user_pool_id)
    delete_identity_provider(provider_name, user_pool_id, params::Dict{String,<:Any})

Deletes an IdP for a user pool.

# Arguments
- `provider_name`: The IdP name.
- `user_pool_id`: The user pool ID.

"""
function delete_identity_provider(
    ProviderName, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "DeleteIdentityProvider",
        Dict{String,Any}("ProviderName" => ProviderName, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_identity_provider(
    ProviderName,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DeleteIdentityProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ProviderName" => ProviderName, "UserPoolId" => UserPoolId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_server(identifier, user_pool_id)
    delete_resource_server(identifier, user_pool_id, params::Dict{String,<:Any})

Deletes a resource server.

# Arguments
- `identifier`: The identifier for the resource server.
- `user_pool_id`: The user pool ID for the user pool that hosts the resource server.

"""
function delete_resource_server(
    Identifier, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "DeleteResourceServer",
        Dict{String,Any}("Identifier" => Identifier, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resource_server(
    Identifier,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DeleteResourceServer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Identifier" => Identifier, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user(access_token)
    delete_user(access_token, params::Dict{String,<:Any})

Allows a user to delete their own user profile. Authorize this action with a signed-in
user's access token. It must include the scope aws.cognito.signin.user.admin.  Amazon
Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this
API operation. For this operation, you can't use IAM credentials to authorize requests, and
you can't grant IAM permissions in policies. For more information about authorization
models in Amazon Cognito, see Using the Amazon Cognito user pools API and user pool
endpoints.

# Arguments
- `access_token`: A valid access token that Amazon Cognito issued to the user whose user
  profile you want to delete.

"""
function delete_user(AccessToken; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "DeleteUser",
        Dict{String,Any}("AccessToken" => AccessToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user(
    AccessToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DeleteUser",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccessToken" => AccessToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user_attributes(access_token, user_attribute_names)
    delete_user_attributes(access_token, user_attribute_names, params::Dict{String,<:Any})

Deletes the attributes for a user. Authorize this action with a signed-in user's access
token. It must include the scope aws.cognito.signin.user.admin.  Amazon Cognito doesn't
evaluate Identity and Access Management (IAM) policies in requests for this API operation.
For this operation, you can't use IAM credentials to authorize requests, and you can't
grant IAM permissions in policies. For more information about authorization models in
Amazon Cognito, see Using the Amazon Cognito user pools API and user pool endpoints.

# Arguments
- `access_token`: A valid access token that Amazon Cognito issued to the user whose
  attributes you want to delete.
- `user_attribute_names`: An array of strings representing the user attribute names you
  want to delete. For custom attributes, you must prependattach the custom: prefix to the
  front of the attribute name.

"""
function delete_user_attributes(
    AccessToken, UserAttributeNames; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "DeleteUserAttributes",
        Dict{String,Any}(
            "AccessToken" => AccessToken, "UserAttributeNames" => UserAttributeNames
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user_attributes(
    AccessToken,
    UserAttributeNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DeleteUserAttributes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccessToken" => AccessToken, "UserAttributeNames" => UserAttributeNames
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user_pool(user_pool_id)
    delete_user_pool(user_pool_id, params::Dict{String,<:Any})

Deletes the specified Amazon Cognito user pool.

# Arguments
- `user_pool_id`: The user pool ID for the user pool you want to delete.

"""
function delete_user_pool(UserPoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "DeleteUserPool",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user_pool(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DeleteUserPool",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user_pool_client(client_id, user_pool_id)
    delete_user_pool_client(client_id, user_pool_id, params::Dict{String,<:Any})

Allows the developer to delete the user pool client.

# Arguments
- `client_id`: The app client ID of the app associated with the user pool.
- `user_pool_id`: The user pool ID for the user pool where you want to delete the client.

"""
function delete_user_pool_client(
    ClientId, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "DeleteUserPoolClient",
        Dict{String,Any}("ClientId" => ClientId, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user_pool_client(
    ClientId,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DeleteUserPoolClient",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientId" => ClientId, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_user_pool_domain(domain, user_pool_id)
    delete_user_pool_domain(domain, user_pool_id, params::Dict{String,<:Any})

Deletes a domain for a user pool.

# Arguments
- `domain`: The domain string. For custom domains, this is the fully-qualified domain name,
  such as auth.example.com. For Amazon Cognito prefix domains, this is the prefix alone, such
  as auth.
- `user_pool_id`: The user pool ID.

"""
function delete_user_pool_domain(
    Domain, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "DeleteUserPoolDomain",
        Dict{String,Any}("Domain" => Domain, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_user_pool_domain(
    Domain,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DeleteUserPoolDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Domain" => Domain, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_identity_provider(provider_name, user_pool_id)
    describe_identity_provider(provider_name, user_pool_id, params::Dict{String,<:Any})

Gets information about a specific IdP.

# Arguments
- `provider_name`: The IdP name.
- `user_pool_id`: The user pool ID.

"""
function describe_identity_provider(
    ProviderName, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "DescribeIdentityProvider",
        Dict{String,Any}("ProviderName" => ProviderName, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_identity_provider(
    ProviderName,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DescribeIdentityProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ProviderName" => ProviderName, "UserPoolId" => UserPoolId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_resource_server(identifier, user_pool_id)
    describe_resource_server(identifier, user_pool_id, params::Dict{String,<:Any})

Describes a resource server.

# Arguments
- `identifier`: A unique resource server identifier for the resource server. The identifier
  can be an API friendly name like solar-system-data. You can also set an API URL like
  https://solar-system-data-api.example.com as your identifier. Amazon Cognito represents
  scopes in the access token in the format resource-server-identifier/scope. Longer
  scope-identifier strings increase the size of your access tokens.
- `user_pool_id`: The user pool ID for the user pool that hosts the resource server.

"""
function describe_resource_server(
    Identifier, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "DescribeResourceServer",
        Dict{String,Any}("Identifier" => Identifier, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_resource_server(
    Identifier,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DescribeResourceServer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Identifier" => Identifier, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_risk_configuration(user_pool_id)
    describe_risk_configuration(user_pool_id, params::Dict{String,<:Any})

Describes the risk configuration.

# Arguments
- `user_pool_id`: The user pool ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientId"`: The app client ID.
"""
function describe_risk_configuration(
    UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "DescribeRiskConfiguration",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_risk_configuration(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DescribeRiskConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_user_import_job(job_id, user_pool_id)
    describe_user_import_job(job_id, user_pool_id, params::Dict{String,<:Any})

Describes the user import job.

# Arguments
- `job_id`: The job ID for the user import job.
- `user_pool_id`: The user pool ID for the user pool that the users are being imported into.

"""
function describe_user_import_job(
    JobId, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "DescribeUserImportJob",
        Dict{String,Any}("JobId" => JobId, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_user_import_job(
    JobId,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DescribeUserImportJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("JobId" => JobId, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_user_pool(user_pool_id)
    describe_user_pool(user_pool_id, params::Dict{String,<:Any})

Returns the configuration information and metadata of the specified user pool.  Amazon
Cognito evaluates Identity and Access Management (IAM) policies in requests for this API
operation. For this operation, you must use IAM credentials to authorize requests, and you
must grant yourself the corresponding IAM permission in a policy.  Learn more     Signing
Amazon Web Services API Requests     Using the Amazon Cognito user pools API and user pool
endpoints

# Arguments
- `user_pool_id`: The user pool ID for the user pool you want to describe.

"""
function describe_user_pool(UserPoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "DescribeUserPool",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_user_pool(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DescribeUserPool",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_user_pool_client(client_id, user_pool_id)
    describe_user_pool_client(client_id, user_pool_id, params::Dict{String,<:Any})

Client method for returning the configuration information and metadata of the specified
user pool app client.  Amazon Cognito evaluates Identity and Access Management (IAM)
policies in requests for this API operation. For this operation, you must use IAM
credentials to authorize requests, and you must grant yourself the corresponding IAM
permission in a policy.  Learn more     Signing Amazon Web Services API Requests     Using
the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `client_id`: The app client ID of the app associated with the user pool.
- `user_pool_id`: The user pool ID for the user pool you want to describe.

"""
function describe_user_pool_client(
    ClientId, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "DescribeUserPoolClient",
        Dict{String,Any}("ClientId" => ClientId, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_user_pool_client(
    ClientId,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "DescribeUserPoolClient",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientId" => ClientId, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_user_pool_domain(domain)
    describe_user_pool_domain(domain, params::Dict{String,<:Any})

Gets information about a domain.

# Arguments
- `domain`: The domain string. For custom domains, this is the fully-qualified domain name,
  such as auth.example.com. For Amazon Cognito prefix domains, this is the prefix alone, such
  as auth.

"""
function describe_user_pool_domain(
    Domain; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "DescribeUserPoolDomain",
        Dict{String,Any}("Domain" => Domain);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_user_pool_domain(
    Domain, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "DescribeUserPoolDomain",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Domain" => Domain), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    forget_device(device_key)
    forget_device(device_key, params::Dict{String,<:Any})

Forgets the specified device. For more information about device authentication, see Working
with user devices in your user pool. Authorize this action with a signed-in user's access
token. It must include the scope aws.cognito.signin.user.admin.  Amazon Cognito doesn't
evaluate Identity and Access Management (IAM) policies in requests for this API operation.
For this operation, you can't use IAM credentials to authorize requests, and you can't
grant IAM permissions in policies. For more information about authorization models in
Amazon Cognito, see Using the Amazon Cognito user pools API and user pool endpoints.

# Arguments
- `device_key`: The device key.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessToken"`: A valid access token that Amazon Cognito issued to the user whose
  registered device you want to forget.
"""
function forget_device(DeviceKey; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "ForgetDevice",
        Dict{String,Any}("DeviceKey" => DeviceKey);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function forget_device(
    DeviceKey,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ForgetDevice",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DeviceKey" => DeviceKey), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    forgot_password(client_id, username)
    forgot_password(client_id, username, params::Dict{String,<:Any})

Calling this API causes a message to be sent to the end user with a confirmation code that
is required to change the user's password. For the Username parameter, you can use the
username or user alias. The method used to send the confirmation code is sent according to
the specified AccountRecoverySetting. For more information, see Recovering User Accounts in
the Amazon Cognito Developer Guide. To use the confirmation code for resetting the
password, call ConfirmForgotPassword.  If neither a verified phone number nor a verified
email exists, this API returns InvalidParameterException. If your app client has a client
secret and you don't provide a SECRET_HASH parameter, this API returns
NotAuthorizedException. To use this API operation, your user pool must have self-service
account recovery configured. Use AdminSetUserPassword if you manage passwords as an
administrator.  Amazon Cognito doesn't evaluate Identity and Access Management (IAM)
policies in requests for this API operation. For this operation, you can't use IAM
credentials to authorize requests, and you can't grant IAM permissions in policies. For
more information about authorization models in Amazon Cognito, see Using the Amazon Cognito
user pools API and user pool endpoints.   This action might generate an SMS text message.
Starting June 1, 2021, US telecom carriers require you to register an origination phone
number before you can send SMS messages to US phone numbers. If you use SMS text messages
in Amazon Cognito, you must register a phone number with Amazon Pinpoint. Amazon Cognito
uses the registered number automatically. Otherwise, Amazon Cognito users who must receive
SMS messages might not be able to sign up, activate their accounts, or sign in. If you have
never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon
Simple Notification Service might place your account in the SMS sandbox. In  sandbox mode ,
you can send messages only to verified phone numbers. After you test your app while in the
sandbox environment, you can move out of the sandbox and into production. For more
information, see  SMS message settings for Amazon Cognito user pools in the Amazon Cognito
Developer Guide.

# Arguments
- `client_id`: The ID of the client associated with the user pool.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnalyticsMetadata"`: The Amazon Pinpoint analytics metadata that contributes to your
  metrics for ForgotPassword calls.
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for any
  custom workflows that this action triggers. You create custom workflows by assigning Lambda
  functions to user pool triggers. When you use the ForgotPassword API action, Amazon Cognito
  invokes any functions that are assigned to the following triggers: pre sign-up, custom
  message, and user migration. When Amazon Cognito invokes any of these functions, it passes
  a JSON payload, which the function receives as input. This payload contains a
  clientMetadata attribute, which provides the data that you assigned to the ClientMetadata
  parameter in your ForgotPassword request. In your function code in Lambda, you can process
  the clientMetadata value to enhance your workflow for your specific needs. For more
  information, see  Customizing user pool Workflows with Lambda Triggers in the Amazon
  Cognito Developer Guide.  When you use the ClientMetadata parameter, remember that Amazon
  Cognito won't do the following:   Store the ClientMetadata value. This data is available
  only to Lambda triggers that are assigned to a user pool to support custom workflows. If
  your user pool configuration doesn't include triggers, the ClientMetadata parameter serves
  no purpose.   Validate the ClientMetadata value.   Encrypt the ClientMetadata value. Don't
  use Amazon Cognito to provide sensitive information.
- `"SecretHash"`: A keyed-hash message authentication code (HMAC) calculated using the
  secret key of a user pool client and username plus the client ID in the message.
- `"UserContextData"`: Contextual data about your user session, such as the device
  fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk
  of an authentication event based on the context that your app generates and passes to
  Amazon Cognito when it makes API requests.
"""
function forgot_password(
    ClientId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "ForgotPassword",
        Dict{String,Any}("ClientId" => ClientId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function forgot_password(
    ClientId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ForgotPassword",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientId" => ClientId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_csvheader(user_pool_id)
    get_csvheader(user_pool_id, params::Dict{String,<:Any})

Gets the header information for the comma-separated value (CSV) file to be used as input
for the user import job.

# Arguments
- `user_pool_id`: The user pool ID for the user pool that the users are to be imported into.

"""
function get_csvheader(UserPoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "GetCSVHeader",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_csvheader(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "GetCSVHeader",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_device(device_key)
    get_device(device_key, params::Dict{String,<:Any})

Gets the device. For more information about device authentication, see Working with user
devices in your user pool. Authorize this action with a signed-in user's access token. It
must include the scope aws.cognito.signin.user.admin.  Amazon Cognito doesn't evaluate
Identity and Access Management (IAM) policies in requests for this API operation. For this
operation, you can't use IAM credentials to authorize requests, and you can't grant IAM
permissions in policies. For more information about authorization models in Amazon Cognito,
see Using the Amazon Cognito user pools API and user pool endpoints.

# Arguments
- `device_key`: The device key.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessToken"`: A valid access token that Amazon Cognito issued to the user whose device
  information you want to request.
"""
function get_device(DeviceKey; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "GetDevice",
        Dict{String,Any}("DeviceKey" => DeviceKey);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_device(
    DeviceKey,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "GetDevice",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DeviceKey" => DeviceKey), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_group(group_name, user_pool_id)
    get_group(group_name, user_pool_id, params::Dict{String,<:Any})

Gets a group. Calling this action requires developer credentials.

# Arguments
- `group_name`: The name of the group.
- `user_pool_id`: The user pool ID for the user pool.

"""
function get_group(
    GroupName, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "GetGroup",
        Dict{String,Any}("GroupName" => GroupName, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_group(
    GroupName,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "GetGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupName" => GroupName, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_identity_provider_by_identifier(idp_identifier, user_pool_id)
    get_identity_provider_by_identifier(idp_identifier, user_pool_id, params::Dict{String,<:Any})

Gets the specified IdP.

# Arguments
- `idp_identifier`: The IdP identifier.
- `user_pool_id`: The user pool ID.

"""
function get_identity_provider_by_identifier(
    IdpIdentifier, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "GetIdentityProviderByIdentifier",
        Dict{String,Any}("IdpIdentifier" => IdpIdentifier, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_identity_provider_by_identifier(
    IdpIdentifier,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "GetIdentityProviderByIdentifier",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IdpIdentifier" => IdpIdentifier, "UserPoolId" => UserPoolId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_log_delivery_configuration(user_pool_id)
    get_log_delivery_configuration(user_pool_id, params::Dict{String,<:Any})

Gets the detailed activity logging configuration for a user pool.

# Arguments
- `user_pool_id`: The ID of the user pool where you want to view detailed activity logging
  configuration.

"""
function get_log_delivery_configuration(
    UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "GetLogDeliveryConfiguration",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_log_delivery_configuration(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "GetLogDeliveryConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_signing_certificate(user_pool_id)
    get_signing_certificate(user_pool_id, params::Dict{String,<:Any})

This method takes a user pool ID, and returns the signing certificate. The issued
certificate is valid for 10 years from the date of issue. Amazon Cognito issues and assigns
a new signing certificate annually. This process returns a new value in the response to
GetSigningCertificate, but doesn't invalidate the original certificate.

# Arguments
- `user_pool_id`: The user pool ID.

"""
function get_signing_certificate(
    UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "GetSigningCertificate",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_signing_certificate(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "GetSigningCertificate",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_uicustomization(user_pool_id)
    get_uicustomization(user_pool_id, params::Dict{String,<:Any})

Gets the user interface (UI) Customization information for a particular app client's app
UI, if any such information exists for the client. If nothing is set for the particular
client, but there is an existing pool level customization (the app clientId is ALL), then
that information is returned. If nothing is present, then an empty shape is returned.

# Arguments
- `user_pool_id`: The user pool ID for the user pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientId"`: The client ID for the client app.
"""
function get_uicustomization(UserPoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "GetUICustomization",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_uicustomization(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "GetUICustomization",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_user(access_token)
    get_user(access_token, params::Dict{String,<:Any})

Gets the user attributes and metadata for a user. Authorize this action with a signed-in
user's access token. It must include the scope aws.cognito.signin.user.admin.  Amazon
Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests for this
API operation. For this operation, you can't use IAM credentials to authorize requests, and
you can't grant IAM permissions in policies. For more information about authorization
models in Amazon Cognito, see Using the Amazon Cognito user pools API and user pool
endpoints.

# Arguments
- `access_token`: A non-expired access token for the user whose information you want to
  query.

"""
function get_user(AccessToken; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "GetUser",
        Dict{String,Any}("AccessToken" => AccessToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_user(
    AccessToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "GetUser",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccessToken" => AccessToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_user_attribute_verification_code(access_token, attribute_name)
    get_user_attribute_verification_code(access_token, attribute_name, params::Dict{String,<:Any})

Generates a user attribute verification code for the specified attribute name. Sends a
message to a user with a code that they must return in a VerifyUserAttribute request.
Authorize this action with a signed-in user's access token. It must include the scope
aws.cognito.signin.user.admin.  Amazon Cognito doesn't evaluate Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you can't
use IAM credentials to authorize requests, and you can't grant IAM permissions in policies.
For more information about authorization models in Amazon Cognito, see Using the Amazon
Cognito user pools API and user pool endpoints.   This action might generate an SMS text
message. Starting June 1, 2021, US telecom carriers require you to register an origination
phone number before you can send SMS messages to US phone numbers. If you use SMS text
messages in Amazon Cognito, you must register a phone number with Amazon Pinpoint. Amazon
Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must
receive SMS messages might not be able to sign up, activate their accounts, or sign in. If
you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service,
Amazon Simple Notification Service might place your account in the SMS sandbox. In  sandbox
mode , you can send messages only to verified phone numbers. After you test your app while
in the sandbox environment, you can move out of the sandbox and into production. For more
information, see  SMS message settings for Amazon Cognito user pools in the Amazon Cognito
Developer Guide.

# Arguments
- `access_token`: A non-expired access token for the user whose attribute verification code
  you want to generate.
- `attribute_name`: The attribute name returned by the server response to get the user
  attribute verification code.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for any
  custom workflows that this action triggers. You create custom workflows by assigning Lambda
  functions to user pool triggers. When you use the GetUserAttributeVerificationCode API
  action, Amazon Cognito invokes the function that is assigned to the custom message trigger.
  When Amazon Cognito invokes this function, it passes a JSON payload, which the function
  receives as input. This payload contains a clientMetadata attribute, which provides the
  data that you assigned to the ClientMetadata parameter in your
  GetUserAttributeVerificationCode request. In your function code in Lambda, you can process
  the clientMetadata value to enhance your workflow for your specific needs. For more
  information, see  Customizing user pool Workflows with Lambda Triggers in the Amazon
  Cognito Developer Guide.  When you use the ClientMetadata parameter, remember that Amazon
  Cognito won't do the following:   Store the ClientMetadata value. This data is available
  only to Lambda triggers that are assigned to a user pool to support custom workflows. If
  your user pool configuration doesn't include triggers, the ClientMetadata parameter serves
  no purpose.   Validate the ClientMetadata value.   Encrypt the ClientMetadata value. Don't
  use Amazon Cognito to provide sensitive information.
"""
function get_user_attribute_verification_code(
    AccessToken, AttributeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "GetUserAttributeVerificationCode",
        Dict{String,Any}("AccessToken" => AccessToken, "AttributeName" => AttributeName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_user_attribute_verification_code(
    AccessToken,
    AttributeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "GetUserAttributeVerificationCode",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccessToken" => AccessToken, "AttributeName" => AttributeName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_user_pool_mfa_config(user_pool_id)
    get_user_pool_mfa_config(user_pool_id, params::Dict{String,<:Any})

Gets the user pool multi-factor authentication (MFA) configuration.

# Arguments
- `user_pool_id`: The user pool ID.

"""
function get_user_pool_mfa_config(
    UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "GetUserPoolMfaConfig",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_user_pool_mfa_config(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "GetUserPoolMfaConfig",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    global_sign_out(access_token)
    global_sign_out(access_token, params::Dict{String,<:Any})

Invalidates the identity, access, and refresh tokens that Amazon Cognito issued to a user.
Call this operation when your user signs out of your app. This results in the following
behavior.    Amazon Cognito no longer accepts token-authorized user operations that you
authorize with a signed-out user's access tokens. For more information, see Using the
Amazon Cognito user pools API and user pool endpoints. Amazon Cognito returns an Access
Token has been revoked error when your app attempts to authorize a user pools API request
with a revoked access token that contains the scope aws.cognito.signin.user.admin.   Amazon
Cognito no longer accepts a signed-out user's ID token in a GetId  request to an identity
pool with ServerSideTokenCheck enabled for its user pool IdP configuration in
CognitoIdentityProvider.   Amazon Cognito no longer accepts a signed-out user's refresh
tokens in refresh requests.   Other requests might be valid until your user's token
expires. Authorize this action with a signed-in user's access token. It must include the
scope aws.cognito.signin.user.admin.  Amazon Cognito doesn't evaluate Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you can't
use IAM credentials to authorize requests, and you can't grant IAM permissions in policies.
For more information about authorization models in Amazon Cognito, see Using the Amazon
Cognito user pools API and user pool endpoints.

# Arguments
- `access_token`: A valid access token that Amazon Cognito issued to the user who you want
  to sign out.

"""
function global_sign_out(AccessToken; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "GlobalSignOut",
        Dict{String,Any}("AccessToken" => AccessToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function global_sign_out(
    AccessToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "GlobalSignOut",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccessToken" => AccessToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    initiate_auth(auth_flow, client_id)
    initiate_auth(auth_flow, client_id, params::Dict{String,<:Any})

Initiates sign-in for a user in the Amazon Cognito user directory. You can't sign in a user
with a federated IdP with InitiateAuth. For more information, see  Adding user pool sign-in
through a third party.  Amazon Cognito doesn't evaluate Identity and Access Management
(IAM) policies in requests for this API operation. For this operation, you can't use IAM
credentials to authorize requests, and you can't grant IAM permissions in policies. For
more information about authorization models in Amazon Cognito, see Using the Amazon Cognito
user pools API and user pool endpoints.   This action might generate an SMS text message.
Starting June 1, 2021, US telecom carriers require you to register an origination phone
number before you can send SMS messages to US phone numbers. If you use SMS text messages
in Amazon Cognito, you must register a phone number with Amazon Pinpoint. Amazon Cognito
uses the registered number automatically. Otherwise, Amazon Cognito users who must receive
SMS messages might not be able to sign up, activate their accounts, or sign in. If you have
never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon
Simple Notification Service might place your account in the SMS sandbox. In  sandbox mode ,
you can send messages only to verified phone numbers. After you test your app while in the
sandbox environment, you can move out of the sandbox and into production. For more
information, see  SMS message settings for Amazon Cognito user pools in the Amazon Cognito
Developer Guide.

# Arguments
- `auth_flow`: The authentication flow for this call to run. The API action will depend on
  this value. For example:    REFRESH_TOKEN_AUTH takes in a valid refresh token and returns
  new tokens.    USER_SRP_AUTH takes in USERNAME and SRP_A and returns the SRP variables to
  be used for next challenge execution.    USER_PASSWORD_AUTH takes in USERNAME and PASSWORD
  and returns the next challenge or tokens.   Valid values include:    USER_SRP_AUTH:
  Authentication flow for the Secure Remote Password (SRP) protocol.
  REFRESH_TOKEN_AUTH/REFRESH_TOKEN: Authentication flow for refreshing the access token and
  ID token by supplying a valid refresh token.    CUSTOM_AUTH: Custom authentication flow.
  USER_PASSWORD_AUTH: Non-SRP authentication flow; user name and password are passed
  directly. If a user migration Lambda trigger is set, this flow will invoke the user
  migration Lambda if it doesn't find the user name in the user pool.     ADMIN_NO_SRP_AUTH
  isn't a valid value.
- `client_id`: The app client ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnalyticsMetadata"`: The Amazon Pinpoint analytics metadata that contributes to your
  metrics for InitiateAuth calls.
- `"AuthParameters"`: The authentication parameters. These are inputs corresponding to the
  AuthFlow that you're invoking. The required values depend on the value of AuthFlow:   For
  USER_SRP_AUTH: USERNAME (required), SRP_A (required), SECRET_HASH (required if the app
  client is configured with a client secret), DEVICE_KEY.   For USER_PASSWORD_AUTH: USERNAME
  (required), PASSWORD (required), SECRET_HASH (required if the app client is configured with
  a client secret), DEVICE_KEY.   For REFRESH_TOKEN_AUTH/REFRESH_TOKEN: REFRESH_TOKEN
  (required), SECRET_HASH (required if the app client is configured with a client secret),
  DEVICE_KEY.   For CUSTOM_AUTH: USERNAME (required), SECRET_HASH (if app client is
  configured with client secret), DEVICE_KEY. To start the authentication flow with password
  verification, include ChallengeName: SRP_A and SRP_A: (The SRP_A Value).   For more
  information about SECRET_HASH, see Computing secret hash values. For information about
  DEVICE_KEY, see Working with user devices in your user pool.
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for
  certain custom workflows that this action triggers. You create custom workflows by
  assigning Lambda functions to user pool triggers. When you use the InitiateAuth API action,
  Amazon Cognito invokes the Lambda functions that are specified for various triggers. The
  ClientMetadata value is passed as input to the functions for only the following triggers:
  Pre signup   Pre authentication   User migration   When Amazon Cognito invokes the
  functions for these triggers, it passes a JSON payload, which the function receives as
  input. This payload contains a validationData attribute, which provides the data that you
  assigned to the ClientMetadata parameter in your InitiateAuth request. In your function
  code in Lambda, you can process the validationData value to enhance your workflow for your
  specific needs. When you use the InitiateAuth API action, Amazon Cognito also invokes the
  functions for the following triggers, but it doesn't provide the ClientMetadata value as
  input:   Post authentication   Custom message   Pre token generation   Create auth
  challenge   Define auth challenge   For more information, see  Customizing user pool
  Workflows with Lambda Triggers in the Amazon Cognito Developer Guide.  When you use the
  ClientMetadata parameter, remember that Amazon Cognito won't do the following:   Store the
  ClientMetadata value. This data is available only to Lambda triggers that are assigned to a
  user pool to support custom workflows. If your user pool configuration doesn't include
  triggers, the ClientMetadata parameter serves no purpose.   Validate the ClientMetadata
  value.   Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive
  information.
- `"UserContextData"`: Contextual data about your user session, such as the device
  fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk
  of an authentication event based on the context that your app generates and passes to
  Amazon Cognito when it makes API requests.
"""
function initiate_auth(
    AuthFlow, ClientId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "InitiateAuth",
        Dict{String,Any}("AuthFlow" => AuthFlow, "ClientId" => ClientId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function initiate_auth(
    AuthFlow,
    ClientId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "InitiateAuth",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AuthFlow" => AuthFlow, "ClientId" => ClientId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_devices(access_token)
    list_devices(access_token, params::Dict{String,<:Any})

Lists the sign-in devices that Amazon Cognito has registered to the current user. For more
information about device authentication, see Working with user devices in your user pool.
Authorize this action with a signed-in user's access token. It must include the scope
aws.cognito.signin.user.admin.  Amazon Cognito doesn't evaluate Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you can't
use IAM credentials to authorize requests, and you can't grant IAM permissions in policies.
For more information about authorization models in Amazon Cognito, see Using the Amazon
Cognito user pools API and user pool endpoints.

# Arguments
- `access_token`: A valid access token that Amazon Cognito issued to the user whose list of
  devices you want to view.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The limit of the device request.
- `"PaginationToken"`: This API operation returns a limited number of results. The
  pagination token is an identifier that you can present in an additional API request with
  the same parameters. When you include the pagination token, Amazon Cognito returns the next
  set of items after the current list. Subsequent requests return a new pagination token. By
  use of this token, you can paginate through the full list of items.
"""
function list_devices(AccessToken; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "ListDevices",
        Dict{String,Any}("AccessToken" => AccessToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_devices(
    AccessToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ListDevices",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccessToken" => AccessToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_groups(user_pool_id)
    list_groups(user_pool_id, params::Dict{String,<:Any})

Lists the groups associated with a user pool.  Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID for the user pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The limit of the request to list groups.
- `"NextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_groups(UserPoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "ListGroups",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_groups(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ListGroups",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_identity_providers(user_pool_id)
    list_identity_providers(user_pool_id, params::Dict{String,<:Any})

Lists information about all IdPs for a user pool.  Amazon Cognito evaluates Identity and
Access Management (IAM) policies in requests for this API operation. For this operation,
you must use IAM credentials to authorize requests, and you must grant yourself the
corresponding IAM permission in a policy.  Learn more     Signing Amazon Web Services API
Requests     Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of IdPs to return.
- `"NextToken"`: A pagination token.
"""
function list_identity_providers(
    UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "ListIdentityProviders",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_identity_providers(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ListIdentityProviders",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resource_servers(user_pool_id)
    list_resource_servers(user_pool_id, params::Dict{String,<:Any})

Lists the resource servers for a user pool.  Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID for the user pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of resource servers to return.
- `"NextToken"`: A pagination token.
"""
function list_resource_servers(
    UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "ListResourceServers",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_resource_servers(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ListResourceServers",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags that are assigned to an Amazon Cognito user pool. A tag is a label that you
can apply to user pools to categorize and manage them in different ways, such as by
purpose, owner, environment, or other criteria. You can use this action up to 10 times per
second, per account.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the user pool that the tags are
  assigned to.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "ListTagsForResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_user_import_jobs(max_results, user_pool_id)
    list_user_import_jobs(max_results, user_pool_id, params::Dict{String,<:Any})

Lists user import jobs for a user pool.  Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `max_results`: The maximum number of import jobs you want the request to return.
- `user_pool_id`: The user pool ID for the user pool that the users are being imported into.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PaginationToken"`: This API operation returns a limited number of results. The
  pagination token is an identifier that you can present in an additional API request with
  the same parameters. When you include the pagination token, Amazon Cognito returns the next
  set of items after the current list. Subsequent requests return a new pagination token. By
  use of this token, you can paginate through the full list of items.
"""
function list_user_import_jobs(
    MaxResults, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "ListUserImportJobs",
        Dict{String,Any}("MaxResults" => MaxResults, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_user_import_jobs(
    MaxResults,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ListUserImportJobs",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("MaxResults" => MaxResults, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_user_pool_clients(user_pool_id)
    list_user_pool_clients(user_pool_id, params::Dict{String,<:Any})

Lists the clients that have been created for the specified user pool.  Amazon Cognito
evaluates Identity and Access Management (IAM) policies in requests for this API operation.
For this operation, you must use IAM credentials to authorize requests, and you must grant
yourself the corresponding IAM permission in a policy.  Learn more     Signing Amazon Web
Services API Requests     Using the Amazon Cognito user pools API and user pool endpoints


# Arguments
- `user_pool_id`: The user pool ID for the user pool where you want to list user pool
  clients.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of results you want the request to return when listing
  the user pool clients.
- `"NextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_user_pool_clients(
    UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "ListUserPoolClients",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_user_pool_clients(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ListUserPoolClients",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_user_pools(max_results)
    list_user_pools(max_results, params::Dict{String,<:Any})

Lists the user pools associated with an Amazon Web Services account.  Amazon Cognito
evaluates Identity and Access Management (IAM) policies in requests for this API operation.
For this operation, you must use IAM credentials to authorize requests, and you must grant
yourself the corresponding IAM permission in a policy.  Learn more     Signing Amazon Web
Services API Requests     Using the Amazon Cognito user pools API and user pool endpoints


# Arguments
- `max_results`: The maximum number of results you want the request to return when listing
  the user pools.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_user_pools(MaxResults; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "ListUserPools",
        Dict{String,Any}("MaxResults" => MaxResults);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_user_pools(
    MaxResults,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ListUserPools",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("MaxResults" => MaxResults), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_users(user_pool_id)
    list_users(user_pool_id, params::Dict{String,<:Any})

Lists users and their basic details in a user pool.  Amazon Cognito evaluates Identity and
Access Management (IAM) policies in requests for this API operation. For this operation,
you must use IAM credentials to authorize requests, and you must grant yourself the
corresponding IAM permission in a policy.  Learn more     Signing Amazon Web Services API
Requests     Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID for the user pool on which the search should be
  performed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributesToGet"`: A JSON array of user attribute names, for example given_name, that
  you want Amazon Cognito to include in the response for each user. When you don't provide an
  AttributesToGet parameter, Amazon Cognito returns all attributes for each user. Use
  AttributesToGet with required attributes in your user pool, or in conjunction with Filter.
  Amazon Cognito returns an error if not all users in the results have set a value for the
  attribute you request. Attributes that you can't filter on, including custom attributes,
  must have a value set in every user profile before an AttributesToGet parameter returns
  results.
- `"Filter"`: A filter string of the form \"AttributeName Filter-Type \"AttributeValue\"\".
  Quotation marks within the filter string must be escaped using the backslash () character.
  For example, \"family_name = \"Reddy\"\".    AttributeName: The name of the attribute to
  search for. You can only search for one attribute at a time.    Filter-Type: For an exact
  match, use =, for example, \"given_name = \"Jon\"\". For a prefix (\"starts with\") match,
  use ^=, for example, \"given_name ^= \"Jon\"\".     AttributeValue: The attribute value
  that must be matched for each user.   If the filter string is empty, ListUsers returns all
  users in the user pool. You can only search for the following standard attributes:
  username (case-sensitive)    email     phone_number     name     given_name     family_name
      preferred_username     cognito:user_status (called Status in the Console)
  (case-insensitive)    status (called Enabled in the Console) (case-sensitive)     sub
  Custom attributes aren't searchable.  You can also list users with a client-side filter.
  The server-side filter matches no more than one attribute. For an advanced search, use a
  client-side filter with the --query parameter of the list-users action in the CLI. When you
  use a client-side filter, ListUsers returns a paginated list of zero or more users. You can
  receive multiple pages in a row with zero results. Repeat the query with each pagination
  token that is returned until you receive a null pagination token value, and then review the
  combined result.  For more information about server-side and client-side filtering, see
  FilteringCLI output in the Command Line Interface User Guide.   For more information, see
  Searching for Users Using the ListUsers API and Examples of Using the ListUsers API in the
  Amazon Cognito Developer Guide.
- `"Limit"`: Maximum number of users to be returned.
- `"PaginationToken"`: This API operation returns a limited number of results. The
  pagination token is an identifier that you can present in an additional API request with
  the same parameters. When you include the pagination token, Amazon Cognito returns the next
  set of items after the current list. Subsequent requests return a new pagination token. By
  use of this token, you can paginate through the full list of items.
"""
function list_users(UserPoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "ListUsers",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_users(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ListUsers",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_users_in_group(group_name, user_pool_id)
    list_users_in_group(group_name, user_pool_id, params::Dict{String,<:Any})

Lists the users in the specified group.  Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `group_name`: The name of the group.
- `user_pool_id`: The user pool ID for the user pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of users that you want to retrieve before pagination.
- `"NextToken"`: An identifier that was returned from the previous call to this operation,
  which can be used to return the next set of items in the list.
"""
function list_users_in_group(
    GroupName, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "ListUsersInGroup",
        Dict{String,Any}("GroupName" => GroupName, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_users_in_group(
    GroupName,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ListUsersInGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupName" => GroupName, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    resend_confirmation_code(client_id, username)
    resend_confirmation_code(client_id, username, params::Dict{String,<:Any})

Resends the confirmation (for confirmation of registration) to a specific user in the user
pool.  Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in
requests for this API operation. For this operation, you can't use IAM credentials to
authorize requests, and you can't grant IAM permissions in policies. For more information
about authorization models in Amazon Cognito, see Using the Amazon Cognito user pools API
and user pool endpoints.   This action might generate an SMS text message. Starting June 1,
2021, US telecom carriers require you to register an origination phone number before you
can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito,
you must register a phone number with Amazon Pinpoint. Amazon Cognito uses the registered
number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might
not be able to sign up, activate their accounts, or sign in. If you have never used SMS
text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
Notification Service might place your account in the SMS sandbox. In  sandbox mode , you
can send messages only to verified phone numbers. After you test your app while in the
sandbox environment, you can move out of the sandbox and into production. For more
information, see  SMS message settings for Amazon Cognito user pools in the Amazon Cognito
Developer Guide.

# Arguments
- `client_id`: The ID of the client associated with the user pool.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnalyticsMetadata"`: The Amazon Pinpoint analytics metadata that contributes to your
  metrics for ResendConfirmationCode calls.
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for any
  custom workflows that this action triggers. You create custom workflows by assigning Lambda
  functions to user pool triggers. When you use the ResendConfirmationCode API action, Amazon
  Cognito invokes the function that is assigned to the custom message trigger. When Amazon
  Cognito invokes this function, it passes a JSON payload, which the function receives as
  input. This payload contains a clientMetadata attribute, which provides the data that you
  assigned to the ClientMetadata parameter in your ResendConfirmationCode request. In your
  function code in Lambda, you can process the clientMetadata value to enhance your workflow
  for your specific needs. For more information, see  Customizing user pool Workflows with
  Lambda Triggers in the Amazon Cognito Developer Guide.  When you use the ClientMetadata
  parameter, remember that Amazon Cognito won't do the following:   Store the ClientMetadata
  value. This data is available only to Lambda triggers that are assigned to a user pool to
  support custom workflows. If your user pool configuration doesn't include triggers, the
  ClientMetadata parameter serves no purpose.   Validate the ClientMetadata value.   Encrypt
  the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
- `"SecretHash"`: A keyed-hash message authentication code (HMAC) calculated using the
  secret key of a user pool client and username plus the client ID in the message.
- `"UserContextData"`: Contextual data about your user session, such as the device
  fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk
  of an authentication event based on the context that your app generates and passes to
  Amazon Cognito when it makes API requests.
"""
function resend_confirmation_code(
    ClientId, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "ResendConfirmationCode",
        Dict{String,Any}("ClientId" => ClientId, "Username" => Username);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function resend_confirmation_code(
    ClientId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "ResendConfirmationCode",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientId" => ClientId, "Username" => Username),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    respond_to_auth_challenge(challenge_name, client_id)
    respond_to_auth_challenge(challenge_name, client_id, params::Dict{String,<:Any})

Some API operations in a user pool generate a challenge, like a prompt for an MFA code, for
device authentication that bypasses MFA, or for a custom authentication challenge. A
RespondToAuthChallenge API request provides the answer to that challenge, like a code or a
secure remote password (SRP). The parameters of a response to an authentication challenge
vary with the type of challenge. For more information about custom authentication
challenges, see Custom authentication challenge Lambda triggers.  Amazon Cognito doesn't
evaluate Identity and Access Management (IAM) policies in requests for this API operation.
For this operation, you can't use IAM credentials to authorize requests, and you can't
grant IAM permissions in policies. For more information about authorization models in
Amazon Cognito, see Using the Amazon Cognito user pools API and user pool endpoints.   This
action might generate an SMS text message. Starting June 1, 2021, US telecom carriers
require you to register an origination phone number before you can send SMS messages to US
phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone
number with Amazon Pinpoint. Amazon Cognito uses the registered number automatically.
Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
activate their accounts, or sign in. If you have never used SMS text messages with Amazon
Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place
your account in the SMS sandbox. In  sandbox mode , you can send messages only to verified
phone numbers. After you test your app while in the sandbox environment, you can move out
of the sandbox and into production. For more information, see  SMS message settings for
Amazon Cognito user pools in the Amazon Cognito Developer Guide.

# Arguments
- `challenge_name`: The challenge name. For more information, see InitiateAuth.
  ADMIN_NO_SRP_AUTH isn't a valid value.
- `client_id`: The app client ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnalyticsMetadata"`: The Amazon Pinpoint analytics metadata that contributes to your
  metrics for RespondToAuthChallenge calls.
- `"ChallengeResponses"`: The responses to the challenge that you received in the previous
  request. Each challenge has its own required response parameters. The following examples
  are partial JSON request bodies that highlight challenge-response parameters.  You must
  provide a SECRET_HASH parameter in all challenge responses to an app client that has a
  client secret.   SMS_MFA   \"ChallengeName\": \"SMS_MFA\", \"ChallengeResponses\":
  {\"SMS_MFA_CODE\": \"[SMS_code]\", \"USERNAME\": \"[username]\"}   PASSWORD_VERIFIER
  \"ChallengeName\": \"PASSWORD_VERIFIER\", \"ChallengeResponses\":
  {\"PASSWORD_CLAIM_SIGNATURE\": \"[claim_signature]\", \"PASSWORD_CLAIM_SECRET_BLOCK\":
  \"[secret_block]\", \"TIMESTAMP\": [timestamp], \"USERNAME\": \"[username]\"}  Add
  \"DEVICE_KEY\" when you sign in with a remembered device.  CUSTOM_CHALLENGE
  \"ChallengeName\": \"CUSTOM_CHALLENGE\", \"ChallengeResponses\": {\"USERNAME\":
  \"[username]\", \"ANSWER\": \"[challenge_answer]\"}  Add \"DEVICE_KEY\" when you sign in
  with a remembered device.  NEW_PASSWORD_REQUIRED   \"ChallengeName\":
  \"NEW_PASSWORD_REQUIRED\", \"ChallengeResponses\": {\"NEW_PASSWORD\": \"[new_password]\",
  \"USERNAME\": \"[username]\"}  To set any required attributes that InitiateAuth returned in
  an requiredAttributes parameter, add \"userAttributes.[attribute_name]\":
  \"[attribute_value]\". This parameter can also set values for writable attributes that
  aren't required by your user pool.  In a NEW_PASSWORD_REQUIRED challenge response, you
  can't modify a required attribute that already has a value. In RespondToAuthChallenge, set
  a value for any keys that Amazon Cognito returned in the requiredAttributes parameter, then
  use the UpdateUserAttributes API operation to modify the value of any additional
  attributes.   SOFTWARE_TOKEN_MFA   \"ChallengeName\": \"SOFTWARE_TOKEN_MFA\",
  \"ChallengeResponses\": {\"USERNAME\": \"[username]\", \"SOFTWARE_TOKEN_MFA_CODE\":
  [authenticator_code]}   DEVICE_SRP_AUTH   \"ChallengeName\": \"DEVICE_SRP_AUTH\",
  \"ChallengeResponses\": {\"USERNAME\": \"[username]\", \"DEVICE_KEY\": \"[device_key]\",
  \"SRP_A\": \"[srp_a]\"}   DEVICE_PASSWORD_VERIFIER   \"ChallengeName\":
  \"DEVICE_PASSWORD_VERIFIER\", \"ChallengeResponses\": {\"DEVICE_KEY\": \"[device_key]\",
  \"PASSWORD_CLAIM_SIGNATURE\": \"[claim_signature]\", \"PASSWORD_CLAIM_SECRET_BLOCK\":
  \"[secret_block]\", \"TIMESTAMP\": [timestamp], \"USERNAME\": \"[username]\"}   MFA_SETUP
  \"ChallengeName\": \"MFA_SETUP\", \"ChallengeResponses\": {\"USERNAME\": \"[username]\"},
  \"SESSION\": \"[Session ID from VerifySoftwareToken]\"   SELECT_MFA_TYPE
  \"ChallengeName\": \"SELECT_MFA_TYPE\", \"ChallengeResponses\": {\"USERNAME\":
  \"[username]\", \"ANSWER\": \"[SMS_MFA or SOFTWARE_TOKEN_MFA]\"}    For more information
  about SECRET_HASH, see Computing secret hash values. For information about DEVICE_KEY, see
  Working with user devices in your user pool.
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for any
  custom workflows that this action triggers. You create custom workflows by assigning Lambda
  functions to user pool triggers. When you use the RespondToAuthChallenge API action, Amazon
  Cognito invokes any functions that are assigned to the following triggers: post
  authentication, pre token generation, define auth challenge, create auth challenge, and
  verify auth challenge. When Amazon Cognito invokes any of these functions, it passes a JSON
  payload, which the function receives as input. This payload contains a clientMetadata
  attribute, which provides the data that you assigned to the ClientMetadata parameter in
  your RespondToAuthChallenge request. In your function code in Lambda, you can process the
  clientMetadata value to enhance your workflow for your specific needs. For more
  information, see  Customizing user pool Workflows with Lambda Triggers in the Amazon
  Cognito Developer Guide.  When you use the ClientMetadata parameter, remember that Amazon
  Cognito won't do the following:   Store the ClientMetadata value. This data is available
  only to Lambda triggers that are assigned to a user pool to support custom workflows. If
  your user pool configuration doesn't include triggers, the ClientMetadata parameter serves
  no purpose.   Validate the ClientMetadata value.   Encrypt the ClientMetadata value. Don't
  use Amazon Cognito to provide sensitive information.
- `"Session"`: The session that should be passed both ways in challenge-response calls to
  the service. If InitiateAuth or RespondToAuthChallenge API call determines that the caller
  must pass another challenge, they return a session with other challenge parameters. This
  session should be passed as it is to the next RespondToAuthChallenge API call.
- `"UserContextData"`: Contextual data about your user session, such as the device
  fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk
  of an authentication event based on the context that your app generates and passes to
  Amazon Cognito when it makes API requests.
"""
function respond_to_auth_challenge(
    ChallengeName, ClientId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "RespondToAuthChallenge",
        Dict{String,Any}("ChallengeName" => ChallengeName, "ClientId" => ClientId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function respond_to_auth_challenge(
    ChallengeName,
    ClientId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "RespondToAuthChallenge",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChallengeName" => ChallengeName, "ClientId" => ClientId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    revoke_token(client_id, token)
    revoke_token(client_id, token, params::Dict{String,<:Any})

Revokes all of the access tokens generated by, and at the same time as, the specified
refresh token. After a token is revoked, you can't use the revoked token to access Amazon
Cognito user APIs, or to authorize access to your resource server.  Amazon Cognito doesn't
evaluate Identity and Access Management (IAM) policies in requests for this API operation.
For this operation, you can't use IAM credentials to authorize requests, and you can't
grant IAM permissions in policies. For more information about authorization models in
Amazon Cognito, see Using the Amazon Cognito user pools API and user pool endpoints.

# Arguments
- `client_id`: The client ID for the token that you want to revoke.
- `token`: The refresh token that you want to revoke.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientSecret"`: The secret for the client ID. This is required only if the client ID
  has a secret.
"""
function revoke_token(ClientId, Token; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "RevokeToken",
        Dict{String,Any}("ClientId" => ClientId, "Token" => Token);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function revoke_token(
    ClientId,
    Token,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "RevokeToken",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClientId" => ClientId, "Token" => Token), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_log_delivery_configuration(log_configurations, user_pool_id)
    set_log_delivery_configuration(log_configurations, user_pool_id, params::Dict{String,<:Any})

Sets up or modifies the detailed activity logging configuration of a user pool.

# Arguments
- `log_configurations`: A collection of all of the detailed activity logging configurations
  for a user pool.
- `user_pool_id`: The ID of the user pool where you want to configure detailed activity
  logging .

"""
function set_log_delivery_configuration(
    LogConfigurations, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "SetLogDeliveryConfiguration",
        Dict{String,Any}(
            "LogConfigurations" => LogConfigurations, "UserPoolId" => UserPoolId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_log_delivery_configuration(
    LogConfigurations,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "SetLogDeliveryConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LogConfigurations" => LogConfigurations, "UserPoolId" => UserPoolId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_risk_configuration(user_pool_id)
    set_risk_configuration(user_pool_id, params::Dict{String,<:Any})

Configures actions on detected risks. To delete the risk configuration for UserPoolId or
ClientId, pass null values for all four configuration types. To activate Amazon Cognito
advanced security features, update the user pool to include the UserPoolAddOns
keyAdvancedSecurityMode.

# Arguments
- `user_pool_id`: The user pool ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountTakeoverRiskConfiguration"`: The account takeover risk configuration.
- `"ClientId"`: The app client ID. If ClientId is null, then the risk configuration is
  mapped to userPoolId. When the client ID is null, the same risk configuration is applied to
  all the clients in the userPool. Otherwise, ClientId is mapped to the client. When the
  client ID isn't null, the user pool configuration is overridden and the risk configuration
  for the client is used instead.
- `"CompromisedCredentialsRiskConfiguration"`: The compromised credentials risk
  configuration.
- `"RiskExceptionConfiguration"`: The configuration to override the risk decision.
"""
function set_risk_configuration(
    UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "SetRiskConfiguration",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_risk_configuration(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "SetRiskConfiguration",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_uicustomization(user_pool_id)
    set_uicustomization(user_pool_id, params::Dict{String,<:Any})

Sets the user interface (UI) customization information for a user pool's built-in app UI.
You can specify app UI customization settings for a single client (with a specific
clientId) or for all clients (by setting the clientId to ALL). If you specify ALL, the
default configuration is used for every client that has no previously set UI customization.
If you specify UI customization settings for a particular client, it will no longer return
to the ALL configuration.  To use this API, your user pool must have a domain associated
with it. Otherwise, there is no place to host the app's pages, and the service will throw
an error.

# Arguments
- `user_pool_id`: The user pool ID for the user pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CSS"`: The CSS values in the UI customization.
- `"ClientId"`: The client ID for the client app.
- `"ImageFile"`: The uploaded logo image for the UI customization.
"""
function set_uicustomization(UserPoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "SetUICustomization",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_uicustomization(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "SetUICustomization",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_user_mfapreference(access_token)
    set_user_mfapreference(access_token, params::Dict{String,<:Any})

Set the user's multi-factor authentication (MFA) method preference, including which MFA
factors are activated and if any are preferred. Only one factor can be set as preferred.
The preferred MFA factor will be used to authenticate a user if multiple factors are
activated. If multiple options are activated and no preference is set, a challenge to
choose an MFA option will be returned during sign-in. If an MFA type is activated for a
user, the user will be prompted for MFA during all sign-in attempts unless device tracking
is turned on and the device has been trusted. If you want MFA to be applied selectively
based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on
Adaptive Authentication for the user pool. Authorize this action with a signed-in user's
access token. It must include the scope aws.cognito.signin.user.admin.  Amazon Cognito
doesn't evaluate Identity and Access Management (IAM) policies in requests for this API
operation. For this operation, you can't use IAM credentials to authorize requests, and you
can't grant IAM permissions in policies. For more information about authorization models in
Amazon Cognito, see Using the Amazon Cognito user pools API and user pool endpoints.

# Arguments
- `access_token`: A valid access token that Amazon Cognito issued to the user whose MFA
  preference you want to set.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SMSMfaSettings"`: The SMS text message multi-factor authentication (MFA) settings.
- `"SoftwareTokenMfaSettings"`: The time-based one-time password (TOTP) software token MFA
  settings.
"""
function set_user_mfapreference(
    AccessToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "SetUserMFAPreference",
        Dict{String,Any}("AccessToken" => AccessToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_user_mfapreference(
    AccessToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "SetUserMFAPreference",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AccessToken" => AccessToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_user_pool_mfa_config(user_pool_id)
    set_user_pool_mfa_config(user_pool_id, params::Dict{String,<:Any})

Sets the user pool multi-factor authentication (MFA) configuration.  This action might
generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to
register an origination phone number before you can send SMS messages to US phone numbers.
If you use SMS text messages in Amazon Cognito, you must register a phone number with
Amazon Pinpoint. Amazon Cognito uses the registered number automatically. Otherwise, Amazon
Cognito users who must receive SMS messages might not be able to sign up, activate their
accounts, or sign in. If you have never used SMS text messages with Amazon Cognito or any
other Amazon Web Service, Amazon Simple Notification Service might place your account in
the SMS sandbox. In  sandbox mode , you can send messages only to verified phone numbers.
After you test your app while in the sandbox environment, you can move out of the sandbox
and into production. For more information, see  SMS message settings for Amazon Cognito
user pools in the Amazon Cognito Developer Guide.

# Arguments
- `user_pool_id`: The user pool ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MfaConfiguration"`: The MFA configuration. If you set the MfaConfiguration value to
  ‘ON’, only users who have set up an MFA factor can sign in. To learn more, see Adding
  Multi-Factor Authentication (MFA) to a user pool. Valid values include:    OFF MFA won't be
  used for any users.    ON MFA is required for all users to sign in.    OPTIONAL MFA will be
  required only for individual users who have an MFA factor activated.
- `"SmsMfaConfiguration"`: The SMS text message MFA configuration.
- `"SoftwareTokenMfaConfiguration"`: The software token MFA configuration.
"""
function set_user_pool_mfa_config(
    UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "SetUserPoolMfaConfig",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_user_pool_mfa_config(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "SetUserPoolMfaConfig",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_user_settings(access_token, mfaoptions)
    set_user_settings(access_token, mfaoptions, params::Dict{String,<:Any})

 This action is no longer supported. You can use it to configure only SMS MFA. You can't
use it to configure time-based one-time password (TOTP) software token MFA. To configure
either type of MFA, use SetUserMFAPreference instead. Authorize this action with a
signed-in user's access token. It must include the scope aws.cognito.signin.user.admin.
Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies in requests
for this API operation. For this operation, you can't use IAM credentials to authorize
requests, and you can't grant IAM permissions in policies. For more information about
authorization models in Amazon Cognito, see Using the Amazon Cognito user pools API and
user pool endpoints.

# Arguments
- `access_token`: A valid access token that Amazon Cognito issued to the user whose user
  settings you want to configure.
- `mfaoptions`: You can use this parameter only to set an SMS configuration that uses SMS
  for delivery.

"""
function set_user_settings(
    AccessToken, MFAOptions; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "SetUserSettings",
        Dict{String,Any}("AccessToken" => AccessToken, "MFAOptions" => MFAOptions);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_user_settings(
    AccessToken,
    MFAOptions,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "SetUserSettings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccessToken" => AccessToken, "MFAOptions" => MFAOptions),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    sign_up(client_id, password, username)
    sign_up(client_id, password, username, params::Dict{String,<:Any})

Registers the user in the specified user pool and creates a user name, password, and user
attributes.  Amazon Cognito doesn't evaluate Identity and Access Management (IAM) policies
in requests for this API operation. For this operation, you can't use IAM credentials to
authorize requests, and you can't grant IAM permissions in policies. For more information
about authorization models in Amazon Cognito, see Using the Amazon Cognito user pools API
and user pool endpoints.   This action might generate an SMS text message. Starting June 1,
2021, US telecom carriers require you to register an origination phone number before you
can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito,
you must register a phone number with Amazon Pinpoint. Amazon Cognito uses the registered
number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might
not be able to sign up, activate their accounts, or sign in. If you have never used SMS
text messages with Amazon Cognito or any other Amazon Web Service, Amazon Simple
Notification Service might place your account in the SMS sandbox. In  sandbox mode , you
can send messages only to verified phone numbers. After you test your app while in the
sandbox environment, you can move out of the sandbox and into production. For more
information, see  SMS message settings for Amazon Cognito user pools in the Amazon Cognito
Developer Guide.

# Arguments
- `client_id`: The ID of the client associated with the user pool.
- `password`: The password of the user you want to register.
- `username`: The username of the user that you want to sign up. The value of this
  parameter is typically a username, but can be any alias attribute in your user pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnalyticsMetadata"`: The Amazon Pinpoint analytics metadata that contributes to your
  metrics for SignUp calls.
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for any
  custom workflows that this action triggers. You create custom workflows by assigning Lambda
  functions to user pool triggers. When you use the SignUp API action, Amazon Cognito invokes
  any functions that are assigned to the following triggers: pre sign-up, custom message, and
  post confirmation. When Amazon Cognito invokes any of these functions, it passes a JSON
  payload, which the function receives as input. This payload contains a clientMetadata
  attribute, which provides the data that you assigned to the ClientMetadata parameter in
  your SignUp request. In your function code in Lambda, you can process the clientMetadata
  value to enhance your workflow for your specific needs. For more information, see
  Customizing user pool Workflows with Lambda Triggers in the Amazon Cognito Developer Guide.
   When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the
  following:   Store the ClientMetadata value. This data is available only to Lambda triggers
  that are assigned to a user pool to support custom workflows. If your user pool
  configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
  Validate the ClientMetadata value.   Encrypt the ClientMetadata value. Don't use Amazon
  Cognito to provide sensitive information.
- `"SecretHash"`: A keyed-hash message authentication code (HMAC) calculated using the
  secret key of a user pool client and username plus the client ID in the message.
- `"UserAttributes"`: An array of name-value pairs representing user attributes. For custom
  attributes, you must prepend the custom: prefix to the attribute name.
- `"UserContextData"`: Contextual data about your user session, such as the device
  fingerprint, IP address, or location. Amazon Cognito advanced security evaluates the risk
  of an authentication event based on the context that your app generates and passes to
  Amazon Cognito when it makes API requests.
- `"ValidationData"`: Temporary user attributes that contribute to the outcomes of your pre
  sign-up Lambda trigger. This set of key-value pairs are for custom validation of
  information that you collect from your users but don't need to retain. Your Lambda function
  can analyze this additional data and act on it. Your function might perform external API
  operations like logging user attributes and validation data to Amazon CloudWatch Logs.
  Validation data might also affect the response that your function returns to Amazon
  Cognito, like automatically confirming the user if they sign up from within your network.
  For more information about the pre sign-up Lambda trigger, see Pre sign-up Lambda trigger.
"""
function sign_up(
    ClientId, Password, Username; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "SignUp",
        Dict{String,Any}(
            "ClientId" => ClientId, "Password" => Password, "Username" => Username
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function sign_up(
    ClientId,
    Password,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "SignUp",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientId" => ClientId, "Password" => Password, "Username" => Username
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_user_import_job(job_id, user_pool_id)
    start_user_import_job(job_id, user_pool_id, params::Dict{String,<:Any})

Starts the user import.

# Arguments
- `job_id`: The job ID for the user import job.
- `user_pool_id`: The user pool ID for the user pool that the users are being imported into.

"""
function start_user_import_job(
    JobId, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "StartUserImportJob",
        Dict{String,Any}("JobId" => JobId, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_user_import_job(
    JobId,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "StartUserImportJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("JobId" => JobId, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_user_import_job(job_id, user_pool_id)
    stop_user_import_job(job_id, user_pool_id, params::Dict{String,<:Any})

Stops the user import job.

# Arguments
- `job_id`: The job ID for the user import job.
- `user_pool_id`: The user pool ID for the user pool that the users are being imported into.

"""
function stop_user_import_job(
    JobId, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "StopUserImportJob",
        Dict{String,Any}("JobId" => JobId, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_user_import_job(
    JobId,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "StopUserImportJob",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("JobId" => JobId, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to
categorize and manage user pools in different ways, such as by purpose, owner, environment,
or other criteria. Each tag consists of a key and value, both of which you define. A key is
a general category for more specific values. For example, if you have two versions of a
user pool, one for testing and another for production, you might assign an Environment tag
key to both user pools. The value of this key might be Test for one user pool, and
Production for the other. Tags are useful for cost tracking and access control. You can
activate your tags so that they appear on the Billing and Cost Management console, where
you can track the costs associated with your user pools. In an Identity and Access
Management policy, you can constrain permissions for user pools based on specific tags or
tag values. You can use this action up to 5 times per second, per account. A user pool can
have as many as 50 tags.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the user pool to assign the tags to.
- `tags`: The tags to assign to the user pool.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "TagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes the specified tags from an Amazon Cognito user pool. You can use this action up to
5 times per second, per account.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the user pool that the tags are
  assigned to.
- `tag_keys`: The keys of the tags to remove from the user pool.

"""
function untag_resource(
    ResourceArn, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "UntagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceArn" => ResourceArn, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_auth_event_feedback(event_id, feedback_token, feedback_value, user_pool_id, username)
    update_auth_event_feedback(event_id, feedback_token, feedback_value, user_pool_id, username, params::Dict{String,<:Any})

Provides the feedback for an authentication event, whether it was from a valid user or not.
This feedback is used for improving the risk evaluation decision for the user pool as part
of Amazon Cognito advanced security.  Amazon Cognito doesn't evaluate Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you can't
use IAM credentials to authorize requests, and you can't grant IAM permissions in policies.
For more information about authorization models in Amazon Cognito, see Using the Amazon
Cognito user pools API and user pool endpoints.

# Arguments
- `event_id`: The event ID.
- `feedback_token`: The feedback token.
- `feedback_value`: The authentication event feedback value. When you provide a
  FeedbackValue value of valid, you tell Amazon Cognito that you trust a user session where
  Amazon Cognito has evaluated some level of risk. When you provide a FeedbackValue value of
  invalid, you tell Amazon Cognito that you don't trust a user session, or you don't believe
  that Amazon Cognito evaluated a high-enough risk level.
- `user_pool_id`: The user pool ID.
- `username`: The username of the user that you want to query or modify. The value of this
  parameter is typically your user's username, but it can be any of their alias attributes.
  If username isn't an alias attribute in your user pool, this value must be the sub of a
  local user or the username of a user from a third-party IdP.

"""
function update_auth_event_feedback(
    EventId,
    FeedbackToken,
    FeedbackValue,
    UserPoolId,
    Username;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "UpdateAuthEventFeedback",
        Dict{String,Any}(
            "EventId" => EventId,
            "FeedbackToken" => FeedbackToken,
            "FeedbackValue" => FeedbackValue,
            "UserPoolId" => UserPoolId,
            "Username" => Username,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_auth_event_feedback(
    EventId,
    FeedbackToken,
    FeedbackValue,
    UserPoolId,
    Username,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "UpdateAuthEventFeedback",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EventId" => EventId,
                    "FeedbackToken" => FeedbackToken,
                    "FeedbackValue" => FeedbackValue,
                    "UserPoolId" => UserPoolId,
                    "Username" => Username,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_device_status(access_token, device_key)
    update_device_status(access_token, device_key, params::Dict{String,<:Any})

Updates the device status. For more information about device authentication, see Working
with user devices in your user pool. Authorize this action with a signed-in user's access
token. It must include the scope aws.cognito.signin.user.admin.  Amazon Cognito doesn't
evaluate Identity and Access Management (IAM) policies in requests for this API operation.
For this operation, you can't use IAM credentials to authorize requests, and you can't
grant IAM permissions in policies. For more information about authorization models in
Amazon Cognito, see Using the Amazon Cognito user pools API and user pool endpoints.

# Arguments
- `access_token`: A valid access token that Amazon Cognito issued to the user whose device
  status you want to update.
- `device_key`: The device key.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeviceRememberedStatus"`: The status of whether a device is remembered.
"""
function update_device_status(
    AccessToken, DeviceKey; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "UpdateDeviceStatus",
        Dict{String,Any}("AccessToken" => AccessToken, "DeviceKey" => DeviceKey);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_device_status(
    AccessToken,
    DeviceKey,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "UpdateDeviceStatus",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AccessToken" => AccessToken, "DeviceKey" => DeviceKey),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_group(group_name, user_pool_id)
    update_group(group_name, user_pool_id, params::Dict{String,<:Any})

Updates the specified group with the specified attributes.  Amazon Cognito evaluates
Identity and Access Management (IAM) policies in requests for this API operation. For this
operation, you must use IAM credentials to authorize requests, and you must grant yourself
the corresponding IAM permission in a policy.  Learn more     Signing Amazon Web Services
API Requests     Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `group_name`: The name of the group.
- `user_pool_id`: The user pool ID for the user pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A string containing the new description of the group.
- `"Precedence"`: The new precedence value for the group. For more information about this
  parameter, see CreateGroup.
- `"RoleArn"`: The new role Amazon Resource Name (ARN) for the group. This is used for
  setting the cognito:roles and cognito:preferred_role claims in the token.
"""
function update_group(
    GroupName, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "UpdateGroup",
        Dict{String,Any}("GroupName" => GroupName, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_group(
    GroupName,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "UpdateGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GroupName" => GroupName, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_identity_provider(provider_name, user_pool_id)
    update_identity_provider(provider_name, user_pool_id, params::Dict{String,<:Any})

Updates IdP information for a user pool.  Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `provider_name`: The IdP name.
- `user_pool_id`: The user pool ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AttributeMapping"`: The IdP attribute mapping to be changed.
- `"IdpIdentifiers"`: A list of IdP identifiers.
- `"ProviderDetails"`: The scopes, URLs, and identifiers for your external identity
  provider. The following examples describe the provider detail keys for each IdP type. These
  values and their schema are subject to change. Social IdP authorize_scopes values must
  match the values listed here.  OpenID Connect (OIDC)  Amazon Cognito accepts the following
  elements when it can't discover endpoint URLs from oidc_issuer: attributes_url,
  authorize_url, jwks_uri, token_url. Create or update request: \"ProviderDetails\": {
  \"attributes_request_method\": \"GET\", \"attributes_url\":
  \"https://auth.example.com/userInfo\", \"authorize_scopes\": \"openid profile email\",
  \"authorize_url\": \"https://auth.example.com/authorize\", \"client_id\":
  \"1example23456789\", \"client_secret\": \"provider-app-client-secret\", \"jwks_uri\":
  \"https://auth.example.com/.well-known/jwks.json\", \"oidc_issuer\":
  \"https://auth.example.com\", \"token_url\": \"https://example.com/token\" }  Describe
  response: \"ProviderDetails\": { \"attributes_request_method\": \"GET\",
  \"attributes_url\": \"https://auth.example.com/userInfo\",
  \"attributes_url_add_attributes\": \"false\", \"authorize_scopes\": \"openid profile
  email\", \"authorize_url\": \"https://auth.example.com/authorize\", \"client_id\":
  \"1example23456789\", \"client_secret\": \"provider-app-client-secret\", \"jwks_uri\":
  \"https://auth.example.com/.well-known/jwks.json\", \"oidc_issuer\":
  \"https://auth.example.com\", \"token_url\": \"https://example.com/token\" }   SAML  Create
  or update request with Metadata URL: \"ProviderDetails\": { \"IDPInit\": \"true\",
  \"IDPSignout\": \"true\", \"EncryptedResponses\" : \"true\", \"MetadataURL\":
  \"https://auth.example.com/sso/saml/metadata\", \"RequestSigningAlgorithm\": \"rsa-sha256\"
  }  Create or update request with Metadata file: \"ProviderDetails\": { \"IDPInit\":
  \"true\", \"IDPSignout\": \"true\", \"EncryptedResponses\" : \"true\", \"MetadataFile\":
  \"[metadata XML]\", \"RequestSigningAlgorithm\": \"rsa-sha256\" }  The value of
  MetadataFile must be the plaintext metadata document with all quote (\") characters escaped
  by backslashes. Describe response: \"ProviderDetails\": { \"IDPInit\": \"true\",
  \"IDPSignout\": \"true\", \"EncryptedResponses\" : \"true\",
  \"ActiveEncryptionCertificate\": \"[certificate]\", \"MetadataURL\":
  \"https://auth.example.com/sso/saml/metadata\", \"RequestSigningAlgorithm\":
  \"rsa-sha256\", \"SLORedirectBindingURI\": \"https://auth.example.com/slo/saml\",
  \"SSORedirectBindingURI\": \"https://auth.example.com/sso/saml\" }   LoginWithAmazon
  Create or update request: \"ProviderDetails\": { \"authorize_scopes\": \"profile
  postal_code\", \"client_id\": \"amzn1.application-oa2-client.1example23456789\",
  \"client_secret\": \"provider-app-client-secret\"  Describe response: \"ProviderDetails\":
  { \"attributes_url\": \"https://api.amazon.com/user/profile\",
  \"attributes_url_add_attributes\": \"false\", \"authorize_scopes\": \"profile
  postal_code\", \"authorize_url\": \"https://www.amazon.com/ap/oa\", \"client_id\":
  \"amzn1.application-oa2-client.1example23456789\", \"client_secret\":
  \"provider-app-client-secret\", \"token_request_method\": \"POST\", \"token_url\":
  \"https://api.amazon.com/auth/o2/token\" }   Google  Create or update request:
  \"ProviderDetails\": { \"authorize_scopes\": \"email profile openid\", \"client_id\":
  \"1example23456789.apps.googleusercontent.com\", \"client_secret\":
  \"provider-app-client-secret\" }  Describe response: \"ProviderDetails\": {
  \"attributes_url\": \"https://people.googleapis.com/v1/people/me?personFields=\",
  \"attributes_url_add_attributes\": \"true\", \"authorize_scopes\": \"email profile
  openid\", \"authorize_url\": \"https://accounts.google.com/o/oauth2/v2/auth\",
  \"client_id\": \"1example23456789.apps.googleusercontent.com\", \"client_secret\":
  \"provider-app-client-secret\", \"oidc_issuer\": \"https://accounts.google.com\",
  \"token_request_method\": \"POST\", \"token_url\":
  \"https://www.googleapis.com/oauth2/v4/token\" }   SignInWithApple  Create or update
  request: \"ProviderDetails\": { \"authorize_scopes\": \"email name\", \"client_id\":
  \"com.example.cognito\", \"private_key\": \"1EXAMPLE\", \"key_id\": \"2EXAMPLE\",
  \"team_id\": \"3EXAMPLE\" }  Describe response: \"ProviderDetails\": {
  \"attributes_url_add_attributes\": \"false\", \"authorize_scopes\": \"email name\",
  \"authorize_url\": \"https://appleid.apple.com/auth/authorize\", \"client_id\":
  \"com.example.cognito\", \"key_id\": \"1EXAMPLE\", \"oidc_issuer\":
  \"https://appleid.apple.com\", \"team_id\": \"2EXAMPLE\", \"token_request_method\":
  \"POST\", \"token_url\": \"https://appleid.apple.com/auth/token\" }   Facebook  Create or
  update request: \"ProviderDetails\": { \"api_version\": \"v17.0\", \"authorize_scopes\":
  \"public_profile, email\", \"client_id\": \"1example23456789\", \"client_secret\":
  \"provider-app-client-secret\" }  Describe response: \"ProviderDetails\": {
  \"api_version\": \"v17.0\", \"attributes_url\":
  \"https://graph.facebook.com/v17.0/me?fields=\", \"attributes_url_add_attributes\":
  \"true\", \"authorize_scopes\": \"public_profile, email\", \"authorize_url\":
  \"https://www.facebook.com/v17.0/dialog/oauth\", \"client_id\": \"1example23456789\",
  \"client_secret\": \"provider-app-client-secret\", \"token_request_method\": \"GET\",
  \"token_url\": \"https://graph.facebook.com/v17.0/oauth/access_token\" }
"""
function update_identity_provider(
    ProviderName, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "UpdateIdentityProvider",
        Dict{String,Any}("ProviderName" => ProviderName, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_identity_provider(
    ProviderName,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "UpdateIdentityProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ProviderName" => ProviderName, "UserPoolId" => UserPoolId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_resource_server(identifier, name, user_pool_id)
    update_resource_server(identifier, name, user_pool_id, params::Dict{String,<:Any})

Updates the name and scopes of resource server. All other fields are read-only.  If you
don't provide a value for an attribute, it is set to the default value.   Amazon Cognito
evaluates Identity and Access Management (IAM) policies in requests for this API operation.
For this operation, you must use IAM credentials to authorize requests, and you must grant
yourself the corresponding IAM permission in a policy.  Learn more     Signing Amazon Web
Services API Requests     Using the Amazon Cognito user pools API and user pool endpoints


# Arguments
- `identifier`: A unique resource server identifier for the resource server. The identifier
  can be an API friendly name like solar-system-data. You can also set an API URL like
  https://solar-system-data-api.example.com as your identifier. Amazon Cognito represents
  scopes in the access token in the format resource-server-identifier/scope. Longer
  scope-identifier strings increase the size of your access tokens.
- `name`: The name of the resource server.
- `user_pool_id`: The user pool ID for the user pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Scopes"`: The scope values to be set for the resource server.
"""
function update_resource_server(
    Identifier, Name, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "UpdateResourceServer",
        Dict{String,Any}(
            "Identifier" => Identifier, "Name" => Name, "UserPoolId" => UserPoolId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_resource_server(
    Identifier,
    Name,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "UpdateResourceServer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Identifier" => Identifier, "Name" => Name, "UserPoolId" => UserPoolId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_user_attributes(access_token, user_attributes)
    update_user_attributes(access_token, user_attributes, params::Dict{String,<:Any})

With this operation, your users can update one or more of their attributes with their own
credentials. You authorize this API request with the user's access token. To delete an
attribute from your user, submit the attribute in your API request with a blank value.
Custom attribute values in this request must include the custom: prefix. Authorize this
action with a signed-in user's access token. It must include the scope
aws.cognito.signin.user.admin.  Amazon Cognito doesn't evaluate Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you can't
use IAM credentials to authorize requests, and you can't grant IAM permissions in policies.
For more information about authorization models in Amazon Cognito, see Using the Amazon
Cognito user pools API and user pool endpoints.   This action might generate an SMS text
message. Starting June 1, 2021, US telecom carriers require you to register an origination
phone number before you can send SMS messages to US phone numbers. If you use SMS text
messages in Amazon Cognito, you must register a phone number with Amazon Pinpoint. Amazon
Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must
receive SMS messages might not be able to sign up, activate their accounts, or sign in. If
you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service,
Amazon Simple Notification Service might place your account in the SMS sandbox. In  sandbox
mode , you can send messages only to verified phone numbers. After you test your app while
in the sandbox environment, you can move out of the sandbox and into production. For more
information, see  SMS message settings for Amazon Cognito user pools in the Amazon Cognito
Developer Guide.

# Arguments
- `access_token`: A valid access token that Amazon Cognito issued to the user whose user
  attributes you want to update.
- `user_attributes`: An array of name-value pairs representing user attributes. For custom
  attributes, you must prepend the custom: prefix to the attribute name. If you have set an
  attribute to require verification before Amazon Cognito updates its value, this request
  doesn’t immediately update the value of that attribute. After your user receives and
  responds to a verification message to verify the new value, Amazon Cognito updates the
  attribute value. Your user can sign in and receive messages with the original attribute
  value until they verify the new value.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientMetadata"`: A map of custom key-value pairs that you can provide as input for any
  custom workflows that this action initiates.  You create custom workflows by assigning
  Lambda functions to user pool triggers. When you use the UpdateUserAttributes API action,
  Amazon Cognito invokes the function that is assigned to the custom message trigger. When
  Amazon Cognito invokes this function, it passes a JSON payload, which the function receives
  as input. This payload contains a clientMetadata attribute, which provides the data that
  you assigned to the ClientMetadata parameter in your UpdateUserAttributes request. In your
  function code in Lambda, you can process the clientMetadata value to enhance your workflow
  for your specific needs. For more information, see  Customizing user pool Workflows with
  Lambda Triggers in the Amazon Cognito Developer Guide.  When you use the ClientMetadata
  parameter, remember that Amazon Cognito won't do the following:   Store the ClientMetadata
  value. This data is available only to Lambda triggers that are assigned to a user pool to
  support custom workflows. If your user pool configuration doesn't include triggers, the
  ClientMetadata parameter serves no purpose.   Validate the ClientMetadata value.   Encrypt
  the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
"""
function update_user_attributes(
    AccessToken, UserAttributes; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "UpdateUserAttributes",
        Dict{String,Any}("AccessToken" => AccessToken, "UserAttributes" => UserAttributes);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_user_attributes(
    AccessToken,
    UserAttributes,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "UpdateUserAttributes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccessToken" => AccessToken, "UserAttributes" => UserAttributes
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_user_pool(user_pool_id)
    update_user_pool(user_pool_id, params::Dict{String,<:Any})

 This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers
require you to register an origination phone number before you can send SMS messages to US
phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone
number with Amazon Pinpoint. Amazon Cognito uses the registered number automatically.
Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up,
activate their accounts, or sign in. If you have never used SMS text messages with Amazon
Cognito or any other Amazon Web Service, Amazon Simple Notification Service might place
your account in the SMS sandbox. In  sandbox mode , you can send messages only to verified
phone numbers. After you test your app while in the sandbox environment, you can move out
of the sandbox and into production. For more information, see  SMS message settings for
Amazon Cognito user pools in the Amazon Cognito Developer Guide.  Updates the specified
user pool with the specified attributes. You can get a list of the current user pool
settings using DescribeUserPool.  If you don't provide a value for an attribute, Amazon
Cognito sets it to its default value.   Amazon Cognito evaluates Identity and Access
Management (IAM) policies in requests for this API operation. For this operation, you must
use IAM credentials to authorize requests, and you must grant yourself the corresponding
IAM permission in a policy.  Learn more     Signing Amazon Web Services API Requests
Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `user_pool_id`: The user pool ID for the user pool you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountRecoverySetting"`: The available verified method a user can use to recover their
  password when they call ForgotPassword. You can use this setting to define a preferred
  method when a user has more than one method available. With this setting, SMS doesn't
  qualify for a valid password recovery mechanism if the user also has SMS multi-factor
  authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the
  legacy behavior to determine the recovery method where SMS is preferred through email.
- `"AdminCreateUserConfig"`: The configuration for AdminCreateUser requests.
- `"AutoVerifiedAttributes"`: The attributes that are automatically verified when Amazon
  Cognito requests to update user pools.
- `"DeletionProtection"`: When active, DeletionProtection prevents accidental deletion of
  your user pool. Before you can delete a user pool that you have protected against deletion,
  you must deactivate this feature. When you try to delete a protected user pool in a
  DeleteUserPool API request, Amazon Cognito returns an InvalidParameterException error. To
  delete a protected user pool, send a new DeleteUserPool request after you deactivate
  deletion protection in an UpdateUserPool API request.
- `"DeviceConfiguration"`: The device-remembering configuration for a user pool. A null
  value indicates that you have deactivated device remembering in your user pool.  When you
  provide a value for any DeviceConfiguration field, you activate the Amazon Cognito
  device-remembering feature.
- `"EmailConfiguration"`: The email configuration of your user pool. The email
  configuration type sets your preferred sending method, Amazon Web Services Region, and
  sender for email invitation and verification messages from your user pool.
- `"EmailVerificationMessage"`: This parameter is no longer used. See
  VerificationMessageTemplateType.
- `"EmailVerificationSubject"`: This parameter is no longer used. See
  VerificationMessageTemplateType.
- `"LambdaConfig"`: The Lambda configuration information from the request to update the
  user pool.
- `"MfaConfiguration"`: Possible values include:    OFF - MFA tokens aren't required and
  can't be specified during user registration.    ON - MFA tokens are required for all user
  registrations. You can only specify ON when you're initially creating a user pool. You can
  use the SetUserPoolMfaConfig API operation to turn MFA \"ON\" for existing user pools.
  OPTIONAL - Users have the option when registering to create an MFA token.
- `"Policies"`: A container with the policies you want to update in a user pool.
- `"SmsAuthenticationMessage"`: The contents of the SMS authentication message.
- `"SmsConfiguration"`: The SMS configuration with the settings that your Amazon Cognito
  user pool must use to send an SMS message from your Amazon Web Services account through
  Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web
  Services Region that you want, the Amazon Cognito user pool uses an Identity and Access
  Management (IAM) role in your Amazon Web Services account.
- `"SmsVerificationMessage"`: This parameter is no longer used. See
  VerificationMessageTemplateType.
- `"UserAttributeUpdateSettings"`: The settings for updates to user attributes. These
  settings include the property AttributesRequireVerificationBeforeUpdate, a user-pool
  setting that tells Amazon Cognito how to handle changes to the value of your users' email
  address and phone number attributes. For more information, see  Verifying updates to email
  addresses and phone numbers.
- `"UserPoolAddOns"`: User pool add-ons. Contains settings for activation of advanced
  security features. To log user security information but take no action, set to AUDIT. To
  configure automatic security responses to risky traffic to your user pool, set to ENFORCED.
  For more information, see Adding advanced security to a user pool.
- `"UserPoolTags"`: The tag keys and values to assign to the user pool. A tag is a label
  that you can use to categorize and manage user pools in different ways, such as by purpose,
  owner, environment, or other criteria.
- `"VerificationMessageTemplate"`: The template for verification messages.
"""
function update_user_pool(UserPoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "UpdateUserPool",
        Dict{String,Any}("UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_user_pool(
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "UpdateUserPool",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserPoolId" => UserPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_user_pool_client(client_id, user_pool_id)
    update_user_pool_client(client_id, user_pool_id, params::Dict{String,<:Any})

Updates the specified user pool app client with the specified attributes. You can get a
list of the current user pool app client settings using DescribeUserPoolClient.  If you
don't provide a value for an attribute, Amazon Cognito sets it to its default value.  You
can also use this operation to enable token revocation for user pool clients. For more
information about revoking tokens, see RevokeToken.  Amazon Cognito evaluates Identity and
Access Management (IAM) policies in requests for this API operation. For this operation,
you must use IAM credentials to authorize requests, and you must grant yourself the
corresponding IAM permission in a policy.  Learn more     Signing Amazon Web Services API
Requests     Using the Amazon Cognito user pools API and user pool endpoints

# Arguments
- `client_id`: The ID of the client associated with the user pool.
- `user_pool_id`: The user pool ID for the user pool where you want to update the user pool
  client.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessTokenValidity"`: The access token time limit. After this limit expires, your user
  can't use their access token. To specify the time unit for AccessTokenValidity as seconds,
  minutes, hours, or days, set a TokenValidityUnits value in your API request. For example,
  when you set AccessTokenValidity to 10 and TokenValidityUnits to hours, your user can
  authorize access with their access token for 10 hours. The default time unit for
  AccessTokenValidity in an API request is hours. Valid range is displayed below in seconds.
  If you don't specify otherwise in the configuration of your app client, your access tokens
  are valid for one hour.
- `"AllowedOAuthFlows"`: The allowed OAuth flows.  code  Use a code grant flow, which
  provides an authorization code as the response. This code can be exchanged for access
  tokens with the /oauth2/token endpoint.  implicit  Issue the access token (and, optionally,
  ID token, based on scopes) directly to your user.  client_credentials  Issue the access
  token from the /oauth2/token endpoint directly to a non-person user using a combination of
  the client ID and client secret.
- `"AllowedOAuthFlowsUserPoolClient"`: Set to true to use OAuth 2.0 features in your user
  pool app client.  AllowedOAuthFlowsUserPoolClient must be true before you can configure the
  following features in your app client.    CallBackURLs: Callback URLs.    LogoutURLs:
  Sign-out redirect URLs.    AllowedOAuthScopes: OAuth 2.0 scopes.    AllowedOAuthFlows:
  Support for authorization code, implicit, and client credentials OAuth 2.0 grants.   To use
  OAuth 2.0 features, configure one of these features in the Amazon Cognito console or set
  AllowedOAuthFlowsUserPoolClient to true in a CreateUserPoolClient or UpdateUserPoolClient
  API request. If you don't set a value for AllowedOAuthFlowsUserPoolClient in a request with
  the CLI or SDKs, it defaults to false.
- `"AllowedOAuthScopes"`: The allowed OAuth scopes. Possible values provided by OAuth are
  phone, email, openid, and profile. Possible values provided by Amazon Web Services are
  aws.cognito.signin.user.admin. Custom scopes created in Resource Servers are also supported.
- `"AnalyticsConfiguration"`: The Amazon Pinpoint analytics configuration necessary to
  collect metrics for this user pool.  In Amazon Web Services Regions where Amazon Pinpoint
  isn't available, user pools only support sending events to Amazon Pinpoint projects in
  us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events
  to Amazon Pinpoint projects within that same Region.
- `"AuthSessionValidity"`: Amazon Cognito creates a session token for each API request in
  an authentication flow. AuthSessionValidity is the duration, in minutes, of that session
  token. Your user pool native user must respond to each authentication challenge before the
  session expires.
- `"CallbackURLs"`: A list of allowed redirect (callback) URLs for the IdPs. A redirect URI
  must:   Be an absolute URI.   Be registered with the authorization server.   Not include a
  fragment component.   See OAuth 2.0 - Redirection Endpoint. Amazon Cognito requires HTTPS
  over HTTP except for http://localhost for testing purposes only. App callback URLs such as
  myapp://example are also supported.
- `"ClientName"`: The client name from the update user pool client request.
- `"DefaultRedirectURI"`: The default redirect URI. Must be in the CallbackURLs list. A
  redirect URI must:   Be an absolute URI.   Be registered with the authorization server.
  Not include a fragment component.   See OAuth 2.0 - Redirection Endpoint. Amazon Cognito
  requires HTTPS over HTTP except for http://localhost for testing purposes only. App
  callback URLs such as myapp://example are also supported.
- `"EnablePropagateAdditionalUserContextData"`: Activates the propagation of additional
  user context data. For more information about propagation of user context data, see  Adding
  advanced security to a user pool. If you don’t include this parameter, you can't send
  device fingerprint information, including source IP address, to Amazon Cognito advanced
  security. You can only activate EnablePropagateAdditionalUserContextData in an app client
  that has a client secret.
- `"EnableTokenRevocation"`: Activates or deactivates token revocation. For more
  information about revoking tokens, see RevokeToken.
- `"ExplicitAuthFlows"`: The authentication flows that you want your user pool client to
  support. For each app client in your user pool, you can sign in your users with any
  combination of one or more flows, including with a user name and Secure Remote Password
  (SRP), a user name and password, or a custom authentication process that you define with
  Lambda functions.  If you don't specify a value for ExplicitAuthFlows, your user client
  supports ALLOW_REFRESH_TOKEN_AUTH, ALLOW_USER_SRP_AUTH, and ALLOW_CUSTOM_AUTH.  Valid
  values include:    ALLOW_ADMIN_USER_PASSWORD_AUTH: Enable admin based user password
  authentication flow ADMIN_USER_PASSWORD_AUTH. This setting replaces the ADMIN_NO_SRP_AUTH
  setting. With this authentication flow, your app passes a user name and password to Amazon
  Cognito in the request, instead of using the Secure Remote Password (SRP) protocol to
  securely transmit the password.    ALLOW_CUSTOM_AUTH: Enable Lambda trigger based
  authentication.    ALLOW_USER_PASSWORD_AUTH: Enable user password-based authentication. In
  this flow, Amazon Cognito receives the password in the request instead of using the SRP
  protocol to verify passwords.    ALLOW_USER_SRP_AUTH: Enable SRP-based authentication.
  ALLOW_REFRESH_TOKEN_AUTH: Enable authflow to refresh tokens.   In some environments, you
  will see the values ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, or USER_PASSWORD_AUTH. You
  can't assign these legacy ExplicitAuthFlows values to user pool clients at the same time as
  values that begin with ALLOW_, like ALLOW_USER_SRP_AUTH.
- `"IdTokenValidity"`: The ID token time limit. After this limit expires, your user can't
  use their ID token. To specify the time unit for IdTokenValidity as seconds, minutes,
  hours, or days, set a TokenValidityUnits value in your API request. For example, when you
  set IdTokenValidity as 10 and TokenValidityUnits as hours, your user can authenticate their
  session with their ID token for 10 hours. The default time unit for IdTokenValidity in an
  API request is hours. Valid range is displayed below in seconds. If you don't specify
  otherwise in the configuration of your app client, your ID tokens are valid for one hour.
- `"LogoutURLs"`: A list of allowed logout URLs for the IdPs.
- `"PreventUserExistenceErrors"`: Errors and responses that you want Amazon Cognito APIs to
  return during authentication, account confirmation, and password recovery when the user
  doesn't exist in the user pool. When set to ENABLED and the user doesn't exist,
  authentication returns an error indicating either the username or password was incorrect.
  Account confirmation and password recovery return a response indicating a code was sent to
  a simulated destination. When set to LEGACY, those APIs return a UserNotFoundException
  exception if the user doesn't exist in the user pool. Valid values include:    ENABLED -
  This prevents user existence-related errors.    LEGACY - This represents the early behavior
  of Amazon Cognito where user existence related errors aren't prevented.
- `"ReadAttributes"`: The list of user attributes that you want your app client to have
  read-only access to. After your user authenticates in your app, their access token
  authorizes them to read their own attribute value for any attribute in this list. An
  example of this kind of activity is when your user selects a link to view their profile
  information. Your app makes a GetUser API request to retrieve and display your user's
  profile data. When you don't specify the ReadAttributes for your app client, your app can
  read the values of email_verified, phone_number_verified, and the Standard attributes of
  your user pool. When your user pool has read access to these default attributes,
  ReadAttributes doesn't return any information. Amazon Cognito only populates ReadAttributes
  in the API response if you have specified your own custom set of read attributes.
- `"RefreshTokenValidity"`: The refresh token time limit. After this limit expires, your
  user can't use their refresh token. To specify the time unit for RefreshTokenValidity as
  seconds, minutes, hours, or days, set a TokenValidityUnits value in your API request. For
  example, when you set RefreshTokenValidity as 10 and TokenValidityUnits as days, your user
  can refresh their session and retrieve new access and ID tokens for 10 days. The default
  time unit for RefreshTokenValidity in an API request is days. You can't set
  RefreshTokenValidity to 0. If you do, Amazon Cognito overrides the value with the default
  value of 30 days. Valid range is displayed below in seconds. If you don't specify otherwise
  in the configuration of your app client, your refresh tokens are valid for 30 days.
- `"SupportedIdentityProviders"`: A list of provider names for the IdPs that this client
  supports. The following are supported: COGNITO, Facebook, Google, SignInWithApple,
  LoginWithAmazon, and the names of your own SAML and OIDC providers.
- `"TokenValidityUnits"`: The time units you use when you set the duration of ID, access,
  and refresh tokens. The default unit for RefreshToken is days, and the default for ID and
  access tokens is hours.
- `"WriteAttributes"`: The list of user attributes that you want your app client to have
  write access to. After your user authenticates in your app, their access token authorizes
  them to set or modify their own attribute value for any attribute in this list. An example
  of this kind of activity is when you present your user with a form to update their profile
  information and they change their last name. Your app then makes an UpdateUserAttributes
  API request and sets family_name to the new value.  When you don't specify the
  WriteAttributes for your app client, your app can write the values of the Standard
  attributes of your user pool. When your user pool has write access to these default
  attributes, WriteAttributes doesn't return any information. Amazon Cognito only populates
  WriteAttributes in the API response if you have specified your own custom set of write
  attributes. If your app client allows users to sign in through an IdP, this array must
  include all attributes that you have mapped to IdP attributes. Amazon Cognito updates
  mapped attributes when users sign in to your application through an IdP. If your app client
  does not have write access to a mapped attribute, Amazon Cognito throws an error when it
  tries to update the attribute. For more information, see Specifying IdP Attribute Mappings
  for Your user pool.
"""
function update_user_pool_client(
    ClientId, UserPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "UpdateUserPoolClient",
        Dict{String,Any}("ClientId" => ClientId, "UserPoolId" => UserPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_user_pool_client(
    ClientId,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "UpdateUserPoolClient",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientId" => ClientId, "UserPoolId" => UserPoolId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_user_pool_domain(custom_domain_config, domain, user_pool_id)
    update_user_pool_domain(custom_domain_config, domain, user_pool_id, params::Dict{String,<:Any})

Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user
pool. You can use this operation to provide the Amazon Resource Name (ARN) of a new
certificate to Amazon Cognito. You can't use it to change the domain for a user pool. A
custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and
sign-in pages for your application. When you set up a custom domain, you provide a
certificate that you manage with Certificate Manager (ACM). When necessary, you can use
this operation to change the certificate that you applied to your custom domain. Usually,
this is unnecessary following routine certificate renewal with ACM. When you renew your
existing certificate in ACM, the ARN for your certificate remains the same, and your custom
domain uses the new certificate automatically. However, if you replace your existing
certificate with a new one, ACM gives the new certificate a new ARN. To apply the new
certificate to your custom domain, you must provide this ARN to Amazon Cognito. When you
add your new certificate in ACM, you must choose US East (N. Virginia) as the Amazon Web
Services Region. After you submit your request, Amazon Cognito requires up to 1 hour to
distribute your new certificate to your custom domain. For more information about adding a
custom domain to your user pool, see Using Your Own Domain for the Hosted UI.  Amazon
Cognito evaluates Identity and Access Management (IAM) policies in requests for this API
operation. For this operation, you must use IAM credentials to authorize requests, and you
must grant yourself the corresponding IAM permission in a policy.  Learn more     Signing
Amazon Web Services API Requests     Using the Amazon Cognito user pools API and user pool
endpoints

# Arguments
- `custom_domain_config`: The configuration for a custom domain that hosts the sign-up and
  sign-in pages for your application. Use this object to specify an SSL certificate that is
  managed by ACM.
- `domain`: The domain name for the custom domain that hosts the sign-up and sign-in pages
  for your application. One example might be auth.example.com.  This string can include only
  lowercase letters, numbers, and hyphens. Don't use a hyphen for the first or last
  character. Use periods to separate subdomain names.
- `user_pool_id`: The ID of the user pool that is associated with the custom domain whose
  certificate you're updating.

"""
function update_user_pool_domain(
    CustomDomainConfig,
    Domain,
    UserPoolId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "UpdateUserPoolDomain",
        Dict{String,Any}(
            "CustomDomainConfig" => CustomDomainConfig,
            "Domain" => Domain,
            "UserPoolId" => UserPoolId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_user_pool_domain(
    CustomDomainConfig,
    Domain,
    UserPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "UpdateUserPoolDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CustomDomainConfig" => CustomDomainConfig,
                    "Domain" => Domain,
                    "UserPoolId" => UserPoolId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    verify_software_token(user_code)
    verify_software_token(user_code, params::Dict{String,<:Any})

Use this API to register a user's entered time-based one-time password (TOTP) code and mark
the user's software token MFA status as \"verified\" if successful. The request takes an
access token or a session string, but not both.  Amazon Cognito doesn't evaluate Identity
and Access Management (IAM) policies in requests for this API operation. For this
operation, you can't use IAM credentials to authorize requests, and you can't grant IAM
permissions in policies. For more information about authorization models in Amazon Cognito,
see Using the Amazon Cognito user pools API and user pool endpoints.

# Arguments
- `user_code`: The one- time password computed using the secret code returned by
  AssociateSoftwareToken.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessToken"`: A valid access token that Amazon Cognito issued to the user whose
  software token you want to verify.
- `"FriendlyDeviceName"`: The friendly device name.
- `"Session"`: The session that should be passed both ways in challenge-response calls to
  the service.
"""
function verify_software_token(UserCode; aws_config::AbstractAWSConfig=current_aws_config())
    return cognito_identity_provider(
        "VerifySoftwareToken",
        Dict{String,Any}("UserCode" => UserCode);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function verify_software_token(
    UserCode,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "VerifySoftwareToken",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserCode" => UserCode), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    verify_user_attribute(access_token, attribute_name, code)
    verify_user_attribute(access_token, attribute_name, code, params::Dict{String,<:Any})

Verifies the specified user attributes in the user pool.  If your user pool requires
verification before Amazon Cognito updates the attribute value, VerifyUserAttribute updates
the affected attribute to its pending value. For more information, see
UserAttributeUpdateSettingsType.  Authorize this action with a signed-in user's access
token. It must include the scope aws.cognito.signin.user.admin.  Amazon Cognito doesn't
evaluate Identity and Access Management (IAM) policies in requests for this API operation.
For this operation, you can't use IAM credentials to authorize requests, and you can't
grant IAM permissions in policies. For more information about authorization models in
Amazon Cognito, see Using the Amazon Cognito user pools API and user pool endpoints.

# Arguments
- `access_token`: A valid access token that Amazon Cognito issued to the user whose user
  attributes you want to verify.
- `attribute_name`: The attribute name in the request to verify user attributes.
- `code`: The verification code in the request to verify user attributes.

"""
function verify_user_attribute(
    AccessToken, AttributeName, Code; aws_config::AbstractAWSConfig=current_aws_config()
)
    return cognito_identity_provider(
        "VerifyUserAttribute",
        Dict{String,Any}(
            "AccessToken" => AccessToken, "AttributeName" => AttributeName, "Code" => Code
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function verify_user_attribute(
    AccessToken,
    AttributeName,
    Code,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return cognito_identity_provider(
        "VerifyUserAttribute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AccessToken" => AccessToken,
                    "AttributeName" => AttributeName,
                    "Code" => Code,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
