# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: serverlessapplicationrepository
using AWS.Compat
using AWS.UUIDs

"""
    create_application(author, description, name)
    create_application(author, description, name, params::Dict{String,<:Any})

Creates an application, optionally including an AWS SAM file to create the first
application version in the same call.

# Arguments
- `author`: The name of the author publishing the app.Minimum length=1. Maximum
  length=127.Pattern \"^\\[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?\";
- `description`: The description of the application.Minimum length=1. Maximum length=256
- `name`: The name of the application that you want to publish.Minimum length=1. Maximum
  length=140Pattern: \"[a-zA-Z0-9-]+\";

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"homePageUrl"`: A URL with more information about the application, for example the
  location of your GitHub repository for the application.
- `"labels"`: Labels to improve discovery of apps in search results.Minimum length=1.
  Maximum length=127. Maximum number of labels: 10Pattern: \"^[a-zA-Z0-9+-_:/@]+\";
- `"licenseBody"`: A local text file that contains the license of the app that matches the
  spdxLicenseID value of your application.
 The file has the format
  file://&lt;path>/&lt;filename>.Maximum size 5 MBYou can specify only one of licenseBody and
  licenseUrl; otherwise, an error results.
- `"licenseUrl"`: A link to the S3 object that contains the license of the app that matches
  the spdxLicenseID value of your application.Maximum size 5 MBYou can specify only one of
  licenseBody and licenseUrl; otherwise, an error results.
- `"readmeBody"`: A local text readme file in Markdown language that contains a more
  detailed description of the application and how it works.
 The file has the format
  file://&lt;path>/&lt;filename>.Maximum size 5 MBYou can specify only one of readmeBody and
  readmeUrl; otherwise, an error results.
- `"readmeUrl"`: A link to the S3 object in Markdown language that contains a more detailed
  description of the application and how it works.Maximum size 5 MBYou can specify only one
  of readmeBody and readmeUrl; otherwise, an error results.
- `"semanticVersion"`: The semantic version of the application:
 https://semver.org/
- `"sourceCodeArchiveUrl"`: A link to the S3 object that contains the ZIP archive of the
  source code for this version of your application.Maximum size 50 MB
- `"sourceCodeUrl"`: A link to a public repository for the source code of your application,
  for example the URL of a specific GitHub commit.
- `"spdxLicenseId"`: A valid identifier from https://spdx.org/licenses/.
- `"templateBody"`: The local raw packaged AWS SAM template file of your application.
 The
  file has the format file://&lt;path>/&lt;filename>.You can specify only one of templateBody
  and templateUrl; otherwise an error results.
- `"templateUrl"`: A link to the S3 object containing the packaged AWS SAM template of your
  application.You can specify only one of templateBody and templateUrl; otherwise an error
  results.
"""
function create_application(
    author, description, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return serverlessapplicationrepository(
        "POST",
        "/applications",
        Dict{String,Any}("author" => author, "description" => description, "name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_application(
    author,
    description,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return serverlessapplicationrepository(
        "POST",
        "/applications",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "author" => author, "description" => description, "name" => name
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_application_version(application_id, semantic_version)
    create_application_version(application_id, semantic_version, params::Dict{String,<:Any})

Creates an application version.

# Arguments
- `application_id`: The Amazon Resource Name (ARN) of the application.
- `semantic_version`: The semantic version of the new version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"sourceCodeArchiveUrl"`: A link to the S3 object that contains the ZIP archive of the
  source code for this version of your application.Maximum size 50 MB
- `"sourceCodeUrl"`: A link to a public repository for the source code of your application,
  for example the URL of a specific GitHub commit.
- `"templateBody"`: The raw packaged AWS SAM template of your application.
- `"templateUrl"`: A link to the packaged AWS SAM template of your application.
"""
function create_application_version(
    applicationId, semanticVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return serverlessapplicationrepository(
        "PUT",
        "/applications/$(applicationId)/versions/$(semanticVersion)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_application_version(
    applicationId,
    semanticVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return serverlessapplicationrepository(
        "PUT",
        "/applications/$(applicationId)/versions/$(semanticVersion)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cloud_formation_change_set(application_id, stack_name)
    create_cloud_formation_change_set(application_id, stack_name, params::Dict{String,<:Any})

Creates an AWS CloudFormation change set for the given application.

# Arguments
- `application_id`: The Amazon Resource Name (ARN) of the application.
- `stack_name`: This property corresponds to the parameter of the same name for the AWS
  CloudFormation CreateChangeSet
  API.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"capabilities"`: A list of values that you must specify before you can deploy certain
  applications.
 Some applications might include resources that can affect permissions in
  your AWS
 account, for example, by creating new AWS Identity and Access Management (IAM)
  users.
 For those applications, you must explicitly acknowledge their capabilities by
  specifying this parameter.The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM,
  CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.The following resources require you
  to specify CAPABILITY_IAM or
 CAPABILITY_NAMED_IAM:
 AWS::IAM::Group,
  AWS::IAM::InstanceProfile,
 AWS::IAM::Policy, and
 AWS::IAM::Role.
 If the application
  contains IAM resources, you can specify either CAPABILITY_IAM
 or CAPABILITY_NAMED_IAM. If
  the application contains IAM resources
 with custom names, you must specify
  CAPABILITY_NAMED_IAM.The following resources require you to specify
  CAPABILITY_RESOURCE_POLICY:
 AWS::Lambda::Permission,
 AWS::IAM:Policy,
  AWS::ApplicationAutoScaling::ScalingPolicy,
 AWS::S3::BucketPolicy,
 AWS::SQS::QueuePolicy,
  and
 AWS::SNS:TopicPolicy.Applications that contain one or more nested applications require
  you to specify
 CAPABILITY_AUTO_EXPAND.If your application template contains any of the
  above resources, we recommend that you review
 all permissions associated with the
  application before deploying. If you don't specify
 this parameter for an application that
  requires capabilities, the call will fail.
- `"changeSetName"`: This property corresponds to the parameter of the same name for the
  AWS CloudFormation CreateChangeSet
  API.
- `"clientToken"`: This property corresponds to the parameter of the same name for the AWS
  CloudFormation CreateChangeSet
  API.
- `"description"`: This property corresponds to the parameter of the same name for the AWS
  CloudFormation CreateChangeSet
  API.
- `"notificationArns"`: This property corresponds to the parameter of the same name for the
  AWS CloudFormation CreateChangeSet
  API.
- `"parameterOverrides"`: A list of parameter values for the parameters of the application.
- `"resourceTypes"`: This property corresponds to the parameter of the same name for the
  AWS CloudFormation CreateChangeSet
  API.
- `"rollbackConfiguration"`: This property corresponds to the parameter of the same name
  for the AWS CloudFormation CreateChangeSet
  API.
- `"semanticVersion"`: The semantic version of the application:
 https://semver.org/
- `"tags"`: This property corresponds to the parameter of the same name for the AWS
  CloudFormation CreateChangeSet
  API.
- `"templateId"`: The UUID returned by CreateCloudFormationTemplate.Pattern:
  [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
"""
function create_cloud_formation_change_set(
    applicationId, stackName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return serverlessapplicationrepository(
        "POST",
        "/applications/$(applicationId)/changesets",
        Dict{String,Any}("stackName" => stackName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cloud_formation_change_set(
    applicationId,
    stackName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return serverlessapplicationrepository(
        "POST",
        "/applications/$(applicationId)/changesets",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("stackName" => stackName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_cloud_formation_template(application_id)
    create_cloud_formation_template(application_id, params::Dict{String,<:Any})

Creates an AWS CloudFormation template.

# Arguments
- `application_id`: The Amazon Resource Name (ARN) of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"semanticVersion"`: The semantic version of the application:
 https://semver.org/
"""
function create_cloud_formation_template(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return serverlessapplicationrepository(
        "POST",
        "/applications/$(applicationId)/templates";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_cloud_formation_template(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return serverlessapplicationrepository(
        "POST",
        "/applications/$(applicationId)/templates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_application(application_id)
    delete_application(application_id, params::Dict{String,<:Any})

Deletes the specified application.

# Arguments
- `application_id`: The Amazon Resource Name (ARN) of the application.

"""
function delete_application(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return serverlessapplicationrepository(
        "DELETE",
        "/applications/$(applicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_application(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return serverlessapplicationrepository(
        "DELETE",
        "/applications/$(applicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_application(application_id)
    get_application(application_id, params::Dict{String,<:Any})

Gets the specified application.

# Arguments
- `application_id`: The Amazon Resource Name (ARN) of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"semanticVersion"`: The semantic version of the application to get.
"""
function get_application(applicationId; aws_config::AbstractAWSConfig=current_aws_config())
    return serverlessapplicationrepository(
        "GET",
        "/applications/$(applicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_application(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return serverlessapplicationrepository(
        "GET",
        "/applications/$(applicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_application_policy(application_id)
    get_application_policy(application_id, params::Dict{String,<:Any})

Retrieves the policy for the application.

# Arguments
- `application_id`: The Amazon Resource Name (ARN) of the application.

"""
function get_application_policy(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return serverlessapplicationrepository(
        "GET",
        "/applications/$(applicationId)/policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_application_policy(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return serverlessapplicationrepository(
        "GET",
        "/applications/$(applicationId)/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_cloud_formation_template(application_id, template_id)
    get_cloud_formation_template(application_id, template_id, params::Dict{String,<:Any})

Gets the specified AWS CloudFormation template.

# Arguments
- `application_id`: The Amazon Resource Name (ARN) of the application.
- `template_id`: The UUID returned by CreateCloudFormationTemplate.Pattern:
  [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}

"""
function get_cloud_formation_template(
    applicationId, templateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return serverlessapplicationrepository(
        "GET",
        "/applications/$(applicationId)/templates/$(templateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_cloud_formation_template(
    applicationId,
    templateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return serverlessapplicationrepository(
        "GET",
        "/applications/$(applicationId)/templates/$(templateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_application_dependencies(application_id)
    list_application_dependencies(application_id, params::Dict{String,<:Any})

Retrieves the list of applications nested in the containing application.

# Arguments
- `application_id`: The Amazon Resource Name (ARN) of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxItems"`: The total number of items to return.
- `"nextToken"`: A token to specify where to start paginating.
- `"semanticVersion"`: The semantic version of the application to get.
"""
function list_application_dependencies(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return serverlessapplicationrepository(
        "GET",
        "/applications/$(applicationId)/dependencies";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_application_dependencies(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return serverlessapplicationrepository(
        "GET",
        "/applications/$(applicationId)/dependencies",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_application_versions(application_id)
    list_application_versions(application_id, params::Dict{String,<:Any})

Lists versions for the specified application.

# Arguments
- `application_id`: The Amazon Resource Name (ARN) of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxItems"`: The total number of items to return.
- `"nextToken"`: A token to specify where to start paginating.
"""
function list_application_versions(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return serverlessapplicationrepository(
        "GET",
        "/applications/$(applicationId)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_application_versions(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return serverlessapplicationrepository(
        "GET",
        "/applications/$(applicationId)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_applications()
    list_applications(params::Dict{String,<:Any})

Lists applications owned by the requester.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxItems"`: The total number of items to return.
- `"nextToken"`: A token to specify where to start paginating.
"""
function list_applications(; aws_config::AbstractAWSConfig=current_aws_config())
    return serverlessapplicationrepository(
        "GET", "/applications"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return serverlessapplicationrepository(
        "GET",
        "/applications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_application_policy(application_id, statements)
    put_application_policy(application_id, statements, params::Dict{String,<:Any})

Sets the permission policy for an application. For the list of actions supported for this
operation, see
 Application 
 Permissions
 .

# Arguments
- `application_id`: The Amazon Resource Name (ARN) of the application.
- `statements`: An array of policy statements applied to the application.

"""
function put_application_policy(
    applicationId, statements; aws_config::AbstractAWSConfig=current_aws_config()
)
    return serverlessapplicationrepository(
        "PUT",
        "/applications/$(applicationId)/policy",
        Dict{String,Any}("statements" => statements);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_application_policy(
    applicationId,
    statements,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return serverlessapplicationrepository(
        "PUT",
        "/applications/$(applicationId)/policy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("statements" => statements), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    unshare_application(application_id, organization_id)
    unshare_application(application_id, organization_id, params::Dict{String,<:Any})

Unshares an application from an AWS Organization.This operation can be called only from the
organization's master account.

# Arguments
- `application_id`: The Amazon Resource Name (ARN) of the application.
- `organization_id`: The AWS Organization ID to unshare the application from.

"""
function unshare_application(
    applicationId, organizationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return serverlessapplicationrepository(
        "POST",
        "/applications/$(applicationId)/unshare",
        Dict{String,Any}("organizationId" => organizationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function unshare_application(
    applicationId,
    organizationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return serverlessapplicationrepository(
        "POST",
        "/applications/$(applicationId)/unshare",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("organizationId" => organizationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_application(application_id)
    update_application(application_id, params::Dict{String,<:Any})

Updates the specified application.

# Arguments
- `application_id`: The Amazon Resource Name (ARN) of the application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"author"`: The name of the author publishing the app.Minimum length=1. Maximum
  length=127.Pattern \"^\\[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?\";
- `"description"`: The description of the application.Minimum length=1. Maximum length=256
- `"homePageUrl"`: A URL with more information about the application, for example the
  location of your GitHub repository for the application.
- `"labels"`: Labels to improve discovery of apps in search results.Minimum length=1.
  Maximum length=127. Maximum number of labels: 10Pattern: \"^[a-zA-Z0-9+-_:/@]+\";
- `"readmeBody"`: A text readme file in Markdown language that contains a more detailed
  description of the application and how it works.Maximum size 5 MB
- `"readmeUrl"`: A link to the readme file in Markdown language that contains a more
  detailed description of the application and how it works.Maximum size 5 MB
"""
function update_application(
    applicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return serverlessapplicationrepository(
        "PATCH",
        "/applications/$(applicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_application(
    applicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return serverlessapplicationrepository(
        "PATCH",
        "/applications/$(applicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
