# added 2023-08-01 13:45:14
# from the paper by G. Kindlmann; E. Reinhard; S. Creem
# "Face-based luminance matching for perceptual colormap generation"
# DOI: 10.1109/VISUAL.2002.1183788
# Basically the rainbow color map with the luminance adjusted such
# that it monotonically changes, making it much more perceptually viable.

loadcolorscheme(:kindlmann, [
        RGB(0.0, 0.0, 0.0),
        RGB(0.004413886897691312, 0.00024949041354319383, 0.0038940677061456846),
        RGB(0.008975098895355206, 0.0004375029210488244, 0.00796319584530478),
        RGB(0.013329812007912275, 0.0006989745647048196, 0.011912886690108787),
        RGB(0.017830327344728454, 0.0008992649041340732, 0.01603918580494449),
        RGB(0.022300217036144074, 0.0011057411654817706, 0.020194421669020496),
        RGB(0.026739584983709506, 0.001318376123010148, 0.024378557923456227),
        RGB(0.03114853695912419, 0.0015371421242901743, 0.028591556927303582),
        RGB(0.03552718062657688, 0.0017620110859756298, 0.03283337973360013),
        RGB(0.04004619521177544, 0.0019267646877785959, 0.03725725069613795),
        RGB(0.04419459685257739, 0.0021639235663056854, 0.041530206061371706),
        RGB(0.04823080704747668, 0.002341247650480605, 0.04574043907512824),
        RGB(0.05203094294755461, 0.002524895289632142, 0.04974382231548257),
        RGB(0.05562587369815098, 0.002714834555012232, 0.053568489047787),
        RGB(0.059167700524213086, 0.002845687842786897, 0.0573600395652149),
        RGB(0.06253790131260883, 0.002983102026844918, 0.061004150289031396),
        RGB(0.06563825416415245, 0.0031920532267859483, 0.06440328144667531),
        RGB(0.0687218666131762, 0.0033423173399254776, 0.06780319942591939),
        RGB(0.071787829388437, 0.003434356747576164, 0.07120394821751111),
        RGB(0.07462780277889297, 0.003597658699584536, 0.07439873380949541),
        RGB(0.07746361321136305, 0.0037029910207578742, 0.07760684284842612),
        RGB(0.08009955476744784, 0.003879179842282766, 0.08063174741189441),
        RGB(0.08274070316818896, 0.003997649576229795, 0.08367868166345019),
        RGB(0.08520250962461584, 0.0041865699271156675, 0.08656015700728481),
        RGB(0.08767618907840205, 0.0043180171185169085, 0.0894698800796643),
        RGB(0.09007320144379524, 0.00445597234677594, 0.09231726635287674),
        RGB(0.09248218543089967, 0.00453701719643754, 0.09519356091870773),
        RGB(0.09473792061786934, 0.0046880211240842625, 0.09792690650789462),
        RGB(0.09692587800293206, 0.004846141135138284, 0.10061888524794171),
        RGB(0.0990978725598669, 0.004953331404254114, 0.10341408698326124),
        RGB(0.10117191947731585, 0.005073765732249746, 0.10623756170214407),
        RGB(0.10315202430758341, 0.005207609576826739, 0.10908926117354337),
        RGB(0.10504171548982694, 0.005355031392296846, 0.1119691392407701),
        RGB(0.10684410337341194, 0.005516202639075796, 0.11487715154691205),
        RGB(0.10862405611101242, 0.005630502262545109, 0.11790168114877045),
        RGB(0.11025728648939928, 0.005820078663098405, 0.12086647174937593),
        RGB(0.11186779760920343, 0.005963918782167322, 0.12394897928337223),
        RGB(0.1134503140344699, 0.006063399872754488, 0.12715109852640152),
        RGB(0.11489469267221977, 0.0062383688238853655, 0.13029273038566114),
        RGB(0.11630980352470946, 0.00637021832661643, 0.1335552065125342),
        RGB(0.11760553623142708, 0.0065694065986089305, 0.13675599724921922),
        RGB(0.11893571003113806, 0.0066802917398031845, 0.14007982761164983),
        RGB(0.1201595731207998, 0.00687888646930259, 0.14324767656130913),
        RGB(0.1214214461059501, 0.006985693859048352, 0.14653844708760821),
        RGB(0.12257867855347723, 0.007184860328046397, 0.1496690153844207),
        RGB(0.1237724019669465, 0.007292365366774374, 0.15292232122891783),
        RGB(0.12486340433453777, 0.007496707478064406, 0.15601125110456568),
        RGB(0.1259895157424903, 0.007609507189405964, 0.15922274352977092),
        RGB(0.12705947919770802, 0.007758553635055039, 0.16236338132268358),
        RGB(0.12807445140742915, 0.007945948037582773, 0.16543111102079097),
        RGB(0.1291220687341867, 0.008041282843499012, 0.16862180802496227),
        RGB(0.13007214760270447, 0.008243276399615649, 0.1716385172012931),
        RGB(0.13105374917366155, 0.008353307024761059, 0.17477802997160363),
        RGB(0.13198180447815747, 0.008505790398300324, 0.17784040536738357),
        RGB(0.1328983940884664, 0.008633892581231125, 0.18092517027849025),
        RGB(0.13376300778442707, 0.008807008223692602, 0.18393006074476814),
        RGB(0.1346165052491052, 0.008957024700231991, 0.18695589773906282),
        RGB(0.1354584402175018, 0.009083971844795714, 0.19000260001004676),
        RGB(0.1362503695017201, 0.009258972139716406, 0.19296599859167426),
        RGB(0.13706856165315404, 0.009340448494958914, 0.1960535490120543),
        RGB(0.13780067951090091, 0.009543373386129561, 0.19895101715988045),
        RGB(0.1385582792236458, 0.009652809897836042, 0.20197247154439935),
        RGB(0.13926846914678623, 0.009813711380567948, 0.20490651158562045),
        RGB(0.13996752319436254, 0.009953876692328417, 0.20785840021376545),
        RGB(0.1406551040072894, 0.010073310011982807, 0.21082805228796853),
        RGB(0.14129787489383572, 0.010246840831378867, 0.213706923113001),
        RGB(0.1419622733743035, 0.010325331503031101, 0.21671122101373091),
        RGB(0.14258273664578106, 0.010458922100712541, 0.21962332684828711),
        RGB(0.14316124947834857, 0.010649072187148405, 0.22244131014174057),
        RGB(0.14375978098990738, 0.010743657661826065, 0.2253850686259653),
        RGB(0.14431737444676437, 0.010895716211515577, 0.22823330532624875),
        RGB(0.14486452805622044, 0.011028924450024636, 0.2310962295776421),
        RGB(0.14540100973505637, 0.011143254569069557, 0.23397374900026408),
        RGB(0.145899795151558, 0.011317263419260723, 0.23675244490736785),
        RGB(0.1463890847210718, 0.011473210828068455, 0.23954434788785062),
        RGB(0.14686869427982727, 0.011611054358134405, 0.24234936333952178),
        RGB(0.1473384434438171, 0.011730749407161293, 0.24516739512454133),
        RGB(0.1477981556231633, 0.011832249148946912, 0.24799834552651862),
        RGB(0.1482249816356862, 0.011996192329729089, 0.25072582567274104),
        RGB(0.14864313533836, 0.012142653279282949, 0.2534648478734047),
        RGB(0.1490524876954393, 0.012271570801811208, 0.2562153124755284),
        RGB(0.1494529138171093, 0.012382881345561423, 0.25897711821907715),
        RGB(0.14984450030133123, 0.01247576952434734, 0.261750177147738),
        RGB(0.15020444429564028, 0.012648411020247354, 0.2644148812055119),
        RGB(0.15056850101544464, 0.012742460454953093, 0.26720881765221677),
        RGB(0.15090071937921837, 0.012923561865534535, 0.2698929303681357),
        RGB(0.15123512371368594, 0.013025337375274957, 0.27270723793128593),
        RGB(0.15155412188412803, 0.013130796728699856, 0.27553187334803053),
        RGB(0.15184380193389485, 0.013324453542599845, 0.27824466717010554),
        RGB(0.1521326886697153, 0.013437671307741575, 0.2810890784400233),
        RGB(0.15240592983055523, 0.013554580144828578, 0.28394350843772337),
        RGB(0.15266344499715856, 0.013675177646420952, 0.28680784928662256),
        RGB(0.1529051555075618, 0.013799458586407843, 0.28968199085999924),
        RGB(0.15312202948932535, 0.014013767029348421, 0.2924409028883687),
        RGB(0.15333292004147725, 0.014145754586639293, 0.2953337392406504),
        RGB(0.15352779446255926, 0.014281390915203813, 0.29823603384064407),
        RGB(0.15370658213769456, 0.014420659223724472, 0.30114766754170025),
        RGB(0.15386921462807054, 0.014563539739675715, 0.3040685189190743),
        RGB(0.1540156257607964, 0.014710009680974433, 0.3069984642680242),
        RGB(0.15414839743312772, 0.014771514687250305, 0.31006567582572486),
        RGB(0.15426107667489772, 0.01492472563170877, 0.3130139865184971),
        RGB(0.1543573360727336, 0.015081440725353609, 0.31597100461268585),
        RGB(0.15443711922817369, 0.015241624834734367, 0.31893659724210793),
        RGB(0.15450037249035137, 0.015405239698588861, 0.3219106292726878),
        RGB(0.15454400389133907, 0.015481926779094688, 0.3250240388158764),
        RGB(0.15457287197024475, 0.01565192488823426, 0.32801508346393676),
        RGB(0.15458505099688072, 0.01582522108781593, 0.3310141465491321),
        RGB(0.1545804991264497, 0.016001764373690563, 0.3340210839037906),
        RGB(0.15455129492501576, 0.01608977143208192, 0.337169012694359),
        RGB(0.15451192745967102, 0.016272296147325626, 0.34019179705581143),
        RGB(0.15444527974601616, 0.016365460095394566, 0.34335635613664933),
        RGB(0.15437090133158687, 0.016553726791706417, 0.34639437541934087),
        RGB(0.15426655529547892, 0.01665179839832492, 0.34957493472565043),
        RGB(0.15415699670973007, 0.016845540929583736, 0.35262755903411014),
        RGB(0.15401472186607437, 0.016948243605079776, 0.35582347045178686),
        RGB(0.1538698419135761, 0.017147169079999462, 0.3588900524758985),
        RGB(0.15368943390866366, 0.017254198838344288, 0.3621006502718457),
        RGB(0.153509121412656, 0.017457987643308897, 0.36518052575609183),
        RGB(0.15329040392184531, 0.017569013135758392, 0.3684051270849087),
        RGB(0.15307457981828776, 0.017777319028822607, 0.3714976153750318),
        RGB(0.15281740654012366, 0.017891981649890604, 0.3747355208654691),
        RGB(0.1525401947271699, 0.018008142624843695, 0.3779800697189719),
        RGB(0.15227028283181246, 0.018222345992794337, 0.38109041996017273),
        RGB(0.15195443316311238, 0.018341555430821988, 0.3843471915237802),
        RGB(0.15161843690386623, 0.018461953619401134, 0.387610052846203),
        RGB(0.15129439447945642, 0.01868112662861036, 0.3907366391523297),
        RGB(0.15091965511797664, 0.01880392403630305, 0.394010608380403),
        RGB(0.1505246990930419, 0.018927570151425998, 0.3972900975845656),
        RGB(0.15014661547776753, 0.019150697154893887, 0.4004312474824585),
        RGB(0.14971289568154217, 0.019276033910541876, 0.40372069951924106),
        RGB(0.1492589309560219, 0.019401849587313193, 0.40701508723331287),
        RGB(0.14882704058271906, 0.019627829347443896, 0.41016908662640755),
        RGB(0.14833438435815413, 0.01975456935934695, 0.4134722653882563),
        RGB(0.14782150086879203, 0.019881389641001373, 0.4167797829153914),
        RGB(0.14728839652627118, 0.02000815068731823, 0.4200914366333754),
        RGB(0.1467847965875278, 0.020235960631408045, 0.4232599958769007),
        RGB(0.14621323662901753, 0.0203625369866446, 0.4265788413826959),
        RGB(0.1456215409647521, 0.020488618529055525, 0.4299012126833054),
        RGB(0.1450652966672743, 0.020716393566549765, 0.4330784895778409),
        RGB(0.14443546948099406, 0.02084139742108797, 0.4364068350123991),
        RGB(0.1437856485628437, 0.02096544474304724, 0.43973808862765107),
        RGB(0.1431775842169038, 0.021191820757147047, 0.4429222752442019),
        RGB(0.14249008179612638, 0.021313847521327364, 0.4462582739967678),
        RGB(0.14178278980155068, 0.021434431334943136, 0.4495965588165565),
        RGB(0.14112394453875485, 0.02165797416830624, 0.4527858354267594),
        RGB(0.14037955877290753, 0.02177554774406659, 0.4561276307017545),
        RGB(0.13961565559086103, 0.02189116885529376, 0.45947108838729694),
        RGB(0.13890730324986786, 0.022110379169843396, 0.46266363224810864),
        RGB(0.13810704453422218, 0.022221956924885638, 0.4660093661423162),
        RGB(0.1373672884897803, 0.02243754463887486, 0.46920294171088933),
        RGB(0.13653128555847133, 0.022544369949900677, 0.4725501352441102),
        RGB(0.13576094030454341, 0.022755629926046825, 0.47574394508572165),
        RGB(0.13488988467490481, 0.0228569775018895, 0.4790917869390103),
        RGB(0.13408985469868592, 0.023063189920231292, 0.48228504021352264),
        RGB(0.13318452292745286, 0.02315831949623911, 0.4856327264381663),
        RGB(0.13235580798615088, 0.023358751114182785, 0.4888246410388221),
        RGB(0.13141706674890147, 0.02344690874756958, 0.49217137725026666),
        RGB(0.13056076737574068, 0.023640814225419294, 0.49536118201366713),
        RGB(0.1296924638125012, 0.023831382860806587, 0.49854946137633066),
        RGB(0.1287069019995056, 0.02390785695772366, 0.5018931226392888),
        RGB(0.12781291388282254, 0.024090766081813802, 0.5050781654463086),
        RGB(0.12690800606187158, 0.02426977312227043, 0.5082611351569947),
        RGB(0.12599258637708946, 0.024444689420804872, 0.5114418552049063),
        RGB(0.12506707924496657, 0.024615325673079978, 0.5146201515277341),
        RGB(0.12401175329239161, 0.02466873436421976, 0.5179547135678002),
        RGB(0.12306439680448225, 0.024829790421848238, 0.52112798977151),
        RGB(0.12210828042523522, 0.0249859907148994, 0.5242983319834899),
        RGB(0.12114389785159413, 0.02513714433636767, 0.5274655776835149),
        RGB(0.12017176108737476, 0.02528306029463765, 0.5306295676350365),
        RGB(0.11919240073453571, 0.02542354763788012, 0.5337901460458261),
        RGB(0.11834537533058537, 0.0256739509579702, 0.5367863372245553),
        RGB(0.11735655097481074, 0.025803490612148924, 0.539939329009089),
        RGB(0.11636226031280208, 0.025927035933210656, 0.5430884688653784),
        RGB(0.1153631109029786, 0.026044397567545886, 0.5462336164245146),
        RGB(0.1145119883094147, 0.026272877492065087, 0.5492126048661001),
        RGB(0.11350853242081813, 0.026377811356449853, 0.5523490719928701),
        RGB(0.11250220892801566, 0.026476004501146864, 0.5554811567448937),
        RGB(0.11165628800256103, 0.02668628899947486, 0.5584458518674352),
        RGB(0.1106499554251395, 0.026770968867684736, 0.561568532204711),
        RGB(0.10981247040896636, 0.02696842710062469, 0.5645230546158997),
        RGB(0.10880920769739374, 0.027038889790357887, 0.5676359010489395),
        RGB(0.10798345079116745, 0.02722285080569628, 0.5705798612161102),
        RGB(0.10716652384961639, 0.027400089153602966, 0.573518282195672),
        RGB(0.1063593126612414, 0.027570450989460708, 0.5764510882801137),
        RGB(0.10537582959556324, 0.027610997980094795, 0.5795429052886079),
        RGB(0.1045873042340344, 0.027766593981577155, 0.5824645171389075),
        RGB(0.10381118377811896, 0.02791486438535044, 0.5853803198191367),
        RGB(0.10304837665033531, 0.02805566904152062, 0.5882902632872546),
        RGB(0.10229979018781815, 0.02818887198918685, 0.5911943044881356),
        RGB(0.10156632764758391, 0.028314341801543335, 0.594092407608679),
        RGB(0.10084888492702093, 0.028431951958097373, 0.5969845443488632),
        RGB(0.10035934902673449, 0.028668457878914935, 0.5997044254668212),
        RGB(0.09968001776690891, 0.028770602707773815, 0.6025843688077112),
        RGB(0.09901929854559163, 0.02886454897420206, 0.605458313204538),
        RGB(0.09859865286671904, 0.029078923848073836, 0.6081593931363153),
        RGB(0.09798096153960431, 0.029156805837984516, 0.6110211686903426),
        RGB(0.09761092676518543, 0.02935621052272673, 0.6137097438233228),
        RGB(0.0970363262608081, 0.029418335325149543, 0.6165601129960119),
        RGB(0.09668077716545637, 0.029610993812623602, 0.6192451112997555),
        RGB(0.09607669501035612, 0.02967342126748955, 0.6221009805053391),
        RGB(0.09569187477066288, 0.029868860998810347, 0.6247923128138267),
        RGB(0.09505155051066891, 0.029932804888380352, 0.6276548764917907),
        RGB(0.09463614645517643, 0.03013109047929837, 0.6303525354035174),
        RGB(0.09395789810599331, 0.030196612135990633, 0.6332217855935436),
        RGB(0.09351048815688992, 0.0303978089534707, 0.6359257639198443),
        RGB(0.09183679865822483, 0.030546343687425655, 0.6390739290120551),
        RGB(0.08820710126799966, 0.030624347526271706, 0.6428841624495307),
        RGB(0.08465489026978223, 0.030853496432770598, 0.6465247808385319),
        RGB(0.08090169208178438, 0.03109834068250539, 0.6501645930318598),
        RGB(0.0766062026802723, 0.03122306812615234, 0.6539724576239221),
        RGB(0.07201841250672733, 0.031363676753704106, 0.6577795213852818),
        RGB(0.06709425201786967, 0.031520352936170726, 0.6615857726651856),
        RGB(0.06177693758632625, 0.03169328280773922, 0.6653911999505367),
        RGB(0.05598666544086984, 0.031886549816767175, 0.669194531870602),
        RGB(0.04951290243599996, 0.0321847484275962, 0.6729685817814638),
        RGB(0.041073925624130835, 0.03233886956143171, 0.6770440177581872),
        RGB(0.03267718470358536, 0.03289900616981148, 0.6807439071572101),
        RGB(0.03298769252155177, 0.03577328532724661, 0.681703900256969),
        RGB(0.032571185898745705, 0.038647644020902004, 0.6827960743044396),
        RGB(0.03311391693723005, 0.04189102044350194, 0.6835142159919109),
        RGB(0.03292535986753892, 0.04498628811488591, 0.6843637776257695),
        RGB(0.03313399314527287, 0.04819616889085656, 0.6850078038477694),
        RGB(0.03317408006862515, 0.051391359544124084, 0.68561447843439),
        RGB(0.03304461642191104, 0.05457285061437867, 0.6861835942552843),
        RGB(0.03274489672477728, 0.057741406891759266, 0.6867149805933617),
        RGB(0.032846792666621896, 0.06099695438793288, 0.6870414552040417),
        RGB(0.03278032311439524, 0.0642322134816764, 0.6873305264198821),
        RGB(0.03311971847656106, 0.06753925968665989, 0.6874157094456098),
        RGB(0.03329327823127185, 0.07082032041875483, 0.6874640985527777),
        RGB(0.033301851808612205, 0.0740767103806384, 0.6874757726900989),
        RGB(0.033146550044284344, 0.07730952548452122, 0.687450841562349),
        RGB(0.03282873697322663, 0.08051967763251563, 0.6873894445574038),
        RGB(0.032927400836194096, 0.08378189552661194, 0.6871270177399277),
        RGB(0.032868255902555876, 0.08701704544398114, 0.6868292618815626),
        RGB(0.033231352646836944, 0.09029432735034013, 0.6863325047366715),
        RGB(0.03286363150794817, 0.09347544388210036, 0.6859653127126871),
        RGB(0.03292363935639154, 0.09669517450870851, 0.6854005763335802),
        RGB(0.03283619777429449, 0.09988622930022309, 0.6848025971427338),
        RGB(0.03260423149897754, 0.10304943823345569, 0.6841717645497876),
        RGB(0.03280953756510206, 0.10624170796191001, 0.6833467886361361),
        RGB(0.03287667320493051, 0.10940329528812773, 0.6824907682528467),
        RGB(0.03280903490820584, 0.11253503426393821, 0.6816041828260572),
        RGB(0.032610134820706696, 0.1156376660871476, 0.6806875268500618),
        RGB(0.032861420095613936, 0.1187601314703344, 0.6795816448439557),
        RGB(0.03241082794507582, 0.12180470072597649, 0.6786069212410083),
        RGB(0.032417375456417145, 0.12486683179034133, 0.6774451248980607),
        RGB(0.03230710978629841, 0.12789893319300882, 0.6762564950033707),
        RGB(0.03266005609499498, 0.13094322353778984, 0.6748841845449736),
        RGB(0.03232758236859881, 0.13391558541865625, 0.6736442310798595),
        RGB(0.03246514477568238, 0.13689832803468382, 0.6722229815982343),
        RGB(0.03250068831580386, 0.1398505141403966, 0.6707784994111552),
        RGB(0.03243825780138344, 0.14277275123107, 0.6693114203705495),
        RGB(0.03228189308928999, 0.14566560606942444, 0.6678223826693643),
        RGB(0.032035620075806404, 0.14852960992709044, 0.6663120258969358),
        RGB(0.031703442176857465, 0.15136526314652743, 0.6647809901362567),
        RGB(0.03185967875882778, 0.15420396032595976, 0.663077485118683),
        RGB(0.03193621492940593, 0.15701296638447865, 0.6613559184293842),
        RGB(0.03193695734586745, 0.1597928245834246, 0.6596169522471286),
        RGB(0.03186575841518253, 0.16254405267036812, 0.657861245234203),
        RGB(0.031726410470687735, 0.1652671458805017, 0.6560894518476025),
        RGB(0.031522640451988326, 0.16796257955903554, 0.6543022216934807),
        RGB(0.03125810507913136, 0.1706308114524336, 0.6525001989241929),
        RGB(0.03149947384320772, 0.1732960140098795, 0.6505364738737852),
        RGB(0.03112310717165854, 0.17591025421696882, 0.648707501078411),
        RGB(0.03125733645357567, 0.17852056251805304, 0.6467195560575216),
        RGB(0.030782841328898556, 0.18108258305389968, 0.6448661589214456),
        RGB(0.030823318593656602, 0.1836398255277555, 0.6428565162631044),
        RGB(0.030821095837342202, 0.18617079115697768, 0.640837329162765),
        RGB(0.030779258089317477, 0.1886759254271811, 0.6388092083731979),
        RGB(0.0307007972570082, 0.19115566291545263, 0.6367727550264672),
        RGB(0.030588611291060497, 0.1936104282091969, 0.6347285603800263),
        RGB(0.030445503677445244, 0.19604063670855693, 0.6326772055945047),
        RGB(0.030274183236104115, 0.19844669532635134, 0.6306192615417238),
        RGB(0.030077264205983258, 0.200829003097805, 0.6285552886414778),
        RGB(0.02985726659637005, 0.2031879517109107, 0.6264858367256302),
        RGB(0.03016403647413213, 0.20553780032675772, 0.624273901741816),
        RGB(0.029903894850959352, 0.2078505595392044, 0.6221959064184467),
        RGB(0.029627684776085746, 0.21014111104597083, 0.6201140216095926),
        RGB(0.029881213578486672, 0.2124218881583076, 0.6178936524248773),
        RGB(0.02957808717124078, 0.21466854371534383, 0.6158063181756208),
        RGB(0.029265090034442606, 0.21689408677831712, 0.6137165851311106),
        RGB(0.02948409920720536, 0.2191092629171959, 0.6114923050010099),
        RGB(0.029155830484344062, 0.22129309328084545, 0.6094000170129162),
        RGB(0.02936063301839656, 0.22346620833731506, 0.6071757733390802),
        RGB(0.029024030868611685, 0.22560973469964735, 0.6050827522244681),
        RGB(0.02922129914794946, 0.22774222704787794, 0.6028603368499862),
        RGB(0.028882674264081684, 0.22984681555822506, 0.6007683170734681),
        RGB(0.02854574372362082, 0.2319326694580225, 0.5986769969408684),
        RGB(0.028743544634425126, 0.23400705472179695, 0.5964600642008914),
        RGB(0.028412944354927566, 0.236055933500593, 0.5943721838702126),
        RGB(0.028617299821127696, 0.23809308878717206, 0.5921611761226158),
        RGB(0.02829792778927661, 0.24010626027995524, 0.5900782591650447),
        RGB(0.028513546532794917, 0.2421074747068927, 0.5878746693519439),
        RGB(0.028209801502070687, 0.2440861690568245, 0.5857981585252924),
        RGB(0.027915847207162954, 0.2460482746663426, 0.5837249339325656),
        RGB(0.028156735417939532, 0.2479981022987049, 0.5815346586578986),
        RGB(0.02788413518814221, 0.24992749845090012, 0.5794698561765144),
        RGB(0.02762392592139295, 0.25184115694612513, 0.5774093025976285),
        RGB(0.027898104752470534, 0.25374225350115015, 0.5752352538558604),
        RGB(0.027664060234381206, 0.2556248908317221, 0.573184971396332),
        RGB(0.027444576696228656, 0.2574926034648229, 0.5711398197580958),
        RGB(0.027240285679408643, 0.2593456516360237, 0.5691000752881107),
        RGB(0.02705177917593129, 0.26118429158401596, 0.5670660061088374),
        RGB(0.027396548408077103, 0.26300995538412814, 0.5649242215279419),
        RGB(0.027240482972735843, 0.26482020688159313, 0.5629031575332485),
        RGB(0.027101782541746427, 0.26661680136857135, 0.5608885266465224),
        RGB(0.026980901405782885, 0.2683999790732328, 0.5588805657271694),
        RGB(0.026878264005168313, 0.2701699763248479, 0.5568795042694887),
        RGB(0.026794266711513633, 0.27192702557596127, 0.5548855645723321),
        RGB(0.02672927955456121, 0.27367135542603616, 0.5528989619076285),
        RGB(0.02668364789373778, 0.27540319064657565, 0.5509199046875719),
        RGB(0.026146165772216408, 0.2771240045357005, 0.5490551612916736),
        RGB(0.02614075704283094, 0.27883178902624184, 0.5470909047950654),
        RGB(0.02615558152003089, 0.2805277255798405, 0.5451347789686757),
        RGB(0.026190900935866287, 0.2822120240859655, 0.543186966486829),
        RGB(0.026246959884803328, 0.2838848907484827, 0.5412476439719777),
        RGB(0.025814859841224717, 0.28554913172091867, 0.5394191028650731),
        RGB(0.025913502440570176, 0.28719999489974785, 0.5374963759793386),
        RGB(0.025525050530810382, 0.28884313258410144, 0.535682975279868),
        RGB(0.025666968061402874, 0.2904727570461103, 0.5337774809552684),
        RGB(0.02583057622220359, 0.2920919186720074, 0.5318812740872315),
        RGB(0.025508483665130775, 0.29370464977414606, 0.5300921680103992),
        RGB(0.02520883663911121, 0.29530775900181977, 0.5283108509119689),
        RGB(0.02543900175804668, 0.2968970939888705, 0.5264415653090041),
        RGB(0.02518434127751763, 0.2984812275646025, 0.5246771119201005),
        RGB(0.024952320630345998, 0.30005623578591195, 0.5229208348811721),
        RGB(0.02524996221404707, 0.30161727738873684, 0.5210796332093744),
        RGB(0.025063334645361486, 0.3031742869287247, 0.5193409546371673),
        RGB(0.024899480738755208, 0.3047226412959838, 0.5176108006504444),
        RGB(0.02475842590440477, 0.3062624904783542, 0.5158892792502839),
        RGB(0.024640191702715263, 0.3077939817281239, 0.514176494584573),
        RGB(0.024544796540860305, 0.3093172595938853, 0.5124725470581102),
        RGB(0.024472256333207966, 0.3108324659530735, 0.5107775334403076),
        RGB(0.0244225851267503, 0.31233974004511444, 0.5090915469705115),
        RGB(0.02439579569272072, 0.313839218505112, 0.5074146774609527),
        RGB(0.024391900085581907, 0.31533103539800345, 0.5057470113973598),
        RGB(0.024410910170491806, 0.3168153222531243, 0.5040886320372558),
        RGB(0.023944263407583335, 0.3182994730689365, 0.5025230735975514),
        RGB(0.024008790202397722, 0.3197692746426864, 0.5008826191125034),
        RGB(0.02409622912829282, 0.3212319236087508, 0.49925168313322493),
        RGB(0.02420659562667413, 0.32268754177489894, 0.49763033696244835),
        RGB(0.023829708770758788, 0.32414426165027227, 0.4960985638991457),
        RGB(0.023985522315735187, 0.3255863555827102, 0.4944957162668206),
        RGB(0.02365303848995742, 0.3270301426061108, 0.49298080521230253),
        RGB(0.02385425476946769, 0.32845916362828026, 0.4913967112638706),
        RGB(0.023566012527780504, 0.32989045227210867, 0.4898989093660861),
        RGB(0.02329949673982742, 0.3313157365557616, 0.48840930842938374),
        RGB(0.023568468375463753, 0.33272604287016483, 0.48685334001137787),
        RGB(0.023345961954432455, 0.33413944801307605, 0.48538118431934657),
        RGB(0.02314503307694086, 0.3355471467853545, 0.48391738849722593),
        RGB(0.023481698784368198, 0.336939654536536, 0.48239001598805725),
        RGB(0.02332460815561705, 0.33833605846248277, 0.4809439627480024),
        RGB(0.02318897853569566, 0.3397270371825204, 0.4795064098669753),
        RGB(0.023074768502595693, 0.3411126802875051, 0.47807740057289566),
        RGB(0.022981940825847022, 0.34249307564773124, 0.47665697630023335),
        RGB(0.022910462626034293, 0.34386830944076785, 0.47524517674689176),
        RGB(0.022860305520709966, 0.3452384661791728, 0.47384203992961055),
        RGB(0.022831445757211875, 0.34660362873806483, 0.4724476022379143),
        RGB(0.022823864333103332, 0.3479638783825333, 0.47106189848664665),
        RGB(0.022837547104816263, 0.3493192947948628, 0.46968496196712045),
        RGB(0.02234655645745103, 0.3506811198096137, 0.4683800582125854),
        RGB(0.022401575558988886, 0.3520272534928089, 0.4670198784211758),
        RGB(0.02247781222068727, 0.35336878255697707, 0.46566855772422394),
        RGB(0.022575272409097406, 0.3547057806583111, 0.46432612380589694),
        RGB(0.022163112450547823, 0.35605007982450154, 0.46305235429295916),
        RGB(0.022301753117628744, 0.3573783774164336, 0.46172690265607114),
        RGB(0.021928093595558813, 0.3587144061169661, 0.46046842805944516),
        RGB(0.022107864001424154, 0.36003427650742026, 0.45916005709764346),
        RGB(0.022308896662655463, 0.3613499609697626, 0.4578606941534176),
        RGB(0.02199343366284427, 0.3626740043441444, 0.45662577263029697),
        RGB(0.021696329744582823, 0.36399427288230424, 0.45539816776493974),
        RGB(0.021958372192779373, 0.3652980671461817, 0.4541242173976771),
        RGB(0.021699403761964196, 0.36661082622340624, 0.45291217027508074),
        RGB(0.022002671966494535, 0.36790695165103077, 0.45165554334555663),
        RGB(0.02178179832102917, 0.36921243574881263, 0.45045912544287053),
        RGB(0.02157913516892262, 0.3705144353537073, 0.44927011548879053),
        RGB(0.021394654896253106, 0.3718130048691144, 0.44808852929857795),
        RGB(0.021779043067665014, 0.3730946190723382, 0.44686587673263306),
        RGB(0.021632631621652715, 0.3743863542031687, 0.4457000428872466),
        RGB(0.021504382139003658, 0.3756748170917178, 0.4445416748361591),
        RGB(0.021394286651492365, 0.37696005807353955, 0.44339078526807635),
        RGB(0.021302342041367467, 0.37824212651910144, 0.4422473861566172),
        RGB(0.021228550024619677, 0.3795210708513826, 0.4411114887857801),
        RGB(0.021172917130965346, 0.380796938563226, 0.43998310377471633),
        RGB(0.02113545468077474, 0.3820697762344432, 0.4388622411018299),
        RGB(0.021116178759134335, 0.38333962954866835, 0.43774891012822026),
        RGB(0.021115110187264453, 0.3846065433099637, 0.43664311962048474),
        RGB(0.021132274491447826, 0.3858705614591735, 0.4355448777728955),
        RGB(0.02116770186969144, 0.38713172709002713, 0.4344541922289723),
        RGB(0.020647342941435966, 0.38840521301519226, 0.43340928467946427),
        RGB(0.020717240142253724, 0.389660924798045, 0.43233287852670005),
        RGB(0.020805484788734247, 0.3909139078773577, 0.4312640490155451),
        RGB(0.020912125313216453, 0.39216420213232905, 0.43020280178249265),
        RGB(0.020454284851396658, 0.3934274730594981, 0.42918394371612045),
        RGB(0.0205955808331107, 0.3946726293425045, 0.4281370240755117),
        RGB(0.020755410499206747, 0.39591521140048463, 0.42709770145633325),
        RGB(0.020343934698264555, 0.3971712484358415, 0.42609822694381067),
        RGB(0.020538633785659368, 0.3984089137162949, 0.42507325906731835),
        RGB(0.02075204307785913, 0.39964411291579494, 0.42405589931171606),
        RGB(0.02038706344451104, 0.4008932348007141, 0.42307584715581625),
        RGB(0.020635631735477274, 0.4021237260124571, 0.4220728623689443),
        RGB(0.020300943662266875, 0.40336844532570304, 0.42110549213664206),
        RGB(0.02058488239667383, 0.40459436092759765, 0.4201168926410991),
        RGB(0.020280582490749252, 0.4058348058429243, 0.4191622150013113),
        RGB(0.019990225004123997, 0.4070732183516097, 0.41821346310447616),
        RGB(0.02032635043348537, 0.40829256716031137, 0.41724603176486774),
        RGB(0.020066551586724726, 0.40952688825032696, 0.4163099842591926),
        RGB(0.019820749702474365, 0.4107592652638669, 0.4153798676633663),
        RGB(0.020209610974384784, 0.4119723169833864, 0.41443361562684167),
        RGB(0.0199946048015611, 0.41320077549388057, 0.4135162102844218),
        RGB(0.019947770085024085, 0.4144236116192939, 0.412593960930322),
        RGB(0.0202530197950012, 0.41563680743193854, 0.41164999537223534),
        RGB(0.019933054520342355, 0.4168679719683471, 0.41071437891471796),
        RGB(0.0202381479846077, 0.418081770512824, 0.409749248049353),
        RGB(0.02054344116291586, 0.4192958328106747, 0.40877397687862616),
        RGB(0.020221877184741322, 0.4205279871340717, 0.4078042231071176),
        RGB(0.020526998777265257, 0.42174260240188627, 0.40680769808983447),
        RGB(0.02020410433406562, 0.42297538941904256, 0.40581479544187965),
        RGB(0.02050903322248537, 0.42419052437572113, 0.40479695742126054),
        RGB(0.02081418471657828, 0.4254058823344212, 0.40376890953601585),
        RGB(0.02048943760288353, 0.4266395311025877, 0.40274163166346105),
        RGB(0.020794380699318597, 0.4278553592594597, 0.40169218480921864),
        RGB(0.02046810145891512, 0.4290895551442432, 0.40064159886636974),
        RGB(0.020772813573595166, 0.43030582043166543, 0.39957069561424086),
        RGB(0.021077772915672883, 0.431522268207046, 0.39848951529119164),
        RGB(0.02074936800686726, 0.4327571987230079, 0.39740432198792874),
        RGB(0.02105407898800591, 0.43397403448828337, 0.39630160204307335),
        RGB(0.02135905618669967, 0.4351910286249931, 0.3951885662291012),
        RGB(0.02102836203733253, 0.43642661819418405, 0.3940686301187215),
        RGB(0.021333072071832448, 0.4376439514268128, 0.3929339732117426),
        RGB(0.021000496461081028, 0.4388799528063799, 0.39179048295029434),
        RGB(0.021304912639175114, 0.4400975925193471, 0.3906341505250451),
        RGB(0.02160962011684179, 0.4413153506076298, 0.38946743918896864),
        RGB(0.02127444558249645, 0.4425518857998635, 0.3882889837448933),
        RGB(0.021578836318672877, 0.44376990195654203, 0.3871005184621865),
        RGB(0.021241533079258242, 0.4450067654710875, 0.3858983598491607),
        RGB(0.021545576358815006, 0.446225007436949, 0.38468808821583195),
        RGB(0.02184993440297649, 0.44744332819817106, 0.3834673774908607),
        RGB(0.021509694483864365, 0.44868060173561725, 0.38223003766956615),
        RGB(0.021813676465254436, 0.44989910046201304, 0.38098744541358376),
        RGB(0.022117990344404308, 0.4511176545113255, 0.37973437980977925),
        RGB(0.021774608684935, 0.4523552647376224, 0.3784617334531001),
        RGB(0.02207851389624194, 0.4535739492888085, 0.3771867132286672),
        RGB(0.02173256976962822, 0.4548117566175622, 0.37589013462341575),
        RGB(0.02203602701944831, 0.45603054010131966, 0.37459311090027847),
        RGB(0.022339834132769715, 0.45724934014461477, 0.37328555875049985),
        RGB(0.021990358426980154, 0.4584873631385629, 0.3719534682440054),
        RGB(0.02229367643506112, 0.45970621536151884, 0.37062384312530633),
        RGB(0.022597357239580316, 0.46092506121656024, 0.3692836586454014),
        RGB(0.022244111762533374, 0.4621632283615152, 0.3679159376206489),
        RGB(0.022547256554662186, 0.4633820801112924, 0.36655361304360123),
        RGB(0.02219094983545475, 0.4646203164317802, 0.36516174169418625),
        RGB(0.022493507715358838, 0.46583914335153326, 0.3637772320442317),
        RGB(0.022796436694081334, 0.46705792615163516, 0.36238211378039514),
        RGB(0.022435908336021475, 0.46829618893861075, 0.3609544176726722),
        RGB(0.02273819198244409, 0.4695149014821102, 0.3595370512533951),
        RGB(0.0230408528485722, 0.47073354764299874, 0.35810904910194),
        RGB(0.022675825485707894, 0.4719717675517134, 0.3566454166322647),
        RGB(0.022977775001820216, 0.47319029858779166, 0.35519510587618874),
        RGB(0.022609112387674428, 0.4744284636567761, 0.353707116206181),
        RGB(0.022910284935231125, 0.47564684984774647, 0.35223445619576016),
        RGB(0.023211828934695117, 0.47686513311853257, 0.3507511178964023),
        RGB(0.022838143668540128, 0.4781031415535831, 0.34922700906987814),
        RGB(0.023138830149320132, 0.47932123612206406, 0.34772126560381594),
        RGB(0.023439884666548953, 0.4805392062956207, 0.346204821146269),
        RGB(0.02306085442002933, 0.48177699128013146, 0.3446444887824208),
        RGB(0.023360961441492505, 0.4829947295455657, 0.3431055862185852),
        RGB(0.023661428849082948, 0.48421232226904826, 0.3415559618273385),
        RGB(0.02327671323362841, 0.4854498180264926, 0.3399593043716434),
        RGB(0.023576133065521185, 0.4866671363229243, 0.3383871720557377),
        RGB(0.023875901006531187, 0.4878842882762237, 0.3368042990613677),
        RGB(0.02348514086414575, 0.4891214301220667, 0.33517121780414083),
        RGB(0.023783750388492505, 0.49033826585207246, 0.33356579034662226),
        RGB(0.02408269073182659, 0.491554914801912, 0.33194960547316765),
        RGB(0.02368550748185373, 0.49279163919580343, 0.3302800045578286),
        RGB(0.0239831671720867, 0.49400793088485134, 0.3286412221323643),
        RGB(0.02428113499996484, 0.4952240157392995, 0.3269916678073758),
        RGB(0.023877130052166406, 0.49646026033751073, 0.32528545422616795),
        RGB(0.02417368299077128, 0.49767594768871953, 0.32361326289168574),
        RGB(0.023764246916756843, 0.4989118488972519, 0.32188222686142376),
        RGB(0.024059269872759664, 0.5001271122601663, 0.32018737115560647),
        RGB(0.024354540817494153, 0.5013421362094305, 0.3184817232042195),
        RGB(0.023937544930130266, 0.502577456336077, 0.3167139207010126),
        RGB(0.024231130300102433, 0.503792017463144, 0.3149855751177014),
        RGB(0.02452492480950936, 0.5050063202346081, 0.3132464294510164),
        RGB(0.024818923477049237, 0.5062203584904184, 0.3114964835624452),
        RGB(0.024391854699274677, 0.5074548023962933, 0.30967990201723633),
        RGB(0.02468395832896228, 0.5086683275581518, 0.30790722455381825),
        RGB(0.024976218371448682, 0.5098815698676251, 0.3061237430839157),
        RGB(0.02454052465311961, 0.5111152976248177, 0.3042702046374224),
        RGB(0.024830702234913, 0.5123279901454278, 0.3024639687544831),
        RGB(0.025120981445999665, 0.5135403819538094, 0.3006469282609076),
        RGB(0.02467615846859877, 0.5147733379949203, 0.2987563534229604),
        RGB(0.024964153485446373, 0.5159851442992237, 0.29691654043567034),
        RGB(0.02525218805631381, 0.5171966325275714, 0.2950659256574383),
        RGB(0.02479771002029723, 0.5184287628002143, 0.29313823730131444),
        RGB(0.025083244090428218, 0.5196396308264686, 0.29126483698350364),
        RGB(0.025368748129435924, 0.5208501639285084, 0.289380641386656),
        RGB(0.024904067972839193, 0.5220814159489148, 0.28741576454197565),
        RGB(0.02518684045743277, 0.5232912952057505, 0.28550877569242616),
        RGB(0.02546950563807028, 0.5245008232250614, 0.28359100206437027),
        RGB(0.0257520452553363, 0.5257099947431049, 0.2816624512005281),
        RGB(0.025273743174897462, 0.5269399877557014, 0.2796482947117513),
        RGB(0.025553238527190564, 0.5281484623832627, 0.2776969558094269),
        RGB(0.02583252047767497, 0.5293565649399329, 0.27573485634623535),
        RGB(0.025342687278225, 0.530585563804364, 0.2736833540325552),
        RGB(0.025618659139143952, 0.5317929384365054, 0.27169847329019736),
        RGB(0.02589432181402782, 0.5329999260092514, 0.2697028535173317),
        RGB(0.026169650515064483, 0.5342065217107325, 0.26769650700414854),
        RGB(0.02566441518472246, 0.5354341136565228, 0.26559554881543096),
        RGB(0.02593607440089099, 0.5366399420065922, 0.2635664488992882),
        RGB(0.026207293077341005, 0.5378453643031107, 0.26152665137251846),
        RGB(0.025689091308214843, 0.5390718557258194, 0.25938820146640035),
        RGB(0.025956340689167336, 0.5402764824574519, 0.2573256743467414),
        RGB(0.026223035071281025, 0.5414806895815886, 0.2552524847344541),
        RGB(0.02648914299174269, 0.5426844727758662, 0.253168650880399),
        RGB(0.025953622865552046, 0.5439094225322002, 0.2509805886413524),
        RGB(0.02621535723506262, 0.5451123746400316, 0.24887408019183227),
        RGB(0.02647638014249391, 0.5463148901345085, 0.24675697210259034),
        RGB(0.026736656309958143, 0.5475169649904394, 0.2446292868243653),
        RGB(0.026182684073858778, 0.5487403024555053, 0.24239154022771425),
        RGB(0.0264381582482968, 0.5499415130679357, 0.2402412541218903),
        RGB(0.026692750502619135, 0.5511422712666262, 0.2380804463188308),
        RGB(0.026946421835986886, 0.5523425733366045, 0.2359091441393586),
        RGB(0.02637283066388908, 0.5535642326859092, 0.23362164776852717),
        RGB(0.02662124921388363, 0.5547636398193827, 0.23142783979817572),
        RGB(0.02686860204450892, 0.5559625799961487, 0.22922360552386406),
        RGB(0.027114846592237042, 0.5571610498248941, 0.22700897794804165),
        RGB(0.027359939338204183, 0.5583590459976642, 0.22478399188616666),
        RGB(0.026760964120808934, 0.5595785169925375, 0.2224346578261549),
        RGB(0.027000223239738743, 0.5607755835699475, 0.22018733316331784),
        RGB(0.027238174547927655, 0.5619721669050571, 0.21792973757855488),
        RGB(0.02747477125830685, 0.5631682640311352, 0.21566191289133796),
        RGB(0.02770996570302926, 0.5643638720693789, 0.2133839031742551),
        RGB(0.027083757519820416, 0.5655810703051862, 0.21097272512308274),
        RGB(0.0273125102427818, 0.5667757183163664, 0.20867259566575164),
        RGB(0.027539695075125444, 0.5679698689617747, 0.20636239282741997),
        RGB(0.027765261504516265, 0.5691635197224519, 0.20404216942229703),
        RGB(0.02798915824639552, 0.5703566681722395, 0.20171198109939587),
        RGB(0.027333847585343452, 0.5715715199791992, 0.19923898384150196),
        RGB(0.027550674488762, 0.572763682422921, 0.19688695843907544),
        RGB(0.02776565855944032, 0.573955335657634, 0.19452510995617586),
        RGB(0.02797874623192208, 0.5751464776370806, 0.19215350510497825),
        RGB(0.0281898833138436, 0.5763371064130879, 0.18977221421419072),
        RGB(0.02750360539215732, 0.5775495494229426, 0.18723745787368626),
        RGB(0.027707033408210967, 0.578739170910995, 0.18483469276612338),
        RGB(0.027908332790823925, 0.5799282737551749, 0.1824224219127877),
        RGB(0.02810744777730844, 0.5811168564092276, 0.18000072986561644),
        RGB(0.028304322161884506, 0.5823049174308275, 0.17756970586339027),
        RGB(0.02849889933535127, 0.583492455482835, 0.17512944411893933),
        RGB(0.028691122326436728, 0.5846794693345849, 0.17268004412791554),
        RGB(0.027959877030049166, 0.5858884505110685, 0.17006012627779),
        RGB(0.028143504935021605, 0.5870744358573375, 0.16758999815877618),
        RGB(0.028324598400389107, 0.5882598937541694, 0.16511099016561323),
        RGB(0.028503100116030865, 0.589444823408365, 0.16262322292269626),
        RGB(0.028678952648375885, 0.5906292241401844, 0.16012682407989645),
        RGB(0.02885209849137182, 0.5918130953848739, 0.157621928785437),
        RGB(0.029022480119107658, 0.5929964366942433, 0.1551086801974763),
        RGB(0.029190040040030757, 0.5941792477382936, 0.15258723003807537),
        RGB(0.02840385316978476, 0.5953841958005875, 0.14987159553157794),
        RGB(0.02856184062933827, 0.596565967228475, 0.1473307372822163),
        RGB(0.028716832520993225, 0.5977472079018156, 0.14478207925050762),
        RGB(0.02886877276227205, 0.5989279179788454, 0.14222580831387713),
        RGB(0.02901760560093164, 0.600108097745065, 0.13966212314596582),
        RGB(0.029163275677492786, 0.6012877476152644, 0.13709123510513904),
        RGB(0.029305728089050555, 0.6024668681356284, 0.1345133692032679),
        RGB(0.029444908454353363, 0.6036454599859328, 0.13192876516304597),
        RGB(0.02958076298009274, 0.6048235239818296, 0.12933767857303335),
        RGB(0.02971323852837069, 0.606001061077235, 0.12674038215064765),
        RGB(0.029842282685227848, 0.6071780723668219, 0.12413716712450465),
        RGB(0.028975723294520882, 0.6083774451198067, 0.12129625923639059),
        RGB(0.0290940080530037, 0.6095534274982308, 0.11867704850875233),
        RGB(0.029208714720870194, 0.6107288879806974, 0.11605272249596957),
        RGB(0.029319795159038663, 0.6119038282507159, 0.113423652202014),
        RGB(0.029427202301696057, 0.6130782501469599, 0.11079023565123378),
        RGB(0.029530890228909135, 0.6142521556665802, 0.10815290026480695),
        RGB(0.029630814239919867, 0.6154255469686885, 0.10551210548003467),
        RGB(0.029726930926893363, 0.6165984263780278, 0.10286834563964237),
        RGB(0.029819198249120545, 0.6177707963888398, 0.10022215318135894),
        RGB(0.029907575607607345, 0.6189426596689489, 0.09757410216147774),
        RGB(0.029992023920011792, 0.6201140190640726, 0.09492481214988266),
        RGB(0.030072505695847875, 0.6212848776023855, 0.09227495253812215),
        RGB(0.030148985111903132, 0.6224552384993488, 0.08962524730657823),
        RGB(0.03022142808793094, 0.6236251051628314, 0.08697648030152799),
        RGB(0.030289802362481928, 0.624794481198546, 0.08432950107795806),
        RGB(0.03035407756896563, 0.6259633704158265, 0.08168523136919856),
        RGB(0.03041422531191653, 0.6271317768337772, 0.07904467224974676),
        RGB(0.03047021924351471, 0.6282997046878248, 0.07640891206278155),
        RGB(0.030522035140402, 0.6294671584367129, 0.07377913518861129),
        RGB(0.030569650980939184, 0.6306341427699754, 0.0711566317341426),
        RGB(0.03061304702293518, 0.6318006626159428, 0.06854280822593209),
        RGB(0.030652205882107684, 0.6329667231503211, 0.06593919938957682),
        RGB(0.030687112611381594, 0.6341323298054153, 0.06334748109514945),
        RGB(0.030717754781357857, 0.635297488280052, 0.060769484540510905),
        RGB(0.030744122562172262, 0.6364622045502842, 0.058207211729808535),
        RGB(0.030766208807195335, 0.6376264848809606, 0.05566285228075998),
        RGB(0.030784009138984915, 0.6387903358382591, 0.05313880155813038),
        RGB(0.030797522037995715, 0.639953764303298, 0.050637680078123394),
        RGB(0.030806748934767997, 0.6411167774869574, 0.04816235405403586),
        RGB(0.03081169430626961, 0.6422793829460618, 0.045715956851278196),
        RGB(0.03081236577739973, 0.6434415886011082, 0.04330191098239319),
        RGB(0.03080877422865121, 0.6446034027557437, 0.040923950091638815),
        RGB(0.030800933911356704, 0.6457648341182479, 0.038580184136165416),
        RGB(0.03189843250299969, 0.6469025179633052, 0.03692855509989857),
        RGB(0.03188543557013632, 0.6480632010961591, 0.034822019055970786),
        RGB(0.03186823544968876, 0.6492235304745247, 0.03283713360435827),
        RGB(0.03184686712467637, 0.6503835178327965, 0.03097260633980078),
        RGB(0.0363153054281716, 0.6514500182535425, 0.03146160466126649),
        RGB(0.039684103399968466, 0.6525402381435099, 0.0313630970474609),
        RGB(0.042981523559619074, 0.6536307682399887, 0.03125880886789437),
        RGB(0.04716101664496216, 0.6546981036305064, 0.03173881137559706),
        RGB(0.05016705336295801, 0.6557892305257111, 0.031624797920325465),
        RGB(0.05307392400408855, 0.6568806668291376, 0.03150482858809433),
        RGB(0.05589127557308005, 0.657972412269827, 0.031378843174103555),
        RGB(0.05889121767891629, 0.6590562662575548, 0.031618509933991124),
        RGB(0.06024927683467315, 0.6601783918025654, 0.03154797740236014),
        RGB(0.06244687957596127, 0.6612771889473258, 0.03207813653787654),
        RGB(0.06376915904090433, 0.6623998624162853, 0.03200742610193979),
        RGB(0.06508043186767834, 0.6635228105849342, 0.03193590136637408),
        RGB(0.06638114187465963, 0.664646033064695, 0.03186355977843055),
        RGB(0.06767170753274968, 0.6657695294678528, 0.03179039878289506),
        RGB(0.06974407566773305, 0.6668696782592868, 0.03232550100147364),
        RGB(0.07100613683951554, 0.6679937187743946, 0.032252148538058724),
        RGB(0.0723163517716405, 0.669116567731239, 0.03217471492093861),
        RGB(0.07370696248394143, 0.6702373386805123, 0.03209120328312008),
        RGB(0.07517570391168446, 0.671356010052749, 0.0320015313350435),
        RGB(0.07745701759935122, 0.6724488922229234, 0.032522238602756603),
        RGB(0.07906760306318042, 0.6735632019953464, 0.032421234254182335),
        RGB(0.08075218731464051, 0.6746752530450373, 0.03231360589941776),
        RGB(0.08250925082929911, 0.6757849940017159, 0.03219920124220442),
        RGB(0.0850232333652203, 0.6768687323556256, 0.032700711844388414),
        RGB(0.08690889627850273, 0.6779737024927981, 0.03257375189904502),
        RGB(0.08886184430987457, 0.6790762134232599, 0.03243956280946706),
        RGB(0.09152785663034377, 0.6801525726947721, 0.03292552761202339),
        RGB(0.09359859150015412, 0.6812500220564179, 0.03277788127616775),
        RGB(0.0957311698541074, 0.6823448692740764, 0.03262255867594548),
        RGB(0.09853375116035851, 0.6834134250726785, 0.033091627210615496),
        RGB(0.10077339763085605, 0.6845029315163645, 0.032921954919269525),
        RGB(0.10306950587285957, 0.6855896982470214, 0.0327441636386285),
        RGB(0.10599415499848824, 0.6866500425286651, 0.0331949967270471),
        RGB(0.10838713858755153, 0.6877311994320346, 0.03300197063189177),
        RGB(0.11138136872168644, 0.6887858499765165, 0.03344050185319511),
        RGB(0.11386497541093596, 0.6898612230798808, 0.03323165336125678),
        RGB(0.11639675463561752, 0.6909336376976906, 0.033013954950698414),
        RGB(0.11949214786727638, 0.6919794287127141, 0.03343203602737952),
        RGB(0.1221057271486754, 0.6930458052185542, 0.03319763917065541),
        RGB(0.12525861294551868, 0.6940854832225188, 0.033601946353854995),
        RGB(0.1279487471528075, 0.6951456567974976, 0.03335026853584902),
        RGB(0.131155129392821, 0.6961790605124696, 0.03374021525197637),
        RGB(0.13391697240091513, 0.697232869701589, 0.03347067567401012),
        RGB(0.13717321949821262, 0.6982598411947415, 0.033845676606749905),
        RGB(0.14000230586090712, 0.6993071277736168, 0.03355769611967581),
        RGB(0.14330512210157462, 0.7003275123350551, 0.033917167165624054),
        RGB(0.14619734464102122, 0.7013681211969183, 0.03361016824867606),
        RGB(0.14954374106261734, 0.7023817672360888, 0.0339535265150108),
        RGB(0.1524953263070249, 0.7034155462957109, 0.033626933293989136),
        RGB(0.1558825922204461, 0.7044223052533374, 0.03395359713239562),
        RGB(0.1588900750790871, 0.7054491053651004, 0.03360683543193552),
        RGB(0.16231575093747688, 0.7064488316381203, 0.033916224504059865),
        RGB(0.1657557950538387, 0.7074449923988378, 0.03421764049648192),
        RGB(0.16883780161101614, 0.7084610574033379, 0.033840257300052384),
        RGB(0.1723131978675485, 0.7094499730400166, 0.03412352898361697),
        RGB(0.17580187037729042, 0.7104352193929608, 0.03439839119595902),
        RGB(0.1789525864462507, 0.7114402312612867, 0.0339890982636261),
        RGB(0.18247394287741356, 0.7124180264228739, 0.034244949882302186),
        RGB(0.18600762808046398, 0.7133920517097085, 0.03449195715296456),
        RGB(0.1892219220293584, 0.7143857017007943, 0.034049472699318795),
        RGB(0.1927859509548275, 0.7153520759583385, 0.03427660685971538),
        RGB(0.1963614808469027, 0.7163145828671222, 0.03449446358522184),
        RGB(0.19994831668203988, 0.7172731908295533, 0.03470289834984269),
        RGB(0.2032386159200627, 0.7182512334867359, 0.03421463858603844),
        RGB(0.20685319785026585, 0.7192019338843952, 0.03440205563068164),
        RGB(0.21047838017937825, 0.7201486419464569, 0.034579620455450426),
        RGB(0.21411399566169886, 0.7210913274343538, 0.03474718950866676),
        RGB(0.2177598814933664, 0.7220299604477339, 0.034904619502716915),
        RGB(0.2214158790749387, 0.7229645114232035, 0.03505176742803878),
        RGB(0.22480577935637064, 0.7239182050388445, 0.0344913103413601),
        RGB(0.22848641017321752, 0.7248444843132164, 0.034615738645735625),
        RGB(0.23217657632543104, 0.725766594167521, 0.03472945998681408),
        RGB(0.23587613851935418, 0.7266845063663281, 0.034832332666242666),
        RGB(0.23958496047912786, 0.72759819300543, 0.03492421533783285),
        RGB(0.24330290879718458, 0.7285076265107825, 0.03500496702303703),
        RGB(0.24702985279407214, 0.7294127796374531, 0.03507444712661609),
        RGB(0.25076566438700343, 0.7303136254685794, 0.03513251545249388),
        RGB(0.2545102179665617, 0.7312101374143279, 0.03517903221979014),
        RGB(0.25826339028101747, 0.7321022892108533, 0.03521385807901265),
        RGB(0.26202506032777495, 0.732990054919251, 0.0352368541283996),
        RGB(0.2657951092514898, 0.7338734089245001, 0.035247881930401674),
        RGB(0.26957342024842096, 0.7347523259343935, 0.0352468035283002),
        RGB(0.27335987847661564, 0.7356267809784546, 0.03523348146292859),
        RGB(0.277154370971579, 0.7364967494068309, 0.0352077787895207),
        RGB(0.2809567865670486, 0.7373622068891704, 0.03516955909464817),
        RGB(0.284977768302341, 0.7382002888322619, 0.0358431999236766),
        RGB(0.28879236231697036, 0.7390566852191078, 0.03578122309049984),
        RGB(0.2926146262394328, 0.739908500412628, 0.03570632014846798),
        RGB(0.2964444531186919, 0.740755711357593, 0.03561835692341402),
        RGB(0.300281737562844, 0.7415982953122754, 0.03551719985812606),
        RGB(0.30412637568028306, 0.7424362298471492, 0.0354027160296889),
        RGB(0.30816984037521145, 0.74324685711337, 0.03600971917271902),
        RGB(0.312025933333998, 0.7440754644674844, 0.03586985022173708),
        RGB(0.31588913435029464, 0.744899357865345, 0.035716256170097056),
        RGB(0.31975934323343513, 0.7457185161215645, 0.035548806747582075),
        RGB(0.32381646970121636, 0.7465104359453246, 0.03610933626212722),
        RGB(0.32769767695474644, 0.747320102937472, 0.03591543891645933),
        RGB(0.3315856499255118, 0.7481249739858259, 0.03570729600581789),
        RGB(0.3356521790614694, 0.748902670766381, 0.03623206829333563),
        RGB(0.3395508240799118, 0.7496979345296012, 0.03599669296588382),
        RGB(0.3434559945174193, 0.7504883443060049, 0.035746688485945234),
        RGB(0.3475318138422851, 0.7512516554145448, 0.03623451166658945),
        RGB(0.35144732000992585, 0.7520323474424921, 0.03595650343830646),
        RGB(0.35552842046245847, 0.7527859970939863, 0.036419711860881145),
        RGB(0.35945406251533407, 0.753556901441871, 0.03611319090519806),
        RGB(0.3635404195975121, 0.7543008249905001, 0.03655126520867873),
        RGB(0.36747599162901656, 0.7550618741506955, 0.03621572891964233),
        RGB(0.3715675643642241, 0.755796009436034, 0.03662815580835292),
        RGB(0.375512855377693, 0.7565471382937237, 0.03626310821840696),
        RGB(0.3796095880693843, 0.7572714256089577, 0.03664938072347135),
        RGB(0.3835643828449455, 0.7580125714094524, 0.03625433276604489),
        RGB(0.3876662066582939, 0.7587269534680422, 0.036613950503988295),
        RGB(0.3916302865282413, 0.7594580557825996, 0.03618842027297222),
        RGB(0.3957371209159103, 0.7601624776834166, 0.036520889701074186),
        RGB(0.39984540428172577, 0.760861928344303, 0.036840590335888816),
        RGB(0.40382201845019444, 0.7615778875645448, 0.03636923737478636),
        RGB(0.4079352043835066, 0.7622673012564117, 0.036661059131345985),
        RGB(0.4120498272094634, 0.762951708344522, 0.03693974564942047),
        RGB(0.416038557726593, 0.7636524046276468, 0.03642151501391582),
        RGB(0.42015795013272855, 0.7643267031498543, 0.03667160854706569),
        RGB(0.4242787518448978, 0.7649959623219043, 0.03690820858952947),
        RGB(0.428400959983923, 0.7656601722033664, 0.037131196457387806),
        RGB(0.4324045837617608, 0.7663403674150973, 0.036549382096360244),
        RGB(0.43653136982768603, 0.7669943819533471, 0.03674284916042766),
        RGB(0.440659516919678, 0.7676433178447235, 0.03692235728164531),
        RGB(0.4447890158425524, 0.7682871662700755, 0.03708779164754529),
        RGB(0.44891985585074295, 0.7689259186859765, 0.03723903843503555),
        RGB(0.4530520247348973, 0.7695595668218308, 0.0373759848237537),
        RGB(0.45707580118563934, 0.7702087176192807, 0.03669624636354598),
        RGB(0.46121222427725533, 0.7708320577880438, 0.03680233688611262),
        RGB(0.4653499098787937, 0.7714502691693537, 0.03689379863348898),
        RGB(0.4694888412983325, 0.7720633445447198, 0.03697052297795895),
        RGB(0.47362900073451913, 0.7726712769535075, 0.03703240235850205),
        RGB(0.47777036934210243, 0.7732740596898394, 0.03707933029296565),
        RGB(0.48191292729442, 0.7738716862994663, 0.03711120139002509),
        RGB(0.48605665384302416, 0.77446415057661, 0.03712791136092804),
        RGB(0.4902015273745715, 0.7750514465607761, 0.03712935703102231),
        RGB(0.4943475254651369, 0.775633568533542, 0.037115436351064214),
        RGB(0.4984946249320665, 0.7762105110153171, 0.03708604840828715),
        RGB(0.502642801883516, 0.7767822687620808, 0.03704109343727423),
        RGB(0.5068833934855096, 0.7773292179749586, 0.03780552235540209),
        RGB(0.5110322390289221, 0.7778906833786734, 0.03773100866787591),
        RGB(0.515182102470769, 0.7784469511114819, 0.03764063108073489),
        RGB(0.5193329571428251, 0.7789980168477252, 0.037534294469291886),
        RGB(0.5234847758966199, 0.7795438764806356, 0.03741190490692426),
        RGB(0.527637531140749, 0.7800845261189507, 0.03727336967449897),
        RGB(0.5318742911250198, 0.7806009149353412, 0.03795522435673687),
        RGB(0.5360275130690987, 0.7811312343516991, 0.03778596736189297),
        RGB(0.5401816001049143, 0.781656334828754, 0.037600289000297264),
        RGB(0.5443365228872072, 0.7821762133120265, 0.037398101419540156),
        RGB(0.5485701198321974, 0.7826722297861471, 0.03802371849010636),
        RGB(0.5527253564047435, 0.7831817624700191, 0.03779007802733804),
        RGB(0.5568813516114738, 0.7836860666783018, 0.03753966724447331),
        RGB(0.5611121540416362, 0.7841668260331799, 0.038122695477072345),
        RGB(0.5652683429590374, 0.784660777791412, 0.037840306544910655),
        RGB(0.5694252100161443, 0.7851494963355118, 0.03754089734452582),
        RGB(0.573653123466836, 0.7856150027915638, 0.03808053264367187),
        RGB(0.5778100556814102, 0.7860933657044101, 0.03774864207859234),
        RGB(0.5820355802802507, 0.7865487472990333, 0.03825966141021112),
        RGB(0.5861924953932597, 0.7870167553438145, 0.037894963188238345),
        RGB(0.5903499526979912, 0.7874795264158704, 0.03751285157021069),
        RGB(0.5945724040245368, 0.7879196752929557, 0.03797920581386968),
        RGB(0.5987297050424524, 0.7883720936862876, 0.03756382074223956),
        RGB(0.6029496489872047, 0.7888021384147543, 0.03800073471378663),
        RGB(0.6071677496346222, 0.7892271983332287, 0.038423913705847),
        RGB(0.6113240912918714, 0.7896641602797437, 0.03795893442463016),
        RGB(0.6155396172493154, 0.7900791352802582, 0.03835220145028235),
        RGB(0.619695586519552, 0.7905057590501737, 0.03785320940536028),
        RGB(0.623908482002378, 0.7909106624762815, 0.03821626486617712),
        RGB(0.6280639857131055, 0.7913269553644167, 0.037682984164797186),
        RGB(0.632274192199553, 0.791721801786401, 0.03801553835126383),
        RGB(0.636482492199995, 0.7921116945300647, 0.03833382588105742),
        RGB(0.6406365928530963, 0.7925125773788863, 0.037749476514203247),
        RGB(0.6448421200382853, 0.7928924388696306, 0.03803684255155144),
        RGB(0.6490457098142719, 0.7932673627822314, 0.038309731245799485),
        RGB(0.6532473538073746, 0.7936373553462163, 0.03856807355243269),
        RGB(0.6573989450776796, 0.7940177841421354, 0.03791530316765149),
        RGB(0.66159770206957, 0.7943777847841516, 0.03814219534081519),
        RGB(0.6657944784798606, 0.7947328717993949, 0.0383543450402907),
        RGB(0.6699892646295347, 0.7950830519390929, 0.03855168805063211),
        RGB(0.6741820505370315, 0.7954283320777663, 0.03873416135727877),
        RGB(0.6783297994466064, 0.7957833199741623, 0.03799493739041623),
        RGB(0.6825195500096713, 0.796118663815401, 0.03814535305462981),
        RGB(0.6867072621836784, 0.7964491271692659, 0.03828072122861862),
        RGB(0.6908929251464992, 0.7967747173610121, 0.03840098374003412),
        RGB(0.6950765278828611, 0.7970954418216145, 0.03850608361786965),
        RGB(0.6992580592043067, 0.797411308084305, 0.038595965091877786),
        RGB(0.7034375077683261, 0.7977223237811313, 0.038670573591768446),
        RGB(0.7076148620966649, 0.7980284966395406, 0.03872985574617812),
        RGB(0.7117901105928659, 0.7983298344789823, 0.038773759381416896),
        RGB(0.7159632415590571, 0.7986263452075402, 0.0388022335200043),
        RGB(0.7201342432120216, 0.7989180368185848, 0.03881522837898154),
        RGB(0.7243031036985768, 0.7992049173874535, 0.03881269536800875),
        RGB(0.728469811110292, 0.7994869950681537, 0.038794587087260524),
        RGB(0.7326343534975633, 0.7997642780900922, 0.03876085732510132),
        RGB(0.7367967188830759, 0.8000367747548344, 0.0387114610555596),
        RGB(0.7409568952746746, 0.8003044934328837, 0.03864635443560177),
        RGB(0.7451148706776666, 0.8005674425604941, 0.038565494802197176),
        RGB(0.7492706331065742, 0.8008256306365054, 0.03846884066918826),
        RGB(0.753424170596363, 0.8010790662192095, 0.03835635172397272),
        RGB(0.7575754712131629, 0.801327757923243, 0.038227988823983004),
        RGB(0.7617487490552545, 0.8015606139435483, 0.03903235108871544),
        RGB(0.7658946549538621, 0.8018000388923762, 0.038874173996084165),
        RGB(0.7700382930007423, 0.8020347480586764, 0.038700007772300385),
        RGB(0.7741796514059663, 0.8022647502580584, 0.03850981788306723),
        RGB(0.7783187184593664, 0.8024900543473364, 0.038303570943882516),
        RGB(0.7824753158003205, 0.8027005633738319, 0.03904056053468382),
        RGB(0.7866089019928363, 0.8029167027197129, 0.03880412790171419),
        RGB(0.7907401664202145, 0.8031281727186128, 0.038551540028546674),
        RGB(0.7948690976983633, 0.8033349823690579, 0.038282768049755236),
        RGB(0.7990120785540442, 0.803527866211664, 0.03896568656856239),
        RGB(0.8031354627449458, 0.8037255949774104, 0.0386664700208236),
        RGB(0.8072711538321751, 0.8039113964270261, 0.038986422617102404),
        RGB(0.8114316510845841, 0.8040835853123776, 0.039455480566208394),
        RGB(0.8156049800757742, 0.8042504482662842, 0.039022380236529874),
        RGB(0.8198177181066806, 0.8043949339527786, 0.03962372859844665),
        RGB(0.824045019507605, 0.8045332732763149, 0.039325775341488726),
        RGB(0.8283098671525237, 0.8046494349518775, 0.04005947329552869),
        RGB(0.8325910000525768, 0.8047586118098564, 0.03989662743228778),
        RGB(0.8369078174483852, 0.8048458141675503, 0.04075673268810507),
        RGB(0.8412426317760714, 0.8049251747594269, 0.0407295079412932),
        RGB(0.8456046699772178, 0.8049892411407674, 0.040769095204805005),
        RGB(0.8499938893770251, 0.8050378412149525, 0.04087532784915587),
        RGB(0.85441024590624, 0.8050708008954787, 0.04104784122889026),
        RGB(0.8588536940445408, 0.8050879440974782, 0.04128607699340641),
        RGB(0.8633241867620639, 0.8050890927298142, 0.04158928984807395),
        RGB(0.867821675459045, 0.8050740666877959, 0.04195655656543156),
        RGB(0.872346109903587, 0.8050426838465384, 0.042386786987057744),
        RGB(0.8768969871908932, 0.8049992412084133, 0.041973633041971804),
        RGB(0.881476029826447, 0.8049342925900304, 0.04253440774777439),
        RGB(0.8860831431110989, 0.8048563082683854, 0.04225617775679658),
        RGB(0.8907165662982215, 0.8047570271474244, 0.042944126125188685),
        RGB(0.8953796750310049, 0.8046437120545679, 0.042799978703080506),
        RGB(0.9000672355747585, 0.8045093146135625, 0.043610340113140016),
        RGB(0.9047860830178824, 0.8043598620177409, 0.043597907054898764),
        RGB(0.9095331270101835, 0.8041918733867752, 0.04365113495420204),
        RGB(0.9143082954458002, 0.8040051365734311, 0.043769685425562165),
        RGB(0.9191115138389025, 0.8037994371041517, 0.043953032996200285),
        RGB(0.9239427052417405, 0.8035745581761549, 0.04420047068347004),
        RGB(0.9288017901606208, 0.8033302806555456, 0.04451111771024057),
        RGB(0.9336886864698074, 0.803066383076505, 0.044883929144084546),
        RGB(0.938603309323366, 0.8027826416415957, 0.045317707200500705),
        RGB(0.9435571364148354, 0.8024788170053142, 0.04496427606439934),
        RGB(0.9485277936972537, 0.8021543560953136, 0.04552379002870167),
        RGB(0.9535259044036509, 0.8018093615452845, 0.04614042010205064),
        RGB(0.9572210885085922, 0.8015462594707281, 0.10207642659839444),
        RGB(0.9598746377541908, 0.8014182115971645, 0.15749589488476037),
        RGB(0.9619981098099722, 0.8014085164209024, 0.20211447726556508),
        RGB(0.9637685373169708, 0.8015021161600044, 0.23927930275430692),
        RGB(0.9652698693176992, 0.8016869883226984, 0.2712876263398194),
        RGB(0.9666112146758695, 0.801944910441491, 0.29905573384500067),
        RGB(0.9677899850925847, 0.8022721028655733, 0.3238995147519015),
        RGB(0.9688453397028164, 0.8026593916433251, 0.3463354196507753),
        RGB(0.9698160066822822, 0.8030974988373322, 0.366702599095877),
        RGB(0.9707072091423518, 0.8035826526390505, 0.3854119305082664),
        RGB(0.9715509561701902, 0.8041069057391936, 0.4026209602340267),
        RGB(0.9723055206699113, 0.8046753470079608, 0.41878706506837593),
        RGB(0.973029652148704, 0.805275809654241, 0.43381767801798576),
        RGB(0.9737085989155608, 0.8059091674602602, 0.44794389536918805),
        RGB(0.9743202964061587, 0.8065781682348917, 0.4613758725065184),
        RGB(0.9749229186167335, 0.8072705518708625, 0.47398579285333514),
        RGB(0.9754906173011587, 0.8079899632171107, 0.4859661236424801),
        RGB(0.9760376419794096, 0.8087325354112581, 0.49734018406091524),
        RGB(0.9765294367178557, 0.8095042221490915, 0.508285042247796),
        RGB(0.977025420785865, 0.8102922208554789, 0.518658552961917),
        RGB(0.9775395197863913, 0.8110926253556802, 0.528476037096336),
        RGB(0.9779784289406829, 0.8119239681103162, 0.5380587345261376),
        RGB(0.9784014049537427, 0.8127734082221418, 0.5472600716017453),
        RGB(0.9788173356779569, 0.8136383950420486, 0.55608845088847),
        RGB(0.9792350572447216, 0.8145163709701274, 0.5645514495636242),
        RGB(0.9796035097974113, 0.8154178217183462, 0.5728064881627449),
        RGB(0.9799881803122147, 0.816328038640063, 0.5807078411184234),
        RGB(0.9803348566130589, 0.8172584024186099, 0.5884105003624699),
        RGB(0.980712068963684, 0.8181932868576939, 0.5957694007089338),
        RGB(0.9810624882950364, 0.819144967391874, 0.6029374675683835),
        RGB(0.9813901780592983, 0.8201122109746346, 0.6099176017586524),
        RGB(0.981699199098173, 0.8210937788831179, 0.6167125242898546),
        RGB(0.9819936090712159, 0.8220884275645319, 0.623324794655223),
        RGB(0.9823493912968785, 0.82307827416457, 0.6296112332668318),
        RGB(0.982628214132114, 0.8240948959762407, 0.6358658302313726),
        RGB(0.9829045641373876, 0.8251208480664498, 0.6419446195501496),
        RGB(0.9831824774374988, 0.8261548750929201, 0.6478496588716017),
        RGB(0.983465982141133, 0.8271957204018262, 0.6535829079339138),
        RGB(0.9837590969802755, 0.8282421265915634, 0.6591462373088556),
        RGB(0.9839851598625488, 0.8293121048256844, 0.6646841345186721),
        RGB(0.9842259722617189, 0.8303859971903602, 0.6700547389213992),
        RGB(0.9844855480125067, 0.8314625428373479, 0.6752597297194245),
        RGB(0.9847678871280888, 0.8325404820902239, 0.6803007205873507),
        RGB(0.9849905869019057, 0.8336395537266311, 0.6853202645758639),
        RGB(0.9852411910759359, 0.8347383616328622, 0.6901780583690009),
        RGB(0.9854344615414988, 0.8358574999568301, 0.6950157769931136),
        RGB(0.9856607882626768, 0.8369747120889162, 0.6996938693739269),
        RGB(0.9858321073523287, 0.8381114427883013, 0.7043531712987924),
        RGB(0.9860416433143976, 0.8392445822032217, 0.708854859616867),
        RGB(0.9862933757393592, 0.8403728763908156, 0.7132002703518995),
        RGB(0.986495028047088, 0.8415190390417898, 0.7175290362359787),
        RGB(0.9867440219590667, 0.842658696311092, 0.7217033729694982),
        RGB(0.9869453068439608, 0.8438153999418715, 0.7258621576916167),
        RGB(0.9870986899332393, 0.8449891523697466, 0.7300055714491049),
        RGB(0.9873057611954742, 0.8461543275624016, 0.733996840623098),
        RGB(0.9874673282681935, 0.8473357208353549, 0.7379737654510048),
        RGB(0.9876877426869662, 0.8485068827424326, 0.7418002166204221),
        RGB(0.9878650633816425, 0.8496934317734639, 0.7456133006917744),
        RGB(0.9879991331306589, 0.8508953585393795, 0.7494131703771582),
        RGB(0.9881984195370911, 0.8520849905615302, 0.7530646362330099),
        RGB(0.9883568878395118, 0.8532891662422292, 0.7567038119982926),
        RGB(0.9884743998422859, 0.8545078696204474, 0.7603308390883341),
        RGB(0.9886635121858937, 0.8557122238754916, 0.7638114290978794),
        RGB(0.9888141203726067, 0.8569302715181016, 0.7672807468253394),
        RGB(0.9890414761652718, 0.8581323450864384, 0.7706050794267193),
        RGB(0.9892327819230872, 0.8593472831392025, 0.7739189780957254),
        RGB(0.9893879356160952, 0.8605750639419242, 0.7772225644961929),
        RGB(0.9895068379366346, 0.8618156619609407, 0.7805159612798841),
        RGB(0.9895893924315337, 0.8630690478321618, 0.7837992921106822),
        RGB(0.9897575462730536, 0.8643036077930344, 0.7869402330852436),
        RGB(0.9898918417068588, 0.8655501268233237, 0.7900718938402396),
        RGB(0.9901168646437853, 0.8667762326921647, 0.7930624721327568),
        RGB(0.9901845446885277, 0.8680461947012985, 0.7961761802292472),
        RGB(0.990345444736146, 0.8692949229505659, 0.7991495526499374),
        RGB(0.9904748435861773, 0.8705547230404813, 0.8021146150124944),
        RGB(0.9907025694369057, 0.871791729007125, 0.8049405756025291),
        RGB(0.9907701167812576, 0.8730731918978621, 0.8078895909749624),
        RGB(0.9909384906211586, 0.8743310499954606, 0.8107002087426346),
        RGB(0.9910777712637365, 0.8755990933055952, 0.8135034309997083),
        RGB(0.9911879259056794, 0.8768772803791594, 0.8162993602689361),
        RGB(0.9912689259794923, 0.8781655666341263, 0.8190881001509525),
        RGB(0.991458344845262, 0.8794279213030516, 0.8217402710303974),
        RGB(0.9916211160314424, 0.8806995784038285, 0.8243859099327777),
        RGB(0.9917572272719072, 0.8819804940183272, 0.8270251129082576),
        RGB(0.9918666707939122, 0.8832706213404304, 0.8296579770126207),
        RGB(0.9919494434347708, 0.8845699106664712, 0.8322846002898908),
        RGB(0.9920055467576402, 0.8858783093878068, 0.8349050817529102),
        RGB(0.9921801197679149, 0.8871577244070352, 0.8373913251147318),
        RGB(0.9923305326699136, 0.8884454725439429, 0.8398720321252351),
        RGB(0.992456801287177, 0.8897415034011227, 0.8423472939371239),
        RGB(0.9925589462851928, 0.8910457639343797, 0.8448172025615133),
        RGB(0.9926369932732303, 0.8923581984513291, 0.84728185084139),
        RGB(0.9926909729043117, 0.8936787486121948, 0.8497413324231746),
        RGB(0.9928733842813432, 0.8949673709204781, 0.8520687073051976),
        RGB(0.993034218389003, 0.8962633599534868, 0.8543914679027059),
        RGB(0.9931735170918802, 0.897566661121744, 0.856709699549858),
        RGB(0.9931353023315957, 0.8989181302901734, 0.8591499884305525),
        RGB(0.9933877008270392, 0.9001949696150879, 0.8613329206524968),
        RGB(0.9934626949157489, 0.9015198558910716, 0.8636380839972536),
        RGB(0.9935163718669321, 0.902851812223228, 0.8659390660985156),
        RGB(0.9937095060836477, 0.9041486703223474, 0.8681101190059957),
        RGB(0.9937219304049251, 0.905494279173443, 0.8704031613025478),
        RGB(0.9938762667989324, 0.9068040821979634, 0.8725667603616549),
        RGB(0.9940118829952141, 0.9081201205606573, 0.8747268317940803),
        RGB(0.9941288585350289, 0.9094423314781755, 0.8768834553067812),
        RGB(0.9942272780722071, 0.9107706501235393, 0.8790367109532542),
        RGB(0.9943072314183158, 0.9121050096457819, 0.8811866790922881),
        RGB(0.9943688135834728, 0.9134453411918497, 0.8833334403456233),
        RGB(0.9944121248125918, 0.9147915739307918, 0.8854770755545905),
        RGB(0.9946080650577388, 0.9160990731422108, 0.8874931246064166),
        RGB(0.9946162565547941, 0.91745663637537, 0.8896308778118438),
        RGB(0.9947794541441789, 0.9187748158106092, 0.8916414549209616),
        RGB(0.9949269695250772, 0.9200981083782028, 0.8936494683409784),
        RGB(0.9948838721435623, 0.9214720032203758, 0.8957790411549569),
        RGB(0.9949993231279323, 0.9228055588613981, 0.8977820269670345),
        RGB(0.995099445017127, 0.9241440181874225, 0.8997826663372901),
        RGB(0.9951843632941008, 0.9254873096669004, 0.9017810304801561),
        RGB(0.9952542082304706, 0.9268353602311143, 0.9037771904907562),
        RGB(0.9954892840906585, 0.9281413927918475, 0.9056477042018171),
        RGB(0.9955303990181718, 0.9294985208801994, 0.9076397666213242),
        RGB(0.9955568533935665, 0.9308601846969297, 0.9096298338807367),
        RGB(0.9957519210987075, 0.9321789652486259, 0.9114947485625072),
        RGB(0.9957504925524353, 0.933549261401112, 0.9134811244660304),
        RGB(0.9959199024251287, 0.9348761140334029, 0.9153426590404998),
        RGB(0.9958911957110462, 0.9362547359398993, 0.9173256092525522),
        RGB(0.9960355403513853, 0.9375893681018259, 0.9191840156028361),
        RGB(0.9961680400547922, 0.9389276835213428, 0.9210409899177255),
        RGB(0.9962888472089805, 0.9402696105091882, 0.9228965909353637),
        RGB(0.9963981179900391, 0.9416150764022875, 0.9247508769402565),
        RGB(0.996496012287161, 0.9429640076117972, 0.9266039057301596),
        RGB(0.9965826936210901, 0.9443163296727776, 0.9284557345839346),
        RGB(0.9966583290562504, 0.9456719672954509, 0.930306420230466),
        RGB(0.9967230891064965, 0.9470308444180086, 0.9321560188187087),
        RGB(0.9967771476344601, 0.9483928842609165, 0.9340045858889431),
        RGB(0.9968206817444661, 0.9497580093826791, 0.9358521763453064),
        RGB(0.9968538716689895, 0.9511261417370075, 0.9376988444296545),
        RGB(0.9970733289972938, 0.9524472621061978, 0.9394224461919497),
        RGB(0.997087196949379, 0.9538210369531975, 0.9412674758595254),
        RGB(0.9970912696387496, 0.9551975865961336, 0.943111739064695),
        RGB(0.9972845289896551, 0.9565264915075796, 0.944833221893348),
        RGB(0.9972703731194316, 0.9579082292370088, 0.9466761442725641),
        RGB(0.9974472936422688, 0.9592419217325935, 0.9483964599726206),
        RGB(0.9976166686237228, 0.9605778419866148, 0.9501162759865648),
        RGB(0.9975769516344853, 0.9619667396338162, 0.9519575561127628),
        RGB(0.9977310551905197, 0.9633070239859237, 0.9536764652887025),
        RGB(0.9976749938357491, 0.9647003548060614, 0.9555168644429634),
        RGB(0.9978145609910206, 0.9660447169196457, 0.9572350345932469),
        RGB(0.9979474700991923, 0.96739096281834, 0.9589529077273079),
        RGB(0.9980738981972198, 0.9687390256251377, 0.9606705212839245),
        RGB(0.9981940231532579, 0.9700888386229035, 0.9623879119800277),
        RGB(0.9981015651089221, 0.9714918091116075, 0.9642268792872256),
        RGB(0.9982089993227375, 0.9728450012525508, 0.9659439172221981),
        RGB(0.9983106777074661, 0.9741997406788679, 0.9676608401400778),
        RGB(0.9984067796621959, 0.9755559619610844, 0.969377681792929),
        RGB(0.9984974844947104, 0.9769136001377877, 0.9710944751950347),
        RGB(0.9985829712227395, 0.9782725907789033, 0.9728112526215703),
        RGB(0.9986634183696727, 0.9796328700497633, 0.974528045607587),
        RGB(0.9987390037544895, 0.9809943747760409, 0.9762448849471538),
        RGB(0.9988099042755932, 0.982357042509641, 0.9779618006924934),
        RGB(0.998876295688148, 0.9837208115956672, 0.9796788221529281),
        RGB(0.9989383523744012, 0.9850856212406253, 0.981395977893435),
        RGB(0.9989962471063641, 0.9864514115820481, 0.983113295732596),
        RGB(0.9992633719189333, 0.9877659880402755, 0.9847090826272643),
        RGB(0.9993139396526537, 0.9891335382217893, 0.9864267955269616),
        RGB(0.999361057478564, 0.9905018315526272, 0.9881447776807158),
        RGB(0.9994049267214625, 0.991870801168416, 0.9898630587378755),
        RGB(0.9994455360161131, 0.9932404473859239, 0.9915816387305635),
        RGB(0.9994828739263738, 0.9946107705235728, 0.9933005176968083),
        RGB(0.9997330759128481, 0.9959294589058242, 0.9948979245618655),
        RGB(0.9997643387194343, 0.9973011088081595, 0.9966173927642735),
        RGB(0.9997922970878687, 0.9986734365937217, 0.9983371600678866),
        RGB(1.0, 1.0, 1.0),

],
"kindlmann",
"luminance matching, perceptual, rainbow, G. Kindlmann; E. Reinhard; S. Creem")
