# Internal API Reference

This is an exhaustive list of all non-exported modules, constants, types, functions
and macros in `DomainSets.jl`.

!!! warning
    Unexported functions and types are subject to change across different
    releases of the package, even if the release is said to be non-breaking.
    This overview is useful to better understand or to help develop the
    internals of DomainSets.

## Constants

```@autodocs
Modules = [DomainSets]
Order   = [:constant]
Public  = false
Private = true
```

## Functions

```@autodocs
Modules = [DomainSets]
Order   = [:function]
Public  = false
Private = true
```

## Types

```@autodocs
Modules = [DomainSets]
Order   = [:type]
Public  = false
Private = true
```
