# FunctionMaps.jl

## What is FunctionMaps.jl

`FunctionMaps` is a submodule of `DomainSets` as of version `0.7.10`. The
module collects all functionality in the package that relates to functions in
the sense of a map between spaces. It defines properties such as the `jacobian`
etcetera.

The module is expected to be moved into a separate package in the future and will
be independently documented.


## Public API Reference

### Constants

```@autodocs
Modules = [FunctionMaps]
Order   = [:constant]
Public  = true
Private = false
```

### Functions

```@autodocs
Modules = [FunctionMaps]
Order   = [:function]
Public  = true
Private = false
```

### Types

```@autodocs
Modules = [FunctionMaps]
Order   = [:type]
Public  = true
Private = false
```


## Internal API Reference

This is an exhaustive list of all non-exported constants, types and functions
in `FunctionMaps.jl`.

!!! warning
    Unexported functions and types are subject to change across different
    releases of the package, even if the release is said to be non-breaking.

### Constants

```@autodocs
Modules = [FunctionMaps]
Order   = [:constant]
Public  = false
Private = true
```

### Functions

```@autodocs
Modules = [FunctionMaps]
Order   = [:function]
Public  = false
Private = true
```

### Types

```@autodocs
Modules = [FunctionMaps]
Order   = [:type]
Public  = false
Private = true
```
