```@meta
CurrentModule = MathOptInterface
DocTestSetup = quote
    import MathOptInterface as MOI
end
DocTestFilters = [r"MathOptInterface|MOI"]
```

# Naming conventions

MOI follows several conventions for naming functions and structures. These
should also be followed by packages extending MOI.

## Sets

Sets encode the structure of constraints. Their names should follow the
following conventions:

* Abstract types in the set hierarchy should begin with `Abstract` and end in
  `Set`, for example, [`AbstractScalarSet`](@ref), [`AbstractVectorSet`](@ref).
* Vector-valued conic sets should end with `Cone`, for example,
  [`NormInfinityCone`](@ref), [`SecondOrderCone`](@ref).
* Vector-valued Cartesian products should be plural and not end in `Cone`,
  for example, [`Nonnegatives`](@ref), not `NonnegativeCone`.
* Matrix-valued conic sets should provide two representations: `ConeSquare` and
  `ConeTriangle`, for example, [`RootDetConeTriangle`](@ref) and
  [`RootDetConeSquare`](@ref). See [Matrix cones](@ref) for more details.
* Scalar sets should be singular, not plural, for example, [`Integer`](@ref),
  not `Integers`.
* As much as possible, the names should follow established conventions in the
  domain where this set is used: for instance, convex sets should have names
  close to those of [CVX](https://web.cvxr.com/cvx/doc/), and
  constraint-programming sets should follow
  [MiniZinc](https://www.minizinc.org/doc-latest/en/)'s constraints.
