struct TanYam7ConstantCache{T, T2} <: OrdinaryDiffEqConstantCache
    c1::T2
    c2::T2
    c3::T2
    c4::T2
    c5::T2
    c6::T2
    c7::T2
    a21::T
    a31::T
    a32::T
    a41::T
    a43::T
    a51::T
    a53::T
    a54::T
    a61::T
    a63::T
    a64::T
    a65::T
    a71::T
    a73::T
    a74::T
    a75::T
    a76::T
    a81::T
    a83::T
    a84::T
    a85::T
    a86::T
    a87::T
    a91::T
    a93::T
    a94::T
    a95::T
    a96::T
    a97::T
    a98::T
    a101::T
    a103::T
    a104::T
    a105::T
    a106::T
    a107::T
    a108::T
    b1::T
    b4::T
    b5::T
    b6::T
    b7::T
    b8::T
    b9::T
    btilde1::T
    btilde4::T
    btilde5::T
    btilde6::T
    btilde7::T
    btilde8::T
    btilde9::T
    btilde10::T
end

"""
On the Optimization of Some Nine-Stage Seventh-order Runge-Kutta Method, by M. Tanaka, S. Muramatsu and S. Yamashita,
Information Processing Society of Japan, Vol. 33, No. 12 (1992) pages 1512-1526.
"""
function TanYam7ConstantCache(T::Type{<:CompiledFloats}, T2::Type{<:CompiledFloats})
    c1 = convert(T2, 0.07816646510113846)
    c2 = convert(T2, 0.1172496976517077)
    c3 = convert(T2, 0.17587454647756157)
    c4 = convert(T2, 0.4987401101913988)
    c5 = convert(T2, 0.772121690184484)
    c6 = convert(T2, 0.9911856696047768)
    c7 = convert(T2, 0.9995019582097662)
    a21 = convert(T, 0.07816646510113846)
    a31 = convert(T, 0.029312424412926925)
    a32 = convert(T, 0.08793727323878078)
    a41 = convert(T, 0.04396863661939039)
    a43 = convert(T, 0.13190590985817116)
    a51 = convert(T, 0.7361834837738382)
    a53 = convert(T, -2.8337999624233303)
    a54 = convert(T, 2.5963565888408913)
    a61 = convert(T, -12.062819391370866)
    a63 = convert(T, 48.20838100175243)
    a64 = convert(T, -38.05863046463434)
    a65 = convert(T, 2.6851905444372632)
    a71 = convert(T, 105.21957276320198)
    a73 = convert(T, -417.92888626241256)
    a74 = convert(T, 332.3155504499333)
    a75 = convert(T, -19.827591183572938)
    a76 = convert(T, 1.2125399024549859)
    a81 = convert(T, 114.67755718631742)
    a83 = convert(T, -455.5612169896097)
    a84 = convert(T, 362.24095553923144)
    a85 = convert(T, -21.67190442182809)
    a86 = convert(T, 1.3189132007137807)
    a87 = convert(T, -0.0048025566150346555)
    a91 = convert(T, 115.21334870553768)
    a93 = convert(T, -457.69356568613233)
    a94 = convert(T, 363.93688218862735)
    a95 = convert(T, -21.776682078900294)
    a96 = convert(T, 1.3250670887878468)
    a97 = convert(T, -0.004518190986768983)
    a98 = convert(T, -0.0005320269334859959)
    a101 = convert(T, 115.18928245800194)
    a103 = convert(T, -457.598022271643)
    a104 = convert(T, 363.8610256312148)
    a105 = convert(T, -21.77212754027556)
    a106 = convert(T, 1.3248804645074317)
    a107 = convert(T, -0.0045057252106918315)
    a108 = convert(T, -0.0005330165949429136)
    b1 = convert(T, 0.05126014249744686)
    b4 = convert(T, 0.27521638456212627)
    b5 = convert(T, 0.33696650340710543)
    b6 = convert(T, 0.18986072244906577)
    b7 = convert(T, 8.461099418514403)
    b8 = convert(T, -130.15941672640542)
    b9 = convert(T, 121.84501355497527)
    # bhat1 =convert(T,0.051002417590377186)
    # bhat4 =convert(T,0.27613929504666546)
    # bhat5 =convert(T,0.333788602069686)
    # bhat6 =convert(T,0.20196531139081392)
    # bhat7 =convert(T,5.755075459041811)
    # bhat8 =convert(T,-85.61797108513936)
    # bhat10=convert(T,80)
    btilde1 = convert(T, -0.0002577249070696835)
    btilde4 = convert(T, 0.0009229104845391819)
    btilde5 = convert(T, -0.0031779013374194105)
    btilde6 = convert(T, 0.01210458894174817)
    btilde7 = convert(T, -2.706023959472591)
    btilde8 = convert(T, 44.541445641266066)
    btilde9 = convert(T, -121.84501355497527)
    btilde10 = convert(T, 80)

    TanYam7ConstantCache(
        c1, c2, c3, c4, c5, c6, c7, a21, a31, a32, a41, a43, a51, a53, a54,
        a61, a63, a64, a65, a71, a73, a74, a75, a76, a81, a83, a84, a85,
        a86, a87, a91, a93, a94, a95, a96, a97, a98, a101, a103, a104,
        a105, a106, a107, a108, b1, b4, b5, b6, b7, b8, b9, btilde1,
        btilde4, btilde5, btilde6, btilde7, btilde8, btilde9, btilde10)
end

"""
On the Optimization of Some Nine-Stage Seventh-order Runge-Kutta Method, by M. Tanaka, S. Muramatsu and S. Yamashita,
Information Processing Society of Japan, Vol. 33, No. 12 (1992) pages 1512-1526.
"""
function TanYam7ConstantCache(T::Type, T2::Type)
    c1 = convert(T2, 36259 // 463869)
    c2 = convert(T2, 36259 // 309246)
    c3 = convert(T2, 36259 // 206164)
    c4 = convert(T2, 76401 // 153188)
    c5 = convert(T2, 5164663400901569152 // 6688924124988083687)
    c6 = convert(T2, 3486 // 3517)
    c7 = convert(T2, 44151 // 44173)
    a21 = convert(T, 36259 // 463869)
    a31 = convert(T, 36259 // 1236984)
    a32 = convert(T, 36259 // 412328)
    a41 = convert(T, 36259 // 824656)
    a43 = convert(T, 108777 // 824656)
    a51 = convert(T, 17751533712975975593187 // 24112920357813127230992)
    a53 = convert(T, -68331192803887602162951 // 24112920357813127230992)
    a54 = convert(T, 7825717455900471140481 // 3014115044726640903874)
    a61 = convert(T,
        -BigInt(2425518501234340256175806929031336393991001205323654593685210322030691047097621496102266496) //
        BigInt(201073929944556265242953373967503382318096046559546854970564286270157897072030532387737241))
    a63 = convert(T,
        BigInt(126875939114499086848675646731069753055308007638565564293214808307459627250976287910912) //
        BigInt(2631823273838775215546306644775636213113650954300949659959480717139276934490785884841))
    a64 = convert(T,
        -BigInt(18238165682427587123600563411903599919711680222699338744428834349094610403849667513626245575680) //
        BigInt(479212348415302218688412787744011607018072627155280851781784515530195350673833210517995172867))
    a65 = convert(T,
        BigInt(74777425357290689294313120787550134201356775453356604582280658347816977407509825814840320) //
        BigInt(27848089034948481594251542168496834020714916243735255636715495143105044359669539013058107))
    a71 = convert(T,
        BigInt(42210784012026021620512889337138957588173072058924928398799062235) //
        BigInt(401168555464694196502745570125544252560955194769351196028554688))
    a73 = convert(T,
        -BigInt(53537582181289418572806048482253962781541488) //
        BigInt(128102133978061070595749084326726258918069))
    a74 = convert(T,
        BigInt(6373437319382536771018620806214785516542915567996760353063349991182871200304) //
        BigInt(19178871740288180724887392022898914045213833131528843480576173243533301485))
    a75 = convert(T,
        -BigInt(836513109281956728811652083904588515347012294160401579661057793958992) //
        BigInt(42189346226535262916910956145917457264775063492307360825161811325023))
    a76 = convert(T,
        BigInt(10038768138260655813133796321688310283082351149893792474426644227234755871856831386997923013888351) //
        BigInt(8279123943002224665888560854425725483235895533066047643118716510648226939201056966728652698557760))
    a81 = convert(T,
        BigInt(1454976871505621321312348899226731229297985195430097820532172928754404221419640982320963761) //
        BigInt(12687546780768188413911065021432924447284583965992535848754097389537051103097048673168256))
    a83 = convert(T,
        -BigInt(1452249436938195913836212549773886207822959770792) //
        BigInt(3187825000852340545619892931005470986913487349))
    a84 = convert(T,
        BigInt(3193785703967379485471835519262043520640585789136428552340853315619929163223926155626278646291801931779256) //
        BigInt(8816743814108800069900425523882492176796603795861854625575345408990649746129323017714575203134405597571))
    a85 = convert(T,
        -BigInt(314398569508916946629277462588835135011587938712337655816458752800894863689255534896547161759213480) //
        BigInt(14507196201560052990013371105817112064769849230048646555812475120383456376679192045076337148816813))
    a86 = convert(T,
        BigInt(5021633516852870452803558794670341128133410978274753232000155240629688617274518068065484524425884625107263111090060721584249881611265924113) //
        BigInt(3807402575192378287101053794016079417728266285278436439472658972755893033722804748992796724254152818232996309281540415603729279478920107136))
    a87 = convert(T,
        -BigInt(894451839895008223904010765658125850176064186717638397881061173697811879745) //
        BigInt(186244934020117483847289332768639722211239803963523669807238114327710091115676))
    a91 = convert(T,
        BigInt(152015786770038627019906826956584678402371493198250158080970494807155603994339) //
        BigInt(1319428594672311986480108760138089275639618425553698631283119461253421932416))
    a93 = convert(T,
        -BigInt(19887569115365707672105043997835466942389220328) //
        BigInt(43451712251082409470704235239058276887205131))
    a94 = convert(T,
        BigInt(6298831527954572673520838478029639446424615570453903300371170696118960335541193275024146681623960) //
        BigInt(17307483347318198085207889427954666589398911583434527253470846782562794571553580157056644256313))
    a95 = convert(T,
        -BigInt(16267621644623777942279856217571823792451732234540266142050307930357537283432611648312520) //
        BigInt(747020211145282116967827947968990352912884924402891384654470989583659988117513448655559))
    a96 = convert(T,
        BigInt(491920517345271821393960134665582163547632868347911487496995665146055538579545277983570189994492481977206720065882583432234119698425636137169515) //
        BigInt(371241970695441505578374965290296000309261530083026613438333515399198575394818137422626328203755084156959422247928840402063855870066548878130304))
    a97 = convert(T,
        -BigInt(17535891839112183607157943692398769696531153719141528498448224128785868799210475) //
        BigInt(3881175428498724209649715816699297677268154716152409333146177577349474565697791732))
    a98 = convert(T,
        -BigInt(31140449219386755112730831706895080247696102690585728771850210691242594436100540310) //
        BigInt(58531715707220748822628340615174217489020037018063169180406742622693159384762890406389))
    a101 = convert(T,
        BigInt(24861126512935523838485032295435745281790804119672244200744512677831357181363) //
        BigInt(215828469302253893975010055544246846578750854407392771457340001283636121600))
    a103 = convert(T, -76626859319946149305867456329803 // 167454524692981091214376557800)
    a104 = convert(T,
        BigInt(257532657386915224604779230484778835596042580268896440943054087972106955277512448850995064336363) //
        BigInt(707777528357579864776572552477247532276956780876653359042572831013312547307465249178438602200))
    a105 = convert(T,
        -BigInt(103092665221253777021612043042409780416654274677686197534469014507504059634284484983141143) //
        BigInt(4735075386204034224907103653335170134874540866215348781137359896717512695961598377363000))
    a106 = convert(T,
        BigInt(1318945254307068672853031172410281620677291556423152759282406612372948205789241763483098989903852936890735513699395545618802215742952753372919) //
        BigInt(995520191927224509158660659519643916330847017611189618002256023928790665495276022949114110343406997764203331763292012060684160018593393766400))
    a107 = convert(T,
        -BigInt(2175691361381933486174620849991740173349017185199505364607841) //
        BigInt(482872625303278742130341621563226511344221688759361797916327450))
    a108 = convert(T,
        -BigInt(11327601987184122343710458559595782081610122892585097) //
        BigInt(21251874884678431935286330856983429378055579208005268000))
    b1 = convert(T,
        BigInt(677260699094873524061210073954310211) //
        BigInt(13212228177645157882237395248920447488))
    b4 = convert(T,
        BigInt(5627843976805934592544586970647029617399366281651959837492864) //
        BigInt(20448796992082885248862284273169726631726393791864145954479875))
    b5 = convert(T,
        BigInt(1359735671458057021603668186882234273947181034928034734244224) //
        BigInt(4035225037829041960922838374222759264846456609494840689395475))
    b6 = convert(T,
        BigInt(3575764371063841994042920363615768888383369782579963896064642431626191680598750790399139608006651160426580137040859330533720256407) //
        BigInt(18833618269956378326078572170759846509476617594300797062242096554507068838086062412372695473217373611870290738365243380652826304000))
    b7 = convert(T,
        BigInt(14322850798205614664394883796805489119964080948503151) //
        BigInt(1692788382425178679633337406927131793062126418747780))
    b8 = convert(T,
        -BigInt(16735096417960349589058935251250023138290806176584545269411) //
        BigInt(128573843052304513208482301684749747737236254208431871400))
    b9 = convert(T,
        33050288141543277444692395096256051 // 271248590133163812341791503489000)
    # bhat1 =convert(T,BigInt(962650826879437817605721930727384851)//BigInt(18874611682350225546053421784172067840))
    # bhat4 =convert(T,BigInt(99703652969826806275610089806158069716600653757297413344)//BigInt(361062893830367886445877712954352019629670588714825566425))
    # bhat5 =convert(T,BigInt(17540887447270394964911517553576959050951784592644178144)//BigInt(52550888012671962193116521992300249584518949945887203425))
    # bhat6 =convert(T,BigInt(101855668513773837712956593596043266148479443244790887636953159551191054134940671472736229702711787350735239179)//BigInt(504322587935299170723833764883183242017770187561624249681119708768991642691172146267201689787026963930014131200))
    # bhat7 =convert(T,BigInt(179578338747395946570172802104016572846366090083599)//BigInt(31203472487100067827342625012481692038011546889360))
    # bhat8 =convert(T,-BigInt(500374162579884236288722085953024481890963958534161489781)//BigInt(5844265593286568782203740985670443078965284282201448700))
    # bhat10=convert(T,80)
    btilde1 = convert(T,
        BigInt(-11350400930890172457349074817136051) //
        BigInt(44040760592150526274124650829734824960))
    btilde4 = convert(T,
        BigInt(18872409140206580874590465524732661000311743892579167244576) //
        BigInt(20448796992082885248862284273169726631726393791864145954479875))
    btilde5 = convert(T,
        BigInt(-4274515681501734477669162831906773100582117137555409033632) //
        BigInt(1345075012609680653640946124740919754948818869831613563131825))
    btilde6 = convert(T,
        BigInt(151982138295746861476872192192436808638630079892291260212523545728864842939698890632387350810275352451114165347163409431707619557) //
        BigInt(12555745513304252217385714780506564339651078396200531374828064369671379225390708274915130315478249074580193825576828920435217536000))
    btilde7 = convert(T,
        BigInt(-6107634561545846083950679043550120057398294081957207) //
        BigInt(2257051176566904906177783209236175724082835224997040))
    btilde8 = convert(T,
        BigInt(1908954947067632130235683120094494845563199696277664164743) //
        BigInt(42857947684101504402827433894916582579078751402810623800))
    btilde9 = convert(T,
        -33050288141543277444692395096256051 //
        271248590133163812341791503489000)
    btilde10 = convert(T, 80)

    TanYam7ConstantCache(
        c1, c2, c3, c4, c5, c6, c7, a21, a31, a32, a41, a43, a51, a53, a54,
        a61, a63, a64, a65, a71, a73, a74, a75, a76, a81, a83, a84, a85,
        a86, a87, a91, a93, a94, a95, a96, a97, a98, a101, a103, a104,
        a105, a106, a107, a108, b1, b4, b5, b6, b7, b8, b9, btilde1,
        btilde4, btilde5, btilde6, btilde7, btilde8, btilde9, btilde10)
end

struct TsitPap8ConstantCache{T, T2} <: OrdinaryDiffEqConstantCache
    c1::T2
    c2::T2
    c3::T2
    c4::T2
    c5::T2
    c6::T2
    c7::T2
    c8::T2
    c9::T2
    c10::T2
    a0201::T
    a0301::T
    a0302::T
    a0401::T
    a0403::T
    a0501::T
    a0503::T
    a0504::T
    a0601::T
    a0604::T
    a0605::T
    a0701::T
    a0704::T
    a0705::T
    a0706::T
    a0801::T
    a0804::T
    a0805::T
    a0806::T
    a0807::T
    a0901::T
    a0904::T
    a0905::T
    a0906::T
    a0907::T
    a0908::T
    a1001::T
    a1004::T
    a1005::T
    a1006::T
    a1007::T
    a1008::T
    a1009::T
    a1101::T
    a1104::T
    a1105::T
    a1106::T
    a1107::T
    a1108::T
    a1109::T
    a1110::T
    a1201::T
    a1204::T
    a1205::T
    a1206::T
    a1207::T
    a1208::T
    a1209::T
    a1210::T
    a1211::T
    a1301::T
    a1304::T
    a1305::T
    a1306::T
    a1307::T
    a1308::T
    a1309::T
    a1310::T
    b1::T
    b6::T
    b7::T
    b8::T
    b9::T
    b10::T
    b11::T
    b12::T
    btilde1::T
    btilde6::T
    btilde7::T
    btilde8::T
    btilde9::T
    btilde10::T
    btilde11::T
    btilde12::T
    btilde13::T
end

"""
Cheap Error Estimation for Runge-Kutta methods, by Ch. Tsitouras and S.N. Papakostas,
Siam Journal on Scientific Computing, Vol. 20, Issue 6, Nov 1999.
"""
function TsitPap8ConstantCache(T::Type{<:CompiledFloats}, T2::Type{<:CompiledFloats})
    c1 = convert(T2, 0.06338028169014084)
    c2 = convert(T2, 0.1027879458763643)
    c3 = convert(T2, 0.15418191881454646)
    c4 = convert(T2, 0.3875968992248062)
    c5 = convert(T2, 0.4657534246575342)
    c6 = convert(T2, 0.1554054054054054)
    c7 = convert(T2, 1.0070921985815602)
    c8 = convert(T2, 0.876141078561489)
    c9 = convert(T2, 0.9120879120879121)
    c10 = convert(T2, 0.959731543624161)
    a0201 = convert(T, 0.06338028169014084)
    a0301 = convert(T, 0.019438980427336498)
    a0302 = convert(T, 0.08334896544902781)
    a0401 = convert(T, 0.038545479703636615)
    a0403 = convert(T, 0.11563643911090984)
    a0501 = convert(T, 0.39436557770112496)
    a0503 = convert(T, -1.4818719321673373)
    a0504 = convert(T, 1.4751032536910185)
    a0601 = convert(T, 0.045994489107698204)
    a0604 = convert(T, 0.23235070626395474)
    a0605 = convert(T, 0.18740822928588133)
    a0701 = convert(T, 0.06005228953244051)
    a0704 = convert(T, 0.11220383194636775)
    a0705 = convert(T, -0.03357232951906142)
    a0706 = convert(T, 0.016721613445658576)
    a0801 = convert(T, -1.5733292732086857)
    a0804 = convert(T, -1.3167087730223663)
    a0805 = convert(T, -11.723515296181773)
    a0806 = convert(T, 9.107825028173872)
    a0807 = convert(T, 6.512820512820513)
    a0901 = convert(T, -0.48107625624391254)
    a0904 = convert(T, -6.6506103607463904)
    a0905 = convert(T, -4.530206099782572)
    a0906 = convert(T, 3.894414525020157)
    a0907 = convert(T, 8.634217645525526)
    a0908 = convert(T, 0.009401624788681498)
    a1001 = convert(T, -0.7754121446230569)
    a1004 = convert(T, -7.996604718235832)
    a1005 = convert(T, -6.726558607230182)
    a1006 = convert(T, 5.532184454327406)
    a1007 = convert(T, 10.89757332024991)
    a1008 = convert(T, 0.020091650280045396)
    a1009 = convert(T, -0.039186042680376856)
    a1101 = convert(T, -1.1896363245449992)
    a1104 = convert(T, -7.128368483301214)
    a1105 = convert(T, -9.53722789710108)
    a1106 = convert(T, 7.574470108980868)
    a1107 = convert(T, 11.267486382070919)
    a1108 = convert(T, 0.051009801223058315)
    a1109 = convert(T, 0.08019413469508256)
    a1110 = convert(T, -0.15819617839847347)
    a1201 = convert(T, -0.39200039047127266)
    a1204 = convert(T, 3.916659042493856)
    a1205 = convert(T, -2.8017459289080557)
    a1206 = convert(T, 2.441204566481742)
    a1207 = convert(T, -2.4183655778824718)
    a1208 = convert(T, -0.33943326290032927)
    a1209 = convert(T, 0.19496450383103364)
    a1210 = convert(T, -0.19437176762508154)
    a1211 = convert(T, 0.5930888149805791)
    a1301 = convert(T, -1.4847063081291894)
    a1304 = convert(T, -2.390723588981498)
    a1305 = convert(T, -11.184306772840532)
    a1306 = convert(T, 8.720804667459817)
    a1307 = convert(T, 7.33673830753461)
    a1308 = convert(T, 0.01289874999394761)
    a1309 = convert(T, 0.042583289842657704)
    a1310 = convert(T, -0.05328834487981156)
    b1 = convert(T, 0.04441161093250152)
    b6 = convert(T, 0.35395063113733116)
    b7 = convert(T, 0.2485219684184965)
    b8 = convert(T, -0.3326913171720666)
    b9 = convert(T, 1.921248828652836)
    b10 = convert(T, -2.7317783000882523)
    b11 = convert(T, 1.4012004409899175)
    b12 = convert(T, 0.0951361371292365)
    # bhat1 =convert(T,0.044484201850329544)
    # bhat6 =convert(T,0.35502352274458154)
    # bhat7 =convert(T,0.24825530158391707)
    # bhat8 =convert(T,-2.4242252962684616)
    # bhat9 =convert(T,1.5999301534099692)
    # bhat10=convert(T,-1.8107646286929684)
    # bhat13=convert(T,2.9872967453726327)
    btilde1 = convert(T, -7.259091782802626e-5)
    btilde6 = convert(T, -0.0010728916072503584)
    btilde7 = convert(T, 0.0002666668345794398)
    btilde8 = convert(T, 2.091533979096395)
    btilde9 = convert(T, 0.3213186752428666)
    btilde10 = convert(T, -0.921013671395284)
    btilde11 = convert(T, 1.4012004409899175)
    btilde12 = convert(T, 0.0951361371292365)
    btilde13 = convert(T, -2.9872967453726327)

    TsitPap8ConstantCache(c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, a0201, a0301, a0302,
        a0401, a0403, a0501, a0503, a0504, a0601, a0604, a0605, a0701,
        a0704, a0705, a0706, a0801, a0804, a0805, a0806, a0807, a0901,
        a0904, a0905, a0906, a0907, a0908, a1001, a1004, a1005, a1006,
        a1007, a1008, a1009, a1101, a1104, a1105, a1106, a1107, a1108,
        a1109, a1110, a1201, a1204, a1205, a1206, a1207, a1208, a1209,
        a1210, a1211, a1301, a1304, a1305, a1306, a1307, a1308, a1309,
        a1310, b1, b6, b7, b8, b9, b10, b11, b12, btilde1, btilde6,
        btilde7, btilde8, btilde9, btilde10, btilde11, btilde12, btilde13)
end

"""
Cheap Error Estimation for Runge-Kutta methods, by Ch. Tsitouras and S.N. Papakostas,
Siam Journal on Scientific Computing, Vol. 20, Issue 6, Nov 1999.
"""
function TsitPap8ConstantCache(T::Type, T2::Type)
    c1 = convert(T2, 9 // 142)
    c2 = convert(T2, 24514 // 238491)
    c3 = convert(T2, 12257 // 79497)
    c4 = convert(T2, 50 // 129)
    c5 = convert(T2, 34 // 73)
    c6 = convert(T2, 23 // 148)
    c7 = convert(T2, 142 // 141)
    c8 = convert(T2, 29104120198 // 33218531707)
    c9 = convert(T2, 83 // 91)
    c10 = convert(T2, 143 // 149)
    a0201 = convert(T, 9 // 142)
    a0301 = convert(T, 9950845450 // 511901613729)
    a0302 = convert(T, 42666469916 // 511901613729)
    a0401 = convert(T, 12257 // 317988)
    a0403 = convert(T, 12257 // 105996)
    a0501 = convert(T, 14131686489425 // 35833975601529)
    a0503 = convert(T, -17700454220625 // 11944658533843)
    a0504 = convert(T, 17619604667500 // 11944658533843)
    a0601 = convert(T, 4418011 // 96055225)
    a0604 = convert(T, 9757757988 // 41995818067)
    a0605 = convert(T, 19921512441 // 106300094275)
    a0701 = convert(T, 480285555889619 // 7997789253816320)
    a0704 = convert(T, 52162106556696460538643 // 464887033284472899365888)
    a0705 = convert(T, -16450769949384489 // 490009784398315520)
    a0706 = convert(T, 864813381633887 // 51718297665732608)
    a0801 = convert(T, -7001048352088587137143 // 4449830351030385148800)
    a0804 = convert(T, -2522765548294599044197935933 // 1915963195493758447677901792)
    a0805 = convert(T, -318556182235222634647116091 // 27172411532484037214054400)
    a0806 = convert(T, 1205563885850790193966807 // 132365727505912221222912)
    a0807 = convert(T, 254 // 39)
    a0901 = convert(T,
        -BigInt(20629396399716689122801179264428539394462855874226604463554767070845753369) //
        BigInt(42881759662770155956657513470012114488076017981128105307375594963152353200))
    a0904 = convert(T,
        -BigInt(3315443074343659404779422149387397712986453181141168247590906370819301077749322753) //
        BigInt(498517112641608872807821838566847987729514312398278633788185835348997643218553476))
    a0905 = convert(T,
        -BigInt(273749409411654060286948141164828452109898379203526945684314474186724062841643) //
        BigInt(60427583951377552503967840653825589117167443021628367691773162913607984889600))
    a0906 = convert(T,
        BigInt(16656372518874512738268060504309924900437672263609245028809229865738327731797537) //
        BigInt(4276990138533930522782076385771016009097627930550149628282203007913538394549504))
    a0907 = convert(T,
        BigInt(42008080033354305590804322944084805264441066760038302359736803632) //
        BigInt(4865302423216534910074823287811605599629170295030631799935804001))
    a0908 = convert(T,
        BigInt(668459780930716338000066627236927417191947396177093524377824) //
        BigInt(71100452948884643779799087713322002499799983434685642170251833))
    a1001 = convert(T,
        -BigInt(1793603946322260900828212460706877142477132870159527) //
        BigInt(2313097568511990753781649719556084665131024900300800))
    a1004 = convert(T,
        -BigInt(14776874123722838192315406145167687512425345723701) //
        BigInt(1847893530366076701102014146927696206329050105856))
    a1005 = convert(T,
        -BigInt(19587020919884661714856757105130246995757906603) //
        BigInt(2911893296942532038566182868170393629789388800))
    a1006 = convert(T,
        BigInt(6364380863259071677112259236455506477417699780613300364807) //
        BigInt(1150428174584942133406579091549443438814988349188394057728))
    a1007 = convert(T,
        BigInt(27725164402569748756040320433848245155581006369) //
        BigInt(2544159473655547770881695354241256106302348256))
    a1008 = convert(T,
        BigInt(10744247163960019876833255044784609639) //
        BigInt(534761804739901348825491947768304503296))
    a1009 = convert(T,
        -BigInt(50977737930792808232204417497248979399878217280011103197862899) //
        BigInt(1300915694564913675613280314081837358644964393191337994183389184))
    a1101 = convert(T,
        -BigInt(3587625717068952487214493441966897048737050755812600710793) //
        BigInt(3015733164033229624772006086429467685046639983706974412800))
    a1104 = convert(T,
        -BigInt(5453011711267804731211501837262816944661201619903) //
        BigInt(764973320899716397072448644710733101329290196992))
    a1105 = convert(T,
        -BigInt(884348836774584715070440485633026464653487653) //
        BigInt(92725983515963799584249219499787659014963200))
    a1106 = convert(T,
        BigInt(26823469063654084387375587616552322383082061411417182757389742951) //
        BigInt(3541299744763681675473620647087123057228744296123642301654630400))
    a1107 = convert(T,
        BigInt(142363419491686507162007051071007722765323162710521029) //
        BigInt(12634887202368261565807449771335728082273587905775840))
    a1108 = convert(T,
        BigInt(64747617454909275289531520412519442831235890581) //
        BigInt(1269317188117975960996670628974453443777854830080))
    a1109 = convert(T,
        BigInt(112633808253272720979874303367503891597499261046700689572459050065039333987335667) //
        BigInt(1404514291245034532812181377119034501014039830518218465064579291611563374608650240))
    a1110 = convert(T,
        -BigInt(10612202518573994431153697720606405883) //
        BigInt(67082546658259846778754594976831647575))
    a1201 = convert(T,
        -BigInt(7534081165544982478296202335922049210803875045423) //
        BigInt(19219575665440848756074598051658416387002479820800))
    a1204 = convert(T,
        BigInt(237696087452786717802270375283034262859273455) //
        BigInt(60688480889936839261131818793519097177034752))
    a1205 = convert(T,
        -BigInt(20610578209826329263318986584876108069323) //
        BigInt(7356333776438834884293014575840932659200))
    a1206 = convert(T,
        BigInt(51260471529841028040709654458903254781320136131844164563) //
        BigInt(20998023776318546907382302106788168158765514131585630208))
    a1207 = convert(T,
        -BigInt(3077214437173472971196810795615384000211457151011) //
        BigInt(1272435592582280820597059432060116893200684680384))
    a1208 = convert(T,
        -BigInt(1539218116260541896259682954580256454049) //
        BigInt(4534670830750360983422999946409310393344))
    a1209 = convert(T,
        BigInt(241886539350268429372116296787271276553970618941104594460614948326132797451456131) //
        BigInt(1240669632662465892528916120041123051054026283188324780101555345343662316090597376))
    a1210 = convert(T,
        -80556486832245966191717452425924975 //
        414445409518676597565032008051106461)
    a1211 = convert(T,
        BigInt(2944781680874500347594142792814463350) //
        BigInt(4965161383073676983610218096030654529))
    a1301 = convert(T,
        -BigInt(7757739937862944832927743694336116203639371542761) //
        BigInt(5225100678421794325654850845451340473577260032000))
    a1304 = convert(T,
        -BigInt(433889546009521405913741133329446636837810749) //
        BigInt(181488796115643001621310691169322233346938880))
    a1305 = convert(T,
        -BigInt(246044720162308748108107126829066792329071) //
        BigInt(21999103311417807170100413255475150848000))
    a1306 = convert(T,
        BigInt(2140331235425829844389060818616719848637810765257179167) //
        BigInt(245428182036011897638028252815369258646052549878743040))
    a1307 = convert(T,
        BigInt(1573990926219809229258666534611598771063240529) //
        BigInt(214535514317495538101650508596881057760818080))
    a1308 = convert(T,
        BigInt(62408280667309375445301959066100433563) //
        BigInt(4838320046251983849512355559327451645440))
    a1309 = convert(T,
        BigInt(1145609822249493677618113725359506642998153205603226883141207089968379) //
        BigInt(26902802166822768476367427840835743139559294105398677975568538466119680))
    a1310 = convert(T,
        -408950356875874683139089678053832 //
        7674292714443204070455739595109785)
    b1 = convert(T, 55038446513529253801 // 1239280570055853383520)
    b6 = convert(T, 2335496795323782464411846394611 // 6598368783294020109895379936256)
    b7 = convert(T, 7636073376527143565375240869888 // 30725949199261296642046754748645)
    b8 = convert(T, -4237087214169934312729607487 // 12735791394214625116604076160)
    b9 = convert(T,
        BigInt(408505291291133241760995514121984335914363927884426780078325258228227984174126699) //
        BigInt(212624874612193697466655159405635202123821166475348052734199905546455860773575680))
    b10 = convert(T, -1108225296327029096435947 // 405679075893979729103310)
    b11 = convert(T, 2460988291206213825688467985 // 1756342789520947764222671739)
    b12 = convert(T, 4808707937311 // 50545545388065)
    # bhat1 =convert(T,715953338020208413//16094552857868225760)
    # bhat6 =convert(T,62284335162928966987066121//175437206755843240272669696)
    # bhat7 =convert(T,184309146777472302831695872//742417767522160213324368465)
    # bhat8 =convert(T,-509771598215811385123057257//210282269969085698264101760)
    # bhat9 =convert(T,BigInt(2701602489646143640362891402924962500766379885231830470264478480621389)//BigInt(1688575269294196295712420798364925687791337062814161130291144634516480))
    # bhat10=convert(T,-7218534073012286740367561//3986456306153224954098780)
    # bhat13=convert(T,5752173075461//1925544586212)
    btilde1 = convert(T, -1124506425334925 // 15491007125698167294)
    btilde6 = convert(T, -34035261967014004512968665 // 31722926842759712066804711232)
    btilde7 = convert(T, 24580774837247048845194838016 // 92177847597783889926140264245935)
    btilde8 = convert(T, 7658235379858959628545472335 // 3661540025836704721023671896)
    btilde9 = convert(T,
        BigInt(1510930663253486646384296195586886863633653147150681174690536256975353069486325) //
        BigInt(4702280880846591386281796794547701585430660412435581935467882526508158459415616))
    btilde10 = convert(T, -237184116991804346989794715 // 257525077377498332034781188)
    btilde11 = convert(T, 2460988291206213825688467985 // 1756342789520947764222671739)
    btilde12 = convert(T, 4808707937311 // 50545545388065)
    btilde13 = convert(T, -5752173075461 // 1925544586212)

    TsitPap8ConstantCache(c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, a0201, a0301, a0302,
        a0401, a0403, a0501, a0503, a0504, a0601, a0604, a0605, a0701,
        a0704, a0705, a0706, a0801, a0804, a0805, a0806, a0807, a0901,
        a0904, a0905, a0906, a0907, a0908, a1001, a1004, a1005, a1006,
        a1007, a1008, a1009, a1101, a1104, a1105, a1106, a1107, a1108,
        a1109, a1110, a1201, a1204, a1205, a1206, a1207, a1208, a1209,
        a1210, a1211, a1301, a1304, a1305, a1306, a1307, a1308, a1309,
        a1310, b1, b6, b7, b8, b9, b10, b11, b12, btilde1, btilde6,
        btilde7, btilde8, btilde9, btilde10, btilde11, btilde12, btilde13)
end

struct DP8ConstantCache{T, T2} <: OrdinaryDiffEqConstantCache
    c7::T2
    c8::T2
    c9::T2
    c10::T2
    c11::T2
    c6::T2
    c5::T2
    c4::T2
    c3::T2
    c2::T2
    b1::T
    b6::T
    b7::T
    b8::T
    b9::T
    b10::T
    b11::T
    b12::T
    btilde1::T
    btilde6::T
    btilde7::T
    btilde8::T
    btilde9::T
    btilde10::T
    btilde11::T
    btilde12::T
    er1::T
    er6::T
    er7::T
    er8::T
    er9::T
    er10::T
    er11::T
    er12::T
    a0201::T
    a0301::T
    a0302::T
    a0401::T
    a0403::T
    a0501::T
    a0503::T
    a0504::T
    a0601::T
    a0604::T
    a0605::T
    a0701::T
    a0704::T
    a0705::T
    a0706::T
    a0801::T
    a0804::T
    a0805::T
    a0806::T
    a0807::T
    a0901::T
    a0904::T
    a0905::T
    a0906::T
    a0907::T
    a0908::T
    a1001::T
    a1004::T
    a1005::T
    a1006::T
    a1007::T
    a1008::T
    a1009::T
    a1101::T
    a1104::T
    a1105::T
    a1106::T
    a1107::T
    a1108::T
    a1109::T
    a1110::T
    a1201::T
    a1204::T
    a1205::T
    a1206::T
    a1207::T
    a1208::T
    a1209::T
    a1210::T
    a1211::T
    c14::T2
    c15::T2
    c16::T2
    a1401::T
    a1407::T
    a1408::T
    a1409::T
    a1410::T
    a1411::T
    a1412::T
    a1413::T
    a1501::T
    a1506::T
    a1507::T
    a1508::T
    a1511::T
    a1512::T
    a1513::T
    a1514::T
    a1601::T
    a1606::T
    a1607::T
    a1608::T
    a1609::T
    a1613::T
    a1614::T
    a1615::T
    d401::T
    d406::T
    d407::T
    d408::T
    d409::T
    d410::T
    d411::T
    d412::T
    d413::T
    d414::T
    d415::T
    d416::T
    d501::T
    d506::T
    d507::T
    d508::T
    d509::T
    d510::T
    d511::T
    d512::T
    d513::T
    d514::T
    d515::T
    d516::T
    d601::T
    d606::T
    d607::T
    d608::T
    d609::T
    d610::T
    d611::T
    d612::T
    d613::T
    d614::T
    d615::T
    d616::T
    d701::T
    d706::T
    d707::T
    d708::T
    d709::T
    d710::T
    d711::T
    d712::T
    d713::T
    d714::T
    d715::T
    d716::T
end

function DP8ConstantCache(T::Type{<:CompiledFloats}, T2::Type{<:CompiledFloats})
    c7 = convert(T2, 0.25)
    c8 = convert(T2, 0.3076923076923077)
    c9 = convert(T2, 0.6512820512820513)
    c10 = convert(T2, 0.6)
    c11 = convert(T2, 0.8571428571428571)
    c6 = convert(T2, 0.3333333333333333)
    c5 = convert(T2, 0.2816496580927726)
    c4 = convert(T2, 0.1183503419072274)
    c3 = convert(T2, 0.0789002279381516)
    c2 = convert(T2, 0.05260015195876773)
    b1 = convert(T, 0.054293734116568765)
    b6 = convert(T, 4.450312892752409)
    b7 = convert(T, 1.8915178993145003)
    b8 = convert(T, -5.801203960010585)
    b9 = convert(T, 0.3111643669578199)
    b10 = convert(T, -0.1521609496625161)
    b11 = convert(T, 0.20136540080403034)
    b12 = convert(T, 0.04471061572777259)
    # bhh1   = convert(T,0.2440944881889764)
    # bhh2   = convert(T,0.7338466882816118)
    # bhh3   = convert(T,0.022058823529411766)
    btilde1 = convert(T, -0.18980075407240762)
    btilde6 = convert(T, 4.450312892752409)
    btilde7 = convert(T, 1.8915178993145003)
    btilde8 = convert(T, -5.801203960010585)
    btilde9 = convert(T, -0.42268232132379197)
    btilde10 = convert(T, -0.1521609496625161)
    btilde11 = convert(T, 0.20136540080403034)
    btilde12 = convert(T, 0.022651792198360825)
    er1 = convert(T, 0.01312004499419488)
    er6 = convert(T, -1.2251564463762044)
    er7 = convert(T, -0.4957589496572502)
    er8 = convert(T, 1.6643771824549864)
    er9 = convert(T, -0.35032884874997366)
    er10 = convert(T, 0.3341791187130175)
    er11 = convert(T, 0.08192320648511571)
    er12 = convert(T, -0.022355307863886294)
    a0201 = convert(T, 0.05260015195876773)
    a0301 = convert(T, 0.0197250569845379)
    a0302 = convert(T, 0.0591751709536137)
    a0401 = convert(T, 0.02958758547680685)
    a0403 = convert(T, 0.08876275643042054)
    a0501 = convert(T, 0.2413651341592667)
    a0503 = convert(T, -0.8845494793282861)
    a0504 = convert(T, 0.924834003261792)
    a0601 = convert(T, 0.037037037037037035)
    a0604 = convert(T, 0.17082860872947386)
    a0605 = convert(T, 0.12546768756682242)
    a0701 = convert(T, 0.037109375)
    a0704 = convert(T, 0.17025221101954405)
    a0705 = convert(T, 0.06021653898045596)
    a0706 = convert(T, -0.017578125)
    a0801 = convert(T, 0.03709200011850479)
    a0804 = convert(T, 0.17038392571223998)
    a0805 = convert(T, 0.10726203044637328)
    a0806 = convert(T, -0.015319437748624402)
    a0807 = convert(T, 0.008273789163814023)
    a0901 = convert(T, 0.6241109587160757)
    a0904 = convert(T, -3.3608926294469414)
    a0905 = convert(T, -0.868219346841726)
    a0906 = convert(T, 27.59209969944671)
    a0907 = convert(T, 20.154067550477894)
    a0908 = convert(T, -43.48988418106996)
    a1001 = convert(T, 0.47766253643826434)
    a1004 = convert(T, -2.4881146199716677)
    a1005 = convert(T, -0.590290826836843)
    a1006 = convert(T, 21.230051448181193)
    a1007 = convert(T, 15.279233632882423)
    a1008 = convert(T, -33.28821096898486)
    a1009 = convert(T, -0.020331201708508627)
    a1101 = convert(T, -0.9371424300859873)
    a1104 = convert(T, 5.186372428844064)
    a1105 = convert(T, 1.0914373489967295)
    a1106 = convert(T, -8.149787010746927)
    a1107 = convert(T, -18.52006565999696)
    a1108 = convert(T, 22.739487099350505)
    a1109 = convert(T, 2.4936055526796523)
    a1110 = convert(T, -3.0467644718982196)
    a1201 = convert(T, 2.273310147516538)
    a1204 = convert(T, -10.53449546673725)
    a1205 = convert(T, -2.0008720582248625)
    a1206 = convert(T, -17.9589318631188)
    a1207 = convert(T, 27.94888452941996)
    a1208 = convert(T, -2.8589982771350235)
    a1209 = convert(T, -8.87285693353063)
    a1210 = convert(T, 12.360567175794303)
    a1211 = convert(T, 0.6433927460157636)
    c14, c15, c16, a1401, a1407, a1408, a1409, a1410, a1411, a1412, a1413, a1501, a1506, a1507, a1508, a1511, a1512, a1513, a1514, a1601, a1606, a1607, a1608, a1609, a1613, a1614, a1615 = DP8Interp(
        T,
        T2)
    d401, d406, d407, d408, d409, d410, d411, d412, d413, d414, d415, d416, d501, d506, d507, d508, d509, d510, d511, d512, d513, d514, d515, d516, d601, d606, d607, d608, d609, d610, d611, d612, d613, d614, d615, d616, d701, d706, d707, d708, d709, d710, d711, d712, d713, d714, d715, d716 = DP8Interp_polyweights(T)
    DP8ConstantCache(
        c7, c8, c9, c10, c11, c6, c5, c4, c3, c2, b1, b6, b7, b8, b9, b10, b11,
        b12, btilde1, btilde6, btilde7, btilde8, btilde9, btilde10, btilde11,
        btilde12, er1, er6, er7, er8, er9, er10, er11, er12, a0201, a0301,
        a0302, a0401, a0403, a0501, a0503, a0504, a0601, a0604, a0605, a0701,
        a0704, a0705, a0706, a0801, a0804, a0805, a0806, a0807, a0901, a0904,
        a0905, a0906, a0907, a0908, a1001, a1004, a1005, a1006, a1007, a1008,
        a1009, a1101, a1104, a1105, a1106, a1107, a1108, a1109, a1110, a1201,
        a1204, a1205, a1206, a1207, a1208, a1209, a1210, a1211, c14, c15, c16,
        a1401, a1407, a1408, a1409, a1410, a1411, a1412, a1413, a1501, a1506,
        a1507, a1508, a1511, a1512, a1513, a1514, a1601, a1606, a1607, a1608,
        a1609, a1613, a1614, a1615, d401, d406, d407, d408, d409, d410, d411,
        d412, d413, d414, d415, d416, d501, d506, d507, d508, d509, d510, d511,
        d512, d513, d514, d515, d516, d601, d606, d607, d608, d609, d610, d611,
        d612, d613, d614, d615, d616, d701, d706, d707, d708, d709, d710, d711,
        d712, d713, d714, d715, d716)
end

function DP8ConstantCache(T::Type, T2::Type)
    c7 = convert(T2, 1 // 4)
    c8 = convert(T2, 4 // 13)
    c9 = convert(T2, 127 // 195)
    c10 = convert(T2, 3 // 5)
    c11 = convert(T2, 6 // 7)
    c6 = convert(T2, 4 // 3 * c7)
    c5 = convert(T2, (6 + sqrt(6)) / 10 * c6)
    c4 = convert(T2, (6 - sqrt(6)) / 10 * c6)
    c3 = convert(T2, 2 // 3 * c4)
    c2 = convert(T2, 2 // 3 * c3)
    b1 = convert(T, big" 5.42937341165687622380535766363e-2")
    b6 = convert(T, big" 4.45031289275240888144113950566")
    b7 = convert(T, big" 1.89151789931450038304281599044")
    b8 = convert(T, big"-5.8012039600105847814672114227")
    b9 = convert(T, big" 3.1116436695781989440891606237e-1")
    b10 = convert(T, big"-1.52160949662516078556178806805e-1")
    b11 = convert(T, big" 2.01365400804030348374776537501e-1")
    b12 = convert(T, big" 4.47106157277725905176885569043e-2")
    # bhh1   = convert(T,big"0.244094488188976377952755905512")
    # bhh2   = convert(T,big"0.733846688281611857341361741547")
    # bhh3   = convert(T,big"0.220588235294117647058823529412e-01")
    btilde1 = convert(T, big"-1.898007540724076157147023288757e-1")
    btilde6 = convert(T, big" 4.45031289275240888144113950566")
    btilde7 = convert(T, big" 1.89151789931450038304281599044")
    btilde8 = convert(T, big"-5.8012039600105847814672114227")
    btilde9 = convert(T, big"-4.22682321323791962932445679177e-1")
    btilde10 = convert(T, big"-1.52160949662516078556178806805e-1")
    btilde11 = convert(T, big" 2.01365400804030348374776537501e-1")
    btilde12 = convert(T, big"2.26517921983608258118062039631e-2")
    er1 = convert(T, big" 0.1312004499419488073250102996e-01")
    er6 = convert(T, big"-0.1225156446376204440720569753e+01")
    er7 = convert(T, big"-0.4957589496572501915214079952")
    er8 = convert(T, big" 0.1664377182454986536961530415e+01")
    er9 = convert(T, big"-0.3503288487499736816886487290")
    er10 = convert(T, big" 0.3341791187130174790297318841")
    er11 = convert(T, big" 0.8192320648511571246570742613e-01")
    er12 = convert(T, big"-0.2235530786388629525884427845e-01")
    a0201 = convert(T, big" 5.26001519587677318785587544488e-2")
    a0301 = convert(T, big" 1.97250569845378994544595329183e-2")
    a0302 = convert(T, big" 5.91751709536136983633785987549e-2")
    a0401 = convert(T, big" 2.95875854768068491816892993775e-2")
    a0403 = convert(T, big" 8.87627564304205475450678981324e-2")
    a0501 = convert(T, big" 2.41365134159266685502369798665e-1")
    a0503 = convert(T, big"-8.84549479328286085344864962717e-1")
    a0504 = convert(T, big" 9.24834003261792003115737966543e-1")
    a0601 = convert(T, big" 3.7037037037037037037037037037e-2")
    a0604 = convert(T, big" 1.70828608729473871279604482173e-1")
    a0605 = convert(T, big" 1.25467687566822425016691814123e-1")
    a0701 = convert(T, big" 3.7109375e-2")
    a0704 = convert(T, big" 1.70252211019544039314978060272e-1")
    a0705 = convert(T, big" 6.02165389804559606850219397283e-2")
    a0706 = convert(T, big"-1.7578125e-2")
    a0801 = convert(T, big" 3.70920001185047927108779319836e-2")
    a0804 = convert(T, big" 1.70383925712239993810214054705e-1")
    a0805 = convert(T, big" 1.07262030446373284651809199168e-1")
    a0806 = convert(T, big"-1.53194377486244017527936158236e-2")
    a0807 = convert(T, big" 8.27378916381402288758473766002e-3")
    a0901 = convert(T, big" 6.24110958716075717114429577812e-1")
    a0904 = convert(T, big"-3.36089262944694129406857109825")
    a0905 = convert(T, big"-8.68219346841726006818189891453e-1")
    a0906 = convert(T, big" 2.75920996994467083049415600797e1")
    a0907 = convert(T, big" 2.01540675504778934086186788979e1")
    a0908 = convert(T, big"-4.34898841810699588477366255144e1")
    a1001 = convert(T, big" 4.77662536438264365890433908527e-1")
    a1004 = convert(T, big"-2.48811461997166764192642586468e0")
    a1005 = convert(T, big"-5.90290826836842996371446475743e-1")
    a1006 = convert(T, big" 2.12300514481811942347288949897e1")
    a1007 = convert(T, big" 1.52792336328824235832596922938e1")
    a1008 = convert(T, big"-3.32882109689848629194453265587e1")
    a1009 = convert(T, big"-2.03312017085086261358222928593e-2")
    a1101 = convert(T, big"-9.3714243008598732571704021658e-1")
    a1104 = convert(T, big" 5.18637242884406370830023853209e0")
    a1105 = convert(T, big" 1.09143734899672957818500254654e0")
    a1106 = convert(T, big"-8.14978701074692612513997267357e0")
    a1107 = convert(T, big"-1.85200656599969598641566180701e1")
    a1108 = convert(T, big" 2.27394870993505042818970056734e1")
    a1109 = convert(T, big" 2.49360555267965238987089396762e0")
    a1110 = convert(T, big"-3.0467644718982195003823669022e0")
    a1201 = convert(T, big"  2.27331014751653820792359768449e0")
    a1204 = convert(T, big" -1.05344954667372501984066689879e1")
    a1205 = convert(T, big" -2.00087205822486249909675718444e0")
    a1206 = convert(T, big" -1.79589318631187989172765950534e1")
    a1207 = convert(T, big"  2.79488845294199600508499808837e1")
    a1208 = convert(T, big" -2.85899827713502369474065508674e0")
    a1209 = convert(T, big" -8.87285693353062954433549289258e0")
    a1210 = convert(T, big" 1.23605671757943030647266201528e1")
    a1211 = convert(T, big" 6.43392746015763530355970484046e-1")
    c14, c15, c16, a1401, a1407, a1408, a1409, a1410, a1411, a1412, a1413, a1501, a1506, a1507, a1508, a1511, a1512, a1513, a1514, a1601, a1606, a1607, a1608, a1609, a1613, a1614, a1615 = DP8Interp(
        T,
        T2)
    d401, d406, d407, d408, d409, d410, d411, d412, d413, d414, d415, d416, d501, d506, d507, d508, d509, d510, d511, d512, d513, d514, d515, d516, d601, d606, d607, d608, d609, d610, d611, d612, d613, d614, d615, d616, d701, d706, d707, d708, d709, d710, d711, d712, d713, d714, d715, d716 = DP8Interp_polyweights(T)
    DP8ConstantCache(
        c7, c8, c9, c10, c11, c6, c5, c4, c3, c2, b1, b6, b7, b8, b9, b10, b11,
        b12, btilde1, btilde6, btilde7, btilde8, btilde9, btilde10, btilde11,
        btilde12, er1, er6, er7, er8, er9, er10, er11, er12, a0201, a0301,
        a0302, a0401, a0403, a0501, a0503, a0504, a0601, a0604, a0605, a0701,
        a0704, a0705, a0706, a0801, a0804, a0805, a0806, a0807, a0901, a0904,
        a0905, a0906, a0907, a0908, a1001, a1004, a1005, a1006, a1007, a1008,
        a1009, a1101, a1104, a1105, a1106, a1107, a1108, a1109, a1110, a1201,
        a1204, a1205, a1206, a1207, a1208, a1209, a1210, a1211, c14, c15, c16,
        a1401, a1407, a1408, a1409, a1410, a1411, a1412, a1413, a1501, a1506,
        a1507, a1508, a1511, a1512, a1513, a1514, a1601, a1606, a1607, a1608,
        a1609, a1613, a1614, a1615, d401, d406, d407, d408, d409, d410, d411,
        d412, d413, d414, d415, d416, d501, d506, d507, d508, d509, d510, d511,
        d512, d513, d514, d515, d516, d601, d606, d607, d608, d609, d610, d611,
        d612, d613, d614, d615, d616, d701, d706, d707, d708, d709, d710, d711,
        d712, d713, d714, d715, d716)
end

function DP8Interp(T::Type{<:CompiledFloats}, T2::Type{<:CompiledFloats})
    c14 = convert(T2, 0.1)
    c15 = convert(T2, 0.2)
    c16 = convert(T2, 0.7777777777777778)
    a1401 = convert(T, 0.056167502283047954)
    a1407 = convert(T, 0.25350021021662483)
    a1408 = convert(T, -0.2462390374708025)
    a1409 = convert(T, -0.12419142326381637)
    a1410 = convert(T, 0.15329179827876568)
    a1411 = convert(T, 0.00820105229563469)
    a1412 = convert(T, 0.007567897660545699)
    a1413 = convert(T, -0.008298)
    a1501 = convert(T, 0.03183464816350214)
    a1506 = convert(T, 0.028300909672366776)
    a1507 = convert(T, 0.053541988307438566)
    a1508 = convert(T, -0.05492374857139099)
    a1511 = convert(T, -0.00010834732869724932)
    a1512 = convert(T, 0.0003825710908356584)
    a1513 = convert(T, -0.00034046500868740456)
    a1514 = convert(T, 0.1413124436746325)
    a1601 = convert(T, -0.42889630158379194)
    a1606 = convert(T, -4.697621415361164)
    a1607 = convert(T, 7.683421196062599)
    a1608 = convert(T, 4.06898981839711)
    a1609 = convert(T, 0.3567271874552811)
    a1613 = convert(T, -0.0013990241651590145)
    a1614 = convert(T, 2.9475147891527724)
    a1615 = convert(T, -9.15095847217987)

    return c14, c15, c16, a1401, a1407, a1408, a1409, a1410, a1411, a1412, a1413, a1501,
    a1506, a1507, a1508, a1511, a1512, a1513, a1514, a1601, a1606, a1607, a1608,
    a1609, a1613, a1614, a1615
end

function DP8Interp(T::Type, T2::Type)
    c14 = convert(T2, 1 // 10)
    c15 = convert(T2, 2 // 10)
    c16 = convert(T2, 7 // 9)
    a1401 = convert(T, big" 5.61675022830479523392909219681e-2")
    a1407 = convert(T, big" 2.53500210216624811088794765333e-1")
    a1408 = convert(T, big"-2.46239037470802489917441475441e-1")
    a1409 = convert(T, big"-1.24191423263816360469010140626e-1")
    a1410 = convert(T, big" 1.5329179827876569731206322685e-1")
    a1411 = convert(T, big" 8.20105229563468988491666602057e-3")
    a1412 = convert(T, big" 7.56789766054569976138603589584e-3")
    a1413 = convert(T, big"-8.298e-3")
    a1501 = convert(T, big" 3.18346481635021405060768473261e-2")
    a1506 = convert(T, big" 2.83009096723667755288322961402e-2")
    a1507 = convert(T, big" 5.35419883074385676223797384372e-2")
    a1508 = convert(T, big"-5.49237485713909884646569340306e-2")
    a1511 = convert(T, big"-1.08347328697249322858509316994e-4")
    a1512 = convert(T, big" 3.82571090835658412954920192323e-4")
    a1513 = convert(T, big"-3.40465008687404560802977114492e-4")
    a1514 = convert(T, big" 1.41312443674632500278074618366e-1")
    a1601 = convert(T, big"-4.28896301583791923408573538692e-1")
    a1606 = convert(T, big"-4.69762141536116384314449447206e0")
    a1607 = convert(T, big" 7.68342119606259904184240953878e0")
    a1608 = convert(T, big" 4.06898981839711007970213554331e0")
    a1609 = convert(T, big" 3.56727187455281109270669543021e-1")
    a1613 = convert(T, big"-1.39902416515901462129418009734e-3")
    a1614 = convert(T, big" 2.9475147891527723389556272149e0")
    a1615 = convert(T, big"-9.15095847217987001081870187138e0")

    return c14, c15, c16, a1401, a1407, a1408, a1409, a1410, a1411, a1412, a1413, a1501,
    a1506, a1507, a1508, a1511, a1512, a1513, a1514, a1601, a1606, a1607, a1608,
    a1609, a1613, a1614, a1615
end

function DP8Interp_polyweights(T::Type{<:CompiledFloats})
    d401 = convert(T, -8.428938276109013)
    d406 = convert(T, 0.5667149535193777)
    d407 = convert(T, -3.0689499459498917)
    d408 = convert(T, 2.38466765651207)
    d409 = convert(T, 2.117034582445028)
    d410 = convert(T, -0.871391583777973)
    d411 = convert(T, 2.2404374302607883)
    d412 = convert(T, 0.6315787787694688)
    d413 = convert(T, -0.08899033645133331)
    d414 = convert(T, 18.148505520854727)
    d415 = convert(T, -9.194632392478356)
    d416 = convert(T, -4.436036387594894)
    d501 = convert(T, 10.427508642579134)
    d506 = convert(T, 242.28349177525817)
    d507 = convert(T, 165.20045171727028)
    d508 = convert(T, -374.5467547226902)
    d509 = convert(T, -22.113666853125306)
    d510 = convert(T, 7.733432668472264)
    d511 = convert(T, -30.674084731089398)
    d512 = convert(T, -9.332130526430229)
    d513 = convert(T, 15.697238121770845)
    d514 = convert(T, -31.139403219565178)
    d515 = convert(T, -9.35292435884448)
    d516 = convert(T, 35.81684148639408)
    d601 = convert(T, 19.985053242002433)
    d606 = convert(T, -387.0373087493518)
    d607 = convert(T, -189.17813819516758)
    d608 = convert(T, 527.8081592054236)
    d609 = convert(T, -11.57390253995963)
    d610 = convert(T, 6.8812326946963)
    d611 = convert(T, -1.0006050966910838)
    d612 = convert(T, 0.7777137798053443)
    d613 = convert(T, -2.778205752353508)
    d614 = convert(T, -60.19669523126412)
    d615 = convert(T, 84.32040550667716)
    d616 = convert(T, 11.99229113618279)
    d701 = convert(T, -25.69393346270375)
    d706 = convert(T, -154.18974869023643)
    d707 = convert(T, -231.5293791760455)
    d708 = convert(T, 357.6391179106141)
    d709 = convert(T, 93.40532418362432)
    d710 = convert(T, -37.45832313645163)
    d711 = convert(T, 104.0996495089623)
    d712 = convert(T, 29.8402934266605)
    d713 = convert(T, -43.53345659001114)
    d714 = convert(T, 96.32455395918828)
    d715 = convert(T, -39.17726167561544)
    d716 = convert(T, -149.72683625798564)

    return d401, d406, d407, d408, d409, d410, d411, d412, d413, d414, d415, d416, d501,
    d506, d507, d508, d509, d510, d511, d512, d513, d514, d515, d516, d601, d606,
    d607, d608, d609, d610, d611, d612, d613, d614, d615, d616, d701, d706, d707,
    d708, d709, d710, d711, d712, d713, d714, d715, d716
end

function DP8Interp_polyweights(T::Type)
    d401 = convert(T, big"-0.84289382761090128651353491142e+01")
    d406 = convert(T, big" 0.56671495351937776962531783590e+00")
    d407 = convert(T, big"-0.30689499459498916912797304727e+01")
    d408 = convert(T, big" 0.23846676565120698287728149680e+01")
    d409 = convert(T, big" 0.21170345824450282767155149946e+01")
    d410 = convert(T, big"-0.87139158377797299206789907490e+00")
    d411 = convert(T, big" 0.22404374302607882758541771650e+01")
    d412 = convert(T, big" 0.63157877876946881815570249290e+00")
    d413 = convert(T, big"-0.88990336451333310820698117400e-01")
    d414 = convert(T, big" 0.18148505520854727256656404962e+02")
    d415 = convert(T, big"-0.91946323924783554000451984436e+01")
    d416 = convert(T, big"-0.44360363875948939664310572000e+01")
    d501 = convert(T, big" 0.10427508642579134603413151009e+02")
    d506 = convert(T, big" 0.24228349177525818288430175319e+03")
    d507 = convert(T, big" 0.16520045171727028198505394887e+03")
    d508 = convert(T, big"-0.37454675472269020279518312152e+03")
    d509 = convert(T, big"-0.22113666853125306036270938578e+02")
    d510 = convert(T, big" 0.77334326684722638389603898808e+01")
    d511 = convert(T, big"-0.30674084731089398182061213626e+02")
    d512 = convert(T, big"-0.93321305264302278729567221706e+01")
    d513 = convert(T, big" 0.15697238121770843886131091075e+02")
    d514 = convert(T, big"-0.31139403219565177677282850411e+02")
    d515 = convert(T, big"-0.93529243588444783865713862664e+01")
    d516 = convert(T, big" 0.35816841486394083752465898540e+02")
    d601 = convert(T, big" 0.19985053242002433820987653617e+02")
    d606 = convert(T, big"-0.38703730874935176555105901742e+03")
    d607 = convert(T, big"-0.18917813819516756882830838328e+03")
    d608 = convert(T, big" 0.52780815920542364900561016686e+03")
    d609 = convert(T, big"-0.11573902539959630126141871134e+02")
    d610 = convert(T, big" 0.68812326946963000169666922661e+01")
    d611 = convert(T, big"-0.10006050966910838403183860980e+01")
    d612 = convert(T, big" 0.77771377980534432092869265740e+00")
    d613 = convert(T, big"-0.27782057523535084065932004339e+01")
    d614 = convert(T, big"-0.60196695231264120758267380846e+02")
    d615 = convert(T, big" 0.84320405506677161018159903784e+02")
    d616 = convert(T, big" 0.11992291136182789328035130030e+02")
    d701 = convert(T, big"-0.25693933462703749003312586129e+02")
    d706 = convert(T, big"-0.15418974869023643374053993627e+03")
    d707 = convert(T, big"-0.23152937917604549567536039109e+03")
    d708 = convert(T, big" 0.35763911791061412378285349910e+03")
    d709 = convert(T, big" 0.93405324183624310003907691704e+02")
    d710 = convert(T, big"-0.37458323136451633156875139351e+02")
    d711 = convert(T, big" 0.10409964950896230045147246184e+03")
    d712 = convert(T, big" 0.29840293426660503123344363579e+02")
    d713 = convert(T, big"-0.43533456590011143754432175058e+02")
    d714 = convert(T, big" 0.96324553959188282948394950600e+02")
    d715 = convert(T, big"-0.39177261675615439165231486172e+02")
    d716 = convert(T, big"-0.14972683625798562581422125276e+03")

    return d401, d406, d407, d408, d409, d410, d411, d412, d413, d414, d415, d416, d501,
    d506, d507, d508, d509, d510, d511, d512, d513, d514, d515, d516, d601, d606,
    d607, d608, d609, d610, d611, d612, d613, d614, d615, d616, d701, d706, d707,
    d708, d709, d710, d711, d712, d713, d714, d715, d716
end
struct PFRK87ConstantCache{T1, T2} <: OrdinaryDiffEqConstantCache
    α0201::T1
    α0301::T1
    α0401::T1
    α0501::T1
    α0601::T1
    α0701::T1

    α0302::T1

    α0403::T1
    α0503::T1

    α0504::T1
    α0604::T1
    α0704::T1

    α0605::T1
    α0705::T1

    α0706::T1

    α0908::T1
    α1008::T1
    α1108::T1
    α1208::T1
    α1308::T1

    α1009::T1
    α1109::T1
    α1209::T1
    α1309::T1

    α1110::T1
    α1210::T1
    α1310::T1

    α1211::T1
    α1311::T1

    β1::T1
    β6::T1
    β7::T1
    β8::T1
    β9::T1
    β10::T1
    β11::T1
    β12::T1
    β13::T1

    β1tilde::T1
    β6tilde::T1
    β7tilde::T1
    β8tilde::T1
    β9tilde::T1
    β10tilde::T1
    β11tilde::T1
    β12tilde::T1

    c2::T2
    c3::T2
    c4::T2
    c5::T2
    c6::T2
    c7::T2
    c8::T2
    c9::T2
    c10::T2
    c11::T2
    c12::T2
    c13::T2
end

function PFRK87ConstantCache(T1::Type, T2::Type)

    # elements of Butcher Table
    α0201 = convert(T1, 1 // 18)
    α0301 = convert(T1, 1 // 48)
    α0401 = convert(T1, 1 // 32)
    α0501 = convert(T1, 5 // 16)
    α0601 = convert(T1, 3 // 80)
    α0701 = convert(T1, 29443841 // 614563906)

    α0302 = convert(T1, 1 // 16)

    α0403 = convert(T1, 3 // 32)
    α0503 = convert(T1, -75 // 64)

    α0504 = convert(T1, 75 // 64)
    α0604 = convert(T1, 3 // 16)
    α0704 = convert(T1, 77736538 // 692538347)

    α0605 = convert(T1, 3 // 20)
    α0705 = convert(T1, -28693883 // 1125000000)

    α0706 = convert(T1, 23124283 // 1800000000)

    α0908 = convert(T1, 800635310 // 3783071287)
    α1008 = convert(T1, 393006217 // 1396673457)
    α1108 = convert(T1, 15336726248 // 1032824649)
    α1208 = convert(T1, 5232866602 // 850066563)
    α1308 = convert(T1, -13158990841 // 6184727034)

    α1009 = convert(T1, 123872331 // 1001029789)
    α1109 = convert(T1, -45442868181 // 3398467696)
    α1209 = convert(T1, -4093664535 // 808688257)
    α1309 = convert(T1, 3936647629 // 1978049680)

    α1110 = convert(T1, 3065993473 // 597172653)
    α1210 = convert(T1, 3962137247 // 1805957418)
    α1310 = convert(T1, -160528059 // 685178525)

    α1211 = convert(T1, 65686358 // 487910083)
    α1311 = convert(T1, 248638103 // 1413531060)

    β1 = convert(T1, 14005451 // 335480064)
    β6 = convert(T1, -59238493 // 1068277825)
    β7 = convert(T1, 181606767 // 758867731)
    β8 = convert(T1, 561292985 // 797845732)
    β9 = convert(T1, -1041891430 // 1371343529)
    β10 = convert(T1, 760417239 // 1151165299)
    β11 = convert(T1, 118820643 // 751138087)
    β12 = convert(T1, -528747749 // 2220607170)
    β13 = convert(T1, 1 // 4)

    β1tilde = convert(T1, 13451932 // 455176623)
    β6tilde = convert(T1, -808719846 // 976000145)
    β7tilde = convert(T1, 1757004468 // 5645159321)
    β8tilde = convert(T1, 656045339 // 265891186)
    β9tilde = convert(T1, -3867574721 // 1518517206)
    β10tilde = convert(T1, 465885868 // 322736535)
    β11tilde = convert(T1, 53011238 // 667516719)
    β12tilde = convert(T1, 2 // 45)

    c2 = convert(T2, 1 // 18)
    c3 = convert(T2, 1 // 12)
    c4 = convert(T2, 1 // 8)
    c5 = convert(T2, 5 // 16)
    c6 = convert(T2, 3 // 8)
    c7 = convert(T2, 59 // 400)
    c8 = convert(T2, 93 // 200)
    c9 = convert(T2, 5490023248 // 9719169821)
    c10 = convert(T2, 13 // 20)
    c11 = convert(T2, 1201146811 // 1299019798)
    c12 = convert(T2, 1 // 1)
    c13 = convert(T2, 1 // 1)

    PFRK87ConstantCache(α0201, α0301, α0401, α0501, α0601, α0701, α0302, α0403, α0503,
        α0504, α0604, α0704, α0605, α0705, α0706, α0908, α1008, α1108,
        α1208, α1308, α1009, α1109, α1209, α1309, α1110, α1210, α1310,
        α1211, α1311, β1, β6, β7, β8, β9, β10, β11, β12, β13, β1tilde,
        β6tilde, β7tilde, β8tilde, β9tilde, β10tilde, β11tilde, β12tilde,
        c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13)
end
