struct Rosenbrock23Tableau{T}
    c₃₂::T
    d::T
end

function Rosenbrock23Tableau(T)
    c₃₂ = convert(T, 6 + sqrt(2))
    d = convert(T, 1 / (2 + sqrt(2)))
    Rosenbrock23Tableau(c₃₂, d)
end

struct Rosenbrock32Tableau{T}
    c₃₂::T
    d::T
end

function Rosenbrock32Tableau(T)
    c₃₂ = convert(T, 6 + sqrt(2))
    d = convert(T, 1 / (2 + sqrt(2)))
    Rosenbrock32Tableau(c₃₂, d)
end

struct ROS3PTableau{T, T2}
    a21::T
    a31::T
    a32::T
    C21::T
    C31::T
    C32::T
    b1::T
    b2::T
    b3::T
    btilde1::T
    btilde2::T
    btilde3::T
    gamma::T2
    c2::T2
    c3::T2
    d1::T
    d2::T
    d3::T
end

function ROS3PTableau(T, T2)
    gamma = convert(T, 1 / 2 + sqrt(3) / 6)
    igamma = inv(gamma)
    a21 = convert(T, igamma)
    a31 = convert(T, igamma)
    a32 = convert(T, 0)
    C21 = convert(T, -igamma^2)
    tmp = -igamma * (convert(T, 2) - convert(T, 1 / 2) * igamma)
    C31 = -igamma * (convert(T, 1) - tmp)
    C32 = tmp
    tmp = igamma * (convert(T, 2 / 3) - convert(T, 1 / 6) * igamma)
    b1 = igamma * (convert(T, 1) + tmp)
    b2 = tmp
    b3 = convert(T, 1 / 3) * igamma
    # btilde1 = convert(T,2.113248654051871)
    # btilde2 = convert(T,1.000000000000000)
    # btilde3 = convert(T,0.4226497308103742)
    btilde1 = b1 - convert(T, 2.113248654051871)
    btilde2 = b2 - convert(T, 1.000000000000000)
    btilde3 = b3 - convert(T, 0.4226497308103742)
    c2 = convert(T, 1)
    c3 = convert(T, 1)
    d1 = convert(T, 0.7886751345948129)
    d2 = convert(T, -0.2113248654051871)
    d3 = convert(T, -1.077350269189626)
    ROS3PTableau(
        a21, a31, a32, C21, C31, C32, b1, b2, b3, btilde1, btilde2, btilde3, gamma,
        c2, c3, d1, d2, d3)
end

struct Rodas3Tableau{T, T2}
    a21::T
    a31::T
    a32::T
    a41::T
    a42::T
    a43::T
    C21::T
    C31::T
    C32::T
    C41::T
    C42::T
    C43::T
    b1::T
    b2::T
    b3::T
    b4::T
    btilde1::T
    btilde2::T
    btilde3::T
    btilde4::T
    gamma::T2
    c2::T2
    c3::T2
    d1::T
    d2::T
    d3::T
    d4::T
end

function Rodas3Tableau(T, T2)
    gamma = convert(T, 1 // 2)
    a21 = convert(T, 0)
    a31 = convert(T, 2)
    a32 = convert(T, 0)
    a41 = convert(T, 2)
    a42 = convert(T, 0)
    a43 = convert(T, 1)
    C21 = convert(T, 4)
    C31 = convert(T, 1)
    C32 = convert(T, -1)
    C41 = convert(T, 1)
    C42 = convert(T, -1)
    C43 = convert(T, -8 // 3)
    b1 = convert(T, 2)
    b2 = convert(T, 0)
    b3 = convert(T, 1)
    b4 = convert(T, 1)
    btilde1 = convert(T, 0.0)
    btilde2 = convert(T, 0.0)
    btilde3 = convert(T, 0.0)
    btilde4 = convert(T, 1.0)
    c2 = convert(T, 0.0)
    c3 = convert(T, 1.0)
    c4 = convert(T, 1.0)
    d1 = convert(T, 1 // 2)
    d2 = convert(T, 3 // 2)
    d3 = convert(T, 0)
    d4 = convert(T, 0)
    Rodas3Tableau(a21, a31, a32, a41, a42, a43, C21, C31, C32, C41, C42, C43, b1, b2, b3,
        b4, btilde1, btilde2, btilde3, btilde4, gamma, c2, c3, d1, d2, d3, d4)
end

struct Rodas3PTableau{T, T2}
    a21::T
    a41::T
    a42::T
    a43::T
    C21::T
    C31::T
    C32::T
    C41::T
    C42::T
    C43::T
    C51::T
    C52::T
    C53::T
    C54::T
    gamma::T
    c2::T2
    c3::T2
    d1::T
    d2::T
    d3::T
    h21::T
    h22::T
    h23::T
    h24::T
    h25::T
    h31::T
    h32::T
    h33::T
    h34::T
    h35::T
    h2_21::T
    h2_22::T
    h2_23::T
    h2_24::T
    h2_25::T
end

function Rodas3PTableau(T, T2)
    gamma = convert(T, 1 // 3)
    a21 = convert(T, 4.0 / 3.0)
    a41 = convert(T, 2.90625)
    a42 = convert(T, 3.375)
    a43 = convert(T, 0.40625)
    C21 = -convert(T, 4.0)
    C31 = convert(T, 8.25)
    C32 = convert(T, 6.75)
    C41 = convert(T, 1.21875)
    C42 = -convert(T, 5.0625)
    C43 = -convert(T, 1.96875)
    C51 = convert(T, 4.03125)
    C52 = -convert(T, 15.1875)
    C53 = -convert(T, 4.03125)
    C54 = convert(T, 6.0)
    c2 = convert(T2, 4.0 / 9.0)
    c3 = convert(T2, 0.0)
    d1 = convert(T, 1.0 / 3.0)
    d2 = -convert(T, 1.0 / 9.0)
    d3 = convert(T, 1.0)
    h21 = convert(T, 1.78125)
    h22 = convert(T, 6.75)
    h23 = convert(T, 0.15625)
    h24 = -convert(T, 6.0)
    h25 = -convert(T, 1.0)
    h31 = convert(T, 4.21875)
    h32 = -convert(T, 15.1875)
    h33 = -convert(T, 3.09375)
    h34 = convert(T, 9.0)
    h35 = convert(T, 0.0)
    h2_21 = convert(T, 4.21875)
    h2_22 = -convert(T, 2.025)
    h2_23 = -convert(T, 1.63125)
    h2_24 = -convert(T, 1.7)
    h2_25 = -convert(T, 0.1)
    Rodas3PTableau(a21, a41, a42, a43,
        C21, C31, C32, C41, C42, C43, C51, C52, C53, C54,
        gamma, c2, c3, d1, d2, d3,
        h21, h22, h23, h24, h25, h31, h32, h33, h34, h35, h2_21, h2_22, h2_23, h2_24, h2_25)
end

@ROS2(:tableau)

@ROS23(:tableau)

@ROS34PW(:tableau)

@Rosenbrock4(:tableau)

struct RodasTableau{T, T2}
    A::Matrix{T}
    C::Matrix{T}
    gamma::T2
    c::Vector{T2}
    d::Vector{T}
    H::Matrix{T}
end

const RODAS4A = [0 0 0 0 0 0
          1.544 0 0 0 0 0
          0.9466785280815826 0.2557011698983284 0 0 0 0
          3.314825187068521 2.896124015972201 0.9986419139977817 0 0 0
          1.221224509226641 6.019134481288629 12.53708332932087 -0.6878860361058950 0 0
          1.221224509226641 6.019134481288629 12.53708332932087 -0.6878860361058950 1 0]
const RODAS4C = [0 0 0 0 0
          -5.6688 0 0 0 0
          -2.430093356833875 -0.2063599157091915 0 0 0
          -0.1073529058151375 -9.594562251023355 -20.47028614809616 0 0
          7.496443313967647 -10.24680431464352 -33.99990352819905 11.70890893206160 0
          8.083246795921522 -7.981132988064893 -31.52159432874371 16.31930543123136 -6.058818238834054]
const RODAS4c = [0, 0.386, 0.21, 0.63, 1, 1]
const RODAS4d = [0.25, -0.1043, 0.1035, -0.0362, 0, 0]
const RODAS4H = [10.12623508344586 -7.487995877610167 -34.80091861555747 -7.992771707568823 1.025137723295662 0
          -0.6762803392801253 6.087714651680015 16.43084320892478 24.76722511418386 -6.594389125716872 0]
function Rodas4Tableau(T, T2)
    gamma = .25
    RodasTableau{T, T2}(RODAS4A, RODAS4C, gamma, RODAS4c, RODAS4d, RODAS4H)
end


const RODAS42A = [0 0 0 0 0 0
          1.4028884 0 0 0 0 0
          0.6581212688557198 -1.320936088384301 0 0 0 0
          7.131197445744498 16.02964143958207 -5.561572550509766 0 0 0
          22.73885722420363 67.38147284535289 -31.21877493038560 0.7285641833203814 0 0
          22.73885722420363 67.38147284535289 -31.21877493038560 0.7285641833203814 1 0]
const RODAS42C = [0 0 0 0 0
          -5.1043536 0 0 0 0
          -2.899967805418783 4.040399359702244 0 0 0
          -32.64449927841361 -99.35311008728094 49.99119122405989 0 0
          -76.46023087151691 -278.5942120829058 153.9294840910643 10.97101866258358 0
          -76.29701586804983 -294.2795630511232 162.0029695867566 23.65166903095270 -7.652977706771382]
const RODAS42c = [0, 0.3507221, 0.2557041, 0.681779, 1, 1]
const RODAS42d = [0.25, -0.0690221, -0.0009672, -0.087979, 0, 0]
const RODAS42H = [-38.71940424117216 -135.8025833007622 64.51068857505875 -4.192663174613162 -2.531932050335060 0
          -14.99268484949843 -76.30242396627033 58.65928432851416 16.61359034616402 -0.6758691794084156 0]
function Rodas42Tableau(T, T2)
    gamma = .25
    RodasTableau{T, T2}(RODAS42A, RODAS42C, gamma, RODAS42c, RODAS42d, RODAS42H)
end

const RODAS4PA = [0 0 0 0 0 0
          3 0 0 0 0 0
          1.831036793486759 0.4955183967433795 0 0 0 0
          2.304376582692669 -0.05249275245743001 -1.176798761832782 0 0 0
          -7.170454962423024 -4.741636671481785 -16.31002631330971 -1.062004044111401 0 0
          -7.170454962423024 -4.741636671481785 -16.31002631330971 -1.062004044111401 1 0]
const RODAS4PC = [0 0 0 0 0
          -12 0 0 0 0
          -8.791795173947035 -2.207865586973518 0 0 0
          10.81793056857153 6.780270611428266 19.53485944642410 0 0
          34.19095006749676 15.49671153725963 54.74760875964130 14.16005392148534 0
          34.62605830930532 15.30084976114473 56.99955578662667 18.40807009793095 -5.714285714285717]
const RODAS4Pc = [0, 0.75, 0.21, 0.63, 1, 1]
const RODAS4Pd = [0.25, -0.5, -0.023504, -0.0362, 0, 0]
const RODAS4PH = [25.09876703708589 11.62013104361867 28.49148307714626 -5.664021568594133 0 0
          1.638054557396973 -0.7373619806678748 8.477918219238990 15.99253148779520 -1.882352941176471 0]
function Rodas4PTableau(T, T2)
    gamma = .25
    RodasTableau{T, T2}(RODAS4PA, RODAS4PC, gamma, RODAS4Pc, RODAS4Pd, RODAS4PH)
end

const RODAS4P2A = [0 0 0 0 0 0
          3 0 0 0 0 0
          0.906377755268814 -0.189707390391685 0 0 0 0
          3.758617027739064 1.161741776019525 -0.849258085312803 0 0 0
          7.089566927282776 4.573591406461604 -8.423496976860259 -0.959280113459775 0 0
          7.089566927282776 4.573591406461604 -8.423496976860259 -0.959280113459775 1 0]
const RODAS4P2C = [0 0 0 0 0
          -12 0 0 0 0
          -6.354581592719008 0.338972550544623 0 0 0
          -8.575016317114033 -7.606483992117508 12.224997650124820 0 0
          -5.888975457523102 -8.157396617841821 24.805546872612922 12.790401512796979 0
          -4.408651676063871 -6.692003137674639 24.625568527593117 16.627521966636085 -5.714285714285718]
const RODAS4P2c = [0, 0.75, 0.321448134013046, 0.519745732277726, 1, 1]
const RODAS4P2d = [0.25, -0.5, -0.189532918363016, 0.085612108792769, 0, 0]
const RODAS4P2H = [-5.323528268423303 -10.042123754867493 17.175254928256965 -5.079931171878093 -0.016185991706112 0
         6.984505741529879 6.914061169603662 -0.849178943070653 18.104410789349338 -3.516963011559032 0]
function Rodas4P2Tableau(T, T2)
    gamma = .25
    RodasTableau{T, T2}(RODAS4P2A, RODAS4P2C, gamma, RODAS4P2c, RODAS4P2d, RODAS4P2H)
end

const RODAS5A = [0 0 0 0 0 0 0 0
      2.0 0 0 0 0 0 0 0
      3.040894194418781 1.041747909077569 0 0 0 0 0 0
      2.576417536461461 1.622083060776640 -0.9089668560264532 0 0 0 0 0
      2.760842080225597 1.446624659844071 -0.3036980084553738 0.2877498600325443 0 0 0 0
      -14.09640773051259 6.925207756232704 -41.47510893210728 2.343771018586405 24.13215229196062 0 0 0
      -14.09640773051259 6.925207756232704 -41.47510893210728 2.343771018586405 24.13215229196062 1 0 0
      -14.09640773051259 6.925207756232704 -41.47510893210728 2.343771018586405 24.13215229196062 1 1 0]
const RODAS5C = [0 0 0 0 0 0 0
      -10.31323885133993 0 0 0 0 0 0
      -21.04823117650003 -7.234992135176716 0 0 0 0 0
      32.22751541853323 -4.943732386540191 19.44922031041879 0 0 0 0
      -20.69865579590063 -8.816374604402768 1.260436877740897 -0.7495647613787146 0 0 0
      -46.22004352711257 -17.49534862857472 -289.6389582892057 93.60855400400906 318.3822534212147 0 0
      34.20013733472935 -14.15535402717690 57.82335640988400 25.83362985412365 1.408950972071624 -6.551835421242162 0
      42.57076742291101 -13.80770672017997 93.98938432427124 18.77919633714503 -31.58359187223370 -6.685968952921985 -5.810979938412932]
const RODAS5c = [0, 0.38, 0.3878509998321533, 0.4839718937873840, 0.4570477008819580, 1, 1, 1]
const RODAS5d = [0.19, -0.1823079225333714636, -0.319231832186874912,
    0.3449828624725343, -0.377417564392089818, 0, 0, 0]

const RODAS5H = [27.354592673333357 -6.925207756232857 26.40037733258859 0.5635230501052979 -4.699151156849391 -1.6008677469422725 -1.5306074446748028 -1.3929872940716344
      44.19024239501722 1.3677947663381929e-13 202.93261852171622 -35.5669339789154 -181.91095152160645 3.4116351403665033 2.5793540257308067 2.2435122582734066
      -44.0988150021747 -5.755396159656812e-13 -181.26175034586677 56.99302194811676 183.21182741427398 -7.480257918273637 -5.792426076169686 -5.32503859794143]

function Rodas5Tableau(T, T2)
    gamma = 0.19
    RodasTableau{T, T2}(RODAS5A, RODAS5C, gamma, RODAS5c, RODAS5d, RODAS5H)
end

const RODAS5PA = [0 0 0 0 0 0 0 0
          3.0 0 0 0 0 0 0 0
          2.849394379747939 0.45842242204463923 0 0 0 0 0 0
          -6.954028509809101 2.489845061869568 -10.358996098473584 0 0 0 0 0
          2.8029986275628964 0.5072464736228206 -0.3988312541770524 -0.04721187230404641 0 0 0 0
          -7.502846399306121 2.561846144803919 -11.627539656261098 -0.18268767659942256 0.030198172008377946 0 0 0
          -7.502846399306121 2.561846144803919 -11.627539656261098 -0.18268767659942256 0.030198172008377946 1 0 0
          -7.502846399306121 2.561846144803919 -11.627539656261098 -0.18268767659942256 0.030198172008377946 1 1 0]
const RODAS5PC = [0 0 0 0 0 0 0
          -14.155112264123755 0 0 0 0 0 0
          -17.97296035885952 -2.859693295451294 0 0 0 0 0
          147.12150275711716 -1.41221402718213 71.68940251302358 0 0 0 0
          165.43517024871676 -0.4592823456491126 42.90938336958603 -5.961986721573306 0 0 0
          24.854864614690072 -3.0009227002832186 47.4931110020768 5.5814197821558125 -0.6610691825249471 0 0
          30.91273214028599 -3.1208243349937974 77.79954646070892 34.28646028294783 -19.097331116725623 -28.087943162872662 0
          37.80277123390563 -3.2571969029072276 112.26918849496327 66.9347231244047 -40.06618937091002 -54.66780262877968 -9.48861652309627]
const RODAS5Pc = [0, 0.6358126895828704, 0.4095798393397535,
        0.9769306725060716, 0.4288403609558664, 1, 1, 1]
const RODAS5Pd = [0.21193756319429014, -0.42387512638858027, -0.3384627126235924,
        1.8046452872882734, 2.325825639765069, 0, 0, 0]
const RODAS5PH = [25.948786856663858 -2.5579724845846235 10.433815404888879 -2.3679251022685204 0.524948541321073 1.1241088310450404 0.4272876194431874 -0.17202221070155493
          -9.91568850695171 -0.9689944594115154 3.0438037242978453 -24.495224566215796 20.176138334709044 15.98066361424651 -6.789040303419874 -6.710236069923372
          11.419903575922262 2.8879645146136994 72.92137995996029 80.12511834622643 -52.072871366152654 -59.78993625266729 -0.15582684282751913 4.883087185713722]
function Rodas5PTableau(T, T2)
    gamma = 0.21193756319429014
    RodasTableau{T, T2}(RODAS5PA, RODAS5PC, gamma, RODAS5Pc, RODAS5Pd, RODAS5PH)
end

const RODAS6PA = [0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 1.7111784962693573 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 3.338661438538325 1.7785154948506772 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 2.936071270275081 0.9182685464146361 0.3700626437020361 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 4.659498341685848 1.750740798902701 0.5870646872926452 0.8880273208834594 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 4.0197306615530755 2.839611966871549 -0.5985886977898102 0.08804800108767567 1.5622259206803966 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 1.988416726724047 -0.379547946940864 0.9004347186464728 1.4277449221484224 -0.7433508015345144 -0.042432590368607255 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 1.8376133238441654 1.9114959548124457 -0.6715227349230231 0.2358079620635186 3.6095202089874117 0.8151701113738031 0.9206065341545108 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 -0.766306772356088 3.209956697664864 -3.3123779344961592 -3.0203200762095332 4.800864725315542 1.1604579105760842 0.4424812765132964 0.3706918590956091 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 6.232416226700401 2.6089061288608786 -0.6004565639275875 -3.3845987889094653 0.42397260663019737 0.35421155529651493 0.30716464971632756 1.5008969261275715 0.5102657561692372 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 0.023392109748070492 1.4081998520657641 -0.7199787823918794 0.7361286083371824 2.4632772861278043 0.46923886035475726 0.1205787235019629 -0.8578747086506138 -0.2588726092696778 -0.4397748045492015 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 2.953951852943472 -0.5094757863221286 0.3109577019600045 -3.5298051247141733 -3.545755924579993 -0.33681829638738314 -0.5663219967973026 1.1332773651373889 0.15030559921640937 0.25755454716019555 0.29836356640198125 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 3.613614004197333 0.6635854700997046 0.021719370087612728 -1.4950066071478674 0.7257768429136315 -0.05542296424699332 0.6617050893162496 1.5916006835996634 0.004468857383033254 0.3492741589610665 -0.20270398239783438 0.6407744206145284 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 0.6650675322630164 3.8649437891996143 -3.5568168140908862 0.30445082364848014 6.687033712252074 1.7577448564663951 0.7252352806302017 0.8340620415656512 0.288756122559755 -0.014344518613253377 -0.9202387269679146 0.1235675186947092 0.5210532009614854 0.0 0.0 0.0 0.0 0.0 0.0
 0.6650675322630163 3.864943789199614 -3.5568168140908876 0.30445082364847914 6.687033712252074 1.7577448564663951 0.7252352806302018 0.834062041565651 0.2887561225597551 -0.014344518613253487 -0.9202387269679145 0.12356751869470915 0.5210532009614851 1.0 0.0 0.0 0.0 0.0 0.0
 0.6650675322630177 3.864943789199614 -3.5568168140908876 0.30445082364847964 6.687033712252074 1.7577448564663947 0.7252352806302018 0.8340620415656512 0.2887561225597553 -0.014344518613253388 -0.9202387269679146 0.12356751869470915 0.5210532009614847 0.9999999999999998 1.0 0.0 0.0 0.0 0.0
 19.50552823691581 19.347153108620457 8.914549824296701 19.841538938728135 -30.357562810836335 -5.8051482228142195 -20.70248562796752 -21.376641384544037 -8.3987892732033 -7.736419267379574 2.0685219772918724 -8.760228330317224 5.418493374208782 1.6147496952752922 -2.4936078709750045 -2.2780749437287913 0.0 0.0 0.0
 56.666079713903386 5.165818087889462 22.35860178936739 10.763846891315566 -12.19955923582867 -0.6557677952689249 6.699011373303813 8.198746354754231 1.677616608414471 3.1277285768268968 1.4179582645760416 -2.2744851263878836 -1.7540829181840385 -2.0011264405011304 -2.473136836317977 -1.8837562152980634 0.10307912091592847 0.0 0.0
 0.4516803503254423 -1.1534041395134922 -4.845280220499032 -23.586737710513358 1.6878417137075876 0.7868554635343545 3.0270371561482805 6.0990245036017745 2.600755391135945 1.3246029905944345 2.0716827798306645 1.0885240892776982 -2.406764303616696 -1.0934035335348031 -0.08817028752603433 0.1628623060793163 -0.0494871328758008 -0.053891050773493175 0.0]
const RODAS6PC = [0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 -6.581455754882143 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 -17.99898897860265 -8.573983492685619 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 -9.381383431453385 -3.147640353879416 -1.3459246069197102 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 -2.6265331637613007 -4.114341661049238 2.3552716210903446 0.7916860595752533 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 13.234071865054425 -6.5531726714288245 10.73126008968739 7.881893740344428 -12.771533510641573 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 2.830906994202388 0.2604988641272497 1.2537810312593667 -3.3671244579321455 -10.786563365589606 -1.9308385166591397 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 -11.060311196714387 -1.3456656966931244 -0.7657970115506183 6.107723730659436 2.2037867523584938 -0.07238767937020778 -0.8050462039096485 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 -18.12844382677043 -8.753725825758918 2.21059342699439 11.608007179779365 -0.05812583279366939 -0.5568300956262869 0.22469855334210373 -3.2370311176417705 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 -27.976343920035056 -8.591555353546772 0.7281452536154736 17.638493457476986 -5.306189757628467 -3.0476569146401444 -5.904770682441327 -11.929084037829442 -5.050568446376497 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 16.354749252471326 1.4669223994142209 5.928484441955681 10.74513480723443 10.673355125609953 3.688805562318594 9.180717730517506 10.247712646451996 1.465303310058304 2.6508985881732774 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 6.914935441832399 5.38984958631352 5.862037438875566 5.348681436005972 -7.013382408252529 -1.0246660674824237 -2.9837100715597376 -5.836566084094612 -1.6109549842142277 -1.1760399923017764 1.9280128334739643 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 4.198711896534994 0.6181084056782703 0.8167077246607498 -11.236495255410707 -4.824409089261172 0.7728367826492113 1.3033341851336357 3.1220057171705977 1.917167519177393 0.740911936448596 2.3884839541537675 -1.0646261824518854 0.0 0.0 0.0 0.0 0.0 0.0 0.0
 8.439457273665866 -12.395217711948733 8.717809686910918 -22.620864451522902 -20.113605406532766 -4.689776805197894 1.6982447341017708 4.543406791431926 1.613366829028557 1.9707273458768597 5.732578765805261 1.7624664316708778 -5.245856774591262 0.0 0.0 0.0 0.0 0.0 0.0
 1.71450490512272 -13.840042084553074 6.437347401872298 -39.22048912909508 -25.603335547270504 -8.064795628637777 -0.0416146802576695 1.2346482358729156 2.7009872115209252 0.896525973043981 11.303609670096813 1.7547024586563815 -10.02276713006834 -6.93945857648056 0.0 0.0 0.0 0.0 0.0
 19.61213176916848 -14.311603723508286 12.96694128305561 -28.107332490598257 -27.192311861144052 -4.26577843330566 4.2210733410202135 10.487402162301366 0.8300940888935481 2.8025411207314455 8.878715452726594 1.4612348690788786 -9.853595041510669 -7.6808377648250294 -6.870056791600298 0.0 0.0 0.0 0.0
 -371.4374434114548 -183.45541467767708 -245.2624549214238 -955.0201586246473 19.423673137681643 -0.9607917923114558 84.24290713671253 150.79467360315542 63.95986343894305 44.75849836276605 140.71019894715903 48.45923399488863 -146.47504553991118 -81.54609927566207 -25.07839993898753 3.829875020371404 0.0 0.0 0.0
 -164.17333724090065 -123.20834760012879 41.95443520088893 -239.77049586199965 -114.21790985713952 -12.341946126859007 15.750890701780254 39.790586318490696 -15.10728752295998 -12.824535901748304 16.73312629333741 -11.045750202895642 -14.639022723428816 -4.819493713790297 0.12987727446051117 0.04274137296376776 1.204312390836273 0.0 0.0
 461.9368267656361 52.53840694165619 144.8183760448168 455.9093893534564 35.81740627464267 40.776479432911195 17.76376684531324 -7.606209560029927 -15.381956921574087 3.9317973949968428 -41.37771137941743 -44.920577584346 53.37495929469229 10.211466474320808 -15.84128439059478 -19.507483543094224 1.884309895179932 5.745356704710484 0.0]
const RODAS6Pc = [0.0, 0.4449064090300329, 0.5391930604628539, 0.3920739557917205, 0.5393851240464334, 0.7496615946466092, 0.09171052879621677, 0.716762001806476, 0.9201684737037024, 0.7017495611178288, 0.5587152179138446, 0.10896187906446, 0.5073827520419607, 0.9999999999999999, 0.9999999999999999, 1.0000000000000002, 0.19999999999999996, 0.4999999999999998, 0.8]
const RODAS6Pd = [0.26, -0.18490640903003291, -0.5445316852875675, -0.03230297796648507, -0.05985832397786847, 0.08292573124960323, 0.4158601113780379, -0.4887636036121086, -0.5305551731438798, 0.12166683722729399, -0.14899579330238244, 0.20995126195089908, -0.06287825975966793, -1.1102230246251565e-16, 1.1102230246251565e-16, 2.220446049250313e-16, 8.520155173756681, -7.34858003171262, 1.5593201340906078]
const RODAS6PH = [17.587737160518465 -4.506717064391614 3.246011776864481 -5.070180845870549 -6.923968603369673 -1.6592466655000042 0.8383525386642399 1.2720777724693832 2.2171542815286456 1.2791183755209752 3.3596716472022443 -0.5508890465808383 -2.0565074886981494 -2.6056952102687827 -2.100871100634552 -1.8776167550373888 -0.022326222735958842 0.25936621048769365 -0.12973178185863266
   -27.32817833553187 2.3528275077734033 7.155223685651038 10.820120934865187 -25.034320788396975 -8.268316122429903 -11.20195859714455 -5.95292555000712 -4.350123484395559 -3.4923279797567224 -7.522667509591013 6.313357154108988 3.434436480929646 4.500204746140061 3.6478467450775045 2.888705712728512 -0.031277730738519756 -1.0511708104283997 0.7378677397843861
   48.135250596372614 1.6152029264444003 8.745836243957392 11.94240783069938 21.81240388443989 13.3043522805227 15.272804908450944 7.036607939296541 -2.212585956007379 3.686601637356048 8.623872556251557 -9.029595886738495 -6.643976834766214 -6.745850399987328 -7.810160738277424 -3.8140189856964035 0.04030442810903404 1.0072680387990685 -1.0126127084529764
   -12.232391324631207 1.7643387246585114 -0.8009754670601623 -2.893944757628759 -7.972815842366974 1.309554861689306 -4.604493120665954 1.8134270309595735 -3.751773417632513 -0.5811994801517248 -2.741530578462468 0.300651942632877 2.0061263661214994 1.8521005591286555 -0.2324954254701126 0.6873479719072509 0.12936879836252782 -0.17980608456604885 0.32290862251165836]  
function Rodas6PTableau(T, T2)
    gamma = 0.26
    RodasTableau{T, T2}(RODAS6PA, RODAS6PC, gamma, RODAS6Pc, RODAS6Pd, RODAS6PH)
end

@RosenbrockW6S4OS(:tableau)

#=
# alpha_ij
A = [0 0 0 0 0 0 0 0
     big"0.38" 0 0 0 0 0 0 0
     big"0.1899188971074152"    big"0.1979321027247381"  0 0 0 0 0 0
     big"0.1110729281178426"    big"0.5456026683145674"  big"-0.1727037026450261" 0 0 0 0 0
     big"0.2329444418850307"    big"0.025099380960713898" big"0.1443314046300300"  big"0.054672473406183418" 0 0 0 0
     big"-0.036201017843430883" big"4.208448872731939"   big"-7.549674427720996"  big"-0.2076823626400282" big"4.585108935472517" 0 0 0
     big"7.585261698003052"     big"-15.57426208319938"  big"-8.814406895608121"  big"1.534698996826085"   big"16.07870828397837" big"0.19" 0 0
     big"0.4646018839086969"    big"0"                   big"-1.720907508837576"  big"0.2910480220957973"  big"1.821778861539924" big"-0.046521258706842056" big"0.19" 0]
# bi
B = [big"0.464601884",0,big"-1.72090751",big"0.29104802",big"1.82177886",big"-0.02674488",big"-0.01977638",big"0.19"]

# Beta_ij

Beta = [big"0.19" 0 0 0 0 0 0 0
        big"0.0076920774666285364"  big"0.19" 0 0 0 0 0 0
        big"-0.058129718999580252"  big"-0.063251113355141360"  big"0.19" 0 0 0 0 0
        big"0.7075715596134048"     big"-0.5980299539145789"   big"0.5294131505610923"    big"0.19" 0 0 0 0
        big"-0.034975026573934865"  big"-0.1928476085817357"    big"0.089839586125126941"  big"0.027613185520411822" big"0.19" 0 0 0
        big"7.585261698003052"      big"-15.57426208319938"     big"-8.814406895608121"    big"1.534698996826085"    big"16.07870828397837"  big"0.19" 0 0
        big"0.4646018839086969"     0                           big"-1.720907508837576"    big"0.2910480220957973"   big"1.821778861539924"  big"-0.046521258706842056" big"0.19" 0
        big"0.4646018839086969"     0                           big"-1.720907508837576"    big"0.2910480220957973"   big"1.821778861539924"  big"-0.026744882930135193" big"-0.019776375776706864" big"0.19"]

Gamma = Beta - A
a = A*Gamma
m = B'*inv(Gamma) # = b_i
C = inv(Diagonal(diag(Gamma))) - inv(Gamma)
c = sum(A,2)
D = Beta*inv(Gamma)
d = sum(Gamma,2)

# Dense output
D_i = tanspose(D)*k_i
y1(Θ) = y₀*(1-Θ) + Θ*(y₁ + (Θ-1)*(D₂ + D₄ + (Θ + 1)*(D₃ + ΘD₄)))

# Determining coefficients
gamma = 0.19
c3 = 0.3878509998321533 == alpha3
c4 = 0.4839718937873840 == alpha4
c5 = 0.4570477008819580 == alpha5
beta3 = 6.8619167645278386e-2
beta4 = 0.8289547562599182
beta5 = 7.9630136489868164e-2
alpha64 = -0.2076823627400282
=#
