# Quick Start

```@meta
CurrentModule = PrettyTables
```

```@setup quick_start
using PrettyTables
```

The following command prints the table in `matrix` using the text backend with all the
available sections:

```julia-repl
julia> matrix = [(i, j) for i in 1:3, j in 1:3];

julia> pretty_table(
    matrix;
    column_labels            = [["Col. $i" for i in 1:3], ["$i" for i in 1:3]],
    footnotes                = [(:column_label, 1, 2) => "Footnote in column label", (:data, 2, 2) => "Footnote in data"],
    merge_column_label_cells = [MergeCells(1, 2, 2, "Merged Column", :c)],
    row_group_labels         = [2 => "Row Group"],
    row_labels               = ["Row $i" for i in 1:5],
    show_row_number_column   = true,
    source_notes             = "Source Notes",
    stubhead_label           = "Rows",
    subtitle                 = "Table Subtitle",
    summary_rows             = [(data, i) -> 10i, (data, i) -> 20i],
    title                    = "Table Title",
)
```

```@setup quick_start
matrix = [(i, j) for i in 1:3, j in 1:3];

str = pretty_table(
    String,
    matrix;
    color                    = true,
    column_labels            = [["Col. $i" for i in 1:3], ["$i" for i in 1:3]],
    footnotes                = [(:column_label, 1, 2) => "Footnote in column label", (:data, 2, 2) => "Footnote in data"],
    merge_column_label_cells = [MergeCells(1, 2, 2, "Merged Column", :c)],
    row_group_labels         = [2 => "Row Group"],
    row_labels               = ["Row $i" for i in 1:5],
    show_row_number_column   = true,
    source_notes             = "Source Notes",
    stubhead_label           = "Rows",
    subtitle                 = "Table Subtitle",
    summary_rows             = [(data, i) -> 10i, (data, i) -> 20i],
    title                    = "Table Title",
)

write("tmp", str)

run(`ansitoimg --width 60 --title "PrettyTables.jl (generated by AnsiToImg)" tmp quick_start.svg`)

run(`rm tmp`)
```

![Quick start](./quick_start.svg)
