using SimpleGraphs, LinearAlgebra

"""
    deGrey
Return Aubrey de Grey's graph. This is a unit-distance graph with 1585 vertices
that has chromatic number 5. 
"""
function deGrey()



edge_matrix = [1 27; 1 29; 1 31; 1 33; 1 35; 1 37; 1 39; 1 41; 1 43; 1 45; 1 47; 1 49; 1 410; 1 412; 1 414; 1 416; 1 418; 1 420; 1 422; 1 424; 1 426; 1 428; 1 430; 1 432; 1 434; 1 436; 1 438; 1 440; 1 442; 1 444; 1 446; 1 448; 1 450; 1 452; 1 454; 1 456; 1 1058; 1 1060; 1 1062; 1 1064; 1 1066; 1 1068; 1 1070; 1 1072; 1 1074; 1 1076; 1 1078; 1 1080; 1 1082; 1 1084; 1 1086; 1 1088; 1 1090; 1 1092; 1 1094; 1 1096; 1 1098; 1 1100; 1 1102; 1 1104; 2 28; 2 30; 2 32; 2 34; 2 36; 2 38; 2 40; 2 42; 2 44; 2 46; 2 48; 2 50; 2 411; 2 413; 2 415; 2 417; 2 419; 2 421; 2 423; 2 425; 2 427; 2 429; 2 431; 2 433; 2 435; 2 437; 2 439; 2 441; 2 443; 2 445; 2 447; 2 449; 2 451; 2 453; 2 455; 2 457; 2 1059; 2 1061; 2 1063; 2 1065; 2 1067; 2 1069; 2 1071; 2 1073; 2 1075; 2 1077; 2 1079; 2 1081; 2 1083; 2 1085; 2 1087; 2 1089; 2 1091; 2 1093; 2 1095; 2 1097; 2 1099; 2 1101; 2 1103; 2 1105; 3 170; 3 174; 3 330; 3 334; 3 1018; 3 1022; 3 1242; 3 1246; 4 171; 4 175; 4 331; 4 335; 4 1019; 4 1023; 4 1243; 4 1247; 5 172; 5 176; 5 332; 5 336; 5 1020; 5 1024; 5 1244; 5 1248; 6 173; 6 177; 6 333; 6 337; 6 1021; 6 1025; 6 1245; 6 1249; 7 178; 7 214; 7 326; 7 338; 7 1014; 7 1026; 7 1238; 7 1250; 8 179; 8 215; 8 327; 8 339; 8 1015; 8 1027; 8 1239; 8 1251; 9 180; 9 216; 9 328; 9 340; 9 1016; 9 1028; 9 1240; 9 1252; 10 181; 10 217; 10 329; 10 341; 10 1017; 10 1029; 10 1241; 10 1253; 11 182; 11 210; 11 322; 11 342; 11 1010; 11 1030; 11 1234; 11 1254; 12 183; 12 211; 12 323; 12 343; 12 1011; 12 1031; 12 1235; 12 1255; 13 184; 13 212; 13 324; 13 344; 13 1012; 13 1032; 13 1236; 13 1256; 14 185; 14 213; 14 325; 14 345; 14 1013; 14 1033; 14 1237; 14 1257; 15 186; 15 206; 15 318; 15 346; 15 1034; 15 1054; 15 1230; 15 1258; 16 187; 16 207; 16 319; 16 347; 16 1035; 16 1055; 16 1231; 16 1259; 17 188; 17 208; 17 320; 17 348; 17 1036; 17 1056; 17 1232; 17 1260; 18 189; 18 209; 18 321; 18 349; 18 1037; 18 1057; 18 1233; 18 1261; 19 190; 19 202; 19 314; 19 350; 19 1038; 19 1050; 19 1226; 19 1262; 20 191; 20 203; 20 315; 20 351; 20 1039; 20 1051; 20 1227; 20 1263; 21 192; 21 204; 21 316; 21 352; 21 1040; 21 1052; 21 1228; 21 1264; 22 193; 22 205; 22 317; 22 353; 22 1041; 22 1053; 22 1229; 22 1265; 23 194; 23 198; 23 354; 23 358; 23 1042; 23 1046; 23 1266; 23 1270; 24 195; 24 199; 24 355; 24 359; 24 1043; 24 1047; 24 1267; 24 1271; 25 196; 25 200; 25 356; 25 360; 25 1044; 25 1048; 25 1268; 25 1272; 26 197; 26 201; 26 357; 26 361; 26 1045; 26 1049; 26 1269; 26 1273; 27 31; 27 35; 27 51; 27 146; 27 150; 27 498; 27 502; 27 882; 27 886; 27 1162; 27 1166; 27 1282; 27 1286; 27 1546; 27 1550; 28 32; 28 36; 28 52; 28 147; 28 151; 28 499; 28 503; 28 883; 28 887; 28 1163; 28 1167; 28 1283; 28 1287; 28 1547; 28 1551; 29 33; 29 37; 29 53; 29 148; 29 152; 29 500; 29 504; 29 884; 29 888; 29 1164; 29 1168; 29 1284; 29 1288; 29 1548; 29 1552; 30 34; 30 38; 30 54; 30 149; 30 153; 30 501; 30 505; 30 885; 30 889; 30 1165; 30 1169; 30 1285; 30 1289; 30 1549; 30 1553; 31 39; 31 55; 31 146; 31 154; 31 458; 31 494; 31 842; 31 878; 31 1158; 31 1170; 31 1278; 31 1290; 31 1542; 31 1554; 32 40; 32 56; 32 147; 32 155; 32 459; 32 495; 32 843; 32 879; 32 1159; 32 1171; 32 1279; 32 1291; 32 1543; 32 1555; 33 41; 33 57; 33 148; 33 156; 33 460; 33 496; 33 844; 33 880; 33 1160; 33 1172; 33 1280; 33 1292; 33 1544; 33 1556; 34 42; 34 58; 34 149; 34 157; 34 461; 34 497; 34 845; 34 881; 34 1161; 34 1173; 34 1281; 34 1293; 34 1545; 34 1557; 35 43; 35 59; 35 150; 35 158; 35 462; 35 490; 35 846; 35 874; 35 1154; 35 1174; 35 1274; 35 1294; 35 1538; 35 1558; 36 44; 36 60; 36 151; 36 159; 36 463; 36 491; 36 847; 36 875; 36 1155; 36 1175; 36 1275; 36 1295; 36 1539; 36 1559; 37 45; 37 61; 37 152; 37 160; 37 464; 37 492; 37 848; 37 876; 37 1156; 37 1176; 37 1276; 37 1296; 37 1540; 37 1560; 38 46; 38 62; 38 153; 38 161; 38 465; 38 493; 38 849; 38 877; 38 1157; 38 1177; 38 1277; 38 1297; 38 1541; 38 1561; 39 47; 39 63; 39 154; 39 162; 39 466; 39 486; 39 850; 39 870; 39 1178; 39 1198; 39 1298; 39 1318; 39 1562; 39 1582; 40 48; 40 64; 40 155; 40 163; 40 467; 40 487; 40 851; 40 871; 40 1179; 40 1199; 40 1299; 40 1319; 40 1563; 40 1583; 41 49; 41 65; 41 156; 41 164; 41 468; 41 488; 41 852; 41 872; 41 1180; 41 1200; 41 1300; 41 1320; 41 1564; 41 1584; 42 50; 42 66; 42 157; 42 165; 42 469; 42 489; 42 853; 42 873; 42 1181; 42 1201; 42 1301; 42 1321; 42 1565; 42 1585; 43 47; 43 67; 43 158; 43 166; 43 470; 43 482; 43 854; 43 866; 43 1182; 43 1194; 43 1302; 43 1314; 43 1566; 43 1578; 44 48; 44 68; 44 159; 44 167; 44 471; 44 483; 44 855; 44 867; 44 1183; 44 1195; 44 1303; 44 1315; 44 1567; 44 1579; 45 49; 45 69; 45 160; 45 168; 45 472; 45 484; 45 856; 45 868; 45 1184; 45 1196; 45 1304; 45 1316; 45 1568; 45 1580; 46 50; 46 70; 46 161; 46 169; 46 473; 46 485; 46 857; 46 869; 46 1185; 46 1197; 46 1305; 46 1317; 46 1569; 46 1581; 47 71; 47 162; 47 166; 47 474; 47 478; 47 858; 47 862; 47 1186; 47 1190; 47 1306; 47 1310; 47 1570; 47 1574; 48 71; 48 163; 48 167; 48 475; 48 479; 48 859; 48 863; 48 1187; 48 1191; 48 1307; 48 1311; 48 1571; 48 1575; 49 72; 49 164; 49 168; 49 476; 49 480; 49 860; 49 864; 49 1188; 49 1192; 49 1308; 49 1312; 49 1572; 49 1576; 50 73; 50 165; 50 169; 50 477; 50 481; 50 861; 50 865; 50 1189; 50 1193; 50 1309; 50 1313; 50 1573; 50 1577; 51 52; 51 53; 51 146; 51 150; 51 170; 51 174; 52 54; 52 147; 52 151; 52 171; 52 175; 53 148; 53 152; 53 172; 53 176; 54 149; 54 153; 54 173; 54 177; 55 57; 55 146; 55 154; 55 178; 55 214; 56 58; 56 147; 56 155; 56 179; 56 215; 57 148; 57 156; 57 180; 57 216; 58 149; 58 157; 58 181; 58 217; 59 61; 59 150; 59 158; 59 182; 59 210; 60 62; 60 151; 60 159; 60 183; 60 211; 61 152; 61 160; 61 184; 61 212; 62 153; 62 161; 62 185; 62 213; 63 65; 63 154; 63 162; 63 186; 63 206; 64 66; 64 155; 64 163; 64 187; 64 207; 65 156; 65 164; 65 188; 65 208; 66 157; 66 165; 66 189; 66 209; 67 69; 67 158; 67 166; 67 190; 67 202; 68 70; 68 159; 68 167; 68 191; 68 203; 69 160; 69 168; 69 192; 69 204; 70 161; 70 169; 70 193; 70 205; 71 72; 71 73; 71 162; 71 163; 71 166; 71 167; 71 194; 71 195; 71 198; 71 199; 72 164; 72 168; 72 196; 72 200; 73 165; 73 169; 73 197; 73 201; 74 114; 74 118; 74 418; 74 422; 74 930; 74 934; 74 1018; 74 1022; 74 1186; 74 1190; 74 1426; 74 1430; 74 1506; 74 1510; 75 115; 75 119; 75 419; 75 423; 75 931; 75 935; 75 1019; 75 1023; 75 1187; 75 1191; 75 1427; 75 1431; 75 1507; 75 1511; 76 116; 76 120; 76 420; 76 424; 76 932; 76 936; 76 1020; 76 1024; 76 1188; 76 1192; 76 1428; 76 1432; 76 1508; 76 1512; 77 117; 77 121; 77 421; 77 425; 77 933; 77 937; 77 1021; 77 1025; 77 1189; 77 1193; 77 1429; 77 1433; 77 1509; 77 1513; 78 110; 78 118; 78 414; 78 426; 78 890; 78 926; 78 1014; 78 1026; 78 1182; 78 1194; 78 1422; 78 1434; 78 1502; 78 1514; 79 111; 79 119; 79 415; 79 427; 79 891; 79 927; 79 1015; 79 1027; 79 1183; 79 1195; 79 1423; 79 1435; 79 1503; 79 1515; 80 112; 80 120; 80 416; 80 428; 80 892; 80 928; 80 1016; 80 1028; 80 1184; 80 1196; 80 1424; 80 1436; 80 1504; 80 1516; 81 113; 81 121; 81 417; 81 429; 81 893; 81 929; 81 1017; 81 1029; 81 1185; 81 1197; 81 1425; 81 1437; 81 1505; 81 1517; 82 106; 82 114; 82 410; 82 430; 82 894; 82 922; 82 1010; 82 1030; 82 1178; 82 1198; 82 1418; 82 1438; 82 1498; 82 1518; 83 107; 83 115; 83 411; 83 431; 83 895; 83 923; 83 1011; 83 1031; 83 1179; 83 1199; 83 1419; 83 1439; 83 1499; 83 1519; 84 108; 84 116; 84 412; 84 432; 84 896; 84 924; 84 1012; 84 1032; 84 1180; 84 1200; 84 1420; 84 1440; 84 1500; 84 1520; 85 109; 85 117; 85 413; 85 433; 85 897; 85 925; 85 1013; 85 1033; 85 1181; 85 1201; 85 1421; 85 1441; 85 1501; 85 1521; 86 102; 86 110; 86 434; 86 454; 86 898; 86 918; 86 1034; 86 1054; 86 1154; 86 1174; 86 1394; 86 1414; 86 1494; 86 1522; 87 103; 87 111; 87 435; 87 455; 87 899; 87 919; 87 1035; 87 1055; 87 1155; 87 1175; 87 1395; 87 1415; 87 1495; 87 1523; 88 104; 88 112; 88 436; 88 456; 88 900; 88 920; 88 1036; 88 1056; 88 1156; 88 1176; 88 1396; 88 1416; 88 1496; 88 1524; 89 105; 89 113; 89 437; 89 457; 89 901; 89 921; 89 1037; 89 1057; 89 1157; 89 1177; 89 1397; 89 1417; 89 1497; 89 1525; 90 98; 90 106; 90 438; 90 450; 90 902; 90 914; 90 1038; 90 1050; 90 1158; 90 1170; 90 1398; 90 1410; 90 1490; 90 1526; 91 99; 91 107; 91 439; 91 451; 91 903; 91 915; 91 1039; 91 1051; 91 1159; 91 1171; 91 1399; 91 1411; 91 1491; 91 1527; 92 100; 92 108; 92 440; 92 452; 92 904; 92 916; 92 1040; 92 1052; 92 1160; 92 1172; 92 1400; 92 1412; 92 1492; 92 1528; 93 101; 93 109; 93 441; 93 453; 93 905; 93 917; 93 1041; 93 1053; 93 1161; 93 1173; 93 1401; 93 1413; 93 1493; 93 1529; 94 98; 94 102; 94 442; 94 446; 94 906; 94 910; 94 1042; 94 1046; 94 1162; 94 1166; 94 1402; 94 1406; 94 1530; 94 1534; 95 99; 95 103; 95 443; 95 447; 95 907; 95 911; 95 1043; 95 1047; 95 1163; 95 1167; 95 1403; 95 1407; 95 1531; 95 1535; 96 100; 96 104; 96 444; 96 448; 96 908; 96 912; 96 1044; 96 1048; 96 1164; 96 1168; 96 1404; 96 1408; 96 1532; 96 1536; 97 101; 97 105; 97 445; 97 449; 97 909; 97 913; 97 1045; 97 1049; 97 1165; 97 1169; 97 1405; 97 1409; 97 1533; 97 1537; 98 110; 98 114; 98 126; 98 130; 98 302; 98 306; 98 446; 98 450; 98 458; 98 502; 98 894; 98 898; 98 1142; 98 1146; 98 1166; 98 1170; 98 1342; 98 1346; 99 111; 99 115; 99 127; 99 131; 99 303; 99 307; 99 447; 99 451; 99 459; 99 503; 99 895; 99 899; 99 1143; 99 1147; 99 1167; 99 1171; 99 1343; 99 1347; 100 112; 100 116; 100 128; 100 132; 100 304; 100 308; 100 448; 100 452; 100 460; 100 504; 100 896; 100 900; 100 1144; 100 1148; 100 1168; 100 1172; 100 1344; 100 1348; 101 113; 101 117; 101 129; 101 133; 101 305; 101 309; 101 449; 101 453; 101 461; 101 505; 101 897; 101 901; 101 1145; 101 1149; 101 1169; 101 1173; 101 1345; 101 1349; 102 106; 102 118; 102 122; 102 134; 102 298; 102 310; 102 442; 102 454; 102 462; 102 498; 102 890; 102 902; 102 1138; 102 1150; 102 1162; 102 1174; 102 1338; 102 1350; 103 107; 103 119; 103 123; 103 135; 103 299; 103 311; 103 443; 103 455; 103 463; 103 499; 103 891; 103 903; 103 1139; 103 1151; 103 1163; 103 1175; 103 1339; 103 1351; 104 108; 104 120; 104 124; 104 136; 104 300; 104 312; 104 444; 104 456; 104 464; 104 500; 104 892; 104 904; 104 1140; 104 1152; 104 1164; 104 1176; 104 1340; 104 1352; 105 109; 105 121; 105 125; 105 137; 105 301; 105 313; 105 445; 105 457; 105 465; 105 501; 105 893; 105 905; 105 1141; 105 1153; 105 1165; 105 1177; 105 1341; 105 1353; 106 118; 106 122; 106 138; 106 266; 106 294; 106 410; 106 438; 106 466; 106 494; 106 906; 106 934; 106 1106; 106 1134; 106 1158; 106 1178; 106 1334; 106 1354; 107 119; 107 123; 107 139; 107 267; 107 295; 107 411; 107 439; 107 467; 107 495; 107 907; 107 935; 107 1107; 107 1135; 107 1159; 107 1179; 107 1335; 107 1355; 108 120; 108 124; 108 140; 108 268; 108 296; 108 412; 108 440; 108 468; 108 496; 108 908; 108 936; 108 1108; 108 1136; 108 1160; 108 1180; 108 1336; 108 1356; 109 121; 109 125; 109 141; 109 269; 109 297; 109 413; 109 441; 109 469; 109 497; 109 909; 109 937; 109 1109; 109 1137; 109 1161; 109 1181; 109 1337; 109 1357; 110 114; 110 126; 110 142; 110 270; 110 290; 110 414; 110 434; 110 470; 110 490; 110 910; 110 930; 110 1110; 110 1130; 110 1154; 110 1182; 110 1330; 110 1358; 111 115; 111 127; 111 143; 111 271; 111 291; 111 415; 111 435; 111 471; 111 491; 111 911; 111 931; 111 1111; 111 1131; 111 1155; 111 1183; 111 1331; 111 1359; 112 116; 112 128; 112 144; 112 272; 112 292; 112 416; 112 436; 112 472; 112 492; 112 912; 112 932; 112 1112; 112 1132; 112 1156; 112 1184; 112 1332; 112 1360; 113 117; 113 129; 113 145; 113 273; 113 293; 113 417; 113 437; 113 473; 113 493; 113 913; 113 933; 113 1113; 113 1133; 113 1157; 113 1185; 113 1333; 113 1361; 114 130; 114 142; 114 274; 114 286; 114 418; 114 430; 114 474; 114 486; 114 914; 114 926; 114 1114; 114 1126; 114 1186; 114 1198; 114 1326; 114 1362; 115 131; 115 143; 115 275; 115 287; 115 419; 115 431; 115 475; 115 487; 115 915; 115 927; 115 1115; 115 1127; 115 1187; 115 1199; 115 1327; 115 1363; 116 132; 116 144; 116 276; 116 288; 116 420; 116 432; 116 476; 116 488; 116 916; 116 928; 116 1116; 116 1128; 116 1188; 116 1200; 116 1328; 116 1364; 117 133; 117 145; 117 277; 117 289; 117 421; 117 433; 117 477; 117 489; 117 917; 117 929; 117 1117; 117 1129; 117 1189; 117 1201; 117 1329; 117 1365; 118 134; 118 138; 118 278; 118 282; 118 422; 118 426; 118 478; 118 482; 118 918; 118 922; 118 1118; 118 1122; 118 1190; 118 1194; 118 1322; 118 1366; 119 135; 119 139; 119 279; 119 283; 119 423; 119 427; 119 479; 119 483; 119 919; 119 923; 119 1119; 119 1123; 119 1191; 119 1195; 119 1323; 119 1367; 120 136; 120 140; 120 280; 120 284; 120 424; 120 428; 120 480; 120 484; 120 920; 120 924; 120 1120; 120 1124; 120 1192; 120 1196; 120 1324; 120 1368; 121 137; 121 141; 121 281; 121 285; 121 425; 121 429; 121 481; 121 485; 121 921; 121 925; 121 1121; 121 1125; 121 1193; 121 1197; 121 1325; 121 1369; 122 218; 122 262; 122 894; 122 898; 122 966; 122 970; 122 1398; 122 1402; 123 219; 123 263; 123 895; 123 899; 123 967; 123 971; 123 1399; 123 1403; 124 220; 124 264; 124 896; 124 900; 124 968; 124 972; 124 1400; 124 1404; 125 221; 125 265; 125 897; 125 901; 125 969; 125 973; 125 1401; 125 1405; 126 222; 126 258; 126 890; 126 902; 126 962; 126 974; 126 1394; 126 1406; 127 223; 127 259; 127 891; 127 903; 127 963; 127 975; 127 1395; 127 1407; 128 224; 128 260; 128 892; 128 904; 128 964; 128 976; 128 1396; 128 1408; 129 225; 129 261; 129 893; 129 905; 129 965; 129 977; 129 1397; 129 1409; 130 226; 130 254; 130 906; 130 934; 130 978; 130 1006; 130 1410; 130 1438; 131 227; 131 255; 131 907; 131 935; 131 979; 131 1007; 131 1411; 131 1439; 132 228; 132 256; 132 908; 132 936; 132 980; 132 1008; 132 1412; 132 1440; 133 229; 133 257; 133 909; 133 937; 133 981; 133 1009; 133 1413; 133 1441; 134 230; 134 250; 134 910; 134 930; 134 982; 134 1002; 134 1414; 134 1434; 135 231; 135 251; 135 911; 135 931; 135 983; 135 1003; 135 1415; 135 1435; 136 232; 136 252; 136 912; 136 932; 136 984; 136 1004; 136 1416; 136 1436; 137 233; 137 253; 137 913; 137 933; 137 985; 137 1005; 137 1417; 137 1437; 138 234; 138 246; 138 914; 138 926; 138 986; 138 998; 138 1418; 138 1430; 139 235; 139 247; 139 915; 139 927; 139 987; 139 999; 139 1419; 139 1431; 140 236; 140 248; 140 916; 140 928; 140 988; 140 1000; 140 1420; 140 1432; 141 237; 141 249; 141 917; 141 929; 141 989; 141 1001; 141 1421; 141 1433; 142 238; 142 242; 142 918; 142 922; 142 990; 142 994; 142 1422; 142 1426; 143 239; 143 243; 143 919; 143 923; 143 991; 143 995; 143 1423; 143 1427; 144 240; 144 244; 144 920; 144 924; 144 992; 144 996; 144 1424; 144 1428; 145 241; 145 245; 145 921; 145 925; 145 993; 145 997; 145 1425; 145 1429; 146 362; 146 406; 146 798; 146 802; 146 1442; 146 1486; 147 363; 147 407; 147 799; 147 803; 147 1443; 147 1487; 148 364; 148 408; 148 800; 148 804; 148 1444; 148 1488; 149 365; 149 409; 149 801; 149 805; 149 1445; 149 1489; 150 366; 150 402; 150 794; 150 806; 150 1446; 150 1482; 151 367; 151 403; 151 795; 151 807; 151 1447; 151 1483; 152 368; 152 404; 152 796; 152 808; 152 1448; 152 1484; 153 369; 153 405; 153 797; 153 809; 153 1449; 153 1485; 154 370; 154 398; 154 810; 154 838; 154 1450; 154 1478; 155 371; 155 399; 155 811; 155 839; 155 1451; 155 1479; 156 372; 156 400; 156 812; 156 840; 156 1452; 156 1480; 157 373; 157 401; 157 813; 157 841; 157 1453; 157 1481; 158 374; 158 394; 158 814; 158 834; 158 1454; 158 1474; 159 375; 159 395; 159 815; 159 835; 159 1455; 159 1475; 160 376; 160 396; 160 816; 160 836; 160 1456; 160 1476; 161 377; 161 397; 161 817; 161 837; 161 1457; 161 1477; 162 378; 162 390; 162 818; 162 830; 162 1458; 162 1470; 163 379; 163 391; 163 819; 163 831; 163 1459; 163 1471; 164 380; 164 392; 164 820; 164 832; 164 1460; 164 1472; 165 381; 165 393; 165 821; 165 833; 165 1461; 165 1473; 166 382; 166 386; 166 822; 166 826; 166 1462; 166 1466; 167 383; 167 387; 167 823; 167 827; 167 1463; 167 1467; 168 384; 168 388; 168 824; 168 828; 168 1464; 168 1468; 169 385; 169 389; 169 825; 169 829; 169 1465; 169 1469; 170 366; 170 610; 170 802; 170 846; 170 1282; 170 1542; 171 367; 171 611; 171 803; 171 847; 171 1283; 171 1543; 172 368; 172 612; 172 804; 172 848; 172 1284; 172 1544; 173 369; 173 613; 173 805; 173 849; 173 1285; 173 1545; 174 362; 174 614; 174 806; 174 842; 174 1286; 174 1538; 175 363; 175 615; 175 807; 175 843; 175 1287; 175 1539; 176 364; 176 616; 176 808; 176 844; 176 1288; 176 1540; 177 365; 177 617; 177 809; 177 845; 177 1289; 177 1541; 178 406; 178 618; 178 810; 178 886; 178 1290; 178 1582; 179 407; 179 619; 179 811; 179 887; 179 1291; 179 1583; 180 408; 180 620; 180 812; 180 888; 180 1292; 180 1584; 181 409; 181 621; 181 813; 181 889; 181 1293; 181 1585; 182 402; 182 622; 182 814; 182 882; 182 1294; 182 1578; 183 403; 183 623; 183 815; 183 883; 183 1295; 183 1579; 184 404; 184 624; 184 816; 184 884; 184 1296; 184 1580; 185 405; 185 625; 185 817; 185 885; 185 1297; 185 1581; 186 398; 186 626; 186 818; 186 878; 186 1298; 186 1574; 187 399; 187 627; 187 819; 187 879; 187 1299; 187 1575; 188 400; 188 628; 188 820; 188 880; 188 1300; 188 1576; 189 401; 189 629; 189 821; 189 881; 189 1301; 189 1577; 190 394; 190 630; 190 822; 190 874; 190 1302; 190 1570; 191 395; 191 631; 191 823; 191 875; 191 1303; 191 1571; 192 396; 192 632; 192 824; 192 876; 192 1304; 192 1572; 193 397; 193 633; 193 825; 193 877; 193 1305; 193 1573; 194 390; 194 634; 194 826; 194 870; 194 1306; 194 1566; 195 391; 195 635; 195 827; 195 871; 195 1307; 195 1567; 196 392; 196 636; 196 828; 196 872; 196 1308; 196 1568; 197 393; 197 637; 197 829; 197 873; 197 1309; 197 1569; 198 386; 198 638; 198 830; 198 866; 198 1310; 198 1562; 199 387; 199 639; 199 831; 199 867; 199 1311; 199 1563; 200 388; 200 640; 200 832; 200 868; 200 1312; 200 1564; 201 389; 201 641; 201 833; 201 869; 201 1313; 201 1565; 202 382; 202 642; 202 834; 202 862; 202 1314; 202 1558; 203 383; 203 643; 203 835; 203 863; 203 1315; 203 1559; 204 384; 204 644; 204 836; 204 864; 204 1316; 204 1560; 205 385; 205 645; 205 837; 205 865; 205 1317; 205 1561; 206 378; 206 646; 206 838; 206 858; 206 1318; 206 1554; 207 379; 207 647; 207 839; 207 859; 207 1319; 207 1555; 208 380; 208 648; 208 840; 208 860; 208 1320; 208 1556; 209 381; 209 649; 209 841; 209 861; 209 1321; 209 1557; 210 374; 210 602; 210 794; 210 854; 210 1274; 210 1550; 211 375; 211 603; 211 795; 211 855; 211 1275; 211 1551; 212 376; 212 604; 212 796; 212 856; 212 1276; 212 1552; 213 377; 213 605; 213 797; 213 857; 213 1277; 213 1553; 214 370; 214 606; 214 798; 214 850; 214 1278; 214 1546; 215 371; 215 607; 215 799; 215 851; 215 1279; 215 1547; 216 372; 216 608; 216 800; 216 852; 216 1280; 216 1548; 217 373; 217 609; 217 801; 217 853; 217 1281; 217 1549; 218 294; 218 422; 218 506; 218 574; 218 582; 218 606; 218 674; 218 966; 218 1006; 218 1018; 218 1050; 218 1094; 218 1122; 218 1138; 218 1222; 218 1410; 219 295; 219 423; 219 507; 219 575; 219 583; 219 607; 219 675; 219 967; 219 1007; 219 1019; 219 1051; 219 1095; 219 1123; 219 1139; 219 1223; 219 1411; 220 296; 220 424; 220 508; 220 576; 220 584; 220 608; 220 676; 220 968; 220 1008; 220 1020; 220 1052; 220 1096; 220 1124; 220 1140; 220 1224; 220 1412; 221 297; 221 425; 221 509; 221 577; 221 585; 221 609; 221 677; 221 969; 221 1009; 221 1021; 221 1053; 221 1097; 221 1125; 221 1141; 221 1225; 221 1413; 222 290; 222 418; 222 510; 222 570; 222 578; 222 602; 222 678; 222 962; 222 1002; 222 1022; 222 1054; 222 1090; 222 1126; 222 1142; 222 1218; 222 1414; 223 291; 223 419; 223 511; 223 571; 223 579; 223 603; 223 679; 223 963; 223 1003; 223 1023; 223 1055; 223 1091; 223 1127; 223 1143; 223 1219; 223 1415; 224 292; 224 420; 224 512; 224 572; 224 580; 224 604; 224 680; 224 964; 224 1004; 224 1024; 224 1056; 224 1092; 224 1128; 224 1144; 224 1220; 224 1416; 225 293; 225 421; 225 513; 225 573; 225 581; 225 605; 225 681; 225 965; 225 1005; 225 1025; 225 1057; 225 1093; 225 1129; 225 1145; 225 1221; 225 1417; 226 286; 226 414; 226 514; 226 566; 226 574; 226 646; 226 682; 226 998; 226 1006; 226 1010; 226 1026; 226 1086; 226 1130; 226 1146; 226 1214; 226 1418; 227 287; 227 415; 227 515; 227 567; 227 575; 227 647; 227 683; 227 999; 227 1007; 227 1011; 227 1027; 227 1087; 227 1131; 227 1147; 227 1215; 227 1419; 228 288; 228 416; 228 516; 228 568; 228 576; 228 648; 228 684; 228 1000; 228 1008; 228 1012; 228 1028; 228 1088; 228 1132; 228 1148; 228 1216; 228 1420; 229 289; 229 417; 229 517; 229 569; 229 577; 229 649; 229 685; 229 1001; 229 1009; 229 1013; 229 1029; 229 1089; 229 1133; 229 1149; 229 1217; 229 1421; 230 282; 230 410; 230 518; 230 562; 230 570; 230 642; 230 686; 230 994; 230 1002; 230 1014; 230 1030; 230 1082; 230 1134; 230 1150; 230 1210; 230 1422; 231 283; 231 411; 231 519; 231 563; 231 571; 231 643; 231 687; 231 995; 231 1003; 231 1015; 231 1031; 231 1083; 231 1135; 231 1151; 231 1211; 231 1423; 232 284; 232 412; 232 520; 232 564; 232 572; 232 644; 232 688; 232 996; 232 1004; 232 1016; 232 1032; 232 1084; 232 1136; 232 1152; 232 1212; 232 1424; 233 285; 233 413; 233 521; 233 565; 233 573; 233 645; 233 689; 233 997; 233 1005; 233 1017; 233 1033; 233 1085; 233 1137; 233 1153; 233 1213; 233 1425; 234 278; 234 454; 234 522; 234 558; 234 566; 234 638; 234 690; 234 990; 234 998; 234 1018; 234 1034; 234 1078; 234 1106; 234 1138; 234 1206; 234 1426; 235 279; 235 455; 235 523; 235 559; 235 567; 235 639; 235 691; 235 991; 235 999; 235 1019; 235 1035; 235 1079; 235 1107; 235 1139; 235 1207; 235 1427; 236 280; 236 456; 236 524; 236 560; 236 568; 236 640; 236 692; 236 992; 236 1000; 236 1020; 236 1036; 236 1080; 236 1108; 236 1140; 236 1208; 236 1428; 237 281; 237 457; 237 525; 237 561; 237 569; 237 641; 237 693; 237 993; 237 1001; 237 1021; 237 1037; 237 1081; 237 1109; 237 1141; 237 1209; 237 1429; 238 274; 238 450; 238 526; 238 554; 238 562; 238 634; 238 694; 238 986; 238 994; 238 1022; 238 1038; 238 1074; 238 1110; 238 1142; 238 1202; 238 1430; 239 275; 239 451; 239 527; 239 555; 239 563; 239 635; 239 695; 239 987; 239 995; 239 1023; 239 1039; 239 1075; 239 1111; 239 1143; 239 1203; 239 1431; 240 276; 240 452; 240 528; 240 556; 240 564; 240 636; 240 696; 240 988; 240 996; 240 1024; 240 1040; 240 1076; 240 1112; 240 1144; 240 1204; 240 1432; 241 277; 241 453; 241 529; 241 557; 241 565; 241 637; 241 697; 241 989; 241 997; 241 1025; 241 1041; 241 1077; 241 1113; 241 1145; 241 1205; 241 1433; 242 270; 242 446; 242 530; 242 558; 242 598; 242 630; 242 650; 242 982; 242 990; 242 1026; 242 1042; 242 1070; 242 1114; 242 1146; 242 1202; 242 1434; 243 271; 243 447; 243 531; 243 559; 243 599; 243 631; 243 651; 243 983; 243 991; 243 1027; 243 1043; 243 1071; 243 1115; 243 1147; 243 1203; 243 1435; 244 272; 244 448; 244 532; 244 560; 244 600; 244 632; 244 652; 244 984; 244 992; 244 1028; 244 1044; 244 1072; 244 1116; 244 1148; 244 1204; 244 1436; 245 273; 245 449; 245 533; 245 561; 245 601; 245 633; 245 653; 245 985; 245 993; 245 1029; 245 1045; 245 1073; 245 1117; 245 1149; 245 1205; 245 1437; 246 266; 246 442; 246 534; 246 554; 246 594; 246 626; 246 654; 246 978; 246 986; 246 1030; 246 1046; 246 1066; 246 1118; 246 1150; 246 1206; 246 1438; 247 267; 247 443; 247 535; 247 555; 247 595; 247 627; 247 655; 247 979; 247 987; 247 1031; 247 1047; 247 1067; 247 1119; 247 1151; 247 1207; 247 1439; 248 268; 248 444; 248 536; 248 556; 248 596; 248 628; 248 656; 248 980; 248 988; 248 1032; 248 1048; 248 1068; 248 1120; 248 1152; 248 1208; 248 1440; 249 269; 249 445; 249 537; 249 557; 249 597; 249 629; 249 657; 249 981; 249 989; 249 1033; 249 1049; 249 1069; 249 1121; 249 1153; 249 1209; 249 1441; 250 310; 250 438; 250 538; 250 590; 250 598; 250 622; 250 658; 250 974; 250 982; 250 1034; 250 1050; 250 1062; 250 1106; 250 1122; 250 1210; 250 1394; 251 311; 251 439; 251 539; 251 591; 251 599; 251 623; 251 659; 251 975; 251 983; 251 1035; 251 1051; 251 1063; 251 1107; 251 1123; 251 1211; 251 1395; 252 312; 252 440; 252 540; 252 592; 252 600; 252 624; 252 660; 252 976; 252 984; 252 1036; 252 1052; 252 1064; 252 1108; 252 1124; 252 1212; 252 1396; 253 313; 253 441; 253 541; 253 593; 253 601; 253 625; 253 661; 253 977; 253 985; 253 1037; 253 1053; 253 1065; 253 1109; 253 1125; 253 1213; 253 1397; 254 306; 254 434; 254 542; 254 586; 254 594; 254 618; 254 662; 254 970; 254 978; 254 1038; 254 1054; 254 1058; 254 1110; 254 1126; 254 1214; 254 1398; 255 307; 255 435; 255 543; 255 587; 255 595; 255 619; 255 663; 255 971; 255 979; 255 1039; 255 1055; 255 1059; 255 1111; 255 1127; 255 1215; 255 1399; 256 308; 256 436; 256 544; 256 588; 256 596; 256 620; 256 664; 256 972; 256 980; 256 1040; 256 1056; 256 1060; 256 1112; 256 1128; 256 1216; 256 1400; 257 309; 257 437; 257 545; 257 589; 257 597; 257 621; 257 665; 257 973; 257 981; 257 1041; 257 1057; 257 1061; 257 1113; 257 1129; 257 1217; 257 1401; 258 302; 258 430; 258 546; 258 582; 258 590; 258 614; 258 666; 258 966; 258 974; 258 1010; 258 1042; 258 1102; 258 1114; 258 1130; 258 1218; 258 1402; 259 303; 259 431; 259 547; 259 583; 259 591; 259 615; 259 667; 259 967; 259 975; 259 1011; 259 1043; 259 1103; 259 1115; 259 1131; 259 1219; 259 1403; 260 304; 260 432; 260 548; 260 584; 260 592; 260 616; 260 668; 260 968; 260 976; 260 1012; 260 1044; 260 1104; 260 1116; 260 1132; 260 1220; 260 1404; 261 305; 261 433; 261 549; 261 585; 261 593; 261 617; 261 669; 261 969; 261 977; 261 1013; 261 1045; 261 1105; 261 1117; 261 1133; 261 1221; 261 1405; 262 298; 262 426; 262 550; 262 578; 262 586; 262 610; 262 670; 262 962; 262 970; 262 1014; 262 1046; 262 1098; 262 1118; 262 1134; 262 1222; 262 1406; 263 299; 263 427; 263 551; 263 579; 263 587; 263 611; 263 671; 263 963; 263 971; 263 1015; 263 1047; 263 1099; 263 1119; 263 1135; 263 1223; 263 1407; 264 300; 264 428; 264 552; 264 580; 264 588; 264 612; 264 672; 264 964; 264 972; 264 1016; 264 1048; 264 1100; 264 1120; 264 1136; 264 1224; 264 1408; 265 301; 265 429; 265 553; 265 581; 265 589; 265 613; 265 673; 265 965; 265 973; 265 1017; 265 1049; 265 1101; 265 1121; 265 1137; 265 1225; 265 1409; 266 322; 266 778; 266 886; 266 1118; 266 1354; 267 323; 267 779; 267 887; 267 1119; 267 1355; 268 324; 268 780; 268 888; 268 1120; 268 1356; 269 325; 269 781; 269 889; 269 1121; 269 1357; 270 326; 270 782; 270 882; 270 1114; 270 1358; 271 327; 271 783; 271 883; 271 1115; 271 1359; 272 328; 272 784; 272 884; 272 1116; 272 1360; 273 329; 273 785; 273 885; 273 1117; 273 1361; 274 330; 274 786; 274 878; 274 1110; 274 1362; 275 331; 275 787; 275 879; 275 1111; 275 1363; 276 332; 276 788; 276 880; 276 1112; 276 1364; 277 333; 277 789; 277 881; 277 1113; 277 1365; 278 334; 278 790; 278 874; 278 1106; 278 1366; 279 335; 279 791; 279 875; 279 1107; 279 1367; 280 336; 280 792; 280 876; 280 1108; 280 1368; 281 337; 281 793; 281 877; 281 1109; 281 1369; 282 338; 282 746; 282 870; 282 1150; 282 1322; 283 339; 283 747; 283 871; 283 1151; 283 1323; 284 340; 284 748; 284 872; 284 1152; 284 1324; 285 341; 285 749; 285 873; 285 1153; 285 1325; 286 342; 286 750; 286 866; 286 1146; 286 1326; 287 343; 287 751; 287 867; 287 1147; 287 1327; 288 344; 288 752; 288 868; 288 1148; 288 1328; 289 345; 289 753; 289 869; 289 1149; 289 1329; 290 346; 290 754; 290 862; 290 1142; 290 1330; 291 347; 291 755; 291 863; 291 1143; 291 1331; 292 348; 292 756; 292 864; 292 1144; 292 1332; 293 349; 293 757; 293 865; 293 1145; 293 1333; 294 350; 294 758; 294 858; 294 1138; 294 1334; 295 351; 295 759; 295 859; 295 1139; 295 1335; 296 352; 296 760; 296 860; 296 1140; 296 1336; 297 353; 297 761; 297 861; 297 1141; 297 1337; 298 354; 298 762; 298 854; 298 1134; 298 1338; 299 355; 299 763; 299 855; 299 1135; 299 1339; 300 356; 300 764; 300 856; 300 1136; 300 1340; 301 357; 301 765; 301 857; 301 1137; 301 1341; 302 358; 302 766; 302 850; 302 1130; 302 1342; 303 359; 303 767; 303 851; 303 1131; 303 1343; 304 360; 304 768; 304 852; 304 1132; 304 1344; 305 361; 305 769; 305 853; 305 1133; 305 1345; 306 314; 306 770; 306 846; 306 1126; 306 1346; 307 315; 307 771; 307 847; 307 1127; 307 1347; 308 316; 308 772; 308 848; 308 1128; 308 1348; 309 317; 309 773; 309 849; 309 1129; 309 1349; 310 318; 310 774; 310 842; 310 1122; 310 1350; 311 319; 311 775; 311 843; 311 1123; 311 1351; 312 320; 312 776; 312 844; 312 1124; 312 1352; 313 321; 313 777; 313 845; 313 1125; 313 1353; 314 686; 314 734; 314 770; 314 846; 314 970; 314 1002; 314 1262; 314 1338; 314 1354; 314 1502; 315 687; 315 735; 315 771; 315 847; 315 971; 315 1003; 315 1263; 315 1339; 315 1355; 315 1503; 316 688; 316 736; 316 772; 316 848; 316 972; 316 1004; 316 1264; 316 1340; 316 1356; 316 1504; 317 689; 317 737; 317 773; 317 849; 317 973; 317 1005; 317 1265; 317 1341; 317 1357; 317 1505; 318 682; 318 730; 318 774; 318 842; 318 974; 318 1006; 318 1258; 318 1342; 318 1358; 318 1498; 319 683; 319 731; 319 775; 319 843; 319 975; 319 1007; 319 1259; 319 1343; 319 1359; 319 1499; 320 684; 320 732; 320 776; 320 844; 320 976; 320 1008; 320 1260; 320 1344; 320 1360; 320 1500; 321 685; 321 733; 321 777; 321 845; 321 977; 321 1009; 321 1261; 321 1345; 321 1361; 321 1501; 322 678; 322 726; 322 778; 322 886; 322 962; 322 978; 322 1254; 322 1346; 322 1362; 322 1494; 323 679; 323 727; 323 779; 323 887; 323 963; 323 979; 323 1255; 323 1347; 323 1363; 323 1495; 324 680; 324 728; 324 780; 324 888; 324 964; 324 980; 324 1256; 324 1348; 324 1364; 324 1496; 325 681; 325 729; 325 781; 325 889; 325 965; 325 981; 325 1257; 325 1349; 325 1365; 325 1497; 326 674; 326 722; 326 782; 326 882; 326 966; 326 982; 326 1250; 326 1350; 326 1366; 326 1490; 327 675; 327 723; 327 783; 327 883; 327 967; 327 983; 327 1251; 327 1351; 327 1367; 327 1491; 328 676; 328 724; 328 784; 328 884; 328 968; 328 984; 328 1252; 328 1352; 328 1368; 328 1492; 329 677; 329 725; 329 785; 329 885; 329 969; 329 985; 329 1253; 329 1353; 329 1369; 329 1493; 330 670; 330 718; 330 786; 330 878; 330 970; 330 986; 330 1246; 330 1322; 330 1354; 330 1534; 331 671; 331 719; 331 787; 331 879; 331 971; 331 987; 331 1247; 331 1323; 331 1355; 331 1535; 332 672; 332 720; 332 788; 332 880; 332 972; 332 988; 332 1248; 332 1324; 332 1356; 332 1536; 333 673; 333 721; 333 789; 333 881; 333 973; 333 989; 333 1249; 333 1325; 333 1357; 333 1537; 334 666; 334 714; 334 790; 334 874; 334 974; 334 990; 334 1242; 334 1326; 334 1358; 334 1530; 335 667; 335 715; 335 791; 335 875; 335 975; 335 991; 335 1243; 335 1327; 335 1359; 335 1531; 336 668; 336 716; 336 792; 336 876; 336 976; 336 992; 336 1244; 336 1328; 336 1360; 336 1532; 337 669; 337 717; 337 793; 337 877; 337 977; 337 993; 337 1245; 337 1329; 337 1361; 337 1533; 338 662; 338 710; 338 746; 338 870; 338 978; 338 994; 338 1238; 338 1330; 338 1362; 338 1526; 339 663; 339 711; 339 747; 339 871; 339 979; 339 995; 339 1239; 339 1331; 339 1363; 339 1527; 340 664; 340 712; 340 748; 340 872; 340 980; 340 996; 340 1240; 340 1332; 340 1364; 340 1528; 341 665; 341 713; 341 749; 341 873; 341 981; 341 997; 341 1241; 341 1333; 341 1365; 341 1529; 342 658; 342 706; 342 750; 342 866; 342 982; 342 998; 342 1234; 342 1334; 342 1366; 342 1522; 343 659; 343 707; 343 751; 343 867; 343 983; 343 999; 343 1235; 343 1335; 343 1367; 343 1523; 344 660; 344 708; 344 752; 344 868; 344 984; 344 1000; 344 1236; 344 1336; 344 1368; 344 1524; 345 661; 345 709; 345 753; 345 869; 345 985; 345 1001; 345 1237; 345 1337; 345 1369; 345 1525; 346 654; 346 702; 346 754; 346 862; 346 986; 346 1002; 346 1230; 346 1322; 346 1338; 346 1518; 347 655; 347 703; 347 755; 347 863; 347 987; 347 1003; 347 1231; 347 1323; 347 1339; 347 1519; 348 656; 348 704; 348 756; 348 864; 348 988; 348 1004; 348 1232; 348 1324; 348 1340; 348 1520; 349 657; 349 705; 349 757; 349 865; 349 989; 349 1005; 349 1233; 349 1325; 349 1341; 349 1521; 350 650; 350 698; 350 758; 350 858; 350 990; 350 1006; 350 1226; 350 1326; 350 1342; 350 1514; 351 651; 351 699; 351 759; 351 859; 351 991; 351 1007; 351 1227; 351 1327; 351 1343; 351 1515; 352 652; 352 700; 352 760; 352 860; 352 992; 352 1008; 352 1228; 352 1328; 352 1344; 352 1516; 353 653; 353 701; 353 761; 353 861; 353 993; 353 1009; 353 1229; 353 1329; 353 1345; 353 1517; 354 694; 354 742; 354 762; 354 854; 354 962; 354 994; 354 1270; 354 1330; 354 1346; 354 1510; 355 695; 355 743; 355 763; 355 855; 355 963; 355 995; 355 1271; 355 1331; 355 1347; 355 1511; 356 696; 356 744; 356 764; 356 856; 356 964; 356 996; 356 1272; 356 1332; 356 1348; 356 1512; 357 697; 357 745; 357 765; 357 857; 357 965; 357 997; 357 1273; 357 1333; 357 1349; 357 1513; 358 690; 358 738; 358 766; 358 850; 358 966; 358 998; 358 1266; 358 1334; 358 1350; 358 1506; 359 691; 359 739; 359 767; 359 851; 359 967; 359 999; 359 1267; 359 1335; 359 1351; 359 1507; 360 692; 360 740; 360 768; 360 852; 360 968; 360 1000; 360 1268; 360 1336; 360 1352; 360 1508; 361 693; 361 741; 361 769; 361 853; 361 969; 361 1001; 361 1269; 361 1337; 361 1353; 361 1509; 362 450; 362 766; 362 774; 362 798; 362 838; 362 1094; 362 1286; 362 1390; 362 1478; 362 1554; 363 451; 363 767; 363 775; 363 799; 363 839; 363 1095; 363 1287; 363 1391; 363 1479; 363 1555; 364 452; 364 768; 364 776; 364 800; 364 840; 364 1096; 364 1288; 364 1392; 364 1480; 364 1556; 365 453; 365 769; 365 777; 365 801; 365 841; 365 1097; 365 1289; 365 1393; 365 1481; 365 1557; 366 454; 366 762; 366 770; 366 794; 366 834; 366 1090; 366 1282; 366 1386; 366 1474; 366 1558; 367 455; 367 763; 367 771; 367 795; 367 835; 367 1091; 367 1283; 367 1387; 367 1475; 367 1559; 368 456; 368 764; 368 772; 368 796; 368 836; 368 1092; 368 1284; 368 1388; 368 1476; 368 1560; 369 457; 369 765; 369 773; 369 797; 369 837; 369 1093; 369 1285; 369 1389; 369 1477; 369 1561; 370 410; 370 758; 370 766; 370 830; 370 838; 370 1086; 370 1278; 370 1382; 370 1470; 370 1562; 371 411; 371 759; 371 767; 371 831; 371 839; 371 1087; 371 1279; 371 1383; 371 1471; 371 1563; 372 412; 372 760; 372 768; 372 832; 372 840; 372 1088; 372 1280; 372 1384; 372 1472; 372 1564; 373 413; 373 761; 373 769; 373 833; 373 841; 373 1089; 373 1281; 373 1385; 373 1473; 373 1565; 374 414; 374 754; 374 762; 374 826; 374 834; 374 1082; 374 1274; 374 1378; 374 1466; 374 1566; 375 415; 375 755; 375 763; 375 827; 375 835; 375 1083; 375 1275; 375 1379; 375 1467; 375 1567; 376 416; 376 756; 376 764; 376 828; 376 836; 376 1084; 376 1276; 376 1380; 376 1468; 376 1568; 377 417; 377 757; 377 765; 377 829; 377 837; 377 1085; 377 1277; 377 1381; 377 1469; 377 1569; 378 418; 378 750; 378 758; 378 822; 378 830; 378 1078; 378 1318; 378 1374; 378 1462; 378 1570; 379 419; 379 751; 379 759; 379 823; 379 831; 379 1079; 379 1319; 379 1375; 379 1463; 379 1571; 380 420; 380 752; 380 760; 380 824; 380 832; 380 1080; 380 1320; 380 1376; 380 1464; 380 1572; 381 421; 381 753; 381 761; 381 825; 381 833; 381 1081; 381 1321; 381 1377; 381 1465; 381 1573; 382 422; 382 746; 382 754; 382 818; 382 826; 382 1074; 382 1314; 382 1370; 382 1458; 382 1574; 383 423; 383 747; 383 755; 383 819; 383 827; 383 1075; 383 1315; 383 1371; 383 1459; 383 1575; 384 424; 384 748; 384 756; 384 820; 384 828; 384 1076; 384 1316; 384 1372; 384 1460; 384 1576; 385 425; 385 749; 385 757; 385 821; 385 829; 385 1077; 385 1317; 385 1373; 385 1461; 385 1577; 386 426; 386 750; 386 790; 386 814; 386 822; 386 1070; 386 1310; 386 1370; 386 1454; 386 1578; 387 427; 387 751; 387 791; 387 815; 387 823; 387 1071; 387 1311; 387 1371; 387 1455; 387 1579; 388 428; 388 752; 388 792; 388 816; 388 824; 388 1072; 388 1312; 388 1372; 388 1456; 388 1580; 389 429; 389 753; 389 793; 389 817; 389 825; 389 1073; 389 1313; 389 1373; 389 1457; 389 1581; 390 430; 390 746; 390 786; 390 810; 390 818; 390 1066; 390 1306; 390 1374; 390 1450; 390 1582; 391 431; 391 747; 391 787; 391 811; 391 819; 391 1067; 391 1307; 391 1375; 391 1451; 391 1583; 392 432; 392 748; 392 788; 392 812; 392 820; 392 1068; 392 1308; 392 1376; 392 1452; 392 1584; 393 433; 393 749; 393 789; 393 813; 393 821; 393 1069; 393 1309; 393 1377; 393 1453; 393 1585; 394 434; 394 782; 394 790; 394 806; 394 814; 394 1062; 394 1302; 394 1378; 394 1446; 394 1538; 395 435; 395 783; 395 791; 395 807; 395 815; 395 1063; 395 1303; 395 1379; 395 1447; 395 1539; 396 436; 396 784; 396 792; 396 808; 396 816; 396 1064; 396 1304; 396 1380; 396 1448; 396 1540; 397 437; 397 785; 397 793; 397 809; 397 817; 397 1065; 397 1305; 397 1381; 397 1449; 397 1541; 398 438; 398 778; 398 786; 398 802; 398 810; 398 1058; 398 1298; 398 1382; 398 1442; 398 1542; 399 439; 399 779; 399 787; 399 803; 399 811; 399 1059; 399 1299; 399 1383; 399 1443; 399 1543; 400 440; 400 780; 400 788; 400 804; 400 812; 400 1060; 400 1300; 400 1384; 400 1444; 400 1544; 401 441; 401 781; 401 789; 401 805; 401 813; 401 1061; 401 1301; 401 1385; 401 1445; 401 1545; 402 442; 402 774; 402 782; 402 798; 402 806; 402 1102; 402 1294; 402 1386; 402 1486; 402 1546; 403 443; 403 775; 403 783; 403 799; 403 807; 403 1103; 403 1295; 403 1387; 403 1487; 403 1547; 404 444; 404 776; 404 784; 404 800; 404 808; 404 1104; 404 1296; 404 1388; 404 1488; 404 1548; 405 445; 405 777; 405 785; 405 801; 405 809; 405 1105; 405 1297; 405 1389; 405 1489; 405 1549; 406 446; 406 770; 406 778; 406 794; 406 802; 406 1098; 406 1290; 406 1390; 406 1482; 406 1550; 407 447; 407 771; 407 779; 407 795; 407 803; 407 1099; 407 1291; 407 1391; 407 1483; 407 1551; 408 448; 408 772; 408 780; 408 796; 408 804; 408 1100; 408 1292; 408 1392; 408 1484; 408 1552; 409 449; 409 773; 409 781; 409 797; 409 805; 409 1101; 409 1293; 409 1393; 409 1485; 409 1553; 410 418; 410 450; 410 462; 410 562; 410 758; 410 838; 410 1002; 410 1194; 411 419; 411 451; 411 463; 411 563; 411 759; 411 839; 411 1003; 411 1195; 412 420; 412 452; 412 464; 412 564; 412 760; 412 840; 412 1004; 412 1196; 413 421; 413 453; 413 465; 413 565; 413 761; 413 841; 413 1005; 413 1197; 414 422; 414 454; 414 458; 414 566; 414 754; 414 834; 414 1006; 414 1198; 415 423; 415 455; 415 459; 415 567; 415 755; 415 835; 415 1007; 415 1199; 416 424; 416 456; 416 460; 416 568; 416 756; 416 836; 416 1008; 416 1200; 417 425; 417 457; 417 461; 417 569; 417 757; 417 837; 417 1009; 417 1201; 418 426; 418 502; 418 570; 418 750; 418 830; 418 962; 418 1154; 419 427; 419 503; 419 571; 419 751; 419 831; 419 963; 419 1155; 420 428; 420 504; 420 572; 420 752; 420 832; 420 964; 420 1156; 421 429; 421 505; 421 573; 421 753; 421 833; 421 965; 421 1157; 422 430; 422 498; 422 574; 422 746; 422 826; 422 966; 422 1158; 423 431; 423 499; 423 575; 423 747; 423 827; 423 967; 423 1159; 424 432; 424 500; 424 576; 424 748; 424 828; 424 968; 424 1160; 425 433; 425 501; 425 577; 425 749; 425 829; 425 969; 425 1161; 426 434; 426 494; 426 578; 426 790; 426 822; 426 970; 426 1162; 427 435; 427 495; 427 579; 427 791; 427 823; 427 971; 427 1163; 428 436; 428 496; 428 580; 428 792; 428 824; 428 972; 428 1164; 429 437; 429 497; 429 581; 429 793; 429 825; 429 973; 429 1165; 430 438; 430 490; 430 582; 430 786; 430 818; 430 974; 430 1166; 431 439; 431 491; 431 583; 431 787; 431 819; 431 975; 431 1167; 432 440; 432 492; 432 584; 432 788; 432 820; 432 976; 432 1168; 433 441; 433 493; 433 585; 433 789; 433 821; 433 977; 433 1169; 434 442; 434 486; 434 586; 434 782; 434 814; 434 978; 434 1170; 435 443; 435 487; 435 587; 435 783; 435 815; 435 979; 435 1171; 436 444; 436 488; 436 588; 436 784; 436 816; 436 980; 436 1172; 437 445; 437 489; 437 589; 437 785; 437 817; 437 981; 437 1173; 438 446; 438 482; 438 590; 438 778; 438 810; 438 982; 438 1174; 439 447; 439 483; 439 591; 439 779; 439 811; 439 983; 439 1175; 440 448; 440 484; 440 592; 440 780; 440 812; 440 984; 440 1176; 441 449; 441 485; 441 593; 441 781; 441 813; 441 985; 441 1177; 442 450; 442 478; 442 594; 442 774; 442 806; 442 986; 442 1178; 443 451; 443 479; 443 595; 443 775; 443 807; 443 987; 443 1179; 444 452; 444 480; 444 596; 444 776; 444 808; 444 988; 444 1180; 445 453; 445 481; 445 597; 445 777; 445 809; 445 989; 445 1181; 446 454; 446 474; 446 598; 446 770; 446 802; 446 990; 446 1182; 447 455; 447 475; 447 599; 447 771; 447 803; 447 991; 447 1183; 448 456; 448 476; 448 600; 448 772; 448 804; 448 992; 448 1184; 449 457; 449 477; 449 601; 449 773; 449 805; 449 993; 449 1185; 450 470; 450 554; 450 766; 450 798; 450 994; 450 1186; 451 471; 451 555; 451 767; 451 799; 451 995; 451 1187; 452 472; 452 556; 452 768; 452 800; 452 996; 452 1188; 453 473; 453 557; 453 769; 453 801; 453 997; 453 1189; 454 466; 454 558; 454 762; 454 794; 454 998; 454 1190; 455 467; 455 559; 455 763; 455 795; 455 999; 455 1191; 456 468; 456 560; 456 764; 456 796; 456 1000; 456 1192; 457 469; 457 561; 457 765; 457 797; 457 1001; 457 1193; 458 698; 458 846; 458 894; 458 1158; 458 1198; 458 1274; 459 699; 459 847; 459 895; 459 1159; 459 1199; 459 1275; 460 700; 460 848; 460 896; 460 1160; 460 1200; 460 1276; 461 701; 461 849; 461 897; 461 1161; 461 1201; 461 1277; 462 702; 462 842; 462 890; 462 1154; 462 1194; 462 1278; 463 703; 463 843; 463 891; 463 1155; 463 1195; 463 1279; 464 704; 464 844; 464 892; 464 1156; 464 1196; 464 1280; 465 705; 465 845; 465 893; 465 1157; 465 1197; 465 1281; 466 706; 466 886; 466 934; 466 1190; 466 1198; 466 1282; 467 707; 467 887; 467 935; 467 1191; 467 1199; 467 1283; 468 708; 468 888; 468 936; 468 1192; 468 1200; 468 1284; 469 709; 469 889; 469 937; 469 1193; 469 1201; 469 1285; 470 710; 470 882; 470 930; 470 1186; 470 1194; 470 1286; 471 711; 471 883; 471 931; 471 1187; 471 1195; 471 1287; 472 712; 472 884; 472 932; 472 1188; 472 1196; 472 1288; 473 713; 473 885; 473 933; 473 1189; 473 1197; 473 1289; 474 714; 474 878; 474 926; 474 1182; 474 1190; 474 1290; 475 715; 475 879; 475 927; 475 1183; 475 1191; 475 1291; 476 716; 476 880; 476 928; 476 1184; 476 1192; 476 1292; 477 717; 477 881; 477 929; 477 1185; 477 1193; 477 1293; 478 718; 478 874; 478 922; 478 1178; 478 1186; 478 1294; 479 719; 479 875; 479 923; 479 1179; 479 1187; 479 1295; 480 720; 480 876; 480 924; 480 1180; 480 1188; 480 1296; 481 721; 481 877; 481 925; 481 1181; 481 1189; 481 1297; 482 722; 482 870; 482 918; 482 1174; 482 1182; 482 1298; 483 723; 483 871; 483 919; 483 1175; 483 1183; 483 1299; 484 724; 484 872; 484 920; 484 1176; 484 1184; 484 1300; 485 725; 485 873; 485 921; 485 1177; 485 1185; 485 1301; 486 726; 486 866; 486 914; 486 1170; 486 1178; 486 1302; 487 727; 487 867; 487 915; 487 1171; 487 1179; 487 1303; 488 728; 488 868; 488 916; 488 1172; 488 1180; 488 1304; 489 729; 489 869; 489 917; 489 1173; 489 1181; 489 1305; 490 730; 490 862; 490 910; 490 1166; 490 1174; 490 1306; 491 731; 491 863; 491 911; 491 1167; 491 1175; 491 1307; 492 732; 492 864; 492 912; 492 1168; 492 1176; 492 1308; 493 733; 493 865; 493 913; 493 1169; 493 1177; 493 1309; 494 734; 494 858; 494 906; 494 1162; 494 1170; 494 1310; 495 735; 495 859; 495 907; 495 1163; 495 1171; 495 1311; 496 736; 496 860; 496 908; 496 1164; 496 1172; 496 1312; 497 737; 497 861; 497 909; 497 1165; 497 1173; 497 1313; 498 738; 498 854; 498 902; 498 1158; 498 1166; 498 1314; 499 739; 499 855; 499 903; 499 1159; 499 1167; 499 1315; 500 740; 500 856; 500 904; 500 1160; 500 1168; 500 1316; 501 741; 501 857; 501 905; 501 1161; 501 1169; 501 1317; 502 742; 502 850; 502 898; 502 1154; 502 1162; 502 1318; 503 743; 503 851; 503 899; 503 1155; 503 1163; 503 1319; 504 744; 504 852; 504 900; 504 1156; 504 1164; 504 1320; 505 745; 505 853; 505 901; 505 1157; 505 1165; 505 1321; 506 690; 506 838; 506 1018; 506 1374; 506 1450; 506 1498; 507 691; 507 839; 507 1019; 507 1375; 507 1451; 507 1499; 508 692; 508 840; 508 1020; 508 1376; 508 1452; 508 1500; 509 693; 509 841; 509 1021; 509 1377; 509 1453; 509 1501; 510 694; 510 834; 510 1022; 510 1370; 510 1454; 510 1502; 511 695; 511 835; 511 1023; 511 1371; 511 1455; 511 1503; 512 696; 512 836; 512 1024; 512 1372; 512 1456; 512 1504; 513 697; 513 837; 513 1025; 513 1373; 513 1457; 513 1505; 514 650; 514 830; 514 1026; 514 1370; 514 1458; 514 1506; 515 651; 515 831; 515 1027; 515 1371; 515 1459; 515 1507; 516 652; 516 832; 516 1028; 516 1372; 516 1460; 516 1508; 517 653; 517 833; 517 1029; 517 1373; 517 1461; 517 1509; 518 654; 518 826; 518 1030; 518 1374; 518 1462; 518 1510; 519 655; 519 827; 519 1031; 519 1375; 519 1463; 519 1511; 520 656; 520 828; 520 1032; 520 1376; 520 1464; 520 1512; 521 657; 521 829; 521 1033; 521 1377; 521 1465; 521 1513; 522 658; 522 822; 522 1034; 522 1378; 522 1466; 522 1514; 523 659; 523 823; 523 1035; 523 1379; 523 1467; 523 1515; 524 660; 524 824; 524 1036; 524 1380; 524 1468; 524 1516; 525 661; 525 825; 525 1037; 525 1381; 525 1469; 525 1517; 526 662; 526 818; 526 1038; 526 1382; 526 1470; 526 1518; 527 663; 527 819; 527 1039; 527 1383; 527 1471; 527 1519; 528 664; 528 820; 528 1040; 528 1384; 528 1472; 528 1520; 529 665; 529 821; 529 1041; 529 1385; 529 1473; 529 1521; 530 666; 530 814; 530 1042; 530 1386; 530 1474; 530 1522; 531 667; 531 815; 531 1043; 531 1387; 531 1475; 531 1523; 532 668; 532 816; 532 1044; 532 1388; 532 1476; 532 1524; 533 669; 533 817; 533 1045; 533 1389; 533 1477; 533 1525; 534 670; 534 810; 534 1046; 534 1390; 534 1478; 534 1526; 535 671; 535 811; 535 1047; 535 1391; 535 1479; 535 1527; 536 672; 536 812; 536 1048; 536 1392; 536 1480; 536 1528; 537 673; 537 813; 537 1049; 537 1393; 537 1481; 537 1529; 538 674; 538 806; 538 1050; 538 1390; 538 1482; 538 1530; 539 675; 539 807; 539 1051; 539 1391; 539 1483; 539 1531; 540 676; 540 808; 540 1052; 540 1392; 540 1484; 540 1532; 541 677; 541 809; 541 1053; 541 1393; 541 1485; 541 1533; 542 678; 542 802; 542 1054; 542 1386; 542 1486; 542 1534; 543 679; 543 803; 543 1055; 543 1387; 543 1487; 543 1535; 544 680; 544 804; 544 1056; 544 1388; 544 1488; 544 1536; 545 681; 545 805; 545 1057; 545 1389; 545 1489; 545 1537; 546 682; 546 798; 546 1010; 546 1382; 546 1442; 546 1490; 547 683; 547 799; 547 1011; 547 1383; 547 1443; 547 1491; 548 684; 548 800; 548 1012; 548 1384; 548 1444; 548 1492; 549 685; 549 801; 549 1013; 549 1385; 549 1445; 549 1493; 550 686; 550 794; 550 1014; 550 1378; 550 1446; 550 1494; 551 687; 551 795; 551 1015; 551 1379; 551 1447; 551 1495; 552 688; 552 796; 552 1016; 552 1380; 552 1448; 552 1496; 553 689; 553 797; 553 1017; 553 1381; 553 1449; 553 1497; 554 710; 554 1066; 554 1430; 554 1526; 555 711; 555 1067; 555 1431; 555 1527; 556 712; 556 1068; 556 1432; 556 1528; 557 713; 557 1069; 557 1433; 557 1529; 558 706; 558 1070; 558 1426; 558 1522; 559 707; 559 1071; 559 1427; 559 1523; 560 708; 560 1072; 560 1428; 560 1524; 561 709; 561 1073; 561 1429; 561 1525; 562 702; 562 1074; 562 1422; 562 1518; 563 703; 563 1075; 563 1423; 563 1519; 564 704; 564 1076; 564 1424; 564 1520; 565 705; 565 1077; 565 1425; 565 1521; 566 698; 566 1078; 566 1418; 566 1514; 567 699; 567 1079; 567 1419; 567 1515; 568 700; 568 1080; 568 1420; 568 1516; 569 701; 569 1081; 569 1421; 569 1517; 570 742; 570 1082; 570 1414; 570 1510; 571 743; 571 1083; 571 1415; 571 1511; 572 744; 572 1084; 572 1416; 572 1512; 573 745; 573 1085; 573 1417; 573 1513; 574 738; 574 1086; 574 1410; 574 1506; 575 739; 575 1087; 575 1411; 575 1507; 576 740; 576 1088; 576 1412; 576 1508; 577 741; 577 1089; 577 1413; 577 1509; 578 734; 578 1090; 578 1406; 578 1502; 579 735; 579 1091; 579 1407; 579 1503; 580 736; 580 1092; 580 1408; 580 1504; 581 737; 581 1093; 581 1409; 581 1505; 582 730; 582 1094; 582 1402; 582 1498; 583 731; 583 1095; 583 1403; 583 1499; 584 732; 584 1096; 584 1404; 584 1500; 585 733; 585 1097; 585 1405; 585 1501; 586 726; 586 1098; 586 1398; 586 1494; 587 727; 587 1099; 587 1399; 587 1495; 588 728; 588 1100; 588 1400; 588 1496; 589 729; 589 1101; 589 1401; 589 1497; 590 722; 590 1102; 590 1394; 590 1490; 591 723; 591 1103; 591 1395; 591 1491; 592 724; 592 1104; 592 1396; 592 1492; 593 725; 593 1105; 593 1397; 593 1493; 594 718; 594 1058; 594 1438; 594 1534; 595 719; 595 1059; 595 1439; 595 1535; 596 720; 596 1060; 596 1440; 596 1536; 597 721; 597 1061; 597 1441; 597 1537; 598 714; 598 1062; 598 1434; 598 1530; 599 715; 599 1063; 599 1435; 599 1531; 600 716; 600 1064; 600 1436; 600 1532; 601 717; 601 1065; 601 1437; 601 1533; 602 754; 602 1002; 602 1234; 602 1282; 602 1314; 603 755; 603 1003; 603 1235; 603 1283; 603 1315; 604 756; 604 1004; 604 1236; 604 1284; 604 1316; 605 757; 605 1005; 605 1237; 605 1285; 605 1317; 606 758; 606 1006; 606 1238; 606 1286; 606 1318; 607 759; 607 1007; 607 1239; 607 1287; 607 1319; 608 760; 608 1008; 608 1240; 608 1288; 608 1320; 609 761; 609 1009; 609 1241; 609 1289; 609 1321; 610 762; 610 962; 610 1242; 610 1274; 610 1290; 611 763; 611 963; 611 1243; 611 1275; 611 1291; 612 764; 612 964; 612 1244; 612 1276; 612 1292; 613 765; 613 965; 613 1245; 613 1277; 613 1293; 614 766; 614 966; 614 1246; 614 1278; 614 1294; 615 767; 615 967; 615 1247; 615 1279; 615 1295; 616 768; 616 968; 616 1248; 616 1280; 616 1296; 617 769; 617 969; 617 1249; 617 1281; 617 1297; 618 770; 618 970; 618 1250; 618 1282; 618 1298; 619 771; 619 971; 619 1251; 619 1283; 619 1299; 620 772; 620 972; 620 1252; 620 1284; 620 1300; 621 773; 621 973; 621 1253; 621 1285; 621 1301; 622 774; 622 974; 622 1254; 622 1286; 622 1302; 623 775; 623 975; 623 1255; 623 1287; 623 1303; 624 776; 624 976; 624 1256; 624 1288; 624 1304; 625 777; 625 977; 625 1257; 625 1289; 625 1305; 626 778; 626 978; 626 1258; 626 1290; 626 1306; 627 779; 627 979; 627 1259; 627 1291; 627 1307; 628 780; 628 980; 628 1260; 628 1292; 628 1308; 629 781; 629 981; 629 1261; 629 1293; 629 1309; 630 782; 630 982; 630 1262; 630 1294; 630 1310; 631 783; 631 983; 631 1263; 631 1295; 631 1311; 632 784; 632 984; 632 1264; 632 1296; 632 1312; 633 785; 633 985; 633 1265; 633 1297; 633 1313; 634 786; 634 986; 634 1266; 634 1298; 634 1314; 635 787; 635 987; 635 1267; 635 1299; 635 1315; 636 788; 636 988; 636 1268; 636 1300; 636 1316; 637 789; 637 989; 637 1269; 637 1301; 637 1317; 638 790; 638 990; 638 1270; 638 1302; 638 1318; 639 791; 639 991; 639 1271; 639 1303; 639 1319; 640 792; 640 992; 640 1272; 640 1304; 640 1320; 641 793; 641 993; 641 1273; 641 1305; 641 1321; 642 746; 642 994; 642 1226; 642 1274; 642 1306; 643 747; 643 995; 643 1227; 643 1275; 643 1307; 644 748; 644 996; 644 1228; 644 1276; 644 1308; 645 749; 645 997; 645 1229; 645 1277; 645 1309; 646 750; 646 998; 646 1230; 646 1278; 646 1310; 647 751; 647 999; 647 1231; 647 1279; 647 1311; 648 752; 648 1000; 648 1232; 648 1280; 648 1312; 649 753; 649 1001; 649 1233; 649 1281; 649 1313; 650 1146; 650 1310; 650 1334; 651 1147; 651 1311; 651 1335; 652 1148; 652 1312; 652 1336; 653 1149; 653 1313; 653 1337; 654 1150; 654 1306; 654 1330; 655 1151; 655 1307; 655 1331; 656 1152; 656 1308; 656 1332; 657 1153; 657 1309; 657 1333; 658 1106; 658 1302; 658 1326; 659 1107; 659 1303; 659 1327; 660 1108; 660 1304; 660 1328; 661 1109; 661 1305; 661 1329; 662 1110; 662 1298; 662 1322; 663 1111; 663 1299; 663 1323; 664 1112; 664 1300; 664 1324; 665 1113; 665 1301; 665 1325; 666 1114; 666 1294; 666 1366; 667 1115; 667 1295; 667 1367; 668 1116; 668 1296; 668 1368; 669 1117; 669 1297; 669 1369; 670 1118; 670 1290; 670 1362; 671 1119; 671 1291; 671 1363; 672 1120; 672 1292; 672 1364; 673 1121; 673 1293; 673 1365; 674 1122; 674 1286; 674 1358; 675 1123; 675 1287; 675 1359; 676 1124; 676 1288; 676 1360; 677 1125; 677 1289; 677 1361; 678 1126; 678 1282; 678 1354; 679 1127; 679 1283; 679 1355; 680 1128; 680 1284; 680 1356; 681 1129; 681 1285; 681 1357; 682 1130; 682 1278; 682 1350; 683 1131; 683 1279; 683 1351; 684 1132; 684 1280; 684 1352; 685 1133; 685 1281; 685 1353; 686 1134; 686 1274; 686 1346; 687 1135; 687 1275; 687 1347; 688 1136; 688 1276; 688 1348; 689 1137; 689 1277; 689 1349; 690 1138; 690 1318; 690 1342; 691 1139; 691 1319; 691 1343; 692 1140; 692 1320; 692 1344; 693 1141; 693 1321; 693 1345; 694 1142; 694 1314; 694 1338; 695 1143; 695 1315; 695 1339; 696 1144; 696 1316; 696 1340; 697 1145; 697 1317; 697 1341; 698 1018; 698 1342; 698 1554; 699 1019; 699 1343; 699 1555; 700 1020; 700 1344; 700 1556; 701 1021; 701 1345; 701 1557; 702 1022; 702 1338; 702 1558; 703 1023; 703 1339; 703 1559; 704 1024; 704 1340; 704 1560; 705 1025; 705 1341; 705 1561; 706 1026; 706 1334; 706 1562; 707 1027; 707 1335; 707 1563; 708 1028; 708 1336; 708 1564; 709 1029; 709 1337; 709 1565; 710 1030; 710 1330; 710 1566; 711 1031; 711 1331; 711 1567; 712 1032; 712 1332; 712 1568; 713 1033; 713 1333; 713 1569; 714 1034; 714 1326; 714 1570; 715 1035; 715 1327; 715 1571; 716 1036; 716 1328; 716 1572; 717 1037; 717 1329; 717 1573; 718 1038; 718 1322; 718 1574; 719 1039; 719 1323; 719 1575; 720 1040; 720 1324; 720 1576; 721 1041; 721 1325; 721 1577; 722 1042; 722 1366; 722 1578; 723 1043; 723 1367; 723 1579; 724 1044; 724 1368; 724 1580; 725 1045; 725 1369; 725 1581; 726 1046; 726 1362; 726 1582; 727 1047; 727 1363; 727 1583; 728 1048; 728 1364; 728 1584; 729 1049; 729 1365; 729 1585; 730 1050; 730 1358; 730 1538; 731 1051; 731 1359; 731 1539; 732 1052; 732 1360; 732 1540; 733 1053; 733 1361; 733 1541; 734 1054; 734 1354; 734 1542; 735 1055; 735 1355; 735 1543; 736 1056; 736 1356; 736 1544; 737 1057; 737 1357; 737 1545; 738 1010; 738 1350; 738 1546; 739 1011; 739 1351; 739 1547; 740 1012; 740 1352; 740 1548; 741 1013; 741 1353; 741 1549; 742 1014; 742 1346; 742 1550; 743 1015; 743 1347; 743 1551; 744 1016; 744 1348; 744 1552; 745 1017; 745 1349; 745 1553; 746 1066; 746 1458; 747 1067; 747 1459; 748 1068; 748 1460; 749 1069; 749 1461; 750 1070; 750 1462; 751 1071; 751 1463; 752 1072; 752 1464; 753 1073; 753 1465; 754 1074; 754 1466; 755 1075; 755 1467; 756 1076; 756 1468; 757 1077; 757 1469; 758 1078; 758 1470; 759 1079; 759 1471; 760 1080; 760 1472; 761 1081; 761 1473; 762 1082; 762 1474; 763 1083; 763 1475; 764 1084; 764 1476; 765 1085; 765 1477; 766 1086; 766 1478; 767 1087; 767 1479; 768 1088; 768 1480; 769 1089; 769 1481; 770 1090; 770 1482; 771 1091; 771 1483; 772 1092; 772 1484; 773 1093; 773 1485; 774 1094; 774 1486; 775 1095; 775 1487; 776 1096; 776 1488; 777 1097; 777 1489; 778 1098; 778 1442; 779 1099; 779 1443; 780 1100; 780 1444; 781 1101; 781 1445; 782 1102; 782 1446; 783 1103; 783 1447; 784 1104; 784 1448; 785 1105; 785 1449; 786 1058; 786 1450; 787 1059; 787 1451; 788 1060; 788 1452; 789 1061; 789 1453; 790 1062; 790 1454; 791 1063; 791 1455; 792 1064; 792 1456; 793 1065; 793 1457; 794 886; 794 1098; 794 1206; 794 1274; 794 1494; 795 887; 795 1099; 795 1207; 795 1275; 795 1495; 796 888; 796 1100; 796 1208; 796 1276; 796 1496; 797 889; 797 1101; 797 1209; 797 1277; 797 1497; 798 882; 798 1102; 798 1202; 798 1278; 798 1490; 799 883; 799 1103; 799 1203; 799 1279; 799 1491; 800 884; 800 1104; 800 1204; 800 1280; 800 1492; 801 885; 801 1105; 801 1205; 801 1281; 801 1493; 802 878; 802 1058; 802 1202; 802 1282; 802 1534; 803 879; 803 1059; 803 1203; 803 1283; 803 1535; 804 880; 804 1060; 804 1204; 804 1284; 804 1536; 805 881; 805 1061; 805 1205; 805 1285; 805 1537; 806 874; 806 1062; 806 1206; 806 1286; 806 1530; 807 875; 807 1063; 807 1207; 807 1287; 807 1531; 808 876; 808 1064; 808 1208; 808 1288; 808 1532; 809 877; 809 1065; 809 1209; 809 1289; 809 1533; 810 870; 810 1066; 810 1210; 810 1290; 810 1526; 811 871; 811 1067; 811 1211; 811 1291; 811 1527; 812 872; 812 1068; 812 1212; 812 1292; 812 1528; 813 873; 813 1069; 813 1213; 813 1293; 813 1529; 814 866; 814 1070; 814 1214; 814 1294; 814 1522; 815 867; 815 1071; 815 1215; 815 1295; 815 1523; 816 868; 816 1072; 816 1216; 816 1296; 816 1524; 817 869; 817 1073; 817 1217; 817 1297; 817 1525; 818 862; 818 1074; 818 1218; 818 1298; 818 1518; 819 863; 819 1075; 819 1219; 819 1299; 819 1519; 820 864; 820 1076; 820 1220; 820 1300; 820 1520; 821 865; 821 1077; 821 1221; 821 1301; 821 1521; 822 858; 822 1078; 822 1222; 822 1302; 822 1514; 823 859; 823 1079; 823 1223; 823 1303; 823 1515; 824 860; 824 1080; 824 1224; 824 1304; 824 1516; 825 861; 825 1081; 825 1225; 825 1305; 825 1517; 826 854; 826 1082; 826 1222; 826 1306; 826 1510; 827 855; 827 1083; 827 1223; 827 1307; 827 1511; 828 856; 828 1084; 828 1224; 828 1308; 828 1512; 829 857; 829 1085; 829 1225; 829 1309; 829 1513; 830 850; 830 1086; 830 1218; 830 1310; 830 1506; 831 851; 831 1087; 831 1219; 831 1311; 831 1507; 832 852; 832 1088; 832 1220; 832 1312; 832 1508; 833 853; 833 1089; 833 1221; 833 1313; 833 1509; 834 846; 834 1090; 834 1214; 834 1314; 834 1502; 835 847; 835 1091; 835 1215; 835 1315; 835 1503; 836 848; 836 1092; 836 1216; 836 1316; 836 1504; 837 849; 837 1093; 837 1217; 837 1317; 837 1505; 838 842; 838 1094; 838 1210; 838 1318; 838 1498; 839 843; 839 1095; 839 1211; 839 1319; 839 1499; 840 844; 840 1096; 840 1212; 840 1320; 840 1500; 841 845; 841 1097; 841 1213; 841 1321; 841 1501; 842 1062; 842 1278; 842 1318; 842 1538; 843 1063; 843 1279; 843 1319; 843 1539; 844 1064; 844 1280; 844 1320; 844 1540; 845 1065; 845 1281; 845 1321; 845 1541; 846 1058; 846 1274; 846 1314; 846 1542; 847 1059; 847 1275; 847 1315; 847 1543; 848 1060; 848 1276; 848 1316; 848 1544; 849 1061; 849 1277; 849 1317; 849 1545; 850 1102; 850 1310; 850 1318; 850 1546; 851 1103; 851 1311; 851 1319; 851 1547; 852 1104; 852 1312; 852 1320; 852 1548; 853 1105; 853 1313; 853 1321; 853 1549; 854 1098; 854 1306; 854 1314; 854 1550; 855 1099; 855 1307; 855 1315; 855 1551; 856 1100; 856 1308; 856 1316; 856 1552; 857 1101; 857 1309; 857 1317; 857 1553; 858 1094; 858 1302; 858 1310; 858 1554; 859 1095; 859 1303; 859 1311; 859 1555; 860 1096; 860 1304; 860 1312; 860 1556; 861 1097; 861 1305; 861 1313; 861 1557; 862 1090; 862 1298; 862 1306; 862 1558; 863 1091; 863 1299; 863 1307; 863 1559; 864 1092; 864 1300; 864 1308; 864 1560; 865 1093; 865 1301; 865 1309; 865 1561; 866 1086; 866 1294; 866 1302; 866 1562; 867 1087; 867 1295; 867 1303; 867 1563; 868 1088; 868 1296; 868 1304; 868 1564; 869 1089; 869 1297; 869 1305; 869 1565; 870 1082; 870 1290; 870 1298; 870 1566; 871 1083; 871 1291; 871 1299; 871 1567; 872 1084; 872 1292; 872 1300; 872 1568; 873 1085; 873 1293; 873 1301; 873 1569; 874 1078; 874 1286; 874 1294; 874 1570; 875 1079; 875 1287; 875 1295; 875 1571; 876 1080; 876 1288; 876 1296; 876 1572; 877 1081; 877 1289; 877 1297; 877 1573; 878 1074; 878 1282; 878 1290; 878 1574; 879 1075; 879 1283; 879 1291; 879 1575; 880 1076; 880 1284; 880 1292; 880 1576; 881 1077; 881 1285; 881 1293; 881 1577; 882 1070; 882 1278; 882 1286; 882 1578; 883 1071; 883 1279; 883 1287; 883 1579; 884 1072; 884 1280; 884 1288; 884 1580; 885 1073; 885 1281; 885 1289; 885 1581; 886 1066; 886 1274; 886 1282; 886 1582; 887 1067; 887 1275; 887 1283; 887 1583; 888 1068; 888 1276; 888 1284; 888 1584; 889 1069; 889 1277; 889 1285; 889 1585; 890 1114; 890 1162; 890 1326; 890 1434; 891 1115; 891 1163; 891 1327; 891 1435; 892 1116; 892 1164; 892 1328; 892 1436; 893 1117; 893 1165; 893 1329; 893 1437; 894 1118; 894 1166; 894 1322; 894 1438; 895 1119; 895 1167; 895 1323; 895 1439; 896 1120; 896 1168; 896 1324; 896 1440; 897 1121; 897 1169; 897 1325; 897 1441; 898 1122; 898 1170; 898 1366; 898 1394; 899 1123; 899 1171; 899 1367; 899 1395; 900 1124; 900 1172; 900 1368; 900 1396; 901 1125; 901 1173; 901 1369; 901 1397; 902 1126; 902 1174; 902 1362; 902 1398; 903 1127; 903 1175; 903 1363; 903 1399; 904 1128; 904 1176; 904 1364; 904 1400; 905 1129; 905 1177; 905 1365; 905 1401; 906 1130; 906 1178; 906 1358; 906 1402; 907 1131; 907 1179; 907 1359; 907 1403; 908 1132; 908 1180; 908 1360; 908 1404; 909 1133; 909 1181; 909 1361; 909 1405; 910 1134; 910 1182; 910 1354; 910 1406; 911 1135; 911 1183; 911 1355; 911 1407; 912 1136; 912 1184; 912 1356; 912 1408; 913 1137; 913 1185; 913 1357; 913 1409; 914 1138; 914 1186; 914 1350; 914 1410; 915 1139; 915 1187; 915 1351; 915 1411; 916 1140; 916 1188; 916 1352; 916 1412; 917 1141; 917 1189; 917 1353; 917 1413; 918 1142; 918 1190; 918 1346; 918 1414; 919 1143; 919 1191; 919 1347; 919 1415; 920 1144; 920 1192; 920 1348; 920 1416; 921 1145; 921 1193; 921 1349; 921 1417; 922 1146; 922 1194; 922 1342; 922 1418; 923 1147; 923 1195; 923 1343; 923 1419; 924 1148; 924 1196; 924 1344; 924 1420; 925 1149; 925 1197; 925 1345; 925 1421; 926 1150; 926 1198; 926 1338; 926 1422; 927 1151; 927 1199; 927 1339; 927 1423; 928 1152; 928 1200; 928 1340; 928 1424; 929 1153; 929 1201; 929 1341; 929 1425; 930 1106; 930 1154; 930 1334; 930 1426; 931 1107; 931 1155; 931 1335; 931 1427; 932 1108; 932 1156; 932 1336; 932 1428; 933 1109; 933 1157; 933 1337; 933 1429; 934 1110; 934 1158; 934 1330; 934 1430; 935 1111; 935 1159; 935 1331; 935 1431; 936 1112; 936 1160; 936 1332; 936 1432; 937 1113; 937 1161; 937 1333; 937 1433; 938 1230; 938 1234; 938 1322; 938 1366; 939 1231; 939 1235; 939 1323; 939 1367; 940 1232; 940 1236; 940 1324; 940 1368; 941 1233; 941 1237; 941 1325; 941 1369; 942 1226; 942 1238; 942 1326; 942 1362; 943 1227; 943 1239; 943 1327; 943 1363; 944 1228; 944 1240; 944 1328; 944 1364; 945 1229; 945 1241; 945 1329; 945 1365; 946 1242; 946 1270; 946 1330; 946 1358; 947 1243; 947 1271; 947 1331; 947 1359; 948 1244; 948 1272; 948 1332; 948 1360; 949 1245; 949 1273; 949 1333; 949 1361; 950 1246; 950 1266; 950 1334; 950 1354; 951 1247; 951 1267; 951 1335; 951 1355; 952 1248; 952 1268; 952 1336; 952 1356; 953 1249; 953 1269; 953 1337; 953 1357; 954 1250; 954 1262; 954 1338; 954 1350; 955 1251; 955 1263; 955 1339; 955 1351; 956 1252; 956 1264; 956 1340; 956 1352; 957 1253; 957 1265; 957 1341; 957 1353; 958 1254; 958 1258; 958 1342; 958 1346; 959 1255; 959 1259; 959 1343; 959 1347; 960 1256; 960 1260; 960 1344; 960 1348; 961 1257; 961 1261; 961 1345; 961 1349; 962 1098; 962 1330; 962 1362; 962 1374; 963 1099; 963 1331; 963 1363; 963 1375; 964 1100; 964 1332; 964 1364; 964 1376; 965 1101; 965 1333; 965 1365; 965 1377; 966 1102; 966 1334; 966 1366; 966 1370; 967 1103; 967 1335; 967 1367; 967 1371; 968 1104; 968 1336; 968 1368; 968 1372; 969 1105; 969 1337; 969 1369; 969 1373; 970 1058; 970 1322; 970 1338; 970 1370; 971 1059; 971 1323; 971 1339; 971 1371; 972 1060; 972 1324; 972 1340; 972 1372; 973 1061; 973 1325; 973 1341; 973 1373; 974 1062; 974 1326; 974 1342; 974 1374; 975 1063; 975 1327; 975 1343; 975 1375; 976 1064; 976 1328; 976 1344; 976 1376; 977 1065; 977 1329; 977 1345; 977 1377; 978 1066; 978 1330; 978 1346; 978 1378; 979 1067; 979 1331; 979 1347; 979 1379; 980 1068; 980 1332; 980 1348; 980 1380; 981 1069; 981 1333; 981 1349; 981 1381; 982 1070; 982 1334; 982 1350; 982 1382; 983 1071; 983 1335; 983 1351; 983 1383; 984 1072; 984 1336; 984 1352; 984 1384; 985 1073; 985 1337; 985 1353; 985 1385; 986 1074; 986 1338; 986 1354; 986 1386; 987 1075; 987 1339; 987 1355; 987 1387; 988 1076; 988 1340; 988 1356; 988 1388; 989 1077; 989 1341; 989 1357; 989 1389; 990 1078; 990 1342; 990 1358; 990 1390; 991 1079; 991 1343; 991 1359; 991 1391; 992 1080; 992 1344; 992 1360; 992 1392; 993 1081; 993 1345; 993 1361; 993 1393; 994 1082; 994 1346; 994 1362; 994 1390; 995 1083; 995 1347; 995 1363; 995 1391; 996 1084; 996 1348; 996 1364; 996 1392; 997 1085; 997 1349; 997 1365; 997 1393; 998 1086; 998 1350; 998 1366; 998 1386; 999 1087; 999 1351; 999 1367; 999 1387; 1000 1088; 1000 1352; 1000 1368; 1000 1388; 1001 1089; 1001 1353; 1001 1369; 1001 1389; 1002 1090; 1002 1322; 1002 1354; 1002 1382; 1003 1091; 1003 1323; 1003 1355; 1003 1383; 1004 1092; 1004 1324; 1004 1356; 1004 1384; 1005 1093; 1005 1325; 1005 1357; 1005 1385; 1006 1094; 1006 1326; 1006 1358; 1006 1378; 1007 1095; 1007 1327; 1007 1359; 1007 1379; 1008 1096; 1008 1328; 1008 1360; 1008 1380; 1009 1097; 1009 1329; 1009 1361; 1009 1381; 1010 1114; 1010 1146; 1010 1234; 1010 1498; 1010 1546; 1011 1115; 1011 1147; 1011 1235; 1011 1499; 1011 1547; 1012 1116; 1012 1148; 1012 1236; 1012 1500; 1012 1548; 1013 1117; 1013 1149; 1013 1237; 1013 1501; 1013 1549; 1014 1118; 1014 1150; 1014 1238; 1014 1502; 1014 1550; 1015 1119; 1015 1151; 1015 1239; 1015 1503; 1015 1551; 1016 1120; 1016 1152; 1016 1240; 1016 1504; 1016 1552; 1017 1121; 1017 1153; 1017 1241; 1017 1505; 1017 1553; 1018 1106; 1018 1122; 1018 1242; 1018 1506; 1018 1554; 1019 1107; 1019 1123; 1019 1243; 1019 1507; 1019 1555; 1020 1108; 1020 1124; 1020 1244; 1020 1508; 1020 1556; 1021 1109; 1021 1125; 1021 1245; 1021 1509; 1021 1557; 1022 1110; 1022 1126; 1022 1246; 1022 1510; 1022 1558; 1023 1111; 1023 1127; 1023 1247; 1023 1511; 1023 1559; 1024 1112; 1024 1128; 1024 1248; 1024 1512; 1024 1560; 1025 1113; 1025 1129; 1025 1249; 1025 1513; 1025 1561; 1026 1114; 1026 1130; 1026 1250; 1026 1514; 1026 1562; 1027 1115; 1027 1131; 1027 1251; 1027 1515; 1027 1563; 1028 1116; 1028 1132; 1028 1252; 1028 1516; 1028 1564; 1029 1117; 1029 1133; 1029 1253; 1029 1517; 1029 1565; 1030 1118; 1030 1134; 1030 1254; 1030 1518; 1030 1566; 1031 1119; 1031 1135; 1031 1255; 1031 1519; 1031 1567; 1032 1120; 1032 1136; 1032 1256; 1032 1520; 1032 1568; 1033 1121; 1033 1137; 1033 1257; 1033 1521; 1033 1569; 1034 1122; 1034 1138; 1034 1258; 1034 1522; 1034 1570; 1035 1123; 1035 1139; 1035 1259; 1035 1523; 1035 1571; 1036 1124; 1036 1140; 1036 1260; 1036 1524; 1036 1572; 1037 1125; 1037 1141; 1037 1261; 1037 1525; 1037 1573; 1038 1126; 1038 1142; 1038 1262; 1038 1526; 1038 1574; 1039 1127; 1039 1143; 1039 1263; 1039 1527; 1039 1575; 1040 1128; 1040 1144; 1040 1264; 1040 1528; 1040 1576; 1041 1129; 1041 1145; 1041 1265; 1041 1529; 1041 1577; 1042 1130; 1042 1146; 1042 1266; 1042 1530; 1042 1578; 1043 1131; 1043 1147; 1043 1267; 1043 1531; 1043 1579; 1044 1132; 1044 1148; 1044 1268; 1044 1532; 1044 1580; 1045 1133; 1045 1149; 1045 1269; 1045 1533; 1045 1581; 1046 1134; 1046 1150; 1046 1270; 1046 1534; 1046 1582; 1047 1135; 1047 1151; 1047 1271; 1047 1535; 1047 1583; 1048 1136; 1048 1152; 1048 1272; 1048 1536; 1048 1584; 1049 1137; 1049 1153; 1049 1273; 1049 1537; 1049 1585; 1050 1106; 1050 1138; 1050 1226; 1050 1490; 1050 1538; 1051 1107; 1051 1139; 1051 1227; 1051 1491; 1051 1539; 1052 1108; 1052 1140; 1052 1228; 1052 1492; 1052 1540; 1053 1109; 1053 1141; 1053 1229; 1053 1493; 1053 1541; 1054 1110; 1054 1142; 1054 1230; 1054 1494; 1054 1542; 1055 1111; 1055 1143; 1055 1231; 1055 1495; 1055 1543; 1056 1112; 1056 1144; 1056 1232; 1056 1496; 1056 1544; 1057 1113; 1057 1145; 1057 1233; 1057 1497; 1057 1545; 1058 1066; 1058 1098; 1058 1314; 1058 1574; 1059 1067; 1059 1099; 1059 1315; 1059 1575; 1060 1068; 1060 1100; 1060 1316; 1060 1576; 1061 1069; 1061 1101; 1061 1317; 1061 1577; 1062 1070; 1062 1102; 1062 1318; 1062 1570; 1063 1071; 1063 1103; 1063 1319; 1063 1571; 1064 1072; 1064 1104; 1064 1320; 1064 1572; 1065 1073; 1065 1105; 1065 1321; 1065 1573; 1066 1074; 1066 1274; 1066 1566; 1067 1075; 1067 1275; 1067 1567; 1068 1076; 1068 1276; 1068 1568; 1069 1077; 1069 1277; 1069 1569; 1070 1078; 1070 1278; 1070 1562; 1071 1079; 1071 1279; 1071 1563; 1072 1080; 1072 1280; 1072 1564; 1073 1081; 1073 1281; 1073 1565; 1074 1082; 1074 1282; 1074 1558; 1075 1083; 1075 1283; 1075 1559; 1076 1084; 1076 1284; 1076 1560; 1077 1085; 1077 1285; 1077 1561; 1078 1086; 1078 1286; 1078 1554; 1079 1087; 1079 1287; 1079 1555; 1080 1088; 1080 1288; 1080 1556; 1081 1089; 1081 1289; 1081 1557; 1082 1090; 1082 1290; 1082 1550; 1083 1091; 1083 1291; 1083 1551; 1084 1092; 1084 1292; 1084 1552; 1085 1093; 1085 1293; 1085 1553; 1086 1094; 1086 1294; 1086 1546; 1087 1095; 1087 1295; 1087 1547; 1088 1096; 1088 1296; 1088 1548; 1089 1097; 1089 1297; 1089 1549; 1090 1098; 1090 1298; 1090 1542; 1091 1099; 1091 1299; 1091 1543; 1092 1100; 1092 1300; 1092 1544; 1093 1101; 1093 1301; 1093 1545; 1094 1102; 1094 1302; 1094 1538; 1095 1103; 1095 1303; 1095 1539; 1096 1104; 1096 1304; 1096 1540; 1097 1105; 1097 1305; 1097 1541; 1098 1306; 1098 1582; 1099 1307; 1099 1583; 1100 1308; 1100 1584; 1101 1309; 1101 1585; 1102 1310; 1102 1578; 1103 1311; 1103 1579; 1104 1312; 1104 1580; 1105 1313; 1105 1581; 1106 1286; 1106 1334; 1106 1358; 1107 1287; 1107 1335; 1107 1359; 1108 1288; 1108 1336; 1108 1360; 1109 1289; 1109 1337; 1109 1361; 1110 1282; 1110 1330; 1110 1354; 1111 1283; 1111 1331; 1111 1355; 1112 1284; 1112 1332; 1112 1356; 1113 1285; 1113 1333; 1113 1357; 1114 1278; 1114 1326; 1114 1350; 1115 1279; 1115 1327; 1115 1351; 1116 1280; 1116 1328; 1116 1352; 1117 1281; 1117 1329; 1117 1353; 1118 1274; 1118 1322; 1118 1346; 1119 1275; 1119 1323; 1119 1347; 1120 1276; 1120 1324; 1120 1348; 1121 1277; 1121 1325; 1121 1349; 1122 1318; 1122 1342; 1122 1366; 1123 1319; 1123 1343; 1123 1367; 1124 1320; 1124 1344; 1124 1368; 1125 1321; 1125 1345; 1125 1369; 1126 1314; 1126 1338; 1126 1362; 1127 1315; 1127 1339; 1127 1363; 1128 1316; 1128 1340; 1128 1364; 1129 1317; 1129 1341; 1129 1365; 1130 1310; 1130 1334; 1130 1358; 1131 1311; 1131 1335; 1131 1359; 1132 1312; 1132 1336; 1132 1360; 1133 1313; 1133 1337; 1133 1361; 1134 1306; 1134 1330; 1134 1354; 1135 1307; 1135 1331; 1135 1355; 1136 1308; 1136 1332; 1136 1356; 1137 1309; 1137 1333; 1137 1357; 1138 1302; 1138 1326; 1138 1350; 1139 1303; 1139 1327; 1139 1351; 1140 1304; 1140 1328; 1140 1352; 1141 1305; 1141 1329; 1141 1353; 1142 1298; 1142 1322; 1142 1346; 1143 1299; 1143 1323; 1143 1347; 1144 1300; 1144 1324; 1144 1348; 1145 1301; 1145 1325; 1145 1349; 1146 1294; 1146 1342; 1146 1366; 1147 1295; 1147 1343; 1147 1367; 1148 1296; 1148 1344; 1148 1368; 1149 1297; 1149 1345; 1149 1369; 1150 1290; 1150 1338; 1150 1362; 1151 1291; 1151 1339; 1151 1363; 1152 1292; 1152 1340; 1152 1364; 1153 1293; 1153 1341; 1153 1365; 1154 1310; 1154 1454; 1154 1570; 1155 1311; 1155 1455; 1155 1571; 1156 1312; 1156 1456; 1156 1572; 1157 1313; 1157 1457; 1157 1573; 1158 1306; 1158 1450; 1158 1574; 1159 1307; 1159 1451; 1159 1575; 1160 1308; 1160 1452; 1160 1576; 1161 1309; 1161 1453; 1161 1577; 1162 1302; 1162 1446; 1162 1578; 1163 1303; 1163 1447; 1163 1579; 1164 1304; 1164 1448; 1164 1580; 1165 1305; 1165 1449; 1165 1581; 1166 1298; 1166 1442; 1166 1582; 1167 1299; 1167 1443; 1167 1583; 1168 1300; 1168 1444; 1168 1584; 1169 1301; 1169 1445; 1169 1585; 1170 1294; 1170 1486; 1170 1538; 1171 1295; 1171 1487; 1171 1539; 1172 1296; 1172 1488; 1172 1540; 1173 1297; 1173 1489; 1173 1541; 1174 1290; 1174 1482; 1174 1542; 1175 1291; 1175 1483; 1175 1543; 1176 1292; 1176 1484; 1176 1544; 1177 1293; 1177 1485; 1177 1545; 1178 1286; 1178 1478; 1178 1546; 1179 1287; 1179 1479; 1179 1547; 1180 1288; 1180 1480; 1180 1548; 1181 1289; 1181 1481; 1181 1549; 1182 1282; 1182 1474; 1182 1550; 1183 1283; 1183 1475; 1183 1551; 1184 1284; 1184 1476; 1184 1552; 1185 1285; 1185 1477; 1185 1553; 1186 1278; 1186 1470; 1186 1554; 1187 1279; 1187 1471; 1187 1555; 1188 1280; 1188 1472; 1188 1556; 1189 1281; 1189 1473; 1189 1557; 1190 1274; 1190 1466; 1190 1558; 1191 1275; 1191 1467; 1191 1559; 1192 1276; 1192 1468; 1192 1560; 1193 1277; 1193 1469; 1193 1561; 1194 1318; 1194 1462; 1194 1562; 1195 1319; 1195 1463; 1195 1563; 1196 1320; 1196 1464; 1196 1564; 1197 1321; 1197 1465; 1197 1565; 1198 1314; 1198 1458; 1198 1566; 1199 1315; 1199 1459; 1199 1567; 1200 1316; 1200 1460; 1200 1568; 1201 1317; 1201 1461; 1201 1569; 1202 1262; 1202 1266; 1202 1382; 1202 1386; 1203 1263; 1203 1267; 1203 1383; 1203 1387; 1204 1264; 1204 1268; 1204 1384; 1204 1388; 1205 1265; 1205 1269; 1205 1385; 1205 1389; 1206 1258; 1206 1270; 1206 1378; 1206 1390; 1207 1259; 1207 1271; 1207 1379; 1207 1391; 1208 1260; 1208 1272; 1208 1380; 1208 1392; 1209 1261; 1209 1273; 1209 1381; 1209 1393; 1210 1226; 1210 1254; 1210 1374; 1210 1390; 1211 1227; 1211 1255; 1211 1375; 1211 1391; 1212 1228; 1212 1256; 1212 1376; 1212 1392; 1213 1229; 1213 1257; 1213 1377; 1213 1393; 1214 1230; 1214 1250; 1214 1370; 1214 1386; 1215 1231; 1215 1251; 1215 1371; 1215 1387; 1216 1232; 1216 1252; 1216 1372; 1216 1388; 1217 1233; 1217 1253; 1217 1373; 1217 1389; 1218 1234; 1218 1246; 1218 1370; 1218 1382; 1219 1235; 1219 1247; 1219 1371; 1219 1383; 1220 1236; 1220 1248; 1220 1372; 1220 1384; 1221 1237; 1221 1249; 1221 1373; 1221 1385; 1222 1238; 1222 1242; 1222 1374; 1222 1378; 1223 1239; 1223 1243; 1223 1375; 1223 1379; 1224 1240; 1224 1244; 1224 1376; 1224 1380; 1225 1241; 1225 1245; 1225 1377; 1225 1381; 1226 1238; 1226 1390; 1226 1526; 1227 1239; 1227 1391; 1227 1527; 1228 1240; 1228 1392; 1228 1528; 1229 1241; 1229 1393; 1229 1529; 1230 1234; 1230 1386; 1230 1522; 1231 1235; 1231 1387; 1231 1523; 1232 1236; 1232 1388; 1232 1524; 1233 1237; 1233 1389; 1233 1525; 1234 1382; 1234 1518; 1235 1383; 1235 1519; 1236 1384; 1236 1520; 1237 1385; 1237 1521; 1238 1378; 1238 1514; 1239 1379; 1239 1515; 1240 1380; 1240 1516; 1241 1381; 1241 1517; 1242 1270; 1242 1374; 1242 1510; 1243 1271; 1243 1375; 1243 1511; 1244 1272; 1244 1376; 1244 1512; 1245 1273; 1245 1377; 1245 1513; 1246 1266; 1246 1370; 1246 1506; 1247 1267; 1247 1371; 1247 1507; 1248 1268; 1248 1372; 1248 1508; 1249 1269; 1249 1373; 1249 1509; 1250 1262; 1250 1370; 1250 1502; 1251 1263; 1251 1371; 1251 1503; 1252 1264; 1252 1372; 1252 1504; 1253 1265; 1253 1373; 1253 1505; 1254 1258; 1254 1374; 1254 1498; 1255 1259; 1255 1375; 1255 1499; 1256 1260; 1256 1376; 1256 1500; 1257 1261; 1257 1377; 1257 1501; 1258 1378; 1258 1494; 1259 1379; 1259 1495; 1260 1380; 1260 1496; 1261 1381; 1261 1497; 1262 1382; 1262 1490; 1263 1383; 1263 1491; 1264 1384; 1264 1492; 1265 1385; 1265 1493; 1266 1386; 1266 1534; 1267 1387; 1267 1535; 1268 1388; 1268 1536; 1269 1389; 1269 1537; 1270 1390; 1270 1530; 1271 1391; 1271 1531; 1272 1392; 1272 1532; 1273 1393; 1273 1533; 1274 1290; 1274 1306; 1274 1346; 1274 1558; 1274 1566; 1275 1291; 1275 1307; 1275 1347; 1275 1559; 1275 1567; 1276 1292; 1276 1308; 1276 1348; 1276 1560; 1276 1568; 1277 1293; 1277 1309; 1277 1349; 1277 1561; 1277 1569; 1278 1294; 1278 1310; 1278 1350; 1278 1554; 1278 1562; 1279 1295; 1279 1311; 1279 1351; 1279 1555; 1279 1563; 1280 1296; 1280 1312; 1280 1352; 1280 1556; 1280 1564; 1281 1297; 1281 1313; 1281 1353; 1281 1557; 1281 1565; 1282 1298; 1282 1314; 1282 1354; 1282 1550; 1282 1558; 1283 1299; 1283 1315; 1283 1355; 1283 1551; 1283 1559; 1284 1300; 1284 1316; 1284 1356; 1284 1552; 1284 1560; 1285 1301; 1285 1317; 1285 1357; 1285 1553; 1285 1561; 1286 1302; 1286 1318; 1286 1358; 1286 1546; 1286 1554; 1287 1303; 1287 1319; 1287 1359; 1287 1547; 1287 1555; 1288 1304; 1288 1320; 1288 1360; 1288 1548; 1288 1556; 1289 1305; 1289 1321; 1289 1361; 1289 1549; 1289 1557; 1290 1306; 1290 1362; 1290 1542; 1290 1550; 1291 1307; 1291 1363; 1291 1543; 1291 1551; 1292 1308; 1292 1364; 1292 1544; 1292 1552; 1293 1309; 1293 1365; 1293 1545; 1293 1553; 1294 1310; 1294 1366; 1294 1538; 1294 1546; 1295 1311; 1295 1367; 1295 1539; 1295 1547; 1296 1312; 1296 1368; 1296 1540; 1296 1548; 1297 1313; 1297 1369; 1297 1541; 1297 1549; 1298 1314; 1298 1322; 1298 1542; 1298 1582; 1299 1315; 1299 1323; 1299 1543; 1299 1583; 1300 1316; 1300 1324; 1300 1544; 1300 1584; 1301 1317; 1301 1325; 1301 1545; 1301 1585; 1302 1318; 1302 1326; 1302 1538; 1302 1578; 1303 1319; 1303 1327; 1303 1539; 1303 1579; 1304 1320; 1304 1328; 1304 1540; 1304 1580; 1305 1321; 1305 1329; 1305 1541; 1305 1581; 1306 1330; 1306 1574; 1306 1582; 1307 1331; 1307 1575; 1307 1583; 1308 1332; 1308 1576; 1308 1584; 1309 1333; 1309 1577; 1309 1585; 1310 1334; 1310 1570; 1310 1578; 1311 1335; 1311 1571; 1311 1579; 1312 1336; 1312 1572; 1312 1580; 1313 1337; 1313 1573; 1313 1581; 1314 1338; 1314 1566; 1314 1574; 1315 1339; 1315 1567; 1315 1575; 1316 1340; 1316 1568; 1316 1576; 1317 1341; 1317 1569; 1317 1577; 1318 1342; 1318 1562; 1318 1570; 1319 1343; 1319 1563; 1319 1571; 1320 1344; 1320 1564; 1320 1572; 1321 1345; 1321 1565; 1321 1573; 1322 1518; 1323 1519; 1324 1520; 1325 1521; 1326 1514; 1327 1515; 1328 1516; 1329 1517; 1330 1510; 1331 1511; 1332 1512; 1333 1513; 1334 1506; 1335 1507; 1336 1508; 1337 1509; 1338 1502; 1339 1503; 1340 1504; 1341 1505; 1342 1498; 1343 1499; 1344 1500; 1345 1501; 1346 1494; 1347 1495; 1348 1496; 1349 1497; 1350 1490; 1351 1491; 1352 1492; 1353 1493; 1354 1534; 1355 1535; 1356 1536; 1357 1537; 1358 1530; 1359 1531; 1360 1532; 1361 1533; 1362 1526; 1363 1527; 1364 1528; 1365 1529; 1366 1522; 1367 1523; 1368 1524; 1369 1525; 1394 1482; 1395 1483; 1396 1484; 1397 1485; 1398 1486; 1399 1487; 1400 1488; 1401 1489; 1402 1442; 1403 1443; 1404 1444; 1405 1445; 1406 1446; 1407 1447; 1408 1448; 1409 1449; 1410 1450; 1411 1451; 1412 1452; 1413 1453; 1414 1454; 1415 1455; 1416 1456; 1417 1457; 1418 1458; 1419 1459; 1420 1460; 1421 1461; 1422 1462; 1423 1463; 1424 1464; 1425 1465; 1426 1466; 1427 1467; 1428 1468; 1429 1469; 1430 1470; 1431 1471; 1432 1472; 1433 1473; 1434 1474; 1435 1475; 1436 1476; 1437 1477; 1438 1478; 1439 1479; 1440 1480; 1441 1481]


coord_matrix = [2.0 0.0; 1.9375 0.49607837082461076; 2.3333333333333335 0.0; 2.2604166666666665 0.5787580992953792; 2.2916666666666665 0.1613743060919757; 2.180024931903804 0.7247544922631346; 2.1666666666666665 0.28867513459481287; 2.0273555880996486 0.8170722716987199; 2.0060790847395964 0.3332778958164491; 1.8607231355472444 0.8204491836236578; 2.1666666666666665 -0.28867513459481287; 2.1705610785670184 0.25776419842126996; 2.2855875819270706 -0.1719035897244734; 2.2568017963565583 0.4003836794640876; 1.8333333333333333 0.28867513459481287; 1.7044389214329818 0.7343925432279514; 1.7144124180729299 0.1719035897244734; 1.618198203643441 0.5917730621851338; 1.8333333333333333 -0.28867513459481287; 1.8476444119003517 0.1750844699505015; 1.9939209152604036 -0.3332778958164491; 2.014276864452755 0.17170755802556373; 1.6666666666666667 0.0; 1.6145833333333333 0.41339864235384227; 1.7083333333333333 -0.1613743060919757; 1.6949750680961964 0.2674022493860869; 3.0 0.0; 2.90625 0.7441175562369161; 2.875 0.4841229182759271; 2.665074795711411 1.1821067351401824; 2.5 0.8660254037844386; 2.207066764298945 1.4590600734469383; 2.018237254218789 0.9998336874493474; 1.7071694066417344 1.4691908092217516; 2.5 -0.8660254037844386; 2.636683235701055 -0.21886414638541152; 2.856762745781211 -0.5157107691734202; 2.8954053890696763 0.20899429674304149; 1.5 0.8660254037844386; 1.238316764298945 1.211020888034633; 1.1432372542187894 0.5157107691734202; 0.9795946109303236 0.78316244490618; 1.5 -0.8660254037844386; 1.667933235701055 -0.46690333179771687; 1.9817627457812106 -0.9998336874493474; 2.1678305933582656 -0.4770340675725301; 1.0 0.0; 0.96875 0.24803918541230538; 1.125 -0.4841229182759271; 1.209925204288589 -0.18994999349096087; 4.0 0.0; 3.875 0.9921567416492215; 3.75 0.9682458365518543; 3.392649591422822 1.868135099455754; 3.0 1.7320508075688772; 2.47663352859789 2.422041776069266; 2.036474508437579 1.9996673748986948; 1.476838813283469 2.4423032476188924; 3.0 -1.7320508075688772; 3.33586647140211 -0.9338066635954337; 3.713525491562421 -1.0314215383468404; 3.8533107781393525 -0.07808977733852784; 1.0 1.7320508075688772; 0.53913352859789 1.9259634052446553; 0.2864745084375788 1.0314215383468404; 0.021689221860647256 1.0702465189877493; 1.0 -1.7320508075688772; 1.39836647140211 -1.4298850344200444; 1.9635254915624212 -1.9996673748986948; 2.398161186716531 -1.450146505969671; 0.0 0.0; 0.25 -0.9682458365518543; 0.4823504085771781 -0.8759783578065324; 2.457427107756338 0.0; 2.3806325106389528 0.6095382180179997; 2.400248719286796 0.22145094630551537; 2.2703124344786794 0.8098863413522942; 2.228713553878169 0.3961434956966306; 2.060807145340501 0.936572305877416; 2.008342214450718 0.45735103188730947; 1.8321405428523272 0.9412063790423327; 2.228713553878169 -0.3961434956966306; 2.2573253652984517 0.16904428296519428; 2.391906504836078 -0.2359000855817941; 2.3756718916263515 0.36475833313457223; 1.771286446121831 0.3961434956966306; 1.6176746347015485 0.823112458684027; 1.608093495163922 0.2359000855817941; 1.4993281083736478 0.6273984085146493; 1.771286446121831 -0.3961434956966306; 1.8141928546594992 0.05558443577180529; 1.991657785549282 -0.45735103188730947; 2.042859457147672 0.050950362606888955; 1.542572892243662 0.0; 1.4943674893610475 0.3826185236312218; 1.5997512807132042 -0.22145094630551537; 1.6046875655213206 0.18227040029692732; 2.5 0.28867513459481287; 2.350272254766315 0.8997520001694882; 2.2977457514062634 0.4946522019084248; 2.1032480674510485 1.0491253050621814; 2.5 -0.28867513459481287; 2.493477745233685 0.3404439268920383; 2.5772542485937366 -0.010529283632497704; 2.499326728260362 0.6290598009026116; 2.0 0.5773502691896257; 1.79429450953263 1.0553864441020606; 1.7204915028125263 0.5051814855409226; 1.5414213391906861 0.9161438749841808; 2.0 -0.5773502691896257; 2.08070549046737 -0.06322970245283921; 2.2795084971874737 -0.5051814855409226; 2.3335786608093136 0.0760128666650406; 1.5 0.28867513459481287; 1.381522254766315 0.651712814757183; 1.4227457514062631 0.010529283632497704; 1.3756732717396376 0.3630969407466099; 1.5 -0.28867513459481287; 1.524727745233685 0.09240474147973307; 1.7022542485937369 -0.4946522019084248; 1.7717519325489512 -0.0569685634129601; 3.0 0.5773502691896257; 2.76304450953263 1.303425629514366; 2.5954915028125263 0.9893044038168496; 2.2689961349020966 1.6021722392997522; 3.0 -0.5773502691896257; 3.04945549046737 0.18480948295946614; 3.1545084971874737 -0.021058567264995408; 3.0611534565207243 0.7620412309806124; 2.0 1.1547005383792515; 1.65108901906526 1.6146945173795106; 1.4409830056250525 1.0103629710818451; 1.145342678381372 1.3362093791437508; 2.0 -1.1547005383792515; 2.22391098093474 -0.6225377757302891; 2.5590169943749475 -1.0103629710818451; 2.7296573216186277 -0.3440526374945295; 1.0 0.5773502691896257; 0.82554450953263 0.8073472586897553; 0.8454915028125263 0.021058567264995408; 0.813846543479275 0.23011551066860916; 1.0 -0.5773502691896257; 1.11195549046737 -0.31126888786514456; 1.4045084971874737 -0.9893044038168496; 1.6060038650979027 -0.610015497650531; 3.5 0.8660254037844386; 3.175816764298945 1.7070992588592437; 2.893237254218789 1.4839566057252744; 2.4347442023531456 2.155219173537323; 3.5 -0.8660254037844386; 3.605433235701055 0.02917503902689389; 3.731762745781211 -0.031587850897493164; 3.6229801847810874 0.8950226610586132; 2.0 1.7320508075688772; 1.50788352859789 2.1740025906569604; 1.1614745084375788 1.5155444566227676; 0.7492640175720582 1.7562748833033208; 2.0 -1.7320508075688772; 2.36711647140211 -1.181845849007739; 2.838525491562421 -1.5155444566227676; 3.125735982427942 -0.7641181416540994; 0.5 0.8660254037844386; 0.269566764298945 0.9629817026223276; 0.2682372542187894 0.031587850897493164; 0.2520198152189127 0.09713408059060846; 0.5 -0.8660254037844386; 0.699183235701055 -0.7149425172100222; 1.1067627457812106 -1.4839566057252744; 1.4402557976468544 -1.1630624318881018; 3.1666666666666665 0.5527707983925666; 2.9305995147803316 1.3209541314150992; 2.75322432127781 1.048484519915411; 2.4071208150006473 1.6986268965751494; 3.1666666666666665 -0.5527707983925666; 3.2048171518863353 0.24996070952950145; 3.288442345388857 0.08113562272841912; 3.1655537083259775 0.8942626951437391; 2.104619779455164 1.2867483702781282; 1.7196863937527918 1.7685656594056216; 1.4685979309174277 1.1765536569325803; 1.1308728349168322 1.504056189636393; 2.104619779455164 -1.2867483702781282; 2.3580144289415887 -0.7245093080082521; 2.714486683129109 -1.0752559910541442; 2.8963645944120953 -0.3683551756378073; 0.9379531127884976 0.7339775718855617; 0.7265868789724603 0.943689898815133; 0.715373609639618 0.1280691370171696; 0.6612520199161843 0.30150766388585437; 0.9379531127884976 -0.7339775718855617; 1.0906972770552534 -0.4783916467131428; 1.4260443377402523 -1.1563916137825634; 1.6683108860861178 -0.7665394999569356; 0.8333333333333334 -0.5527707983925666; 0.9444004852196686 -0.3287973897658778; 1.24677567872219 -1.048484519915411; 1.4678791849993522 -0.7064701549259279; 0.8333333333333334 0.5527707983925666; 0.6701828481136647 0.7421960321197201; 0.7115576546111432 -0.08113562272841912; 0.7094462916740223 0.09789404650548239; 1.8953802205448353 -1.2867483702781282; 2.155313606247208 -0.7764089177564002; 2.5314020690825716 -1.1765536569325803; 2.7441271650831673 -0.5118994479871717; 1.8953802205448353 1.2867483702781282; 1.516985571058411 1.7166660496574737; 1.2855133168708903 1.0752559910541442; 0.978635405587904 1.3605119172870288; 3.062046887211502 -0.7339775718855617; 3.1484131210275392 0.04846684283408824; 3.284626390360381 -0.1280691370171696; 3.2137479800838147 0.690649077763367; 3.062046887211502 0.7339775718855617; 2.784302722944746 1.470548388362364; 2.573955662259747 1.1563916137825634; 2.206689113913882 1.7586962416061571; 2.1666666666666665 0.024579470797059126; 2.0928616614189655 0.561229597394646; 2.133933848201383 0.10219418999341462; 2.0419002518052527 0.6282998349877377; 2.1666666666666665 -0.024579470797059126; 2.1050550052477015 0.5136068727253438; 2.1577328184652838 0.05918011609856116; 2.0756246800985507 0.5925330281000075; 2.062046887211502 0.156627302695936; 1.9587582134121162 0.663201129672609; 1.978464159447221 0.16708720996571383; 1.8751929790117847 0.6526023731310154; 2.062046887211502 -0.156627302695936; 2.0364576305601694 0.359735730699233; 2.130117893172908 -0.10701056975217421; 2.0900945235630903 0.4246862176073656; 1.8953802205448353 0.13204783189887687; 1.8033965519931507 0.5980499031025737; 1.8445303112458376 0.06489301997229924; 1.7707927272065316 0.5203809089678886; 1.8953802205448353 -0.13204783189887687; 1.8689026253124679 0.3422072287984997; 1.9723850747076244 -0.16619068585073526; 1.9519698434645398 0.32823156033196843; 1.8333333333333333 -0.024579470797059126; 1.7821383385810348 0.4309271442545753; 1.866066151798617 -0.10219418999341462; 1.833099748194747 0.36385690666148396; 1.8333333333333333 0.024579470797059126; 1.7699449947522987 0.4785498689238775; 1.8422671815347165 -0.05918011609856116; 1.7993753199014493 0.39962371354921367; 1.9379531127884972 -0.156627302695936; 1.9162417865878831 0.32895561197661255; 2.0215358405527786 -0.16708720996571383; 1.999807020988215 0.3395543685182061; 1.9379531127884972 0.156627302695936; 1.8385423694398302 0.6324210109499886; 1.8698821068270919 0.10701056975217421; 1.784905476436909 0.5674705240418559; 2.104619779455164 -0.13204783189887687; 2.0716034480068486 0.3941068385466477; 2.1554696887541613 -0.06489301997229924; 2.104207272793468 0.4717758326813328; 2.104619779455164 0.13204783189887687; 2.0060973746875312 0.6499495128507217; 2.027614925292375 0.16619068585073526; 1.9230301565354597 0.6639251813172529; 2.8333333333333335 0.024579470797059126; 2.7386949947522985 0.7265890543361828; 2.7172671815347162 0.424942802177366; 2.5269501156128604 1.0856520778647853; 2.8333333333333335 -0.024579470797059126; 2.7508883385810345 0.6789663296668808; 2.741066151798617 0.38192872828251256; 2.560674543906158 1.0498852709770554; 2.3953802205448356 0.7339775718855617; 2.1384693896114126 1.3051889314208271; 1.9906223289264138 0.8336430015986119; 1.7216392501062745 1.3013439987291093; 2.3953802205448356 -0.7339775718855617; 2.5025797876942057 -0.11689261410744849; 2.701293057027048 -0.450817749201121; 2.7286981162762083 0.2332968348863193; 1.5620468872115023 0.7093981010885027; 1.3372743948591144 1.0746782479092551; 1.2733551473916973 0.40870019942124614; 1.1321891344934143 0.7117702916889348; 1.5620468872115023 -0.7093981010885027; 1.6891914491131714 -0.2997805729497186; 1.9602269052284313 -0.8327464774836335; 2.1055235723700503 -0.3205100652661254; 1.1666666666666667 -0.024579470797059126; 1.1363050052477013 0.26556768731303854; 1.2827328184652835 -0.424942802177366; 1.3480498843871398 -0.09349533621556387; 1.1666666666666667 0.024579470797059126; 1.1241116614189652 0.31319041198234066; 1.258933848201383 -0.38192872828251256; 1.314325456093842 -0.05772852932783402; 1.604619779455164 -0.7339775718855617; 1.7365306103885867 -0.31303218977160596; 2.009377671073586 -0.8336430015986119; 2.153360749893725 -0.3091872570798879; 1.604619779455164 0.7339775718855617; 1.3724202123057936 1.1090493557566699; 1.2987069429729512 0.450817749201121; 1.1463018837237913 0.7588599067629019; 2.437953112788497 -0.7093981010885027; 2.537725605140885 -0.08252150626003368; 2.726644852608302 -0.40870019942124614; 2.742810865506585 0.2803864499602866; 2.437953112788497 0.7093981010885027; 2.185808550886828 1.2919373145989401; 2.039773094771568 0.8327464774836335; 1.7694764276299493 1.3126668069153469; 2.6666666666666665 0.26409566379775373; 2.5178272600140166 0.9172805020702215; 2.4554785698715467 0.5538323180069858; 2.2413727475495993 1.1455799623375784; 2.6666666666666665 -0.26409566379775373; 2.6488394066526504 0.4055951534620737; 2.7111880967951203 0.09166490636091688; 2.6037269800656153 0.7612812650657383; 2.104619779455164 0.7093981010885027; 1.8628918842201616 1.2092575861281716; 1.7481064281049012 0.6713721713916578; 1.5269514957261459 1.083990685476823; 2.104619779455164 -0.7093981010885027; 2.214808938474219 -0.16520123473080212; 2.4349781859416355 -0.5700745055132217; 2.5002859336027816 0.05171032852176288; 1.4379531127884972 0.44530243729074886; 1.2825646242061453 0.7880554548825608; 1.2926278582333548 0.11753985338467186; 1.2230787481765468 0.43448909396385504; 1.4379531127884972 -0.44530243729074886; 1.503469531821568 -0.07471801736826517; 1.7237900891465157 -0.6617394118741386; 1.8340589535371663 -0.21349256571936492; 1.3333333333333333 -0.26409566379775373; 1.3571727399859836 0.07487623957899991; 1.5445214301284533 -0.5538323180069858; 1.6336272524504007 -0.15342322068835704; 1.3333333333333333 0.26409566379775373; 1.2261605933473498 0.5865615881871477; 1.2888119032048801 -0.09166490636091688; 1.2712730199343847 0.230875476583483; 1.8953802205448353 -0.7093981010885027; 2.0121081157798377 -0.21710084447895012; 2.251893571895098 -0.6713721713916578; 2.3480485042738537 -0.09183394382760152; 1.8953802205448353 0.7093981010885027; 1.6601910615257809 1.1573579763800237; 1.5650218140583638 0.5700745055132217; 1.374714066397218 0.9404464131274586; 2.562046887211502 -0.44530243729074886; 2.5924353757938543 0.20410128676666064; 2.7073721417666445 -0.11753985338467186; 2.6519212518234525 0.5576676476853663; 2.562046887211502 0.44530243729074886; 2.371530468178431 1.0668747590174865; 2.276209910853484 0.6617394118741386; 2.040941046462833 1.205649307368586; 2.6666666666666665 0.313254605391872; 2.5056339161852805 0.9649032267395237; 2.431679599607646 0.5968463919018394; 2.2076483192563012 1.1813467692253083; 2.6666666666666665 -0.313254605391872; 2.6610327504813864 0.3579724287927716; 2.734987067059021 0.04865083246606339; 2.637451408358913 0.7255144581780086; 2.062046887211502 0.7339775718855617; 1.8155527229447463 1.2225092029500588; 1.698955662259747 0.6722686955066363; 1.4791143182024709 1.0726678772905853; 2.062046887211502 -0.7339775718855617; 2.1796631210275392 -0.19957234257821702; 2.409626390360381 -0.6121920552930967; 2.4861731843724044 0.004620713447795377; 1.3953802205448353 0.42072296649368973; 1.2474188067594658 0.7536843470351459; 1.2672760626521007 0.0754223036047969; 1.2089659989461694 0.3873994788898879; 1.3953802205448353 -0.42072296649368973; 1.4561303705461528 -0.0614664005463779; 1.6746393233013612 -0.6608428877591601; 1.7862217760134913 -0.2248153739056023; 1.3333333333333333 -0.313254605391872; 1.36936608381472 0.02725351490969785; 1.5683204003923539 -0.5968463919018394; 1.6673516807436985 -0.18919002757608694; 1.3333333333333333 0.313254605391872; 1.2139672495186136 0.6341843128564498; 1.2650129329409796 -0.04865083246606339; 1.2375485916410867 0.26664228347121294; 1.9379531127884972 -0.7339775718855617; 2.059447277055253 -0.23035246130083742; 2.3010443377402523 -0.6722686955066363; 2.3958856817975285 -0.08051113564136408; 1.9379531127884972 0.7339775718855617; 1.6953368789724603 1.1917290842274382; 1.590373609639618 0.6121920552930967; 1.3888268156275951 0.987536028201426; 2.6046197794551635 -0.42072296649368973; 2.627581193240533 0.23847239461407543; 2.7327239373478984 -0.0754223036047969; 2.66603400105383 0.6047572627593335; 2.6046197794551635 0.42072296649368973; 2.4188696294538463 1.0536231421955993; 2.325360676698638 0.6608428877591601; 2.088778223986508 1.2169721155548237; 2.957427107756338 0.28867513459481287; 2.7934047654052674 1.0132118473628773; 2.697994470693059 0.71610314821394; 2.4360605019297275 1.3629332755898649; 2.957427107756338 -0.28867513459481287; 2.9366102558726377 0.45390377408542737; 2.9775029678805325 0.2109216626730176; 2.8321391627390415 0.9428677714302948; 2.228713553878169 0.9734937648862564; 1.917601654873131 1.495880379154866; 1.7288337172632442 0.962532517428232; 1.4360618820430135 1.3612718832019026; 2.228713553878169 -0.9734937648862564; 2.4005308557658216 -0.39026379031225567; 2.6714150020235516 -0.7410815711227167; 2.771750552435666 -0.055307171024997895; 1.271286446121831 0.6848186302914435; 1.0616968894678633 0.9787469026165995; 1.0308392465701854 0.24642936921429173; 0.9375013801132858 0.4944169784366485; 1.271286446121831 -0.6848186302914435; 1.4014205998931841 -0.3480891935730723; 1.693912034143019 -0.9520032337957344; 1.877111389696624 -0.5020965716306819; 1.042572892243662 -0.28867513459481287; 1.0815952345947326 -0.021055105713655847; 1.302005529306941 -0.71610314821394; 1.438939498070272 -0.3707765339406434; 1.042572892243662 0.28867513459481287; 0.9383897441273624 0.538252967563794; 1.0224970321194673 -0.2109216626730176; 1.0428608372609585 0.049288970218926594; 1.771286446121831 -0.9734937648862564; 1.957398345126869 -0.5037236375056446; 2.271166282736756 -0.962532517428232; 2.4389381179569867 -0.3691151415526811; 1.771286446121831 0.9734937648862564; 1.4744691442341784 1.382420531961477; 1.3285849979764484 0.7410815711227167; 1.1032494475643342 1.0474639126742193; 2.728713553878169 -0.6848186302914435; 2.8133031105321367 0.013409839032621931; 2.9691607534298146 -0.24642936921429173; 2.937498619886714 0.49773976321257296; 2.728713553878169 0.6848186302914435; 2.473579400106816 1.3402459352222937; 2.3060879658569813 0.9520032337957344; 1.997888610303376 1.4942533132799032; 3.457427107756338 0.5773502691896257; 3.2061770201715825 1.4168854767077548; 2.995740222099322 1.210755350122365; 2.601808569380776 1.9159802098274357; 3.457427107756338 -0.5773502691896257; 3.4925880011063226 0.29826933015285495; 3.5547572164742696 0.20039237904051996; 3.3939658909994037 1.0758492015082952; 2.228713553878169 1.5508440340758822; 1.7743961644057609 2.055188452432316; 1.4493252200757705 1.4677140029691544; 1.0399832212336997 1.7813373873614726; 2.228713553878169 -1.5508440340758822; 2.5437363462331914 -0.9495718635897055; 2.9509234992110254 -1.2462630566636392; 3.1678292132449797 -0.475372675184568; 0.771286446121831 0.9734937648862564; 0.5057191442341785 1.1343813465491717; 0.45358499797644847 0.2569586528467894; 0.37567465185292337 0.3614355483586477; 0.771286446121831 -0.9734937648862564; 0.9886483451268692 -0.75176282291795; 1.3961662827367558 -1.446655435704159; 1.7113633222455755 -1.0551435058682528; 0.542572892243662 -0.5773502691896257; 0.6688229798284174 -0.4247287350585335; 1.0042597779006779 -1.210755350122365; 1.2731914306192238 -0.9238234681782143; 0.542572892243662 0.5773502691896257; 0.3824119988936774 0.6938874114963663; 0.44524278352573043 -0.20039237904051996; 0.4810341090005959 -0.08369245985907406; 1.771286446121831 -1.5508440340758822; 2.100603835594239 -1.0630317107830947; 2.5506747799242295 -1.4677140029691544; 2.8350167787663003 -0.7891806457122511; 1.771286446121831 1.5508440340758822; 1.3312636537668086 1.9417286052389269; 1.0490765007889746 1.2462630566636392; 0.7071707867550203 1.4675294168337893; 3.228713553878169 -0.9734937648862564; 3.3692808557658216 -0.14222460489995034; 3.5464150020235516 -0.2569586528467894; 3.4993253481470767 0.6307211932905737; 3.228713553878169 0.9734937648862564; 2.8863516548731307 1.7439195645671712; 2.603833717263244 1.446655435704159; 2.1636366777544245 2.0473002475174744; 3.1240937744230046 0.313254605391872; 2.948766426824233 1.0783630739329126; 2.831928318894442 0.8182973382073548; 2.5404607537349806 1.4951547397529918; 3.1240937744230046 -0.313254605391872; 3.1041652611203387 0.47143227598616055; 3.1352357863458162 0.2701017787715788; 2.9702638428375923 1.039322428705692; 2.290760441089671 1.1301210675821922; 1.9388598682852474 1.6630031380028643; 1.7072978767104652 1.1296197273939457; 1.3737548610547983 1.5177958855083076; 2.290760441089671 -1.1301210675821922; 2.499488486325991 -0.5266064304376333; 2.8015328951964595 -0.8480921408748908; 2.924345075998756 -0.12669932424224306; 1.1666666666666667 0.8168664621903203; 0.9275934414610144 1.0807184348945624; 0.8753695578160231 0.311322389186591; 0.7707941073198172 0.5187195165799261; 1.1666666666666667 -0.8168664621903203; 1.332823225205652 -0.5019603355991831; 1.666297108850643 -1.1181939196464696; 1.8915812331611639 -0.6699433821233242; 0.8759062255769953 -0.313254605391872; 0.9262335731757674 -0.08620633228369112; 1.168071681105558 -0.8182973382073548; 1.3345392462650192 -0.5029979981037702; 0.8759062255769953 0.313254605391872; 0.7708347388796613 0.520724465663061; 0.864764213654184 -0.2701017787715788; 0.9047361571624076 -0.04716568705647051; 1.709239558910328 -1.1301210675821922; 1.9361401317147524 -0.6708463963536427; 2.2927021232895344 -1.1296197273939457; 2.501245138945201 -0.5256391438590859; 1.709239558910328 1.1301210675821922; 1.3755115136740086 1.5187631720868546; 1.19846710480354 0.8480921408748908; 0.9506549240012436 1.1188560658914644; 2.8333333333333335 -0.8168664621903203; 2.947406558538985 -0.08856169324534102; 3.1246304421839763 -0.311322389186591; 3.104205892680182 0.47343722506929514; 2.8333333333333335 0.8168664621903203; 2.5421767747943473 1.4941170772484045; 2.3337028911493563 1.1181939196464696; 1.9834187668388354 1.6621001237725457; 2.790760441089671 0.313254605391872; 2.625849760157566 0.9956833454621442; 2.5402616522277754 0.6569230321153791; 2.297935821831177 1.2664786183144678; 2.790760441089671 -0.313254605391872; 2.7812485944536722 0.38875254751539223; 2.8435691196791497 0.10872747267960303; 2.7277389109337884 0.8106463072671681; 2.1240937744230046 0.8414459329873795; 1.8490042801855986 1.342009237128755; 1.7012187919708686 0.7963418315774966; 1.4505317255075534 1.1934250727092606; 2.1240937744230046 -0.8414459329873795; 2.2664274077589726 -0.28829225803429265; 2.515945313269389 -0.6761885511504174; 2.6050432796421967 -0.03100463288172011; 1.3333333333333333 0.5281913275955075; 1.1606545200280327 0.8424042624912216; 1.1609571397430931 0.13941879946211763; 1.0900959036763762 0.4230248252194032; 1.3333333333333333 -0.5281913275955075; 1.4226788133053003 -0.18096643472507395; 1.67237619359024 -0.7849160238300205; 1.8148043687084088 -0.34557256932427705; 1.2092395589103284 -0.313254605391872; 1.2491502398424341 -0.0035266038129226907; 1.4597383477722248 -0.6569230321153791; 1.5770641781688228 -0.2743218766652463; 1.2092395589103284 0.313254605391872; 1.093751405546328 0.6034041941338294; 1.1564308803208507 -0.10872747267960303; 1.1472610890662112 0.1815104343820535; 1.8759062255769952 -0.8414459329873795; 2.0259957198144005 -0.34985249547953373; 2.298781208029131 -0.7963418315774966; 2.424468274492446 -0.20126833106003902; 1.8759062255769952 0.8414459329873795; 1.6085725922410268 1.280448999683514; 1.4840546867306101 0.6761885511504174; 1.2699567203578022 1.0231613745309414; 2.6666666666666665 -0.5281913275955075; 2.714345479971967 0.14975247915799983; 2.839042860256906 -0.13941879946211763; 2.7849040963236233 0.5691319164298183; 2.6666666666666665 0.5281913275955075; 2.4523211866946992 1.1731231763742953; 2.32762380640976 0.7849160238300205; 2.060195631291591 1.3377293109734985; 3.1240937744230046 0.26409566379775373; 2.960959770652969 1.0307403492636105; 2.8557272891583425 0.7752832643125013; 2.574185182028278 1.4593879328652617; 3.1240937744230046 -0.26409566379775373; 3.0919719172916027 0.5190550006554625; 3.111436816081916 0.3131158526664322; 2.9365394145442947 1.0750892355934216; 2.3333333333333335 1.1055415967851332; 1.9861990295606626 1.6497515211809772; 1.7564486425556194 1.1287232032789674; 1.421592038578473 1.529118693694545; 2.3333333333333335 -1.1055415967851332; 2.53463430377267 -0.4922353225902186; 2.826884690777713 -0.805974591095016; 2.9384578252291336 -0.0796097091682757; 1.2092395589103282 0.8414459329873795; 0.9627392589076936 1.1150895427419771; 0.900721353397277 0.35343993896646597; 0.7849068565501949 0.5658091316538937; 1.2092395589103282 -0.8414459329873795; 1.3801623864810675 -0.5152119524210705; 1.7154478746957975 -1.119090443761448; 1.9394184106848387 -0.6586205739370868; 0.8759062255769953 -0.26409566379775373; 0.9140402293470312 -0.03858360761438909; 1.1442727108416577 -0.7752832643125013; 1.3008148179717214 -0.4672311912160406; 0.8759062255769953 0.26409566379775373; 0.7830280827083974 0.47310174099375873; 0.8885631839180843 -0.3131158526664322; 0.9384605854557053 -0.08293249394420026; 1.6666666666666667 -1.1055415967851332; 1.8888009704393371 -0.6575947795317556; 2.2435513574443804 -1.1287232032789674; 2.4534079614215263 -0.5369619520453234; 1.6666666666666667 1.1055415967851332; 1.3403656962273294 1.4843920642394401; 1.1731153092222861 0.805974591095016; 0.9365421747708659 1.0717664508174973; 2.7907604410896707 -0.8414459329873795; 2.9122607410923056 -0.1229328010927558; 3.0992786466027225 -0.35343993896646597; 3.0900931434498045 0.42634760999532767; 2.7907604410896707 0.8414459329873795; 2.4948376135189316 1.5073686940702917; 2.2845521253042014 1.119090443761448; 1.9355815893151607 1.6507773155863081; 2.790760441089671 0.26409566379775373; 2.6380431039863024 0.9480606207928418; 2.5640606224916755 0.6139089582205255; 2.3316602501244748 1.2307118114267381; 2.790760441089671 -0.26409566379775373; 2.769055250624936 0.4363752721846941; 2.819770149415249 0.15174154657445652; 2.694014482640491 0.8464131141548976; 2.1666666666666665 0.8168664621903203; 1.8963434414610143 1.3287576203068674; 1.750369557816023 0.7954453074625182; 1.4983689030312282 1.2047478808954977; 2.1666666666666665 -0.8168664621903203; 2.3015732252056518 -0.25392115018687783; 2.5412971088506433 -0.6340710013705424; 2.619156028872575 0.016084982192247407; 1.375906225576995 0.5527707983925666; 1.1958003374747117 0.8767753703386365; 1.186308935324347 0.18153634924199255; 1.1042086529067536 0.4701144402933707; 1.375906225576995 -0.5527707983925666; 1.4700179745807156 -0.19421805154696126; 1.721526959435394 -0.785812547944999; 1.8626415462320836 -0.3342497611380397; 1.2092395589103284 -0.26409566379775373; 1.236956896013698 0.044096120856379366; 1.4359393775083245 -0.6139089582205255; 1.5433397498755252 -0.23855506977751667; 1.2092395589103284 0.26409566379775373; 1.1059447493750643 0.5557814694645273; 1.180229850584751 -0.15174154657445652; 1.1809855173595087 0.14574362749432354; 1.8333333333333333 -0.8168664621903203; 1.978656558538985 -0.33660087865764626; 2.2496304421839763 -0.7954453074625182; 2.3766310969687714 -0.21259113924627648; 1.8333333333333333 0.8168664621903203; 1.5734267747943476 1.246077891836099; 1.4587028911493563 0.6340710013705424; 1.2558439711274247 0.976071759456974; 2.6240937744230046 -0.5527707983925666; 2.6791996625252876 0.11538137131058501; 2.8136910646756523 -0.18153634924199255; 2.7707913470932457 0.5220423013558508; 2.6240937744230046 0.5527707983925666; 2.4049820254192835 1.1863747931961828; 2.2784730405646054 0.785812547944999; 2.0123584537679156 1.3264065027872611; 2.6240937744230046 0.024579470797059126; 2.5359941720579178 0.6746894445880348; 2.5341825674881786 0.3236451362989299; 2.3747126862839325 0.9421078055154208; 2.6240937744230046 -0.024579470797059126; 2.548187515886654 0.6270667199187328; 2.557981537752079 0.2806310624040763; 2.4084371145772296 0.9063409986276912; 2.290760441089671 0.5527707983925666; 2.082065358752617 1.1036950647254145; 1.9868063738979387 0.6244382418530232; 1.7698335218641121 1.0977303813487373; 2.290760441089671 -0.5527707983925666; 2.356282995858621 0.03270164283981658; 2.522024398008986 -0.34291065533396825; 2.5282664151894423 0.293366179917327; 1.6666666666666667 0.5281913275955075; 1.4835711866946992 0.9250839909619899; 1.4526238064097599 0.3007931055540932; 1.3326208355801799 0.651700946657927; 1.6666666666666667 -0.5281913275955075; 1.7455954799719668 -0.0982867062543056; 1.9640428602569064 -0.6235417177380448; 2.0573293006122126 -0.11689644788575339; 1.3759062255769954 -0.024579470797059126; 1.3390058279420822 0.31746729706118654; 1.465817432511821 -0.3236451362989299; 1.500287313716068 0.050048936133800445; 1.3759062255769954 0.024579470797059126; 1.3268124841133462 0.3650900217304886; 1.4420184622479206 -0.2806310624040763; 1.4665628854227704 0.08581574302153029; 1.709239558910328 -0.5527707983925666; 1.7929346412473826 -0.11153832307619282; 2.0131936261020607 -0.6244382418530232; 2.1051664781358874 -0.10557363969951583; 1.709239558910328 0.5527707983925666; 1.5187170041413784 0.9594550988094049; 1.4779756019910137 0.34291065533396825; 1.3467335848105575 0.6987905617318946; 2.3333333333333335 -0.5281913275955075; 2.3914288133053003 0.06707275068723138; 2.5473761935902397 -0.3007931055540932; 2.5423791644198195 0.3404557949912944; 2.3333333333333335 0.5281913275955075; 2.1294045200280323 1.090443447903527; 2.035957139743093 0.6235417177380448; 1.817670699387787 1.1090531895349744; 2.290760441089671 0.024579470797059126; 2.2130775053912513 0.5920097161172664; 2.2425159008215125 0.1622708302069542; 2.132187754380128 0.713431684076897; 2.290760441089671 -0.024579470797059126; 2.2252708492199873 0.5443869914479643; 2.2663148710854126 0.11925675631210073; 2.1659121826734262 0.6776648771891673; 2.1240937744230046 0.26409566379775373; 1.992209770652969 0.7827011638513052; 1.9807272891583423 0.2911603460365741; 1.846610386316867 0.7733595685496902; 2.1240937744230046 -0.26409566379775373; 2.1232219172916027 0.27101581524315727; 2.2364368160819157 -0.17100706560949494; 2.2089646188328835 0.38906087127785005; 1.8333333333333333 0.2395161930006946; 1.7166322652617174 0.6867698185586496; 1.7382113883368298 0.12888951582962005; 1.6519226319367386 0.5560062552974039; 1.8333333333333333 -0.2395161930006946; 1.8354510680716152 0.2227071946198036; 1.9701219449965028 -0.2902638219215957; 1.9805524361594573 0.20747436491329363; 1.7092395589103284 -0.024579470797059126; 1.6619224946087492 0.4001470255319549; 1.757484099178488 -0.1622708302069542; 1.7428122456198714 0.2787250575723244; 1.7092395589103284 0.024579470797059126; 1.6497291507800131 0.44776975020125703; 1.7336851289145876 -0.11925675631210073; 1.7090878173265736 0.31449186446005417; 1.8759062255769952 -0.26409566379775373; 1.8827902293470309 0.20945557779791618; 2.019272710841657 -0.2911603460365741; 2.028389613683132 0.21879717309953103; 1.8759062255769952 0.26409566379775373; 1.7517780827083966 0.721140926406064; 1.7635631839180834 0.17100706560949494; 1.6660353811671158 0.6030958703713712; 2.1666666666666665 -0.2395161930006946; 2.158367734738282 0.305386923090572; 2.2617886116631696 -0.12888951582962005; 2.2230773680632607 0.43615048635181747; 2.1666666666666665 0.2395161930006946; 2.039548931928384 0.7694495470294179; 2.0298780550034965 0.2902638219215957; 1.894447563840542 0.7846823767359281; 3.5620468872115025 0.13204783189887687; 3.4179798853264844 1.011448545456416; 3.302863644579171 0.8717645504321778; 2.9834173867255505 1.6637615161605077; 3.5620468872115025 -0.13204783189887687; 3.4834859586458014 0.7556058711523419; 3.4307184080409576 0.6406808446091432; 3.1645945029835585 1.4716121675245875; 2.6666666666666665 1.418796202177005; 2.2314162790792764 2.0358966486251213; 1.896461575496599 1.5641952890888309; 1.449215425930971 1.9857109706567186; 2.6666666666666665 -1.418796202177005; 2.9352503875873897 -0.7130209930928262; 3.2702050911700673 -0.9186980647209282; 3.395884301684243 -0.07884974325340166; 1.104619779455164 1.2867483702781284; 0.7509363937527919 1.520526473993316; 0.5935979309174279 0.6924307386566532; 0.40329803920542107 0.8180278253208213; 1.104619779455164 -1.2867483702781284; 1.3892644289415887 -0.9725484934205575; 1.839486683129109 -1.5593789093300712; 2.1687897987006846 -1.054383539953379; 0.43795311278849763 -0.13204783189887687; 0.4570201146735156 -0.019291803807194544; 0.6971363554208287 -0.8717645504321778; 0.89158261327445 -0.6716047745112863; 0.43795311278849763 0.13204783189887687; 0.3915140413541987 0.23655087049687937; 0.569281591959042 -0.6406808446091432; 0.7104054970164417 -0.4794554258753663; 1.3333333333333333 -1.418796202177005; 1.6435837209207234 -1.0437399069759001; 2.1035384245034003 -1.5641952890888309; 2.4257845740690285 -0.9935542290074972; 1.3333333333333333 1.418796202177005; 0.9397496124126096 1.7051777347420476; 0.7297949088299325 0.9186980647209282; 0.47911569831575646 1.0710064849026233; 2.895380220544835 -1.2867483702781284; 3.124063606247208 -0.5283697323440948; 3.4064020690825716 -0.6924307386566532; 3.4717019607945785 0.17412891632839986; 2.895380220544835 1.2867483702781284; 2.485735571058411 1.9647052350697787; 2.1605133168708903 1.5593789093300712; 1.7062102012993148 2.0465402816026; 3.3953802205448356 0.42072296649368973; 3.184918806759466 1.2497627178597568; 3.017276062652101 1.0436681401566512; 2.6641155903689913 1.759456207521031; 3.3953802205448356 -0.42072296649368973; 3.3936303705461532 0.4346119702782328; 3.4246393233013617 0.3074029487926941; 3.2413713674363134 1.1472413547255407; 2.3333333333333335 1.418796202177005; 1.9084996124126095 1.953216920154353; 1.6047949088299323 1.4028209829968552; 1.2066904940271672 1.7570348492181949; 2.3333333333333335 -1.418796202177005; 2.612333720920723 -0.7957007215635946; 2.9785384245034003 -1.0800723708129039; 3.153359369780439 -0.30752586469192555; 0.9379531127884976 0.9980732356833155; 0.6610808056531434 1.1995325731192068; 0.5875188461778312 0.3591528428402041; 0.48007490365817623 0.4936570125217746; 0.9379531127884976 -0.9980732356833155; 1.1562033503745701 -0.7342343210172168; 1.5538991012020391 -1.3874753196055978; 1.8494880023441262 -0.9586888485928557; 0.6046197794551642 -0.42072296649368973; 0.690081193240534 -0.25760597621053527; 0.9827239373478991 -1.0436681401566512; 1.2108844096310085 -0.7672994658718095; 0.6046197794551642 0.42072296649368973; 0.4813696294538471 0.5575447713709886; 0.5753606766986387 -0.3074029487926941; 0.6336286325636865 -0.15508461307631935; 1.6666666666666667 -1.418796202177005; 1.9665003875873899 -0.9610601785051316; 2.3952050911700673 -1.4028209829968552; 2.668309505972832 -0.7648781075689733; 1.6666666666666667 1.418796202177005; 1.2626662790792764 1.7878574632128161; 1.021461575496599 1.0800723708129039; 0.7216406302195602 1.2996826063411473; 3.062046887211502 -0.9980732356833155; 3.213919194346856 -0.20737583146998564; 3.412481153822168 -0.3591528428402041; 3.394925096341823 0.498499729127447; 3.062046887211502 0.9980732356833155; 2.718796649625429 1.726391062666438; 2.4461008987979604 1.3874753196055978; 2.0255119976558738 1.9508455902420774; 3.228713553878169 0.39614349569663065; 3.029557145340501 1.1846114912897217; 2.883342214450718 0.9414739501632368; 2.5597153385637386 1.6272347433579044; 3.228713553878169 -0.39614349569663065; 3.2260753652984517 0.4170834683774996; 3.266906504836078 0.24822283269413298; 3.1032466873377627 1.0507866974501439; 2.271286446121831 1.2621688994810691; 1.8872413990004935 1.7860941613063548; 1.6263307493827117 1.2357337730311413; 1.268997515015383 1.60051084691179; 2.271286446121831 -1.2621688994810691; 2.513376090360554 -0.659358081438217; 2.8484205313304924 -0.9730618010607298; 3.000764846217349 -0.23613371147468043; 1.042572892243662 0.8660254037844386; 0.7951842536599925 1.097561040841244; 0.7429885349319936 0.2942598228679049; 0.6467821764516444 0.4693544743784967; 1.042572892243662 -0.8660254037844386; 1.2248007250621025 -0.5803631789911058; 1.5815140264944147 -1.2212846337548626; 1.8350181588795862 -0.7908420381002135; 0.771286446121831 -0.39614349569663065; 0.8454428546594992 -0.1924547496405002; 1.116657785549282 -0.9414739501632368; 1.3152846614362617 -0.6350780017086828; 0.771286446121831 0.39614349569663065; 0.6489246347015485 0.5750732732717219; 0.7330934951639222 -0.24822283269413298; 0.7717533126622372 -0.05862995580092212; 1.728713553878169 -1.2621688994810691; 1.9877586009995065 -0.7939374196571334; 2.3736692506172883 -1.2357337730311413; 2.606002484984617 -0.6083541052625687; 1.728713553878169 1.2621688994810691; 1.3616239096394458 1.6515148230874381; 1.1515794686695073 0.9730618010607298; 0.874235153782651 1.2282904531239018; 2.957427107756338 -0.8660254037844386; 3.0798157463400075 -0.10540429919202263; 3.2570114650680067 -0.2942598228679049; 3.2282178235483556 0.5228022672707245; 2.957427107756338 0.8660254037844386; 2.6501992749378975 1.572519920640327; 2.418485973505585 1.2212846337548626; 2.039981841120414 1.7829987797494349; 3.228713553878169 0.7093981010885027; 2.9518577281924476 1.4880768902630974; 2.7316884807250306 1.2155717298811246; 2.3448137940124325 1.855150898881554; 3.228713553878169 -0.7093981010885027; 3.3037747824465047 0.11361806940412372; 3.418560238561765 -0.025874947023755035; 3.3181482318890687 0.8228705419264941; 2.0 1.418796202177005; 1.585582945745943 1.8705371916835845; 1.313128242163266 1.2414466769048795; 0.9641655621233641 1.5283587277796706; 2.0 -1.418796202177005; 2.289417054254057 -0.8783804500343629; 2.686871757836734 -1.2414466769048795; 2.9108344378766358 -0.5362019861304496; 0.7712864461218307 0.7093981010885025; 0.5712252175534952 0.8785386722450977; 0.5814397614382348 0.025874947023754986; 0.5568517681109313 0.16928619972272754; 0.7712864461218307 -0.7093981010885025; 0.923142271807552 -0.49592014861387596; 1.2683115192749688 -1.2155717298811246; 1.530186205987567 -0.8629941572323327; 3.0620468872115025 0.42072296649368973; 2.862002140092799 1.167082989388988; 2.725609395985434 0.8822938340646753; 2.421590658465188 1.5307800860825072; 3.0620468872115025 -0.42072296649368973; 3.0707137038794863 0.35193224180746424; 3.1329726566346947 0.14602864270071836; 2.99884643553251 0.9185652332870168; 2.1666666666666665 1.1301210675821922; 1.8186440243129611 1.6322230192802434; 1.5987158240903359 1.0695430871804061; 1.2834673584799223 1.4326640364191479; 2.1666666666666665 -1.1301210675821922; 2.3792726423537047 -0.5573865491602539; 2.69295084257633 -0.9081687810884304; 2.8340575734238804 -0.21183117333140256; 1.104619779455164 0.7093981010885025; 0.8941418842201617 0.9612184007158662; 0.8731064281049015 0.18724925311573068; 0.7993767000147349 0.39796232116125146; 1.104619779455164 -0.7093981010885025; 1.2460589384742187 -0.4132404201431075; 1.5599781859416355 -1.054197423789149; 1.7727111378913707 -0.6343180357938087; 0.9379531127884977 -0.42072296649368973; 1.0129978599072005 -0.17492624773976687; 1.2743906040145656 -0.8822938340646753; 1.4534093415348124 -0.5386233444332857; 0.9379531127884977 0.42072296649368973; 0.8042862961205136 0.640224499841757; 0.8670273433653052 -0.14602864270071836; 0.8761535644674904 0.07359150836220449; 1.8333333333333333 -1.1301210675821922; 2.056355975687038 -0.6400662776310223; 2.4012841759096633 -1.0695430871804061; 2.591532641520077 -0.44050729476992645; 1.8333333333333333 1.1301210675821922; 1.4957273576462944 1.549543290809475; 1.3070491574236691 0.9081687810884304; 1.0409424265761191 1.2039879149806239; 2.895380220544835 -0.7093981010885025; 2.9808581157798377 0.030938340933355235; 3.1268935718950983 -0.18724925311573068; 3.0756232999852644 0.5941944204879701; 2.895380220544835 0.7093981010885025; 2.628941061525781 1.405397161792329; 2.440021814058364 1.054197423789149; 2.1022888621086286 1.6264747774430304; 3.0620468872115025 0.156627302695936; 2.927508213412116 0.9112403150849144; 2.853464159447221 0.6512101282416409; 2.602767774723196 1.3386307374465871; 3.0620468872115025 -0.156627302695936; 3.0052076305601694 0.6077749161115384; 3.005117893172908 0.3771123485237529; 2.817669319274502 1.1107145819229374; 2.3953802205448356 0.9980732356833154; 2.0729633162920957 1.5610316057249012; 1.8627675654646272 1.0647267074216464; 1.5404621338482665 1.4934933473650294; 2.3953802205448356 -0.9980732356833154; 2.5680858610135227 -0.3727352884115225; 2.829147820488835 -0.6819014550241556; 2.909875232534216 0.04114748625039903; 1.3333333333333333 0.8414459329873795; 1.0829551028799795 1.1458696614645976; 1.0093034060174062 0.4135165791800056; 0.8751943591250705 0.6509409807430532; 1.3333333333333333 -0.8414459329873795; 1.5003782304533535 -0.48443183369845; 1.8240299273159268 -1.0590138035479084; 2.029705913259715 -0.5734887248479271; 0.9379531127884977 -0.156627302695936; 0.9474917865878836 0.08091642656430714; 1.146535840552779 -0.6512101282416409; 1.2722322252768041 -0.34647399579736554; 0.9379531127884977 0.156627302695936; 0.8697923694398305 0.3843818255376832; 0.9948821068270919 -0.3771123485237529; 1.0573306807254985 -0.11855784027371563; 1.604619779455164 -0.9980732356833154; 1.8020366837079036 -0.5688748640756798; 2.137232434535372 -1.0647267074216464; 2.334537866151733 -0.5013366057158081; 1.604619779455164 0.9980732356833154; 1.3069141389864767 1.3648920300607437; 1.1708521795111644 0.6819014550241556; 0.9651247674657832 0.9510092553988221; 2.6666666666666665 -0.8414459329873795; 2.79204489712002 -0.1537129198153762; 2.9906965939825936 -0.4135165791800056; 2.999805640874929 0.34121576090616823; 2.6666666666666665 0.8414459329873795; 2.3746217695466463 1.4765885753476713; 2.1759700726840725 1.0590138035479084; 1.845294086740285 1.5656454664971482; 2.8953802205448356 0.44530243729074886; 2.694447134845098 1.1495544874882548; 2.567876577520151 0.8231137179661144; 2.283465978366637 1.43432542880711; 2.8953802205448356 -0.44530243729074886; 2.9153520424605213 0.286781015237429; 2.999038808433312 0.04383445270730383; 2.894446183727257 0.7863437691238903; 2.062046887211502 0.9980732356833155; 1.7500466496254292 1.4783518772541326; 1.5711008987979604 0.9033524013296709; 1.2979372019444626 1.2648172259265056; 2.062046887211502 -0.9980732356833155; 2.245169194346856 -0.4554150168822909; 2.537481153822168 -0.8432757611161313; 2.6673503006304125 -0.18752863518812465; 1.1666666666666667 0.5527707983925666; 0.9930995147803313 0.8248757605904886; 1.0032243212778098 0.08023868336355655; 0.9519712235778255 0.3265701679440063; 1.1666666666666667 -0.5527707983925666; 1.267317151886335 -0.2461176612951093; 1.5384423453888565 -0.8871102138234351; 1.7104041169031559 -0.47779403348740407; 1.1046197794551642 -0.44530243729074886; 1.180552865154902 -0.1573977458390337; 1.4321234224798491 -0.8231137179661144; 1.5915340216333629 -0.4421686871578886; 1.1046197794551642 0.44530243729074886; 0.959647957539479 0.7053757264117922; 1.0009611915666885 -0.04383445270730383; 0.9805538162727432 0.20581297252533118; 1.9379531127884972 -0.9980732356833155; 2.12495335037457 -0.4861951356049114; 2.428899101202039 -0.9033524013296709; 2.5770627980555365 -0.2726604842772842; 1.9379531127884972 0.9980732356833155; 1.6298308056531432 1.4475717585315122; 1.4625188461778311 0.8432757611161313; 1.2076496993695869 1.179685376837346; 2.8333333333333335 -0.5527707983925666; 2.8819004852196684 0.167280981058733; 2.9967756787221895 -0.08023868336355655; 2.9230287764221736 0.6655865737052151; 2.8333333333333335 0.5527707983925666; 2.6076828481136647 1.2382744029443309; 2.4615576546111426 0.8871102138234351; 2.1645958830968435 1.4699507751366254; 2.8953802205448356 0.13204783189887687; 2.7721465519931514 0.846089088514879; 2.7195303112458378 0.5490159382482264; 2.4983675229179427 1.2064092732834601; 2.8953802205448356 -0.13204783189887687; 2.8376526253124683 0.590246414210805; 2.8473850747076246 0.3179322324251918; 2.6795446391759508 1.0142599246475401; 2.3333333333333335 0.8414459329873795; 2.0517051028799793 1.393908846876903; 1.884303406017406 0.8976394974559326; 1.6027691548364813 1.3369693450586246; 2.3333333333333335 -0.8414459329873795; 2.4691282304533533 -0.23639264828614465; 2.6990299273159266 -0.5748908852719813; 2.757280708971125 0.11253963946764436; 1.4379531127884972 0.7093981010885025; 1.2170585508868281 1.0438981291866347; 1.1647730947715682 0.3486235592077064; 1.0419016319185388 0.6266384425997753; 1.4379531127884972 -0.7093981010885025; 1.5689756051408852 -0.3305606916723391; 1.8516448526083022 -0.8928231176971733; 2.0152360697951743 -0.40564191435528485; 1.1046197794551642 -0.13204783189887687; 1.102853448006849 0.1460676531343423; 1.2804696887541622 -0.5490159382482264; 1.376632477082057 -0.21425253163423885; 1.1046197794551642 0.13204783189887687; 1.0373473746875321 0.4019103274384162; 1.1526149252923754 -0.3179322324251918; 1.195455360824049 -0.02210318299831866; 1.6666666666666667 -0.8414459329873795; 1.82329489712002 -0.4017521052276816; 2.1156965939825936 -0.8976394974559326; 2.2722308451635183 -0.34481260340940323; 1.6666666666666667 0.8414459329873795; 1.405871769546646 1.2285493899353659; 1.3009700726840727 0.5748908852719813; 1.117719291028874 0.8796171021815771; 2.562046887211502 -0.7093981010885025; 2.657941449113171 -0.0517413875374132; 2.8352269052284313 -0.3486235592077064; 2.8330983680814605 0.3655182990494462; 2.562046887211502 0.7093981010885025; 2.3060243948591146 1.3227174333215606; 2.148355147391697 0.8928231176971733; 1.859763930204825 1.3977986560045064; 2.728713553878169 0.10746836110181775; 2.616784890574186 0.7809378619448438; 2.585596463044455 0.4468217482548119; 2.39396727111269 1.0741878091203334; 2.728713553878169 -0.10746836110181775; 2.6700976200647664 0.5727179123100719; 2.689652256242341 0.25875211632663075; 2.5414199590774005 0.917805267372143; 2.2712864461218305 0.6848186302914435; 2.030446889467863 1.2267860880289048; 1.905839246570185 0.7305522874902188; 1.6650761758246966 1.1804453427522201; 2.2712864461218305 -0.6848186302914435; 2.370170599893184 -0.10005000816076699; 2.5689120341430187 -0.4678803155198073; 2.604686185408035 0.18393179268488974; 1.5425728922436615 0.5773502691896257; 1.3511619988936774 0.9419265969086716; 1.3202427835257304 0.2837305392354072; 1.208608904712007 0.6023359044564974; 1.5425728922436615 -0.5773502691896257; 1.6375729798284173 -0.17668954964622827; 1.8792597779006777 -0.7266324318464379; 2.0007662263306343 -0.2377951038626426; 1.271286446121831 -0.10746836110181775; 1.258215109425814 0.21121887970437764; 1.4144035369555452 -0.4468217482548119; 1.4810327288873102 -0.08203106747111188; 1.271286446121831 0.10746836110181775; 1.2049023799352334 0.41943882933914955; 1.3103477437576592 -0.25875211632663075; 1.3335800409225997 0.0743514742770783; 1.7287135538781688 -0.6848186302914435; 1.8445531105321367 -0.23462934637968344; 2.0941607534298146 -0.7305522874902188; 2.209923824175303 -0.18828860110299864; 1.7287135538781688 0.6848186302914435; 1.5048294001068159 1.092206749809988; 1.4310879658569808 0.4678803155198073; 1.2703138145919648 0.8082249489643316; 2.457427107756338 -0.5773502691896257; 2.5238380011063226 0.050230144740549716; 2.6797572164742696 -0.2837305392354072; 2.6663910952879926 0.389820837192724; 2.457427107756338 0.5773502691896257; 2.2374270201715825 1.1688462912954496; 2.120740222099322 0.7266324318464379; 1.8742337736693653 1.2299518455118643; 2.728713553878169 0.42072296649368973; 2.5390854734261326 1.0844032609182197; 2.4339427293187677 0.7209195279726996; 2.179065726561384 1.3021039646439831; 2.728713553878169 -0.42072296649368973; 2.7477970372128198 0.2692525133366959; 2.841305989968028 -0.015345663391257303; 2.756321503628706 0.689889111848493; 2.0 0.8414459329873795; 1.728788436213313 1.3112291184061347; 1.5926367393507397 0.7362651913639571; 1.3602442229326779 1.1082932236201006; 2.0 -0.8414459329873795; 2.1462115637866868 -0.31907237675691313; 2.4073632606492605 -0.7362651913639571; 2.514755777067322 -0.1161364819708794; 1.271286446121831 0.42072296649368973; 1.12720296278718 0.7229042283125255; 1.1586940100319716 0.015345663391257303; 1.1186784963712937 0.30226762980072824; 1.271286446121831 -0.42072296649368973; 1.335914526573867 -0.09224651926899836; 1.566057270681232 -0.7209195279726996; 1.6959342734386156 -0.3099472229947619; 2.728713553878169 0.156627302695936; 2.60459154674545 0.8285605866141459; 2.5617974927805545 0.48983582214966526; 2.360242842819392 1.109954616008063; 2.728713553878169 -0.156627302695936; 2.682290963893503 0.5250951876407699; 2.7134512265062414 0.21573804243177724; 2.575144387370698 0.8820384604844131; 2.228713553878169 0.7093981010885025; 1.9831077281924476 1.240037704850792; 1.8566884807250303 0.7314488116051974; 1.6172389983010216 1.1691225345659826; 2.228713553878169 -0.7093981010885025; 2.3350247824465047 -0.13442111600818174; 2.5435602385617644 -0.509997865299682; 2.5905734361776576 0.13684217761092224; 1.5 0.5527707983925666; 1.3160161814469982 0.9075554890612569; 1.2948909879444763 0.24161298945553228; 1.1944961554816291 0.55524628938253; 1.5 -0.5527707983925666; 1.5902338185530018 -0.16343793282434088; 1.8301090120555235 -0.7257359077314594; 1.9529290488069597 -0.2491179120488802; 1.271286446121831 -0.156627302695936; 1.2704084532545503 0.16359615503507557; 1.4382025072194455 -0.48983582214966526; 1.5147571571806078 -0.11779787435884165; 1.271286446121831 0.156627302695936; 1.1927090361064971 0.4670615540084516; 1.2865487734937586 -0.21573804243177724; 1.299855612629302 0.11011828116480821; 1.7712864461218307 -0.7093981010885025; 1.8918922718075517 -0.2478809632015707; 2.143311519274969 -0.7314488116051974; 2.2577610016989778 -0.17696579291676112; 1.7712864461218307 0.7093981010885025; 1.539975217553495 1.126577857657403; 1.456439761438235 0.509997865299682; 1.284426563822342 0.8553145640382992; 2.5 -0.5527707983925666; 2.558983818553002 0.08460125258796447; 2.705109012055524 -0.24161298945553228; 2.6805038445183706 0.4369104522666914; 2.5 0.5527707983925666; 2.284766181446998 1.1555946744735623; 2.1698909879444765 0.7257359077314594; 1.92207095119304 1.2412746536981016; 2.5620468872115025 0.13204783189887687; 2.4492298853264844 0.7634093600441105; 2.427863644579171 0.38764163215625064; 2.2558425910141393 0.9777331518449363; 2.5620468872115025 -0.13204783189887687; 2.5147359586458014 0.5075666857400367; 2.5557184080409576 0.1565579263332161; 2.4370197072721473 0.7855838032090161; 2.1666666666666665 0.5527707983925666; 1.9618495147803316 1.0729149460027938; 1.8782243212778096 0.5643616016394837; 1.6795460192892364 1.0125985322595779; 2.1666666666666665 -0.5527707983925666; 2.2360671518863353 0.0019215241171960384; 2.4134423453888565 -0.402987295547508; 2.4379789126145663 0.2082343308281675; 1.604619779455164 0.42072296649368973; 1.4501196294538468 0.8055839567832939; 1.450360676698638 0.17671996948323299; 1.3612034282750973 0.5309437512392521; 1.604619779455164 -0.42072296649368973; 1.6588311932405335 -0.00956679079822992; 1.8577239373478986 -0.559545221880724; 1.9384592053424192 -0.08127110155623804; 1.4379531127884977 -0.13204783189887687; 1.4257701146735156 0.22874738160511077; 1.5721363554208287 -0.38764163215625064; 1.619157408985861 0.014423589804285106; 1.4379531127884977 0.13204783189887687; 1.3602640413541986 0.48459005590918475; 1.444281591959042 -0.1565579263332161; 1.4379802927278527 0.20657293844020524; 1.8333333333333333 -0.5527707983925666; 1.9131504852196686 -0.0807582043535724; 2.1217756787221895 -0.5643616016394837; 2.195453980710763 -0.020441790610356336; 1.8333333333333333 0.5527707983925666; 1.638932848113665 0.9902352175320255; 1.5865576546111428 0.402987295547508; 1.4370210873854328 0.783922410821054; 2.3953802205448356 -0.42072296649368973; 2.424880370546153 0.1865727848659274; 2.5496393233013612 -0.17671996948323299; 2.5137965717249022 0.4612129904099692; 2.3953802205448356 0.42072296649368973; 2.216168806759466 1.0017235324474514; 2.1422760626521007 0.559545221880724; 1.9365407946575801 1.0734278432054594; 2.3953802205448356 0.156627302695936; 2.281674880078783 0.7458808581433775; 2.2701308261138875 0.32846151605768953; 2.1177179109155886 0.8812784945695392; 2.3953802205448356 -0.156627302695936; 2.359374297226836 0.4424154591700014; 2.4217845598395744 0.054363736339801516; 2.3326194554668946 0.6533623390458896; 2.062046887211502 0.42072296649368973; 1.8932521400927995 0.9190438039766827; 1.850609395985434 0.3981709157887483; 1.6940158627537765 0.8447517217669354; 2.062046887211502 -0.42072296649368973; 2.1019637038794863 0.10389305639515896; 2.2579726566346943 -0.3380942755752087; 2.2712716398210984 0.2325368689714453; 1.6666666666666667 0.26409566379775373; 1.5490772600140164 0.6692413166579161; 1.5804785698715464 0.06970939973105882; 1.5137979518381879 0.459551598022007; 1.6666666666666667 -0.26409566379775373; 1.68008940665265 0.1575559680497683; 1.8361880967951196 -0.39245801191501023; 1.8761521843542042 0.07525290075016682; 1.6046197794551644 -0.156627302695936; 1.5933251199212168 0.246275883505844; 1.729869173886112 -0.32846151605768953; 1.7572820890844116 0.11087824707968219; 1.6046197794551644 0.156627302695936; 1.5156257027731637 0.54974128247922; 1.5782154401604251 -0.054363736339801516; 1.5423805445331058 0.3387944026033321; 1.9379531127884972 -0.42072296649368973; 1.9817478599071998 0.07311293767253853; 2.1493906040145654 -0.3981709157887483; 2.180984137246223 0.14740501988228583; 1.9379531127884972 0.42072296649368973; 1.7730362961205133 0.8882636852540624; 1.7420273433653048 0.3380942755752087; 1.603728360178901 0.7596198726777761; 2.3333333333333335 -0.26409566379775373; 2.325922739985983 0.32291542499130527; 2.419521430128453 -0.06970939973105882; 2.3612020481618115 0.5326051436272145; 2.3333333333333335 0.26409566379775373; 2.1949105933473496 0.8346007735994531; 2.1638119032048797 0.39245801191501023; 1.9988478156457952 0.9169038408990546; 2.228713553878169 0.13204783189887687; 2.126313218659818 0.6807296315733422; 2.1361969779125047 0.22626732606427494; 2.0133176591103354 0.7490570304064125; 2.228713553878169 -0.13204783189887687; 2.191819291979135 0.4248869572692681; 2.264051741374291 -0.004816379758759599; 2.1944947753683435 0.5569076817704922; 2.0 0.26409566379775373; 1.871993926680683 0.7519210451286846; 1.8721452365382134 0.23108370582303456; 1.756322883741992 0.6882277194605307; 2.0 -0.26409566379775373; 2.003006073319317 0.24023569652053678; 2.1278547634617864 -0.23108370582303456; 2.118677116258008 0.30392902218869056; 1.7712864461218307 0.13204783189887687; 1.683180708020865 0.5672697843799531; 1.7359482586257087 0.004816379758759599; 1.680505224631656 0.4352490598787291; 1.7712864461218307 -0.13204783189887687; 1.7486867813401819 0.3114271100758792; 1.8638030220874953 -0.22626732606427494; 1.8616823408896641 0.2430997112428089; 2.771286446121831 0.39614349569663065; 2.5864246347015483 1.0711516440963327; 2.483093495163922 0.7200230038577213; 2.226902904085059 1.3134267728302207; 2.771286446121831 -0.39614349569663065; 2.782942854659499 0.3036236211841106; 2.866657785549282 0.02677188638861755; 2.7704342528590837 0.7369787269224604; 2.042572892243662 0.8660254037844386; 1.7639342536599925 1.3456002262535494; 1.6179885349319936 0.7783827411438321; 1.3743569721630553 1.1553828386940683; 2.042572892243662 -0.8660254037844386; 2.1935507250621025 -0.3323239935788005; 2.456514026494415 -0.7371617154789355; 2.562592954590997 -0.10481367378464203; 1.271286446121831 0.469881908087808; 1.1150096189584442 0.7705269529818275; 1.1348950397680715 0.05835973728611062; 1.0849540680779963 0.3380344366884583; 1.271286446121831 -0.469881908087808; 1.3481078704026035 -0.13986924393830036; 1.589856240945133 -0.7639336018675533; 1.7296587017319136 -0.3457140298824916; 1.228713553878169 -0.39614349569663065; 1.2885753652984515 -0.0789949024471111; 1.516906504836078 -0.7200230038577213; 1.6480970959149408 -0.3212700311809994; 1.228713553878169 0.39614349569663065; 1.0920571453405008 0.6885331204651108; 1.133342214450718 -0.02677188638861755; 1.1045657471409165 0.25517801472676116; 1.957427107756338 -0.8660254037844386; 2.1110657463400075 -0.35344348460432795; 2.3820114650680067 -0.7783827411438321; 2.5006430278369445 -0.1632260970448468; 1.957427107756338 0.8660254037844386; 1.6814492749378975 1.324480735228022; 1.5434859735055853 0.7371617154789355; 1.3124070454090029 1.0969704154338633; 2.728713553878169 -0.469881908087808; 2.759990381041556 0.22162978866739394; 2.8651049602319283 -0.05835973728611062; 2.7900459319220037 0.6541223049607632; 2.728713553878169 0.469881908087808; 2.5268921295973965 1.1320259855875219; 2.410143759054867 0.7639336018675533; 2.1453412982680864 1.337870771531713; 2.771286446121831 0.18120677349299513; 2.639737364192129 0.8629316944615606; 2.5871492883618084 0.5319533719295402; 2.3743555920497696 1.1570442310820306; 2.771286446121831 -0.18120677349299513; 2.7296301251689186 0.5118435708188825; 2.762601992351396 0.21484151831679868; 2.6229815648943733 0.893361268670651; 2.228713553878169 0.7585570426826207; 1.9709143843637116 1.2876604295200942; 1.8328895104611302 0.7744628855000509; 1.5835145700077238 1.2048893414537123; 2.228713553878169 -0.7585570426826207; 2.3472181262752407 -0.18204384067748383; 2.567359208825665 -0.5530119391945356; 2.6242978644709547 0.10107537072319239; 1.4574271077563379 0.5773502691896257; 1.2686770201715822 0.9208071058831442; 1.2457402220993221 0.2425095135705107; 1.1466589779579541 0.5439234811962926; 1.4574271077563379 -0.5773502691896257; 1.5550880011063224 -0.19780904067175564; 1.8047572164742693 -0.7678534575113343; 1.9388162995765816 -0.29620752712284754; 1.228713553878169 -0.18120677349299513; 1.2352626358078709 0.12922504718766073; 1.4128507116381916 -0.5319533719295402; 1.5006444079502304 -0.16488748943280918; 1.228713553878169 0.18120677349299513; 1.1453698748310814 0.48031317083033886; 1.2373980076486042 -0.21484151831679868; 1.252018435105627 0.09879547297857069; 1.7712864461218307 -0.7585570426826207; 1.904085615636288 -0.2955036878708728; 2.1671104895388695 -0.7744628855000509; 2.2914854299922753 -0.21273259980449077; 1.7712864461218307 0.7585570426826207; 1.527781873724759 1.174200582326705; 1.4326407911743344 0.5530119391945356; 1.2507021355290444 0.891081370926029; 2.542572892243662 -0.5773502691896257; 2.606322979828417 0.07134963576607722; 2.7542597779006774 -0.2425095135705107; 2.7283410220420454 0.448233260452929; 2.542572892243662 0.5773502691896257; 2.319911998893677 1.189965782320977; 2.1952427835257304 0.7678534575113343; 1.936183700423418 1.2883642687720689; 2.6046197794551644 0.156627302695936; 2.4843757027731637 0.7977804678915255; 2.453215440160425 0.4297591819361256; 2.2699553402445165 1.0248227669189036; 2.6046197794551644 -0.156627302695936; 2.562075119921217 0.4943150689181494; 2.604869173886112 0.1556614022182376; 2.4848568847958226 0.7969066113952537; 2.1666666666666665 0.6019297399866849; 1.9496561709515952 1.1205376706720958; 1.854425351013909 0.6073756755343371; 1.6458215909959386 1.0483653391473076; 2.1666666666666665 -0.6019297399866849; 2.248260495715071 -0.045701200552106094; 2.437241315652757 -0.44600136944236135; 2.471703340907864 0.17246752394043754; 1.5620468872115023 0.44530243729074886; 1.4027804681784313 0.8188355736051811; 1.401209910853484 0.17761649359821152; 1.3133662507514223 0.5196209430530145; 1.5620468872115023 -0.44530243729074886; 1.6236853757938543 -0.0439378986456447; 1.8323721417666445 -0.6016627716605989; 1.9243464561120418 -0.1283607166302053; 1.3953802205448356 -0.156627302695936; 1.3906242972268361 0.19437627375769612; 1.5467845598395746 -0.4297591819361256; 1.6050446597554835 -0.03266602526968221; 1.3953802205448356 0.156627302695936; 1.312924880078783 0.4978416727310721; 1.3951308261138875 -0.1556614022182376; 1.3901431152041777 0.19525013025396776; 1.8333333333333333 -0.6019297399866849; 1.9253438290484044 -0.12838092902287462; 2.14557464898609 -0.6073756755343371; 2.2291784090040605 -0.05620859749808605; 1.8333333333333333 0.6019297399866849; 1.6267395042849282 1.0378579422013272; 1.5627586843472425 0.44600136944236135; 1.4032966590921354 0.8196892177087837; 2.437953112788497 -0.44530243729074886; 2.472219531821568 0.17332116804404027; 2.5987900891465157 -0.17761649359821152; 2.561633749248577 0.4725357985962068; 2.437953112788497 0.44530243729074886; 2.2513146242061453 1.036094640294866; 2.1676278582333546 0.6016627716605989; 1.950653543887957 1.1205174582794266; 2.4379531127884975 0.13204783189887687; 2.3290140413541986 0.7326292413214902; 2.3192815919590424 0.327564991942711; 2.1655550884392634 0.8926013027557768; 2.4379531127884975 -0.13204783189887687; 2.3945201146735156 0.4767865670174162; 2.447136355420829 0.09648128611967645; 2.3467322046972714 0.7004519541198566; 2.104619779455164 0.44530243729074886; 1.9283979575394787 0.9534149118240974; 1.875961191566688 0.4402884655686233; 1.708128611984154 0.8918413368409026; 2.104619779455164 -0.44530243729074886; 2.1493028651549015 0.09064143957327173; 2.3071234224798487 -0.3389907996901872; 2.3191088173447736 0.2438596771576829; 1.6666666666666667 0.313254605391872; 1.53688391618528 0.7168640413272183; 1.5566795996076461 0.11272347362591228; 1.4800735235448903 0.4953184049097368; 1.6666666666666667 -0.313254605391872; 1.6922827504813862 0.10993324338046628; 1.85998706705902 -0.43547208580986363; 1.9098766126475017 0.039486093862436955; 1.5620468872115023 -0.13204783189887687; 1.5459859586458014 0.25952750032773125; 1.680718408040958 -0.327564991942711; 1.7094449115607364 0.09955543889344459; 1.5620468872115023 0.13204783189887687; 1.4804798853264844 0.5153701746318052; 1.5528636445791713 -0.09648128611967645; 1.5282677953027282 0.2917047875293647; 1.8953802205448353 -0.44530243729074886; 1.946602042460521 0.038741829825123746; 2.1240388084333115 -0.4402884655686233; 2.1668713880158457 0.10031540480831858; 1.8953802205448353 0.44530243729074886; 1.7256971348450978 0.9015153020759495; 1.6928765775201506 0.3389907996901872; 1.555891182655226 0.7482970644915385; 2.3333333333333335 -0.313254605391872; 2.3381160838147195 0.27529270032200326; 2.443320400392353 -0.11272347362591228; 2.394926476455109 0.49683833673948485; 2.3333333333333335 0.313254605391872; 2.182717249518613 0.8822234982687552; 2.140012932940979 0.43547208580986363; 1.9651233873524976 0.9526706477867846]
    (r, c) = size(edge_matrix)

    G = IntGraph()

    for i = 1:r
        u, v = edge_matrix[i, :]
        add!(G, u, v)
    end


    xy = Dict{Int,Vector{Float64}}()

    n = NV(G)
    for v = 1:n
        xy[v] = coord_matrix[v,:]
    end

    embed(G, xy)
    name(G, "de Grey")
    return G
end

