
function dist_matrix(G::DirectedGraph)
    VV = vlist(G)
    n = length(VV)
    A = zeros(Int, n, n)
    for u = 1:n
        d = dist(G, VV[u])
        for v = 1:n
            A[u, v] = d[VV[v]]
        end
    end
    return A
end

function diam(G::DirectedGraph)
    A = dist_matrix(G)
    if minimum(A) < 0
        return -1
    end
    return maximum(A)
end
