# Sparspak Documentation


## Package features

- Solves systems of coupled linear algebraic equations with a sparse coefficient matrix.
- Reorderings of various kinds are supported, including the Multiple Minimum Degree (MMD).
- Factorizations of various kinds are supported.
- Solutions with multiple right hand sides, and solutions with preserved structure but changed matrix coefficients are supported. 
- Support of generic floating point types like those defined by [MultiFloats.jl](https://github.com/dzhang314/MultiFloats.jl), 
  [ForwardDiff.jl](https://github.com/JuliaDiff/ForwardDiff.jl) (dual numbers), [IntervalArithmetic.jl](https://github.com/JuliaIntervals/IntervalArithmetic.jl),
  [Measuremets.jl](https://github.com/JuliaPhysics/Measurements.jl)

## Documentation

|          | Learning    |   Working   |
|:---: | :---: | :---: | 
| Practical    | [Tutorials](tutorials/tutorials.md) | [How to](howto/howto.md) |
| Theoretical    | [Concepts](concepts/concepts.md) | [Reference](man/man.md) |




