"""
The `OctantCanvas` is also Unicode-based.
It has the same resolution as `BrailleCanvas`.
In contrast to `BrailleCanvas`, the pixels don't have visible spacing between them.
This canvas effectively turns every character into eight pixels that can individually be manipulated using binary operations.
"""
struct OctantCanvas{YS <: Function, XS <: Function} <: LookupCanvas
    grid::Transpose{UInt16, Matrix{UInt16}}
    colors::Transpose{ColorType, Matrix{ColorType}}
    visible::Bool
    blend::Bool
    yflip::Bool
    xflip::Bool
    pixel_height::Int
    pixel_width::Int
    origin_y::Float64
    origin_x::Float64
    height::Float64
    width::Float64
    min_max::NTuple{2, UnicodeType}
    yscale::YS
    xscale::XS
end

const OCTANT_SIGNS = [
    0b00000001 0b00000010
    0b00000100 0b00001000
    0b00010000 0b00100000
    0b01000000 0b10000000
]

const N_OCTANT = grid_type(OctantCanvas)(256)
const OCTANT_DECODE = Vector{Char}(undef, typemax(N_OCTANT))

# The array is stored according to the octant bit pattern:
# 0 1
# 2 3
# 4 5
# 6 7
OCTANT_DECODE[001] = 0x000000A0  # NO-BREAK SPACE
OCTANT_DECODE[002] = 0x0001CEA8  # LEFT HALF UPPER ONE QUARTER BLOCK
OCTANT_DECODE[003] = 0x0001CEAB  # RIGHT HALF UPPER ONE QUARTER BLOCK
OCTANT_DECODE[004] = 0x0001FB82  # UPPER ONE QUARTER BLOCK
OCTANT_DECODE[005] = 0x0001CD00  # BLOCK OCTANT-3
OCTANT_DECODE[006] = 0x00002598  # QUADRANT UPPER LEFT
OCTANT_DECODE[007] = 0x0001CD01  # BLOCK OCTANT-23
OCTANT_DECODE[008] = 0x0001CD02  # BLOCK OCTANT-123
OCTANT_DECODE[009] = 0x0001CD03  # BLOCK OCTANT-4
OCTANT_DECODE[010] = 0x0001CD04  # BLOCK OCTANT-14
OCTANT_DECODE[011] = 0x0000259D  # QUADRANT UPPER RIGHT
OCTANT_DECODE[012] = 0x0001CD05  # BLOCK OCTANT-124
OCTANT_DECODE[013] = 0x0001CD06  # BLOCK OCTANT-34
OCTANT_DECODE[014] = 0x0001CD07  # BLOCK OCTANT-134
OCTANT_DECODE[015] = 0x0001CD08  # BLOCK OCTANT-234
OCTANT_DECODE[016] = 0x00002580  # UPPER HALF BLOCK
OCTANT_DECODE[017] = 0x0001CD09  # BLOCK OCTANT-5
OCTANT_DECODE[018] = 0x0001CD0A  # BLOCK OCTANT-15
OCTANT_DECODE[019] = 0x0001CD0B  # BLOCK OCTANT-25
OCTANT_DECODE[020] = 0x0001CD0C  # BLOCK OCTANT-125
OCTANT_DECODE[021] = 0x0001FBE6  # MIDDLE LEFT ONE QUARTER BLOCK
OCTANT_DECODE[022] = 0x0001CD0D  # BLOCK OCTANT-135
OCTANT_DECODE[023] = 0x0001CD0E  # BLOCK OCTANT-235
OCTANT_DECODE[024] = 0x0001CD0F  # BLOCK OCTANT-1235
OCTANT_DECODE[025] = 0x0001CD10  # BLOCK OCTANT-45
OCTANT_DECODE[026] = 0x0001CD11  # BLOCK OCTANT-145
OCTANT_DECODE[027] = 0x0001CD12  # BLOCK OCTANT-245
OCTANT_DECODE[028] = 0x0001CD13  # BLOCK OCTANT-1245
OCTANT_DECODE[029] = 0x0001CD14  # BLOCK OCTANT-345
OCTANT_DECODE[030] = 0x0001CD15  # BLOCK OCTANT-1345
OCTANT_DECODE[031] = 0x0001CD16  # BLOCK OCTANT-2345
OCTANT_DECODE[032] = 0x0001CD17  # BLOCK OCTANT-12345
OCTANT_DECODE[033] = 0x0001CD18  # BLOCK OCTANT-6
OCTANT_DECODE[034] = 0x0001CD19  # BLOCK OCTANT-16
OCTANT_DECODE[035] = 0x0001CD1A  # BLOCK OCTANT-26
OCTANT_DECODE[036] = 0x0001CD1B  # BLOCK OCTANT-126
OCTANT_DECODE[037] = 0x0001CD1C  # BLOCK OCTANT-36
OCTANT_DECODE[038] = 0x0001CD1D  # BLOCK OCTANT-136
OCTANT_DECODE[039] = 0x0001CD1E  # BLOCK OCTANT-236
OCTANT_DECODE[040] = 0x0001CD1F  # BLOCK OCTANT-1236
OCTANT_DECODE[041] = 0x0001FBE7  # MIDDLE RIGHT ONE QUARTER BLOCK
OCTANT_DECODE[042] = 0x0001CD20  # BLOCK OCTANT-146
OCTANT_DECODE[043] = 0x0001CD21  # BLOCK OCTANT-246
OCTANT_DECODE[044] = 0x0001CD22  # BLOCK OCTANT-1246
OCTANT_DECODE[045] = 0x0001CD23  # BLOCK OCTANT-346
OCTANT_DECODE[046] = 0x0001CD24  # BLOCK OCTANT-1346
OCTANT_DECODE[047] = 0x0001CD25  # BLOCK OCTANT-2346
OCTANT_DECODE[048] = 0x0001CD26  # BLOCK OCTANT-12346
OCTANT_DECODE[049] = 0x0001CD27  # BLOCK OCTANT-56
OCTANT_DECODE[050] = 0x0001CD28  # BLOCK OCTANT-156
OCTANT_DECODE[051] = 0x0001CD29  # BLOCK OCTANT-256
OCTANT_DECODE[052] = 0x0001CD2A  # BLOCK OCTANT-1256
OCTANT_DECODE[053] = 0x0001CD2B  # BLOCK OCTANT-356
OCTANT_DECODE[054] = 0x0001CD2C  # BLOCK OCTANT-1356
OCTANT_DECODE[055] = 0x0001CD2D  # BLOCK OCTANT-2356
OCTANT_DECODE[056] = 0x0001CD2E  # BLOCK OCTANT-12356
OCTANT_DECODE[057] = 0x0001CD2F  # BLOCK OCTANT-456
OCTANT_DECODE[058] = 0x0001CD30  # BLOCK OCTANT-1456
OCTANT_DECODE[059] = 0x0001CD31  # BLOCK OCTANT-2456
OCTANT_DECODE[060] = 0x0001CD32  # BLOCK OCTANT-12456
OCTANT_DECODE[061] = 0x0001CD33  # BLOCK OCTANT-3456
OCTANT_DECODE[062] = 0x0001CD34  # BLOCK OCTANT-13456
OCTANT_DECODE[063] = 0x0001CD35  # BLOCK OCTANT-23456
OCTANT_DECODE[064] = 0x0001FB85  # UPPER THREE QUARTERS BLOCK
OCTANT_DECODE[065] = 0x0001CEA3  # LEFT HALF LOWER ONE QUARTER BLOCK
OCTANT_DECODE[066] = 0x0001CD36  # BLOCK OCTANT-17
OCTANT_DECODE[067] = 0x0001CD37  # BLOCK OCTANT-27
OCTANT_DECODE[068] = 0x0001CD38  # BLOCK OCTANT-127
OCTANT_DECODE[069] = 0x0001CD39  # BLOCK OCTANT-37
OCTANT_DECODE[070] = 0x0001CD3A  # BLOCK OCTANT-137
OCTANT_DECODE[071] = 0x0001CD3B  # BLOCK OCTANT-237
OCTANT_DECODE[072] = 0x0001CD3C  # BLOCK OCTANT-1237
OCTANT_DECODE[073] = 0x0001CD3D  # BLOCK OCTANT-47
OCTANT_DECODE[074] = 0x0001CD3E  # BLOCK OCTANT-147
OCTANT_DECODE[075] = 0x0001CD3F  # BLOCK OCTANT-247
OCTANT_DECODE[076] = 0x0001CD40  # BLOCK OCTANT-1247
OCTANT_DECODE[077] = 0x0001CD41  # BLOCK OCTANT-347
OCTANT_DECODE[078] = 0x0001CD42  # BLOCK OCTANT-1347
OCTANT_DECODE[079] = 0x0001CD43  # BLOCK OCTANT-2347
OCTANT_DECODE[080] = 0x0001CD44  # BLOCK OCTANT-12347
OCTANT_DECODE[081] = 0x00002596  # QUADRANT LOWER LEFT
OCTANT_DECODE[082] = 0x0001CD45  # BLOCK OCTANT-157
OCTANT_DECODE[083] = 0x0001CD46  # BLOCK OCTANT-257
OCTANT_DECODE[084] = 0x0001CD47  # BLOCK OCTANT-1257
OCTANT_DECODE[085] = 0x0001CD48  # BLOCK OCTANT-357
OCTANT_DECODE[086] = 0x0000258C  # LEFT HALF BLOCK
OCTANT_DECODE[087] = 0x0001CD49  # BLOCK OCTANT-2357
OCTANT_DECODE[088] = 0x0001CD4A  # BLOCK OCTANT-12357
OCTANT_DECODE[089] = 0x0001CD4B  # BLOCK OCTANT-457
OCTANT_DECODE[090] = 0x0001CD4C  # BLOCK OCTANT-1457
OCTANT_DECODE[091] = 0x0000259E  # QUADRANT UPPER RIGHT AND LOWER LEFT
OCTANT_DECODE[092] = 0x0001CD4D  # BLOCK OCTANT-12457
OCTANT_DECODE[093] = 0x0001CD4E  # BLOCK OCTANT-3457
OCTANT_DECODE[094] = 0x0001CD4F  # BLOCK OCTANT-13457
OCTANT_DECODE[095] = 0x0001CD50  # BLOCK OCTANT-23457
OCTANT_DECODE[096] = 0x0000259B  # QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFT
OCTANT_DECODE[097] = 0x0001CD51  # BLOCK OCTANT-67
OCTANT_DECODE[098] = 0x0001CD52  # BLOCK OCTANT-167
OCTANT_DECODE[099] = 0x0001CD53  # BLOCK OCTANT-267
OCTANT_DECODE[100] = 0x0001CD54  # BLOCK OCTANT-1267
OCTANT_DECODE[101] = 0x0001CD55  # BLOCK OCTANT-367
OCTANT_DECODE[102] = 0x0001CD56  # BLOCK OCTANT-1367
OCTANT_DECODE[103] = 0x0001CD57  # BLOCK OCTANT-2367
OCTANT_DECODE[104] = 0x0001CD58  # BLOCK OCTANT-12367
OCTANT_DECODE[105] = 0x0001CD59  # BLOCK OCTANT-467
OCTANT_DECODE[106] = 0x0001CD5A  # BLOCK OCTANT-1467
OCTANT_DECODE[107] = 0x0001CD5B  # BLOCK OCTANT-2467
OCTANT_DECODE[108] = 0x0001CD5C  # BLOCK OCTANT-12467
OCTANT_DECODE[109] = 0x0001CD5D  # BLOCK OCTANT-3467
OCTANT_DECODE[110] = 0x0001CD5E  # BLOCK OCTANT-13467
OCTANT_DECODE[111] = 0x0001CD5F  # BLOCK OCTANT-23467
OCTANT_DECODE[112] = 0x0001CD60  # BLOCK OCTANT-123467
OCTANT_DECODE[113] = 0x0001CD61  # BLOCK OCTANT-567
OCTANT_DECODE[114] = 0x0001CD62  # BLOCK OCTANT-1567
OCTANT_DECODE[115] = 0x0001CD63  # BLOCK OCTANT-2567
OCTANT_DECODE[116] = 0x0001CD64  # BLOCK OCTANT-12567
OCTANT_DECODE[117] = 0x0001CD65  # BLOCK OCTANT-3567
OCTANT_DECODE[118] = 0x0001CD66  # BLOCK OCTANT-13567
OCTANT_DECODE[119] = 0x0001CD67  # BLOCK OCTANT-23567
OCTANT_DECODE[120] = 0x0001CD68  # BLOCK OCTANT-123567
OCTANT_DECODE[121] = 0x0001CD69  # BLOCK OCTANT-4567
OCTANT_DECODE[122] = 0x0001CD6A  # BLOCK OCTANT-14567
OCTANT_DECODE[123] = 0x0001CD6B  # BLOCK OCTANT-24567
OCTANT_DECODE[124] = 0x0001CD6C  # BLOCK OCTANT-124567
OCTANT_DECODE[125] = 0x0001CD6D  # BLOCK OCTANT-34567
OCTANT_DECODE[126] = 0x0001CD6E  # BLOCK OCTANT-134567
OCTANT_DECODE[127] = 0x0001CD6F  # BLOCK OCTANT-234567
OCTANT_DECODE[128] = 0x0001CD70  # BLOCK OCTANT-1234567
OCTANT_DECODE[129] = 0x0001CEA0  # RIGHT HALF LOWER ONE QUARTER BLOCK
OCTANT_DECODE[130] = 0x0001CD71  # BLOCK OCTANT-18
OCTANT_DECODE[131] = 0x0001CD72  # BLOCK OCTANT-28
OCTANT_DECODE[132] = 0x0001CD73  # BLOCK OCTANT-128
OCTANT_DECODE[133] = 0x0001CD74  # BLOCK OCTANT-38
OCTANT_DECODE[134] = 0x0001CD75  # BLOCK OCTANT-138
OCTANT_DECODE[135] = 0x0001CD76  # BLOCK OCTANT-238
OCTANT_DECODE[136] = 0x0001CD77  # BLOCK OCTANT-1238
OCTANT_DECODE[137] = 0x0001CD78  # BLOCK OCTANT-48
OCTANT_DECODE[138] = 0x0001CD79  # BLOCK OCTANT-148
OCTANT_DECODE[139] = 0x0001CD7A  # BLOCK OCTANT-248
OCTANT_DECODE[140] = 0x0001CD7B  # BLOCK OCTANT-1248
OCTANT_DECODE[141] = 0x0001CD7C  # BLOCK OCTANT-348
OCTANT_DECODE[142] = 0x0001CD7D  # BLOCK OCTANT-1348
OCTANT_DECODE[143] = 0x0001CD7E  # BLOCK OCTANT-2348
OCTANT_DECODE[144] = 0x0001CD7F  # BLOCK OCTANT-12348
OCTANT_DECODE[145] = 0x0001CD80  # BLOCK OCTANT-58
OCTANT_DECODE[146] = 0x0001CD81  # BLOCK OCTANT-158
OCTANT_DECODE[147] = 0x0001CD82  # BLOCK OCTANT-258
OCTANT_DECODE[148] = 0x0001CD83  # BLOCK OCTANT-1258
OCTANT_DECODE[149] = 0x0001CD84  # BLOCK OCTANT-358
OCTANT_DECODE[150] = 0x0001CD85  # BLOCK OCTANT-1358
OCTANT_DECODE[151] = 0x0001CD86  # BLOCK OCTANT-2358
OCTANT_DECODE[152] = 0x0001CD87  # BLOCK OCTANT-12358
OCTANT_DECODE[153] = 0x0001CD88  # BLOCK OCTANT-458
OCTANT_DECODE[154] = 0x0001CD89  # BLOCK OCTANT-1458
OCTANT_DECODE[155] = 0x0001CD8A  # BLOCK OCTANT-2458
OCTANT_DECODE[156] = 0x0001CD8B  # BLOCK OCTANT-12458
OCTANT_DECODE[157] = 0x0001CD8C  # BLOCK OCTANT-3458
OCTANT_DECODE[158] = 0x0001CD8D  # BLOCK OCTANT-13458
OCTANT_DECODE[159] = 0x0001CD8E  # BLOCK OCTANT-23458
OCTANT_DECODE[160] = 0x0001CD8F  # BLOCK OCTANT-123458
OCTANT_DECODE[161] = 0x00002597  # QUADRANT LOWER RIGHT
OCTANT_DECODE[162] = 0x0001CD90  # BLOCK OCTANT-168
OCTANT_DECODE[163] = 0x0001CD91  # BLOCK OCTANT-268
OCTANT_DECODE[164] = 0x0001CD92  # BLOCK OCTANT-1268
OCTANT_DECODE[165] = 0x0001CD93  # BLOCK OCTANT-368
OCTANT_DECODE[166] = 0x0000259A  # QUADRANT UPPER LEFT AND LOWER RIGHT
OCTANT_DECODE[167] = 0x0001CD94  # BLOCK OCTANT-2368
OCTANT_DECODE[168] = 0x0001CD95  # BLOCK OCTANT-12368
OCTANT_DECODE[169] = 0x0001CD96  # BLOCK OCTANT-468
OCTANT_DECODE[170] = 0x0001CD97  # BLOCK OCTANT-1468
OCTANT_DECODE[171] = 0x00002590  # RIGHT HALF BLOCK
OCTANT_DECODE[172] = 0x0001CD98  # BLOCK OCTANT-12468
OCTANT_DECODE[173] = 0x0001CD99  # BLOCK OCTANT-3468
OCTANT_DECODE[174] = 0x0001CD9A  # BLOCK OCTANT-13468
OCTANT_DECODE[175] = 0x0001CD9B  # BLOCK OCTANT-23468
OCTANT_DECODE[176] = 0x0000259C  # QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHT
OCTANT_DECODE[177] = 0x0001CD9C  # BLOCK OCTANT-568
OCTANT_DECODE[178] = 0x0001CD9D  # BLOCK OCTANT-1568
OCTANT_DECODE[179] = 0x0001CD9E  # BLOCK OCTANT-2568
OCTANT_DECODE[180] = 0x0001CD9F  # BLOCK OCTANT-12568
OCTANT_DECODE[181] = 0x0001CDA0  # BLOCK OCTANT-3568
OCTANT_DECODE[182] = 0x0001CDA1  # BLOCK OCTANT-13568
OCTANT_DECODE[183] = 0x0001CDA2  # BLOCK OCTANT-23568
OCTANT_DECODE[184] = 0x0001CDA3  # BLOCK OCTANT-123568
OCTANT_DECODE[185] = 0x0001CDA4  # BLOCK OCTANT-4568
OCTANT_DECODE[186] = 0x0001CDA5  # BLOCK OCTANT-14568
OCTANT_DECODE[187] = 0x0001CDA6  # BLOCK OCTANT-24568
OCTANT_DECODE[188] = 0x0001CDA7  # BLOCK OCTANT-124568
OCTANT_DECODE[189] = 0x0001CDA8  # BLOCK OCTANT-34568
OCTANT_DECODE[190] = 0x0001CDA9  # BLOCK OCTANT-134568
OCTANT_DECODE[191] = 0x0001CDAA  # BLOCK OCTANT-234568
OCTANT_DECODE[192] = 0x0001CDAB  # BLOCK OCTANT-1234568
OCTANT_DECODE[193] = 0x00002582  # LOWER ONE QUARTER BLOCK
OCTANT_DECODE[194] = 0x0001CDAC  # BLOCK OCTANT-178
OCTANT_DECODE[195] = 0x0001CDAD  # BLOCK OCTANT-278
OCTANT_DECODE[196] = 0x0001CDAE  # BLOCK OCTANT-1278
OCTANT_DECODE[197] = 0x0001CDAF  # BLOCK OCTANT-378
OCTANT_DECODE[198] = 0x0001CDB0  # BLOCK OCTANT-1378
OCTANT_DECODE[199] = 0x0001CDB1  # BLOCK OCTANT-2378
OCTANT_DECODE[200] = 0x0001CDB2  # BLOCK OCTANT-12378
OCTANT_DECODE[201] = 0x0001CDB3  # BLOCK OCTANT-478
OCTANT_DECODE[202] = 0x0001CDB4  # BLOCK OCTANT-1478
OCTANT_DECODE[203] = 0x0001CDB5  # BLOCK OCTANT-2478
OCTANT_DECODE[204] = 0x0001CDB6  # BLOCK OCTANT-12478
OCTANT_DECODE[205] = 0x0001CDB7  # BLOCK OCTANT-3478
OCTANT_DECODE[206] = 0x0001CDB8  # BLOCK OCTANT-13478
OCTANT_DECODE[207] = 0x0001CDB9  # BLOCK OCTANT-23478
OCTANT_DECODE[208] = 0x0001CDBA  # BLOCK OCTANT-123478
OCTANT_DECODE[209] = 0x0001CDBB  # BLOCK OCTANT-578
OCTANT_DECODE[210] = 0x0001CDBC  # BLOCK OCTANT-1578
OCTANT_DECODE[211] = 0x0001CDBD  # BLOCK OCTANT-2578
OCTANT_DECODE[212] = 0x0001CDBE  # BLOCK OCTANT-12578
OCTANT_DECODE[213] = 0x0001CDBF  # BLOCK OCTANT-3578
OCTANT_DECODE[214] = 0x0001CDC0  # BLOCK OCTANT-13578
OCTANT_DECODE[215] = 0x0001CDC1  # BLOCK OCTANT-23578
OCTANT_DECODE[216] = 0x0001CDC2  # BLOCK OCTANT-123578
OCTANT_DECODE[217] = 0x0001CDC3  # BLOCK OCTANT-4578
OCTANT_DECODE[218] = 0x0001CDC4  # BLOCK OCTANT-14578
OCTANT_DECODE[219] = 0x0001CDC5  # BLOCK OCTANT-24578
OCTANT_DECODE[220] = 0x0001CDC6  # BLOCK OCTANT-124578
OCTANT_DECODE[221] = 0x0001CDC7  # BLOCK OCTANT-34578
OCTANT_DECODE[222] = 0x0001CDC8  # BLOCK OCTANT-134578
OCTANT_DECODE[223] = 0x0001CDC9  # BLOCK OCTANT-234578
OCTANT_DECODE[224] = 0x0001CDCA  # BLOCK OCTANT-1234578
OCTANT_DECODE[225] = 0x0001CDCB  # BLOCK OCTANT-678
OCTANT_DECODE[226] = 0x0001CDCC  # BLOCK OCTANT-1678
OCTANT_DECODE[227] = 0x0001CDCD  # BLOCK OCTANT-2678
OCTANT_DECODE[228] = 0x0001CDCE  # BLOCK OCTANT-12678
OCTANT_DECODE[229] = 0x0001CDCF  # BLOCK OCTANT-3678
OCTANT_DECODE[230] = 0x0001CDD0  # BLOCK OCTANT-13678
OCTANT_DECODE[231] = 0x0001CDD1  # BLOCK OCTANT-23678
OCTANT_DECODE[232] = 0x0001CDD2  # BLOCK OCTANT-123678
OCTANT_DECODE[233] = 0x0001CDD3  # BLOCK OCTANT-4678
OCTANT_DECODE[234] = 0x0001CDD4  # BLOCK OCTANT-14678
OCTANT_DECODE[235] = 0x0001CDD5  # BLOCK OCTANT-24678
OCTANT_DECODE[236] = 0x0001CDD6  # BLOCK OCTANT-124678
OCTANT_DECODE[237] = 0x0001CDD7  # BLOCK OCTANT-34678
OCTANT_DECODE[238] = 0x0001CDD8  # BLOCK OCTANT-134678
OCTANT_DECODE[239] = 0x0001CDD9  # BLOCK OCTANT-234678
OCTANT_DECODE[240] = 0x0001CDDA  # BLOCK OCTANT-1234678
OCTANT_DECODE[241] = 0x00002584  # LOWER HALF BLOCK
OCTANT_DECODE[242] = 0x0001CDDB  # BLOCK OCTANT-15678
OCTANT_DECODE[243] = 0x0001CDDC  # BLOCK OCTANT-25678
OCTANT_DECODE[244] = 0x0001CDDD  # BLOCK OCTANT-125678
OCTANT_DECODE[245] = 0x0001CDDE  # BLOCK OCTANT-35678
OCTANT_DECODE[246] = 0x00002599  # QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT
OCTANT_DECODE[247] = 0x0001CDDF  # BLOCK OCTANT-235678
OCTANT_DECODE[248] = 0x0001CDE0  # BLOCK OCTANT-1235678
OCTANT_DECODE[249] = 0x0001CDE1  # BLOCK OCTANT-45678
OCTANT_DECODE[250] = 0x0001CDE2  # BLOCK OCTANT-145678
OCTANT_DECODE[251] = 0x0000259F  # QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT
OCTANT_DECODE[252] = 0x0001CDE3  # BLOCK OCTANT-1245678
OCTANT_DECODE[253] = 0x00002586  # LOWER THREE QUARTERS BLOCK
OCTANT_DECODE[254] = 0x0001CDE4  # BLOCK OCTANT-1345678
OCTANT_DECODE[255] = 0x0001CDE5  # BLOCK OCTANT-2345678
OCTANT_DECODE[256] = 0x00002588  # FULL BLOCK
OCTANT_DECODE[(N_OCTANT + 1):typemax(N_OCTANT)] = UNICODE_TABLE[1:(typemax(N_OCTANT) - N_OCTANT)]

@inline x_pixel_per_char(::Type{<:OctantCanvas}) = 2
@inline y_pixel_per_char(::Type{<:OctantCanvas}) = 4

@inline lookup_encode(::OctantCanvas) = OCTANT_SIGNS
@inline lookup_decode(::OctantCanvas) = OCTANT_DECODE
@inline lookup_offset(::OctantCanvas) = N_OCTANT

OctantCanvas(args...; kw...) =
    CreateLookupCanvas(OctantCanvas, (0b00000000, 0b11111111), args...; kw...)
