import { QR } from "./qr-base.js";
import { createSVG } from './svg.js';
import { getOptions } from "./utils.js";
import sharp from "sharp";
export async function getPNG(text, inOptions = {}) {
    const options = getOptions({ ...inOptions, type: 'png' });
    const matrix = QR(text, options.ec_level, options.parse_url);
    return generateImage({ matrix, ...options, type: 'png' });
}
export async function generateImage({ matrix, size, margin, logo, logoWidth, logoHeight, color, bgColor, borderRadius, }) {
    const marginPx = margin * size;
    const imageSize = matrix.length * size + marginPx * 2;
    if (size > 200) {
        throw new Error('Module size is too big, resulting image is too large: ' + imageSize);
    }
    const svg = await createSVG({
        matrix, size, margin, color, bgColor,
        imageWidth: imageSize, imageHeight: imageSize,
        borderRadius,
    });
    const qrImage = sharp(svg);
    const layers = [];
    if (logo) {
        const sharpLogo = sharp(logo).resize(Math.round(imageSize * logoWidth / 100), Math.round(imageSize * logoHeight / 100), { fit: 'contain' });
        const data = await sharpLogo.toBuffer();
        layers.push({
            input: data,
        });
        qrImage.composite(layers);
    }
    const { data } = await qrImage.png({
        palette: !logo,
    }).toBuffer({ resolveWithObject: true });
    return new Uint8ClampedArray(data.buffer);
}
//# sourceMappingURL=png.js.map