import { Inferno, Props, VNode } from 'inferno';
/**
 * Creates virtual node
 * @param {string|Function|Component<any, any>} type Type of node
 * @param {object=} props Optional props for virtual node
 * @param {...{object}=} _children Optional children for virtual node
 * @returns {VNode} new virtual node
 */
export declare function createElement<P>(type: string | Inferno.ComponentClass<P> | Inferno.StatelessComponent<P>, props?: (P & Props<P>) | null, ..._children: any[]): VNode;
