import { Component, Inferno, InfernoNode } from 'inferno';
import type { History, Location } from 'history';
import type { RouterContext, TContextRouter, TLoaderData, TLoaderProps } from './Router';
export interface Match<P extends Record<string, string>> {
    params: P;
    isExact: boolean;
    path: string;
    url: string;
    loader?(props: TLoaderProps<P>): Promise<any>;
    loaderData?: TLoaderData;
}
export interface RouteComponentProps<P extends Record<string, string>> {
    match: Match<P>;
    location: Location;
    history: History;
    staticContext?: any;
}
export interface IRouteProps {
    computedMatch?: Match<any> | null;
    path?: string;
    exact?: boolean;
    strict?: boolean;
    sensitive?: boolean;
    loader?(props: TLoaderProps<any>): Promise<any>;
    component?: Inferno.ComponentClass<any> | ((props: any, context: any) => InfernoNode);
    render?: (props: RouteComponentProps<any>, context: any) => InfernoNode;
    location?: Pick<Location, 'pathname'>;
    children?: ((props: RouteComponentProps<any>) => InfernoNode) | InfernoNode;
}
/**
 * The public API for matching a single path and rendering.
 */
type RouteState = {
    match: Match<any> | null;
    __loaderData__?: TLoaderData;
};
declare class Route extends Component<Partial<IRouteProps>, RouteState> {
    constructor(props: IRouteProps, context: RouterContext);
    getChildContext(): RouterContext;
    computeMatch({ computedMatch, ...props }: IRouteProps, router: TContextRouter): Match<any> | null;
    componentWillReceiveProps(nextProps: any, nextContext: {
        router: TContextRouter;
    }): void;
    render(props: IRouteProps, state: RouteState, context: {
        router: TContextRouter;
    }): any;
}
export { Route };
