<?php
/* vim: set sw=4 ts=4 noet foldmarker=@{,@} foldmethod=marker: */

return [

# wgLanguageCode @{
'wgLanguageCode' => [
	'default' => '$lang',

	# Non-ISO language codes
	'be_x_oldwiki' => 'be-tarask',
	'crhwiki' => 'crh-latn',
	'nowiki' => 'nb',
	'simplewiki' => 'en',
	'simplewiktionary' => 'en',

	# Wikis at the wrong domain
	# FIXME: rename these wikis (T21986)
	'alswiki' => 'gsw',
	'alswiktionary' => 'gsw',
	'alswikibooks' => 'gsw',
	'alswikiquote' => 'gsw',
	'bat_smgwiki' => 'sgs',
	'bhwiki' => 'bho',
	'bhwiktionary' => 'bho',
	'fiu_vrowiki' => 'vro',
	'roa_rupwiki' => 'rup',
	'roa_rupwiktionary' => 'rup',
	'zh_classicalwiki' => 'lzh',
	'zh_min_nanwiki' => 'nan',
	'zh_min_nanwiktionary' => 'nan',
	'zh_min_nanwikibooks' => 'nan',
	'zh_min_nanwikiquote' => 'nan',
	'zh_yuewiki' => 'yue',

	# Chapter wikis (xxwikimedia)
	'arwikimedia' => 'es',
	'bdwikimedia' => 'bn',
	'bewikimedia' => 'en',
	'brwikimedia' => 'pt-br',
	'cawikimedia' => 'en', // T88843#1098439
	'cowikimedia' => 'es',
	'dkwikimedia' => 'da',
	'ilwikimedia' => 'he',
	'mkwikimedia' => 'mk',
	'mxwikimedia' => 'es',
	'noboard_chapterswikimedia' => 'no',
	'nycwikimedia' => 'en',
	'nzwikimedia' => 'en',
	'pa_uswikimedia' => 'en',
	'rswikimedia' => 'sr',
	'sewikimedia' => 'sv',
	'uawikimedia' => 'uk',
	'ukwikimedia' => 'en-gb',

	# Local user group wikis (xxwikimedia)
	'cnwikimedia' => 'zh', // T98676

	# Special wikis
	'special' => 'en', # default - overridden below by some wikis
	'advisorywiki' => 'en',
	'arbcom_dewiki' => 'de',
	'arbcom_enwiki' => 'en',
	'arbcom_fiwiki' => 'fi',
	'arbcom_nlwiki' => 'nl',
	'auditcomwiki' => 'en',
	'betawikiversity' => 'en',
	'chairwiki' => 'en',
	'chapcomwiki' => 'en',
	'checkuserwiki' => 'en',
	'collabwiki' => 'en',
	'donatewiki' => 'en',
	'execwiki' => 'en',
	'fdcwiki' => 'en',
	'grantswiki' => 'en',
	'iegcomwiki' => 'en',
	'incubatorwiki' => 'en', # mixed
	'legalteamwiki' => 'en',
	'officewiki' => 'en',
	'ombudsmenwiki' => 'en',
	'otrs_wikiwiki' => 'en',
	'qualitywiki' => 'en',
	'searchcomwiki' => 'en',
	'stewardwiki' => 'en',
	'strategywiki' => 'en',
	'tenwiki' => 'en',
	'transitionteamwiki' => 'en',
	'usabilitywiki' => 'en',
	'votewiki' => 'en', // T132667, T148352
	'wikimania' => 'en',
	'wikimaniateamwiki' => 'en',
],
# @} end of wgLanguageCode

// This is the same as wgServer but with a protocol, so if wgServer is //foo.com this must be http://foo.com
# wgCanonicalServer @{
'wgCanonicalServer' => [
	// Projects
	'wikipedia' => 'https://$lang.wikipedia.org',
	'wikibooks' => 'https://$lang.wikibooks.org',
	'wikimedia' => 'https://$lang.wikimedia.org',
	'wikinews' => 'https://$lang.wikinews.org',
	'wikiquote' => 'https://$lang.wikiquote.org',
	'wikisource' => 'https://$lang.wikisource.org',
	'wikiversity' => 'https://$lang.wikiversity.org',
	'wikivoyage' => 'https://$lang.wikivoyage.org',
	'wiktionary' => 'https://$lang.wiktionary.org',

	// Individual wikis
	'advisorywiki' => 'https://advisory.wikimedia.org',
	'arwikimedia' => 'https://ar.wikimedia.org',
	'auditcomwiki' => 'https://auditcom.wikimedia.org',
	'be_x_oldwiki' => 'https://be-tarask.wikipedia.org',
	'boardgovcomwiki' => 'https://boardgovcom.wikimedia.org',
	'boardwiki' => 'https://board.wikimedia.org',
	'brwikimedia' => 'https://br.wikimedia.org',
	'chairwiki' => 'https://chair.wikimedia.org',
	'chapcomwiki' => 'https://affcom.wikimedia.org',
	'checkuserwiki' => 'https://checkuser.wikimedia.org',
	'cnwikimedia' => 'https://cn.wikimedia.org', // T98676
	'collabwiki' => 'https://collab.wikimedia.org',
	'commonswiki' => 'https://commons.wikimedia.org',
	'donatewiki' => 'https://donate.wikimedia.org',
	'etwikimedia' => 'https://ee.wikimedia.org',
	'execwiki' => 'https://exec.wikimedia.org',
	'fdcwiki' => 'https://fdc.wikimedia.org',
	'grantswiki' => 'https://grants.wikimedia.org',
	'iegcomwiki' => 'https://iegcom.wikimedia.org',
	'incubatorwiki' => 'https://incubator.wikimedia.org',
	'internalwiki' => 'https://internal.wikimedia.org',
	'labswiki' => 'https://wikitech.wikimedia.org',
	'labtestwiki' => 'https://labtestwikitech.wikimedia.org',
	'legalteamwiki' => 'https://legalteam.wikimedia.org',
	'loginwiki' => 'https://login.wikimedia.org',
	'mediawikiwiki' => 'https://www.mediawiki.org',
	'metawiki' => 'https://meta.wikimedia.org',
	'movementroleswiki' => 'https://movementroles.wikimedia.org',
	'mxwikimedia' => 'https://mx.wikimedia.org',
	'noboard_chapterswikimedia' => 'https://noboard-chapters.wikimedia.org',
	'nostalgiawiki' => 'https://nostalgia.wikipedia.org',
	'nycwikimedia' => 'https://nyc.wikimedia.org', // T31273
	'officewiki' => 'https://office.wikimedia.org',
	'ombudsmenwiki' => 'https://ombudsmen.wikimedia.org',
	'otrs_wikiwiki' => 'https://otrs-wiki.wikimedia.org',
	'outreachwiki' => 'https://outreach.wikimedia.org',
	'pa_uswikimedia' => 'https://pa-us.wikimedia.org',
	'qualitywiki' => 'https://quality.wikimedia.org',
	'searchcomwiki' => 'https://searchcom.wikimedia.org',
	'sourceswiki' => 'https://wikisource.org',
	'spcomwiki' => 'https://spcom.wikimedia.org',
	'specieswiki' => 'https://species.wikimedia.org',
	'stewardwiki' => 'https://steward.wikimedia.org',
	'strategywiki' => 'https://strategy.wikimedia.org',
	'testwikidatawiki' => 'https://test.wikidata.org',
	'transitionteamwiki' => 'https://transitionteam.wikimedia.org',
	'usabilitywiki' => 'https://usability.wikimedia.org',
	'votewiki' => 'https://vote.wikimedia.org',
	'wikidatawiki' => 'https://www.wikidata.org',
	'wikimania2005wiki' => 'https://wikimania2005.wikimedia.org',
	'wikimania2006wiki' => 'https://wikimania2006.wikimedia.org',
	'wikimania2007wiki' => 'https://wikimania2007.wikimedia.org',
	'wikimania2008wiki' => 'https://wikimania2008.wikimedia.org',
	'wikimania2009wiki' => 'https://wikimania2009.wikimedia.org',
	'wikimania2010wiki' => 'https://wikimania2010.wikimedia.org',
	'wikimania2011wiki' => 'https://wikimania2011.wikimedia.org',
	'wikimania2012wiki' => 'https://wikimania2012.wikimedia.org',
	'wikimania2013wiki' => 'https://wikimania2013.wikimedia.org',
	'wikimania2014wiki' => 'https://wikimania2014.wikimedia.org',
	'wikimania2015wiki' => 'https://wikimania2015.wikimedia.org',
	'wikimania2016wiki' => 'https://wikimania2016.wikimedia.org',
	'wikimania2017wiki' => 'https://wikimania2017.wikimedia.org',
	'wikimaniateamwiki' => 'https://wikimaniateam.wikimedia.org',
],
# @} end of wgCanonicalServer

# wgSitename @{
'wgSitename' => [
	// Projects
	'wikipedia' => 'Wikipedia',
	'wikibooks' => 'Wikibooks',
	'wikidata' => 'Wikidata',
	'wikimania' => 'Wikimania',
	'wikimedia' => 'Wikimedia',
	'wikinews' => 'Wikinews',
	'wikiquote' => 'Wikiquote',
	'wikisource' => 'Wikisource',
	'wikiversity' => 'Wikiversity',
	'wikivoyage' => 'Wikivoyage',
	'wiktionary' => 'Wiktionary',

	// Individual wikis, alphabetically by DB name
	'abwiki' => 'Авикипедиа',
	'advisorywiki' => 'Advisory Board',
	'adywiki' => 'Википедие', // T125501
	'angwiki' => 'Wikipǣdia', // T58634
	'angwikisource' => 'Wicifruma',
	'angwiktionary' => 'Wikiwordbōc', // T58634
	'amwiki' => 'ውክፔዲያ',
	'arbcom_dewiki' => 'Arbitration Committee',
	'arbcom_enwiki' => 'Arbitration Committee',
	'arbcom_fiwiki' => 'Arbitration Committee',
	'arbcom_nlwiki' => 'Arbitration Committee',
	'arcwiki' => 'ܘܝܩܝܦܕܝܐ',
	'arwiki' => 'ويكيبيديا',
	'arwikibooks' => 'ويكي_الكتب',
	'arwikimedia' => 'Wikimedia Argentina',
	'arwikinews' => 'ويكي_الأخبار',
	'arwikiquote' => 'ويكي_الاقتباس',
	'arwikisource' => 'ويكي_مصدر',
	'arwikiversity' => 'ويكي الجامعة',
	'arwiktionary' => 'ويكاموس',
	'arzwiki' => 'ويكيبيديا',
	'astwiktionary' => 'Wikcionariu', // T99315
	'aswiki' => 'অসমীয়া ৱিকিপিডিয়া',
	'aswikisource' => 'ৱিকিউৎস', // T45129
	'auditcomwiki' => 'Audit Committee',
	'azwiki' => 'Vikipediya',
	'azwikibooks' => 'Vikikitab', // T33068
	'azwikiquote' => 'Vikisitat',
	'azwikisource' => 'Vikimənbə', // T114002
	'azbwiki' => 'ویکی‌پدیا', // T106305
	'bawiki' => 'Википедия', // T43167
	'bdwikimedia' => 'উইকিমিডিয়া বাংলাদেশ',
	'be_x_oldwiki' => 'Вікіпэдыя',
	'bewiki' => 'Вікіпедыя',
	'bewikimedia' => 'Wikimedia Belgium',
	'bewikisource' => 'Вікікрыніцы',
	'bewiktionary' => 'Вікіслоўнік',
	'bgwiki' => 'Уикипедия',
	'bgwikibooks' => 'Уикикниги',
	'bgwikinews' => 'Уикиновини',
	'bgwikiquote' => 'Уикицитат',
	'bgwikisource' => 'Уикиизточник',
	'bgwiktionary' => 'Уикиречник',
	'bhwiki' => 'विकिपीडिया',
	'bjnwiki' => 'Wikipidia',
	'bnwiki' => 'উইকিপিডিয়া',
	'bnwikibooks' => 'উইকিবই',
	'bnwikisource' => 'উইকিসংকলন',
	'bnwiktionary' => 'উইকিঅভিধান',
	'boardgovcomwiki' => 'Board Governance Committee',
	'boardwiki' => 'Board',
	'bpywiki' => 'উইকিপিডিয়া',
	'brwikimedia' => 'Wikimedia Brasil',
	'brwikiquote' => 'Wikiarroud',
	'brwikisource' => 'Wikimammenn',
	'brwiktionary' => 'Wikeriadur',
	'bswikibooks' => 'Wikiknjige',
	'bswikinews' => 'Wikivijesti',
	'bswikiquote' => 'Wikicitati',
	'bswikisource' => 'Wikizvor',
	'bswiktionary' => 'Vikirječnik',
	'cawiki' => "Viquip\xc3\xa8dia",
	'cawikibooks' => 'Viquillibres',
	'cawikimedia' => 'Wikimedia Canada',
	'cawikinews' => 'Viquinotícies',
	'cawikiquote' => 'Viquidites',
	'cawikisource' => 'Viquitexts',
	'cawiktionary' => 'Viccionari',
	'ckbwiki' => 'ویکیپیدیا',
	'cewiki' => 'Википеди', // T49574
	'chairwiki' => 'Wikimedia Board Chair',
	'chapcomwiki' => 'Affcom',
	'checkuserwiki' => 'CheckUser Wiki',
	'chywiki' => 'Tsétsêhéstâhese Wikipedia',
	'cnwikimedia' => '中国维基媒体用户组', // T98676
	'collabwiki' => 'Collab',
	'commonswiki' => 'Wikimedia Commons',
	'cowikimedia' => 'Wikimedia Colombia',
	'crhwiki' => 'Vikipediya',
	'cswiki' => 'Wikipedie',
	'cswikibooks' => 'Wikiknihy',
	'cswikinews' => 'Wikizprávy',
	'cswikiquote' => 'Wikicitáty',
	'cswikisource' => 'Wikizdroje',
	'cswiktionary' => 'Wikislovník',
	'cswikiversity' => 'Wikiverzita',
	'cuwiki' => 'Википєдїꙗ',
	'cvwiki' => 'Википеди',
	'cywiki' => 'Wicipedia',
	'cywikibooks' => 'Wicilyfrau',
	'cywikisource' => 'Wicidestun',
	'cywiktionary' => 'Wiciadur',
	'dkwikimedia' => 'Wikimedia Danmark',
	'donatewiki' => 'Donate',
	'dsbwiki' => 'Wikipedija',
	'dvwiki' => 'ވިކިޕީޑިއާ', // T50075
	'dvwiktionary' => 'ވިކިރަދީފު',
	'elwiki' => 'Βικιπαίδεια',
	'elwikibooks' => 'Βικιβιβλία',
	'elwikinews' => 'Βικινέα',
	'elwikiquote' => 'Βικιφθέγματα',
	'elwikisource' => 'Βικιθήκη',
	'elwikiversity' => 'Βικιεπιστήμιο',
	'elwikivoyage' => 'Βικιταξίδια',
	'elwiktionary' => 'Βικιλεξικό',
	'eowiki' => 'Vikipedio',
	'eowikibooks' => 'Vikilibroj',
	'eowikinews' => 'Vikinovaĵoj',
	'eowikiquote' => 'Vikicitaro',
	'eowikisource' => 'Vikifontaro',
	'eowiktionary' => 'Vikivortaro',
	'eswikibooks' => 'Wikilibros',
	'eswikinews' => 'Wikinoticias',
	'eswikiversity' => 'Wikiversidad',
	'eswikivoyage' => 'Wikiviajes', // T44933
	'eswiktionary' => 'Wikcionario',
	'etwiki' => 'Vikipeedia',
	'etwikibooks' => 'Vikiõpikud',
	'etwikimedia' => 'Wikimedia Eesti',
	'etwikisource' => 'Vikitekstid',
	'etwikiquote' => 'Vikitsitaadid',
	'etwiktionary' => 'Vikisõnastik',
	'execwiki' => 'Wikimedia Executive',
	'extwiki' => 'Güiquipeya',
	'fawiki' => 'ویکی‌پدیا',
	'fawikibooks' => 'ویکی‌کتاب', // T60655
	'fawikinews' => 'ویکی‌خبر',
	'fawikiquote' => 'ویکی‌گفتاورد',
	'fawikisource' => 'ویکی‌نبشته',
	'fawikivoyage' => 'ویکی‌سفر', // T73382
	'fawiktionary' => 'ویکی‌واژه',
	'fdcwiki' => 'Wikimedia FDC',
	'fiwikibooks' => 'Wikikirjasto',
	'fiwikimedia' => 'Wikimedia Suomi',
	'fiwikinews' => 'Wikiuutiset',
	'fiwikiquote' => 'Wikisitaatit',
	'fiwikisource' => 'Wikiaineisto',
	'fiwikiversity' => 'Wikiopisto',
	'fiwiktionary' => 'Wikisanakirja',
	'foundationwiki' => 'Wikimedia Foundation',
	'fowikisource' => 'Wikiheimild',
	'frpwiki' => 'Vouiquipèdia',
	'frwiki' => 'Wikipédia',
	'frwikibooks' => 'Wikilivres', // T51612
	'frwikiversity' => 'Wikiversité',
	'frwiktionary' => 'Wiktionnaire',
	'furwiki' => 'Vichipedie',
	'fywiki' => 'Wikipedy',
	'ganwiki' => '維基百科',
	'gawiki' => 'Vicipéid',
	'gagwiki' => 'Vikipediya',
	'gawikibooks' => 'Vicíleabhair',
	'gawikiquote' => 'Vicísliocht',
	'gawiktionary' => 'Vicífhoclóir',
	'gdwiki' => 'Uicipeid',
	'gnwiki' => 'Vikipetã',
	'gomwiki' => 'विकिपीडिया', // T96468
	'grantswiki' => 'Wikimedia Foundation Grants Discussion',
	'guwiki' => 'વિકિપીડિયા',
	'guwikiquote' => 'વિકિસૂક્તિ', // T121853
	'guwikisource' => 'વિકિસ્રોત',
	'guwiktionary' => 'વિકિકોશ', // T122407
	'hewiki' => 'ויקיפדיה',
	'hewikibooks' => 'ויקיספר',
	'hewikinews' => 'ויקיחדשות',
	'hewikiquote' => 'ויקיציטוט',
	'hewikisource' => 'ויקיטקסט',
	'hewikivoyage' => 'ויקימסע',
	'hewiktionary' => 'ויקימילון',
	'hiwiki' => 'विकिपीडिया',
	'hiwikiquote' => 'विकिसूक्ति', // T126185
	'hiwiktionary' => 'विक्षनरी',
	'hrwiki' => 'Wikipedija',
	'hrwikiquote' => 'Wikicitat',
	'hrwikisource' => 'Wikizvor',
	'hsbwiki' => 'Wikipedija',
	'hsbwiktionary' => 'Wikisłownik', // T43328
	'htwiki' => 'Wikipedya',
	'htwikisource' => 'Wikisòrs',
	'huwiki' => 'Wikipédia',
	'huwikibooks' => 'Wikikönyvek',
	'huwikinews' => 'Wikihírek',
	'huwikiquote' => 'Wikidézet',
	'huwikisource' => 'Wikiforrás',
	'huwiktionary' => 'Wikiszótár',
	'hywiki' => 'Վիքիպեդիա',
	'hywikibooks' => 'Վիքիգրքեր',
	'hywikiquote' => 'Վիքիքաղվածք',
	'hywikisource' => 'Վիքիդարան',
	'hywiktionary' => 'Վիքիբառարան',
	'iawiktionary' => 'Wiktionario',
	'iegcomwiki' => 'Individual Engagement Grants Committee Wiki',
	'idwikibooks' => 'Wikibuku',
	'ilwikimedia' => 'ויקימדיה',
	'incubatorwiki' => 'Wikimedia Incubator',
	'internalwiki' => 'Internal',
	'iowiki' => 'Wikipedio',
	'iowiktionary' => 'Wikivortaro',
	'iswikibooks' => 'Wikibækur',
	'iswikiquote' => 'Wikivitnun',
	'iswikisource' => 'Wikiheimild',
	'iswiktionary' => 'Wikiorðabók',
	'itwikinews' => 'Wikinotizie',
	'itwikiversity' => 'Wikiversità',
	'itwiktionary' => 'Wikizionario',
	'iuwiki' => 'ᐅᐃᑭᐱᑎᐊ',
	'jamwiki' => 'Wikipidia',
	'jawikinews' => 'ウィキニュース',
	'jawikiversity' => 'ウィキバーシティ',
	'kawiki' => 'ვიკიპედია',
	'kawikibooks' => 'ვიკიწიგნები',
	'kawikiquote' => 'ვიკიციტატა',
	'kawiktionary' => 'ვიქსიკონი',
	'kbdwiki' => 'Уикипедиэ',
	'kkwiki' => 'Уикипедия',
	'kkwikibooks' => 'Уикикітап',
	'kkwikiquote' => 'Уикидәйек',
	'kkwiktionary' => 'Уикисөздік',
	'kmwiki' => 'វិគីភីឌា',
	'knwiki' => 'ವಿಕಿಪೀಡಿಯ',
	'knwikiquote' => 'ವಿಕಿಕೋಟ್',
	'knwikisource' => 'ವಿಕಿಸೋರ್ಸ್', // T110806
	'knwiktionary' => 'ವಿಕ್ಷನರಿ',
	'koiwiki' => 'Википедия',
	'kowiki' => '위키백과',
	'kowikinews' => '위키뉴스',
	'kowikibooks' => '위키책',
	'kowikiquote' => '위키인용집',
	'kowikisource' => '위키문헌',
	'kowikiversity' => '위키배움터',
	'kowiktionary' => '위키낱말사전',
	'krcwiki' => 'Википедия',
	'kuwiki' => 'Wîkîpediya',
	'wikitech' => 'Wikitech',
	'lawiki' => 'Vicipaedia',
	'lawikibooks' => 'Vicilibri',
	'lawikiquote' => 'Vicicitatio',
	'lawiktionary' => 'Victionarium',
	'ladwiki' => 'Vikipedya',
	'lbwiktionary' => 'Wiktionnaire',
	'lbewiki' => 'Википедия',
	'legalteamwiki' => 'Legal Team Wiki',
	'lezwiki' => 'Википедия',
	'liwikibooks' => 'Wikibeuk',
	'liwikisource' => 'Wikibrónne',
	'loginwiki' => 'Wikimedia Login Wiki',
	'lowiki' => 'ວິກິພີເດຍ',
	'lrcwiki' => 'ڤیکیپئدیا', // T102026
	'ltgwiki' => 'Vikipedeja',
	'ltwiki' => 'Vikipedija',
	'ltwikisource' => 'Vikišaltiniai',
	'ltwiktionary' => 'Vikižodynas',
	'lvwiki' => 'Vikipēdija',
	'maiwiki' => 'विकिपिडिया', // T74346
	'mdfwiki' => 'Википедиесь',
	'mediawikiwiki' => 'MediaWiki',
	'metawiki' => 'Meta',
	'mhrwiki' => 'Википедий',
	'mkwiki' => 'Википедија',
	'mkwiktionary' => 'Викиречник', // T140566
	'mkwikimedia' => 'Викимедија Македонија',
	'mlwiki' => 'വിക്കിപീഡിയ',
	'mlwikibooks' => 'വിക്കിപാഠശാല',
	'mlwikiquote' => 'വിക്കിചൊല്ലുകൾ',
	'mlwikisource' => 'വിക്കിഗ്രന്ഥശാല',
	'mlwiktionary' => 'വിക്കിനിഘണ്ടു',
	'movementroleswiki' => 'Movement Roles',
	'mnwiki' => 'Википедиа',
	'mrjwiki' => 'Википеди',
	'mrwiki' => 'विकिपीडिया',
	'mrwikibooks' => 'विकिबुक्स', // T104132
	'mrwikisource' => 'विकिस्रोत',
	'mtwiki' => 'Wikipedija',
	'mtwiktionary' => 'Wikizzjunarju',
	'mwlwiki' => 'Biquipédia',
	'mxwikimedia' => 'Wikimedia México',
	'mywiki' => 'ဝီကီပီးဒီးယား', // T123191
	'myvwiki' => 'Википедиясь',
	'mznwiki' => 'ویکی‌پدیا',
	'nahwiki' => 'Huiquipedia',
	'nds_nlwiki' => 'Wikipedie',
	'newiki' => 'विकिपीडिया',
	'newikibooks' => 'विकिपुस्तक', // T124881
	'nlwiktionary' => 'WikiWoordenboek',
	'noboard_chapterswikimedia' => 'Wikimedia Norway Internal Board',
	'nostalgiawiki' => 'Wikipedia',
	'nowikibooks' => 'Wikibøker',
	'nowikimedia' => 'Wikimedia Norge',
	'nowikinews' => 'Wikinytt',
	'nowikisource' => 'Wikikilden',
	'nycwikimedia' => 'Wikimedia New York City', // T31273
	'ocwiki' => 'Wikipèdia', // T9123
	'ocwikibooks' => 'Wikilibres',
	'ocwiktionary' => 'Wikiccionari',
	'officewiki' => 'Wikimedia Office',
	'olowiki' => 'Wikipedii', // T146612
	'ombudsmenwiki' => 'Ombudsmen Wiki',
	'orwiki' => 'ଉଇକିପିଡ଼ିଆ',
	'orwikisource' => 'ଉଇକିପାଠାଗାର', // T73875
	'orwiktionary' => 'ଉଇକିଅଭିଧାନ', // T94142
	'oswiki' => 'Википеди',
	'otrs_wikiwiki' => 'OTRS Wiki',
	'outreachwiki' => 'Outreach Wiki',
	'pa_uswikimedia' => 'Wikimedia Pennsylvania',
	'pawiki' => 'ਵਿਕੀਪੀਡੀਆ',
	'plwikiquote' => 'Wikicytaty',
	'plwikisource' => 'Wikiźródła',
	'plwikivoyage' => 'Wikipodróże',
	'plwiktionary' => 'Wikisłownik',
	'pnbwiki' => 'وکیپیڈیا',
	'pnbwiktionary' => 'وکشنری',
	'pntwiki' => 'Βικιπαίδεια',
	'pswiki' => 'ويکيپېډيا',
	'pswikibooks' => 'ويکيتابونه',
	'pswiktionary' => 'ويکيسيند',
	'ptwiki' => 'Wikipédia',
	'ptwikibooks' => 'Wikilivros',
	'ptwikinews' => 'Wikinotícias',
	'ptwikiversity' => 'Wikiversidade',
	'ptwiktionary' => 'Wikcionário',
	'qualitywiki' => 'Wikimedia Quality',
	'rmywiki' => 'Vikipidiya',
	'rowikibooks' => 'Wikimanuale',
	'rowikinews' => 'Wikiștiri',
	'rowikiquote' => 'Wikicitat',
	'rowiktionary' => 'Wikționar',
	'rswikimedia' => 'Викимедија',
	'ruewiki' => 'Вікіпедія',
	'ruwiki' => 'Википедия',
	'ruwikibooks' => 'Викиучебник',
	'ruwikimedia' => 'Викимедиа',
	'ruwikinews' => 'Викиновости',
	'ruwikiquote' => 'Викицитатник',
	'ruwikisource' => 'Викитека',
	'ruwikiversity' => 'Викиверситет',
	'ruwiktionary' => 'Викисловарь',
	'sawiki' => 'विकिपीडिया',
	'sawikiquote' => 'विकिसूक्तिः',
	'sahwiki' => 'Бикипиэдьийэ',
	'sahwikisource' => 'Бикитиэкэ',
	'scnwiktionary' => 'Wikizziunariu',
	'searchcomwiki' => 'Search Committee',
	'siwiki' => 'විකිපීඩියා, නිදහස් විශ්වකෝෂය',
	'skwiki' => 'Wikipédia',
	'skwikibooks' => 'Wikiknihy',
	'skwikiquote' => 'Wikicitáty',
	'skwikisource' => 'Wikizdroje',
	'skwiktionary' => 'Wikislovník',
	'slwiki' => 'Wikipedija',
	'slwikibooks' => 'Wikiknjige',
	'slwikiquote' => 'Wikinavedek',
	'slwikisource' => 'Wikivir',
	'slwiktionary' => 'Wikislovar',
	'slwikiversity' => 'Wikiverza',
	'sourceswiki' => 'Wikisource',
	'spcomwiki' => 'Spcom',
	'specieswiki' => 'Wikispecies',
	'sqwikinews' => 'Wikilajme',
	'srwiki' => 'Википедија',
	'srwikibooks' => 'Викикњиге',
	'srwikinews' => 'Викиновости', // T226315
	'srwikiquote' => 'Викицитат', // T111247
	'srwikisource' => 'Викизворник',
	'srwiktionary' => 'Викиречник', // T121278
	'strategywiki' => 'Strategic Planning',
	'stewardwiki' => 'Steward Wiki',
	'tawiki' => 'விக்கிப்பீடியா',
	'tawikibooks' => 'விக்கிநூல்கள்',
	'tawikinews' => 'விக்கிசெய்தி',
	'tawiktionary' => 'விக்சனரி',
	'tawikiquote' => 'விக்கிமேற்கோள்',
	'tawikisource' => 'விக்கிமூலம்',
	'tcywiki' => 'ವಿಕಿಪೀಡಿಯ', // T140898
	'tewiki' => 'వికీపీడియా',
	'tewikiquote' => 'వికీవ్యాఖ్య', // T89332
	'tewikisource' => 'వికీసోర్స్', // T52357
	'tewiktionary' => 'విక్షనరీ',
	'tenwiki' => 'Wikipedia 10',
	'tgwiki' => 'Википедиа',
	'thwiki' => 'วิกิพีเดีย',
	'thwikibooks' => 'วิกิตำรา', // T48153
	'thwikiquote' => 'วิกิคำคม',
	'thwikisource' => 'วิกิซอร์ซ',
	'tkwiki' => 'Wikipediýa',
	'tkwiktionary' => 'Wikisözlük',
	'transitionteamwiki' => 'Transition Team Wiki',
	'trwiki' => 'Vikipedi',
	'trwikibooks' => 'Vikikitap',
	'trwikimedia' => 'Wikimedia Türkiye',
	'trwikinews' => 'Vikihaber',
	'trwikiquote' => 'Vikisöz',
	'trwikisource' => 'Vikikaynak', // T44721
	'trwiktionary' => 'Vikisözlük',
	'tyvwiki' => 'Википедия', // T51328
	'uawikimedia' => 'Вікімедіа Україна',
	'udmwiki' => 'Википедия', // T49820
	'ukwiki' => 'Вікіпедія',
	'ukwikibooks' => 'Вікіпідручник',
	'ukwikimedia' => 'Wikimedia UK', // Andrew 2009-04-27 Private request of current board member
	'ukwikinews' => 'Вікіновини', // T50843
	'ukwikiquote' => 'Вікіцитати',
	'ukwikisource' => 'Вікіджерела',
	'ukwikivoyage' => 'Вікімандри',
	'ukwiktionary' => 'Вікісловник',
	'urwiki' => 'ویکیپیڈیا', // T44155
	'urwikibooks' => 'وکی کتب',
	'urwikiquote' => 'وکی اقتباسات',
	'urwiktionary' => 'وکی لغت',
	'usabilitywiki' => 'Wikimedia Usability Initiative',
	'uzwiki' => 'Vikipediya',
	'uzwikibooks' => 'Vikikitob',
	'uzwikiquote' => 'Vikiiqtibos',
	'uzwiktionary' => 'Vikilug‘at',
	'vecwiktionary' => 'Wikisionario',
	'vepwiki' => 'Vikipedii',
	'votewiki' => 'Wikimedia Vote Wiki', // T53264
	'vowiki' => 'Vükiped',
	'vowikibooks' => 'Vükibuks',
	'vowiktionary' => 'Vükivödabuk',
	'wg_enwiki' => 'Wikipedia Working Group',
	'wikimaniateamwiki' => 'WikimaniaTeam',
	'wuuwiki' => '维基百科', // T128354
	'xmfwiki' => 'ვიკიპედია',
	'yiwiki' => 'װיקיפּעדיע',
	'yiwikisource' => 'װיקיביבליאָטעק',
	'yiwiktionary' => 'װיקיװערטערבוך',
	'zh_min_nanwikisource' => 'Wiki Tô·-su-kóan',
	'zh_classicalwiki' => '維基大典',
	'zhwikivoyage' => '维基导游', // T61077
	'zh_yuewiki' => '維基百科',
],
# @} end of wgSitename

];
