
# Migration Guide 2.7 -> 2.8


## Summary
The unified metrics handle has been expanded to enable metrics recording through multiple clients.  Previously, the metrics handle was an instance of the StatsD or Log client.  Now, metrics users should request a Metric instance from the metrics handle with configuration for all configured clients and operate on the provided methods (See lib/metrics/index.js).

Care has been taken to provide a largely-backwards-compatible interface with the legacy metrics handle, but not all methods in the StatsD client are implemented (See: service-runner/lib/metrics/metric.js).  A deprecation warning is logged when using the backwards-compatible interface and an error is logged on calling a unimplemented method.

## Configuring both Prometheus and StatsD
To enable the Prometheus client and endpoint, update the metrics section in your config.yaml to an array like so:
```yaml
# ...

metrics:
  - type: prometheus
    # probably not 9000 - possible collisions https://github.com/prometheus/prometheus/wiki/Default-port-allocations
    port: 9000
  - type: statsd
    host: localhost
    port: 8125

# ...
```

## Examples

#### Version <= 2.7.3
```js
class ExampleService {
    constructor(options) {
        this.options = options;
    }
    incrementDemoMetric() {
        this.options.metrics.increment('demo.called');
    }
}
```

#### Version >= 2.8.0
```js
class ExampleService {
     // assuming in config package.name = example_service
    constructor(options) {
        this.options = options;
    }

    incrementDemoMetric() {
        this.options.metrics.makeMetric({
            type: 'Counter',
            name: 'demo.called',
            prometheus: {
                name: 'example_service_demo_called_count',
                help: 'demo hit count',
            }
        }).increment();
        // emits to statsd server: example_service.demo.called:1c
        // registers in prometheus endpoint: example_service_demo_called_count{} 1.0
    }
}

// using labels makes the metric more easily attributable
class ExampleService {
    // assuming in config package.name = example_service
    constructor(options) {
            this.options = options;
        }

        incrementDemoMetric() {
            this.options.metrics.makeMetric({
                type: 'Counter',
                name: 'demo.called',
                prometheus: {
                    name: 'example_service_demo_called_count',
                    help: 'demo hit count',
                },
                labels: {
                    names: ['caller']
                }
            }).increment(1, ['foo']);
            // emits to statsd server: example_service.demo.called.caller.foo:1c
            // registers in prometheus endpoint: example_service_demo_called_count{'caller': 'foo'} 1.0
        }
}
```
