/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPAttributeReferencePurpose;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueRenderer;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSContextBoundAttribute;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.utils.CommonUtils;

public abstract class DBDAttributeBinding
implements DBSObject,
DBSAttributeBase,
DBSTypedObjectEx,
DBPQualifiedObject {
    @NotNull
    protected DBDValueHandler valueHandler;
    @Nullable
    private DBSAttributeBase presentationAttribute;
    @Nullable
    private List<DBDAttributeBinding> nestedBindings;
    private boolean transformed;
    private boolean disableTransformers;

    protected DBDAttributeBinding(@NotNull DBDValueHandler valueHandler) {
        this.valueHandler = valueHandler;
    }

    public boolean isCustom() {
        return false;
    }

    @Override
    @Nullable
    public abstract DBDAttributeBinding getParentObject();

    @Override
    public abstract int getOrdinalPosition();

    @NotNull
    public abstract String getLabel();

    @Override
    @NotNull
    public abstract String getName();

    @Nullable
    public abstract DBCAttributeMetaData getMetaAttribute();

    @Nullable
    public abstract DBSEntityAttribute getEntityAttribute();

    @NotNull
    public DBSAttributeBase getAttribute() {
        DBSEntityAttribute attr = this.getEntityAttribute();
        return attr == null ? this.getMetaAttribute() : attr;
    }

    @Nullable
    public DBSAttributeBase getPresentationAttribute() {
        if (this.presentationAttribute != null) {
            return this.presentationAttribute;
        }
        return this.getAttribute();
    }

    public void setPresentationAttribute(@Nullable DBSAttributeBase presentationAttribute) {
        this.presentationAttribute = presentationAttribute;
    }

    public boolean isPseudoAttribute() {
        return false;
    }

    public DBSDataContainer getDataContainer() {
        DBDAttributeBinding parentObject = this.getParentObject();
        return parentObject == null ? null : parentObject.getDataContainer();
    }

    @Nullable
    public abstract DBDRowIdentifier getRowIdentifier();

    public abstract String getRowIdentifierStatus();

    public boolean isInRowIdentifier() {
        DBDRowIdentifier rowIdentifier = this.getRowIdentifier();
        return rowIdentifier != null && rowIdentifier.hasAttribute(this);
    }

    @Nullable
    public abstract List<DBSEntityReferrer> getReferrers();

    @Nullable
    public abstract Object extractNestedValue(@NotNull Object var1, int var2) throws DBCException;

    @NotNull
    public DBDValueHandler getValueHandler() {
        return this.valueHandler;
    }

    public void setTransformHandler(@NotNull DBDValueHandler valueHandler) {
        this.valueHandler = valueHandler;
        this.transformed = true;
    }

    public boolean isTransformed() {
        return this.transformed;
    }

    public void disableTransformers(boolean disableTransformers) {
        this.disableTransformers = disableTransformers;
    }

    @NotNull
    public DBDValueRenderer getValueRenderer() {
        return this.valueHandler;
    }

    public boolean matches(@Nullable DBSAttributeBase attr, boolean searchByName) {
        if (attr != null && (this == attr || this.getMetaAttribute() == attr || this.getEntityAttribute() == attr)) {
            return true;
        }
        if (searchByName) {
            if (attr instanceof DBDAttributeBinding) {
                DBDAttributeBinding cmpAttr = (DBDAttributeBinding)attr;
                if (this.getLevel() != cmpAttr.getLevel() || this.getOrdinalPosition() != cmpAttr.getOrdinalPosition()) {
                    return false;
                }
                DBDAttributeBinding a1 = cmpAttr;
                DBDAttributeBinding a2 = this;
                while (a1 != null && a2 != null) {
                    if (!SQLUtils.compareAliases(attr.getName(), this.getName())) {
                        return false;
                    }
                    a1 = a1.getParentObject();
                    a2 = a2.getParentObject();
                }
                return true;
            }
            if (attr != null) {
                return SQLUtils.compareAliases(attr.getName(), this.getName());
            }
        }
        return false;
    }

    @Nullable
    public List<DBDAttributeBinding> getNestedBindings() {
        return this.nestedBindings;
    }

    public boolean hasNestedBindings() {
        return this.nestedBindings != null;
    }

    public void setNestedBindings(@NotNull List<DBDAttributeBinding> nestedBindings) {
        this.nestedBindings = nestedBindings;
    }

    @Override
    @Nullable
    public String getDescription() {
        DBSEntityAttribute attr = this.getEntityAttribute();
        return attr == null ? null : attr.getDescription();
    }

    @Override
    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return this.getFullyQualifiedName(context, DBPAttributeReferencePurpose.UNSPECIFIED);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context, @NotNull DBPAttributeReferencePurpose purpose) {
        DBSEntityAttribute dBSEntityAttribute = this.getEntityAttribute();
        if (dBSEntityAttribute instanceof DBSContextBoundAttribute) {
            DBSContextBoundAttribute cba = (DBSContextBoundAttribute)dBSEntityAttribute;
            if (purpose != DBPAttributeReferencePurpose.UNSPECIFIED) {
                return cba.formatMemberReference(false, null, purpose);
            }
        }
        DBPDataSource dataSource = this.getDataSource();
        if (this.getParentObject() == null) {
            return DBUtils.getQuotedIdentifier(dataSource, this.getName());
        }
        char structSeparator = dataSource.getSQLDialect().getStructSeparator();
        StringBuilder query = new StringBuilder();
        boolean hasPrevIdentifier = false;
        DBDAttributeBinding attribute = this;
        while (attribute != null) {
            if (!(attribute.isPseudoAttribute() || attribute.getParentObject() == null && attribute.getDataKind() == DBPDataKind.DOCUMENT)) {
                if (hasPrevIdentifier) {
                    query.insert(0, structSeparator);
                }
                query.insert(0, DBUtils.getQuotedIdentifier(dataSource, attribute.getName()));
                hasPrevIdentifier = true;
            }
            attribute = attribute.getParentObject();
        }
        return query.toString();
    }

    @Override
    public boolean isPersisted() {
        return false;
    }

    @Nullable
    public DBDAttributeBinding getParent(int grand) {
        if (grand == 0) {
            return this;
        }
        DBDAttributeBinding p = this;
        int i = 0;
        while (i < grand) {
            if (p == null) {
                throw new IllegalArgumentException("Bad parent depth: " + grand);
            }
            p = p.getParentObject();
            ++i;
        }
        return p;
    }

    @NotNull
    public DBDAttributeBinding getTopParent() {
        DBDAttributeBinding binding = this;
        while (binding.getParentObject() != null) {
            binding = binding.getParentObject();
        }
        return binding;
    }

    public int getLevel() {
        if (this.getParentObject() == null) {
            return 0;
        }
        int level = 0;
        DBDAttributeBinding binding = this.getParentObject();
        while (binding != null) {
            ++level;
            binding = binding.getParentObject();
        }
        return level;
    }

    @Override
    @Nullable
    public DBSDataType getDataType() {
        DBSEntityAttribute attribute = this.getEntityAttribute();
        if (attribute instanceof DBSTypedObjectEx) {
            return ((DBSTypedObjectEx)((Object)attribute)).getDataType();
        }
        return null;
    }

    public void lateBinding(@NotNull DBCSession session, List<Object[]> rows) throws DBException {
        if (this.disableTransformers) {
            return;
        }
        DBDAttributeTransformer[] transformers = DBVUtils.findAttributeTransformers(this, null);
        if (transformers != null) {
            Map<String, Object> transformerOptions = DBVUtils.getAttributeTransformersOptions(this);
            DBDAttributeTransformer[] dBDAttributeTransformerArray = transformers;
            int n = transformers.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeTransformer transformer = dBDAttributeTransformerArray[n2];
                transformer.transformAttribute(session, this, rows, transformerOptions);
                ++n2;
            }
        }
    }

    protected List<DBSEntityReferrer> findVirtualReferrers() {
        List<DBVEntityForeignKey> foreignKeys;
        DBSEntity attrEntity;
        DBVEntity vEntity;
        DBSDataContainer dataContainer = this.getDataContainer();
        if (dataContainer instanceof DBSEntity && (vEntity = DBVUtils.getVirtualEntity(attrEntity = (DBSEntity)((Object)dataContainer), false)) != null && !CommonUtils.isEmpty(foreignKeys = vEntity.getForeignKeys())) {
            ArrayList<DBVEntityForeignKey> referrers = null;
            for (DBVEntityForeignKey vfk : foreignKeys) {
                for (DBVEntityForeignKeyColumn vfkc : vfk.getAttributes()) {
                    if (!CommonUtils.equalObjects((Object)vfkc.getAttributeName(), (Object)this.getFullyQualifiedName(DBPEvaluationContext.DML))) continue;
                    if (referrers == null) {
                        referrers = new ArrayList<DBVEntityForeignKey>();
                    }
                    referrers.add(vfk);
                }
            }
            return referrers;
        }
        return null;
    }

    public String toString() {
        DBDAttributeBinding parentAttr = this.getParentObject();
        if (parentAttr == null) {
            return this.getName();
        }
        return parentAttr.getName() + "." + this.getName();
    }
}

