/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle;

import java.awt.Color;
import org.freeplane.api.HorizontalTextAlignment;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.api.TextWritingDirection;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.features.nodestyle.NodeStyleShape;

public class NodeStyleModel
implements IExtension,
Cloneable {
    private Color backgroundColor;
    private Color color;
    private String fontFamilyName = null;
    private Integer fontSize = null;
    private Boolean isBold = null;
    private Boolean isUnderlined = null;
    private Boolean isStrikedThrough = null;
    private Boolean isItalic = null;
    private NodeGeometryModel shapeConfiguration = NodeGeometryModel.NULL_SHAPE;
    private Boolean nodeNumbering = null;
    private String nodeFormat = null;
    private HorizontalTextAlignment horizontalTextAlignment = null;
    private TextWritingDirection textWritingDirection = null;

    public static NodeStyleModel createNodeStyleModel(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        if (styleModel == null) {
            styleModel = new NodeStyleModel();
            node.addExtension(styleModel);
        }
        return styleModel;
    }

    public static Color getBackgroundColor(NodeModel node) {
        NodeStyleModel styleModel = NodeStyleModel.getModel(node);
        return styleModel == null ? null : styleModel.getBackgroundColor();
    }

    public static Color getColor(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getColor();
    }

    public static String getFontFamilyName(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getFontFamilyName();
    }

    public static Integer getFontSize(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getFontSize();
    }

    public static NodeStyleModel getModel(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel;
    }

    public static Boolean getNodeNumbering(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getNodeNumbering();
    }

    public static String getNodeFormat(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getNodeFormat();
    }

    public static NodeStyleShape getShape(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getShape();
    }

    public static NodeGeometryModel getShapeConfiguration(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? NodeGeometryModel.NULL_SHAPE : styleModel.getShapeConfiguration();
    }

    public static Boolean isBold(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.isBold();
    }

    public static Boolean isUnderlined(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.isUnderlined();
    }

    public static Boolean isStrikedThrough(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.isStrikedThrough();
    }

    public static Boolean isItalic(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.isItalic();
    }

    public static HorizontalTextAlignment getHorizontalTextAlignment(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getHorizontalTextAlignment();
    }

    public static TextWritingDirection getTextWritingDirection(NodeModel node) {
        NodeStyleModel styleModel = node.getExtension(NodeStyleModel.class);
        return styleModel == null ? null : styleModel.getTextWritingDirection();
    }

    public static void setBackgroundColor(NodeModel node, Color color) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setBackgroundColor(color);
    }

    public static void setColor(NodeModel node, Color color) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setColor(color);
    }

    public static void setNodeNumbering(NodeModel node, Boolean enableNodeNumbering) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setNodeNumbering(enableNodeNumbering);
    }

    public static void setNodeFormat(NodeModel node, String nodeFormat) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setNodeFormat(nodeFormat);
    }

    public static void setShape(NodeModel node, String shape) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setShape(shape);
    }

    public static void setShape(NodeModel node, NodeStyleShape shape) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setShape(shape);
    }

    public static void setShapeHorizontalMargin(NodeModel node, Quantity<LengthUnit> margin) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setShapeConfiguration(styleModel.getShapeConfiguration().withHorizontalMargin(margin));
    }

    public static void setShapeVerticalMargin(NodeModel node, Quantity<LengthUnit> margin) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setShapeConfiguration(styleModel.getShapeConfiguration().withVerticalMargin(margin));
    }

    public static void setShapeUniform(NodeModel node, boolean uniform) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setShapeConfiguration(styleModel.getShapeConfiguration().withUniform(uniform));
    }

    public static void setShapeConfiguration(NodeModel node, NodeGeometryModel shape) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setShapeConfiguration(shape);
    }

    public static void setHorizontalTextAlignment(NodeModel node, HorizontalTextAlignment textAlignment) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setHorizontalTextAlignment(textAlignment);
    }

    public static void setTextWritingDirection(NodeModel node, TextWritingDirection textAlignment) {
        NodeStyleModel styleModel = NodeStyleModel.createNodeStyleModel(node);
        styleModel.setTextWritingDirection(textAlignment);
    }

    protected NodeStyleModel clone() {
        return this.copyTo(new NodeStyleModel());
    }

    public NodeStyleModel copyTo(NodeStyleModel to) {
        if (this.color != null) {
            to.setColor(this.color);
        }
        if (this.backgroundColor != null) {
            to.setBackgroundColor(this.backgroundColor);
        }
        if (this.isBold != null) {
            to.setBold(this.isBold);
        }
        if (this.isUnderlined != null) {
            to.setUnderlined(this.isUnderlined);
        }
        if (this.fontFamilyName != null) {
            to.setFontFamilyName(this.fontFamilyName);
        }
        if (this.fontSize != null) {
            to.setFontSize(this.fontSize);
        }
        if (this.isItalic != null) {
            to.setItalic(this.isItalic);
        }
        if (this.isStrikedThrough != null) {
            to.setStrikedThrough(this.isStrikedThrough);
        }
        if (this.shapeConfiguration != NodeGeometryModel.NULL_SHAPE) {
            to.setShapeConfiguration(this.shapeConfiguration);
        }
        if (this.nodeFormat != null) {
            to.setNodeFormat(this.nodeFormat);
        }
        if (this.nodeNumbering != null) {
            to.setNodeNumbering(this.nodeNumbering);
        }
        if (this.horizontalTextAlignment != null) {
            to.setHorizontalTextAlignment(this.horizontalTextAlignment);
        }
        if (this.textWritingDirection != null) {
            to.setTextWritingDirection(this.textWritingDirection);
        }
        return to;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getColor() {
        return this.color;
    }

    public String getFontFamilyName() {
        return this.fontFamilyName;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public Boolean getNodeNumbering() {
        return this.nodeNumbering;
    }

    public String getNodeFormat() {
        return this.nodeFormat;
    }

    public NodeStyleShape getShape() {
        return this.getShapeConfiguration().getShape();
    }

    public Boolean isBold() {
        return this.isBold;
    }

    public Boolean isUnderlined() {
        return this.isUnderlined;
    }

    public Boolean isStrikedThrough() {
        return this.isStrikedThrough;
    }

    public Boolean isItalic() {
        return this.isItalic;
    }

    public HorizontalTextAlignment getHorizontalTextAlignment() {
        return this.horizontalTextAlignment;
    }

    public TextWritingDirection getTextWritingDirection() {
        return this.textWritingDirection;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setBold(Boolean isBold) {
        this.isBold = isBold;
    }

    public void setUnderlined(Boolean isUnderline) {
        this.isUnderlined = isUnderline;
    }

    public void setStrikedThrough(Boolean isStrikedThrough) {
        this.isStrikedThrough = isStrikedThrough;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFontFamilyName(String fontFamilyName) {
        this.fontFamilyName = fontFamilyName;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public void setItalic(Boolean isItalic) {
        this.isItalic = isItalic;
    }

    public void setNodeNumbering(Boolean enableNodeNumbering) {
        this.nodeNumbering = enableNodeNumbering;
    }

    public void setNodeFormat(String nodeFormat) {
        this.nodeFormat = nodeFormat;
    }

    public void setShape(String shape) {
        try {
            this.setShapeConfiguration(this.getShapeConfiguration().withShape(shape != null ? NodeStyleShape.valueOf(shape) : null));
        }
        catch (IllegalArgumentException e) {
            LogUtils.warn("unknown shape " + shape);
        }
    }

    public void setShape(NodeStyleShape shape) {
        this.setShapeConfiguration(this.getShapeConfiguration().withShape(shape));
    }

    public void setHorizontalTextAlignment(HorizontalTextAlignment textAlignment) {
        this.horizontalTextAlignment = textAlignment;
    }

    public void setTextWritingDirection(TextWritingDirection textWritingDirection) {
        this.textWritingDirection = textWritingDirection;
    }

    public NodeGeometryModel getShapeConfiguration() {
        return this.shapeConfiguration;
    }

    public void setShapeConfiguration(NodeGeometryModel shapeConfiguration) {
        if (shapeConfiguration == null) {
            throw new RuntimeException("Null pointer as shapeConfiguration");
        }
        this.shapeConfiguration = shapeConfiguration;
    }
}

