/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.core.resources.components.ColorProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

class EdgeColorControlGroup
implements ControlGroup {
    private static final String EDGE_COLOR = "edgecolor";
    private RevertingProperty mSetEdgeColor;
    private ColorProperty mEdgeColor;
    private EdgeColorChangeListener propertyChangeListener;

    EdgeColorControlGroup() {
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetEdgeColor = new RevertingProperty();
        this.mEdgeColor = new ColorProperty(EDGE_COLOR, ColorUtils.colorToString((Color)EdgeController.STANDARD_EDGE_COLOR));
        this.propertyChangeListener = new EdgeColorChangeListener(this.mSetEdgeColor, (IPropertyControl)this.mEdgeColor);
        this.mSetEdgeColor.addPropertyChangeListener(this.propertyChangeListener);
        this.mEdgeColor.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mEdgeColor.appendToForm(formBuilder);
        this.mSetEdgeColor.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    private class EdgeColorChangeListener
    extends ControlGroupChangeListener {
        public EdgeColorChangeListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MEdgeController edgeController = (MEdgeController)MEdgeController.getController();
            edgeController.setColor(node, enabled ? EdgeColorControlGroup.this.mEdgeColor.getColorValue() : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            EdgeModel edgeModel = EdgeModel.getModel((NodeModel)node);
            EdgeController edgeController = EdgeController.getController();
            Color edgeColor = edgeModel != null ? edgeModel.getColor() : null;
            Color viewColor = edgeController.getColor(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            EdgeColorControlGroup.this.mSetEdgeColor.setValue(edgeColor != null);
            EdgeColorControlGroup.this.mEdgeColor.setColorValue(viewColor);
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, EdgeColorControlGroup.this.mSetEdgeColor);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)EdgeColorControlGroup.this.mEdgeColor);
        }
    }
}

