/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import org.hibernate.dialect.function.xml.XmlTableFunction;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.XmlTableColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableColumnsClause;
import org.hibernate.sql.ast.tree.expression.XmlTableOrdinalityColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableQueryColumnDefinition;
import org.hibernate.sql.ast.tree.expression.XmlTableValueColumnDefinition;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerXmlTableFunction
extends XmlTableFunction {
    public SQLServerXmlTableFunction(TypeConfiguration typeConfiguration) {
        super(false, typeConfiguration);
    }

    @Override
    protected void renderXmlTable(SqlAppender sqlAppender, XmlTableFunction.XmlTableArguments arguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("(select");
        this.renderColumns(sqlAppender, arguments.columnsClause(), walker);
        sqlAppender.appendSql(" from (select ");
        if (!arguments.isXmlType()) {
            sqlAppender.appendSql("cast(");
        }
        arguments.xmlDocument().accept(walker);
        if (!arguments.isXmlType()) {
            sqlAppender.appendSql(" as xml)");
        }
        sqlAppender.appendSql(") t0_(d) cross apply t0_.d.nodes(");
        walker.render(arguments.xpath(), SqlAstNodeRenderingMode.INLINE_PARAMETERS);
        sqlAppender.appendSql(") t1_(d))");
    }

    @Override
    protected void renderColumns(SqlAppender sqlAppender, XmlTableColumnsClause xmlTableColumnsClause, SqlAstTranslator<?> walker) {
        int separator = 32;
        for (XmlTableColumnDefinition columnDefinition : xmlTableColumnsClause.getColumnDefinitions()) {
            sqlAppender.appendSql((char)separator);
            if (columnDefinition instanceof XmlTableQueryColumnDefinition) {
                XmlTableQueryColumnDefinition definition = (XmlTableQueryColumnDefinition)columnDefinition;
                this.renderXmlQueryColumnDefinition(sqlAppender, definition, walker);
            } else if (columnDefinition instanceof XmlTableValueColumnDefinition) {
                XmlTableValueColumnDefinition definition = (XmlTableValueColumnDefinition)columnDefinition;
                this.renderXmlValueColumnDefinition(sqlAppender, definition, walker);
            } else {
                this.renderXmlOrdinalityColumnDefinition(sqlAppender, (XmlTableOrdinalityColumnDefinition)columnDefinition, walker);
            }
            separator = 44;
        }
    }

    @Override
    protected void renderXmlOrdinalityColumnDefinition(SqlAppender sqlAppender, XmlTableOrdinalityColumnDefinition definition, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("row_number() over (order by (select 1)) ");
        sqlAppender.appendSql(definition.name());
    }

    @Override
    protected void renderXmlValueColumnDefinition(SqlAppender sqlAppender, XmlTableValueColumnDefinition definition, SqlAstTranslator<?> walker) {
        if (definition.defaultExpression() != null) {
            sqlAppender.appendSql("coalesce(");
        }
        sqlAppender.appendSql("t1_.d.value('(");
        sqlAppender.appendSql(definition.xpath() == null ? definition.name() : definition.xpath());
        sqlAppender.appendSql(")[1]',");
        sqlAppender.appendSingleQuoteEscapedString(this.determineColumnType(definition.type(), walker));
        sqlAppender.appendSql(')');
        if (definition.defaultExpression() != null) {
            sqlAppender.appendSql(',');
            definition.defaultExpression().accept(walker);
            sqlAppender.appendSql(')');
        }
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(definition.name());
    }

    @Override
    protected void renderXmlQueryColumnDefinition(SqlAppender sqlAppender, XmlTableQueryColumnDefinition definition, SqlAstTranslator<?> walker) {
        if (definition.defaultExpression() != null) {
            sqlAppender.appendSql("coalesce(");
        }
        sqlAppender.appendSql("t1_.d.query('(");
        sqlAppender.appendSql(definition.xpath() == null ? definition.name() : definition.xpath());
        sqlAppender.appendSql(")[1]')");
        if (definition.defaultExpression() != null) {
            sqlAppender.appendSql(',');
            definition.defaultExpression().accept(walker);
            sqlAppender.appendSql(')');
        }
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(definition.name());
    }
}

