/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.tokenexchange;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authentication.authenticators.util.AuthenticatorUtils;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.ExchangeExternalToken;
import org.keycloak.broker.provider.ExchangeTokenToIdentityProviderToken;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.broker.provider.IdentityProviderMapperSyncModeDelegate;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.protocol.oidc.TokenExchangeContext;
import org.keycloak.protocol.oidc.TokenExchangeProvider;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.admin.fgap.AdminPermissions;
import org.keycloak.services.validation.Validation;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public abstract class AbstractTokenExchangeProvider
implements TokenExchangeProvider {
    private static final Logger logger = Logger.getLogger(AbstractTokenExchangeProvider.class);
    protected TokenExchangeContext.Params params;
    protected MultivaluedMap<String, String> formParams;
    protected KeycloakSession session;
    protected Cors cors;
    protected RealmModel realm;
    protected ClientModel client;
    protected EventBuilder event;
    protected ClientConnection clientConnection;
    protected HttpHeaders headers;
    protected TokenManager tokenManager;
    protected Map<String, String> clientAuthAttributes;
    protected TokenExchangeContext context;

    public Response exchange(TokenExchangeContext context) {
        this.params = context.getParams();
        this.formParams = context.getFormParams();
        this.session = context.getSession();
        this.cors = context.getCors();
        this.realm = context.getRealm();
        this.client = context.getClient();
        this.event = context.getEvent();
        this.clientConnection = context.getClientConnection();
        this.headers = context.getHeaders();
        this.tokenManager = (TokenManager)context.getTokenManager();
        this.clientAuthAttributes = context.getClientAuthAttributes();
        this.context = context;
        return this.tokenExchange();
    }

    public void close() {
    }

    protected abstract Response tokenExchange();

    protected boolean isExternalInternalTokenExchangeRequest(TokenExchangeContext context) {
        String subjectToken = context.getParams().getSubjectToken();
        KeycloakSession session = context.getSession();
        RealmModel realm = context.getRealm();
        EventBuilder event = context.getEvent();
        if (subjectToken != null) {
            String subjectTokenType = context.getParams().getSubjectTokenType();
            String realmIssuerUrl = Urls.realmIssuer(session.getContext().getUri().getBaseUri(), realm.getName());
            String subjectIssuer = this.getSubjectIssuer(context, subjectToken, subjectTokenType);
            if (subjectIssuer != null && !realmIssuerUrl.equals(subjectIssuer)) {
                event.detail("subject_issuer", subjectIssuer);
                return true;
            }
        }
        return false;
    }

    protected String getSubjectIssuer(TokenExchangeContext context, String subjectToken, String subjectTokenType) {
        String subjectIssuer = (String)context.getFormParams().getFirst((Object)"subject_issuer");
        if (subjectIssuer != null) {
            return subjectIssuer;
        }
        if ("urn:ietf:params:oauth:token-type:jwt".equals(subjectTokenType)) {
            try {
                JWSInput jws = new JWSInput(subjectToken);
                JsonWebToken jwt = (JsonWebToken)jws.readJsonContent(JsonWebToken.class);
                return jwt.getIssuer();
            }
            catch (JWSInputException e) {
                context.getEvent().detail("reason", "unable to parse jwt subject_token");
                context.getEvent().error("invalid_token");
                throw new CorsErrorResponseException(context.getCors(), "invalid_request", "Invalid token type, must be access token", Response.Status.BAD_REQUEST);
            }
        }
        return null;
    }

    protected Response exchangeToIdentityProvider(UserModel targetUser, UserSessionModel targetUserSession, String requestedIssuer) {
        this.event.detail("requested_issuer", requestedIssuer);
        IdentityProviderModel providerModel = this.session.identityProviders().getByAlias(requestedIssuer);
        if (providerModel == null) {
            this.event.detail("reason", "unknown requested_issuer");
            this.event.error("unknown_identity_provider");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Invalid issuer", Response.Status.BAD_REQUEST);
        }
        IdentityProvider<?> provider = IdentityBrokerService.getIdentityProvider(this.session, requestedIssuer);
        if (!(provider instanceof ExchangeTokenToIdentityProviderToken)) {
            this.event.detail("reason", "exchange unsupported by requested_issuer");
            this.event.error("unknown_identity_provider");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Issuer does not support token exchange", Response.Status.BAD_REQUEST);
        }
        if (!AdminPermissions.management(this.session, this.realm).idps().canExchangeTo(this.client, providerModel)) {
            this.event.detail("reason", "client not allowed to exchange for requested_issuer");
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
        }
        Response response = ((ExchangeTokenToIdentityProviderToken)provider).exchangeFromToken((UriInfo)this.session.getContext().getUri(), this.event, this.client, targetUserSession, targetUser, this.formParams);
        return this.cors.add(Response.fromResponse((Response)response));
    }

    protected abstract String getRequestedTokenType();

    protected List<ClientModel> getTargetAudienceClients() {
        List audienceParams = this.params.getAudience();
        ArrayList<ClientModel> targetAudienceClients = new ArrayList<ClientModel>();
        if (audienceParams != null) {
            for (String audience : audienceParams) {
                ClientModel targetClient = this.realm.getClientByClientId(audience);
                if (targetClient == null) {
                    this.event.detail("reason", "audience not found");
                    this.event.detail("audience", audience);
                    this.event.error("client_not_found");
                    throw new CorsErrorResponseException(this.cors, "invalid_client", "Audience not found", Response.Status.BAD_REQUEST);
                }
                targetAudienceClients.add(targetClient);
            }
        }
        if (targetAudienceClients.isEmpty()) {
            targetAudienceClients.add(this.client);
        }
        return targetAudienceClients;
    }

    protected abstract void validateAudience(AccessToken var1, boolean var2, List<ClientModel> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response exchangeClientToClient(UserModel targetUser, UserSessionModel targetUserSession, AccessToken token, boolean disallowOnHolderOfTokenMismatch) {
        String requestedTokenType = this.getRequestedTokenType();
        this.event.detail("requested_token_type", requestedTokenType);
        List<ClientModel> targetAudienceClients = this.getTargetAudienceClients();
        this.validateAudience(token, disallowOnHolderOfTokenMismatch, targetAudienceClients);
        String scope = this.getRequestedScope(token, targetAudienceClients);
        try {
            this.setClientToContext(targetAudienceClients);
            if (this.getSupportedOAuthResponseTokenTypes().contains(requestedTokenType)) {
                Response response = this.exchangeClientToOIDCClient(targetUser, targetUserSession, requestedTokenType, targetAudienceClients, scope, token);
                return response;
            }
            if ("urn:ietf:params:oauth:token-type:saml2".equals(requestedTokenType)) {
                Response response = this.exchangeClientToSAML2Client(targetUser, targetUserSession, requestedTokenType, targetAudienceClients);
                return response;
            }
        }
        finally {
            this.session.getContext().setClient(this.client);
        }
        throw new CorsErrorResponseException(this.cors, "invalid_request", "requested_token_type unsupported", Response.Status.BAD_REQUEST);
    }

    protected void forbiddenIfClientIsNotWithinTokenAudience(AccessToken token) {
        if (token != null && !token.hasAudience(this.client.getClientId())) {
            this.event.detail("reason", "client is not within the token audience");
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "access_denied", "Client is not within the token audience", Response.Status.FORBIDDEN);
        }
    }

    protected void forbiddenIfClientIsNotTokenHolder(boolean disallowOnHolderOfTokenMismatch, ClientModel tokenHolder) {
        if (disallowOnHolderOfTokenMismatch && !this.client.equals((Object)tokenHolder)) {
            this.event.detail("reason", "client is not the token holder");
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "access_denied", "Client is not the holder of the token", Response.Status.FORBIDDEN);
        }
    }

    protected abstract List<String> getSupportedOAuthResponseTokenTypes();

    protected AuthenticationSessionModel createSessionModel(UserSessionModel targetUserSession, RootAuthenticationSessionModel rootAuthSession, UserModel targetUser, ClientModel client, String scope) {
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(client);
        authSession.setAuthenticatedUser(targetUser);
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        return authSession;
    }

    protected abstract String getRequestedScope(AccessToken var1, List<ClientModel> var2);

    protected void setClientToContext(List<ClientModel> targetAudienceClients) {
        this.session.getContext().setClient(this.client);
    }

    protected abstract Response exchangeClientToOIDCClient(UserModel var1, UserSessionModel var2, String var3, List<ClientModel> var4, String var5, AccessToken var6);

    protected abstract Response exchangeClientToSAML2Client(UserModel var1, UserSessionModel var2, String var3, List<ClientModel> var4);

    protected Response exchangeExternalToken(String subjectIssuer, String subjectToken) {
        ExternalExchangeContext externalExchangeContext = this.locateExchangeExternalTokenByAlias(subjectIssuer);
        if (externalExchangeContext == null) {
            this.event.error("invalid_issuer");
            throw new CorsErrorResponseException(this.cors, "invalid_issuer", "Invalid subject_issuer parameter", Response.Status.BAD_REQUEST);
        }
        if (!AdminPermissions.management(this.session, this.realm).idps().canExchangeTo(this.client, externalExchangeContext.idpModel())) {
            this.event.detail("reason", "client not allowed to exchange subject_issuer");
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
        }
        BrokeredIdentityContext context = externalExchangeContext.provider().exchangeExternal((TokenExchangeProvider)this, this.context);
        if (context == null) {
            this.event.error("invalid_issuer");
            throw new CorsErrorResponseException(this.cors, "invalid_issuer", "Invalid subject_issuer parameter", Response.Status.BAD_REQUEST);
        }
        UserModel user = this.importUserFromExternalIdentity(context);
        UserSessionModel userSession = new UserSessionManager(this.session).createUserSession(this.realm, user, user.getUsername(), this.clientConnection.getRemoteHost(), "external-exchange", false, null, null);
        externalExchangeContext.provider().exchangeExternalComplete(userSession, context, this.formParams);
        userSession.setNote("EXTERNAL_IDENTITY_PROVIDER", externalExchangeContext.idpModel().getAlias());
        userSession.setNote("FEDERATED_ACCESS_TOKEN", subjectToken);
        context.addSessionNotesToUserSession(userSession);
        return this.exchangeClientToClient(user, userSession, null, false);
    }

    protected UserModel importUserFromExternalIdentity(BrokeredIdentityContext context) {
        IdentityProviderModel identityProviderConfig = context.getIdpConfig();
        String providerId = identityProviderConfig.getAlias();
        context.getIdp().preprocessFederatedIdentity(this.session, this.realm, context);
        Set mappers = this.session.identityProviders().getMappersByAliasStream(context.getIdpConfig().getAlias()).collect(Collectors.toSet());
        KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
        for (IdentityProviderMapperModel mapper : mappers) {
            IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
            target.preprocessFederatedIdentity(this.session, this.realm, mapper, context);
        }
        UserModel user = null;
        if (!context.getIdpConfig().isTransientUsers()) {
            FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(providerId, context.getId(), context.getUsername(), context.getToken());
            user = this.session.users().getUserByFederatedIdentity(this.realm, federatedIdentityModel);
        }
        if (user == null || context.getIdpConfig().isTransientUsers()) {
            Object existingUser;
            logger.debugf("Federated user not found for provider '%s' and broker username '%s'.", (Object)providerId, (Object)context.getUsername());
            Object username = context.getModelUsername();
            if (username == null) {
                username = this.realm.isRegistrationEmailAsUsername() && !Validation.isBlank(context.getEmail()) ? context.getEmail() : (context.getUsername() == null ? context.getIdpConfig().getAlias() + "." + context.getId() : context.getUsername());
            }
            username = ((String)username).trim();
            context.setModelUsername((String)username);
            if (context.getEmail() != null && !this.realm.isDuplicateEmailsAllowed() && (existingUser = this.session.users().getUserByEmail(this.realm, context.getEmail())) != null) {
                this.event.error("federated_identity_account_exists");
                throw new CorsErrorResponseException(this.cors, "invalid_token", "User already exists", Response.Status.BAD_REQUEST);
            }
            existingUser = this.session.users().getUserByUsername(this.realm, (String)username);
            if (existingUser != null) {
                this.event.error("federated_identity_account_exists");
                throw new CorsErrorResponseException(this.cors, "invalid_token", "User already exists", Response.Status.BAD_REQUEST);
            }
            if (context.getIdpConfig().isTransientUsers()) {
                String authSessionId = context.getAuthenticationSession() != null && context.getAuthenticationSession().getParentSession() != null ? context.getAuthenticationSession().getParentSession().getId() : null;
                user = new LightweightUserAdapter(this.session, this.realm, authSessionId);
            } else {
                user = this.session.users().addUser(this.realm, (String)username);
            }
            user.setEnabled(true);
            user.setEmail(context.getEmail());
            user.setFirstName(context.getFirstName());
            user.setLastName(context.getLastName());
            if (!context.getIdpConfig().isTransientUsers()) {
                FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(context.getIdpConfig().getAlias(), context.getId(), context.getModelUsername(), context.getToken());
                this.session.users().addFederatedIdentity(this.realm, user, federatedIdentityModel);
            }
            context.getIdp().importNewUser(this.session, this.realm, user, context);
            for (IdentityProviderMapperModel mapper : mappers) {
                IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                target.importNewUser(this.session, this.realm, user, mapper, context);
            }
            if (context.getIdpConfig().isTrustEmail() && !Validation.isBlank(user.getEmail())) {
                logger.debugf("Email verified automatically after registration of user '%s' through Identity provider '%s' ", (Object)user.getUsername(), (Object)context.getIdpConfig().getAlias());
                user.setEmailVerified(true);
            }
            this.event.clone().event(EventType.REGISTER).user(user.getId()).detail("register_method", "token-exchange").detail("email", user.getEmail()).detail("identity_provider", providerId).success();
        } else {
            if (!user.isEnabled()) {
                this.event.error("user_disabled");
                throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid Token", Response.Status.BAD_REQUEST);
            }
            String bruteForceError = AuthenticatorUtils.getDisabledByBruteForceEventError((BruteForceProtector)this.session.getProvider(BruteForceProtector.class), this.session, this.realm, user);
            if (bruteForceError != null) {
                this.event.error(bruteForceError);
                throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid Token", Response.Status.BAD_REQUEST);
            }
            context.getIdp().updateBrokeredUser(this.session, this.realm, user, context);
            for (IdentityProviderMapperModel mapper : mappers) {
                IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                IdentityProviderMapperSyncModeDelegate.delegateUpdateBrokeredUser((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user, (IdentityProviderMapperModel)mapper, (BrokeredIdentityContext)context, (IdentityProviderMapper)target);
            }
        }
        for (Map.Entry attr : context.getAttributes().entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
            if ("username".equalsIgnoreCase((String)attr.getKey())) continue;
            user.setAttribute((String)attr.getKey(), (List)attr.getValue());
        }
        return user;
    }

    protected void updateUserSessionFromClientAuth(UserSessionModel userSession) {
        for (Map.Entry<String, String> attr : this.clientAuthAttributes.entrySet()) {
            userSession.setNote(attr.getKey(), attr.getValue());
        }
    }

    protected ExternalExchangeContext locateExchangeExternalTokenByAlias(String alias) {
        try {
            IdentityProvider<?> idp = IdentityBrokerService.getIdentityProvider(this.session, alias);
            if (idp instanceof ExchangeExternalToken) {
                ExchangeExternalToken external = (ExchangeExternalToken)idp;
                IdentityProviderModel model = this.session.identityProviders().getByAlias(alias);
                return new ExternalExchangeContext(external, model);
            }
        }
        catch (IdentityBrokerException identityBrokerException) {
            // empty catch block
        }
        return this.session.identityProviders().getAllStream().map(idpModel -> {
            ExchangeExternalToken external;
            IdentityProvider<?> idp = IdentityBrokerService.getIdentityProvider(this.session, idpModel.getAlias());
            if (idp instanceof ExchangeExternalToken && (external = (ExchangeExternalToken)idp).isIssuer(alias, this.formParams)) {
                return new ExternalExchangeContext(external, (IdentityProviderModel)idpModel);
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    protected record ExternalExchangeContext(ExchangeExternalToken provider, IdentityProviderModel idpModel) {
    }
}

