/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.security.AccessController;
import java.util.EnumMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;

public class JBossLoggerFinder
extends System.LoggerFinder {
    private static final Map<System.Logger.Level, java.util.logging.Level> LEVELS = new EnumMap<System.Logger.Level, java.util.logging.Level>(System.Logger.Level.class);
    private static final AtomicBoolean LOGGED = new AtomicBoolean(false);
    private static volatile boolean PROPERTY_SET = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public System.Logger getLogger(String name, Module module) {
        Logger logger;
        if (!PROPERTY_SET) {
            JBossLoggerFinder jBossLoggerFinder = this;
            synchronized (jBossLoggerFinder) {
                if (!PROPERTY_SET) {
                    if (System.getSecurityManager() == null) {
                        if (System.getProperty("java.util.logging.manager") == null) {
                            System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
                        }
                    } else {
                        AccessController.doPrivileged(() -> {
                            if (System.getProperty("java.util.logging.manager") == null) {
                                System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
                            }
                            return null;
                        });
                    }
                }
                PROPERTY_SET = true;
            }
        }
        if (!(logger = Logger.getLogger(name)).getClass().getName().equals("org.jboss.logmanager.Logger") && LOGGED.compareAndSet(false, true)) {
            logger.log((java.util.logging.Level)Level.ERROR, "The LogManager accessed before the \"java.util.logging.manager\" system property was set to \"org.jboss.logmanager.LogManager\". Results may be unexpected.");
        }
        return new JBossSystemLogger(logger);
    }

    static {
        LEVELS.put(System.Logger.Level.ALL, Level.ALL);
        LEVELS.put(System.Logger.Level.TRACE, Level.TRACE);
        LEVELS.put(System.Logger.Level.DEBUG, Level.DEBUG);
        LEVELS.put(System.Logger.Level.INFO, Level.INFO);
        LEVELS.put(System.Logger.Level.WARNING, Level.WARN);
        LEVELS.put(System.Logger.Level.ERROR, Level.ERROR);
        LEVELS.put(System.Logger.Level.OFF, Level.OFF);
    }

    private static class JBossSystemLogger
    implements System.Logger {
        private static final String LOGGER_CLASS_NAME = JBossSystemLogger.class.getName();
        private final Logger delegate;

        private JBossSystemLogger(Logger delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public boolean isLoggable(System.Logger.Level level) {
            return this.delegate.isLoggable(LEVELS.getOrDefault((Object)level, java.util.logging.Level.INFO));
        }

        @Override
        public void log(System.Logger.Level level, String msg) {
            this.log(level, null, msg, (Object[])null);
        }

        @Override
        public void log(System.Logger.Level level, Supplier<String> msgSupplier) {
            if (this.isLoggable(level)) {
                this.log(level, null, msgSupplier.get(), (Object[])null);
            }
        }

        @Override
        public void log(System.Logger.Level level, Object obj) {
            if (this.isLoggable(level)) {
                this.log(level, null, obj.toString(), (Object[])null);
            }
        }

        @Override
        public void log(System.Logger.Level level, String msg, Throwable thrown) {
            this.log(level, null, msg, thrown);
        }

        @Override
        public void log(System.Logger.Level level, Supplier<String> msgSupplier, Throwable thrown) {
            if (this.isLoggable(level)) {
                this.log(level, null, msgSupplier.get(), thrown);
            }
        }

        @Override
        public void log(System.Logger.Level level, String format, Object ... params) {
            this.log(level, null, format, params);
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
            ExtLogRecord record = new ExtLogRecord(LEVELS.getOrDefault((Object)level, java.util.logging.Level.INFO), msg, LOGGER_CLASS_NAME);
            record.setThrown(thrown);
            record.setResourceBundle(bundle);
            this.delegate.log(record);
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
            ExtLogRecord record = new ExtLogRecord(LEVELS.getOrDefault((Object)level, java.util.logging.Level.INFO), format, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, LOGGER_CLASS_NAME);
            record.setParameters(params);
            record.setResourceBundle(bundle);
            this.delegate.log(record);
        }
    }
}

