/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.def;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreement;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.agreement.kdf.ConcatenationKDFGenerator;
import org.bouncycastle.crypto.engines.AESWrapEngine;
import org.bouncycastle.crypto.params.KDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.keycloak.common.util.Base64Url;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jwe.JWEKeyStorage;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import org.keycloak.jose.jwk.ECPublicJWK;
import org.keycloak.jose.jwk.JWKUtil;

public class BCEcdhEsAlgorithmProvider
implements JWEAlgorithmProvider {
    public byte[] decodeCek(byte[] encodedCek, Key encryptionKey, JWEHeader header, JWEEncryptionProvider encryptionProvider) throws Exception {
        int keyDataLength = BCEcdhEsAlgorithmProvider.getKeyDataLength(header.getAlgorithm(), encryptionProvider);
        PublicKey sharedPublicKey = BCEcdhEsAlgorithmProvider.toPublicKey(header.getEphemeralPublicKey());
        String algorithmID = BCEcdhEsAlgorithmProvider.getAlgorithmID(header.getAlgorithm(), header.getEncryptionAlgorithm());
        byte[] derivedKey = BCEcdhEsAlgorithmProvider.deriveKey(sharedPublicKey, encryptionKey, keyDataLength, algorithmID, this.base64UrlDecode(header.getAgreementPartyUInfo()), this.base64UrlDecode(header.getAgreementPartyVInfo()));
        if ("ECDH-ES".equals(header.getAlgorithm())) {
            return derivedKey;
        }
        AESWrapEngine encrypter = new AESWrapEngine();
        encrypter.init(false, (CipherParameters)new KeyParameter(derivedKey));
        return encrypter.unwrap(encodedCek, 0, encodedCek.length);
    }

    public byte[] encodeCek(JWEEncryptionProvider encryptionProvider, JWEKeyStorage keyStorage, Key encryptionKey, JWEHeader.JWEHeaderBuilder headerBuilder) throws Exception {
        JWEHeader header = headerBuilder.build();
        int keyDataLength = BCEcdhEsAlgorithmProvider.getKeyDataLength(header.getAlgorithm(), encryptionProvider);
        ECParameterSpec params = ((ECPublicKey)encryptionKey).getParams();
        KeyPair ephemeralKeyPair = BCEcdhEsAlgorithmProvider.generateEcKeyPair(params);
        ECPublicKey ephemeralPublicKey = (ECPublicKey)ephemeralKeyPair.getPublic();
        ECPrivateKey ephemeralPrivateKey = (ECPrivateKey)ephemeralKeyPair.getPrivate();
        byte[] agreementPartyUInfo = header.getAgreementPartyUInfo() != null ? this.base64UrlDecode(header.getAgreementPartyUInfo()) : new byte[]{};
        byte[] agreementPartyVInfo = header.getAgreementPartyVInfo() != null ? this.base64UrlDecode(header.getAgreementPartyVInfo()) : new byte[]{};
        headerBuilder.ephemeralPublicKey(BCEcdhEsAlgorithmProvider.toECPublicJWK(ephemeralPublicKey));
        String algorithmID = BCEcdhEsAlgorithmProvider.getAlgorithmID(header.getAlgorithm(), header.getEncryptionAlgorithm());
        byte[] derivedKey = BCEcdhEsAlgorithmProvider.deriveKey(encryptionKey, ephemeralPrivateKey, keyDataLength, algorithmID, agreementPartyUInfo, agreementPartyVInfo);
        if ("ECDH-ES".equals(header.getAlgorithm())) {
            keyStorage.setCEKBytes(derivedKey);
            encryptionProvider.deserializeCEK(keyStorage);
            return new byte[0];
        }
        AESWrapEngine encrypter = new AESWrapEngine();
        encrypter.init(true, (CipherParameters)new KeyParameter(derivedKey));
        byte[] cekBytes = keyStorage.getCekBytes();
        return encrypter.wrap(cekBytes, 0, cekBytes.length);
    }

    private byte[] base64UrlDecode(String encoded) {
        return Base64Url.decode((String)(encoded == null ? "" : encoded));
    }

    private static KeyPair generateEcKeyPair(ECParameterSpec params) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC");
            SecureRandom randomGen = SecureRandom.getInstance("SHA1PRNG");
            keyGen.initialize(params, randomGen);
            return keyGen.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] deriveOtherInfo(int keyDataLength, String algorithmID, byte[] agreementPartyUInfo, byte[] agreementPartyVInfo) {
        byte[] algorithmId = BCEcdhEsAlgorithmProvider.encodeDataLengthData(algorithmID.getBytes(Charset.forName("ASCII")));
        byte[] partyUInfo = BCEcdhEsAlgorithmProvider.encodeDataLengthData(agreementPartyUInfo);
        byte[] partyVInfo = BCEcdhEsAlgorithmProvider.encodeDataLengthData(agreementPartyVInfo);
        byte[] suppPubInfo = BCEcdhEsAlgorithmProvider.toByteArray(keyDataLength);
        byte[] suppPrivInfo = BCEcdhEsAlgorithmProvider.emptyBytes();
        return BCEcdhEsAlgorithmProvider.concat(algorithmId, partyUInfo, partyVInfo, suppPubInfo, suppPrivInfo);
    }

    public static byte[] deriveKey(Key publicKey, Key privateKey, int keyDataLength, String algorithmID, byte[] agreementPartyUInfo, byte[] agreementPartyVInfo) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException {
        byte[] z = BCEcdhEsAlgorithmProvider.deriveSharedSecret(publicKey, privateKey);
        byte[] otherInfo = BCEcdhEsAlgorithmProvider.deriveOtherInfo(keyDataLength, algorithmID, agreementPartyUInfo, agreementPartyVInfo);
        KDFParameters param = new KDFParameters(z, otherInfo);
        ConcatenationKDFGenerator concatKdf = new ConcatenationKDFGenerator(DigestFactory.createSHA256());
        concatKdf.init((DerivationParameters)param);
        int derivedKeyLength = keyDataLength / 8;
        byte[] derivedKeyBytes = new byte[derivedKeyLength];
        concatKdf.generateBytes(derivedKeyBytes, 0, derivedKeyLength);
        return derivedKeyBytes;
    }

    private static ECPublicJWK toECPublicJWK(ECPublicKey ecKey) {
        ECPublicJWK k = new ECPublicJWK();
        int fieldSize = ecKey.getParams().getCurve().getField().getFieldSize();
        k.setCrv("P-" + fieldSize);
        k.setKeyType("EC");
        k.setX(Base64Url.encode((byte[])JWKUtil.toIntegerBytes((BigInteger)ecKey.getW().getAffineX(), (int)fieldSize)));
        k.setY(Base64Url.encode((byte[])JWKUtil.toIntegerBytes((BigInteger)ecKey.getW().getAffineY(), (int)fieldSize)));
        return k;
    }

    private static PublicKey toPublicKey(ECPublicJWK jwk) {
        String crv = jwk.getCrv();
        String xStr = jwk.getX();
        String yStr = jwk.getY();
        if (crv == null) {
            throw new IllegalArgumentException("JWK crv must be set");
        }
        if (xStr == null) {
            throw new IllegalArgumentException("JWK x must be set");
        }
        if (yStr == null) {
            throw new IllegalArgumentException("JWK y must be set");
        }
        BigInteger x = new BigInteger(1, Base64Url.decode((String)xStr));
        BigInteger y = new BigInteger(1, Base64Url.decode((String)yStr));
        String name = BCEcdhEsAlgorithmProvider.nistToSecCurveName(crv);
        try {
            ECPoint point = new ECPoint(x, y);
            ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)name);
            ECNamedCurveSpec params = new ECNamedCurveSpec(name, spec.getCurve(), spec.getG(), spec.getN());
            ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(point, (ECParameterSpec)params);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return keyFactory.generatePublic(pubKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] deriveSharedSecret(Key publicKey, Key privateKey) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException {
        KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, true);
        return keyAgreement.generateSecret();
    }

    private static String getAlgorithmID(String alg, String enc) {
        if ("ECDH-ES+A128KW".equals(alg) || "ECDH-ES+A192KW".equals(alg) || "ECDH-ES+A256KW".equals(alg)) {
            return alg;
        }
        if ("ECDH-ES".equals(alg)) {
            return enc;
        }
        throw new IllegalArgumentException("Unsupported algorithm");
    }

    private static String nistToSecCurveName(String nistCurveName) {
        switch (nistCurveName) {
            case "P-256": {
                return "secp256r1";
            }
            case "P-384": {
                return "secp384r1";
            }
            case "P-521": {
                return "secp521r1";
            }
        }
        throw new IllegalArgumentException("Unsupported curve");
    }

    private static int getKeyDataLength(String alg, JWEEncryptionProvider encryptionProvider) {
        if ("ECDH-ES+A128KW".equals(alg)) {
            return 128;
        }
        if ("ECDH-ES+A192KW".equals(alg)) {
            return 192;
        }
        if ("ECDH-ES+A256KW".equals(alg)) {
            return 256;
        }
        if ("ECDH-ES".equals(alg)) {
            return encryptionProvider.getExpectedCEKLength() * 8;
        }
        throw new IllegalArgumentException("Unsupported algorithm");
    }

    private static byte[] encodeDataLengthData(byte[] data) {
        byte[] databytes = data != null ? data : new byte[]{};
        byte[] datalen = BCEcdhEsAlgorithmProvider.toByteArray(databytes.length);
        return BCEcdhEsAlgorithmProvider.concat(datalen, databytes);
    }

    private static byte[] emptyBytes() {
        return new byte[0];
    }

    private static byte[] toByteArray(int intValue) {
        return new byte[]{(byte)(intValue >> 24), (byte)(intValue >> 16), (byte)(intValue >> 8), (byte)intValue};
    }

    private static byte[] concat(byte[] ... byteArrays) {
        byte[] throwable;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            for (byte[] bytes : byteArrays) {
                if (bytes == null) continue;
                baos.write(bytes);
            }
            throwable = baos.toByteArray();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        baos.close();
        return throwable;
    }
}

