/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.spi;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.model.Extensions;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public abstract class AbstractAnnotationScanner
implements AnnotationScanner {
    private static final String EMPTY = "";
    private static final Set<DotName> PRIMITIVE_OBJECTS = new HashSet<DotName>();
    private static final Set<DotName> STREAM_OBJECTS = new HashSet<DotName>();
    protected AnnotationScannerContext context;
    protected String currentAppPath = "";
    private String contextRoot = "";

    @Override
    public void setContextRoot(String path) {
        this.contextRoot = path;
    }

    protected List<String> makePaths(List<String> operationPaths) {
        return operationPaths.stream().map(operationPath -> AbstractAnnotationScanner.createPathFromSegments(this.contextRoot, this.currentAppPath, operationPath)).collect(Collectors.toList());
    }

    protected String makePath(String operationPath) {
        return AbstractAnnotationScanner.createPathFromSegments(this.contextRoot, this.currentAppPath, operationPath);
    }

    protected static String createPathFromSegments(String ... segments) {
        StringBuilder builder = new StringBuilder();
        for (String segment : segments) {
            if (segment.startsWith("/")) {
                segment = segment.substring(1);
            }
            if (segment.endsWith("/")) {
                segment = segment.substring(0, segment.length() - 1);
            }
            if (segment.isEmpty()) continue;
            builder.append("/");
            builder.append(segment);
        }
        String rval = builder.toString();
        if (rval.isEmpty()) {
            return "/";
        }
        return rval;
    }

    protected static boolean processProfiles(OpenApiConfig config, Extensible<?> extensible) {
        Set profiles = Extensions.getProfiles(extensible);
        Extensions.removeProfiles(extensible);
        return AbstractAnnotationScanner.profileIncluded(config, profiles);
    }

    private static boolean profileIncluded(OpenApiConfig config, Set<String> profiles) {
        if (!config.getScanExcludeProfiles().isEmpty()) {
            return config.getScanExcludeProfiles().stream().noneMatch(profiles::contains);
        }
        if (config.getScanProfiles().isEmpty()) {
            return true;
        }
        return config.getScanProfiles().stream().anyMatch(profiles::contains);
    }

    @Override
    public String[] getDefaultConsumes(AnnotationScannerContext context, MethodInfo methodInfo, ResourceParameters params) {
        Type requestBodyType = this.getRequestBodyParameterClassType(context, methodInfo, params);
        if (requestBodyType != null) {
            if (this.isStreaming(requestBodyType)) {
                return context.getConfig().getDefaultStreamingConsumes().orElseGet(ContentIO::defaultMediaTypes);
            }
            if (this.isPrimimive(requestBodyType)) {
                return context.getConfig().getDefaultPrimitivesConsumes().orElseGet(ContentIO::defaultMediaTypes);
            }
            return context.getConfig().getDefaultConsumes().orElseGet(ContentIO::defaultMediaTypes);
        }
        return new String[0];
    }

    @Override
    public String[] getDefaultProduces(AnnotationScannerContext context, MethodInfo methodInfo) {
        if (this.isStreaming(methodInfo.returnType())) {
            return context.getConfig().getDefaultStreamingProduces().orElseGet(ContentIO::defaultMediaTypes);
        }
        if (this.isPrimimive(methodInfo.returnType())) {
            return context.getConfig().getDefaultPrimitivesProduces().orElseGet(ContentIO::defaultMediaTypes);
        }
        return context.getConfig().getDefaultProduces().orElseGet(ContentIO::defaultMediaTypes);
    }

    private boolean isPrimimive(Type type) {
        if (type != null) {
            return type.kind().equals((Object)Type.Kind.PRIMITIVE) || PRIMITIVE_OBJECTS.contains(type.name()) || this.isWrapperType(type) && this.isPrimimive(this.unwrapType(type)) || TypeUtil.isWrappedType(type) && this.isPrimimive(TypeUtil.unwrapType(type));
        }
        return false;
    }

    private boolean isStreaming(Type type) {
        if (type != null) {
            return type.kind().equals((Object)Type.Kind.PRIMITIVE) && type.name().equals((Object)DotName.createSimple(Byte.TYPE)) || STREAM_OBJECTS.contains(type.name()) || this.isWrapperType(type) && this.isStreaming(this.unwrapType(type)) || TypeUtil.isWrappedType(type) && this.isStreaming(TypeUtil.unwrapType(type));
        }
        return false;
    }

    static {
        PRIMITIVE_OBJECTS.add(DotName.createSimple(String.class));
        PRIMITIVE_OBJECTS.add(DotName.createSimple(Integer.class));
        PRIMITIVE_OBJECTS.add(DotName.createSimple(Short.class));
        PRIMITIVE_OBJECTS.add(DotName.createSimple(Long.class));
        PRIMITIVE_OBJECTS.add(DotName.createSimple(Float.class));
        PRIMITIVE_OBJECTS.add(DotName.createSimple(Double.class));
        PRIMITIVE_OBJECTS.add(DotName.createSimple(Boolean.class));
        PRIMITIVE_OBJECTS.add(DotName.createSimple(Character.class));
        PRIMITIVE_OBJECTS.add(DotName.createSimple(BigDecimal.class));
        PRIMITIVE_OBJECTS.add(DotName.createSimple(BigInteger.class));
        STREAM_OBJECTS.add(DotName.createSimple(File.class));
        STREAM_OBJECTS.add(DotName.createSimple(Path.class));
        STREAM_OBJECTS.add(DotName.createSimple(InputStream.class));
        STREAM_OBJECTS.add(DotName.createSimple(Reader.class));
        STREAM_OBJECTS.add(DotName.createSimple(Byte.class));
        STREAM_OBJECTS.add(DotName.createSimple(byte[].class));
        STREAM_OBJECTS.add(DotName.createSimple((String)"io.vertx.core.file.AsyncFile"));
        STREAM_OBJECTS.add(DotName.createSimple((String)"io.vertx.core.buffer.Buffer"));
    }
}

