/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.ExponentialHistogramBucketsMarshaler;
import io.opentelemetry.proto.metrics.v1.internal.ExponentialHistogramDataPoint;
import io.opentelemetry.sdk.internal.DynamicPrimitiveLongList;
import io.opentelemetry.sdk.internal.PrimitiveLongList;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import java.io.IOException;
import java.util.List;

final class ExponentialHistogramBucketsStatelessMarshaler
implements StatelessMarshaler<ExponentialHistogramBuckets> {
    static final ExponentialHistogramBucketsStatelessMarshaler INSTANCE = new ExponentialHistogramBucketsStatelessMarshaler();

    private ExponentialHistogramBucketsStatelessMarshaler() {
    }

    public void writeTo(Serializer output, ExponentialHistogramBuckets buckets, MarshalerContext context) throws IOException {
        output.serializeSInt32(ExponentialHistogramDataPoint.Buckets.OFFSET, buckets.getOffset());
        List counts = buckets.getBucketCounts();
        if (counts instanceof DynamicPrimitiveLongList) {
            output.serializeRepeatedUInt64(ExponentialHistogramDataPoint.Buckets.BUCKET_COUNTS, (DynamicPrimitiveLongList)counts);
        } else {
            output.serializeRepeatedUInt64(ExponentialHistogramDataPoint.Buckets.BUCKET_COUNTS, PrimitiveLongList.toArray((List)counts));
        }
    }

    public int getBinarySerializedSize(ExponentialHistogramBuckets buckets, MarshalerContext context) {
        return ExponentialHistogramBucketsMarshaler.calculateSize(buckets.getOffset(), buckets.getBucketCounts());
    }
}

