/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class BoostingQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, BoostingQuery> {
    @Nonnull
    private final Query negative;
    private final float negativeBoost;
    @Nonnull
    private final Query positive;
    public static final JsonpDeserializer<BoostingQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BoostingQuery::setupBoostingQueryDeserializer);

    private BoostingQuery(Builder builder) {
        super(builder);
        this.negative = ApiTypeHelper.requireNonNull(builder.negative, this, "negative");
        this.negativeBoost = ApiTypeHelper.requireNonNull(builder.negativeBoost, this, "negativeBoost").floatValue();
        this.positive = ApiTypeHelper.requireNonNull(builder.positive, this, "positive");
    }

    public static BoostingQuery of(Function<Builder, ObjectBuilder<BoostingQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Boosting;
    }

    @Nonnull
    public final Query negative() {
        return this.negative;
    }

    public final float negativeBoost() {
        return this.negativeBoost;
    }

    @Nonnull
    public final Query positive() {
        return this.positive;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("negative");
        this.negative.serialize(generator, mapper);
        generator.writeKey("negative_boost");
        generator.write((double)this.negativeBoost);
        generator.writeKey("positive");
        this.positive.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupBoostingQueryDeserializer(ObjectDeserializer<Builder> op) {
        BoostingQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::negative, Query._DESERIALIZER, "negative");
        op.add(Builder::negativeBoost, JsonpDeserializer.floatDeserializer(), "negative_boost");
        op.add(Builder::positive, Query._DESERIALIZER, "positive");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.negative.hashCode();
        result = 31 * result + Float.hashCode(this.negativeBoost);
        result = 31 * result + this.positive.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoostingQuery other = (BoostingQuery)o;
        return this.negative.equals(other.negative) && this.negativeBoost == other.negativeBoost && this.positive.equals(other.positive);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, BoostingQuery> {
        private Query negative;
        private Float negativeBoost;
        private Query positive;

        public Builder() {
        }

        private Builder(BoostingQuery o) {
            super(o);
            this.negative = o.negative;
            this.negativeBoost = Float.valueOf(o.negativeBoost);
            this.positive = o.positive;
        }

        private Builder(Builder o) {
            super(o);
            this.negative = o.negative;
            this.negativeBoost = o.negativeBoost;
            this.positive = o.positive;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder negative(Query value) {
            this.negative = value;
            return this;
        }

        @Nonnull
        public final Builder negative(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.negative(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder negativeBoost(float value) {
            this.negativeBoost = Float.valueOf(value);
            return this;
        }

        @Nonnull
        public final Builder positive(Query value) {
            this.positive = value;
            return this;
        }

        @Nonnull
        public final Builder positive(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.positive(fn.apply(new Query.Builder()).build());
        }

        @Override
        @Nonnull
        public BoostingQuery build() {
            this._checkSingleUse();
            return new BoostingQuery(this);
        }
    }
}

